#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
void Platoons_initialize() {
	int i;
	for(i = 0; i < PLATOON_MAX; i++) {
		platoons.status[i]	= 0;
	}
}
/*--------------------------------------------------------------------------*/
void Platoons_set(int y, int type) {
	int i;
	for(i = 0; i < PLATOON_MAX; i++) {
		if(!Platoons_inUse(i)) {
			platoons.spawnYs[i]	= y;
			platoons.types[  i]	= type;
			platoons.timers[ i]	= 0;
			platoons.status[ i]	= PLATOON_USING_MASK;
			return;
		}
	}
}
/*--------------------------------------------------------------------------*/
void Platoons_spawn() {
	static const int INTERVALS[]={10,16,16};
	int i;
	for(i = 0; i < PLATOON_MAX; i++) {
		if(!Platoons_inUse(i)) { continue; }
		if(!(platoons.timers[i] % INTERVALS[platoons.types[i]]) &&
		    (platoons.timers[i] < (PLATOON_CONSISTS * INTERVALS[platoons.types[i]]))) {	//limitation PLATOON_CONSISTS
			int isOdd, spawnType, y;
			//type
			isOdd = platoons.timers[i] / INTERVALS[platoons.types[i]] % 2;	//0123 -> 1234
			if(platoons.types[i] == PLATOON_ZIG_FILE) {
				spawnType = isOdd ? SENEMY_ZIG_FIRE : SENEMY_ZIG_NOFIRE;
			} else {
				spawnType = isOdd ? SENEMY_TRI_FIRE : SENEMY_TRI_NOFIRE;
			}
			//y
			y = platoons.spawnYs[i];
			if(platoons.types[i] == PLATOON_TRI_SHOAL) {
				y += random(0, 20) - 10;
			}
			//spawn
			if(GameLevel_spawnSmallEnemy(y, (i << 4) | spawnType)) {
				platoons.status[i] = 0;	//reset platoon
			}
		}
		if(platoons.timers[i] < 255) {
			platoons.timers[i]++;
		}
	}
}
/*--------------------------------------------------------------------------*/
int Platoons_checkBonus(int idx, int killed) {
	if(!Platoons_inUse(idx)) { return 0; }
	//count
	platoons.status[idx]++;
	if(killed) { platoons.status[idx] += (1 << 3); }
	//check
	if((platoons.status[idx] & PLATOON_COUNT_MASK) >= PLATOON_CONSISTS) {
		if(((platoons.status[idx] >> 3) & PLATOON_COUNT_MASK) >= PLATOON_CONSISTS) {
			platoons.status[idx] = 0;
			return 1;
		}
		platoons.status[idx] = 0;
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
int Platoons_inUse(int idx) {
	return !!(platoons.status[idx] & PLATOON_USING_MASK);
}
