#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
void Particle_activate(Particle* particle, int x, int y) {
	particle->x	= x;
	particle->y	= y;
}
/*--------------------------------------------------------------------------*/
void Particle_move(Particle* particle) {
	particle->limit--;
	if(particle->limit <= 0) {
		Particle_inactivate(particle);
	}
}
/*--------------------------------------------------------------------------*/
void Particle_draw(Particle* particle) {
	switch(particle->type) {
	case 0:
		{
			if(particle->limit > 8) {
				GameCore_drawBitmap(
					particle->x,
					particle->y,
					SPR_EXPLOSION0,
					2);
			} else if(particle->limit > 4) {
				GameCore_drawBitmap(
					particle->x,
					particle->y,
					SPR_EXPLOSION1,
					2);
			} else {
				GameCore_drawBitmap(
					particle->x,
					particle->y,
					SPR_EXPLOSION2,
					2);
			}
		}
		break;
	default:
		{
			GameCore_drawBitmap(
				particle->x,
				particle->y,
				SPR_TEN,
				2);
		}
		break;
	}
}
/*--------------------------------------------------------------------------*/
void Particle_inactivate(Particle* particle) {
	particle->x = EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int Particle_exist(Particle* particle) {
	return particle->x > EXIST_THRESHOLD;
}
