#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define BACKSPACE		37
#define ENTER_KEY		39
/*--------------------------------------------------------------------------*/
#define COLUMN			10
#define ROW			4
/****************************************************************************
 *	[J֐
 ****************************************************************************/
static void NameEntry_entryChar(int c) {
	if(nameEntry.nameCursor >= RANKING_NAME_LEN) { nameEntry.nameCursor--; }	//3͌ɕ͂ꂽꍇ3ڂ㏑鎖ɂB
	nameEntry.name[nameEntry.nameCursor] = c;
	nameEntry.nameCursor++;
	if(nameEntry.nameCursor >= RANKING_NAME_LEN) { nameEntry.kbCursor = ENTER_KEY; }
	GameCore_tone(880, 100);
}
/*--------------------------------------------------------------------------*/
static void NameEntry_backspace() {
	if(nameEntry.nameCursor) { nameEntry.nameCursor--; }
	nameEntry.name[nameEntry.nameCursor] = ' ';
	GameCore_tone(220, 100);
}
/****************************************************************************
 *	
 ****************************************************************************/
void NameEntry_initialize() {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
void NameEntry_onEntry(int rank, int score) {
	memset(nameEntry.name, ' ', sizeof nameEntry.name);
	nameEntry.nameCursor	= 0;
	nameEntry.kbCursor	= 10;
	nameEntry.rank		= rank;
	nameEntry.score		= score;
	nameEntry.exitCount	= -1;
	nameEntry.waitTimer	= SCENE_ENTRY_WAIT;	//for disabling input for a while
}
/*--------------------------------------------------------------------------*/
int NameEntry_loop() {
	int i;
	if(nameEntry.exitCount < 0) {
		//move cursor
		if(joy & TRG_UP) {
			if((nameEntry.kbCursor / COLUMN) == 0) {
				nameEntry.kbCursor += COLUMN * (ROW - 1);
			} else {
				nameEntry.kbCursor -= COLUMN;
			}
		}
		if(joy & TRG_DN) {
			if((nameEntry.kbCursor / COLUMN) == (ROW - 1)) {
				nameEntry.kbCursor -= COLUMN * (ROW - 1);
			} else {
				nameEntry.kbCursor += COLUMN;
			}
		}
		if(joy & TRG_LF) {
			if((nameEntry.kbCursor % COLUMN) == 0) {
				nameEntry.kbCursor += COLUMN - 1;
			} else {
				nameEntry.kbCursor -= 1;
			}
		}
		if(joy & TRG_RI) {
			if((nameEntry.kbCursor % COLUMN) == (COLUMN - 1)) {
				nameEntry.kbCursor -= COLUMN - 1;
			} else {
				nameEntry.kbCursor += 1;
			}
		}
		//entry character
		if((joy & TRG_A) && !nameEntry.waitTimer) {
			if(nameEntry.kbCursor < 36) {
				NameEntry_entryChar((nameEntry.kbCursor < 10) ? (nameEntry.kbCursor + '0') : (nameEntry.kbCursor + ('A' - 10)));
			} else if(nameEntry.kbCursor == BACKSPACE) {
				NameEntry_backspace();
			} else if(nameEntry.kbCursor == ENTER_KEY) {
				nameEntry.exitCount = 0;
				GameCore_tone(880, 1000);
			} else {
				NameEntry_entryChar(' ');
			}
		}
		//b button BS
		if(joy & TRG_B) {
			NameEntry_backspace();
		}
	}
	//=== draw ===
	//keyboard
	{
#define W	10
#define H	12
#define BX	((SCREEN_WIDTH-(W*(COLUMN-1)+6))/2)
#define BY	(20-1)
		//number
		for(i = 0; i < 10; i++) {
			GameCore_setCursor(
				i * W + BX,
				BY);
			GameCore_print("%c", '0' + i);
		}
		//alphabet
		for(i = 0; i < 26; i++) {
			GameCore_setCursor(
				(i % COLUMN * W)     + BX,
				(i / COLUMN + 1) * H + BY);
			GameCore_print("%c", 'A' + i);
		}
		//backspace
		GameCore_setCursor(
			7 * W + BX - 2,
			3 * H + BY);
		GameCore_print("");
		//enter
		GameCore_drawBitmap(9 * W + BX, 3 * H + BY, SPR_OK, 1);
		//cursor
		if(nameEntry.exitCount < 0) {
			GameCore_drawCircle(
				(nameEntry.kbCursor % COLUMN) * W + BX + 2,
				(nameEntry.kbCursor / COLUMN) * H + BY + 3,
				5,
				1);
		}
#undef  W
#undef  H
#undef  BX
#undef  BY
	}
	//entry
	{
#define BY	(5-1)
#define NX	42
#define NW	8
		//rank
		GameCore_setCursor(
			24,
			BY);
		GameCore_print("%c", '1' + nameEntry.rank);
		//name
		for(i = 0; i < RANKING_NAME_LEN; i++) {
			if((nameEntry.exitCount < 0) || !(GameCore_frameCount() / 30 % 2)) {
				GameCore_setCursor(
					i * NW + NX,
					BY);
				GameCore_print("%c", nameEntry.name[i]);
			}
			//underline
			if(i != nameEntry.nameCursor || !(GameCore_frameCount() / 30 % 2)) {
				GameCore_fillRect(
					i * NW + NX,
					BY + 8,
					5,
					1,
					1);
			}
		}
		//score
		GameCore_setCursor(
			76,
			BY);
		GameCore_print("%05d", nameEntry.score);
#undef  BY
#undef  NX
#undef  NW
	}
	if(nameEntry.waitTimer) { nameEntry.waitTimer--; }
	//exit
	if(nameEntry.exitCount >=   0) { nameEntry.exitCount++; }
	if(nameEntry.exitCount >= 150) { return 1; }
	return 0;
}
/*--------------------------------------------------------------------------*/
int NameEntry_getScore() {
	return nameEntry.score;
}
/*--------------------------------------------------------------------------*/
const char* NameEntry_getName() {
	return nameEntry.name;
}
