#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define WAVES_IN_ZONE			6
#define DIFFICULTY_CAP			100
/*--------------------------------------------------------------------------*/
#define ZONE_DISP_FRAMES		90
#define DIFFICULTY_INCR			20
#define DIFFICULTY_DECR			10
/****************************************************************************
 *	Enemy spawn scripts
 ****************************************************************************/
#define INST_SPAWN_MASK			BIN8(10000000)
#define INST_TYPE_MASK			BIN8(01111111)
#define INST_RAND_MASK			BIN8(11000000)
#define INST_Y_MASK			BIN8(00111111)
//
#define INST_RAND_WIDE			BIN8(11000000)
#define INST_RAND_NARROW		BIN8(10000000)
#define INST_RAND_NONE			BIN8(01000000)
#define INST_RAND_ERROR			BIN8(00000000)
//
#define INST_END_WAVE			BIN8(00000000)
#define INST_SPAWN(type,rand,y)		(INST_SPAWN_MASK|(type)),((rand)|((y)&INST_Y_MASK))
#define INST_DELAY(frame)		(((frame)>INST_TYPE_MASK)?INST_TYPE_MASK:(frame))
/*--------------------------------------------------------------------------*/
static const uint8_t waveEmpty[]={
	INST_DELAY(127),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveBeginner0[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,38),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveBeginner1[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,46),
	INST_DELAY(40),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,12),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveRandomShoal[]={
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_WIDE,0),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveRandomLines[]={
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_WIDE,0),
	INST_DELAY(127),
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_WIDE,0),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveZigTop[]={
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NARROW,20),
	INST_DELAY(127),
	INST_DELAY(60),
	INST_END_WAVE};
static const uint8_t waveZigBottom[]={
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NARROW,24),
	INST_DELAY(127),
	INST_DELAY(60),
	INST_END_WAVE};
static const uint8_t waveTriTri[]={
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NONE,18),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NONE,52),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NONE,32),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveSandwich[]={
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_NARROW,10),
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_NARROW,54),
	INST_DELAY(100),
	INST_SPAWN(SPAWN_ZIG_FILE,INST_RAND_NONE,30),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveCatapult[]={
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_NONE,21),
	INST_SPAWN(SPAWN_TRI_LINE,INST_RAND_NONE,43),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,29),
	INST_DELAY(127),
	INST_DELAY(64),
	INST_END_WAVE};
static const uint8_t waveSuperPlatoon[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,26),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,39),
	INST_DELAY(80),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,13),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,52),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveArrows[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,46),
	INST_DELAY(80),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,52),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,40),
	INST_DELAY(127),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,18),
	INST_DELAY(80),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,24),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,12),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveCamouflage0[]={
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,16),
	INST_DELAY(90),
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,44),
	INST_DELAY(30),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,44),
	INST_DELAY(97),
	INST_END_WAVE};
static const uint8_t waveCamouflage1[]={
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,16),
	INST_DELAY(30),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,16),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,44),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveBigWall[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,56),
	INST_DELAY(40),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,44),
	INST_DELAY(40),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,32),
	INST_DELAY(40),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,20),
	INST_DELAY(40),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NONE,8),
	INST_DELAY(40),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
static const uint8_t waveJamming[]={
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,16),
	INST_DELAY(20),
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,48),
	INST_DELAY(20),
	INST_SPAWN(SPAWN_TRI_SHOAL,INST_RAND_NONE,32),
	INST_DELAY(20),
	INST_DELAY(60),
	INST_SPAWN(SPAWN_BIG,INST_RAND_WIDE,0),
	INST_DELAY(60),
	INST_END_WAVE};
static const uint8_t waveTest[]={
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,26),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,39),
	INST_DELAY(80),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,13),
	INST_SPAWN(SPAWN_BIG,INST_RAND_NARROW,52),
	INST_DELAY(127),
	INST_DELAY(127),
	INST_END_WAVE};
/****************************************************************************
 *	
 ****************************************************************************/
void Generator_initialize() {
	generator.difficulty	= 0;
	generator.zone		= 0;
	generator.waveCount	= WAVES_IN_ZONE - 1;
	generator.waveIndex	= 0;
	generator.progCount	= 0;
	generator.delayTimer	= 0;
	generator.dispTimer	= 0;
}
/*--------------------------------------------------------------------------*/
void Generator_spawn() {
	static const uint8_t* const waves[]={	//generating scripts
#ifdef  DEBUG
		waveTest,								//0
#else //DEBUG
		waveEmpty,								//0
#endif//DEBUG
		waveBeginner0,waveBeginner1,waveRandomLines,waveZigTop,waveZigBottom,	//easy 1-5
		waveTriTri,waveSandwich,waveCatapult,waveSuperPlatoon,			//normal 6-9
		waveBigWall,waveJamming,waveCamouflage0,waveCamouflage1,waveArrows,	//hard 10-14
	};
	static const uint8_t DIFFICULTY_GROUP[]={5,4,5};
	//
	int inst;	//current instruction (or operand)
#ifdef  DEBUG
	if(joy & PAD_B) {
		if(joy & TRG_UP) { generator.difficulty += 10; }
		if(joy & TRG_DN) { generator.difficulty -= 10; }
	}
#endif//DEBUG
	if(generator.dispTimer  > 0) { generator.dispTimer--; }
	if(generator.delayTimer > 0) { generator.delayTimer--; return; }	//if delaying, skip generating step
	//fetch
	inst = pgm_read_byte(waves[generator.waveIndex] + generator.progCount);
	while((inst != INST_END_WAVE) && (generator.delayTimer <= 0)) {
		//spawn
		if(inst & INST_SPAWN_MASK) {
			int type, rand, y;
			type = inst & INST_TYPE_MASK;
			//get next operand
			generator.progCount++;
			inst = pgm_read_byte(waves[generator.waveIndex] + generator.progCount);
			rand = inst & INST_RAND_MASK;
			if(rand == INST_RAND_ERROR) { DIE(); }	//invalid operand
			y = inst & INST_Y_MASK;
			if(rand == INST_RAND_WIDE) {
				y  = random(4, 57);
			} else if(rand == INST_RAND_NARROW) {
				y += random(0, 10) - 5;
			}
			switch(type) {
			default:DIE();
			case SPAWN_BIG:        GameLevel_spawnBigEnemy(  y                       ); break;
			case SPAWN_ZIG_SINGLE: GameLevel_spawnSmallEnemy(y - 5, SENEMY_ZIG_FIRE  ); break;
			case SPAWN_ZIG_FILE:   Platoons_set(             y - 5, PLATOON_ZIG_FILE ); break;
			case SPAWN_TRI_SINGLE: GameLevel_spawnSmallEnemy(y    , SENEMY_TRI_FIRE  ); break;
			case SPAWN_TRI_LINE:   Platoons_set(             y    , PLATOON_TRI_LINE ); break;
			case SPAWN_TRI_SHOAL:  Platoons_set(             y    , PLATOON_TRI_SHOAL); break;
			}
		//delay
		} else {
			generator.delayTimer = inst;
		}
		//get next instruction
		generator.progCount++;
		inst = pgm_read_byte(waves[generator.waveIndex] + generator.progCount);
	}
	//next wave
	if((inst == INST_END_WAVE) && (generator.delayTimer <= 0)) {
		int randNum, randMin;
		generator.waveCount++;
		generator.progCount = 0;
		//difficulty limit
		randMin = 1;	//except zero
		if(Generator_getDifficulty() < 10) {
			randNum  = DIFFICULTY_GROUP[0];
		} else if(Generator_getDifficulty() < 50) {
			randNum  = DIFFICULTY_GROUP[0] + DIFFICULTY_GROUP[1];
		} else if(Generator_getDifficulty() < 70) {
			randNum  = DIFFICULTY_GROUP[0] + DIFFICULTY_GROUP[1] + DIFFICULTY_GROUP[2];
		} else {
			randNum  = DIFFICULTY_GROUP[1] + DIFFICULTY_GROUP[2];
			randMin += DIFFICULTY_GROUP[0];
		}
		generator.waveIndex = random(0, randNum) + randMin;
		//difficulty up
		if(generator.difficulty < (DIFFICULTY_CAP + DIFFICULTY_DECR)) {
			generator.difficulty += (DIFFICULTY_INCR / WAVES_IN_ZONE);
		}
		//next zone
		if(generator.waveCount >= WAVES_IN_ZONE) {
			generator.waveCount = 0;
			generator.dispTimer = ZONE_DISP_FRAMES;	//disp zone and score
			generator.zone++;
			//difficulty down
			if((generator.difficulty < (DIFFICULTY_CAP + DIFFICULTY_DECR)) && (generator.zone > 1)) {
				generator.difficulty -= DIFFICULTY_DECR;
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
void Generator_draw() {
	if((generator.dispTimer > 0) && !(GameLevel_frameCount() / 5 % 2)) {
		GameCore_setCursor((SCREEN_WIDTH / 2) - (6 * 11 / 2), 0);
		GameCore_print("Score %05d", GameLevel_getScore());
		GameCore_setCursor((SCREEN_WIDTH / 2) - (6 * 7 / 2), 10);
		GameCore_print("ZONE%3d", generator.zone);
	}
}
/*--------------------------------------------------------------------------*/
int Generator_getDifficulty() {
	return (generator.difficulty > DIFFICULTY_CAP) ? DIFFICULTY_CAP : generator.difficulty;
}
