#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define inactivateCharacters(T,pool,n)		\
	for(i = 0; i < (n); i++) {		\
		T##_inactivate(&(pool)[i]);	\
	}
#define moveCharacters(T,pool,n)		\
	for(i = 0; i < (n); i++) {		\
		if(T##_exist(&(pool)[i])) {	\
			T##_move(&(pool)[i]);	\
		}				\
	}
#define drawCharacters(T,pool,n)		\
	for(i = 0; i < (n); i++) {		\
		if(T##_exist(&(pool)[i])) {	\
			T##_draw(&(pool)[i]);	\
		}				\
	}
#define searchAvailableIndex(T,pool,n) ({	\
	for(i = 0; i < (n); i++) {		\
		if(!T##_exist(&(pool)[i])) {	\
			break;			\
		}				\
	}					\
	i;})
/*--------------------------------------------------------------------------*/
#define GRAZE_RANGE		8
/****************************************************************************
 *	
 ****************************************************************************/
void GameLevel_initialize() {
	/** no job **/
}
/*--------------------------------------------------------------------------*/
void GameLevel_onEntry() {
	int i;
	gameLevel.frames	= 0;
	gameLevel.score		= 0;
	gameLevel.gameoverCount	= -1;
	//
	Submarine_initialize();
	Torpedo_inactivate();
	inactivateCharacters(AutoShot, autoShots, AUTO_SHOT_MAX);
	inactivateCharacters(BigEnemy, bigEnemies, BIG_ENEMY_MAX);
	inactivateCharacters(SmallEnemy, smallEnemies, SMALL_ENEMY_MAX);
	inactivateCharacters(Bullet, bullets, BULLET_MAX);
	inactivateCharacters(Particle, particles, PARTICLE_MAX);
#ifndef DEBUG
	//first shoal
	for(i = 0; i < SMALL_ENEMY_MAX; i++) {
		int r = random(0, 256);
		smallEnemies[i].x	= FIELD_WIDTH - (r % SCREEN_WIDTH);
		smallEnemies[i].y	= r % (SCREEN_HEIGHT - 20) + 10;
		smallEnemies[i].type	= SENEMY_ZIG_NOFIRE;
		smallEnemies[i].timer	= r % 96;
	}
#endif//DEBUG
	Echo_reset(0);
	Platoons_initialize();
	Generator_initialize();
	//
	randomSeed(GameCore_frameCount());
	GameCore_tone(880, 1000);
}
/*--------------------------------------------------------------------------*/
int GameLevel_loop() {
	int i, fx, shotIdx, smallEnemyIdx, bigEnemyIdx;
	//music
#ifndef DISABLE_MUSIC
	if((gameLevel.frames > 381) && !GameCore_playing()) { GameCore_playScore(ARDUBOY_I_HALF); }
#endif//DISABLE_MUSIC
	//spawn
	/*if(!(GameLevel_frameCount() % 240)) {
		//GameLevel_spawnBigEnemy(random(8, SCREEN_HEIGHT - 8));
		//GameLevel_spawnSmallEnemy(random(8, SCREEN_HEIGHT - 8), SENEMY_ZIG_NOFIRE | (3 << 4));
		Platoons_set(random(8, SCREEN_HEIGHT - 8), PLATOON_TRI_SHOAL);
	}*/
	Generator_spawn();
	Platoons_spawn();
	//in order to forecast the position of submarine
	gameLevel.prevSubmarineX = submarine.x / 256.0;
	gameLevel.prevSubmarineY = submarine.y / 256.0;
	//=== move ===
	Submarine_move();
	Echo_reset(Submarine_fieldX());
	Torpedo_move();
	moveCharacters(AutoShot, autoShots, AUTO_SHOT_MAX);
	moveCharacters(BigEnemy, bigEnemies, BIG_ENEMY_MAX);
	moveCharacters(SmallEnemy, smallEnemies, SMALL_ENEMY_MAX);
	moveCharacters(Bullet, bullets, BULLET_MAX);
	moveCharacters(Particle, particles, PARTICLE_MAX);
	//=== hittest ===
	//BigEnemy vs Torpedo
	for(i = 0; i < BIG_ENEMY_MAX; i++) {
		if(!Torpedo_exist()) { break; }
		if(!BigEnemy_exist(&bigEnemies[i])) { continue; }
		//check graze
		if(Collision(bigEnemies[i].x,
			     bigEnemies[i].y,
			     BIGENEMY_W,
			     BIGENEMY_H,
			     torpedo.x,
			     torpedo.y - GRAZE_RANGE,
			     TORPEDO_W,
			     TORPEDO_H + GRAZE_RANGE * 2)) {
			//check hit
			if(Collision(bigEnemies[i].x,
				     bigEnemies[i].y,
				     BIGENEMY_W,
				     BIGENEMY_H,
				     torpedo.x,
				     torpedo.y,
				     TORPEDO_W,
				     TORPEDO_H)) {
				BigEnemy_onHit(&bigEnemies[i]);
				Torpedo_onHit();
			} else {
				BigEnemy_onGraze(&bigEnemies[i]);
			}
		}
	}
#ifndef LOW_FLASH_MEMORY
	//SmallEnemy vs Torpedo
	for(i = 0; i < SMALL_ENEMY_MAX; i++) {
		if(!Torpedo_exist()) { break; }
		if(!SmallEnemy_exist(&smallEnemies[i])) { continue; }
		if(Collision(smallEnemies[i].x,
			     smallEnemies[i].y,
			     SMALLENEMY_W,
			     SMALLENEMY_H,
			     torpedo.x,
			     torpedo.y,
			     TORPEDO_W,
			     TORPEDO_H)) {
			SmallEnemy_onHit(&smallEnemies[i]);
		}
	}
#endif//LOW_FLASH_MEMORY
	//AutoShot
	for(shotIdx = 0; shotIdx < AUTO_SHOT_MAX; shotIdx++) {
		if(!AutoShot_exist(&autoShots[shotIdx])) { continue; }
		//vs SmallEnemy
		for(smallEnemyIdx = 0; smallEnemyIdx < SMALL_ENEMY_MAX; smallEnemyIdx++) {
			if(!SmallEnemy_exist(&smallEnemies[smallEnemyIdx])) { continue; }
			if(Collision(autoShots[shotIdx].x,
				     autoShots[shotIdx].y,
				     AUTOSHOT_W,
				     AUTOSHOT_H,
				     smallEnemies[smallEnemyIdx].x,
				     smallEnemies[smallEnemyIdx].y,
				     SMALLENEMY_W,
				     SMALLENEMY_H)) {
				AutoShot_onHit(&autoShots[shotIdx]);
				SmallEnemy_onHit(&smallEnemies[smallEnemyIdx]);
			}
		}
#ifndef LOW_FLASH_MEMORY
		//vs BigEnemy
		for(bigEnemyIdx = 0; bigEnemyIdx < BIG_ENEMY_MAX; bigEnemyIdx++) {
			if(!BigEnemy_exist(&bigEnemies[bigEnemyIdx])) { continue; }
			if(Collision(autoShots[shotIdx].x,
				     autoShots[shotIdx].y,
				     AUTOSHOT_W,
				     AUTOSHOT_H,
				     bigEnemies[bigEnemyIdx].x,
				     bigEnemies[bigEnemyIdx].y,
				     BIGENEMY_W,
				     BIGENEMY_H)) {
				AutoShot_onHit(&autoShots[shotIdx]);
			}
		}
#endif//LOW_FLASH_MEMORY
	}
	//Bullet vs Submarine
	for(i = 0; i < BULLET_MAX; i++) {
		if(!Submarine_exist()) { break; } //todo armor
		if(!Bullet_exist(&bullets[i])) { continue; }
		if(Collision(Bullet_fieldX(&bullets[i]),
			     Bullet_fieldY(&bullets[i]),
			     BULLET_W,
			     BULLET_H, 
			     Submarine_fieldX(),
			     Submarine_fieldY(),
			     SUBMARINE_W,
			     SUBMARINE_H)) {
			Bullet_onHit(&bullets[i]);
			Submarine_onHit();
		}
	}
	//=== draw ===
	//background
	fx = -GameLevel_frameCount() / 16;
	DrawWave(fx, GameLevel_frameCount());
	DrawBottom(fx);
	//disp extralives
	GameCore_drawBitmap(0, 4, SPR_EXTRALIVES, 1);
	GameCore_setCursor(10, 0);
	GameCore_print("%c", '0' + Clamp(submarine.extraLives, 0, 9));
#ifdef  DEBUG
	//disp score
	GameCore_setCursor(SCREEN_WIDTH / 2 - 15, 0);
	GameCore_print("%05d", gameLevel.score);
#endif//DEBUG
	//zone and score
	if(!GameLevel_isGameover()) {
		Generator_draw();
	}
	//echo
	if(!GameLevel_isGameover()) {
		Echo_draw();
	}
	//characters
	drawCharacters(AutoShot, autoShots, AUTO_SHOT_MAX);
	Submarine_draw();
	Torpedo_draw();
	drawCharacters(BigEnemy, bigEnemies, BIG_ENEMY_MAX);
	drawCharacters(SmallEnemy, smallEnemies, SMALL_ENEMY_MAX);
	drawCharacters(Bullet, bullets, BULLET_MAX);
	drawCharacters(Particle, particles, PARTICLE_MAX);
	//gameover
	if(gameLevel.gameoverCount > 100) {
		GameCore_setCursor(SCREEN_WIDTH / 2 - 20, SCREEN_HEIGHT / 2 - 3);
		GameCore_print("GAMEOVER");
	}
	//=== post process ===
	//clock
	gameLevel.frames++;
	if(gameLevel.gameoverCount >= 0) { gameLevel.gameoverCount++; }
	//exit game if return true
	if((gameLevel.gameoverCount > 100) && (joy & TRG_AB)) {
		return 1;	//skip gameover text
	}
	return gameLevel.gameoverCount >= 300;
}
/*--------------------------------------------------------------------------*/
void GameLevel_addScore(int plus) {
	if((gameLevel.score + plus) > 99999) {
		gameLevel.score = 99999;	//count stop
	} else if(gameLevel.gameoverCount < 0) {
#ifndef EXHIBITION_MODE
		if((((gameLevel.score + plus) / EXTEND_SCORE) > (gameLevel.score / EXTEND_SCORE)) && (submarine.extraLives < 9)) {
			submarine.extraLives++;
			GameCore_tone(1760, 500);
		}
#endif//EXHIBITION_MODE
		gameLevel.score += plus;
	}
}
/*--------------------------------------------------------------------------*/
double GameLevel_getSubmarineAngle(int bx, int by) {
	return atan2(
		Submarine_fieldY() - by,
		Submarine_fieldX() - bx);
}
/*--------------------------------------------------------------------------*/
//FromX, FromY, BulletSpeed
double GameLevel_getFutureSubmarineAngle(int fx, int fy, int bs) {
	double tx = submarine.x / 256.0;		//ToX (or TargetX)
	double ty = submarine.y / 256.0;		//ToY
	double vx = tx - gameLevel.prevSubmarineX;	//VelocityX (of submarine)
	double vy = ty - gameLevel.prevSubmarineY;	//VelocityY
	double ds = (tx - fx) * (tx - fx) + (ty - fy) * (ty - fy);	//SquareDistance
	double rt = sqrt(ds) / bs;			//ReachTime
	double px = vx * rt + tx;			//PredictedX (of future submarine)
	double py = vy * rt + ty;			//PredictedY
	return atan2(py - fy, px - fx);
}
/*--------------------------------------------------------------------------*/
//spawn characters
void GameLevel_launchTorpedo(int x, int y) {
	if(Torpedo_launch(x, y)) {
		GameCore_tone(440, 50);
	}
}
/*--------------------------------------------------------------------------*/
void GameLevel_fireAutoShot(int x, int y) {
	int i = searchAvailableIndex(AutoShot, autoShots, AUTO_SHOT_MAX);
	if(i < AUTO_SHOT_MAX) {
		AutoShot_initialize(&autoShots[i], x, y);
	}
}
/*--------------------------------------------------------------------------*/
void GameLevel_spawnBigEnemy(int y) {
	int i = searchAvailableIndex(BigEnemy, bigEnemies, BIG_ENEMY_MAX);
	if(i < BIG_ENEMY_MAX) {
		BigEnemy_initialize(&bigEnemies[i], y);
	}
}
/*--------------------------------------------------------------------------*/
int GameLevel_spawnSmallEnemy(int y, int type) {
	int i = searchAvailableIndex(SmallEnemy, smallEnemies, SMALL_ENEMY_MAX);
	if(i < SMALL_ENEMY_MAX) {
		SmallEnemy_initialize(&smallEnemies[i], y, type);
		return 0;	//successfully
	}
	return 1;	//error
}
/*--------------------------------------------------------------------------*/
void GameLevel_fireBullet(int x, int y, double radian, int type) {
	int i = searchAvailableIndex(Bullet, bullets, BULLET_MAX);
	if(i < BULLET_MAX) {
		Bullet_initialize(&bullets[i], x, y, radian, type);
	}
}
/*--------------------------------------------------------------------------*/
void GameLevel_spawnParticle(const int x, int y, int type) {
	int i;
	//this function can not be inline
	if(x > SCREEN_WIDTH || y > SCREEN_HEIGHT) { return; }
	i = searchAvailableIndex(Particle, particles, PARTICLE_MAX);
	if(i < PARTICLE_MAX) {
		Particle_activate(&particles[i], x, y);
		particles[i].type	= type;
		switch(type) {
		case PARTICLE_EXPLOSION: particles[i].limit = 12; break;
		default:                 particles[i].limit = 50; break;
		}
	}
}
/*--------------------------------------------------------------------------*/
int GameLevel_frameCount() {
	return gameLevel.frames;
}
/*--------------------------------------------------------------------------*/
void GameLevel_setGameover() {
	if(gameLevel.gameoverCount < 0) {
		gameLevel.gameoverCount = 0;
	}
}
/*--------------------------------------------------------------------------*/
int GameLevel_isGameover() {
	return gameLevel.gameoverCount >= 0;
}
/*--------------------------------------------------------------------------*/
int GameLevel_getScore() {
	return gameLevel.score;
}
/*--------------------------------------------------------------------------*/
int GameLevel_difficulty() {
	return Generator_getDifficulty();
}
/*--------------------------------------------------------------------------*/
#ifndef LOW_FLASH_MEMORY
int GameLevel_lookForEnemy() {
	int i;
	for(i = 0; i < BIG_ENEMY_MAX; i++) {
		if((bigEnemies[i].x > 0) && (bigEnemies[i].x < (SCREEN_WIDTH + 16))) {
			return 1;
		}
	}
	for(i = 0; i < SMALL_ENEMY_MAX; i++) {
		if((smallEnemies[i].x > 0) && (smallEnemies[i].x < (SCREEN_WIDTH + 16))) {
			return 1;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
void GameLevel_removeAllBullets() {
	int i;
	for(i = 0; i < BULLET_MAX; i++) {
		Bullet_onHit(&bullets[i]);
	}
}
#endif//LOW_FLASH_MEMORY
/*--------------------------------------------------------------------------*/
