#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#if     ((SCREEN_WIDTH!=DISP_X)||(SCREEN_HEIGHT>DISP_Y))
#error  ((SCREEN_WIDTH!=DISP_X)||(SCREEN_HEIGHT>DISP_Y))
#endif//((SCREEN_WIDTH!=DISP_X)||(SCREEN_HEIGHT>DISP_Y))
/****************************************************************************
 *	
 ****************************************************************************/
void GameCore_initialize() {
	music_wch = 3;	//USE_2BIT_ADPCMUSE_TRUESPEECHgpȂ̂app.capp_init()ł͎̏sȂAW[stream_play()ĂяôŕKvłBsȂBGMƌʉȂȂĂ܂B
	gameCore.soundOn = 1;
	//'肵`'B
	surface2.w = SCREEN_WIDTH;
	surface2.h = SCREEN_HEIGHT;
	surface2.vbuff = &vbuff[DISP_X * ((DISP_Y - SCREEN_HEIGHT) / 2)];
	render_init_2d(&render2, &surface2, 0, 0, 0, 0);
	//XvCghCo'肵`'g悤ɍďB
	sprite_init(&render2, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
	//Xg[ĐJnB
	stream_play(320, GameCore_stream_callback, 0, 0);
}
/*--------------------------------------------------------------------------*/
#ifndef LOW_FLASH_MEMORY
void GameCore_updateQuake() {
	if(gameCore.quakeForce > 0.5) {
		double dir;
		gameCore.quakeForce *= 0.85;
		dir = random(0, 256) * (M_PI * 2.0 / 256.0);
		gameCore.qx = lround(gameCore.quakeForce * cos(dir));
		gameCore.qy = lround(gameCore.quakeForce * sin(dir));
	} else {
		gameCore.qx = 0;
		gameCore.qy = 0;
	}
}
/*--------------------------------------------------------------------------*/
void GameCore_setQuake() {
	gameCore.quakeForce = 10;
}
#endif//LOW_FLASH_MEMORY
/*--------------------------------------------------------------------------*/
int GameCore_frameCount() {
	return now;
}
/*--------------------------------------------------------------------------*/
void GameCore_drawPixel(int x, int y, int c) {	//(c color. 0:A1:)
	x += gameCore.qx;
	y += gameCore.qy;
	switch(c) {
	default:DIE();
	case 0: c = COLOR_BLACK; break;
	case 1: c = COLOR_WHITE; break;
	}
	render_point(&render2, x, y, c);
}
/*--------------------------------------------------------------------------*/
void GameCore_drawBitmap(int x, int y, int sprno, int c) {	//(c color. 0:A1:A2:])
	x += gameCore.qx;
	y += gameCore.qy;
	switch(c) {
	default:DIE();
	case 0: c = DRW_CLR(COLOR_MASK,COLOR_BLACK); break;
	case 1: c = DRW_CLR(COLOR_MASK,COLOR_WHITE); break;
//{{C
//	case 2: c = DRW_CLR(COLOR_WHITE,COLOR_MASK); break;	//']'Ƃ͂()Ӗł͂ȂXOR`̂Ƃ炵B
//C
	case 2: sprite_draw_1BX(x, y, sprno); return;//܂	//P/ECEɂXOR`̋@\͖(`͗L邪)Ȃ̂ŁAOŏ鎖ɂB	fram.c
//}}C
	}
	sprite_draw(x, y, sprno, c);
}
/*--------------------------------------------------------------------------*/
void GameCore_drawCircle(int x, int y, int r, int c) {	//(c color. 0:A1:)
	x += gameCore.qx;
	y += gameCore.qy;
	switch(c) {
	default:DIE();
	case 0: c = COLOR_BLACK; break;
	case 1: c = COLOR_WHITE; break;
	}
	x -= r;
	y -= r;
	render_ellipse(&render2, x, y, (r * 2) + 1, (r * 2) + 1, c);
}
/*--------------------------------------------------------------------------*/
void GameCore_fillRect(int x, int y, int w, int h, int c) {	//(c color. 0:A1:)
	x += gameCore.qx;
	y += gameCore.qy;
	switch(c) {
	default:DIE();
	case 0: c = COLOR_BLACK; break;
	case 1: c = COLOR_WHITE; break;
	}
	render_rectangle_fill(&render2, x, y, w, h, c);
}
/*--------------------------------------------------------------------------*/
void GameCore_setCursor(int x, int y) {
	gameCore.cx = x;
	gameCore.cy = y;
}
/*--------------------------------------------------------------------------*/
void GameCore_print(const char* fmt, ...) {
	char buf[256/**/];
	va_list ap;
	va_start(ap, fmt);
	vsprintf(buf, fmt, ap);
	va_end(ap);
	render_string_framed(&render2,
		gameCore.cx - 2,	//(-2)Ă闝ŔAwʒuɍ킹邽߂(-1)A5x10sNZANKtHg(1,1)ɂȂ悤ɃfUCĂ̂(-1)Av(-2)܂B
		gameCore.cy - 2,	//
		buf,
		0,
		COLOR_WHITE|
		COLOR_BLACK<<4|
		COLOR_BLACK<<8);
}
/*--------------------------------------------------------------------------*/
void GameCore_playScore(const void* score) {
	if(!gameCore.soundOn) { return; }
	PlayMusic((uint8_t*)score);
}
/*--------------------------------------------------------------------------*/
void GameCore_stopScore() {
	StopMusic();
}
/*--------------------------------------------------------------------------*/
int GameCore_playing() {
	return !MusicCheck();	//MusicCheck()̖߂ĺu==0 t <>0 ~vȂ̂Ŕ]ĕԂ܂Bmuslib.cMusicCheck()̃RgQƂĉB
}
/*--------------------------------------------------------------------------*/
void GameCore_tone(int f, int d) {
	if(!gameCore.soundOn) { return; }
	if((unsigned)f > (SPEAKER_FREQUENCY / 2)) { f = (SPEAKER_FREQUENCY / 2); }
ENTER_CS;
	gameCore.tone_f = f;
	gameCore.tone_d = d * (SPEAKER_FREQUENCY / 1000);
	gameCore.tone_e = 0;
LEAVE_CS;
}
