#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
void Echo_reset(int subX) {
	int i;
	if(!(GameLevel_frameCount() % ECHO_CYCLE)) {
		for(i = 0; i < ECHO_VERT_RESO; i++) {
			echo.intensities[i] = 0;
		}
		echo.acceptFlag = 1;
	} else {
		echo.acceptFlag = 0;
	}
	echo.submarineX = subX;
}
/*--------------------------------------------------------------------------*/
void Echo_add(int left, int top, int bottom) {
	int dist, b, e, newInte, i;
	if(!echo.acceptFlag) { return; }
	dist = left - echo.submarineX;
	if(dist < 0) { return; }
	b = top    / ECHO_GRID_SIZE;
	e = bottom / ECHO_GRID_SIZE;
	newInte = ((FIELD_WIDTH - dist) / ECHO_HORI_RESO) + 3;	//+3 for display soon
	for(i = b; i <= e; i++) {
		if(newInte > echo.intensities[i]) {
			echo.intensities[i] = newInte;	//update
		}
	}
}
/*--------------------------------------------------------------------------*/
void Echo_draw() {
	int i, j;
	if(!(GameLevel_frameCount() / 3 % 2) ||					//tearing
	   ((GameLevel_frameCount() % ECHO_CYCLE) < (ECHO_CYCLE / 2))) {	//sustain: 30 frames
		return;
	}
	for(i = 0; i < ECHO_VERT_RESO; i++) {
		for(j = 0; j < echo.intensities[i]; j++) {
			GameCore_fillRect(
				SCREEN_WIDTH - (j - 1) * ECHO_GRID_SIZE,
				i * ECHO_GRID_SIZE,
				ECHO_GRID_SIZE - 1,
				ECHO_GRID_SIZE - 1,
				1);
		}
	}
}
