#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define MARGIN				4
/****************************************************************************
 *	
 ****************************************************************************/
void Bullet_initialize(Bullet* bullet, int x, int y, double radian, int type) {
	static const int SPEEDS[]={BULLET_TYPE0_SPD,BULLET_TYPE1_SPD,BULLET_TYPE2_SPD,BULLET_TYPE3_SPD};
	int speed = SPEEDS[type];
	bullet->x	= x << 8;
	bullet->y	= y << 8;
	bullet->vx	= round(cos(radian) * speed * 256.0);
	bullet->vy	= round(sin(radian) * speed * 256.0);
	bullet->type	= type;
}
/*--------------------------------------------------------------------------*/
void Bullet_move(Bullet* bullet) {
	bullet->x += bullet->vx;
	bullet->y += bullet->vy;
	//frame out
	if((Bullet_fieldX(bullet) < -MARGIN) || (Bullet_fieldX(bullet) > (SCREEN_WIDTH  + MARGIN)) ||
	   (Bullet_fieldY(bullet) < -MARGIN) || (Bullet_fieldY(bullet) > (SCREEN_HEIGHT + MARGIN))) {
		Bullet_inactivate(bullet);
	}
}
/*--------------------------------------------------------------------------*/
void Bullet_draw(Bullet* bullet) {
	//ToDo: async animation (if there are enough memories)
	int frame = GameLevel_frameCount() / 3 % 2;
	if(!(bullet->type % 2)) {
		static const int bitmaps[]={SPR_MBULLET0,SPR_MBULLET1};
		int sprno = bitmaps[frame];
		GameCore_drawBitmap(
			Bullet_fieldX(bullet) - (sprite_width( sprno) / 2),
			Bullet_fieldY(bullet) - (sprite_height(sprno) / 2),
			sprno,
			2);
	} else {
		static const int bitmaps[]={SPR_SBULLET0,SPR_SBULLET1};
		int sprno = bitmaps[frame];
		GameCore_drawBitmap(
			Bullet_fieldX(bullet) - (sprite_width( sprno) / 2),
			Bullet_fieldY(bullet) - (sprite_height(sprno) / 2),
			sprno,
			2);
	}
}
/*--------------------------------------------------------------------------*/
void Bullet_onHit(Bullet* bullet) {
	GameCore_drawCircle(
		Bullet_fieldX(bullet),
		Bullet_fieldY(bullet),
		6,
		1);
	Bullet_inactivate(bullet);
}
/*--------------------------------------------------------------------------*/
int Bullet_fieldX(Bullet* bullet) {
	return bullet->x >> 8;
}
/*--------------------------------------------------------------------------*/
int Bullet_fieldY(Bullet* bullet) {
	return bullet->y >> 8;
}
/*--------------------------------------------------------------------------*/
void Bullet_inactivate(Bullet* bullet) {
	bullet->x = FIXED_EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int Bullet_exist(Bullet* bullet) {
	return bullet->x > FIXED_EXIST_THRESHOLD;
}
