#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
#define PERIOD			150
/*--------------------------------------------------------------------------*/
#define GRAZED_MASK		(1<<1)
#define ON_SCREEN_MASK		1
/****************************************************************************
 *	
 ****************************************************************************/
void BigEnemy_initialize(BigEnemy* bigEnemy, int y) {
	bigEnemy->x		= FIELD_WIDTH;
	bigEnemy->y		= y;
	bigEnemy->state		= 0;
	bigEnemy->timer		= 0;
}
/*--------------------------------------------------------------------------*/
void BigEnemy_move(BigEnemy* bigEnemy) {
	//moving
	if(BigEnemy_grazed(bigEnemy) && (bigEnemy->x > (SCREEN_WIDTH - 5))) {
		bigEnemy->x += -3;	//submarine found
	} else if(!(bigEnemy->timer % 5)) {	//-0.2
		bigEnemy->x--;
	}
	//frame out
	if((bigEnemy->x + sprite_width(SPR_CRUENEMY0)) < 0) {
		BigEnemy_inactivate(bigEnemy);
	}
	//setting sonar reaction
	Echo_add(
		bigEnemy->x,
		bigEnemy->y,
		bigEnemy->y + BIGENEMY_H);
	//firing bullet
	if(bigEnemy->x < (SCREEN_WIDTH - BIGENEMY_W / 2)) {
		int d;
		if(!BigEnemy_onScreen(bigEnemy)) {
			bigEnemy->timer  = 0;	//in order to sync fire cycle
			bigEnemy->state |= ON_SCREEN_MASK;
		}
		d = GameLevel_difficulty();
		if(!(bigEnemy->timer) || ((d >= 60) && (bigEnemy->timer == 40))) {	//freq up when 60 and over
			int bulletY     = bigEnemy->y + sprite_height(SPR_CRUENEMY0) / 2;
			int bulletSpeed = (d >= 80) ? BULLET_TYPE2_SPD : BULLET_TYPE0_SPD;
			int bulletType  = (d >= 80) ? 2 : 0;
			GameLevel_fireBullet(
				bigEnemy->x,
				bulletY,
				GameLevel_getFutureSubmarineAngle(
					bigEnemy->x,
					bulletY,
					bulletSpeed),
				bulletType);
		}
	}
	//updating timer
	bigEnemy->timer = (bigEnemy->timer + 1) % PERIOD;
}
/*--------------------------------------------------------------------------*/
void BigEnemy_draw(BigEnemy* bigEnemy) {
	if((bigEnemy->x - 3) > SCREEN_WIDTH) { return; }
	GameCore_drawBitmap(
		bigEnemy->x - 3,
		bigEnemy->y - 2,
		SPR_CRUENEMY0,
		2);
}
/*--------------------------------------------------------------------------*/
void BigEnemy_onHit(BigEnemy* bigEnemy) {
	//add score
	GameLevel_addScore(10);
	if(bigEnemy->x > SCREEN_WIDTH) {	//far bonus
		GameLevel_addScore((bigEnemy->x - SCREEN_WIDTH) * 10 / (FIELD_WIDTH - SCREEN_WIDTH));
	}
	//near
	if(bigEnemy->x < (SCREEN_WIDTH + 20)) {
		GameCore_tone(1047, 250);
		GameLevel_spawnParticle(
			bigEnemy->x + random(-2,  8),
			bigEnemy->y + random(-4,  4),
			PARTICLE_EXPLOSION);
		GameLevel_spawnParticle(
			bigEnemy->x + random( 8, 18),
			bigEnemy->y + random(-4,  4),
			PARTICLE_EXPLOSION);
#ifndef LOW_FLASH_MEMORY
		GameLevel_removeAllBullets();
		GameCore_setQuake();
#endif//LOW_FLASH_MEMORY
	}
	//reset
	BigEnemy_inactivate(bigEnemy);
}
/*--------------------------------------------------------------------------*/
void BigEnemy_onGraze(BigEnemy* bigEnemy) {
	bigEnemy->state |= GRAZED_MASK;
}
/*--------------------------------------------------------------------------*/
void BigEnemy_inactivate(BigEnemy* bigEnemy) {
	bigEnemy->x = EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int BigEnemy_exist(BigEnemy* bigEnemy) {
	return bigEnemy->x > EXIST_THRESHOLD;
}
/*--------------------------------------------------------------------------*/
int BigEnemy_grazed(BigEnemy* bigEnemy) {
	return !!(bigEnemy->state & GRAZED_MASK);
}
/*--------------------------------------------------------------------------*/
int BigEnemy_onScreen(BigEnemy* bigEnemy) {
	return !!(bigEnemy->state & ON_SCREEN_MASK);
}
