/* * Wed Aug 26 01:00:19 JST 2009 Naoyuki Sawa
 * - c[găt[YǗALZSSkR[hłBȉ̖{Qlɂ܂B
 *   uf[^knhubN\bvO}̂߂̈kZ@Љv(gbp) 8 ړɂ鈳k 8.3 vO
 * - 悻AL̎ɍڂĂvOƓłAꕔAƊ_̂ŁAC܂B
 *   L̎̃vÓAm[h0Ԃm[hɊ蓖ĂĂ܂ALȃt[Yʒuɑ΂ĂA0ԃm[hgp꓾悤Ɍ܂B
 *   0ԃm[hɓo^ꂽt[Y͒TΏۂƂȂ炸A͂ɈkቺĂ悤Ɏv܂B
 *   40961̃t[YɂȂ邾Ȃ̂ŁAقƂǉê͖łACɂȂ܂B(̐Ă邩ǂA؂łB)
 *   ȉ̃vÓALȃt[Yʒuɑ΂m[hƁAm[ḧʒuȂ悤Am[ḧʒuύXč쐬܂B
 * - {W[̃R[h́ALZSSk̋@\Ŝ񋟂̂ł͂ȂAt[Ỹc[ǗAT{@\݂̂񋟂܂B
 *   {W[̃R[hgāAǂ̂悤ȈkoCitH[}bg֏o͂邩́Ap̃R[hɈς˂Ă܂B
 *   ṕA"lzss1.c""lzss2.c"QƂĂB
 */

/****************************************************************************
 *	LZSS{[`
 ****************************************************************************/

#if 0  /*{{̃t@CCN[hӏŐݒ肵ĂB*/
#define LZSS_DEBUG	/* ̃V{`ƁATdɌȂs܂BvÕoOopłBvO肵ARgAEgĂB */
//{{
//typedef const unsigned char LZSS_CHAR;	/* t[Y\镶P */
typedef const unsigned short LZSS_CHAR;		/* t[Y\镶P */
#define LZSS_MATCH_LEN_MAX	(15 + 2)	/* t[YɃ}b`ő咷Bŏ0Av2̈v̏ꍇAʏ͖kƂďo͂ */
//#define LZSS_MATCH_DIST_MAX	(15 + 1)	/* EChETCYB݂͈̓ʒuA}b`\ȉߋ̃t[Y܂ł̍ő勗Bŏ1 */
#define LZSS_MATCH_DIST_MAX	(4095 + 1)	/* EChETCYB݂͈̓ʒuA}b`\ȉߋ̃t[Y܂ł̍ő勗Bŏ1 */
//}}
#endif /*}}̃t@CCN[hӏŐݒ肵ĂB*/

/*---------------------------------------------------------------------------*/

#define LZSS_NODE_MAX		LZSS_MATCH_DIST_MAX	/* Lȃm[hԍ̍őlB(LZSS_MATCH_DIST_MAX+1)̗Lm[h݂BLZSS_search()̃RgQ */
#define LZSS_TREE_HEAD		(LZSS_NODE_MAX + 1)	/* [gm[hw_~m[hԍBtree[LZSS_TREE_HEAD].child[LZSS_CHILD_GT][gm[hԍw */
#define LZSS_NODE_NIL		(LZSS_NODE_MAX + 2)	/* m[hƂ\_~[m[hԍBtree[LZSS_NODE_NIL]ɑ΂ẮAǂȏsȂĂ\Ȃ */
#define LZSS_TREE_SIZE		(LZSS_NODE_MAX + 3)	/* LZSS_TREE_HEADLZSS_NODE_NIL܂ށAc[m[h */

/* LZSS_NODE.child */
#define LZSS_CHILD_LT		0
#define LZSS_CHILD_GT		1

typedef struct _LZSS_NODE {
	int parent;	/* ̃m[h̐eBLZSS_NODE_NILȂ΁Ãm[h͖gp */
	int child[2];	/* child[LZSS_CHILD_LT] = ̃m[ht[Y\q, child[LZSS_CHILD_GT] = ̃m[h傫t[Y\q */
} LZSS_NODE;

typedef struct _LZSS {
	LZSS_CHAR* src_data;		/* ̓f[^̐擪AhXBύXȂ */
	int src_len;			/* ̓f[^̕BύXȂ */
	int src_pos;			/* ݂̃t[YʒuB0(src_len-1)܂ő */
	LZSS_NODE tree[LZSS_TREE_SIZE];	/* EChẼt[Yo^c[ */
} LZSS;

static LZSS lzss;

/*---------------------------------------------------------------------------*/

/* {W[𗘗pR[hgp */
static int LZSS_init(LZSS_CHAR* src_data, int src_len);
static int LZSS_search(int* p_dist);
static int LZSS_advance();
/* {W[̓ł̂ݎgp */
static void LZSS_delete_node(int node);
static int LZSS_find_next_node(int node);
static void LZSS_replace_node(int old_node, int new_node);
static void LZSS_contract_node(int old_node, int new_node);

/*---------------------------------------------------------------------------*/

#ifdef LZSS_DEBUG
#pragma warning(disable: 4702)	/* 䂪nȂR[hłB */
#define LZSS_ASSERT(f) ((void)((f) || (LZSS_die("### %s(%d): %s", __FILE__, __LINE__, #f), 0)))
static void __declspec(noreturn)
LZSS_die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	fprintf(stderr, "\n");
	vfprintf(stderr, fmt, ap);
	va_end(ap);
#ifdef _DEBUG
	__asm int 3;
#else /*_DEBUG*/
	exit(1);
#endif /*_DEBUG*/
}
#else /*LZSS_DEBUG*/
#define LZSS_ASSERT(f)	((void)0)
#endif /*LZSS_DEBUG*/

/*---------------------------------------------------------------------------*/

/* c[B
 * ݂̃t[YʒuԂBK0łB
 */
static int
LZSS_init(LZSS_CHAR* src_data, int src_len)
{
	int i;

	/* ̓f[^̐擪AhXƕi[B */
	lzss.src_data = src_data;
	lzss.src_len = src_len;

	/* ׂĂ̗Lm[h𖢎gpƂA[gm[h(lzss.tree[LZSS_TREE_HEAD].child[LZSS_CHILD_GT])𖢑݂ƂB
	 * - lzss.tree[LZSS_TREE_HEAD].child[LZSS_CHILD_GT]łȂAlzss.tree[LZSS_TREE_HEAD].child[LZSS_CHILD_LT]AQƂ\B
	 *   LZSS_contract_node()ɂāA폜m[h[gm[hłꍇɁAêǂ̎qr邽߂łB
	 *   RvĂ܂ƁAsȏƂȂ̂ŁAlzss.tree[LZSS_TREE_HEAD].child[LZSS_CHILD_LT]m[hԍɏĂƂK{B
	 */
	for(i = 0; i < LZSS_TREE_SIZE; i++) {
		lzss.tree[i].parent = LZSS_NODE_NIL;
		lzss.tree[i].child[LZSS_CHILD_GT] = LZSS_NODE_NIL;
		lzss.tree[i].child[LZSS_CHILD_LT] = LZSS_NODE_NIL;
	}

	/* ݂̃t[YʒuB */
	lzss.src_pos = 0;

	return lzss.src_pos;
}

/*---------------------------------------------------------------------------*/

/* VKt[Yo^B
 * VKt[YɍŒvAEChẼt[Yւ̋ƁAvԂB
 */
static int
LZSS_search(int* p_dist)
{
	int new_node;
	int limit_len;
	int match_len;
	int match_pos;
	int child_sel;
	int test_node;
	int test_pos;
	int i;
	int delta;

	/* ݂̃t[YʒuA̓f[^ł邱ƁB */
	LZSS_ASSERT((lzss.src_pos >= 0) && (lzss.src_pos <= lzss.src_len - 1));

	/* VKt[Yo^邽߂́Am[hԍ߂B
	 * - (LZSS_NODE_MAX+1)  (2^N) Ƃ͌Ȃ̂ŁAlzss.src_pos&(LZSS_NODE_MAX+1) ƂĂ͂ȂB
	 *   ۂɁAʏ̃p[^ݒɂāA(LZSS_NODE_MAX+1)  17 ܂ 4097 łB
	 *   ̃p[^Ɍ炸A{W[p[^̒ɁA(2^N) OƂĂ͖̂B
	 */
	new_node = lzss.src_pos % (LZSS_NODE_MAX + 1);

	/* - VKt[Yo^邽߂̃m[hɂ́AŌẪt[YĂ邩A܂́AgpłB
	 *   ŌẪt[ÝAVKt[Y猩āA(LZSS_MATCH_DIST_MAX+1)̋ɑ݂B
	 *   EChEOłAVKt[YɃ}b`Ă͂Ȃ̂ŁATsȂOɍ폜B
	 *   TOɂЂƂ̃m[h𖢎gpɖ߂̂ŁAT̗Lm[h̓EChETCYɈvB
	 *   ȏオAc[̗Lm[hA(EChETCY+1)ƂRłB
	 * - c[̗Lm[hA(EChETCY)xɂłȂŔAȉ̂ƂB
	 *   ƁAŌẪt[Y̓EBhEłA܂Lł邩ATOɍ폜łȂB
	 *   TIAVKt[Yo^钼OɁAŌẪt[Y폜KvB
	 *   Ƃ낪AŌẪt[Ỹm[h폜uԂɁAc[\ω\B
	 *   c[\ωƁAVKt[Ỹm[ho^łȂȂĂ܂B
	 *   ȏ̗RɂAc[̗Lm[h́A(EChETCY+1)łȂĂ͂ȂȂB
	 */
	LZSS_delete_node(new_node);

	/* VKt[Y̓f[^̖܂ł̒A܂́AK̍ő咷́AZEƂB */
	limit_len = lzss.src_len - lzss.src_pos;
	if(limit_len > LZSS_MATCH_LEN_MAX) {
		limit_len = LZSS_MATCH_LEN_MAX;
	}

	/* ɁAŒv̒߂B */
	match_len = 0;

	/* ɁAŒvt[Yʒu߂B */
	match_pos = 0;

	/* tree[LZSS_TREE_HEAD].child[LZSS_CHILD_GT]ATJnB
	 * tree[LZSS_TREE_HEAD].child[LZSS_CHILD_GT]́A[gm[hwĂ邩A܂́AłB
	 */
	test_node = LZSS_TREE_HEAD;
	child_sel = LZSS_CHILD_GT;

	for(;;) {
		/* ̒Tm[h΁AVKt[Yi[āAIB */
		if(lzss.tree[test_node].child[child_sel] == LZSS_NODE_NIL) {
			lzss.tree[test_node].child[child_sel] = new_node;
			lzss.tree[new_node].parent = test_node;
			lzss.tree[new_node].child[LZSS_CHILD_LT] = LZSS_NODE_NIL;
			lzss.tree[new_node].child[LZSS_CHILD_GT] = LZSS_NODE_NIL;
			break; /* T܂ */
		}

		/* ̔rt[YɑΉATm[hԍ擾B */
		test_node = lzss.tree[test_node].child[child_sel];

		/* Tm[hALm[hł邱ƁB */
		LZSS_ASSERT((test_node >= 0) && (test_node <= LZSS_NODE_MAX));

		/* Tm[hԍɑΉAt[Yʒu߂B
		 * - ݂̃t[YʒuƁAc[̃m[hԍÃm[h̃t[Yʒu߂鎮łB
		 *   GNZȂǂgāAۂɒlׂĂ݂ƁA̎ŐƂłƎv܂B
		 */
		test_pos = (lzss.src_pos - 1) - (((lzss.src_pos - 1) - test_node) % (LZSS_NODE_MAX + 1));

		/* rt[YʒuA̓f[^̐擪Ã݂t[Yʒu̒O܂ł͈̔͂ł邱ƁB */
		LZSS_ASSERT((test_pos >= 0) && (test_pos <= lzss.src_pos - 1));

		/* rt[YƐVKt[ÝAv߂B */
		i = 0;
		do {
			/* rt[Y̕ƁAVKt[Ý̕A召߂B */
			delta = lzss.src_data[test_pos + i] - lzss.src_data[lzss.src_pos + i];

			/* rt[YƐVKt[YقȂA܂ŁB */
			if(delta) {
				break; /* r܂ */
			}
		} while(++i < limit_len); /* EɒBAr܂ */

		/* ܂ł̍Œv̒𒴂c */
		if(i > match_len) {
			/* Œv̒XVB */
			match_len = i;

			/* Œvt[YʒuLB */
			match_pos = test_pos;

			/* EňvAv͗L蓾Ȃ̂ŁATł؂B */
			if(match_len == limit_len) {
				/* - rt[YƐVKt[ÝǍ݂Eȉ̒ɂāASvƌȂB
				 *   ȍ~̔rŁAE邱Ƃ͗L蓾Ȃ̂ŁAȍ~̔rɂĂSvƌȂB
				 *   Ȃ킿Art[YƐVKt[ÝASvƌȂB
				 *   t[Yo^Ă邱Ƃ͖ʂȂ̂ŁAÂt[Y̓o^AVKt[YōւB
				 * - LƋtɁAÂt[YcĐVKt[Yo^ȂAƂ@͕słB
				 *   Ât[ÝAVKt[YɃEChEOāA폜邩łB
				 *   ȍ~ɁAÂt[Y폜ƁAEChE̒ɐVKt[Y݂Ăɂ炸A
				 *   c[ɓo^ĂȂԂƂȂAkቺĂ܂B
				 */
				LZSS_replace_node(test_node, new_node);
				break; /* T܂ */
			}
		}

		/* do`whilẽubNdelta=0Ŕꍇ́AE̔fŒTł؂̂ŁAւ͗Ȃ͂B */
		LZSS_ASSERT(delta != 0);

		/* rt[YƐVKt[Y̑召ɂāAɐiގq̕IB */
		if(delta < 0) {
			child_sel = LZSS_CHILD_LT;
		} else {
			child_sel = LZSS_CHILD_GT;
		}
	}

	/* VKt[YɍŒvAEChẼt[Yւ̋i[B
	 * AvĂȂAvt[Yꍇ́Ai[ȂB
	 */
	if(p_dist && match_len) {
		*p_dist = lzss.src_pos - match_pos;

		/* t[Yւ̋AEChE͈͓ł邱ƂmFB */
		LZSS_ASSERT((*p_dist >= 1) && (*p_dist <= LZSS_MATCH_DIST_MAX));
	}

	/* Œv̒ԂB */
	return match_len;
}

/*---------------------------------------------------------------------------*/

/* ݂̃t[Yʒui߂B
 * i߂ʂ́Ã݂t[YʒuԂB
 */
static int
LZSS_advance()
{
	/* ݂̃t[YʒuA̓f[^ł邱ƁB */
	LZSS_ASSERT((lzss.src_pos >= 0) && (lzss.src_pos <= lzss.src_len - 1));

	/* ݂̃t[Yʒui߂Bʂ́A1`lzss.src_len͈̔͂ƂȂB */
	lzss.src_pos++;

	return lzss.src_pos;
}

/*---------------------------------------------------------------------------*/

/* ̃m[h폜B */
static void
LZSS_delete_node(int node)
{
	int next_node;

	/* Lm[hȊOɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT((node >= 0) && (node <= LZSS_NODE_MAX));

	/* gpȂ΁AȂB
	 * ܂t[Yǂݍ܂ĂȂASvŌÂt[Y폜ꂽꍇłB
	 */
	if(lzss.tree[node].parent == LZSS_NODE_NIL) {
		return;
	}

	/* ̎q΁Ãm[h폜A傫̎q㏸B傫̎qꍇ́Ãm[h폜邾̏ƂȂB */
	if(lzss.tree[node].child[LZSS_CHILD_LT] == LZSS_NODE_NIL) {
		LZSS_contract_node(node, lzss.tree[node].child[LZSS_CHILD_GT]);

	/* 傫̎q΁Ãm[h폜A̎q㏸B̎qꍇ́Ãm[h폜邾̏ƂȂB */
	} else if(lzss.tree[node].child[LZSS_CHILD_GT] == LZSS_NODE_NIL) {
		LZSS_contract_node(node, lzss.tree[node].child[LZSS_CHILD_LT]);

	/* ̎qL΁Ãm[h폜Ãm[h̎ɑ傫ȃt[Ỹm[h㏸B */
	} else {
		/* ̃m[h̎ɑ傫ȃt[Ỹm[h擾B */
		next_node = LZSS_find_next_node(node);

		/* ɑ傫ȃt[Ỹm[hA폜B
		 * ɑ傫ȃt[Ỹm[hɑ΂A̐em[hqm[h̃N؂邽߂łB
		 */
		LZSS_delete_node(next_node);

		/* ɑ傫ȃt[Ỹm[hÃm[ḧʒuɏ㏸B */
		LZSS_replace_node(node, next_node);
	}
}

/*---------------------------------------------------------------------------*/

/* ̃m[h̎ɑ傫ȃt[ÝAm[hԍ擾B */
static int
LZSS_find_next_node(int node)
{
	/* Lm[hȊOɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT((node >= 0) && (node <= LZSS_NODE_MAX));

	/* 傫̎q̃c[A̎q𖖒[܂łǂB
	 * ƁÃm[h傫t[Y̒ŁAŏ̃t[Y擾B
	 */
	node = lzss.tree[node].child[LZSS_CHILD_GT];
	for(;;) {
		/* ̊֐́Am[h̎qĂꍇɌĂяôŁAȂ傫̎qƂ͗L蓾ȂB
		 * ȍ~́A̎q𖖒[܂łǂrŁAsȃm[hԍi[ĂȂƂmFB
		 */
		LZSS_ASSERT((node >= 0) && (node <= LZSS_NODE_MAX));

		/* ̎q΁Ã݂m[h[łB */
		if(lzss.tree[node].child[LZSS_CHILD_LT] == LZSS_NODE_NIL) {
			return node; /* ܂ */
		}

		/* ̎qւǂāApB */
		node = lzss.tree[node].child[LZSS_CHILD_LT];
	}
}

/*---------------------------------------------------------------------------*/

/* Âm[h폜AVKm[hōւB */
static void
LZSS_replace_node(int old_node, int new_node)
{
	int parent;

	/* Lm[hȊOɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT((old_node >= 0) && (old_node <= LZSS_NODE_MAX));
	LZSS_ASSERT((new_node >= 0) && (new_node <= LZSS_NODE_MAX));

	/* m[hɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT(old_node != new_node);

	/* Âm[h̐em[hԍ擾B */
	parent = lzss.tree[old_node].parent;

	/* em[h́ALm[hA܂́ALZSS_TREE_HEADł͂B */
	LZSS_ASSERT(((parent >= 0) && (parent <= LZSS_NODE_MAX)) || (parent == LZSS_TREE_HEAD));

	/* em[hÂm[hւ̃|C^AVKm[hɍB */
	if(lzss.tree[parent].child[LZSS_CHILD_LT] == old_node) {
		lzss.tree[parent].child[LZSS_CHILD_LT] = new_node;
	} else {
		/* Âm[h́Aem[h̏̎qA܂́A傫̎q́Aꂩł͂B
		 * ̏fŁA̎qłȂƂƂ́A傫̎qłȂ΂ȂȂB
		 */
		LZSS_ASSERT(lzss.tree[parent].child[LZSS_CHILD_GT] == old_node);
		lzss.tree[parent].child[LZSS_CHILD_GT] = new_node;
	}

	/* Âm[h̎q́ALm[hA܂́Ał͂B */
	LZSS_ASSERT(((lzss.tree[old_node].child[LZSS_CHILD_LT] >= 0) && (lzss.tree[old_node].child[LZSS_CHILD_LT] <= LZSS_NODE_MAX)) ||
	             (lzss.tree[old_node].child[LZSS_CHILD_LT] == LZSS_NODE_NIL));
	LZSS_ASSERT(((lzss.tree[old_node].child[LZSS_CHILD_GT] >= 0) && (lzss.tree[old_node].child[LZSS_CHILD_GT] <= LZSS_NODE_MAX)) ||
	             (lzss.tree[old_node].child[LZSS_CHILD_GT] == LZSS_NODE_NIL));

	/* VKm[hAeƎqւ̃|C^AÂm[hƓɂB */
	lzss.tree[new_node] = lzss.tree[old_node];

	/* VKm[h̎qAeւ̃|C^AVKm[hɍB
	 * q󂾂ꍇ́Atree[LZSS_NODE_NIL]ɑ΂_~[ƂȂASłB
	 */
	lzss.tree[lzss.tree[new_node].child[LZSS_CHILD_LT]].parent = new_node;
	lzss.tree[lzss.tree[new_node].child[LZSS_CHILD_GT]].parent = new_node;

	/* Âm[h𖢎gpɖ߂B */
	lzss.tree[old_node].parent = LZSS_NODE_NIL;
}

/*---------------------------------------------------------------------------*/

/* Âm[h폜AÂm[h̐eƁAVKm[h𒼌B
 * VKm[hɋm[hw肵ꍇ́AÂm[h폜邾̏ƂȂB
 */
static void
LZSS_contract_node(int old_node, int new_node)
{
	int parent;

	/* Âm[hALm[hȊOɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT((old_node >= 0) && (old_node <= LZSS_NODE_MAX));

	/* VKm[h́ALm[hA܂́Ał͂B */
	LZSS_ASSERT(((new_node >= 0) && (new_node <= LZSS_NODE_MAX)) || (new_node == LZSS_NODE_NIL));

	/* m[hɑ΂āÅ֐Ăяo邱Ƃ͗L蓾ȂB */
	LZSS_ASSERT(old_node != new_node);

	/* 폜m[h̐em[hԍ擾B */
	parent = lzss.tree[old_node].parent;

	/* 폜m[h̐em[h́ALm[hA܂́ALZSS_TREE_HEADł͂B */
	LZSS_ASSERT(((parent >= 0) && (parent <= LZSS_NODE_MAX)) || (parent == LZSS_TREE_HEAD));

	/* ㏸m[hAeւ̃|C^A폜m[h̐eɍB
	 * ㏸m[hm[hłꍇ́Atree[LZSS_NODE_NIL]ɑ΂_~[ƂȂASłB
	 */
	lzss.tree[new_node].parent = parent;

	/* 폜m[h̐em[hAqւ̃|C^A㏸m[hɍB */
	if(lzss.tree[parent].child[LZSS_CHILD_LT] == old_node) {
		lzss.tree[parent].child[LZSS_CHILD_LT] = new_node;
	} else {
		/* 폜m[h́Aem[h̏̎qA܂́A傫̎q́Aꂩł͂B
		 * ̏fŁA̎qłȂƂƂ́A傫̎qłȂ΂ȂȂB
		 */
		LZSS_ASSERT(lzss.tree[parent].child[LZSS_CHILD_GT] == old_node);
		lzss.tree[parent].child[LZSS_CHILD_GT] = new_node;
	}

	/* 폜m[h𖢎gpɖ߂B */
	lzss.tree[old_node].parent = LZSS_NODE_NIL;
}
