%{
/*{{^R[h:y.tab.y(錾,%{`%})======================================*/
#ifdef  PIECE
#include "app.h"
#else //PIECE
#include "winapp.h"
#pragma warning(default: 4131)	//{{2016/03/01ǉ:clipstd.hɂC4131̌xxグ܂ABison/Flex̐R[hɂ͋X^C̐錾gĂ̂ŁABison/Flex̐R[ĥ݌xxɖ߂܂B}}
#endif//PIECE
/* p[T[X^bN̏l`܂B
 * sizeof(YYSTYPE)*YYINITDEPTH) X^bNɊmۂ܂B
 * ftHgł200ƒ`ĂAP/ECEɂ͑傫܂B
 * P/ECEɓK؂ȁAȃTCY(16)ɁAĒ`܂B
 * p[T[X^bNsꍇ́AIɊĝŁA肠܂B
 */
#define YYINITDEPTH 16
/*}}^R[h:y.tab.y(錾,%{`%})======================================*/
%}

%union {
	int		v_num;
	char*		v_lab;
	char*		v_str;
	//
	ST_KeyBody*	v_keyBody;
	ST_Key*		v_key;
	ST_NameRow*	v_nameRow;
	ST_ValueRow*	v_valueRow;
	ST_StringRow*	v_stringRow;
	ST_BlobRow*	v_blobRow;
	ST_Blob*	v_blob;
}

%token			T_END
%token	<v_num>		T_NUM
%token	<v_lab>		T_LAB
%token	<v_str>		T_STR
%token			T_EOL
%token			T_BIT
%token			T_BYTE
%token			T_HALF
%token			T_WORD

%type	<v_keyBody>	keyBody
%type	<v_key>		key
%type	<v_nameRow>	nameRow
%type	<v_valueRow>	valueRow
%type	<v_stringRow>	stringRow
%type	<v_num>		name
%type	<v_num>		data
%type	<v_num>		bit
%type	<v_num>		byte
%type	<v_num>		half
%type	<v_num>		word
%type	<v_num>		expr
%type	<v_str>		estr
%type	<v_str>		string
%type	<v_blobRow>	blobRow
%type	<v_blob>	blobBody
%type	<v_blob>	blob

%left			'|'
%left			'^'
%left			'&'
%left			T_SHL T_SHR
%left			'+' '-'
%left			'*' '/' '%'
%nonassoc		'~' T_UPL T_UMI

%%

all
		: keyBody			{ add_keyBody($1); }
		;
keyBody		: /* empty */			{ $$ = KeyBody_new(); }
		| keyBody T_EOL			/* use default action */
		| keyBody key			{ $$ = KeyBody_addKey($1, $2);       yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody valueRow		{ $$ = KeyBody_addValueRow($1, $2);  yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody stringRow		{ $$ = KeyBody_addStringRow($1, $2); yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody blobRow		{ $$ = KeyBody_addBlobRow($1, $2);   yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody error									//SẴV^NXG[񍐂邽߂ɌpB
		;
key
		: nameRow keyBody endRow	{ $$ = Key_new($1, $2); }
		;
nameRow
		: name T_EOL			{ $$ = NameRow_new($1); }
		;
valueRow
		: name '=' data T_EOL		{ $$ = ValueRow_new($1, $3); }
		;
stringRow
		: name '=' string T_EOL		{ $$ = StringRow_new($1, $3); }
		;
blobRow
		: name '=' blob T_EOL		{ $$ = BlobRow_new($1, $3); }
		;
endRow
		: T_END T_EOL			/* no action */
		;
name
		: expr				{ $$ = Name_newExpr($1); }
		| T_LAB				{ $$ = Name_newLabel($1); }
		;
data
		: expr				{ $$ = Data_newExpr($1); }
		| T_LAB				{ $$ = Data_newLabel($1); }
		;
string
		: estr				{ $$ = String_intern($1); }
		;
blob
		: '{' xeol blobBody '}'		{ $$ = Blob_intern($3); }
		;
blobBody
		:                   bit  xeol	{ $$ = Blob_newBit( $1); }
		| blobBody ',' xeol bit  xeol	{ $$ = Blob_addBit( $1, $4); }
		|                   byte xeol	{ $$ = Blob_newByte($1); }
		| blobBody ',' xeol byte xeol	{ $$ = Blob_addByte($1, $4); }
		|                   half xeol	{ $$ = Blob_newHalf($1); }
		| blobBody ',' xeol half xeol	{ $$ = Blob_addHalf($1, $4); }
		|                   word xeol	{ $$ = Blob_newWord($1); }
		| blobBody ',' xeol word xeol	{ $$ = Blob_addWord($1, $4); }
		;
bit
		: T_BIT  expr			{ $$ = Bit_new( $2); }
		;
byte
		:        expr			{ $$ = Byte_new($1); }		//ȗL@
		| T_BYTE expr			{ $$ = Byte_new($2); }
		;
half
		: T_HALF expr			{ $$ = Half_new($2); }
		;
word
		: T_WORD expr			{ $$ = $2; }
		;
xeol
		: /* empty */			/* no action */
		| xeol T_EOL			/* no action */
		;
expr
		: T_NUM
		| '(' expr ')'			{ $$ =  $2; }
		| '+' expr %prec T_UPL		{ $$ =  $2; }
		| '-' expr %prec T_UMI		{ $$ = -$2; }
		| '~' expr			{ $$ = ~$2; }
		| expr '+' expr			{ $$ = $1 + $3; }
		| expr '-' expr			{ $$ = $1 - $3; }
		| expr '*' expr			{ $$ = $1 * $3; }
		| expr '/' expr			{ if(!$3) { yyerror("division or modulo by zero"); yynerrs++; YYERROR; } $$ = $1 / $3; }
		| expr '%' expr			{ if(!$3) { yyerror("division or modulo by zero"); yynerrs++; YYERROR; } $$ = $1 % $3; }
		| expr '&' expr			{ $$ = $1 & $3; }
		| expr '^' expr			{ $$ = $1 ^ $3; }
		| expr '|' expr			{ $$ = $1 | $3; }
		| expr T_SHL expr		{ if((unsigned)$3 >= 32) { yyerror("shift count >= 32"); yynerrs++; YYERROR; } $$ = $1 << $3; }
		| expr T_SHR expr		{ if((unsigned)$3 >= 32) { yyerror("shift count >= 32"); yynerrs++; YYERROR; } $$ = $1 >> $3; }
		;
estr
		: T_STR
		| '(' estr ')'			{ $$ = $2; }
		| estr '+' estr			{ $$ = strconcat($1, $3, NULL); }
		;

%%
