#include "app.h"
/****************************************************************************
 *	main
 ****************************************************************************/
int main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
#ifdef  _DEBUG
	remove("syslog.out");	//񃍃O폜鎖ɂB
	openlog(NULL, LOG_PERROR, LOG_USER);
#endif//_DEBUG
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
	putenv("GC_LOG_FILE=CON");//Oo͐w肷B
	GC_set_find_leak(1);//[NoJnB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
#if     (defined(GC_H) && defined(PTHREAD_H))
	GC_init();//̒GCXbhNBCXbhpthread_exit()ŏIGCXbhcăvZXIȂ̂ŒӂB
	GC_allow_register_threads();
#endif//(defined(GC_H) && defined(PTHREAD_H))
#ifdef  __CLIP_SEH_H__
	SEH_init();
#endif//__CLIP_SEH_H__
//{{DATA
#ifdef  __CLIP_REG_H__
	if(!(TBL_RegTbl = (const unsigned char*)LockResource(LoadResource(NULL, FindResource(NULL, "RegTbl", "RegTbl"))))) { DIE(); }
#endif//__CLIP_REG_H__
#ifdef  __CLIP_ANMS_H__
	if(!(TBL_AnmSeqNo = (const int*)LockResource(LoadResource(NULL, FindResource(NULL, "AnmSeq", "AnmSeq"))))) { DIE(); }
#endif//__CLIP_ANMS_H__
#ifdef  __CLIP_NCSS_H__
	if(!(TBL_NcsSeqNo = (const int*)LockResource(LoadResource(NULL, FindResource(NULL, "NcsSeq", "NcsSeq"))))) { DIE(); }
#endif//__CLIP_NCSS_H__
#ifdef  __CLIP_TAPS_H__
	if(!(TBL_TapDefNo = (const int*)LockResource(LoadResource(NULL, FindResource(NULL, "TapDef", "TapDef"))))) { DIE(); }
#endif//__CLIP_TAPS_H__
#ifdef  __CLIP_LOT_H__
	if(!(TBL_LotTblNo = (const int*)LockResource(LoadResource(NULL, FindResource(NULL, "LotTbl", "LotTbl"))))) { DIE(); }
	LotRom_Init(TBL_LotTblNo, (int (*)())mrand48, NULL/*_~[*/);
#endif//__CLIP_LOT_H__
#ifdef  __CLIP_ENM_H__
	if(!(pEnmKey = REG_open_key(TBL_RegTbl, RegKey_EnmDef))) { DIE(); }
#endif//__CLIP_ENM_H__
#ifdef  __CLIP_PRP_H__
	if(!(pPrpKey = REG_open_key(TBL_RegTbl, RegKey_PrpTbl))) { DIE(); }
	PrpHdr_init(phApp, pPrpKey, PrpTbl_App);
#endif//__CLIP_PRP_H__
#ifdef  __CLIP_FSM_H__
	if(!(pFsmKey = REG_open_key(TBL_RegTbl, RegKey_FsmMap))) { DIE(); }
	FsmObj_Init(&foApp, pFsmKey, FsmMap_App);
#endif//__CLIP_FSM_H__
#ifdef  __CLIP_ACT_H__
	aoApp = ActObj_New(NULL/*pParent*/, NULL/*pFsmKey*/, 0/*iFsmMap*/, NULL/*pPrpKey*/, 0/*iPrpTbl*/, 0/*nDataBytes*/);
#endif//__CLIP_ACT_H__
//}}DATA
#ifdef  __CLIP_WKST_H__
	pWS = pWS = Worksheet_new();
#endif//__CLIP_WKST_H__
#ifdef  USE_PDCURSES
	initscr();
	refresh();//initscr()̒refresh()ĂяoĂ̂PDCurses̒΂łB
#endif//USE_PDCURSES
#ifdef  USE_GDIPLUS
	Gdiplus_Init();
#endif//USE_GDIPLUS
	app_init(argc, argv);
	exitCode = app_main(argc, argv);
	app_exit();
#ifdef  USE_GDIPLUS
	Gdiplus_Exit();
#endif//USE_GDIPLUS
#ifdef  USE_PDCURSES
	endwin();
#endif//USE_PDCURSES
#if     (defined(GC_H) && !defined(USE_BISON_FLEX))
	CHECK_LEAKS();//[NoB
#endif//(defined(GC_H) && !defined(USE_BISON_FLEX))
//{{TEST
	if(isatty(fileno(stdout))) {
		cputs("ok");
		getch();//"curses.h"CN[hgetch()wgetch(stdscr)ɒûŒӂB
	}
//}}TEST
	return exitCode;
}
/****************************************************************************
 *	usage
 ****************************************************************************/
__declspec(noreturn) static void usage() {
	//TODO:
	exit(EXIT_FAILURE);
}
/****************************************************************************
 *	
 ****************************************************************************/
void app_init(int argc, char* argv[]) {
	//TODO:
#ifdef  USE_DXLIB
	cpp_init(argc, argv);
#endif//USE_DXLIB
}
/*--------------------------------------------------------------------------*/
void app_exit() {
	//TODO:
#ifdef  USE_DXLIB
	cpp_exit();
#endif//USE_DXLIB
}
/*--------------------------------------------------------------------------*/
//{{TEST
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void test1() {
#ifdef  __CLIP_PRP_H__
	{
		ST_PrpHdr* pPrpHdr = PrpHdr_new(pPrpKey, PrpTbl_Dots);
		{
			int x, y, c = 0;
			for(x = 0; x < 3; x++) {
				for(y = 0; y < 2; y++) {
					PrpHdr_set_l(pPrpHdr, x, PrpVar_Dot,x,y, PrpVar_x, -1);
					PrpHdr_set_l(pPrpHdr, y, PrpVar_Dot,x,y, PrpVar_y, -1);
					PrpHdr_set_l(pPrpHdr, c, PrpVar_Dot,x,y, PrpVar_c, -1);
					if(++c > 4) { c = 0; }
				}
			}
		}
		PrpHdr_dump(stderr, pPrpHdr, fnVarFmt, 0);
		{
			PrpHdr_init_l(pPrpHdr, PrpVar_Dot, -1);
		}
		PrpHdr_dump(stderr, pPrpHdr, fnVarFmt, 0);
		PrpHdr_free(pPrpHdr);
		pPrpHdr = NULL;
	}
#ifdef  USE_PDCURSES
	sleep(1);
	clear();
	{
		ST_PrpEdt* pPrpEdt;
		pPrpEdt = PrpEdt_new(phApp->pPrpKey, phApp->iTbl, phApp+1, 0, fnVarFmt, stdscr, 30, 10);
		for(;;) {
			refresh();
			if(PrpEdt_exec(pPrpEdt) == KEY_F(12)) { break; }
			PrpEdt_draw(pPrpEdt);
		}
		PrpEdt_free(pPrpEdt);
	}
	clear();
	refresh();
#endif//USE_PDCURSES
#endif//__CLIP_PRP_H__
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void test2() {
#ifdef  USE_SQLITE
	int rc, iCol;
	db = sqlite_open(":memory:", 0, NULL);
	rc = sqlite_exec_printf(db, "CREATE TABLE tbl(id INTEGER PRIMARY KEY, val)", NULL, NULL, NULL);
	if(rc) { DIE(); }
	rc = sqlite_exec_printf(db, "BEGIN", NULL, NULL, NULL);
	if(rc) { DIE(); }
	{
		ST_Recordset_w* rs_w;
		rs_w = Recordset_New(db, "tbl");
			Recordset_SetNN(rs_w, 1234			,"id");
			Recordset_SetNT(rs_w, "One-Two-Three-Four"	,"val");
		Recordset_Insert(rs_w);
		rs_w = Recordset_New(db, "tbl");
			Recordset_SetNN(rs_w, 56			,"id");
			Recordset_SetNT(rs_w, "Five-Six"		,"val");
		Recordset_Insert(rs_w);
		rs_w = Recordset_New(db, "tbl");
			Recordset_SetNN(rs_w, 789			,"id");
			Recordset_SetNT(rs_w, "Seven-Eight-Nine"	,"val");
		Recordset_Insert(rs_w);
		rs_w = Recordset_New(db, "tbl");
			Recordset_SetNT(rs_w, "FIVE-SIX"		,"val");
		Recordset_Update(rs_w, "id = 56");
	}
	rc = sqlite_exec_printf(db, "COMMIT", NULL, NULL, NULL);
	if(rc) { DIE(); }
	{
		ST_Recordset_r* rs_r;
		for(rs_r = Recordset_Open(db, "SELECT * FROM %s ORDER BY id", "tbl");
		    rs_r;
		    rs_r = Recordset_Next(rs_r)) {
			for(iCol = 0; iCol < Recordset_Count(rs_r); iCol++) {
				if(iCol) { putchar(','); }
				printf("%s=%s",
					Recordset_ColIN(rs_r, iCol),
					Recordset_GetIT(rs_r, iCol));
			}
			putchar('\n');
		}
	}
	sqlite_close(db);
	db = NULL;
#endif//USE_SQLITE
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void test3() {
#ifdef  USE_BISON_FLEX
	FILE* fp = fopen("prog1.txt", "r");
#if     (YYDEBUG!=0)
//	yydebug = 1;	//nonzero means print parse trace
#endif/*(YYDEBUG!=0)*/
	yylex_init(fp);
	if((yyparse() != 0) || (yynerrs != 0)) { DIE(); }
	fclose(fp);
#endif//USE_BISON_FLEX
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void test4() {
#ifdef  USE_PDCURSES
	//Ql:
	//ucursesɂ[ - List 0. ȒPcursesvO hello.cv
	//(http://www.kushiro-ct.ac.jp/yanagawa/ex/2-game/01.html)
    //	initscr();	//[̊Jn
	start_color();	//J[̐ݒ
	init_pair(1, COLOR_RED, COLOR_BLUE);	//Fԍ1ԕ/nƂ
	bkgd(COLOR_PAIR(1));			//F1ftHgFƂ
	erase();	//ʕ\
	move(10, 20);
	addstr("Hello World");
	refresh();
	timeout(-1);
	getch();	//L[
    //	endwin();	//[̏I
#endif//USE_PDCURSES
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#ifdef  __CLIP_RRS_H__
static void job1(ST_RRS* pRRS) { for(;;) { putchar('1'); RRS_yield(pRRS); } }
static void job2(ST_RRS* pRRS) { for(;;) { putchar('2'); RRS_yield(pRRS); } }
static void job3(ST_RRS* pRRS) { for(;;) { putchar('3'); RRS_yield(pRRS); } }
#endif//__CLIP_RRS_H__
static void test5() {
#ifdef  __CLIP_RRS_H__
	int i;
	RRS_new_l(&pRRS, 0, job1, job2, job3, NULL);
	for(i = 0; i < 10; i++) {
		puts("0");
		RRS_yield(pRRS);
	}
	puts("");
	sleep(1);
#endif//__CLIP_RRS_H__
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//}}TEST
#ifdef  __cplusplus
#ifdef  USE_GDIPLUS
static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hDC = BeginPaint(hWnd, &ps);
			Graphics* graphics = new Graphics(hDC);
			if(graphics->GetLastStatus()) { DIE(); }
			if(graphics->Clear(Color.Red)) { DIE(); }
			wchar_t* fname = strdup_ShiftJisToUnicode("C:/usr/PIECE/HTML/IMAGE/MENULOGO.GIF");
			Image* image = new Image(fname);
			if(image->GetLastStatus()) { DIE(); }
			free(fname);
			if(graphics->DrawImage(image, 0, 0)) { DIE(); }
			delete image;
			delete graphics;
			EndPaint(hWnd, &ps);
		}
		return 0;
	}
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}
#endif//USE_GDIPLUS
#endif//__cplusplus
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int app_main(int argc, char* argv[]) {
	int exitCode = EXIT_SUCCESS;
//{{TEST
	test1();
	test2();
	test3();
	test4();
	test5();
//}}TEST
#if 0
	{
		int opt;
		opterr = 0; //IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB
		while((opt = getopt(argc, argv, "eh")) != -1) {	//R}hCIvVB
			switch(opt) {
		    #ifdef  USE_BISON_FLEX
			case 'e':
				{
					//G[Ot@C쐬B
					// - JgtH_'st@C.err'ƂOŐ鎖ɂB̓́A'lk33.exe'̎dlQlɂB
					char fname[MAX_FNAME];
					splitpath(argv[0], NULL, NULL, fname, NULL);
					makepath(err_path, NULL, NULL, fname, ".err");
					//'-e'IvVw肳ꂽAŏɊmɁÃG[Ot@C폜ĂB
					//OɐG[OcĂāA񐶐G[Oƍ댯邽߂łB
					//A'-e'IvVw肳Ȃꍇ́ÃG[Ot@C폜鏈͍sȂB
					remove(err_path);
				}
				break;
		    #endif//USE_BISON_FLEX
			case 'h':
			default:
				usage();
			}
		}
	}
	{
		char* glbuf = NULL;	//getline()pobt@
		int   glcap = 0;	//
		FILE* fp = stdin;	//̓t@Cw肳ĂȂ΁AW͂񏈗B
		do {
			if(optind < argc) {	//̓t@Cw肳Ăc
				fp = fopen(argv[optind], "r");		//̓t@CJB
				if(!fp) { error(EXIT_FAILURE, errno, "%s J܂B", argv[optind]); }
			}
			while(getline(&glbuf, &glcap, fp) != EOF) {	//sǂݍށBt@CI[łȂ΁c
				//TODO:
			}
			if(optind < argc) {	//̓t@Cw肳Ăc
				fclose(fp);	//̓t@CB
				optind++;	//̓̓t@C֐i߂B
			}
		} while(optind < argc);
		free(glbuf);	//getline()pobt@JB
	}
#endif
#ifdef  __cplusplus
#ifdef  USE_GDIPLUS
	{
		WNDCLASS wc;
		HWND hWnd;
		MSG msg;
		memset(&wc, 0, sizeof wc);
		wc.style = (CS_HREDRAW|CS_VREDRAW);
		wc.lpfnWndProc = WndProc;
		wc.hInstance = GetModuleHandle(NULL);
		wc.hCursor = LoadCursor(NULL, IDC_ARROW);
		wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
		wc.lpszClassName = program_invocation_short_name;
		if(!RegisterClass(&wc)) { DIE(); }
		hWnd = CreateWindow(
			program_invocation_short_name,
			program_invocation_short_name,
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT, CW_USEDEFAULT,
			CW_USEDEFAULT, CW_USEDEFAULT,
			NULL, NULL, wc.hInstance, NULL);
		if(!hWnd) { DIE(); }
		ShowWindow(hWnd, SW_SHOW);
		UpdateWindow(hWnd);
		while(GetMessage(&msg, NULL, 0, 0)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
#endif//USE_GDIPLUS
#endif//__cplusplus
#ifdef  __CLIP_RRS_H__
	//Round Robin Scheduler (RRS)B
	RRS_new_l(&pRRS, 0/*stacksize*/,
		job_main,	//vZWu
		//{{TODO:ɃWu֐ǉĉB}}
		NULL/*I[*/);
#endif//__CLIP_RRS_H__
#ifdef  __CLIP_MSGH_H__
	//bZ[WnhVFCNB
	MsgHsk_Init(&stMsgHsk, pRRS);
#endif//__CLIP_MSGH_H__
#ifdef  USE_DXLIB
	exitCode = cpp_main(argc, argv);	//UIWu
#endif//USE_DXLIB
	return exitCode;
}
/****************************************************************************
 *	vZWu
 ****************************************************************************/
#ifdef  __CLIP_RRS_H__
void job_main(ST_RRS* pRRS) {
	int i = 0;
	for(;;) {
		RRS_yield(pRRS);
#ifdef  _DEBUG
		syslog(LOG_DEBUG, "job#%d/%d: %d", RRS_i_job(pRRS)+1, RRS_n_job(pRRS));
#endif//_DEBUG
		printf("<%d>\n", i);
		i += 10;
	}
	exit(EXIT_SUCCESS);
}
#endif//__CLIP_RRS_H__
//{{DATA
/****************************************************************************
 *	ϐtH[}b^
 ****************************************************************************/
#ifdef  __CLIP_PRP_H__
void fnVarFmt(char* buf/*[cap]*/, int cap, int iFmt, int iVal) {
	switch(iFmt) {
	default:DIE();
	case PrpFmt_Color:
		{
#ifdef  __CLIP_ENM_H__
			snprintf(buf, cap, "%d(%s)", iVal, EnmDef_ToStr(pEnmKey, RegKey_Color, iVal));
#else //__CLIP_ENM_H__
			//'MkNamDef.bat Define.h'Ő,ҏW܂B
			static const char* const TBL_NamDef_Color[5]={
			"",     //0 Color_White
			"D(W)", //1 Color_GlayW
			"D(Z)", //2 Color_GlayB
			"",     //3 Color_Black
			"}XN", //4 Color_Mask 
			};
			if((unsigned)iVal >= ARRAY_SIZE(TBL_NamDef_Color)) { DIE(); }
			snprintf(buf, cap, "%d(%s)", iVal, TBL_NamDef_Color[iVal]);
#endif//__CLIP_ENM_H__
		}
		break;
	}
}
#endif//__CLIP_PRP_H__
//}}DATA
