/*
 *	app.c
 *
 *	P/ECEAvP[V̐^iCLiPCuŁj
 *
 *	* Tue Jul 23 21:01:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

/****************************************************************************
 *	main
 ****************************************************************************/

int main() {
#ifdef  USE_ARGS
	static char cmdline[128] = PRESCAN_STRINGIFY(PROJECT);	//ur.exevɃR}hCw肵ꍇA܂B
	char** const argv = strsplit(cmdline, " ", 0);
	int    const argc = strv_length(argv);
#else //USE_ARGS
	char** const argv = (char*[]){ PRESCAN_STRINGIFY(PROJECT), NULL };
	int    const argc = 1;
#endif//USE_ARGS
	/* ĂяovŐNɎgpꂽOݒ肵܂B */
	program_invocation_short_name = basename((program_invocation_name = argv[0]));
	/* ߑȂO߂邽߂́AOt[܂B */
	SEH_init();
	/* AvP[V܂B */
	app_init(argc, argv);
	/* C[vs܂B */
	app_main(argc, argv);
	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static const uint8_t TBL_TapMxrChMask[(TapLogCh_Max+1)]={
BIN8(00000111),	//_0ɓKpзقޯϽ	ðBGM
BIN8(00000110),	//_1ɓKpзقޯϽ	oBGM
BIN8(00000110),	//_2ɓKpзقޯϽ	oSE
BIN8(00000110),	//_3ɓKpзقޯϽ	oSE
BIN8(00000110),	//_4ɓKpзقޯϽ	oSE
BIN8(00000110),	//_5ɓKpзقޯϽ	UI
BIN8(00000110),	//_6ɓKpзقޯϽ	UI
BIN8(00000100)};//_7ɓKpзقޯϽ	װ
//        ||+--- TAPз1:oBGMĐ	Ώۘ_:ðBGM
//        |+---- TAPз2:װĐ	Ώۘ_:װȊO
//        +----- TAPз0:İ		Ώۘ_:S
static void set_att(int iLogCh, ST_TapLogCh* pLogCh) {	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ𤂱̘_ق䂵Ă޲قɓKp	(pLogCh->iDevCh==UINT8_MAX)̎ɌĂяoĂ͂Ȃ
	int iAtt=pLogCh->iAtt;					//̘_ق̌				//2حё
	iAtt+=TapMxr_GetAtt(pTapMxr,&TBL_TapMxrChMask[iLogCh]);	//̘_قɓKpзق̍v	//1حё
	sound_att(pLogCh->iDevCh,iAtt);				//̘_ق䂵Ă޲قɤL2_̍vʂKp
}
static void TapMxr_TimerProc(void* iTime) {	//TAPзpϊ
	int iDevCh,iLogCh;
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Bg2)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg,64, 0,  0);}	//_1ŉoBGMĐȂΤðBGM𑦏		
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Stg, 0,64,500);}	//_1ŉoBGM~ȂΤðBGM0.5bŕA		{{TODO:عݒ}}
	if(TapSeq_GetLogCh(pTapSeq,TapLogCh_Err)->iPhr!=UINT16_MAX){TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err,64, 0,  0);}	//_7ŴװĐȂΤðBGM,oBGM,SE𑦏	
	else                                                       {TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Err, 0, 0,  0);}	//_7Ŵװ~ȂΤðBGM,oBGM,SE𑦕A	
	TapMxr_Exec(pTapMxr,(int)iTime);	//TAPзs
	for(iDevCh=0;iDevCh<pTapSeq->pInfo->nDevCh;iDevCh++){	//޲ق̌ʂݒ肷
		iLogCh=TapSeq_GetDevCh(pTapSeq,iDevCh)->iLogCh;
		if(iLogCh!=UINT8_MAX){		//޲ق𐧌䂵Ă_قL΁c
			ST_TapLogCh* pLogCh=TapSeq_GetLogCh(pTapSeq,iLogCh);
			set_att(iLogCh,pLogCh);	//̘_ق̌ʂƤ̘_قɓKpзق̍vʂ޲قɓKp
		}
	}
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static void TapSeq_fnPlay(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
	sound_play(pLogCh->iDevCh,sound_table[pLogCh->iPhr],pLogCh->iLoop?pLogCh->iLoop:-1);
}
static void TapSeq_fnStop(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	sound_stop(pLogCh->iDevCh);
}
static void TapSeq_fnLoop(int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnEnd(int iLogCh, ST_TapLogCh* pLogCh) {
	/** no job **/
}
static void TapSeq_fnCtrl(int iLogCh, ST_TapLogCh* pLogCh) {
	if(pLogCh->iDevCh==UINT8_MAX){return;}
	set_att(iLogCh,pLogCh);
}
static int TapSeq_fnGetPhrTime(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int TapSeq_fnGetPhrNext(int iPhr) {
#ifdef  USE_REG
    #ifdef  RegKey_Next
	//t[YV[PXWXg擾ꍇB
	iPhr++;			//sound.h0x[X,t[YV[PX1x[XȂ̂ŁAꎞI1x[XɕϊBڍׂ́A/clip/tool/dPhrDefC/winapp.c QƂB
	iPhr = REG_get_value_l(TBL_RegTbl,RegKey_PhrDef,iPhr,RegKey_Next,-1)<<8>>8;	//ʏt[Y(-1),ԃt[Y(<>iPhr),[vt[Y(=iPhr),St[Y(-2)
	if(iPhr>=0){iPhr--;}	//ʏt[Y(-1),,St[Y(-2)ȊOȂ΁Asound.h̒l(=0x[X)ɖ߂B
	return iPhr;
    #else //RegKey_Next
	//t[YV[PXWXg擾邪ASĒʏt[Yłꍇ'RegKey_Next'`ȂB
	return -1;
    #endif//RegKey_Next
#else /*USE_REG*/
	//t[YV[PXvOŏꍇB
	return (iPhr==SND_BGM_1G)||(iPhr==SND_BGM_ST)?iPhr:-1;
#endif/*USE_REG*/
}
static void TapSeq_TimerProc(void* iTime) {
	TapSeq_Exec(pTapSeq,(int)iTime);
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now/FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_NVLOG
void nvlog_(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	nvlog_vprintf(nvlog, fmt, ap);
	va_end(ap);
	pceFileWriteSct(&faNvLog, nvlog, 0, NVLOG_SIZE);
}
#endif//USE_NVLOG

#ifdef  USE_TCL
//srand seed
static int Tcl_SrandCmd(Tcl_Interp* iPtr) {
	if((iPtr->argc < 1) || (iPtr->argc > 2)) { DIE(); }
	srand((iPtr->argc == 2) ? atoi(iPtr->argv[1]) : time(NULL));
	return TCL_OK;
}
//rand
static int Tcl_RandCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	iPtr->result = strdup_printf("%d", rand());
	return TCL_OK;
}
//log string
static int Tcl_LogCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { DIE(); }
#ifdef  USE_LOG_BUFFER
	LogBuf_Print(pLogBuf, iPtr->argv[1]);
	update();
#else //USE_LOG_BUFFER
	TRACE("%s\n", iPtr->argv[1]);
#endif//USE_LOG_BUFFER
	return TCL_OK;
}
//schedule
static int Tcl_ScheduleCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	schedule();
	return TCL_OK;
}
#endif//USE_TCL

void app_init(int argc, char* argv[]) {
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* TAPз܂ */
#ifdef  USE_SOUND_MIXER
	{
		pTapMxr=TapMxr_New(TapMxrCh_Max+1);
		timer_start(100,TapMxr_TimerProc,(void*)100);	//TAPзpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TAPݻ܂ */
#ifdef  USE_SOUND_SEQUENCER
	{
		static struct {
			ST_TapSeqInfo stTapSeqInfo;
			const uint8_t* TBL_TapSet[(TapLogCh_Max+1)];
		} stTapSeqInfo = {{
			SOUND_COUNT,			//nPhr
			TapDevCh_Max+1,			//nDevCh
			TapLogCh_Max+1,			//nLogCh
			TapSeqCh_Max+1,			//nSeqCh
			1000/FPS,			//iCont
			31/**/,			//nEvt
			~(1<<TapEvt_Ctrl)/*ύX*/,	//iEvtMsk
			TapSeq_fnPlay,
			TapSeq_fnStop,
			TapSeq_fnLoop,
			TapSeq_fnEnd,
			TapSeq_fnCtrl,
			TapSeq_fnGetPhrTime,
			TapSeq_fnGetPhrNext,
		},{
			(uint8_t[]){TapDevCh_Bg1,-1},			//ðBGM
			(uint8_t[]){TapDevCh_Bg2,-1},			//oBGM
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Se1,TapDevCh_Se2,-1},	//oSE
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//UI
			(uint8_t[]){TapDevCh_Ui1,TapDevCh_Ui2,-1},	//װ
		}};
		pTapSeq=TapSeq_New(&stTapSeqInfo.stTapSeqInfo);
		timer_start(10,TapSeq_TimerProc,(void*)10);	//޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* LEDV[PT܂B */
#ifdef  USE_LED
	pLedSeq = LedSeq_New(LedCh_Max + 1, LedSeqCh_Max + 1);
#endif//USE_LED

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static ST_EvtTmrFunc stEvtTmrFunc = { EvtTmr_onEvent };
		pEvtTmr = EvtTmr_New(EvtTmrNo_Max+1);	//ς
		EvtTmr_AddFunc(pEvtTmr, &stEvtTmrFunc);	//ď֐o^
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_New(CntCh_Max+1);
#endif/*USE_COUNTER_MANAGER*/

	/* JE^܂B */
#ifdef  USE_DURATION_COUNTER
	pDurCnt = DurCnt_New();
#endif/*USE_DURATION_COUNTER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

	//sOobt@܂B
#ifdef  USE_NVLOG
	{
		time_t t;
		pceFileCreate("nvlog.bin", NVLOG_SIZE);
		pceFileOpen(&faNvLog, "nvlog.bin", FOMD_WR);
		pceFileReadSct(&faNvLog, nvlog, 0, NVLOG_SIZE);	//ÕOɒǉ鎖ɂB̏ԂJnꍇ͂̍s폜B
		time(&t);
		NVLOG("Start at %s", strstrip(ctime(&t)));
	}
#endif//USE_NVLOG

#ifdef  USE_TCL
	//TclC^v^邽߂ɁAIɃK[x[WRNVsB
#if     defined(GC_LEVEL)
/*K{*/timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBʏGCTclC^v^gpꍇ́A̍ssȂƋɒ[ɒxȂB
#elif   defined(BITMAP_GC_UNIT)
//C	timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBBitmap GCgpꍇ͋ɒ[ɒx͂ȂA̍ssł͂B
#else //defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	#error TclC^v^̓K[x[WRN^[̕pK{łB
#endif//defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	//TclC^v^쐬B
	iPtr = Tcl_CreateInterp();
	//ėpIȃAvP[V`̃R}ho^B
	Tcl_CreateCommand(iPtr, "srand",    Tcl_SrandCmd,    NULL);
	Tcl_CreateCommand(iPtr, "rand",     Tcl_RandCmd,     NULL);
	Tcl_CreateCommand(iPtr, "log",      Tcl_LogCmd,      NULL);
	Tcl_CreateCommand(iPtr, "schedule", Tcl_ScheduleCmd, NULL);
#endif//USE_TCL

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef  USE_CBKQUE
	/* R[obNL[܂B */
	pCbkQue = CbkQue_New(2048/**/);	//CbkQue_sprite_draw()x100񕪂炢łBCbkQue_render_printf()gƂƏ܂B
#endif//USE_CBKQUE

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

#if     (defined(USE_ENM)&&defined(USE_REG))
	/* 񋓒`L[擾܂B */
	pEnmKey = REG_open_key(TBL_RegTbl, RegKey_EnmDef);
#endif//(defined(USE_ENM)&&defined(USE_REG))

#ifdef  USE_PRP
	/* vpeBe[uL[擾܂B */
	pPrpKey = REG_open_key(TBL_RegTbl, RegKey_PrpTbl);
	if(!pPrpKey) { DIE(); }
	/* vpeBwb_܂B */
	PrpHdr_init(phApp, pPrpKey, PrpTbl_App);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_PRP

#ifdef  USE_FSM
	/* Lԋ@B}bvL[擾܂B */
	pFsmKey = REG_open_key(TBL_RegTbl, RegKey_FsmMap);
	if(!pFsmKey) { DIE(); }
	/* Lԋ@B܂B */
	FsmObj_Init(&foApp, pFsmKey, FsmMap_App);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_FSM

#ifdef  USE_ACT
	/* AN^[IuWFNg܂B */
	aoApp = ActObj_New(NULL/*pParent*/, NULL/*pFsmKey*/, 0/*iFsmMap*/, NULL/*pPrpKey*/, 0/*iPrpTbl*/, 0/*nDataBytes*/);	//ڰĂƂ1`܂KvɉĒ`ǉĉ
#endif//USE_ACT

#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)܂B */
	RRS_new_l(&pRRS, 0/*stacksize*/,	//{{TODO:ύX}}
		//{{TODO:ɃWu֐񋓂ĉB}}
		NULL/*I[*/);
#endif//USE_RRS
#ifdef  USE_MSGHSK
	//bZ[WnhVFCNB
	MsgHsk_Init(&stMsgHsk, pRRS);
#endif//USE_MSGHSK

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void app_exit() {
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void update() {
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void vidrec() {
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void schedule() {
#ifdef  USE_RRS
	/* Round Robin Scheduler (RRS)B */
	RRS_yield(pRRS);
#endif//USE_RRS

#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef  USE_DURATION_COUNTER
	/* JE^B */
	DurCnt_Exec(pDurCnt);
#endif/*USE_DURATION_COUNTER*/

#ifdef  USE_LED
	/* LEDV[PTB */
	{
		unsigned char Buffer[LedCh_Max + 1];
		memset(Buffer, 1/**/, sizeof Buffer);
		LedSeq_Exec(pLedSeq, Buffer);
		//{{TODO:Buffer[]ʂɕ`悵Ă}}
	}
#endif//USE_LED

#ifdef  USE_CBKQUE
	/* R[obNL[B */
	CbkQue_Invoke(pCbkQue);	//o^Ăm[hSČĂяoBAvP[VɂẮȀCbkQue_InvokePri()𕡐񕪂ČĂяo悤ɕύXĉB
	CbkQue_Clear(pCbkQue);	//R[obNL[̏Ԃɖ߂BAvP[VɂẮAxo^R[obNL[xg񂷏ꍇ́A̍s폜ĉB
#endif//USE_CBKQUE

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */

/*{{AvP[VL̎*/
    //	surface_clear(&surface, 0/*ύX*/);	//Öق̃T[tFCXNAsB̏demo_main()̏ƏՓ˂̂ŁAdemo_main()ƓɎgp鎖͏oȂB]āAsimplify.sedɂdemo_main()폜ɁȀL悤ɂBAvP[VɂẮAÖق̃T[tFCXNAsvȏꍇ́A̍s폜ĉB
/*}}AvP[VL̎*/
}

/****************************************************************************
 *	delay
 ****************************************************************************/

void delay(int frame) {
	while(frame > 0) {
		schedule();
		frame--;
	}
}

/****************************************************************************
 *	demo_main
 ****************************************************************************/

#ifdef USE_IDLE
static int idle_proc(void* param) {
	/* {{TODO:ŎԂ̂鏈s}} */
	return 0;
}
#endif /*USE_IDLE*/

#ifdef  USE_TASK
static int task_proc(void* param) {
	int* pval = param;
	for(;;) { (*pval)++; task_yield(); }
	return 0;
}
#endif/*USE_TASK*/

#ifdef  USE_LOT
static int fnRnd(int* rndval) {
	return (*rndval)++;
}
#endif//USE_LOT

#ifdef  USE_DIR
static void fnAct_Lcd(int DirLyr, int ActNo) {
	const char* s;
	switch(ActNo) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- LcdUi ---
	case LcdUi_TjUi:    s = "TjUi";   break;//ʏUI
	case LcdUi_BoUi:    s = "BoUi";   break;//ްŽUI
	//--- LcdCmd ---
	case LcdCmd_TjBgSc: s = "TjBgSc"; break;//ʏBG۰
	case LcdCmd_TjBgTe: s = "TjBgTe"; break;//ʏBG~
	case LcdCmd_TjAcAl: s = "TjAcAl"; break;//ʏ
	case LcdCmd_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case LcdCmd_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case LcdCmd_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case LcdCmd_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case LcdCmd_TjAcBe: s = "TjAcBe"; break;//ʏ
	case LcdCmd_TjAcSk: s = "TjAcSk"; break;//ʏ
	case LcdCmd_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case LcdCmd_Bonus:  s = "Bonus";  break;//ްŽBG
	case LcdCmd_BoEnd:  s = "BoEnd";  break;//ްŽI
	case LcdCmd_BoGet:  s = "BoGet";  break;//ްŽGet
	case LcdCmd_BoAcTe: s = "BoAcTe"; break;//ްŽ~
	case LcdCmd_BoAcKt: s = "BoAcKt"; break;//ްŽ]
	}
	render_rectangle_fill(&render, 0,10*DirLyr, DISP_X,10, 0);
	render_string(&render, 0,10*DirLyr, s, 0,3);
}
static void fnAct_Lmp(int DirLyr, int ActNo) {
	const char* s;
	switch(ActNo) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- LedCmd ---
	case LedCmd_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case LedCmd_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case LedCmd_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case LedCmd_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case LedCmd_TjAcBe: s = "TjAcBe"; break;//ʏ
	case LedCmd_TjAcSk: s = "TjAcSk"; break;//ʏ
	case LedCmd_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case LedCmd_Bonus:  s = "Bonus";  break;//ްŽBG
	case LedCmd_BoEnd:  s = "BoEnd";  break;//ްŽI
	case LedCmd_BoGet:  s = "BoGet";  break;//ްŽGet
	}
	render_rectangle_fill(&render, 0,10*DirLyr, DISP_X,10, 0);
	render_string(&render, 0,10*DirLyr, s, 0,3);
}
static void fnAct_Snd(int DirLyr, int ActNo) {
	const char* s;
	switch(ActNo) {
	default: DIE(); break;
	case 0: s = ""; break;
	//--- SndBgm ---
	case SndBgm_Bonus: s = "Bonus";  break;//ްŽBGM
	case SndBgm_BoEnd: s = "BoEnd";  break;//ްŽI
	//--- SndSe ---
	case SndSe_TjAcKz: s = "TjAcKz"; break;//ʏCt
	case SndSe_TjAcHz: s = "TjAcHz"; break;//ʏʽ
	case SndSe_TjAcBo: s = "TjAcBo"; break;//ʏްŽ
	case SndSe_TjAcRp: s = "TjAcRp"; break;//ʏڲ
	case SndSe_TjAcBe: s = "TjAcBe"; break;//ʏ
	case SndSe_TjAcSk: s = "TjAcSk"; break;//ʏ
	case SndSe_TjAcCh: s = "TjAcCh"; break;//ʏذ
	case SndSe_BoAcKt: s = "BoAcKt"; break;//ްŽ]
	case SndSe_BoGet:  s = "BoGet";  break;//ްŽGet
	}
	render_rectangle_fill(&render, 0,10*DirLyr, DISP_X,10, 0);
	render_string(&render, 0,10*DirLyr, s, 0,3);
}
static void fnAct_Prg(int DirLyr, int ActNo) {
	const char* s;
	switch(ActNo) {
	default: DIE(); break;
	case 0: s = ""; break;
	}
	render_rectangle_fill(&render, 0,10*DirLyr, DISP_X,10, 0);
	render_string(&render, 0,10*DirLyr, s, 0,3);
}
static void fnAct(int ActNo/*[31]=I[o[t[,[30:24]=`,[23:0]=oԍ*/) {
	static void (*const TBL_fnAct[])(int DirLyr/*oC*/, int ActNo/*oԍ*/) = {
		fnAct_Lcd,//0 t(UI)
		fnAct_Lcd,//1 t()
		fnAct_Lcd,//2 t(O)
		fnAct_Lmp,//3 ()
		fnAct_Lmp,//4 (O)
		fnAct_Snd,//5 (BGM)
		fnAct_Snd,//6 (SE)
		fnAct_Prg,//7 ۸
	};
	int DirLyr = (unsigned char)(ActNo >> 16);
	if(ActNo < 0) { return; }//I[o[t[ɑMꂽR}h͏ȂɂB̔f̓AtP[Vł菈Ă\ȂBoV[PT̊֐ċAIɌĂяoĂ͂ȂB
	if((unsigned)DirLyr >= ARRAY_SIZE(TBL_fnAct)) { DIE(); }
	(*TBL_fnAct[DirLyr])(DirLyr, (unsigned short)ActNo);
}
#endif//USE_DIR

#ifdef  USE_FSM
typedef struct _ST_FsmTest {
	int x,y;
	ST_FsmObj stFsmObj;
} ST_FsmTest;
static ST_FsmTest stFsmTest;
FSMFUNC_(Map1_State1_entry) { TRACE("FsmFunc_Map1_State1_entry\n"); }
FSMFUNC_(Map1_State1_exit) { TRACE("FsmFunc_Map1_State1_exit\n"); }
FSMFUNC_(Map1_State1_Trans1_guard) {
	ST_FsmTest* const pFsmTest = CONTAINING_RECORD(pFsmObj,ST_FsmTest,stFsmObj);
	TRACE("FsmFunc_Map1_State1_Trans1_guard\n"); return pFsmTest->x == 0; }
FSMFUNC_(Map1_State2_Trans2_guard) {
	ST_FsmTest* const pFsmTest = CONTAINING_RECORD(pFsmObj,ST_FsmTest,stFsmObj);
	TRACE("FsmFunc_Map1_State2_Trans2_guard\n"); return pFsmTest->y != 0; }
FSMFUNC_(Map1_State1_Trans1_act) { TRACE("FsmFunc_Map1_State1_Trans1_act\n"); }
FSMFUNC_(Map1_State2_Trans2_act) { TRACE("FsmFunc_Map1_State2_Trans2_act\n"); }
FSMFUNC_(Map1_default_act) {
	TRACE("FsmFunc_Map1_default_act\n");
	FsmObj_SetState(pFsmObj,FsmState_State1); }
#endif//USE_FSM

int demo_main() {
#ifdef USE_IDLE
	idle_init(idle_proc, NULL, 0);
#endif /*USE_IDLE*/

#ifdef  USE_TASK
	{
		int val = 0;
		TASK* task = task_create(INT_MIN, task_proc, &val, 0);
		for(;;) {
			schedule();
			if(joy & TRG_A) { break; }
			surface_clear(&surface, 0);
			render_printf(&render, 0,0, 0,3, "%d", val);
			task_yield();
		}
		task_kill(task);
	}
#endif/*USE_TASK*/

#ifdef USE_MUSIC
	{
		/* SAMPLE */
		extern /*const*/ unsigned char C350[];
		PlayMusic(C350);
	}
#endif /*USE_MUSIC*/

#ifdef  USE_BISON_FLEX
	{
		/* SAMPLE */
		FILE* fp = fopen("program.txt", "r");
#if     (YYDEBUG!=0)
	//	yydebug = 1; /* nonzero means print parse trace */
#endif/*(YYDEBUG!=0)*/
		yylex_init(fp);
		if((yyparse() != 0) || (yynerrs != 0)) DIE();
		fclose(fp);
	}
#endif/*USE_BISON_FLEX*/

#ifdef  USE_LOT
	{
		/* SAMPLE */
		int hitcnt[(Sym_Max+1)]={0};
		int rndval=0;
		LotRom_Init(TBL_LotTblNo, fnRnd, &rndval);//I\ROMǗJn
	    #if     defined(TRACE_ON) && (TRACE_ON)
		LotRom_BeginLog();//۸ނJn
	    #endif//defined(TRACE_ON) && (TRACE_ON)
		while(rndval <= USHRT_MAX) {
			int hitval = LotRom_draw_l(LotTblNo_Nor/*ʏ펞*/, 2/*߯V*/,6/*ݒ6*/,-1/*I[*/);
			if(hitval == -1) { hitval = Sym_Mis; }
			if((unsigned)hitval >= ARRAY_SIZE(hitcnt)) { DIE(); }
			hitcnt[hitval]++;
		}
		surface_clear(&surface, 0);
		render_printf(&render, 0,10*0, 0,3, "Sym_Mis %5d\n", hitcnt[Sym_Mis]);
		render_printf(&render, 0,10*1, 0,3, "Sym_Rep %5d\n", hitcnt[Sym_Rep]);
		render_printf(&render, 0,10*2, 0,3, "Sym_Bel %5d\n", hitcnt[Sym_Bel]);
		render_printf(&render, 0,10*3, 0,3, "Sym_Che %5d\n", hitcnt[Sym_Che]);
		render_printf(&render, 0,10*4, 0,3, "Sym_Bon %5d\n", hitcnt[Sym_Bon]);
	    #if     defined(TRACE_ON) && (TRACE_ON)
		LotRom_DumpLog(stderr);//۸ނo͂
		LotRom_EndLog();//۸ނILotRom_Free()̒ŎIɍŝŤȗ\ł
	    #endif//defined(TRACE_ON) && (TRACE_ON)
		LotRom_Free();//I\ROMǗI顱عݏIƓȂΤ͕̏svł
		for(;;) { schedule(); if(joy & TRG_A) { break; } }
	}
#endif/*USE_LOT*/

#ifdef  USE_DIR
	{
		/* SAMPLE */
		const unsigned char* const TBL_DirSeq = (const unsigned char*)&TBL_DirTblNo[TBL_DirTblNo[0]];
		int selDirTblNo = 0, selTrig = 1;
		DirSeq_Init(fnAct);
		surface_clear(&surface, 0);
		for(;;) {
			schedule();
			DirSeq_Exec();
			if((joy & PAD_A) && (joy & PAD_B)) { break; }
			if(joy & TRG_UP) { if(--selDirTblNo < 0) { selDirTblNo = DirTblNo_Max; } }//oðٔԍI(-)
			if(joy & TRG_DN) { if(++selDirTblNo > DirTblNo_Max) { selDirTblNo = 0; } }//oðٔԍI(+)
			if(joy & TRG_LF) { if(--selTrig < 1) { selTrig = DirTrg_Max; } }//ضޑI(-)
			if(joy & TRG_RI) { if(++selTrig > DirTrg_Max) { selTrig = 1; } }//ضޑI(+)
			if(joy & TRG_A) { DirSeqCh_SetTbl(0, selDirTblNo ? &TBL_DirSeq[TBL_DirTblNo[selDirTblNo]] : NULL); selTrig = 1; }//oðپı
			if(joy & TRG_B) { DirSeq_SendTrig(selTrig); if(++selTrig > DirTrg_Max) { selTrig = DirTrg_Max; } }//ضޑM
			render_rectangle_fill(&render, 0,DISP_Y-10, DISP_X,10, 0);
			render_printf(&render, 0,DISP_Y-10, 0,3, "DirTblNo %2d / Trigger %2d", selDirTblNo, selTrig);
		}
	}
#endif//USE_DIR

#if     (defined(USE_SOUND_SEQUENCER)&&defined(USE_SOUND_MIXER))
	{
		TapMxrCh_SetAtt(pTapMxr,TapMxrCh_Tlv,3,0,0);	//İقݒ肷(3dB)
		TapSeqCh_PlayNo(pTapSeq,TapSeqCh_Stg,TBL_TapSeqNo,TapSeqNo_Bgm1g);	//ðBGMٰߍĐ
		for(;;){
			schedule();
			if(joy&TRG_UP){TapSeqCh_PlayNo(pTapSeq,TapSeqCh_Dir,TBL_TapSeqNo,TapSeqNo_BgmSt);}	//oBGMٰߍĐ顂̊ԤðBGM͏
			if(joy&TRG_DN){TapSeqCh_PlayNo(pTapSeq,TapSeqCh_Dir,TBL_TapSeqNo,TapSeqNo_BgmStFO);}	//oBGM̪ޱĂ顂̌㤽ðBGMA
			if(joy&TRG_LF){TapSeqCh_PlayNo(pTapSeq,TapSeqCh_Dir,TBL_TapSeqNo,TapSeqNo_SeBtn);}	//SE1Đ顂ͤ̂ǂ̉ɂeȂ
			if(joy&TRG_RI){TapSeqCh_PlayNo(pTapSeq,TapSeqCh_Err,TBL_TapSeqNo,TapSeqNo_SeErr);}	//װĐ顂̊Ԥ̉Sď
			if(joy&TRG_A){TapLogCh_Play(pTapSeq,TapLogCh_Err,SND_SE_ERR,1,0,0);}	//ݻقg킸ɤ_قw肵ĤĐ/~鎖o
			if(joy&TRG_B){break;}
		}
	}
#endif//(defined(USE_SOUND_SEQUENCER)&&defined(USE_SOUND_MIXER))

#ifdef  USE_EVENT_TIMER
	{
		for(;;) {
			schedule();
			if(joy & TRG_UP) { EvtTmr_StartNo(pEvtTmr,EvtTmrNo_Sample1,TBL_EvtTmrNo,EvtTmrNo_Sample1); }	//#1Jn
			if(joy & TRG_DN) { EvtTmr_Stop(pEvtTmr,EvtTmrNo_Sample1); }					//#1~
			if(joy & TRG_LF) { EvtTmr_StartNo(pEvtTmr,EvtTmrNo_Sample2,TBL_EvtTmrNo,EvtTmrNo_Sample2); }	//#2Jn
			if(joy & TRG_RI) { EvtTmr_Stop(pEvtTmr,EvtTmrNo_Sample2); }					//#2~
			if(joy & TRG_A ) { break; }
		}
	}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	{
		//lݒ
		CntMgr_SetVal(pCntMgr, CntCh_1P,    0, 0, 0);//l=   0
		CntMgr_SetVal(pCntMgr, CntCh_2P,    0, 0, 0);//l=   0
		CntMgr_SetVal(pCntMgr, CntCh_HI, 1000, 0, 0);//l=1000
		CntMgr_SetVal(pCntMgr, CntCh_CR, 1000, 0, 0);//l=1000
		//ڕWlݒ
		CntMgr_SetVal(pCntMgr, CntCh_1P, 1000, 1000, SEC( 5));// 5b01000ɕω
		CntMgr_SetVal(pCntMgr, CntCh_2P, 1000, 1000, SEC(10));//10b01000ɕω
		CntMgr_SetVal(pCntMgr, CntCh_HI,    0, 1000, SEC( 5));// 5b10000ɕω
		CntMgr_SetVal(pCntMgr, CntCh_CR,    0, 1000, SEC(10));//10b10000ɕω
		for(;;) {
		    //	uint16_t ValNow[(CntCh_Max+1)];
			schedule();
			surface_clear(&surface, 0);
		    //	CntMgr_GetValAll(pCntMgr, ValNow);
			render_printf(&render, 0, 0, 0,3, "%d", CntMgr_GetVal(pCntMgr, CntCh_1P)/*ValNow[CntCh_1P]*/);
			render_printf(&render, 0,10, 0,3, "%d", CntMgr_GetVal(pCntMgr, CntCh_2P)/*ValNow[CntCh_2P]*/);
			render_printf(&render, 0,20, 0,3, "%d", CntMgr_GetVal(pCntMgr, CntCh_HI)/*ValNow[CntCh_HI]*/);
			render_printf(&render, 0,30, 0,3, "%d", CntMgr_GetVal(pCntMgr, CntCh_CR)/*ValNow[CntCh_CR]*/);
			if(joy & TRG_A) { break; }
		}
	}
#endif/*USE_COUNTER_MANAGER*/

#ifdef  USE_FSM
	{
		FsmObj_Init(&stFsmTest.stFsmObj,REG_open_key_l(TBL_RegTbl,RegKey_FsmMap,-1),FsmMap_Map1);	//State1
		FsmObj_ApplyTrans(&stFsmTest.stFsmObj,FsmTrans_Trans1,NULL);	//State1Trans1JڂɂState2
		FsmObj_ApplyTrans(&stFsmTest.stFsmObj,FsmTrans_Trans2,NULL);	//State2Trans2GuardɂState2̂܂
		FsmObj_ApplyTrans(&stFsmTest.stFsmObj,FsmTrans_Trans1,NULL);	//Map1defaultJڂɂState1
	}
#endif//USE_FSM

#ifdef  USE_PRP
	//{IȊ֐̎gp
	{
		//IȃvpeBe[u̗
		void* ptTable=PrpTbl_new(pPrpKey,PrpTbl_Table1);
		//XJϐݒ/擾
		              PrpTbl_set_l( pPrpKey,PrpTbl_Table1,ptTable,0,123,PrpVar_VarA,-1);
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,    PrpVar_VarA,-1));
		//zϐݒ/擾
		              PrpTbl_set_l( pPrpKey,PrpTbl_Table1,ptTable,0,456,PrpVar_VarB,5,-1);
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,    PrpVar_VarB,5,-1));
		              PrpTbl_set_l( pPrpKey,PrpTbl_Table1,ptTable,0,789,PrpVar_VarB,  -1);	//zϐɑ΂CfNXȗset,y,init\łBSvfɑ΂set,y,init܂B
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,    PrpVar_VarB,9,-1));
		//^Cvϐݒ/擾/ď/擾
		              PrpTbl_set_l( pPrpKey,PrpTbl_Table1,ptTable,0,50,PrpVar_VarD,1,2,3,-1);
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,   PrpVar_VarD,1,2,3,-1));
		              PrpTbl_init_l(pPrpKey,PrpTbl_Table1,ptTable,0,   PrpVar_VarD,0,1,2,-1);	//[0,1,2]ĂA
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,   PrpVar_VarD,1,2,3,-1));	//[1,2,3]͕ςȂB
		              PrpTbl_init_l(pPrpKey,PrpTbl_Table1,ptTable,0,   PrpVar_VarD,      -1);	//SvfύXƁA
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table1,ptTable,0,   PrpVar_VarD,1,2,3,-1));	//[1,2,3]ςB
		free(ptTable);
	}
	{
		//ÓIȃvpeBe[u̗
		static PrpTbl_def(Table2,ptTable2);
		PrpTbl_init(pPrpKey,PrpTbl_Table2,ptTable2,0);
		//e[uϐݒ/擾/ď
		              PrpTbl_set_l( pPrpKey,PrpTbl_Table2,ptTable2,0,199,PrpVar_VarB,3,4,PrpVar_VarC,-1);	//ptTable2.VarB[3,4].VarCݒ
		printf("%d\n",PrpTbl_get_l( pPrpKey,PrpTbl_Table2,ptTable2,0,    PrpVar_VarB,3,4,PrpVar_VarC,-1));	//ptTable2.VarB[3,4].VarC擾
		              PrpTbl_init_l(pPrpKey,PrpTbl_Table2,ptTable2,0,    PrpVar_VarB,3,4,PrpVar_VarC,-1);	//ptTable2.VarB[3,4].VarCď
		              PrpTbl_init_l(pPrpKey,PrpTbl_Table2,ptTable2,0,    PrpVar_VarB,3,4,            -1);	//ptTable2.VarB[3,4]ď
		              PrpTbl_init_l(pPrpKey,PrpTbl_Table2,ptTable2,0,    PrpVar_VarB,                -1);	//ptTable2.VarB̑Svfď
	}
	//[eBeB֐̎gp
	{
		//IȃvpeBe[u̗
		ST_PrpHdr* pPrpHdr=PrpHdr_new(pPrpKey,PrpTbl_Table1);
		//XJϐݒ/擾
		              PrpHdr_set_l( pPrpHdr,123,PrpVar_VarA,-1);
		printf("%d\n",PrpHdr_get_l( pPrpHdr,    PrpVar_VarA,-1));
		//zϐݒ/擾
		              PrpHdr_set_l( pPrpHdr,456,PrpVar_VarB,5,-1);
		printf("%d\n",PrpHdr_get_l( pPrpHdr,    PrpVar_VarB,5,-1));
		              PrpHdr_set_l( pPrpHdr,789,PrpVar_VarB,  -1);	//zϐɑ΂CfNXȗset,y,init\łBSvfɑ΂set,y,init܂B
		printf("%d\n",PrpHdr_get_l( pPrpHdr,    PrpVar_VarB,9,-1));
		//^Cvϐݒ/擾/ď/擾
		              PrpHdr_set_l( pPrpHdr,50,PrpVar_VarD,1,2,3,-1);
		printf("%d\n",PrpHdr_get_l( pPrpHdr,   PrpVar_VarD,1,2,3,-1));
		              PrpHdr_init_l(pPrpHdr,   PrpVar_VarD,0,1,2,-1);	//[0,1,2]ĂA
		printf("%d\n",PrpHdr_get_l( pPrpHdr,   PrpVar_VarD,1,2,3,-1));	//[1,2,3]͕ςȂB
		              PrpHdr_init_l(pPrpHdr,   PrpVar_VarD,      -1);	//SvfύXƁA
		printf("%d\n",PrpHdr_get_l( pPrpHdr,   PrpVar_VarD,1,2,3,-1));	//[1,2,3]ςB
		free(pPrpHdr);
	}
	{
		//ÓIȃvpeBe[u̗
		static PrpHdr_def(Table2,phTable2);
		PrpHdr_init(phTable2,pPrpKey,PrpTbl_Table2);
		//e[uϐݒ/擾/ď
		              PrpHdr_set_l( phTable2,199,PrpVar_VarB,3,4,PrpVar_VarC,-1);	//phTable2.VarB[3,4].VarCݒ
		printf("%d\n",PrpHdr_get_l( phTable2,    PrpVar_VarB,3,4,PrpVar_VarC,-1));	//phTable2.VarB[3,4].VarC擾
		              PrpHdr_init_l(phTable2,    PrpVar_VarB,3,4,PrpVar_VarC,-1);	//phTable2.VarB[3,4].VarCď
		              PrpHdr_init_l(phTable2,    PrpVar_VarB,3,4,            -1);	//phTable2.VarB[3,4]ď
		              PrpHdr_init_l(phTable2,    PrpVar_VarB,                -1);	//phTable2.VarB̑Svfď
	}
	//gݍ'Double'^̎gp
	{
		//IȃvpeBe[u̗
		ST_PrpHdr* pPrpHdr=PrpHdr_new(pPrpKey,PrpTbl_Table3);
		              PrpHdr_fset_l(pPrpHdr,1.23,PrpVar_VarA,  -1);
		printf("%g\n",PrpHdr_fget_l(pPrpHdr,     PrpVar_VarA,  -1));
		              PrpHdr_fset_l(pPrpHdr,2.34,PrpVar_VarB,0,-1);
		              PrpHdr_fset_l(pPrpHdr,3.45,PrpVar_VarB,1,-1);
		PrpHdr_dump(stderr,pPrpHdr,NULL,0);	//_v̎gp
		free(pPrpHdr);
	}
#endif//USE_PRP

	for(;;) {
		schedule();
		surface_clear(&surface, 1);

#ifdef USE_TCPIP
		{
			/* SAMPLE */
			if(joy & TRG_A) tcpip_config();
		}
#endif /*USE_TCPIP*/

#ifdef USE_SPRITE
		{
			/* SAMPLE */
			sprite_draw(0, 0, SPR_SPR4F/*O*/, 0);
			sprite_draw(8, 0, SPR_SPR4B/*K*/, 0);
		}
#endif /*USE_SPRITE*/

#ifdef USE_3D
		{
			/* SAMPLE */
			extern const MESH MESH_CUBE; /* mqo/cube.pmx */
			extern const WIRE WIRE_CONE; /* mqo/cone.pwx */
			render_save(&render);
				mlookat_(render.context->matrix,
					fld(0.0), fld(0.0), fld(0.0),
					fld(0.0), fld(0.0), fld(1.0),
					fld(0.0));
				render_save(&render);
#ifdef USE_TEXTURE
					render.context->texture = &texture_table[TEX_CUBE];
#endif /*USE_TEXTURE*/
					mxlate_(render.context->matrix,
						fld(-1.0), fld(0.0), fld(5.0));
					mrotq_(render.context->matrix, qslerp(
						qrot(fld(1.0), fld(0.0), fld(0.0), fld(0.0)),
						qrot(fld(1.0), fld(0.0), fld(0.0), PI),
						fidiv(fld(now % SEC(5)), SEC(5))));
					render_mesh(&render, &MESH_CUBE);
				render_restore(&render);
				render_save(&render);
					mxlate_(render.context->matrix,
						fld(1.5), fld(-1.0), fld(5.0));
					mrotq_(render.context->matrix, qslerp(
						qrot(fld(0.0), fld(1.0), fld(0.0), fld(0.0)),
						qrot(fld(0.0), fld(1.0), fld(0.0), PI),
						fidiv(fld(now % SEC(5)), SEC(5))));
					render_wire(&render, &WIRE_CONE, 3);
				render_restore(&render);
			render_restore(&render);
		}
#endif /*USE_3D*/

#ifdef  USE_LOG_BUFFER
		{
			LogBuf_Printf(pLogBuf, "now=%u", now);
		}
#endif/*USE_LOG_BUFFER*/

//#ifdef  USE_NVLOG
		{
			NVLOG("now=%u", now);	//USE_NVLOG`ĂȂNVLOG()(void)0ɓWĴŁAUSE_NVLOG`ĂȂĂNVLOG()gpč\܂B
		}
//#endif//USE_NVLOG
	}

#ifdef USE_IDLE
	idle_wait();
#endif /*USE_IDLE*/

	return 0;
}

/****************************************************************************
 *	game_main
 ****************************************************************************/

void game_main() {
	for(;;) {
		schedule();
	}
}

/****************************************************************************
 *	app_main
 ****************************************************************************/

void app_main(int argc, char* argv[]) {
	for(;;) {
		if(demo_main() < 0) { break; }
		game_main();
	}
}
