/*
 *	mqueue.c
 *
 *	POSIX Message Queue for Windows NT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Fri Mar 18 21:34:32 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  pthreads-win32ɂPOSIX Message Queue܂܂ĂȂ̂ŁAǉ鎖ɂ܂B
 *	  ̃W[Win32płBP/ECEł͎gpo܂B	
 *	- ȉ̎QlɂĒAȗɂ܂B
 *	  Ql
 *	  uPOSIX Message Queues for Win32!v(https://sourceware.org/ml/pthreads-win32/2000/msg00131.html)
 *	  Ɋȗ_́Aȉ̒ʂłB
 *	  EIWił̎́AvZXԂŃbZ[W̑Ms悤ɁALgĎĂ܂B
 *	    ́AvZX̃XbhԂŃbZ[W̑MsΏ[Ȃ̂ŁAʂ̃mۂgp܂B
 *	  E̓vZXԒʐMT|[gȂ̂ŁAbZ[WL[̖O͖ӖɂȂAmq_open()name,y,mode𖳎܂B
 *	    ɔāAmq_unlink()AȂ_~[֐Ƃ܂B
 *	  EIWił̎́A{̊֐dlʂɁAG[́AG[R[hԂ悤ɂȂĂ܂B
 *	    ́AG[ɁA'DIE()'Œ~悤ɂ܂B
 *	  Emq_notify()͖ΉłAĂяoƃG[~܂B
 *	    mq_notify()Ήł鎖́AIWił̎łB
 *	- ֐dlɂẮAȉ̎QƂ܂B
 *	  QƎ
 *	  uLinux Programmer's Manual - MQ_OVERVIEWv(https://linuxjm.osdn.jp/html/LDP_man-pages/man7/mq_overview.7.html)
 *	  yсAL̃y[W烊NĂAe֐̐̃y[W
 *	* Sat Mar 19 21:19:21 JST 2016 Naoyuki Sawa
 *	- /clip/include/sys/types.h(/clip/clipstdw.h)ssize_t̒`ǉɔA܂ssize_t̑intgĂ𐳎ssize_tɏC܂B
 *	  2016/03/19_intssize_tɏCӏ́Agetline(),getdelim(),mq_receive()łB
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
//bZ[Wwb_
struct msg_hdr {						//one msg_hdr{} at the front of each message in the mapped file
	unsigned		msg_prio;			//priority
	size_t			msg_len;			//actual length
	char			msg_data[0/*mq_msgsize*/];	//copy of the message
};
/*--------------------------------------------------------------------------*/
//bZ[WL[wb_
struct mq_hdr {							//one mq_hdr{} per queue, at beginning of mapped file
	struct mq_attr		mqh_attr;			//the queue's attributes
	pthread_mutex_t		mqh_lock;			//mutex lock
	pthread_cond_t		mqh_wait;			//and condition variable
	struct msg_hdr*		mqh_mhdr[0/*mq_maxmsg*/];	//message headers
};
/****************************************************************************
 *	
 ****************************************************************************/
mqd_t mq_open(const char* name, int oflag, .../*mode_t mode, struct mq_attr* attr*/) {
	va_list ap;
	mode_t mode;			//gp
	struct mq_attr* attr;
	struct mq_hdr* mqhdr;
	struct msg_hdr* mhdr;
	int i;
	//̓vZXԒʐMT|[gȂ̂ŁAmq_open()ɂ͏ɐVbZ[WL[쐬͂łAoflagO_CREATw肹ɓ֐Ăяo͏o܂B
	//O_CREAT͕K{AO_NONBLOCK͔CӁAO_RDONLY,O_WRONLY,O_RDWR,O_CLOEXEC,O_EXCL͖܂B
	if(!(oflag & O_CREAT)) { DIE(); }
	//oflagO_CREATw肷ꍇAǉ2̈^KvB
	//modéAVL[ɓKp鋖ݒ(permission)Aopen()Ɠ悤Ɏw肷B	ł͖܂B
	//attŕAL[̑w肷B							łQƂ܂B
	va_start(ap, oflag);
	mode = va_arg(ap, mode_t);	//gp
	attr = va_arg(ap, struct mq_attr*);
	va_end(ap);
	//attrNULL̏ꍇAL[͎Œ`ꂽftHgō쐬B
	if(!attr) {
		static const struct mq_attr defattr = {
			0,	//mq_flags
			10,	//mq_maxmsg	ʓILinuxVXẽJ[lp[^ł(10,8192)݂Ȃ̂łɏ鎖ɂ܂B
			8192,	//mq_msgsize	
			0};	//mq_curmsgs
		attr = (struct mq_attr*)&defattr;
	}
	//oflagO_CREATw肳AattrNULLȊOAattr->mq_maxmsgattr->mq_msqsizesłB
	//̃tB[h͗Ƃ0傫Ȃ΂ȂȂB
	if((attr->mq_maxmsg  <= 0) ||
	   (attr->mq_msgsize <= 0)) { DIE(); }	//EINVAL
	//bZ[WL[wb_ƁAbZ[Wwb_ւ̃|C^zƁAbZ[Wwb_ƁAbZ[Wf[^obt@A܂Ƃ߂ămۂB
	mqhdr = malloc(sizeof(struct mq_hdr  )                                        +	//mq_hdr						bZ[WL[wb_
	              (sizeof(struct msg_hdr*)                     * attr->mq_maxmsg) +	//mq_hdr.mqh_mhdr[mq_maxmsg]				bZ[Wwb_ւ̃|C^z
	              (sizeof(struct msg_hdr ) + attr->mq_msgsize) * attr->mq_maxmsg);	//msg_hdr + (msg_hdr.msg_data[mq_msgsize] * mq_maxmsg)	bZ[Wwb_ƃbZ[Wf[^obt@
	if(!mqhdr) { DIE(); }	//ENOMEM
	//bZ[WL[wb_B
	mqhdr->mqh_attr.mq_flags	= oflag & O_NONBLOCK;
	mqhdr->mqh_attr.mq_maxmsg	= attr->mq_maxmsg;
	mqhdr->mqh_attr.mq_msgsize	= (attr->mq_msgsize + 3) & ~3;	//size of message in file is rounded up for alignment
	mqhdr->mqh_attr.mq_curmsgs	= 0;
	//~[eNXƁAϐ쐬B
	if(pthread_mutex_init(&mqhdr->mqh_lock, NULL)) { DIE(); }
	if(pthread_cond_init( &mqhdr->mqh_wait, NULL)) { DIE(); }
	//bZ[Wwb_ւ̃|C^zB
	mhdr = (struct msg_hdr*)&mqhdr->mqh_mhdr[attr->mq_maxmsg];	//bZ[Wwb_ւ̃|C^z̒ɁAbZ[Wwb_ƃbZ[Wf[^obt@̃mۂĂB
	for(i = 0; i < attr->mq_maxmsg; i++) {
		mqhdr->mqh_mhdr[i] = mhdr;
		mhdr = (struct msg_hdr*)&mhdr->msg_data[attr->mq_msgsize];	//|C^ÃbZ[Wwb_ƃbZ[Wf[^obt@̃AhX֐i߂B
	}
	//ƁAmq_open()̓bZ[WL[Lqq(message queue descriptor)ԂB
	//bZ[WL[Lqq͑̃bZ[WL[֘Å֐ŎgpB
	//G[̏ꍇAmq_open()(mqd_t)-1ԂAerrnoɃG[lݒ肷B	ł̓G[̏ꍇvOÎŁA֐G[Ԃ͖B
	return mqhdr;
}
/*--------------------------------------------------------------------------*/
int mq_close(mqd_t mqdes) {
	struct mq_hdr* const mqhdr = mqdes;
	//~[eNXƁAϐ폜B
	if(pthread_cond_destroy( &mqhdr->mqh_wait)) { DIE(); }
	if(pthread_mutex_destroy(&mqhdr->mqh_lock)) { DIE(); }
	//mq_open()ɂĂ܂Ƃ߂ĊmۂA܂Ƃ߂ĊJB
	free(mqhdr);
	//ƁAmq_close()0ԂB
	//G[̏ꍇA-1ԂAerrnoɃG[lݒ肷B	ł̓G[̏ꍇvOÎŁA֐G[Ԃ͖B
	return 0;
}
/*--------------------------------------------------------------------------*/
int mq_unlink(const char* name) {
	//̓vZXԒʐMT|[gȂ̂ŁAbZ[WL[̖O͖ӖɂȂAmq_open()name,y,mode𖳎܂B
	//ɔāAmq_unlink()AȂ_~[֐Ƃ܂B
	/** no job **/
	return 0;
}
/*--------------------------------------------------------------------------*/
static int msg_hdr_compar(const void* key, const void* datum) {
	unsigned const msg_prio = (unsigned)key;
	struct msg_hdr* const mhdr = *(struct msg_hdr**)datum;
	if(msg_prio > mhdr->msg_prio) { return -1; }	//msg_prióAbZ[W̗Dxw肷镉łȂłBbZ[W͗Dx̍~ŃL[Ɋi[ADx̐VbZ[W͓Dx̌ÂbZ[W̌Ɋi[B
	if(msg_prio < mhdr->msg_prio) { return  1; }	//                                                                                      ~~~~
	return 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
int mq_send(mqd_t mqdes, const char* msg_ptr, size_t msg_len, unsigned msg_prio) {
	struct mq_hdr* const mqhdr = mqdes;
	struct mq_attr* const attr = &mqhdr->mqh_attr;
	struct msg_hdr *mhdr, **insert_pos, **remove_pos;
	//bZ[WL[bNB
	if(pthread_mutex_lock(&mqhdr->mqh_lock)) { DIE(); }
	//sg_leńAmsg_ptrwbZ[W̒B
	//̒̓L[mq_msgsizeȉłȂ΂ȂȂB
	//0̃bZ[WF߂ĂB
	if((unsigned)msg_len > (unsigned)attr->mq_msgsize) { DIE(); }	//EMSGSIZE
	//bZ[WL[łɈt̏ꍇ(Ȃ킿AL[ɓĂ郁bZ[WL[mq_maxmsgƓꍇ)AftHgł́Amq_send()́AbZ[WL[CÔɏ\ȋԂł邩A֐ĂяoVOinh[ɂ蒆f܂ŁA~(block)B	ł́AVOinh[ɂ蒆f鎖͖B
	//bZ[WL[Lq(message queue description)O_NONBLOCKtOLɂȂĂꍇ́Amq_send()̓G[EAGAINłɎsB
	while(attr->mq_curmsgs >= attr->mq_maxmsg) {
		if(attr->mq_flags & O_NONBLOCK) {
			//bZ[WL[̃bNB
			if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }	//YȂ!!
			errno = EAGAIN;
			return -1;
		}
		//L[ɓĂ郁bZ[Wω̂҂B
		if(pthread_cond_wait(&mqhdr->mqh_wait, &mqhdr->mqh_lock)) { DIE(); }
	}
	//bZ[Wwb_ւ̃|C^źAVbZ[Wǉʒu߂B
	insert_pos = upper_bound((void*)msg_prio, mqhdr->mqh_mhdr, attr->mq_curmsgs, sizeof(struct msg_hdr*), msg_hdr_compar);
	//̂Ƃmemmove()ɂď㏑ʒu߂B
	remove_pos = &mqhdr->mqh_mhdr[attr->mq_curmsgs++];
	//̂Ƃmemmove()ɂď㏑ʒúAbZ[Wwb_ւ̃|C^oĂB
	mhdr = *remove_pos;
	//VbZ[Wǉʒuȍ~ɗLALȊ̃bZ[Wwb_ւ̃|C^̔zւ炷B
	//
	//	@@@insert_pos
	//	@@@@@remove_pos
	//	@@@@@
	//	
	//	
	//	@@@@memmove
	//	@@@@
	//	
	//	@@@@@
	//	@@@
	//
	memmove(&insert_pos[1], insert_pos, (int)remove_pos - (int)insert_pos);
	//VbZ[WǉʒuɁAmemmove()ɂď㏑ꂽʒuɗLbZ[Wwb_ւ̃|C^i[B
	*insert_pos = mhdr;
	//bZ[Wwb_ݒ肷B
	mhdr->msg_prio	= msg_prio;
	mhdr->msg_len	= msg_len;
	memcpy(mhdr->msg_data, msg_ptr, msg_len);
	//L[ɓĂ郁bZ[WωʒmB
	if(pthread_cond_signal( &mqhdr->mqh_wait)) { DIE(); }
	//bZ[WL[̃bNB
	if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }
	//ƁAmq_send()mq_timedsend()0ԂB
	//G[̏ꍇA-1ԂAerrnoɃG[lݒ肷B	ł́AO_NONBLOCKw肵ꍇ̂݁AG[Ԃ\LB
	return 0;
}
/*--------------------------------------------------------------------------*/
ssize_t mq_receive(mqd_t mqdes, char* msg_ptr, size_t msg_len, unsigned* msg_prio) {
	struct mq_hdr* const mqhdr = mqdes;
	struct mq_attr* const attr = &mqhdr->mqh_attr;
	struct msg_hdr *mhdr, **insert_pos, **remove_pos;
	//bZ[WL[bNB
	if(pthread_mutex_lock(&mqhdr->mqh_lock)) { DIE(); }
	//msg_leńAmsg_ptrwobt@[̑傫B
	//̒l̓L[mq_msgsizeȏłȂ΂ȂȂB
	if((unsigned)msg_len < (unsigned)attr->mq_msgsize) { DIE(); }	//EMSGSIZE
	//L[̏ꍇAftHgł́Amq_receive()́AVbZ[W͂A֐ĂяoVOinh[ɂ蒆f܂ŁA~(block)B
	//bZ[WL[Lq(message queue description)O_NONBLOCKtOLɂȂĂꍇ́Amq_receive()̓G[EAGAINłɎsB
	while(!attr->mq_curmsgs) {
		if(attr->mq_flags & O_NONBLOCK) {
			//bZ[WL[̃bNB
			if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }	//YȂ!!
			errno = EAGAIN;
			return -1;
		}
		//L[ɓĂ郁bZ[Wω̂҂B
		if(pthread_cond_wait(&mqhdr->mqh_wait, &mqhdr->mqh_lock)) { DIE(); }
	}
	//̂Ƃmemmove()ɂċ󂫂ʒu߂B
	insert_pos = &mqhdr->mqh_mhdr[--attr->mq_curmsgs];
	//̂Ƃmemmove()ɂď㏑ʒu߂B
	remove_pos = &mqhdr->mqh_mhdr[0];
	//̂Ƃmemmove()ɂď㏑ʒúAbZ[Wwb_ւ̃|C^oĂB
	mhdr = *remove_pos;
	//obZ[Ẅʒuȍ~ɗLALȊ̃bZ[Wwb_ւ̃|C^̔zOւ炷B
	//
	//	remove_pos
	//	@@@@insert_pos
	//	@@@@
	//	
	//	
	//	memmove
	//	
	//	
	//	@@@@
	//	
	//
	memmove(remove_pos, &remove_pos[1], (int)insert_pos - (int)remove_pos);
	//memmove()ɂċ󂫂ʒuɁAmemmove()ɂď㏑ꂽʒuɗLbZ[Wwb_ւ̃|C^i[B
	*insert_pos = mhdr;
	//߂li[B
	memcpy(msg_ptr, mhdr->msg_data, (msg_len = mhdr->msg_len));
	if(msg_prio) { *msg_prio = mhdr->msg_prio; }	//msg_prioNULLȊȌꍇAmsg_priowobt@[ɎMbZ[W̗Dxi[B
	//L[ɓĂ郁bZ[WωʒmB
	if(pthread_cond_signal( &mqhdr->mqh_wait)) { DIE(); }
	//bZ[WL[̃bNB
	if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }
	//ƁAmq_receive()mq_timedreceive()͎MbZ[W̃oCgԂB
	//G[̏ꍇA-1ԂAerrnoɃG[lݒ肷B	ł́AO_NONBLOCKw肵ꍇ̂݁AG[Ԃ\LB
	return msg_len;
}
/*--------------------------------------------------------------------------*/
int mq_notify(mqd_t mqdes, const struct sigevent* notification) {
	//mq_notify()͖ΉłAĂяoƃG[~܂B
	//mq_notify()Ήł鎖́AIWił̎łB
	DIE();	//Ή
}
/*--------------------------------------------------------------------------*/
int mq_getattr(mqd_t mqdes, struct mq_attr* attr) {
	struct mq_hdr* const mqhdr = mqdes;
	//bZ[WL[bNB
	if(pthread_mutex_lock(&mqhdr->mqh_lock)) { DIE(); }
	//mq_getattr()́Aattrwobt@[mq_attr\̂i[ĕԂB
	*attr = mqhdr->mqh_attr;
	//bZ[WL[̃bNB
	if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }
	//ƁAmq_getattr()mq_setattr()0ԂB
	//G[̏ꍇA-1ԂAerrnoɃG[lݒ肷B	ł̓G[̏ꍇvOÎŁA֐G[Ԃ͖B
	return 0;
}
/*--------------------------------------------------------------------------*/
int mq_setattr(mqd_t mqdes, const struct mq_attr* newattr, struct mq_attr* oldattr) {
	struct mq_hdr* const mqhdr = mqdes;
	//bZ[WL[bNB
	if(pthread_mutex_lock(&mqhdr->mqh_lock)) { DIE(); }
	//oldattrtB[hNULLȊȌꍇAmq_getattr()Ԃ̂Ɠi[mq_attr\̂oldattrwobt@[ɓĕԂB
	if(oldattr) { *oldattr = mqhdr->mqh_attr; }
	//mq_setattr()́Anewattrwmq_attr\̂ŗ^ꂽgāAbZ[WL[̑ݒ肷B
	//ύX邱Ƃł鑮́Amq_flagsO_NONBLOCKtO̐ݒ肾łB
	//newattȓ̃tB[h͖B
	mqhdr->mqh_attr.mq_flags = newattr->mq_flags & O_NONBLOCK;
	//bZ[WL[̃bNB
	if(pthread_mutex_unlock(&mqhdr->mqh_lock)) { DIE(); }
	//ƁAmq_getattr()mq_setattr()0ԂB
	//G[̏ꍇA-1ԂAerrnoɃG[lݒ肷B	ł̓G[̏ꍇvOÎŁA֐G[Ԃ͖B
	return 0;
}
