/*
 *	ght_hash_table.h
 *
 *	Generic Hash Table (GHT)
 *
 *	* Sat Jun 06 15:36:36 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- ulibghthash - Generic Hash Table (GHT)v(http://www.bth.se/people/ska/sim_home/libghthash.html)݊W[łB
 *	  ֐dllibghthashƓŁA͓ƎłB
 *	  IWiłlibghthash͑x\dĎĂ悤łA͏ȃD悵ĒPɎ܂B
 *	- ֐dlgṕAIWiłlibghthash̃hLgQƂĂB
 *	  IWiłlibghthashA/clip/tool/libghthash.7z ɕۑĂ܂B
 *	* Sun Jul 12 21:50:47 JST 2015 Naoyuki Sawa
 *	- ght_set_rehash(),ght_rehash()Ή܂B
 *	  x\dȂjł̊֐ɂ͑ΉĂ܂łAP邽߂ɑΉ鎖ɂ܂B
 *	  ܂ł́Aght_create()̈ɗLx傫Ȓlw肷KvLAۂ̗vfȂɖʂĂ܂B
 *	  ́A'ght_create(0);ght_set_rehash(p_ht,1)'ŗǂAvf̑ɉĎIɃe[uTCY܂B
 *	* Tue Oct 06 21:24:18 JST 2015 Naoyuki Sawa
 *	- ght_size()܂B
 *	  ܂łRAMߖŗD悵i_sizetB[hێɁAght_size()ďoxle_iteratorHėvf𐔂Ă܂B
 *	  ̕ύXi_sizetB[hǉāAght_size()i_sizeԂɂč܂B
 *	  ͂RAMʂ܂AP/ECȄꍇ̓vORAMɓWĴŁAght_size()̃R[hTCYጸŎRAMʂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __GHT_HASH_TABLE_H__
#define __GHT_HASH_TABLE_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct s_hash_entry {
	LIST_ENTRY		le_iterator;
	LIST_ENTRY		le_bucket;
	void*			p_entry_data;			//Entry data.
	int			i_key_size;			//The size in bytes of the key.
	unsigned char		key_data[0/*i_key_size*/];	//Key data.
} ght_hash_entry_t;
/*--------------------------------------------------------------------------*/
typedef struct {
	LIST_ENTRY*		le_next;			//The current entry.		//Ce[^͎̃m[hwĂ̂ŁACe[V̒œYm[hght_remove()ĂSłBgpght_finalize()̎QƂĂB
} ght_iterator_t;
/*--------------------------------------------------------------------------*/
typedef struct {
	struct {
	  unsigned		b_rehash	:1;		//Automatic rehashing status.
	} flag;
	int			i_size;				//The current number of items in the table.
	LIST_ENTRY		le_iterator;
	int			i_table_size;			//The number of buckets.
	LIST_ENTRY*		le_bucket/*[i_table_size]*/;
} ght_hash_table_t;
/****************************************************************************
 *	
 ****************************************************************************/
ght_hash_table_t* ght_create(int i_table_size);
int ght_size(ght_hash_table_t* p_ht);
int ght_table_size(ght_hash_table_t* p_ht);
int ght_insert(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data);
void* ght_replace(ght_hash_table_t* p_ht, void* p_entry_data, int i_key_size, const void* p_key_data);
void* ght_get(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data);
void* ght_remove(ght_hash_table_t* p_ht, int i_key_size, const void* p_key_data);
void* ght_first(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data);
void* ght_first_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data, int* p_key_size);
void* ght_next(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data);
void* ght_next_keysize(ght_hash_table_t* p_ht, ght_iterator_t* p_iterator, const void** pp_key_data, int* p_key_size);
void ght_finalize(ght_hash_table_t* p_ht);
void ght_set_rehash(ght_hash_table_t* p_ht, int b_rehash);
void ght_rehash(ght_hash_table_t* p_ht, int i_table_size);
/*--------------------------------------------------------------------------*/
//Ή̊֐ƁAΉƂŔAȉ̒ʂł:
//Eght_set_alloc		malloc,freeŒŏ[B
//Eght_set_hash		One-at-a-Time HashŒŏ[B
//Eght_set_heuristics		x\͏dȂB
//Eght_set_bounded_buckets	LbVƂĎg\͖B
//Eght_one_at_a_time_hash	One-at-a-Time HashŒŏ[B
//Eght_rotating_hash		One-at-a-Time HashŒŏ[B
//Eght_crc_hash		One-at-a-Time HashŒŏ[B
//Eght_print			fobO@\KvȒGł͂ȂB
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__GHT_HASH_TABLE_H__
