/*	
 *	framsap.c
 *
 *	P/ECE SAP Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Jan 26 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	M6502G~[VpO֐
 ****************************************************************************/

#ifdef SAP_IO_READ /* I/O READΉ̂ */
unsigned char
sap_m6502_read(M6502* m6502, unsigned short addr)
{
	SAPDRIVER* sap = (SAPDRIVER*)m6502;
	unsigned char* mem = sap->mem;

	/* Hardware I/O area */
	if(addr >= 0xd000 && addr <= 0xdfff) {
		return sap_m6502_in(m6502, addr);
	}

	return mem[addr];
}
#endif /*SAP_IO_READ*/

#ifndef PIECE	/************************************************************/

void
sap_m6502_write(M6502* m6502, unsigned short addr, unsigned char data)
{
	SAPDRIVER* sap = (SAPDRIVER*)m6502;
	unsigned char* mem = sap->mem;

	/* Hardware I/O area */
	if(addr >= 0xd000 && addr <= 0xdfff) {
		sap_m6502_out(m6502, addr, data);
		return;
	}

	mem[addr] = data;
}

#else /*PIECE*/	/************************************************************/

//asm("
//	.code
//	.align 1
//	.global sap_m6502_write
//sap_m6502_write:
//	xcmp %r13, 0xd000		; if(addr <  0xd000) goto L10
//	xjrult sap_m6502_write_L10
//	xcmp %r13, 0xdfff		; if(addr <= 0xdfff) goto sap_m6502_out(m6502, addr, data)
//	xjrule sap_m6502_out
//sap_m6502_write_L10:
//	add %r12, %r13			; ((unsigned char*)(m6502 + 1))[addr] = data
//	xld.b [%r12+24], %r14		; * '24' is sizeof(M6502). See clipm65.h *
//	ret
//");
//fȎ()
//============================================================================
//݃AhX̏opxlč܂B
//E݃AhX0x0000-0xcfff(RAM area)΂񑽂A
//EɎ      0xd000-0xdfff(I/O area)B
//E                  0xe000-0xffff(ROM area)ւ݂̏͂܂肦ȂB
//ƍlāARAMI/OROM̏ɔ肷邱Ƃɂ܂B
asm("
	.code
	.align 1
	.global sap_m6502_write
sap_m6502_write:
	xcmp %r13, 0xd000		; if(addr >= 0xd000) goto L10
	xjruge sap_m6502_write_L10
sap_m6502_write_L20:
	add %r12, %r13			; ((unsigned char*)(m6502 + 1))[addr] = data
	xld.b [%r12+24], %r14		; * '24' is sizeof(M6502). See clipm65.h *
	ret
sap_m6502_write_L10:
	xcmp %r13, 0xdfff		; if(addr <= 0xdfff) goto sap_m6502_out(m6502, addr, data)
	xjrule sap_m6502_out
	xjp sap_m6502_write_L20		; goto L20 (ROM areaւ̏?)
");

#endif /*PIECE*//************************************************************/
