/*	
 *	clipz8c.h
 *
 *	P/ECE Z80 Emulator ()
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 10 19:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_Z8C_H__
#define __CLIP_Z8C_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* AvP[V`I/O֐vg^Cv */
typedef int  Z80CPUIN (int addr);
typedef void Z80CPUOUT(int addr, int data);

typedef struct _Z80CPU {
	unsigned short af;		/* + 0,2 */
	unsigned short bc;		/* + 2,2 */
	unsigned short de;		/* + 4,2 */
	unsigned short hl;		/* + 6,2 */
	//
	unsigned short af2;		/* + 8,2 */
	unsigned short bc2;		/* +10,2 */
	unsigned short de2;		/* +12,2 */
	unsigned short hl2;		/* +14,2 */
	//
	unsigned short ix;		/* +16,2 */
	unsigned short iy;		/* +18,2 */
	unsigned short sp;		/* +20,2 */
	unsigned short pc;		/* +22,2 */
	//
	unsigned char r;		/* +24,1 */
	unsigned char i;		/* +25,1 */
	unsigned char im;		/* +26,1 */
	unsigned char iff1;		/* +27,1 */
	unsigned char iff2;		/* +28,1 */
	unsigned char halt;		/* +29,1 */
	unsigned char pending;		/* +30,1 */
	unsigned char pending_no;	/* +31,1 */
	//
	int cycle;			/* +32,4 */
	Z80CPUIN* in;			/* +36,4 */
	Z80CPUOUT* out;			/* +40,4 */
} Z80CPU;				/* =44   */

extern Z80CPU z80cpu;			/* RAMɔzu */
extern unsigned char z80mem[0x10000];	/*    SRAMɔzu */

/****************************************************************************
 *	
 ****************************************************************************/

/* CPUZbg܂B
 * [in]
 *	in	I/O Read  O֐ (NULL)
 *	out	I/O Write O֐ (NULL)
 */
void z80cpu_reset(Z80CPUIN* in, Z80CPUOUT* out);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void z80cpu_run(int cycle);

/* INTv𔭍s܂B
 * [in]
 *	no	荞݃[hɂĈӖقȂ܂B
 *		[h0: RST XXH ߂OpCodew肵܂B
 *		[h1: Ӗ܂B
 *		[h2: 荞݃xN^̉ʃoCgw肵܂B(TODO:)
 */
void z80cpu_int(int no);

/* NMIv𔭍s܂B
 */
void z80cpu_nmi();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_Z8C_H__*/
