/*	
 *	clipwkst.c
 *
 *	[NV[g(KwnbVe[u)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Mon Jul 13 21:22:16 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Jul 15 01:12:55 JST 2015 Naoyuki Sawa
 *	- Worksheet_ref_l(),Worksheet_ref_a(),Worksheet_ref_v()ǉ܂B
 *	- Worksheet_sum_l(),Worksheet_sum_a(),Worksheet_sum_v()ǉ܂B
 *	* Thu Jul 16 22:21:18 JST 2015 Naoyuki Sawa
 *	- Worksheet_sort(),Worksheet_sort_l(),Worksheet_sort_a(),Worksheet_sort_v()ǉ܂B
 *	* Sun Jul 19 12:59:05 JST 2015 Naoyuki Sawa
 *	- RĝݒǋL:
 *	  W[̊֐́AL[lɎwł̂͐l݂̂ŁA͎wł܂B
 *	  L[lɕw肵ꍇ́A{clipstr.cW[ɒǉAquark_from_string(),quark_to_string()𕹗pĂB
 *	  <>
 *	  Worksheet_set_l(ws,quark_from_string("Value"),quark_from_string("Key"),-1);
 *	  iVal=Worksheet_get_l(ws,quark_from_string("Key"),-1);
 *	  if(iVal!=-1){puts(quark_to_string(iVal));}
 *	* Fri Dec 11 21:38:17 JST 2015 Naoyuki Sawa
 *	- Worksheet_incr_l()A܂ł͖߂lłA(1)̒lԂ悤ɂ܂B
 *	  JE^ƂėpꍇAZ̒l(1)āAɂ̒lQƂ鎖łB
 *	- ߂l𖳎Γ͕ςĂȂ̂ŁÃAvP[Vւ̉e͗L܂B
 */
#include "clip.h"
/****************************************************************************
 *	쐬/J
 ****************************************************************************/
//Wv\̒PKw쐬B
// - ̊KwƌȂsƌȂ́AAvP[V̉ߎłB
ST_Worksheet* Worksheet_new() {
	//Wv\̒PKw̃mۂB
	ST_Worksheet* ws = calloc(1, sizeof(ST_Worksheet));
	if(!ws) { DIE(); }
	//nbVe[u쐬B
	ws->tKey = ght_create(0);		//TCYw肵ȂB
	ght_set_rehash(ws->tKey, 1);	//TCYLƂB
	//Wv\̒PKwԂB
	return ws;
}
/*--------------------------------------------------------------------------*/
//Wv\̑SKwJB
void Worksheet_free(ST_Worksheet* ws) {
	int iKey;
	ST_Worksheet_Iterator it;
	//k|C^ɑ΂Čďoꂽꍇ́AȂB
	if(!ws) { return; }	//܂
	//qKwSĊJB
	for(iKey = Worksheet_first_l(ws, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) { Worksheet_unset_l(ws, iKey, -1); }
	//̊KwJB
	ght_finalize(ws->tKey);
	free(ws);
}
/****************************************************************************
 *	Q
 ****************************************************************************/
//Wv\̃m[hQƂB
// - w肳ꂽm[h݂Ȃꍇ́Ak|C^Ԃ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́AwsԂ܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
ST_Worksheet* Worksheet_ref_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	ST_Worksheet* pChild;
	va_list ap;
	va_start(ap, ws);
	pChild = Worksheet_ref_a(ws, ap);
	va_end(ap);
	return pChild;
}
/*--------------------------------------------------------------------------*/
ST_Worksheet* Worksheet_ref_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_ref_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
ST_Worksheet* Worksheet_ref_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́Aw肳ꂽm[h݂Ȃ̂Ɠ`ƌȂāAk|C^ԂB
	if(!ws) { return NULL; }	//܂
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁AwsԂB
	if(iKey == -1) { return ws; }	//܂
	//L[ɑΉqKw(L)擾B
	pChild = ght_get(ws->tKey, sizeof(int), &iKey);
	//L[ɑΉqKw(L)ɑ΂āAċAB
	// - L[ɑΉqKwꍇAňSłB
	return Worksheet_ref_v(pChild/*k*/, aKey);
}
/****************************************************************************
 *	擾
 ****************************************************************************/
//Wv\̃Z̒l擾B
// - Wv\̃Z̒lݒ肾ꍇ́A(0)Ԃ܂B
//   ݒ(0)ƁAIɐݒ肳ꂽ(0)Aʂ@͗L܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒lԂ܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
int Worksheet_get_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	int iVal;
	va_list ap;
	va_start(ap, ws);
	iVal = Worksheet_get_a(ws, ap);
	va_end(ap);
	return iVal;
}
/*--------------------------------------------------------------------------*/
int Worksheet_get_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_get_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
int Worksheet_get_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	//w肳ꂽm[h(L)擾B
	// - k|C^ɑ΂ČďoꂽꍇAňSłB
	ws = Worksheet_ref_v(ws/*k*/, aKey);
	//w肳ꂽm[h݂Ȃꍇ́AlݒƓ`ƌȂāA(0)ԂB
	if(!ws) { return 0; }	//܂
	//w肳ꂽm[h̒lԂB
	return ws->iVal;
}
/****************************************************************************
 *	v
 ****************************************************************************/
//Wv\́Aw肳ꂽm[hȉ̃c[̒lvB
// - w肳ꂽm[h݂Ȃꍇ́A(0)Ԃ܂B
//   L(0)ƁAIɐݒ肳ꂽl̍v(0)łꍇƂAʂ@͗L܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́Ãm[hȉ̃c[̒lv܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
// - w肳ꂽm[hg̒lAvɊ܂݂܂B
//   m[hlƃL[𗼕Ăꍇ́AǂvɊ܂݂܂B
//@@@@@ P @@@@
//@@@@@^_@@@@Ⴆ́A}̃c[̍ŏʂ̃m[hw肵ꍇA
//@@@@Q@@@@@vl(1+2+3+4+5=15)ƂȂ܂B
//@@@^@_@@_@@
//@@R@@@S@@T@
int Worksheet_sum_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	int iSum;
	va_list ap;
	va_start(ap, ws);
	iSum = Worksheet_sum_a(ws, ap);
	va_end(ap);
	return iSum;
}
/*--------------------------------------------------------------------------*/
int Worksheet_sum_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_sum_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
int Worksheet_sum_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey, iSum;
	ST_Worksheet_Iterator it;
	//w肳ꂽm[h(L)擾B
	// - k|C^ɑ΂ČďoꂽꍇAňSłB
	ws = Worksheet_ref_v(ws/*k*/, aKey);
	//w肳ꂽm[h̒l擾B
	// - w肳ꂽm[hꍇAňSłB
	iSum = Worksheet_get_l(ws/*k*/, -1);
	//qKw̃L[ɑ΂čċAAlZB
	// - w肳ꂽm[hꍇAňSłB
	for(iKey = Worksheet_first_l(ws/*k*/, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) { iSum += Worksheet_sum_l(ws, iKey, -1); }
	return iSum;
}
/****************************************************************************
 *	ݒ
 ****************************************************************************/
//Wv\̃Z̒lݒ肷B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒lݒ肵܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
// - lɂ́ACӂ̐wo܂B
void Worksheet_set_l(ST_Worksheet* ws, int iVal, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, iVal);
	Worksheet_set_a(ws, iVal, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void Worksheet_set_a(ST_Worksheet* ws, int iVal, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	Worksheet_set_v(ws, iVal, aKey);
}
/*--------------------------------------------------------------------------*/
void Worksheet_set_v(ST_Worksheet* ws, int iVal, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey;
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́AG[~B
	if(!ws) { DIE(); }
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁ÅKw̒lݒ肷B
	if(iKey == -1) { ws->iVal = iVal; return; }	//܂
	//L[ɑΉqKw(L)擾B
	pChild = Worksheet_ref_l(ws, iKey, -1);
	//L[ɑΉqKw΁c
	if(!pChild) {
		//Wv\̒PKw쐬B
		pChild = Worksheet_new();
		//L[ɑΉqKwƂāAǉB
		ght_insert(ws->tKey, pChild, sizeof(int), &iKey);
	}
	//L[ɑΉqKwɑ΂āAċAB
	Worksheet_set_v(pChild, iVal, aKey);
}
/****************************************************************************
 *	폜
 ****************************************************************************/
//Wv\̎w肳ꂽm[h,y,ȉ̊KwJB
// - ψ́A(1)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́AG[~܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
void Worksheet_unset_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, ws);
	Worksheet_unset_a(ws, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void Worksheet_unset_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	Worksheet_unset_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
void Worksheet_unset_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́AȂB
	if(!ws) { return; }	//܂
	//ȂƂ(1)ȏ̃L[w肳ĂȂ΂ȂȂB
	if(aKey[0] == -1) { DIE(); }
	//aKey[0]Ō̃L[Ȃ΁c
	if(aKey[1] == -1) {
		//aKey[0]ɑΉqKw(L)OB
		pChild = ght_remove(ws->tKey, sizeof(int), &aKey[0]);
		//OqKw(L)JB
		// - L[ɑΉqKwꍇAňSłB
		Worksheet_free(pChild/*k*/);
		return;	//܂
	}
	//aKey[0]ɑΉqKw(L)擾B
	pChild = Worksheet_ref_l(ws, aKey[0], -1);
	//aKey[0]ɑΉqKw(L)ɑ΂āAċAB
	// - aKey[0]ɑΉqKwꍇAňSłB
	Worksheet_unset_v(pChild/*k*/, &aKey[1]);
}
/****************************************************************************
 *	v
 ****************************************************************************/
//Wv\̃Z̒l(1)A(1)̒lԂB
// - Wv\̃Z̒lݒ肾ꍇ́A(1)̒l(1)ɂȂ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̒l(1)܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
int Worksheet_incr_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	int iVal;
	va_list ap;
	va_start(ap, ws);
	iVal = Worksheet_incr_a(ws, ap);
	va_end(ap);
	return iVal;
}
/*--------------------------------------------------------------------------*/
int Worksheet_incr_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_incr_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
int Worksheet_incr_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	//݂̒l擾(1)B
	int iVal = Worksheet_get_v(ws, aKey) + 1;
	//(1)̒lݒ肷B
	Worksheet_set_v(ws, iVal, aKey);
	//(1)̒lԂB
	return iVal;
}
/****************************************************************************
 *	Jn
 ****************************************************************************/
//Wv\̎qKw̍ŏ̃L[擾܂B
// - qKw΁A(-1)Ԃ܂B
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̎qKw̍ŏ̃L[擾܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
int Worksheet_first_l(ST_Worksheet* ws, ST_Worksheet_Iterator* it, ... /*,(-1)*/) {
	int iKey;
	va_list ap;
	va_start(ap, it);
	iKey = Worksheet_first_a(ws, it, ap);
	va_end(ap);
	return iKey;
}
/*--------------------------------------------------------------------------*/
int Worksheet_first_a(ST_Worksheet* ws, ST_Worksheet_Iterator* it, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	return Worksheet_first_v(ws, it, aKey);
}
/*--------------------------------------------------------------------------*/
int Worksheet_first_v(ST_Worksheet* ws, ST_Worksheet_Iterator* it, const int* aKey/*={key,key,...,key,-1}*/) {
	int iKey, *pKey;
	ST_Worksheet* pChild;
	//k|C^ɑ΂Čďoꂽꍇ́AqKŵƓ`ƌȂāA(-1)ԂB
	if(!ws) { return -1; }	//܂
	//̃L[擾B
	iKey = *aKey++;
	//L[I[Ȃ΁ÅKw̎qKw𑖍JnB
	if(iKey == -1) {
		//Ce[^ƓɁAqKw̍ŏ̃L[擾B
		it->p_ht = ws->tKey;
		if(!ght_first(it->p_ht, &it->it, (const void**)&pKey)) { return -1; }	//qKw̍ŏ̃L[΁A(-1)ԂB
		//qKw̍ŏ̃L[ԂB
		return *pKey;	//܂
	}
	//L[ɑΉqKw(L)擾B
	pChild = Worksheet_ref_l(ws, iKey, -1);
	//L[ɑΉqKwɑ΂āAċAB
	return Worksheet_first_v(pChild, it, aKey);
}
/****************************************************************************
 *	p
 ****************************************************************************/
//Wv\̎qKw̎̃L[擾܂B
// - ̃L[΁A(-1)Ԃ܂B
int Worksheet_next(ST_Worksheet_Iterator* it) {
	int* pKey;
	//qKw̎̃L[擾B
	if(!ght_next(it->p_ht, &it->it, (const void**)&pKey)) { return -1; }	//qKw̎̃L[΁A(-1)ԂB
	//qKw̎̃L[ԂB
	return *pKey;
}
/****************************************************************************
 *	\[g
 ****************************************************************************/
//Wv\̑SKw\[gB
void Worksheet_sort(ST_Worksheet* ws) {
	int iKey;
	ST_Worksheet_Iterator it;
	//̊Kw\[gB
	// - k|C^ɑ΂ČďoꂽꍇAňSłB
	Worksheet_sort_l(ws/*k*/, -1);
	//qKwSă\[gB
	// - k|C^ɑ΂ČďoꂽꍇAňSłB
	for(iKey = Worksheet_first_l(ws/*k*/, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) {
		ST_Worksheet* pChild = Worksheet_ref_l(ws, iKey, -1);
		Worksheet_sort(pChild);
	}
}
/*--------------------------------------------------------------------------*/
//Wv\̒PKw\[gB
// - ψ́A(0)ȏ̃L[̕тƁAI[(-1)łB
//   L[̕т(0)ꍇ́ÅKw̎qKw\[g܂B
// - L[ɂ́A(-1)ȊO̔Cӂ̐wo܂B
void Worksheet_sort_l(ST_Worksheet* ws, ... /*,(-1)*/) {
	va_list ap;
	va_start(ap, ws);
	Worksheet_sort_a(ws, ap);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
void Worksheet_sort_a(ST_Worksheet* ws, va_list ap) {
	int aKey[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((aKey[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(aKey)) { DIE(); }	//Œ~ꍇ́AaKey[]s,,ďoI[YĂBԂ҂낤B
	}
	Worksheet_sort_v(ws, aKey);
}
/*--------------------------------------------------------------------------*/
static int Worksheet_sort_Compare(LIST_ENTRY* _x, LIST_ENTRY* _y) {
	//֐̏́Aght_hash_table.h/cW[̓ɈˑĂ܂B
	//Oght_hash_table_t.le_iteratoȑԂёւĂAL܂B
	ght_hash_entry_t* x = CONTAINING_RECORD(_x, ght_hash_entry_t, le_iterator);
	ght_hash_entry_t* y = CONTAINING_RECORD(_y, ght_hash_entry_t, le_iterator);
	if((x->i_key_size != sizeof(int)) || (y->i_key_size != sizeof(int))) { DIE(); }
	if(*(int*)x->key_data < *(int*)y->key_data) { return -1; }
	if(*(int*)x->key_data > *(int*)y->key_data) { return  1; }
	DIE();	//Kwɓl̃L[݂鎖͖͂BŒ~oOłB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void Worksheet_sort_v(ST_Worksheet* ws, const int* aKey/*={key,key,...,key,-1}*/) {
	ws = Worksheet_ref_v(ws/*k*/, aKey);
	if(!ws) { return; }	//܂
	//[NV[g̓́AnbVe[u̓́A_uNXg\[gB
	SortList(&ws->tKey->le_iterator, Worksheet_sort_Compare);
}
/****************************************************************************
 *	_v
 ****************************************************************************/
static void Worksheet_dump_indent(int indent) {
	while(indent--) { putchar('\t'); }
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void Worksheet_dump_iter(ST_Worksheet* ws, int indent) {
	int iKey;
	ST_Worksheet_Iterator it;
	//qKw𑖍B
	// - k|C^ɑ΂ČďoꂽꍇAňSłB
	for(iKey = Worksheet_first_l(ws/*k*/, &it, -1);
	    iKey != -1;
	    iKey = Worksheet_next(&it)) {
		ST_Worksheet* pChild = Worksheet_ref_l(ws, iKey, -1);
		//qKw̒lݒ肳ĂAlo͂B
		if(pChild->iVal) {
			Worksheet_dump_indent(indent);
			printf("%d\t=\t%d\n", iKey, pChild->iVal);
		}
		//qKw̃L[łȂ΁AL[o͂B
		if(ght_size(pChild->tKey)) {
			Worksheet_dump_indent(indent);
			printf("%d\n", iKey);
			Worksheet_dump_iter(pChild, indent + 1);
			Worksheet_dump_indent(indent);
			printf("end\n");
		}
	}
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Wv\̑SKwAWXggNvg`Ń_v܂B
// - WXgXNvg͍̐l܂B
//   ̓Iɂ́AWXgXNvg̃L[ƒl͈̔͂(0)`(65535)ł̂ɑ΂A
//   W[̃L[͈̔͂(-1)Cӂ̐,l͈̔͂(-1)܂ޔCӂ̐łB
//   WXgXNvg̐O邱̒lÂ܂܏o͂܂B
//   ̏ꍇAWXgXNvgRpC_ŃG[ƂȂ܂B
// - [gKwɒڐݒ肵l͏o͂܂B
//   WXgXNvg̍\A'[gKw̒l'͕\oȂłB
void Worksheet_dump(ST_Worksheet* ws) {
	Worksheet_sort(ws);	//L[̏Ƀ_v鎖ɂBK{ł͂ȂB
	Worksheet_dump_iter(ws, 0);
}
/****************************************************************************
 *	gp
 ****************************************************************************/
//TODO:
