/*	
 *	clipunic.h
 *
 *	Unicode
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Thu Mar 05 21:20:02 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Mar 06 21:21:37 JST 2015 Naoyuki Sawa
 *	- strdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉ܂B
 *	* Sat Mar 07 13:24:35 JST 2015 Naoyuki Sawa
 *	- k@uCanonical Huffman Code(CHC)vuRange Coder(RC)vuByte Pair Encoding(BPE)vIł悤ɂ܂B
 *	  O܂ł́uRCvŒłAk@ɂႢrƎvłB
 *	- k@̑ÍAW[̃rhCOMPRESSION_METHOD̒`鎖ōŝŁAAvP[VI鎖͂ł܂B
 *	  k@rƂuCHCvxƗeʂ̃oXǂƎv̂ŁÁ݂uCHCv(COMPRESSION_METHOD=1)IĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Thu Mar 10 21:38:25 JST 2016 Naoyuki Sawa
 *	- u[eBeB֐(VtgJISUnicode(UCS-2))vǉ܂B
 *	- u[eBeB֐(UTF-8UCS-2)vǉ܂B
 *	* Fri Mar 11 21:58:48 JST 2016 Naoyuki Sawa
 *	- u[eBeB֐(VtgJISUnicode(UCS-2))vu[eBeB֐(UTF-8UCS-2)vǉƂɔA
 *	   ́u[eBeB֐(VtgJISUTF-8)vAu[eBeB֐(VtgJISUnicode(UCS-2))vu[eBeB֐(UTF-8UCS-2)v𗘗p悤ɕύX܂B
 *	   ʂ͂܂łƓłB
 */
#ifndef __CLIP_UNIC_H__
#define __CLIP_UNIC_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	R[hϊ(VtgJISUnicode(UCS-2))
 ****************************************************************************/
/* VtgJISR[hAUnicodeR[hɕϊ܂B
 * [in]
 *	c		VtgJISR[h
 * [out]
 *	߂l		UnicodeR[h
 * [note]
 *	- ϊłȂꍇ́A'?'(0x003F)Ԃ܂B
 */
int ShiftJisToUnicodeChr(int c);
/* UnicodeR[hAVtgJISR[hɕϊ܂B
 * [in]
 *	c		UnicodeR[h
 * [out]
 *	߂l		VtgJISR[h
 * [note]
 *	- ϊłȂꍇ́A'?'(0x3F)Ԃ܂B
 */
int UnicodeToShiftJisChr(int c);
/****************************************************************************
 *	ϊ(VtgJISUnicode(UCS-2))
 ****************************************************************************/
/* VtgJISAUnicodeɕϊ܂B
 * [in]
 *	s		VtgJIS
 *	buf		Unicodei[obt@
 *	cap		buf̗vf
 * [out]
 *	߂l		ϊUnicodẽ[hBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=ShiftJisToUnicodeStr(s,NULL,0);	//ϊ̃[h(I[܂܂)߂B
 *	buf=malloc((len+1)*sizeof(wchar_t));	//obt@mۂBI[(+1)sizeof(wchar_t){鎖Yꂸ!!
 *	ShiftJisToUnicodeStr(s,buf,len+1);	//ϊ̕(I[܂)i[B
 */
int ShiftJisToUnicodeStr(const char* _s, wchar_t buf[/*cap*/], int cap);
/* UnicodeAVtgJISɕϊ܂B
 * [in]
 *	s		Unicode
 *	buf		VtgJISi[obt@
 *	cap		buf̗vf
 * [out]
 *	߂l		ϊ̃VtgJIS̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=UnicodeToShiftJisStr(s,NULL,0);	//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);			//obt@mۂBI[(+1)Yꂸ!!
 *	UnicodeToShiftJisStr(s,buf,len+1);	//ϊ̕(I[܂)i[B
 */
int UnicodeToShiftJisStr(const wchar_t* s, char buf[/*cap*/], int cap);
/****************************************************************************
 *	ϊ(UTF-8UCS-2)
 ****************************************************************************/
/* UTF-8AUCS-2ɕϊ܂B
 * [in]
 *	s		UTF-8
 *	buf		UCS-2i[obt@
 *	cap		buf̗vf
 * [out]
 *	߂l		ϊUCS-2̃[hBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=Ucs2ToUtf8Str(s,NULL,0);		//ϊ̃[h(I[܂܂)߂B
 *	buf=malloc((len+1)*sizeof(wchar_t));	//obt@mۂBI[(+1)sizeof(wchar_t){鎖Yꂸ!!
 *	Ucs2ToUtf8Str(s,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int Utf8ToUcs2Str(const unsigned char* s, wchar_t buf[/*cap*/], int cap);
/* UCS-2AUTF-8ɕϊ܂B
 * [in]
 *	s		UCS-2
 *	buf		UTF-8i[obt@
 *	cap		buf̗vf
 * [out]
 *	߂l		ϊUTF-8̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=Ucs2ToUtf8Str(s,NULL,0);		//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);			//obt@mۂBI[(+1)Yꂸ!!
 *	Ucs2ToUtf8Str(s,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int Ucs2ToUtf8Str(const wchar_t* s, unsigned char buf[/*cap*/], int cap);
/****************************************************************************
 *	[eBeB֐(VtgJISUTF-8)
 ****************************************************************************/
unsigned char* strdup_ShiftJisToUtf8(const char* s);
char* strdup_Utf8ToShiftJis(const unsigned char* s);
/****************************************************************************
 *	[eBeB֐(VtgJISUnicode(UCS-2))
 ****************************************************************************/
wchar_t* strdup_ShiftJisToUnicode(const char* s);
char* strdup_UnicodeToShiftJis(const wchar_t* s);
/****************************************************************************
 *	[eBeB֐(UTF-8UCS-2)
 ****************************************************************************/
wchar_t* strdup_Utf8ToUcs2(const unsigned char* s);
unsigned char* strdup_Ucs2ToUtf8(const wchar_t* s);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_UNIC_H__
