/*	
 *	cliptask.h
 *
 *	^XNXPW[ (ReLXgXCb`)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006-2014 Naoyuki Sawa
 *
 *	* Fri Jun 09 22:27:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	  cliptask.h́AkeeptH_ɕۑ܂B
 *	* Wed Jun 14 00:44:00 JST 2006 Naoyuki Sawa
 *	- task_kill()ǉ܂B
 *	* Thu Sep 11 21:21:57 JST 2014 Naoyuki Sawa
 *	- task_yield()ǉ܂B
 *	* Fri Sep 12 22:07:53 JST 2014 Naoyuki Sawa
 *	- task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *	  ṕAtask_yield()[note]́Au^XNXPW[AAChXbhƕpāA`vQƂĂB
 *	* Thu Oct 30 00:04:33 JST 2014 Naoyuki Sawa
 *	- ZbgCxgɑ΂event_pulse()sAłsDx^XNNׂƂA
 *	  撅ŕ^XN̐擪ɓo^Ă^XNNĂƂAC܂B
 *	  Tv
 *	  EVENT* event;
 *	  TASK *task1,*task2;
 *	  int task_proc(void* param) {
 *	    event_wait(event);
 *	    TRACE("%s\n",param);
 *	    return 0;
 *	  }
 *	  void app_main() {
 *	    event=event_create(0);
 *	    task1=task_create(1,task_proc,"task1",0);//sDx=
 *	    task2=task_create(2,task_proc,"task2",0);//sDx=
 *	    event_pulse(event);//ˏCOtask1NĂBCtask2NB
 *	    event_pulse(event);//ˏCOtask2NĂBCtask1NB
 *	    for(;;) { schedule(); }
 *	  }
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_TASK_H__
#define __CLIP_TASK_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	^XN
 ****************************************************************************/

/* ^XN\  */
typedef struct _TASK {
	/*{{CAEgŒ*/
	int* sp;			/* %spۑ */
	/*}}CAEgŒ*/
	int suspend;			/* TXyh (1ȏ = ~, 0 = , 0 = ݒs) */
	int priority;			/* sDx (INT_MAX = ō ` 0 = ʏ ` INT_MIN = Œ) */
	int exit_code;			/* IR[h */
	LIST_ENTRY blocked_task_list;	/* ^XNXg                                                           */
					/* * Xg͋󂩁A܂́AB̏I҂^XNo^Ă܂B           */
					/*   ȏ̏I҂^XNo^Ă邱Ƃ́AL蓾܂B           */
					/*   - ̃^XN͏IĂ炸AI҂^XN͖  󃊃Xg           */
					/*   - ̃^XN͏IĂ炸AI҂^XN͗L  I҂^XNo^ */
					/*   - ̃^XN͏Iς݂łAI҂^XN͖  󃊃Xg           */
					/*   - ̃^XN͏Iς݂łAI҂^XN͗L  I҂^XNo^ */
	LIST_ENTRY task_list_entry;	/* e^XNXgւ̓o^p                                                          */
					/* * ̃^XNwI^XNxłꍇAK^XNXgɓo^Ă܂B  */
					/*   Ȃ킿Atask_list_entry.Flink!=NULLłAq́wI^XNxƋʂł܂B */
					/*   o^̃^XNXǵAȉ̒ʂłB                                          */
					/*   - s\łꍇAws\^XNXgx(ready_task_list)                   */
					/*   - ^XNI҂łꍇA^XŃw^XNXgx(TASK.blocked_task_list)  */
					/*   - Cxg҂łꍇACxǵw^XNXgx(EVENT.blocked_task_list) */
					/* * ̃^XNwI^XNx(Iς݁AAI҂^XNo^)łꍇA    */
					/*   Itask_list_entry.Flink=NULLƂāAwI^XNxł邱Ƃ܂B    */
} TASK;

/* ^XNXPW[܂B
 * [in]
 *    //{{2014/09/12ǉ:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *	priority	VXeACh^XN̎sDxB
 *    //}}2014/09/12ǉ:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 * [note]
 *	* ^XN@\𗘗pAvP[VAŏɈxĂяoĂB
 *	  ̊֐ĂяoɃ^XN@\𗘗p悤ƂƁAُ퓮ƂȂ܂B
 *
 *		int main() {
 *			...
 *    //{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //		task_init(); // ^XN@\𗘗pȂ΁AKv!!
 *    //2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			task_init(INT_MIN); // ^XN@\𗘗pȂ΁AKv!!
 *    //}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			...
 *		}
 *
 *	* task_init()Ƒ΂ɂȂA^XN@\̃N[Abv֐͂܂B
 *	  task_init()ĂяoAvP[VAIOɌĂяoKv̂֐͂܂B
 *	  ܂A̃^XNc܂܂ŁAAvP[VIĂ\܂B
 *
 *	* ̊֐ĂяoReLXgAVXeACh^XNƂēo^܂B
 *    //{{2014/09/12폜:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //  VXeACh^XN̎sDx́AINT_MIN(AChDx)ɌŒŁAύXł܂B
 *    //}}2014/09/12폜:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *
 *	* VXeACh^XŃAIĂ͂܂B(task_exit()Ăяos)
 *	  ăVXeACh^XNIĂ܂ꍇ̓́A`łB
 *
 *		int main() {
 *			...
 *    //{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //		task_init();
 *    //2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			task_init(INT_MIN);
 *    //}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			...
 *			task_exit(0); // !!
 *		}
 */
//{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
//void task_init();
//2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
void task_init(int priority);
//}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B

/* s^XN擾܂B
 * [out]
 *	߂l		s^XNB
 * [note]
 *	* task_init()ĂяóAɉ炩̃^XNsłB
 *	  task_get_current()NULLԂƂ́A΂ɂ܂B
 */
TASK* task_get_current();

/* ^XN쐬܂B
 * [in]
 *	priority	sDxB
 *	task_proc	AvP[V`̃^XN֐B
 *	param		^XN֐ɈnAAvP[V`̃p[^B
 *	stack_size	X^bNTCYB(oCg)
 *			0w肷ƁÃX^bNTCYgp܂B
 * [out]
 *	߂l		쐬^XNB
 * [note]
 *	* ^XN̎sDx́A^XN쐬Ɏw肵AȌAύX邱Ƃ͂ł܂B
 *	  ^XN̎sDxύX֐pӂ邱Ƃ͊ȒPłAۂ̃AvP[VɂāA
 *	  ^XN쐬ɎsDx̕ύXKvƂȂʂ͂܂ƍlāAėpӂ܂łB
 *
 *	* ^XN쐬́ATXyh񐔂̏l0łB(=TXyhĂȂ)
 *	  Ȃ킿Atask_create()Ăяo^XNA쐬ꂽ^XN̎sDxꍇA
 *	  task_create()Ԃ̂́A쐬ꂽ^XN邩A܂́AIƂȂ܂B
 *
 *		int main() {
 *			...
 *    //{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //		task_init();                                 // sDx=INT_MIN
 *    //2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			task_init(INT_MIN);                          // sDx=INT_MIN
 *    //}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *			...
 *			task1 = task_create(1, task1_proc, NULL, 0); // sDx=1
 *			// ̎_ŁAtask1͕Ă邩AɏIĂB
 *			...
 *		}
 *
 *		int task1_proc(void* param) {                        // sDx=1
 *			...
 *			task2 = task_create(0, task2_proc, NULL, 0); // sDx=0
 *			// ̎_ŁAtask2̏́A܂sĂȂB
 *			...
 *		}
 *
 *	* ԂŃTXyhĂ^XN쐬@́ApӂĂ܂B
 *	  KvȂ΁A^XN֐̐擪ɎgTXyh鏈zu邱ƂŎł܂B
 *
 *		int task_proc(void* param) {
 *			task_suspend(task_get_current());
 *			...
 *		}
 */
TASK* task_create(int priority, int (*task_proc)(void* param), void* param, int stack_size);

/* ^XNI܂B
 * [in]
 *	exit_code	IR[hB
 * [note]
 *	* ̊֐́AԂ܂B
 *
 *	* AvP[V`̃^XN֐́Aȉ̓ނ̕@Ń^XNIł܂B
 *
 *		1. IR[hw肵āAtask_exit()ĂяoB
 *
 *			int task_proc(void* param) {
 *				...
 *				task_exit(result);
 *			}
 *
 *		2. IR[h𔺂āA^XN֐returnB
 *
 *			int task_proc(void* param) {
 *				...
 *				return result;
 *			}
 */
void task_exit(int exit_code) __attribute__((noreturn));

/* ^XN̏I҂āA\[X܂B
 * [in]
 *	task		҂^XNB
 * [out]
 *	߂l		IR[hB
 * [note]
 *	* g̏I҂Ƃ͂ł܂B
 *	  g̏I҂ƂƂƁAAT[g܂B
 *
 *		reulst = task_wait(task_get_current()); // !!
 *
 *	* task_wait()ĂяoƂŁAI^XÑ\[X܂B
 *	  task_wait()ĂяoȂƁAI^XÑ\[XꂸɁAcĂ܂܂B
 *	  JԂ쐬^XNɑ΂ẮAtask_wait()ĂяoāA\[XĂB
 *
 *		for(;;) {
 *			...
 *			task = task_create(0, task_proc, NULL, 0);
 *			...
 *			result = task_wait(task); // Kv!!
 *			...
 *		}
 *
 *	* ̃^XN̏IÃ^XN҂Ƃ͂ł܂B
 *	  ̃^XN̏IÃ^XN҂ƂƂƁAAT[g܂B
 *
 *		TASK* task4;
 *
 *		int task1_proc(void* param) {
 *			...
 *			task4 = task_create(0, task4_proc, NULL, 0);
 *			...
 * 		}
 *
 *		int task2_proc(void* param) {
 *			...
 *			result = task_wait(task4); // ǂ炩!!
 *			...
 * 		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			result = task_wait(task4); // ǂ炩!!
 *			...
 * 		}
 */
int task_wait(TASK* task);

/* ^XN̏I҂ɁA\[X܂B
 * [in]
 *	task		I^XNB
 * [note]
 *	* gI邱Ƃ͂ł܂B
 *	  gI悤ƂƁAAT[g܂B
 *
 *		task_kill(task_get_current()); // !!
 *
 *	* ɏIĂ^XNɑ΂āAtask_kill()ĂяoƂł܂B
 *	  I^XNAɏIĂ邩ۂɂāAtask_kill()̌ʂɈႢ͂܂B
 *
 *	* ^XN1^XN2̏I҂ĂƂɁA^XN3^XN2I邱Ƃ͂ł܂B
 *	  ̂悤ȎdlƂŔA^XN1Ăяotask_wait()̖߂l`łȂ߂łB
 *
 *		int task1_proc(void* param) {
 *			...
 *			result = task_wait(task2);
 *			...
 *		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			task_kill(task2); // !!
 *			...
 *		}
 *
 *	  ̖ɂ́Ae^XN݌vɁAtask_wait()ɂă\[Xׂ^XNA
 *	  ܂́Atask_kill()ɂă\[Xׂ^XNAmɂĂKv܂B
 *
 *	* ^XN1^XN2̏I҂ă\[X邽߂ɁAtask_wait()ĂяoĕĂƂA
 *	  ^XN3^XN1IƁA^XN1̓^XN2̕^XNXgo^܂B
 *	  AvP[VÃP[XӎāAʂ̎iɂă^XN2̃\[XȂA
 *	  ^XN2̃\[X[NĂ܂܂B
 *
 *		int task1_proc(void* param) {
 *			...
 *			result = task_wait(task2); // ̌ĂяoԂO...
 *			...
 *		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			task_kill(task1);          // ̌ĂяosƁAtask2\[X[N!!
 *			...
 *		}
 *
 *	  ̖́A^XÑ\[XɌ炸Atask1\[Xs^XNłꍇɁA
 *	  ̏sOɋIƁA\[X[NĂ܂łƌ܂B
 *	  Cuœɑ΍݂͐Ă܂̂ŁAAvP[VɂĒӂĂB
 */
void task_kill(TASK* task);

/* ^XÑTXyh񐔂𑝂₵܂B
 * [in]
 *	task		TXyh񐔂𑝂₷^XNB
 * [note]
 *	* TXyhINT_MAXāATXyh񐔂𑝂₷Ƃ͂ł܂B
 */
void task_suspend(TASK* task);

/* ^XÑTXyh񐔂炵܂B
 * [in]
 *	task		TXyh񐔂炷^XNB
 * [note]
 *	* TXyh0āATXyh񐔂炷Ƃ͂ł܂B
 */
void task_resume(TASK* task);

//{{2014/09/11ǉ:task_yield()ǉ܂B
/* ݂́ws^XNxƓsDxÁws\^XNxցA؂ւ܂B
 * [note]
 *	* ֐́A̓Iɂ́Aȉ̏s܂B
 *	  1. ݂́ws^XNxAws\^XNXgxꎞIɎO܂B
 *	     (֐Ă΂ꂽɁAws^XNx́Aws\^XNXgx̐擪ɗL͂Ȃ̂ŁAꎞIɎOB)
 *	  2. ݂́ws^XNxAws\^XNXgx̖ɒǉ܂B
 *	     (1.2.̌ʂƂāÁ݂ws^XNxAws\^XNXgx̐擪疖ցAړƂɂȂB)
 *	  3. ^XNXPW[Os܂B
 *	     ws\^XNXgx̒ɂ́Á݂ws^XNx荂sDx^XN݂͑Ȃ͂Ȃ̂ŁA
 *	     3.̌ʂƂāÁ݂ws^XNxƓsDxÁws\^XNxցA؂ւ܂B
 *	     ws\^XNXgxł邩ÁÁ݂ws^XNx̎sDx^XNꍇ́A
 *	     ɁAēxÁ݂ws^XNxցA؂ւ܂B
 *
 *	* ֐𗘗pƁAEhrȒPɎ邱Ƃł܂B
 *	  (܂ł́ACxg҂A^XÑTXyh񐔂gĎKvL܂A͊ȒPɎł܂B)
 *
 *		//1:CXbh܂ރEhr
 *		static int task_proc(void* param){
 *		  for(;;){
 *		    TRACE("task#%d   now=%d\n",(int)param,now);
 *		    task_yield();
 *		  }
 *		}
 *		void app_main(){
 *    //{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //	  task_init();//CXbhVXeACh^XNƂȂ
 *    //	  task_create(INT_MIN,task_proc,(void*)0,0);
 *    //	  task_create(INT_MIN,task_proc,(void*)1,0);
 *    //2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *		  task_init(0);//CXbhVXeACh^XNƂȂ	task_yield()păEhrsꍇ́ASẴ^XN̗Dx𓙂邱ƁB
 *		  task_create(0,task_proc,(void*)0,0);				̗ł́ASẴ^XN̗Dx(0)ƂB
 *		  task_create(0,task_proc,(void*)1,0);				ΉłǂA(0)łȂĂ\ȂB
 *    //}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *		  for(;;){
 *		    schedule();
 *		    TRACE("app_main now=%d\n",now);
 *		    task_yield();
 *		  }
 *		}
 *		//
 *		//app_main now=1
 *		//task#0   now=1
 *		//task#1   now=1
 *		//app_main now=2
 *		//task#0   now=2
 *		//task#1   now=2
 *		//app_main now=3
 *		//task#0   now=3
 *		//task#1   now=3
 *		//c
 *
 *	* ^XNXPW[AAChXbhƕpāA̒œ֐𗘗p̂֗Ǝv܂B
 *	  ̃AChAAChXbh̒Ŏs邱Ƃł܂B
 *
 *		//2:CXbh܂܂ȂEhr
 *		static int task_proc(void* param){
 *		  static int step[2];
 *		  for(;;){
 *		    TRACE("task#%d step=%d\n",(int)param,step[(int)param]++);
 *		    task_yield();
 *		  }
 *		}
 *		static int idle_proc(void* param){
 *    //{{2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *    //	  task_init();//AChXbhVXeACh^XNƂȂ
 *    //	  task_create(INT_MIN,task_proc,(void*)0,0);
 *    //	  task_create(INT_MIN,task_proc,(void*)1,0);
 *    //	  task_suspend(task_get_current());
 *    //2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *		  task_init(1);//AChXbhVXeACh^XNƂȂ
 *		  task_create(0,task_proc,(void*)0,0);//VXeACh^XN̕sDx̂ŁA܂JnȂB
 *		  task_create(0,task_proc,(void*)1,0);//VXeACh^XN̕sDx̂ŁA܂JnȂB
 *		  task_suspend(task_get_current());//VXeAChXbhTXyĥŁAL2^XNJnB
 *    //}}2014/09/12ύX:task_init()̈priorityǉAVXeACh^XN̎sDxݒł悤ɂ܂B
 *		  DIE();//NOTREACHED
 *		}
 *		void app_main(){
 *		  idle_init(idle_proc,NULL,0);
 *		  for(;;){
 *		    schedule();//̒łyield()łȂidle_yield()ĂԂ
 *		  }
 *		}
 *		//
 *		//task#0 step=0
 *		//task#1 step=0
 *		//task#0 step=1
 *		//task#1 step=1
 *		//task#0 step=2
 *		//task#1 step=2
 *		//c
 */
void task_yield();
//}}2014/09/11ǉ:task_yield()ǉ܂B

/****************************************************************************
 *	Cxg
 ****************************************************************************/

/* Cxg\  */
typedef struct _EVENT {
	int signal;			/* Cxg (0 = VOi, 1 = VOi) */
	int manual_reset;		/* Zbg敪 (0 = Zbg, 1 = 蓮Zbg) */
	LIST_ENTRY blocked_task_list;	/* ^XNXg */
} EVENT;

/* Cxg쐬܂B
 * [in]
 *	manual_reset	Zbg敪B
 *			0w肷ƁAZbgCxg쐬܂B
 *			1w肷ƁA蓮ZbgCxg쐬܂B
 * [out]
 *	߂l		쐬CxgB
 * [note]
 *	* Cxg̏Ԃ́AwVOiԁxłB
 *
 *	* event_create()̈ŁACxg̏Ԃw肷@́Ač̂܂łB
 *	  ԂŁwVOiԁx̃CxgKvƂȂP[X́A܂ƍlłB
 *	  KvȂ΁Aevent_create()̒ɁAevent_set()ĂяoĂB
 *
 *		event = event_create(0܂1); // VOi
 *		event_set(event);               //   VOi
 */
EVENT* event_create(int manual_reset);

/* Cxg폜܂B
 * [in]
 *	event		폜CxgB
 * [note]
 *	* Cxg҂́w^XNxcĂꍇACxg폜邱Ƃ͂ł܂B
 *	  Cxg폜悤ƂƁAAT[g܂B
 *
 *		int task1_proc(void* param) {
 *			...
 *			event = event_create(0܂1);
 *			task2 = task_create(0, task2_proc, NULL, 0);
 *			event_delete(event); // !!
 *			...
 *		}
 *
 *		int task2_proc(void* param) {
 *			...
 *			event_wait(event);
 *			...
 *		}
 */
void event_delete(EVENT* event);

/* Cxg҂܂B
 * [in]
 *	event		҂CxgB
 */
void event_wait(EVENT* event);

/* Cxg𔭍s܂B(Zbg)
 * [in]
 *	event		sCxgB
 * [note]
 *	* CxgԂwVOiԁxɂ܂B
 *	  Nw^XNx̐ƃCxgԂ̑Jڂ́AZbg敪Ɓw^XNx̗LɈˑ܂B
 *	  TˁAWindows̃Cxg֐ƓłBWindows̃Cxg֐dlQƂĂB
 */
void event_set(EVENT* event);

/* Cxg𔭍s܂B(pX)
 * [in]
 *	event		sCxgB
 * [note]
 *	* CxgԂwVOiԁxɂAɁwVOiԁxɖ߂܂B
 *	  Jw^XNx̐́AZbg敪Ɉˑ܂B
 *	  TˁAWindows̃Cxg֐ƓłBWindows̃Cxg֐dlQƂĂB
 */
void event_pulse(EVENT* event);

/* CxgVOiԂɂ܂B
 * [in]
 *	event		VOiԂɂCxgB
 */
void event_reset(EVENT* event);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_TASK_H__*/
