
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.code
	.align	2
strtrim_reject:
	.ascii	"\t\n\013\f\r \000"
; APP

		.code
		.align		1
		.global		strtrim
strtrim:
		pushn		%r3
		;//%r12 := s
		;//%r13 := mode
		;//%r14 := reject
		cmp		%r14, 0				;//if(!reject) { reject = strtrim_reject }
		jrne.d		5				;//
		 cmp		%r13, 3				;//%psr := ((unsigned)mode <=> (unsigned)3)			*delay*
		 ext		      strtrim_reject@h		;//							@
		 ext		      strtrim_reject@m		;//							@
		 ld.w		%r14, strtrim_reject@l		;//							@
		jrugt		strtrim_DIE			;//if((unsigned)mode >  (unsigned)3) { goto DIE() }	
		ld.w		%r0, %r12			;//%r0  := s
		jreq.d		strtrim_case_3			;//if((unsigned)mode == (unsigned)3) { goto case_3 }
		ld.w		%r1, %r14			;//%r1  := reject						*delay*
		cmp		%r13, 1				;//%psr := ((unsigned)mode <=> (unsigned)1)
		jrugt		strtrim_case_2			;//if((unsigned)mode >  (unsigned)1) { goto case_2 }
		jreq		strtrim_case_1			;//if((unsigned)mode == (unsigned)1) { goto case_1 }
		;//---------------------------------------------;//
;//strtrim_case_0:
		;//%r0  := s			gȂ
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject
		call.d		strtrim				;//%r10 := t = strtrim(s, 1, reject)
		ld.w		%r13, 1				;//%r13 :=                1					*delay*
		ld.w		%r2, %r10			;//%r2  := t
		ld.w		%r12, %r2			;//%r12 :=             t
		ld.w		%r13, 2				;//%r13 :=                2
		call.d		strtrim				;//%r10 := u = strtrim(t, 2, reject)
		ld.w		%r14, %r1			;//%r14 :=                   reject				*delay*
		ld.w		%r3, %r10			;//%r3  := u
	ext	free@rm		; 		xcall.d		free				;//   free(t)
	call.d	free@rl
		ld.w		%r12, %r2			;//%r12 := t							*delay*
		jp		strtrim_return_u		;//return  u
		;//---------------------------------------------;//
strtrim_case_1:
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s			gȂ
		;//%r14 := reject		gȂ
strtrim_case_1_L10:						;//do {
		ld.b		%r13, [%r0]+			;//%r13 := c = *s++
		cmp		%r13, 0				;//if(!c) { break }
		jreq		strtrim_case_1_L20		;//
	ext	strchr@rm	; 		xcall.d		strchr				;//%r10 := strchr(reject, c)
	call.d	strchr@rl
		ld.w		%r12, %r1			;//%r12 :=        reject					*delay*
		cmp		%r10, 0				;//} while(strchr(reject, c))
		jrne		strtrim_case_1_L10		;//
strtrim_case_1_L20:
		sub		%r0, 1				;//%r0  := s--
		jp.d		strtrim_case_2_L30		;//goto case_2_L30
		ld.w		%r13, -1			;//%r13 := n = SIZE_MAX						*delay*
		;//---------------------------------------------;//
strtrim_case_2:
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject		gȂ
	ext	strchr@rm	; 		xcall.d		strchr				;//%r10 := t = strchr(s, '0')
	call.d	strchr@rl
		ld.w		%r13, 0				;//%r13 :=               '0'					*delay*
		ld.w		%r2, %r10			;//%r2  := t
strtrim_case_2_L10:						;//do {
		cmp		%r2, %r0			;//     if(t-- <= s) { break }
		jrule.d		strtrim_case_2_L20		;//
		sub		%r2, 1				;//%r2  := t--							*delay*
		ld.b		%r13, [%r2]			;//
	ext	strchr@rm	; 		xcall.d		strchr				;//%r10 := strchr(reject, *t)
	call.d	strchr@rl
		ld.w		%r12, %r1			;//%r12 :=        reject					*delay*
		cmp		%r10, 0				;//} while(strchr(reject, *t))
		jrne		strtrim_case_2_L10		;//
strtrim_case_2_L20:						;//
		ld.w		%r13, %r2			;//%r13 :=     t
		sub		%r13, %r0			;//%r13 :=     t - s
		add		%r13, 1				;//%r13 := n = t - s + 1
strtrim_case_2_L30:						;//
	ext	strndup@rm	; 		xcall.d		strndup				;//%r10 := u = strndup(s, n)
	call.d	strndup@rl
		ld.w		%r12, %r0			;//%r12 :=             s					*delay*
		cmp		%r10, 0				;//    if(!u) { DIE() }
		jreq		strtrim_DIE			;//
		jp.d		strtrim_return_u		;//return  u
		ld.w		%r3, %r10			;//%r3  := u							*delay*
		;//---------------------------------------------;//
strtrim_case_3:
		;//%r0  := s
		;//%r1  := reject
		;//%r12 := s
		;//%r14 := reject		gȂ
	ext	strdup@rm	; 		xcall		strdup				;//%r10 := u = strdup(s, n)
	call	strdup@rl
		cmp		%r10, 0				;//    if(!u) { DIE() }
		jreq		strtrim_DIE			;//
		ld.w		%r2, %r10			;//%r2  := t
		ld.w		%r3, %r10			;//%r2  := u
strtrim_case_3_L10:						;//for(;;) {
		ld.b		%r13, [%r0]+			;//%r13 := c = *s++
		ld.b		[%r2]+, %r13			;//*t++  = c
		cmp		%r13, 0				;//    if(!c) { return  u }
		jreq		strtrim_return_u		;//
	ext	strchr@rm	; 		xcall.d		strchr				;//%r10 := p = strchr(reject, c)
	call.d	strchr@rl
		ld.w		%r12, %r1			;//%r12 :=            reject					*delay*
		cmp		%r8, %r10			;//%psr(C) :=   !!p								
		jp.d		strtrim_case_3_L10		;//										uif(strchr(reject, c)) { t--; }v򖳂ŎHv
		sbc		%r2, %r8			;//%r2  := t -= !!p						*delay*		
		;//---------------------------------------------;//
strtrim_return_u:
		;//%r3  := u
		ld.w		%r10, %r3			;//%r10 := u
		popn		%r3				;//
		ret						;//return  u

	.align	2
__LC0:
	.ascii	"clipstr.$\000"
; NO_APP
	.code
	.align	1
strtrim_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x3		; 	xld.w	%r13,0x000000d4		; 212
	ld.w	%r13,0x14
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strstrip
		.global		strchug
		.global		strchomp
strstrip:
		jp.d		strstrip_strchug_strchomp
		ld.w		%r13, 0				;//%r13 :=                mode = 0	*delay*
strchug:
		jp.d		strstrip_strchug_strchomp
		ld.w		%r13, 1				;//%r13 :=                mode = 1	*delay*
strchomp:
		ld.w		%r13, 2				;//%r13 :=                mode = 2
strstrip_strchug_strchomp:
		pushn		%r1
		ld.w		%r0, %r12			;//%r0  := s
	call.d	strtrim		; 		xcall.d		strtrim				;//%r10 := t = strtrim(s, mode, NULL)
		ld.w		%r14, 0				;//%r14 :=                      NULL	*delay*
		ld.w		%r1, %r10			;//%r0  := t
		ld.w		%r12, %r0			;//%r12 :=        s
	ext	strcpy@rm	; 		xcall.d		strcpy				;//%r10 := strcpy(s, t)
	call.d	strcpy@rl
		ld.w		%r13, %r1			;//%r13 :=           t			*delay*
	ext	free@rm		; 		xcall.d		free				;//        free(t)
	call.d	free@rl
		ld.w		%r12, %r1			;//%r12 :=      t			*delay*
		ld.w		%r10, %r0			;//%r10 := s
		popn		%r1				;//
		ret						;//return  2

; NO_APP
	.code
	.align	2
TBL_strescape:
	.byte	7
	.byte	8
	.byte	27
	.byte	12
	.byte	10
	.byte	13
	.byte	9
	.byte	11
	.byte	63
	.byte	39
	.byte	34
	.byte	92
	.byte	0
	.byte	97
	.byte	98
	.byte	101
	.byte	102
	.byte	110
	.byte	114
	.byte	116
	.byte	118
	.byte	63
	.byte	39
	.byte	34
	.byte	92
	.byte	0
; APP

		.code
		.align		1
		.global		strescape
strescape:
		pushn		%r3
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8
	ld.w	[%sp+0x1],%r12	; 		xld.w		[%sp+0x4], %r12			;//[%sp+4] := s
	ld.w	[%sp+0x0],%r13	; 		xld.w		[%sp+0x0], %r13			;//[%sp+0] := need_escape
		ld.w		%r0, 0				;//%r0  := r = NULL
		;//---------------------------------------------;//
strescape_L10:							;//for(;;) {
	ld.w	%r1,[%sp+0x1]	; 		xld.w		%r1, [%sp+0x4]			;//  %r1  := t = s
		ld.w		%r2, %r0			;//  %r2  := u = r
		;//---------------------------------------------;//
strescape_L20:							;//
		ld.b		%r3, [%r1]+			;//  %r3  := c = *t++
		cmp		%r3, 0				;//  if(!c) {
		jrne		strescape_L30
		cmp		%r0, 0				;//    if(!r) {
		jrne		strescape_L25
		add		%r2, 1				;//      %r2  :=            u + 1
	ext	malloc@rm	; 		xcall.d		malloc				;//      %r10 := r = malloc(u + 1)
	call.d	malloc@rl
		ld.w		%r12, %r2			;//      %r12 :=            u + 1				*delay*
		cmp		%r10, 0				;//      if(!r) { DIE() }
		jreq		strescape_DIE
		jp.d		strescape_L10
		ld.w		%r0, %r10			;//      %r0  := r						*delay*
strescape_L25:							;//    } else {
		ld.b		[%r2], %r8			;//      *u    = '0'
		ld.w		%r10, %r0			;//      return  r
	add	%sp,0x2		; 		xadd		%sp, %sp, 8
		popn		%r3
		ret						;//    }
		;//---------------------------------------------;//  } else {
strescape_L30:
	ext	TBL_strescape+0x0@h	; 		xld.w		%r12, TBL_strescape		;//    %r12 :=            TBL_strescape
	ext	TBL_strescape+0x0@m
	ld.w	%r12,TBL_strescape+0x0@l
	ext	strchr@rm	; 		xcall.d		strchr				;//    %r10 := p = strchr(TBL_strescape, c))
	call.d	strchr@rl
		ld.w		%r13, %r3			;//    %r13 :=                           c			*delay*
		cmp		%r10, 0				;//    if(    (p = strchr(TBL_strescape, c)) {
		jreq		strescape_L40
		cmp		%r0, 0				;//      if(!r) { u += 2
		jreq		strescape_ADD_2			;//      } else {
	ext	0x1		; 		xld.w		%r9, 92				;//        %r9  := ''
	ld.w	%r9,0x1c
		ld.b		[%r2]+, %r9			;//        *u++  = ''
		add		%r10, 13			;//        %r10 :=   p + SIZE_strescape
		ld.b		%r9, [%r10]			;//        %r9  := *(p + SIZE_strescape)
		ld.b		[%r2]+, %r9			;//        *u++  = *(p + SIZE_strescape)
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else
strescape_L40:
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0x0]			;//    %r12 := need_escape
		cmp		%r12, 0				;//    if((    need_escape) &&
		jreq		strescape_L50
	ext	strchr@rm	; 		xcall.d		strchr				;//    strchr( need_escape, c)) {
	call.d	strchr@rl
		ld.w		%r13, %r3			;//    %r13 :=              c					*delay*
		cmp		%r10, 0
		jreq		strescape_L50
		cmp		%r0, 0				;//      if(!r) { u += 2
		jreq		strescape_ADD_2			;//      } else {
	ext	0x1		; 		xld.w		%r9, 92				;//        %r9  := ''
	ld.w	%r9,0x1c
		ld.b		[%r2]+, %r9			;//        *u++  = ''
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else
strescape_L50:
	ext	isprint@rm	; 		xcall.d		isprint				;//    if(isprint(c)) {
	call.d	isprint@rl
		ld.w		%r12, %r3			;//    %r12 :=    c						*delay*
		cmp		%r10, 0
		jrne		strescape_L60
		cmp		%r0, 0				;//      if(!r) { u += 4
		jreq		strescape_ADD_4			;//      } else {
	ext	0x1		; 		xld.w		%r9, 92				;//        %r9  := ''
	ld.w	%r9,0x1c
		ld.b		[%r2]+, %r9			;//        *u++  = ''
	ext	0x7		; 		xand		%r5, %r3, 7			;//        %r5  :=        (c >> 0) & 7
	and	%r5,%r3
		add		%r5, 48				;//        %r5  := '0' + ((c >> 0) & 7)
		sra		%r3, 3				;//        %r3  :=         c >> 3
	ext	0x7		; 		xand		%r4, %r3, 7			;//        %r5  :=        (c >> 3) & 7
	and	%r4,%r3
		add		%r4, 48				;//        %r5  := '0' + ((c >> 3) & 7
		sra		%r3, 3				;//        %r3  :=         c >> 6
	and	%r3,0x3		; 		xand		%r3, %r3, 3			;//        %r3  :=        (c >> 6) & 3
		add		%r3, 48				;//        %r3  := '0' + ((c >> 6) & 3
		ld.b		[%r2]+, %r3			;//        *u++  = '0' + ((c >> 6) & 3
		ld.b		[%r2]+, %r4			;//        *u++  = '0' + ((c >> 3) & 7
		ld.b		[%r2]+, %r5			;//        *u++  = '0' + ((c >> 0) & 7
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//    } else {
strescape_L60:
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strescape_ADD_1			;//      } else {
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strescape_L20			;//      }
		;//---------------------------------------------;//} } }
strescape_ADD_4:
		add		%r2, 2				;//%r2  := u += 2 + 1 + 1
strescape_ADD_2:
		add		%r2, 1				;//%r2  := u +=     1 + 1
strescape_ADD_1:
		jp.d		strescape_L20
		add		%r2, 1				;//%r2  := u +=         1					*delay*

; NO_APP
	.code
	.align	1
strescape_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x6		; 	xld.w	%r13,0x000001af		; 431
	ld.w	%r13,0x2f
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strcompress
strcompress:
		pushn		%r3
	sub	%sp,0x4		; 		xsub		%sp, %sp, 16
	ld.w	[%sp+0x1],%r12	; 		xld.w		[%sp+0x4], %r12			;//[%sp+4]  := s
	ld.w	[%sp+0x2],%r13	; 		xld.w		[%sp+0x8], %r13			;//[%sp+8]  := endptr
	ld.w	[%sp+0x3],%r14	; 		xld.w		[%sp+0xc], %r14			;//[%sp+12] := delim
		ld.w		%r0, 0				;//%r0  := r = NULL
		;//---------------------------------------------;//
strcompress_L10:						;//for(;;) {
	ld.w	%r1,[%sp+0x1]	; 		xld.w		%r1, [%sp+0x4]			;//  %r1  := t = s
		ld.w		%r2, %r0			;//  %r2  := u = r
		;//---------------------------------------------;//
strcompress_L20:						;//
		ld.b		%r3, [%r1]+			;//  %r3  := c = *t++
		cmp		%r3, 0				;//  if(!c || (delim && strchr(delim, c))) {
		jreq		strcompress_BREAK
	ld.w	%r12,[%sp+0x3]	; 		xld.w		%r12, [%sp+0xc]			;//  %r12 :=                   delim
		cmp		%r12, 0
		jreq		strcompress_L30
	ext	strchr@rm	; 		xcall.d		strchr				;//  %r10 :=            strchr(delim, c)
	call.d	strchr@rl
		ld.w		%r13, %r3			;//  %r13 :=                          c				*delay*
		cmp		%r10, 0
		jreq		strcompress_L30
strcompress_BREAK:
		cmp		%r0, 0				;//    if(!r) {
		jrne		strcompress_L25
		add		%r2, 1				;//      %r2  :=            u + 1
	ext	malloc@rm	; 		xcall.d		malloc				;//      %r10 := r = malloc(u + 1)
	call.d	malloc@rl
		ld.w		%r12, %r2			;//      %r12 :=            u + 1				*delay*
		cmp		%r10, 0				;//      if(!r) { DIE() }
		jreq		strcompress_DIE
		jp.d		strcompress_L10
		ld.w		%r0, %r10			;//      %r0  := r						*delay*
strcompress_L25:						;//    } else {
	ld.w	%r9,[%sp+0x2]	; 		xld.w		%r9, [%sp+0x8]			;//      %r9  := endptr
		cmp		%r9, 0				;//      if(endptr) {
		jreq		3
		 sub		%r1, 1				;//        *endptr = t - 1
		 ld.w		[%r9], %r1			;//      }
		ld.b		[%r2], %r8			;//      *u    = '0'
		ld.w		%r10, %r0			;//      return  r
	add	%sp,0x4		; 		xadd		%sp, %sp, 16
		popn		%r3
		ret						;//    }
		;//---------------------------------------------;//  } else {
strcompress_L30:
	ext	0x1		; 		xcmp		%r3, 92				;//    if(c != '') { goto COPY }
	cmp	%r3,0x1c
		jrne		strcompress_COPY
		ld.b		%r3, [%r1]+			;//    %r3  := c = *t++
		cmp		%r3, 0				;//    if(!c) { goto BREAK }
		jreq		strcompress_BREAK
	ext	TBL_strescape+0xd@h	; 		xld.w		%r12, TBL_strescape+0xd		;//    %r12 :=            TBL_strescape + SIZE_strescape
	ext	TBL_strescape+0xd@m
	ld.w	%r12,TBL_strescape+0xd@l
	ext	strchr@rm	; 		xcall.d		strchr				;//    %r10 := p = strchr(TBL_strescape + SIZE_strescape, c))
	call.d	strchr@rl
		ld.w		%r13, %r3			;//    %r13 :=                                            c	*delay*
		cmp		%r10, 0				;//    if(    (p = strchr(TBL_strescape + SIZE_strescape, c)) {
		jreq		strcompress_L40
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		sub		%r10, 13			;//        %r10 :=   p - SIZE_strescape
		ld.b		%r9, [%r10]			;//        %r9  := *(p - SIZE_strescape)
		ld.b		[%r2]+, %r9			;//        *u++  = *(p - SIZE_strescape)
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L40:
		ld.w		%r4, %r3			;//    %r4  := x = c
		sub		%r4, 48				;//    %r4  := x -= '0'
		cmp		%r4, 7				;//    if((unsigned)x <= (unsigned)7) {
		jrugt		strcompress_L50
		ld.b		%r9, [%r1]			;//      %r9  := y = *t
		sub		%r9, 48				;//      %r9  := y -= '0'
		cmp		%r9, 7				;//      if((unsigned)y <= (unsigned)7) {
		jrugt		strcompress_L45
		 sla		%r4, 3				;//        %r4  := x <<= 3
		 or		%r4, %r9			;//        %r4  := x  |= y
		 add		%r1, 1				;//        %r1  := t++
		 ld.b		%r9, [%r1]			;//        %r9  := y = *t
		 sub		%r9, 48				;//        %r9  := y -= '0'
		 cmp		%r9, 7				;//        if((unsigned)y <= (unsigned)7) {
		 jrugt		strcompress_L45
		  sla		%r4, 3				;//          %r4  := x <<= 3
		  or		%r4, %r9			;//          %r4  := x  |= y
		  add		%r1, 1				;//          %r1  := t++
strcompress_L45:						;//      } }
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.b		[%r2]+, %r4			;//        *u++  = x
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L50:
	ld.w	%r9,%r3		; 		xand		%r9, %r3, -33			;//    if((c == 'x') || (c == 'X')) {
	ext	0x1fff
	and	%r9,0x1f
	ext	0x1		; 		xcmp		%r9, 88
	cmp	%r9,0x18
		jrne		strcompress_L60
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.w		%r12, %r1			;//        %r12 :=             t
		ld.w		%r13, %sp			;//        %r13 :=                &t
	ld.w	[%sp+0x0],%r1	; 		xld.w		[%sp+0x0], %r1
	ext	strtoul@rm	; 		xcall.d		strtoul				;//        %r10 := x = strtoul(t, &t, 16)
	call.d	strtoul@rl
		ld.w		%r14, 16			;//        %r14 :=                    16			*delay*
	ld.w	%r1,[%sp+0x0]	; 		xld.w		%r1, [%sp+0x0]			;//        %r1  :=                 t
		ld.b		[%r2]+, %r10			;//        *u++  = x
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//    } else
strcompress_L60:
		cmp		%r3, 10				;//    if(c == 'n') {
		jreq		strcompress_L20			;//      /** no job **/
		;//---------------------------------------------;//    } else {
strcompress_COPY:
		cmp		%r0, 0				;//      if(!r) { u += 1
		jreq		strcompress_ADD_1		;//      } else {
		ld.b		[%r2]+, %r3			;//        *u++  = c
		jp		strcompress_L20			;//      }
		;//---------------------------------------------;//} } }
strcompress_ADD_1:
		jp.d		strcompress_L20
		add		%r2, 1				;//%r2  := u +=         1					*delay*

; NO_APP
	.align	1
strcompress_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x9		; 	xld.w	%r13,0x0000025e		; 606
	ld.w	%r13,0x1e
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strfreev
strfreev:
		cmp		%r12, 0			;//if(!str_array) { goto L30 }
		jreq		strfreev_L30
		pushn		%r12
		ld.w		%r0, %r12		;//%r0  := p = str_array
strfreev_L10:
		ld.w		%r12, [%r0]+		;//while((str = *p++)) {
		cmp		%r12, 0
		jreq		strfreev_L20
		call		strfreev_L30		;// free(str)		uxcall freevƏA̕ext1ߖłB
		jp		strfreev_L10		;//}
strfreev_L20:
		popn		%r12
strfreev_L30:
	ext	free@rm		; 		xjp		free			;//free(str_array)	(!str_array)̏ꍇs邪Afree(NULL)͈SłB
	jp	free@rl


		.code
		.align		1
		.global		strv_length
strv_length:
		ld.w		%r10, -1		;//%r10 := n = -1
		ld.w		%r9, [%r12]+		;//%r9  := str = *str_array++
		 cmp		%r9, 0			;//    if(!str) { break }
		jrne.d		-2
		add		%r10, 1			;//%r10 := n++			*delay*
		ret


		.code
		.align		1
		.global		strdupv
strdupv:
		pushn		%r2
	call.d	strv_length	; 		xcall.d		strv_length		;//%r10 := n = strv_length(str_array)
		ld.w		%r0, %r12		;//%r0  := str_array			*delay*
		add		%r10, 1			;//%r12 := n++
		ld.w		%r12, %r10		;//%r12 :=            n
	ext	calloc@rm	; 		xcall.d		calloc			;//%r10 := p = calloc(n, sizeof(char*))
	call.d	calloc@rl
		ld.w		%r13, 4			;//%r13 :=               sizeof(char*)	*delay*
		cmp		%r10, 0			;//if(!p) { DIE() }
		jreq		strdupv_DIE		;//
		ld.w		%r1, %r10		;//%r1  := p
		jp.d		strdupv_START		;//goto START
		ld.w		%r2, %r10		;//%r2  := q = p			*delay*
strdupv_LOOP:						;//do {
	ext	strdup@rm	; 		xcall		strdup			;//  %r10 := r = strdup(r)
	call	strdup@rl
		cmp		%r10, 0			;//  if(!r) { DIE() }
		jreq		strdupv_DIE		;//
		ld.w		[%r2]+, %r10		;//  *q++  = r
strdupv_START:						;//
		ld.w		%r12, [%r0]+		;//  %r12 := r = *str_array++
		cmp		%r12, 0			;//
		jrne		strdupv_LOOP		;//} while(r)
		ld.w		%r10, %r1		;//%r10 := p
		popn		%r2
		ret

; NO_APP
	.align	1
strdupv_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xb		; 	xld.w	%r13,0x000002f2		; 754
	ld.w	%r13,0x32
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strdup_printf
		.global		strdup_vprintf
		;//[%sp+0] := retp
		;//[%sp+4] := fmt
		;//[%sp+8] := ...
strdup_printf:
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]		;//%r12 := fmt
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8		;//%r13 := ap
	add	%r13,0x8
strdup_vprintf:
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
		ld.w		%r14, %r13		;//%r14 :=                               ap
		ld.w		%r13, %r12		;//%r13 :=                          fmt
		ld.w		%r12, %sp		;//%r12 :=                    &str
	ext	vasprintf@rm	; 		xcall		vasprintf		;//%r10 := retval = vasprintf(&str, fmt, ap)
	call	vasprintf@rl
		cmp		%r10, -1		;//if(retval == -1) { DIE() }
		jreq		strdup_vprintf_DIE
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]		;//%r10 := str
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		ret					;//return  str

; NO_APP
	.align	1
strdup_vprintf_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xc		; 	xld.w	%r13,0x0000031f		; 799
	ld.w	%r13,0x1f
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strconcat
		.global		strjoin
		.global		strjoinv
strconcat:
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := s
		;//[%sp+ 8] := ...
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 4			;//%r13 := str_array = &{s,...}		//sstr_array̐擪vfƂ邱ƂɒӂB
	add	%r13,0x4
		jp.d		strjoinv
		ld.w		%r12, 0				;//%r12 := separator = NULL		*delay*
strjoin:
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := separator
		;//[%sp+ 8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]			;//%r12 := separator
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8			;//%r13 := str_array = &...
	add	%r13,0x8
strjoinv:
		pushn		%r1
	sub	%sp,0x4		; 		xsub		%sp, %sp, 16
		ld.w		%r0, %r12			;//%r0      := separator
		ld.w		%r1, %r13			;//%r1      := str_array
	ext	strjoinv_FMT+0x0@h	; 		xld.w		%r12, strjoinv_FMT		;//%r12     := g%s%s%sh	yӁzp̓dpgasmubN̕I[ƌȂ̂ŎgpsB
	ext	strjoinv_FMT+0x0@m
	ld.w	%r12,strjoinv_FMT+0x0@l
	ld.w	[%sp+0x0],%r12	; 		xld.w		[%sp+ 0x0], %r12			;//[%sp+ 0] := g%s%s%sh
		add		%r12, 6				;//%r12     :=       gh
	ld.w	[%sp+0x2],%r12	; 		xld.w		[%sp+ 0x8], %r12			;//[%sp+ 8] := sep = gh
	ext	strdup@rm	; 		xcall		strdup				;//%r10     := newStr = strdup(gh)
	call	strdup@rl
		cmp		%r10, 0				;//if(!newStr) { DIE() }
		jreq		strjoinv_DIE
	ld.w	[%sp+0x1],%r10	; 		xld.w		[%sp+ 0x4], %r10			;//[%sp+ 4] := oldStr = newStr			ŏ̃[voldStr
strjoinv_L10:	;//---------------------------------------------;//for(;;) {
		;//%r0      := separator
		;//%r1      := str_array
		;//%r10     := newStr
		;//[%sp+ 0] := g%s%s%sh	strdup_printfւ̈
		;//[%sp+ 4] := oldStr		strdup_printfւ̈
		;//[%sp+ 8] := sep		strdup_printfւ̈
		;//[%sp+12] := str		strdup_printfւ̈
		ld.w		%r9, [%r1]+			;//  %r9      := str = *str_array++
		cmp		%r9, 0
		jreq		strjoinv_L20
	ld.w	[%sp+0x3],%r9	; 		xld.w		[%sp+0xc], %r9			;//  [%sp+12] := str
	call	strdup_printf	; 		xcall		strdup_printf			;//  %r10     := newStr = strdup_printf(g%s%s%sh, oldStr, sep, str)
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+ 0x4]			;//  %r12     := oldStr		
	ld.w	[%sp+0x1],%r10	; 		xld.w		[%sp+ 0x4], %r10			;//  [%sp+ 4] := oldStr = newStr		̃[voldStr
	ext	free@rm		; 		xcall		free				;//         free(oldStr)	
	call	free@rl
		cmp		%r0, 0				;//  if(separator) { sep = separator }
		jreq		strjoinv_L10
	ld.w	[%sp+0x2],%r0	; 		xld.w		[%sp+ 0x8], %r0
		jp		strjoinv_L10
strjoinv_L20:	;//---------------------------------------------;//}
	ld.w	%r10,[%sp+0x1]	; 		xld.w		%r10, [%sp+ 0x4]			;//%r10     := newStr
	add	%sp,0x4		; 		xadd		%sp, %sp, 16
		popn		%r1
		ret

; NO_APP
	.align	1
strjoinv_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0xe		; 	xld.w	%r13,0x0000039f		; 927
	ld.w	%r13,0x1f
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
	.code
	.align	2
strjoinv_FMT:
	.ascii	"%s%s%s\000"
; APP

		.code
		.align		1
		.global		strsplit
		.global		strsplit_set
strsplit:
		jp.d		strsplit_sub
		ld.w		%r15, 0			;//%r15    := delimiter_len = 0					*delay*
strsplit_set:
		ld.w		%r15, 1			;//%r15    := delimiter_len = 1
strsplit_sub:
		pushn		%r3
	sub	%sp,0x3		; 		xsub		%sp, %sp, 12
		ld.w		%r0, 0			;//%r0     := argv = NULL
		ld.w		%r1, 0			;//%r1     := size = 0
		ld.b		%r9, [%r12]		;//%r9     := *s
		cmp		%r9, 0			;//if(!(*s)) { goto strsplit_sub_L40 }
		jreq		strsplit_sub_L40
		ld.w		%r2, %r12		;//%r2     := s
		ld.w		%r3, %r14		;//%r3     := max_tokens
	ld.w	[%sp+0x0],%r13	; 		xld.w		[%sp+0x0], %r13		;//[%sp+0] := delimiter
	ext	strpbrk+0x0@h	; 		xld.w		%r9, strpbrk		;//%r9     := fn = strpbrk
	ext	strpbrk+0x0@m
	ld.w	%r9,strpbrk+0x0@l
		cmp		%r15, 0			;//if(!delimiter_len) {
		jrne		strsplit_sub_L10
		ld.w		%r12, %r13		;//  %r12  :=                        delimiter
	ext	strlen@rm	; 		xcall		strlen			;//  %r10  := delimiter_len = strlen(delimiter)
	call	strlen@rl
		cmp		%r10, 0			;//  if(!delimiter_len) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r15, %r10		;//  %r15  := delimiter_len
	ext	strstr+0x0@h	; 		xld.w		%r9, strstr		;//  %r9   := fn = strstr
	ext	strstr+0x0@m
	ld.w	%r9,strstr+0x0@l
strsplit_sub_L10:					;//}
	ld.w	[%sp+0x1],%r15	; 		xld.w		[%sp+0x4], %r15		;//[%sp+4] := delimiter_len
	ld.w	[%sp+0x2],%r9	; 		xld.w		[%sp+0x8], %r9		;//[%sp+8] := fn
strsplit_sub_L20:					;//for(;;) {
		ld.w		%r12, %r0		;//  %r12    :=                argv
		ld.w		%r13, %r1		;//  %r13    :=                      size
	ext	realloc@rm	; 		xcall.d		realloc			;//  %r10    := argv = realloc(argv, size + sizeof(char*))
	call.d	realloc@rl
		add		%r13, 4			;//  %r13    :=                      size + sizeof(char*)	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r0, %r10		;//  %r0     := argv
		cmp		%r3, 1			;//  if((max_tokens >= 1) &&
		jrlt		3
		 sub		%r3, 1			;//   (--max_tokens == 0)) { break }
		 jreq		strsplit_sub_L30
	ld.w	%r9,[%sp+0x2]	; 		xld.w		%r9, [%sp+0x8]		;//  %r9    :=       fn
	ld.w	%r13,[%sp+0x0]	; 		xld.w		%r13, [%sp+0x0]		;//  %r13   :=              delimiter
		call.d		%r9			;//  %r10   := p = (*fn)(s, delimiter)
		ld.w		%r12, %r2		;//  %r12   :=           s					*delay*
		cmp		%r10, 0			;//  if(!p) { break }
		jreq		strsplit_sub_L30
		ld.w		%r12, %r2		;//  %r12   :=             s
		ld.w		%r13, %r10		;//  %r13   :=                p
		sub		%r13, %r2		;//  %r13   :=                p - s
	ld.w	%r2,[%sp+0x1]	; 		xld.w		%r2, [%sp+0x4]		;//  %r2    :=         delimiter_len
	ext	strndup@rm	; 		xcall.d		strndup			;//  %r10   := t = strndup(s, p - s)
	call.d	strndup@rl
		add		%r2, %r10		;//  %r2    := s = p + delimiter_len				*delay*
		cmp		%r10, 0			;//  if(!t) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r9, %r0		;//  %r9    := argv
		add		%r9, %r1		;//  %r9    := argv[argc]
		ld.w		[%r9], %r10		;//  argv[argc] = t
		jp.d		strsplit_sub_L20	;//}
		add		%r1, 4			;//  %r1    := size += sizeof(char*)				*delay*
strsplit_sub_L30:
	ext	strdup@rm	; 		xcall.d		strdup			;//%r10     := strdup(s)
	call.d	strdup@rl
		ld.w		%r12, %r2		;//%r12     :=        s						*delay*
		ld.w		%r9, %r0		;//%r9      := argv
		add		%r9, %r1		;//%r9      := argv[argc]
		ld.w		[%r9], %r10		;//argv[argc] = t
		add		%r1, 4			;//%r1      := size += sizeof(char*)
strsplit_sub_L40:
		ld.w		%r12, %r0		;//%r12      :=                argv
		ld.w		%r13, %r1		;//%r13      :=                      size
	ext	realloc@rm	; 		xcall.d		realloc			;//%r10      := argv = realloc(argv, size + sizeof(char*))
	call.d	realloc@rl
		add		%r13, 4			;//%r13      :=                      size + sizeof(char*)	*delay*
		cmp		%r10, 0			;//if(!argv) { DIE() }
		jreq		strsplit_sub_DIE
		ld.w		%r9, %r10		;//%r9      := argv
		add		%r9, %r1		;//%r9      := argv[argc]
		ld.w		[%r9], %r8		;//argv[argc] = NULL
	add	%sp,0x3		; 		xadd		%sp, %sp, 12
		popn		%r3
		ret

; NO_APP
	.code
	.align	1
strsplit_sub_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x11		; 	xld.w	%r13,0x0000044a		; 1098
	ld.w	%r13,0xa
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		textwrap
textwrap:
		pushn		%r3
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
	ld.w	[%sp+0x0],%r13	; 		xld.w		[%sp+0x0], %r13		;//[%sp+0] := w
		ld.w		%r0, 0			;//%r0     :=  argv = NULL
		ld.w		%r1, 0			;//%r1     := (argc*4) = 0
		jp.d		textwrap_START		;//goto START
		ld.w		%r2, %r12		;//%r2     := s					*delay*
textwrap_LOOP:	;//-------------------------------------;//do {
		;//%r0     :=  argv
		;//%r1     := (argc*4)
		;//%r2     :=  s
		;//%r3     :=  n
		;//[%sp+0] :=  w
		ld.w		%r12, %r2		;//  %r12 :=             s
		add		%r12, %r3		;//  %r12 :=            &s[n+0]
		ld.b		%r12, [%r12]		;//  %r12 :=             s[n+0]
		cmp		%r12, 0			;//  if(                 s[n+0]) {		!INTERLOCK!
		jreq		textwrap_NUL		;//
	ext	ismbblead@rm	; 		xcall		ismbblead		;//    %r10 := ismbblead(s[n+0])
	call	ismbblead@rl
		cmp		%r10, 0			;//    if(    !ismbblead(s[n+0]) {
		jreq		textwrap_ANK		;//    goto ANK } else {
		ld.w		%r12, %r2		;//      %r12 :=            s
		add		%r12, %r3		;//      %r12 :=           &s[n+0]
	ext	0x1		; 		xld.b		%r12, [%r12+0x1]		;//      %r12 :=            s[n+1]
	ld.b	%r12,[%r12]
	ext	ismbbtrail@rm	; 		xcall		ismbbtrail		;//      %r10 := ismbbtrail(s[n+1])
	call	ismbbtrail@rl
		cmp		%r10, 0			;//      if(     ismbbtrail(s[n+1]) {
		jrne.d		textwrap_KNJ		;//
		ld.w		%r4, 2			;//        %r4  := c = 2			*delay*
textwrap_ANK:						;//      } else {
		ld.w		%r4, 1			;//        %r4  := c = 1
textwrap_KNJ:						;//    } }
		add		%r3, %r4		;//    %r3  := n += c
		cmp		%r3, %r4		;//    if(n == c) { goto LOOP }					s͕ωĂȂ̂(*s)͕̌svłLOOP֖߂ėǂBCłcontinueĝwhile(*s)ɖ߂Ă܂ۂ̂Ƃ(*s)͖̌ʂł
		jreq		textwrap_LOOP		;//
	ld.w	%r5,[%sp+0x0]	; 		xld.w		%r5, [%sp+0x0]		;//    %r5  := w
		cmp		%r3, %r5		;//    if(n <= w) { goto LOOP }			!INTERLOCK!	s͕ωĂȂ̂(*s)͕̌svłLOOP֖߂ėǂBCłcontinueĝwhile(*s)ɖ߂Ă܂ۂ̂Ƃ(*s)̌
		jrle		textwrap_LOOP		;//
		sub		%r3, %r4		;//    %r3  := n -= c
textwrap_NUL:						;//  }
		ld.w		%r12, %r0		;//  %r12 :=                argv
		ld.w		%r13, %r1		;//  %r13 :=                      (argc*4)
	ext	realloc@rm	; 		xcall.d		realloc			;//  %r10 := argv = realloc(argv, (argc*4)+4)
	call.d	realloc@rl
		add		%r13, 4			;//  %r13 :=                      (argc*4)+4	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		textwrap_DIE		;//
		ld.w		%r0, %r10		;//  %r0  := argv
		ld.w		%r12, %r2		;//  %r12 :=             s
	ext	strndup@rm	; 		xcall.d		strndup			;//  %r10 := t = strndup(s, n)
	call.d	strndup@rl
		ld.w		%r13, %r3		;//  %r13 :=                n			*delay*
		add		%r1, %r0		;//  %r1  := argv[argc  ]
		ld.w		[%r1]+, %r10		;//          argv[argc++] = t
		sub		%r1, %r0		;//  %r1  :=     (argc*4)
		add		%r2, %r3		;//  %r2  :=  s += n
textwrap_START:
		ld.b		%r4, [%r2]		;//  %r4  := *s
		cmp		%r4, 0			;//  						!INTERLOCK!
		jrne.d		textwrap_LOOP		;;//} while( *s)
		ld.w		%r3, 0			;//  %r3  :=       n = 0			*delay*		'n=0'ƕ؂o'n=0'˂B
		;//-------------------------------------;//
		ld.w		%r12, %r0		;//  %r12 :=                argv
		ld.w		%r13, %r1		;//  %r13 :=                      (argc*4)
	ext	realloc@rm	; 		xcall.d		realloc			;//  %r10 := argv = realloc(argv, (argc*4)+4)
	call.d	realloc@rl
		add		%r13, 4			;//  %r13 :=                      (argc*4)+4	*delay*
		cmp		%r10, 0			;//  if(!argv) { DIE() }
		jreq		textwrap_DIE		;//
		add		%r1, %r10		;//  %r1  := argv[argc]
		ld.w		[%r1], %r8		;//          argv[argc] = NULL
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		popn		%r3
		ret

; NO_APP
	.align	1
textwrap_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x12		; 	xld.w	%r13,0x000004be		; 1214
	ld.w	%r13,0x3e
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
	.align	1
	.global	strdup_splitpath
strdup_splitpath:
;	.frame	%sp,796,$31		# vars= 772, regs= 5/0, args= 4, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0xc2	; 	xsub	%sp,%sp,776
	ld.w	%r1,%r13
	ld.w	%r2,%r14
	ld.w	%r3,%r15
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,4
	add	%r0,0x4
	ext	0x204		; 	xadd	%r10,%r0,516
	add	%r10,%r0
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ld.w	%r13,%r0
	ld.w	%r14,%sp	; 	xadd	%r14,%sp,8
	add	%r14,0x8
	ext	0x104		; 	xadd	%r15,%r0,260
	add	%r15,%r0
	ext	splitpath@rm	; 	xcall	splitpath
	call	splitpath@rl
	cmp	%r1,0x0
	jreq	__LX79		; 	xjreq	__L79
	ld.w	%r12,%r0
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	ld.w	[%r1],%r10	; 	xld.w	[%r1],%r10
	cmp	%r10,0x0
	jrne	__LX79		; 	xjrne	__L79
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x13		; 	xld.w	%r13,0x000004d1		; 1233
	ld.w	%r13,0x11
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX79:				; __L79:
	cmp	%r2,0x0
	jreq	__LX81		; 	xjreq	__L81
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,8
	add	%r12,0x8
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	ld.w	[%r2],%r10	; 	xld.w	[%r2],%r10
	cmp	%r10,0x0
	jrne	__LX81		; 	xjrne	__L81
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x13		; 	xld.w	%r13,0x000004d2		; 1234
	ld.w	%r13,0x12
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX81:				; __L81:
	cmp	%r3,0x0
	jreq	__LX83		; 	xjreq	__L83
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,264
	ext	0x4
	add	%r12,0x8
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	ld.w	[%r3],%r10	; 	xld.w	[%r3],%r10
	cmp	%r10,0x0
	jrne	__LX83		; 	xjrne	__L83
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x13		; 	xld.w	%r13,0x000004d3		; 1235
	ld.w	%r13,0x13
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX83:				; __L83:
	ext	0xc		; 	xld.w	%r11,[%sp+0x31c]
	ld.w	%r11,[%sp+0x1c]
	cmp	%r11,0x0
	jreq	__LX85		; 	xjreq	__L85
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,520
	ext	0x8
	add	%r12,0x8
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	ext	0xc		; 	xld.w	%r11,[%sp+0x31c]
	ld.w	%r11,[%sp+0x1c]
	ld.w	[%r11],%r10	; 	xld.w	[%r11],%r10
	cmp	%r10,0x0
	jrne	__LX85		; 	xjrne	__L85
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x13		; 	xld.w	%r13,0x000004d4		; 1236
	ld.w	%r13,0x14
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX85:				; __L85:
	add	%sp,0xc2	; 	xadd	%sp,%sp,776
	popn	%r3
	ret
	.align	1
	.global	strdup_makepath
strdup_makepath:
;	.frame	%sp,268,$31		# vars= 260, regs= 1/0, args= 4, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x42	; 	xsub	%sp,%sp,264
	ld.w	%r10,%r12
	ld.w	%r11,%r13
	ld.w	%r4,%r14
	ld.w	[%sp+0x0],%r15	; 	xld.w	[%sp],%r15
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,4
	add	%r12,0x4
	ld.w	%r13,%r10
	ld.w	%r14,%r11
	ld.w	%r15,%r4
	ext	makepath@rm	; 	xcall	makepath
	call	makepath@rl
	ld.w	%r12,%sp	; 	xadd	%r12,%sp,4
	add	%r12,0x4
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	cmp	%r10,0x0
	jrne	__LX88		; 	xjrne	__L88
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x13		; 	xld.w	%r13,0x000004d9		; 1241
	ld.w	%r13,0x19
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX88:				; __L88:
	add	%sp,0x42	; 	xadd	%sp,%sp,264
	ret
; APP

		.code
		.align		1
		.global		str_has_prefix
		.global		str_has_suffix
str_has_prefix:
		jp.d		str_has_prefix_suffix
		ld.w		%r14,  0			;//%r14 := mask =  0									*delay*
str_has_suffix:
		ld.w		%r14, -1			;//%r14 := mask = -1
str_has_prefix_suffix:
		pushn		%r3
		ld.w		%r0, %r12			;//%r0  := s1
		ld.w		%r1, %r13			;//%r1  := s2
	ext	strlen@rm	; 		xcall.d		strlen				;//%r10 := n1 = strlen(s1)
	call.d	strlen@rl
		ld.w		%r2, %r14			;//%r2  := mask										*delay*
		ld.w		%r3, %r10			;//%r3  := n1
	ext	strlen@rm	; 		xcall.d		strlen				;//%r10 := n2 = strlen(s2)
	call.d	strlen@rl
		ld.w		%r12, %r1			;//%r12 :=             s2								*delay*
		sub		%r3, %r10			;//%r3  :=      n1 -         n2		%psr(C) := ((unsigned)n1<(unsigned)n2) ? 1 : 0
		jrult		str_has_prefix_suffix_L10	;//if((unsigned)n1<(unsigned)n2) { return 0 }					
		and		%r3, %r2			;//%r3  :=                        (n1-n2)&mask					
		or		%r10, %r2			;//%r10 :=                                            n2|mask			
		ld.w		%r12, %r0			;//%r12 :=                  s1							
		add		%r12, %r3			;//%r12 :=                  s1 + ((n1-n2)&mask)					
		ld.w		%r13, %r1			;//%r13 :=                                       s2				
	ext	strncmp@rm	; 		xcall.d		strncmp				;//%r10 := retval = strncmp(s1 + ((n1-n2)&mask), s2, (n2|mask))			
	call.d	strncmp@rl
		ld.w		%r14, %r10			;//%r14 :=                                            n2|mask				*delay*
		cmp		%r8, %r10			;//%psr(C) := retval  ?  1 : 0							
str_has_prefix_suffix_L10:					;//			@							
		ld.w		%r10, 1				;//%r10    := 1							
		popn		%r3				;//										
		ret.d						;//										
		sbc		%r10, %r8			;//%r10    := %psr(C) ?  0 : 1		*delay*


		.code
		.align		1
		.global		string_match
string_match:							;//for(;;) {
		ld.b		%r4, [%r12]+			;//  %r4  := p = *pat++
		ld.b		%r5, [%r13]+			;//  %r5  := s = *str++
		cmp		%r4, 0				;//  if(!p) {
		jrne.d		4
		 cmp		%r5, 0				;//  %psr(Z) := !s				*delay*
		 jreq		string_match_RET_1		;//    return !s			
		 jp		string_match_RET_0		;//  }					@
		jrne.d		3				;//  if(!s) {				
		 sub		%r4, 42				;//  %psr(Z) := (p == '*')			*delay*		ucmp %r4,42v́ucmp %rd,sign6v͈̔͊OȂ̂ŕsB
		 jrne		string_match_RET_0		;//    if(p != '*') { return 0 } }				@͈͊Ołɂ炸AZuG[oȂ̂ŒӂB
		jrne.d		string_match_L20		;//  if(p == '*') {						@uxcmp %r4,42vɂ2ɏKv邪Ausub %r4,42vŔfāuadd %r4,42vŖ߂1ōςށB
		add		%r4, 42				;//  						*delay*		ł́usub %r4,42v`uadd %r4,42v̊Ԃ%r4̒lωĂ薳Ƃ𗘗pHvłB
		ld.b		%r4, [%r12]			;//    %r4  := p = *pat
		cmp		%r4, 0				;//    if(!p) { return 1 }
		jreq		string_match_RET_1
		sub		%r13, 1				;//    %r13 := str--
string_match_L10:						;//    for(;;) {
	;//{{ǂ炩IĂB
	;//X^bNʂȂo[W
	;//	xsub		%sp, %sp, 8
	;//	xld.w		[%sp+0], %r12			;//      [%sp+0] := pat
	;//	xld.w		[%sp+4], %r13			;//      [%sp+4] := str
	;//	call		string_match			;//      %r10 := retval = string_match(pat,str)
	;//	xld.w		%r12, [%sp+0]			;//      %r12 := pat
	;//	xld.w		%r13, [%sp+4]			;//      %r13 := str
	;//	xadd		%sp, %sp, 8
	;//	cmp		%r10, 0				;//      if(retval) { return 1 }
	;//||ǂ炩IĂB
	;//X^bNʂ4ߐߖ񂵂o[W
		pushn		%r13
		call		string_match			;//      %r10 := retval = string_match(pat,str)
		cmp		%r10, 0				;//      if(retval) { return 1 }
		popn		%r13
	;//}}ǂ炩IĂB
		jrne		string_match_RET_1
		ld.b		%r10, [%r13]+			;//      %r10 := s = *str++
		cmp		%r10, 0				;//      if(!s) { return 0 }
		jrne		string_match_L10
		jp		string_match_RET_0		;//    }
string_match_L20:						;//  }
	ext	0x0		; 		xcmp		%r4, 63
	cmp	%r4,0x3f
		jreq		string_match
	ext	0x1		; 		xcmp		%r4, 91				;//  if(p == '[') {
	cmp	%r4,0x1b
		jrne		string_match_L40
		ld.w		%r6, 0				;//    %r6  := match = 0
string_match_L30:						;//    for(;;) {
		ld.b		%r4, [%r12]+			;//      %r4  := p = *pat++
		cmp		%r4, 0				;//      if(!p) { DIE() }
		jreq		string_match_DIE
	ext	0x1		; 		xcmp		%r4, 93				;//      if(p == ']') { break }
	cmp	%r4,0x1d
		jreq		string_match_L35
		ld.b		%r7, [%r12]			;//      %r7  := q = *pat
	ext	0x0		; 		xcmp		%r7, 45				;//      if(q == '-') {
	cmp	%r7,0x2d
		jrne.d		6
		 cmp		%r7, %r4			;//      %r7  := q = p				*delay*
		 add		%r12, 1				;//        %r12 := pat++
		 ld.b		%r7, [%r12]+			;//        %r7  := q = *pat++
		 cmp		%r7, 0				;//        if(!q) { DIE() }
		 jreq		string_match_DIE		;//      }
		cmp		%r4, %r7			;//      if(p > q) {
		jrle		4
		 xor		%r4, %r7			;//        %r4  := p ^= q	
		 xor		%r7, %r4			;//        %r7  := q ^= p	pq
		 xor		%r4, %r7			;//        %r4  := p ^= q }	
		sub		%r5, %r4			;//      %r5  :=       s-p
		sub		%r7, %r4			;//      %r7  :=                          q-p
		cmp		%r5, %r7			;//      if((unsigned)(s-p) <= (unsigned)(q-p)) { match = 1 }
		jrugt		string_match_L30
		jp.d		string_match_L30
		ld.w		%r6, 1				;//						*delay*
string_match_L35:						;//    }
		cmp		%r6, 0				;//    if(!match) { return 0 }
		jrne		string_match			;//    continue
		jp		string_match_RET_0
string_match_L40:						;//  }
	ext	0x1		; 		xcmp		%r4, 92				;//  if(p == '') {
	cmp	%r4,0x1c
		jrne		4
		 ld.b		%r4, [%r12]+			;//    %r4  := p = *pat++
		 cmp		%r4, 0				;//    if(!p) { DIE() }
		 jreq		string_match_DIE		;//  }
		cmp		%r4, %r5			;//  if(p != s) { return 0 }
		jreq		string_match			;//}
string_match_RET_0:
		ret.d						;//return 0
		ld.w		%r10, 0				;//						*delay*
string_match_RET_1:
		ret.d						;//return 1
		ld.w		%r10, 1				;//						*delay*

; NO_APP
	.align	1
string_match_DIE:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	__LC0+0x0@h	; 	xld.w	%r12,__LC0
	ext	__LC0+0x0@m
	ld.w	%r12,__LC0+0x0@l
	ext	0x17		; 	xld.w	%r13,0x000005d7		; 1495
	ld.w	%r13,0x17
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
	ret
; APP

		.code
		.align		1
		.global		strnatcmp
		.global		strnatcasecmp
strnatcasecmp:
	ext	toupper+0x0@h	; 		xld.w		%r14, toupper			;//%r14 := conv = toupper
	ext	toupper+0x0@m
	ld.w	%r14,toupper+0x0@l
		jp		strnatcmp_subr
		;//---------------------------------------------;//
strnatcmp:
	ext	strnatcmp_noconv+0x0@h	; 		xld.w		%r14, strnatcmp_noconv		;//%r14 := conv = strnatcmp_noconv
	ext	strnatcmp_noconv+0x0@m
	ld.w	%r14,strnatcmp_noconv+0x0@l
		;//---------------------------------------------;//
strnatcmp_subr:
		;//%r12 := s1
		;//%r13 := s2
		;//%r14 := conv
		pushn		%r3
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
		ld.w		%r0, %r12			;//%r0     := s1
		ld.w		%r1, %r13			;//%r1     := s2
	ld.w	[%sp+0x0],%r14	; 		xld.w		[%sp+0x0], %r14			;//[%sp+0] := conv
		;//s̋󔒂ǂݔ΂B
strnatcmp_subr_LOOP1:						;//for(;;) {
		ld.ub		%r2, [%r0]+			;//  %r2  := c1 = *s1++
		call.d		strnatcmp_isspace		;//  if(!isspace(c1)) { break }
		ld.w		%r12, %r2			;//  													*delay*
		jrne		strnatcmp_subr_LOOP1		;//}
strnatcmp_subr_LOOP2:						;//for(;;) {
		ld.ub		%r3, [%r1]+			;//  %r3  := c2 = *s2++
		call.d		strnatcmp_isspace		;//  if(!isspace(c2)) { break }
		ld.w		%r12, %r3			;//  													*delay*
		jrne		strnatcmp_subr_LOOP2		;//}
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
strnatcmp_subr_LOOP3:						;//for(;;) {
		call		strnatcmp_isdigit		;//  %r4[0] := isdigit(c2), %r4[1] := isdigit(c1), %r4[31:2] := 0, %alr := (c1 - '0') * (c2 - '0')
		cmp		%r4, 3				;//  if(isdigit(c1) && isdigit(c2)) {
		jrne		strnatcmp_subr_L10		;//
		;//Ȃ΁c				;//
		;//ƂȂ΁c			;//
		ld.w		%r9, %alr			;//    %r9  := (c1 - '0') * (c2 - '0')
		cmp		%r9, 0				;//    if(     (c1 - '0') * (c2 - '0')) {
		jreq		strnatcmp_subr_LOOP5		;//
		ld.w		%r10, 0				;//      %r10 := bias = 0
strnatcmp_subr_LOOP4:						;//      for(;;) {
		sub		%r4, 1				;//        if(!isdigit(c1) && !isdigit(c2)) {
		jrge		4				;//
		 cmp		%r10, 0				;//          if(bias) { return bias }
		 jrne		strnatcmp_subr_RET		;//
		 jp		strnatcmp_subr_LOOP3_NEXT	;//          break }
		sub		%r4, 1				;//        if(!isdigit(c1) &&  isdigit(c2)) { return -1 }
		jrlt		strnatcmp_subr_RETm1		;//
		sub		%r4, 1				;//        if( isdigit(c1) && !isdigit(c2)) { return  1 }
		jrlt		strnatcmp_subr_RET1		;//
		cmp		%r10, 0				;//        if(!bias) {
		jrne		3				;//
		 ld.w		%r10, %r2			;//          %r10 :=        c1
		 sub		%r10, %r3			;//          %r10 := bias = c1 - c2 }
		ld.ub		%r2, [%r0]+			;//        %r2  := c1 = *s1++
		ld.ub		%r3, [%r1]+			;//        %r3  := c2 = *s2++
		call		strnatcmp_isdigit		;//        %r4[0] := isdigit(c2), %r4[1] := isdigit(c1), %r4[31:2] := 0, %alr := (c1 - '0') * (c2 - '0')
		jp		strnatcmp_subr_LOOP4		;//      }
		;//ȂƂȂ΁c		;//    } else {
strnatcmp_subr_LOOP5:						;//      for(;;) {
		sub		%r4, 1				;//        if(!isdigit(c1) && !isdigit(c2)) { break }
		jrlt		strnatcmp_subr_LOOP3_NEXT	;//
		sub		%r4, 1				;//        if(!isdigit(c1) &&  isdigit(c2)) { return -1 }
		jrlt		strnatcmp_subr_RETm1		;//
		sub		%r4, 1				;//        if( isdigit(c1) && !isdigit(c2)) { return  1 }
		jrlt		strnatcmp_subr_RET1		;//
		ld.w		%r10, %r2			;//        %r10 := c1
		sub		%r10, %r3			;//        %r10 := c1 - c2
		jrne		strnatcmp_subr_RET		;//        if(     c1 - c2) { return c1 - c2 }
		ld.ub		%r2, [%r0]+			;//        %r2  := c1 = *s1++
		ld.ub		%r3, [%r1]+			;//        %r3  := c2 = *s2++
		call		strnatcmp_isdigit		;//        %r4[0] := isdigit(c2), %r4[1] := isdigit(c1), %r4[31:2] := 0, %alr := (c1 - '0') * (c2 - '0')
		jp		strnatcmp_subr_LOOP5		;//    } }
strnatcmp_subr_L10:						;//  } else {
		;//ȂƂłȂ΁c		;//
		;//Е̕񂪏I[Ȃ΁AЕ̋̕󔒕ǂݔ΂B
		cmp		%r2, 0				;//    if(!c1) {
		jrne		strnatcmp_subr_LOOP6_SKIP	;//
strnatcmp_subr_LOOP6:						;//      for(;;) {
		call.d		strnatcmp_isspace		;//        if(!isspace(c2)) { break }
		ld.w		%r12, %r3			;//        												*delay*
		jreq		strnatcmp_subr_LOOP6_SKIP	;//
		ld.ub		%r3, [%r1]+			;//        c2 = *s2++
		jp		strnatcmp_subr_LOOP6		;//      }
strnatcmp_subr_LOOP6_SKIP:					;//    }
		cmp		%r3, 0				;//    if(!c2) {
		jrne		strnatcmp_subr_LOOP7_SKIP	;//
strnatcmp_subr_LOOP7:						;//      for(;;) {
		call.d		strnatcmp_isspace		;//        if(!isspace(c1)) { break }
		ld.w		%r12, %r2			;//        												*delay*
		jreq		strnatcmp_subr_LOOP7_SKIP	;//
		ld.ub		%r2, [%r0]+			;//        c1 = *s1++
		jp		strnatcmp_subr_LOOP7		;//      }
strnatcmp_subr_LOOP7_SKIP:					;//    }
		;//Kvɉđ啶ɕϊB		;//
	ld.w	%r9,[%sp+0x0]	; 		xld.w		%r9, [%sp+0x0]			;//    %r9  :=        conv
		call.d		%r9				;//    %r10 := c2 = (*conv)(c2)
		ld.w		%r12, %r3			;//    %r12 :=              c2										*delay*
		ld.w		%r3, %r10			;//    %r3  := c2
	ld.w	%r9,[%sp+0x0]	; 		xld.w		%r9, [%sp+0x0]			;//    %r9  :=        conv
		call.d		%r9				;//    %r10 := c1 = (*conv)(c1)
		ld.w		%r12, %r2			;//    %r12 :=              c1										*delay*
		;//c1,c2قȂ邩,,I[ɒBArʂԂB
		sub		%r10, %r3			;//    %r10 := c1 -= c2
		jrne		strnatcmp_subr_RET		;//    if( c1) { return c1 }
		cmp		%r3, 0				;//    if(!c2) { return c1 }
		jreq		strnatcmp_subr_RET		;//
		;//̕擾B				;//
		ld.ub		%r2, [%r0]+			;//    %r2  := c1 = *s1++
		ld.ub		%r3, [%r1]+			;//    %r3  := c2 = *s2++
strnatcmp_subr_LOOP3_NEXT:					;//  }
		;//A󔒕̃Xy[X(' ')ɒuB
		call.d		strnatcmp_isspace		;//  if(isspace(c1)) {
		ld.w		%r12, %r2			;//    													*delay*
		jreq		strnatcmp_subr_LOOP8_SKIP	;//
	ext	0x0		; 		xld.w		%r2, 32				;//    %r2  := c1 = ' '
	ld.w	%r2,0x20
strnatcmp_subr_LOOP8:						;//
		ld.ub		%r12, [%r0]+			;//    while(isspace(*s1++)) { /** no job **/ }
		call		strnatcmp_isspace		;//
		jrne		strnatcmp_subr_LOOP8		;//
		sub		%r0, 1				;//    %r0  := s1--
strnatcmp_subr_LOOP8_SKIP:					;//  }
		call.d		strnatcmp_isspace		;//  if(isspace(c2)) {
		ld.w		%r12, %r3			;//    													*delay*
		jreq		strnatcmp_subr_LOOP9_SKIP	;//
	ext	0x0		; 		xld.w		%r3, 32				;//    %r3  := c2 = ' '
	ld.w	%r3,0x20
strnatcmp_subr_LOOP9:						;//
		ld.ub		%r12, [%r1]+			;//    while(isspace(*s2++)) { /** no job **/ }
		call		strnatcmp_isspace		;//
		jrne		strnatcmp_subr_LOOP9		;//
		sub		%r1, 1				;//    %r1  := s2--
strnatcmp_subr_LOOP9_SKIP:					;//  }
		jp		strnatcmp_subr_LOOP3		;//}
		;//- - - - - - - - - - - - - - - - - - - - - - -;//
strnatcmp_subr_RET:
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		popn		%r3
		ret
strnatcmp_subr_RET1:						;//
		jp.d		strnatcmp_subr_RET		;//return   1
		ld.w		%r10, 1				;//%r10 :=  1												*delay*
strnatcmp_subr_RETm1:						;//
		jp.d		strnatcmp_subr_RET		;//return  -1
		ld.w		%r10, -1			;//%r10 := -1												*delay*
		;//---------------------------------------------;//
strnatcmp_isspace:
	ext	isspace@rm	; 		xcall		isspace				;//%r10    :=  isspace(c)
	call	isspace@rl
		ret.d						;//%psr(Z) := !isspace(c)
		cmp		%r10, 0				;//													*delay*
		;//---------------------------------------------;//
strnatcmp_isdigit:
		sub		%r2, 48				;//%r2     := c1 -= '0'
		cmp		%r2, 10				;//%psr(C) := (c1 <= 9)
		adc		%r4, %r4			;//%r4[0]  := isdigit(c1),                         %r4[31:1] := (sl)
		sub		%r3, 48				;//%r3     := c2 -= '0'
		cmp		%r3, 10				;//%psr(C) := (c2 <= 9)
		adc		%r4, %r4			;//%r4[0]  := isdigit(c2), %r4[1]  := isdigit(c1), %r4[31:2] := (sl)
		mlt.h		%r2, %r3			;//%alr    := (c1 - '0') * (c2 - '0')
		add		%r2, 48				;//%r2     := c1 += '0'
		add		%r3, 48				;//%r3     := c2 += '0'
		ret.d						;//
		and		%r4, 3				;//%r4[0]  := isdigit(c2), %r4[1]  := isdigit(c1), %r4[31:2] := 0					*delay*
		;//---------------------------------------------;//
strnatcmp_noconv:
		ret.d						;//return  c
		ld.w		%r10, %r12			;//%r10 := c												*delay*


		.code
		.align		1
		.global		strreverse
strreverse:
		pushn		%r0
		ld.w		%r0, %r12		;//%r0  := s
	ext	strchr@rm	; 		xcall.d		strchr			;//%r10 := p2 = strchr(s, 'O')
	call.d	strchr@rl
		ld.w		%r13, 0			;//%r13 :=                'O'	*delay*
		jp.d		strreverse_START	;//goto START
		ld.w		%r4, %r0		;//%r4 := p1 = s			*delay*
strreverse_LOOP:					;//do {
		ld.b		%r5, [%r4]		;//  %r5  := c1 = *p1
		ld.b		%r6, [%r10]		;//  %r6  := c2 = *p2
		ld.b		[%r10], %r5		;//  *p2   = c1
		ld.b		[%r4]+, %r6		;//  *p1++ = c2
strreverse_START:					;//
		sub		%r10, 1			;//  %r10 := p2--
		cmp		%r4, %r10		;//} while(p1 < p2)
		jrult		strreverse_LOOP		;//
		ld.w		%r10, %r0		;//%r10 := s
		popn		%r0
		ret

; NO_APP
	.align	1
	.global	quark_from_string
quark_from_string:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	call	intern_string	; 	xcall	intern_string
	ret
	.align	1
	.global	quark_to_string
quark_to_string:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r10,%r12
	ret

	.lcomm	ht.92 4
	.align	1
	.global	intern_string
intern_string:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r1,%r12
	ext	ht.92+0x0@ah	; 	xld.w	%r12,[ht.92]
	ext	ht.92+0x0@al
	ld.w	%r12,[%r8]
	cmp	%r12,0x0
	jrne	__LX93		; 	xjrne	__L93
	ext	ght_create@rm	; 	xcall	ght_create
	call	ght_create@rl
	ext	ht.92+0x0@ah	; 	xld.w	[ht.92],%r10
	ext	ht.92+0x0@al
	ld.w	[%r8],%r10
	ld.w	%r12,%r10
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
	ext	ght_set_rehash@rm	; 	xcall	ght_set_rehash
	call	ght_set_rehash@rl
__LX93:				; __L93:
	cmp	%r1,0x0
	jreq	__LX94		; 	xjreq	__L94
	ld.w	%r12,%r1
	ext	strlen@rm	; 	xcall	strlen
	call	strlen@rl
	ld.w	%r2,%r10
	ext	ht.92+0x0@ah	; 	xld.w	%r12,[ht.92]
	ext	ht.92+0x0@al
	ld.w	%r12,[%r8]
	ld.w	%r13,%r2
	ld.w	%r14,%r1
	ext	ght_get@rm	; 	xcall	ght_get
	call	ght_get@rl
	ld.w	%r0,%r10
	cmp	%r0,0x0
	jrne	__LX95		; 	xjrne	__L95
	ld.w	%r12,%r1
	ext	strdup@rm	; 	xcall	strdup
	call	strdup@rl
	ld.w	%r0,%r10
	ext	ht.92+0x0@ah	; 	xld.w	%r12,[ht.92]
	ext	ht.92+0x0@al
	ld.w	%r12,[%r8]
	ld.w	%r13,%r0
	ld.w	%r14,%r2
	ld.w	%r15,%r0
	ext	ght_insert@rm	; 	xcall	ght_insert
	call	ght_insert@rl
__LX95:				; __L95:
	ld.w	%r1,%r0
__LX94:				; __L94:
	ld.w	%r10,%r1
	popn	%r2
	ret
; APP

		.code
		.align		1
		.global		strreplace
strreplace:
		pushn		%r0			;//
		ld.w		%r0, %r14		;//%r0  := newstr
	ext	strsplit@rm	; 		xcall.d		strsplit		;//%r10 := argv = strsplit(s, oldstr, 0)
	call.d	strsplit@rl
		ld.w		%r14, 0			;//%r14 :=                            0		*delay*
		ld.w		%r12, %r0		;//%r12 :=              newstr
		ld.w		%r0, %r10		;//%r0  := argv
	ext	strjoinv@rm	; 		xcall.d		strjoinv		;//%r10 := t = strjoinv(newstr, argv)
	call.d	strjoinv@rl
		ld.w		%r13, %r0		;//%r13 :=                      argv		*delay*
		ld.w		%r12, %r0		;//%r12 :=          argv
	ext	strfreev@rm	; 		xcall.d		strfreev		;//        strfreev(argv)
	call.d	strfreev@rl
		ld.w		%r0, %r10		;//%r0  := t					*delay*
		ld.w		%r10, %r0		;//%r10 := t
		popn		%r0			;//
		ret					;//return  t


		.code
		.align		1
		.global		memdup
memdup:
		;//%r12 := src
		;//%r13 := n
		pushn		%r1			;//
		ld.w		%r0, %r12		;//%r0  := src
		ld.w		%r1, %r13		;//%r1  := n
	ext	malloc@rm	; 		xcall.d		malloc			;//%r10 := dest = malloc(n)
	call.d	malloc@rl
		ld.w		%r12, %r13		;//%r12 :=               n			*delay*
		cmp		%r10, 0			;//if(dest) {
		jreq		memdup_RET		;//
		ld.w		%r13, %r0		;//  %r13 :=                     src
		ld.w		%r14, %r1		;//  %r14 :=                          n
	ext	memcpy@rm	; 		xcall.d		memcpy			;//  %r10 := dest = memcpy(dest, src, n)
	call.d	memcpy@rl
		ld.w		%r12, %r10		;//  %r12 :=               dest			*delay*
memdup_RET:						;//}
		popn		%r1			;//
		ret					;//return dest

