/*
 *	clipstl.c
 *
 *	STLQlɂč쐬֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sat Mar 05 21:53:08 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- lower_bound()֐,upper_bound()֐쐬܂B
 *	- XbhZ[tłlower_bound_r()֐,upper_bound_r()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	
 ****************************************************************************/
// * Sat Mar 05 21:53:08 JST 2016 Naoyuki Sawa
// - lower_bound()֐,upper_bound()֐ǉ܂B
//   ړÍA'l͈͕̔tbsearch()'sLłB
// - lower_bound,upper_bound̊֐́ASTLstd::lower_bound(),std::upper_bound()܂B
//   ǉlower_bound()֐,upper_bound()֐́Absearch()̈dl/߂ldlŁASTLstd::lower_bound(),std::upper_bound()ƓŝłB
// - Ql
//   uPrograming Placev(http://ppp-lab.sakura.ne.jp/)́wC++(WCu) 20 \[gς݂͈̔͂ASYx(http://ppp-lab.sakura.ne.jp/cpp/library/020.html)̋L
//   uStack Overflowv́wFind the first element in an array that is greater than the targetx(http://stackoverflow.com/questions/6553970/find-the-first-element-in-an-array-that-is-greater-than-the-target)̋L
// - XbhZ[tłlower_bound_r()֐,upper_bound_r()ǉ܂B
//   qsort()ɑ΂Aqsort_r()ɑ܂B
//   Ȃ݂ɁAbsearch()ɑ΂bsearch_r()݂͑܂B
//   bsearch_r,lfind_r,lsearch_r,݂Ȃ̂́ACWCudlĂ̂悤łB
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//(keyval)ƂȂAŏvalւ̃|C^ԂB
//SĂval(keyval)Ȃ΁AŌval̎ւ̃|C^ԂB	std::lower_bound()̎dlłBNULLԂ̂ł͂ȂɒӂĉB
//[in]
//		dĺAbsearch()ƓłB
//		Ɏw肷compar֐́Absearch()Ɠ̂po܂B
//[out]
//		߂l̎dĺAstd::lower_bound()ƓłB
//		֐ANULLԂ͗L܂B
//[note]
//		- 𖞂ʒuꍇAbsearch()NULLԂ܂A֐͍Ōval̎ւ̃|C^ԂɒӂĉB
//		  std::lower_bound()̎dlɕłB
//		- 𖞂ʒuꍇAbsearch()ƓlNULLԂdlɕύX悤Ƃv̂łA
//		  ۂɎgČƁAĂяo̊ϓ_łAŌval̎ւ̃|C^ԂꂽgՂP[X킩܂B
//		  ]āA𖞂ʒuꍇ́Astd::lower_bound()ƓlɁAŌval̎ւ̃|C^Ԃɂ܂B
void* lower_bound(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) {
	return lower_bound_r(key, _base, nmemb, size, (int (*)(const void*, const void*, void*))compar, NULL);	//lower_bound()lower_bound_r()́Acompar֐̌`قȂ܂A'cdeclďoK'Ȃ΁Alower_bound()`compar֐ɂāA]Ȉ̂Ŗ肠܂B
}
void* lower_bound_r(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*, void*), void* arg) {
	unsigned char* base = (unsigned char*)_base;
	unsigned lo = 0, hi = nmemb;
	while(lo != hi) {
		unsigned mid = (lo + hi) >> 1;
		if((*compar)(key, base + (size * mid), arg) >  0) {	//̈ʒu̒lL[Ȃ΁Äʒu͏𖞂ĂȂ̂Łc	lower_bound()upper_bound()̈Ⴂ͂̍słB
			lo = mid + 1;					//ʂ̈ʒúAȂƂÄʒu̎ȍ~ƂȂB
		} else {						//̈ʒu̒lL[ȏȂ΁Äʒu͏𖞂Ă̂Łc
			hi = mid;					//ʂ̈ʒúAȂƂÄʒuȑOƂȂB
		}
	}
	return base + (size * lo);	//𖞂ʒuLꍇ́A(lo==hinmemb)ƂȂĂB𖞂ʒuꍇ́A(lo==hi==nmemb)ƂȂĂB
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//(keyval)ƂȂAŏvalւ̃|C^ԂB
//SĂval(keyval)Ȃ΁AŌval̎ւ̃|C^ԂB	std::upper_bound()̎dlłBNULLԂ̂ł͂ȂɒӂĉB
//[note]
//	- lower_bound()̐QƂĉB
void* upper_bound(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) {
	return upper_bound_r(key, _base, nmemb, size, (int (*)(const void*, const void*, void*))compar, NULL);	//upper_bound()upper_bound_r()́Acompar֐̌`قȂ܂A'cdeclďoK'Ȃ΁Aupper_bound()`compar֐ɂāA]Ȉ̂Ŗ肠܂B
}
void* upper_bound_r(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*, void*), void* arg) {
	unsigned char* base = (unsigned char*)_base;
	unsigned lo = 0, hi = nmemb;
	while(lo != hi) {
		unsigned mid = (lo + hi) >> 1;
		if((*compar)(key, base + (size * mid), arg) >= 0) {	//̈ʒu̒lL[ȉȂ΁Äʒu͏𖞂ĂȂ̂Łc	lower_bound()upper_bound()̈Ⴂ͂̍słB
			lo = mid + 1;					//ʂ̈ʒúAȂƂÄʒu̎ȍ~ƂȂB
		} else {						//̈ʒu̒lL[߂Ȃ΁Äʒu͏𖞂Ă̂Łc
			hi = mid;					//ʂ̈ʒúAȂƂÄʒuȑOƂȂB
		}
	}
	return base + (size * lo);	//𖞂ʒuLꍇ́A(lo==hinmemb)ƂȂĂB𖞂ʒuꍇ́A(lo==hi==nmemb)ƂȂĂB
}
