/*
 *	clipscnm.c
 *
 *	V[Ǘ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sun Nov 08 21:45:34 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Mon Nov 09 21:43:23 JST 2015 Naoyuki Sawa
 *	- W[Ŏgp郌WXgf[^쐬邽߂̃c[ƂāA'/clip/tool/MkScnInf.awk,MkScnInf.bat'쐬܂B
 *	  ڍׂ́ALc[̎QƂĉB
 */
#include "clip.h"
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static void ScnMgrInf_Verify(const ST_ScnMgrInf* pInf);
static void ScnMgr_LyrSta(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/, int iScnNo/*1`*/);
static void ScnMgr_LyrCon(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/);
static void ScnMgr_LyrEnd(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//V[Ǘ𓮓Iɍ쐬B
ST_ScnMgr* ScnMgr_New(const ST_ScnMgrInf* pInf) {
	ST_ScnMgr* pScnMgr;
	//B
	ScnMgrInf_Verify(pInf);
	//mۂB
#ifndef __RENESAS__
	pScnMgr = malloc(sizeof(ST_ScnMgr) + (sizeof(ST_ScnLyr) *  pInf->nLyr));
#else //__RENESAS__
	pScnMgr = malloc(sizeof(ST_ScnMgr) + (sizeof(ST_ScnLyr) * (pInf->nLyr - 1/*ST_ScnMgr.TBL_Lyr[0]̕*/*/)));	//Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
#endif//__RENESAS__
	if(!pScnMgr) { DIE(); }
	//V[ǗÓIɏB
	ScnMgr_Init(pScnMgr, pInf);
	return pScnMgr;
}
/*---------------------------------------------------------------------------*/
//V[ǗÓIɏB
void ScnMgr_Init(ST_ScnMgr* pScnMgr, const ST_ScnMgrInf* pInf) {
	//B
	ScnMgrInf_Verify(pInf);
	//NAB
#ifndef __RENESAS__
	memset(pScnMgr, 0, sizeof(ST_ScnMgr) + (sizeof(ST_ScnLyr) *  pInf->nLyr));
#else //__RENESAS__
	memset(pScnMgr, 0, sizeof(ST_ScnMgr) + (sizeof(ST_ScnLyr) * (pInf->nLyr - 1/*ST_ScnMgr.TBL_Lyr[0]̕*/*/)));	//Hew͗vf[0]̔zɑΉĂȂ̂ŁAvf[1]ƂĒ܂B
#endif//__RENESAS__
	//ւ̃|C^i[B
	pScnMgr->pInf = pInf;
}
/*---------------------------------------------------------------------------*/
//C擾B
ST_ScnLyr* ScnMgr_GetLyr(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/) {
	const int nLyr = pScnMgr->pInf->nLyr;
	if((unsigned)iLyrNo >= (unsigned)nLyr) { DIE(); }	//oO
	return &pScnMgr->TBL_Lyr[iLyrNo];
}
/*---------------------------------------------------------------------------*/
//̃V[̍ĐCԍ擾B
// - ĐCLȂiLyrNo=0`nLyr-1CĐCȂiLyrNo=-1ԂB
int ScnMgr_GetLyrNo(ST_ScnMgr* pScnMgr, int iScnNo/*1`*/) {
	const int nLyr = pScnMgr->pInf->nLyr;
	const uint8_t* pScnInf;
	int iLyrNo;
	//V[擾B
	if(!iScnNo) { DIE(); }	//AvP[ṼoO
	pScnInf = (*pScnMgr->pInf->fnGetInf)(iScnNo/*1`*/);
	if(!pScnInf) { DIE(); }	//f[^oO
	//V[1oCgڂ́A(̃V[̍ĐCԍ+1)łB
	iLyrNo = *pScnInf - 1;		//ĐCLȂiLyrNo=0`nLyr-1CĐCȂiLyrNo=-1ɂȂB
	if(iLyrNo >= nLyr) { DIE(); }	//f[^oO
	return iLyrNo;
}
/*---------------------------------------------------------------------------*/
//V[ĐB
void ScnMgr_SetScn(ST_ScnMgr* pScnMgr, int iScnNo/*1`*/) {
	const int nLyr = pScnMgr->pInf->nLyr;
	const uint8_t* pScnInf;
	int iLyrNo1, iLyrNo2;
	ST_ScnLyr* pLyr;
	//V[擾B
	if(!iScnNo) { DIE(); }	//AvP[ṼoO
	pScnInf = (*pScnMgr->pInf->fnGetInf)(iScnNo/*1`*/);
	if(!pScnInf) { DIE(); }	//f[^oO
	//V[1oCgڂ́A(̃V[̍ĐCԍ+1)łB
	iLyrNo1 = *pScnInf++ - 1;	//ĐCLȂiLyrNo=0`nLyr-1CĐCȂiLyrNo=-1ɂȂB
	if(iLyrNo1 >= nLyr) { DIE(); }	//f[^oO
	//SẴCɂāc
	// - ĐC̗Lɂ炸ÃV[~郌C̃rbg}XN͗LłB
	for(iLyrNo2 = 0; iLyrNo2 < nLyr; iLyrNo2++) {
		//̃V[ÃC~Ȃ΁c
		// - V[2oCgڈȍ~́ÃV[~郌C̃rbg}XNłB
		if(pScnInf[iLyrNo2 >> 3] & (1 << (iLyrNo2 & 7))) {
			//̃C̃V[~sB
			// - ̃C'݂̃V['΃_~[ƂȂB
			ScnMgr_LyrEnd(pScnMgr, iLyrNo2);
		}
	}
	//ĐCLȂ΁c
	if(iLyrNo1 != -1) {
		//ĐC̃V[ωȂ΁c(̏Œ~ꍇ܂ށB)
		pLyr = ScnMgr_GetLyr(pScnMgr, iLyrNo1);
		if(pLyr->iScnNo_Now != iScnNo) {
			//̃C̃V[~sB
			// - ̃C'݂̃V['΃_~[ƂȂB
			ScnMgr_LyrEnd(pScnMgr, iLyrNo1);
			//̃C̃V[JnsB
			ScnMgr_LyrSta(pScnMgr, iLyrNo1, iScnNo);
		//ĐC̃V[ωȂ΁c
		} else {
			//̃C̃V[psB
			ScnMgr_LyrCon(pScnMgr, iLyrNo1);
		}
	//ĐCȂ΁c
	} else {
		//ĐC̖V[JnʒmsByꏈz
		// - ĐCĂAV[Jnʒm͍sB
		//   ̏ꏊAAvP[V`(*fnScnSta)()Ăяoꍇ̂݁A(iLyrNo=-1)ŌĂяoB
		// - ĐCĂAV[JnʒmsړÍAĐC̖_~[V[ɑ΂āAĐԂǗȂVbgSE֘At邽߂łB
		//   ́AȊO̗prłAAvP[VCӂɗpĂ\ȂB
		//   AvP[V̋@\𗘗pȂꍇ́AAvP[V`(*fnScnSta)()́A(iLyrNo=-1)̏ꍇ͉ɏԂ悤ɍ쐬B
		(*pScnMgr->pInf->fnScnSta)(iLyrNo1/*-1*/, iScnNo/*1`*/);
	}
}
/*---------------------------------------------------------------------------*/
//C~B
void ScnMgr_DelLyr(ST_ScnMgr* pScnMgr, .../*iLyrMsk[31:0],iLyrMsk[63:32],c,iLyrMsk[(nLyr-1):(nLyr-1)&~31]*/) {
	const int nLyr = pScnMgr->pInf->nLyr;
	va_list ap;
	int iLyrNo;
	ST_ScnLyr* pLyr;
	unsigned iLyrMsk = 0;	//x}
	va_start(ap, pScnMgr);
	//SẴCɂāc
	for(iLyrNo = 0; iLyrNo < nLyr; iLyrNo++) {
		//C0,32,64,...Ȃ΁c
		if(!(iLyrNo & 31)) {
			//C}XN擾B
			iLyrMsk = va_arg(ap, unsigned);
		}
		//C}XNw肳Ăc
		if(iLyrMsk & 1) {
			//̃C̃V[~sB
			// - ̃C'݂̃V['΃_~[ƂȂB
			ScnMgr_LyrEnd(pScnMgr, iLyrNo);
			//'ÕV['mɃNAB
			// - ScnMgr_DelLyr()ĂяoꂽƂ́AAvP[VӐ}IɃC~ƌȂ̂ŁA'ÕV['(=qXg)NAB
			//   'ÕV['͂܂łAꃌCɑ΂2̃V[OIɏdčĐ悤ȓP[XL邽߂̂̂łB
			//   AvP[VKvɉScnMgr_GetLyrNo()->iScnNo_Now,iScnNo_Old擾āAAvP[V̕@Ŕf̂ړIB
			//   Aɂ́AꃌCɑ΂3ȏ̃V[OIɏdčĐ\L邪AW[ł2܂łT|[gĂȂB
			pLyr = ScnMgr_GetLyr(pScnMgr, iLyrNo);
			pLyr->iScnNo_Old = 0;
		}
		//C}XN֐i߂B
		iLyrMsk >>= 1;
	}
	va_end(ap);
}
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//B
static void ScnMgrInf_Verify(const ST_ScnMgrInf* pInf) {
	if(!pInf->nLyr ||		//C
	   !pInf->fnGetInf ||		//V[擾
	   !pInf->fnScnSta ||		//V[Jnʒm
	   !pInf->fnScnCon ||		//V[pʒm
	   !pInf->fnScnEnd) { DIE(); }	//V[~ʒm
}
/*---------------------------------------------------------------------------*/
//̃C̃V[JnsB
static void ScnMgr_LyrSta(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/, int iScnNo/*1`*/) {
	ST_ScnLyr* pLyr = ScnMgr_GetLyr(pScnMgr, iLyrNo);
	//'݂̃V['i[B
	if(!iScnNo) { DIE(); }	//W[̃oO
	pLyr->iScnNo_Now = iScnNo;
	//V[JnʒmsB
	(*pScnMgr->pInf->fnScnSta)(iLyrNo/*0`(nLyr-1)*/, iScnNo/*1`*/);
}
/*---------------------------------------------------------------------------*/
//̃C̃V[psB
static void ScnMgr_LyrCon(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/) {
	ST_ScnLyr* pLyr = ScnMgr_GetLyr(pScnMgr, iLyrNo);
	//'݂̃V['擾B
	int iScnNo = pLyr->iScnNo_Now;
	if(!iScnNo) { DIE(); }	//W[̃oO
	//V[pʒmsB
	(*pScnMgr->pInf->fnScnCon)(iLyrNo/*0`(nLyr-1)*/, iScnNo/*1`*/);
}
/*---------------------------------------------------------------------------*/
//̃C̃V[~sB
static void ScnMgr_LyrEnd(ST_ScnMgr* pScnMgr, int iLyrNo/*0`(nLyr-1)*/) {
	ST_ScnLyr* pLyr = ScnMgr_GetLyr(pScnMgr, iLyrNo);
	//̃C'݂̃V['擾B
	int iScnNo = pLyr->iScnNo_Now;
	//̃C'݂̃V['L΁c
	if(iScnNo) {
		//'݂̃V['A'ÕV['ƂĊi[B
		pLyr->iScnNo_Old = iScnNo;
		//'݂̃V['NAB
		pLyr->iScnNo_Now = 0;
		//V[~ʒmsB
		(*pScnMgr->pInf->fnScnEnd)(iLyrNo/*0`(nLyr-1)*/, iScnNo/*1`*/);
	//̃C'݂̃V['΁c
	} else {
		//'ÕV['ύXɈێB
		/** no job **/
	}
}

/****************************************************************************
 *	A̗
 ****************************************************************************/
#if 0

RegTbl.txt
	ScnNo
		1000
			ScnInf		= {1,bit 1,bit 1,bit 0,bit 0}
			TapSeqNo
				0	= 2000
				1	= 2001
			end
			LedSeqNo	= 3000
			RudSeqNo
				0	= 4000
				1	= 4001
			end
		end
	end
	PhrNo
		5000
			LedSeqNo
				0	= 3000
			end
			RudSeqNo
				0	= 4000
				1	= 4001
			end
		end
	end

Sample.c
	#define RegKey_ScnInf   1 //
	#define RegKey_ScnNo    2 //
	#define RegKey_TapSeqNo 3 //ۂdRegTblC.exeRegTbl.hɏo͂B
	#define RegKey_LedSeqNo 4 //
	#define RegKey_RudSeqNo 5 //
	#define RegKey_PhrNo    6 //
	#define ScnLyr_Max      3 //AvP[V`
	extern ST_TapSeq* pTapSeq;//TAPV[PT
	extern ST_LedSeq* pLedSeq;//LEDV[PT
	extern const uint8_t TBL_RegTbl[];//RegTbl.bin
	extern const int   TBL_TapSeqNo[];//TapDef.bin
	extern const int   TBL_LedSeqNo[];//LedDef.bin
	extern const int   TBL_RudSeqNo[];//RudDef.bin
	void onTapEvt() {//AvP[V̎,y,TapSeqCh_PlayNo()/TapSeqCh_Stop()ĂяoɂonTapEvt()ĂяoB
		ST_TapEvt* pEvt;
		while((pEvt = TapSeq_EvtGet(pTapSeq))) {
			switch(pEvt->iEvt) {
			default:DIE();
			case TapEvt_Play:
			case TapEvt_Loop:
				{
					const void* pPhrKey = REG_open_key_l(TBL_RegTbl, RegKey_PhrNo, pEvt->iPhr, -1);
					//t[YLEDA
					{
						const void* pKey = REG_open_key(pPhrKey, RegKey_LedSeqNo);
						int index = 0, iLedSeqCh, iLedSeqNo;
						while((iLedSeqNo = REG_get_nth_value(pKey, index++, &iLedSeqCh)) != -1) {
							LedSeqCh_PlayNo(pLedSeq, iLedSeqCh, TBL_LedSeqNo, iLedSeqNo);
						}
					}
					//t[Y˃[^[A
					{
						const void* pKey = REG_open_key(pPhrKey, RegKey_RudSeqNo);
						int index = 0, iRudSeqCh, iRudSeqNo;
						while((iRudSeqNo = REG_get_nth_value(pKey, index++, &iRudSeqCh)) != -1) {
							RudSeqCh_PlayNo(iRudSeqCh, TBL_RudSeqNo, iRudSeqNo);
						}
					}
				}
				break;
			case TapEvt_Stop:
			case TapEvt_End:
				{
					const void* pPhrKey = REG_open_key_l(TBL_RegTbl, RegKey_PhrNo, pEvt->iPhr, -1);
					//t[YLEDA
					{
						const void* pKey = REG_open_key(pPhrKey, RegKey_LedSeqNo);
						int index = 0, iLedSeqCh, iLedSeqNo;
						while((iLedSeqNo = REG_get_nth_value(pKey, index++, &iLedSeqCh)) != -1) {
							LedSeqCh_Stop(pLedSeq, iLedSeqCh);
						}
					}
					//t[Y˃[^[A
					{
						const void* pKey = REG_open_key(pPhrKey, RegKey_RudSeqNo);
						int index = 0, iRudSeqCh, iRudSeqNo;
						while((iRudSeqNo = REG_get_nth_value(pKey, index++, &iRudSeqCh)) != -1) {
							RudSeqCh_Stop(iRudSeqCh);
						}
					}
				}
				break;
			case TapEvt_Ctrl:
				/** no job **/
				break;
			}
		}
	}
	static const void* fnGetInf(int iScnNo/*1`*/) {
		const void* pScnInf = REG_get_blob_l(TBL_RegTbl, RegKey_ScnNo, iScnNo, RegKey_ScnInf, -1);
		if(REG_get_blob_size(pScnInf) != (((ScnLyr_Max+1)+15)>>3)) { DIE(); }
		return pScnInf;
	}
	static void fnScnSta(int iLyrNo/*-1`(nLyr-1)*/, int iScnNo/*1`*/) {
		const void* pScnKey = REG_open_key_l(TBL_RegTbl, RegKey_ScnNo, iScnNo, -1);
		//V[˃TEhA
		{
			const void* pKey = REG_open_key(pScnKey, RegKey_TapSeqNo);
			int index = 0, iTapSeqCh, iTapSeqNo;
			while((iTapSeqNo = REG_get_nth_value(pKey, index++, &iTapSeqCh)) != -1) {
				TapSeqCh_PlayNo(pTapSeq, iTapSeqCh, TBL_TapSeqNo, iTapSeqNo);
				onTapEvt();//荞݊Oł̃TEhJn~vƃTEhCxg𓯂ɂ邽߂ɑfBȊOTapSeqCh_PlayNo()/TapSeqCh_Stop()ĂяoɂonTapEvt()ĂяoB
			}
		}
		//V[LEDA
		{
			int iLedSeqNo = REG_get_value(pScnKey, RegKey_LedSeqNo);
			if(iLedSeqNo != -1) {
				int iLedSeqCh = iLyrNo;
				LedSeqCh_PlayNo(pLedSeq, iLedSeqCh, TBL_LedSeqNo, iLedSeqNo);
			}
		}
		//V[˃[^[A
		{
			const void* pKey = REG_open_key(pScnKey, RegKey_RudSeqNo);
			int index = 0, iRudSeqCh, iRudSeqNo;
			while((iRudSeqNo = REG_get_nth_value(pKey, index++, &iRudSeqCh)) != -1) {
				RudSeqCh_PlayNo(iRudSeqCh, TBL_RudSeqNo, iRudSeqNo);
			}
		}
	}
	static void fnScnCon(int iLyrNo/* 0`(nLyr-1)*/, int iScnNo/*1`*/) {
	    //	const void* pScnKey = REG_open_key_l(TBL_RegTbl, RegKey_ScnNo, iScnNo, -1);
		//V[˃TEhA
		{
			/** no job **/
		}
		//V[LEDA
		{
			/** no job **/
		}
		//V[˃[^[A
		{
			/** no job **/
		}
	}
	static void fnScnEnd(int iLyrNo/* 0`(nLyr-1)*/, int iScnNo/*1`*/) {
		const void* pScnKey = REG_open_key_l(TBL_RegTbl, RegKey_ScnNo, iScnNo, -1);
		//V[˃TEhA
		{
			const void* pKey = REG_open_key(pScnKey, RegKey_TapSeqNo);
			int index = 0, iTapSeqCh, iTapSeqNo;
			while((iTapSeqNo = REG_get_nth_value(pKey, index++, &iTapSeqCh)) != -1) {
				TapSeqCh_Stop(pTapSeq, iTapSeqCh);
				onTapEvt();//荞݊Oł̃TEhJn~vƃTEhCxg𓯂ɂ邽߂ɑfBȊOTapSeqCh_PlayNo()/TapSeqCh_Stop()ĂяoɂonTapEvt()ĂяoB
			}
		}
		//V[LEDA
		{
			int iLedSeqNo = REG_get_value(pScnKey, RegKey_LedSeqNo);
			if(iLedSeqNo != -1) {
				int iLedSeqCh = iLyrNo;
				LedSeqCh_Stop(pLedSeq, iLedSeqCh);
			}
		}
		//V[˃[^[A
		{
			const void* pKey = REG_open_key(pScnKey, RegKey_RudSeqNo);
			int index = 0, iRudSeqCh, iRudSeqNo;
			while((iRudSeqNo = REG_get_nth_value(pKey, index++, &iRudSeqCh)) != -1) {
				RudSeqCh_Stop(iRudSeqCh);
			}
		}
	}
	static const ST_ScnMgrInf stScnMgrInf = { (ScnLyr_Max+1), fnGetInf, fnScnSta, fnScnCon, fnScnEnd };

#endif
