/*	
 *	clips3m.h
 *
 *	P/ECE S3M Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Nov 14 20:03:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_S3M_H__
#define __CLIP_S3M_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	S3Mt@Cdl
 ****************************************************************************/

/* S3Mt@C\̎dĺAoCgtB[h̋Eۏ؂Ă܂B
 * ׂĂHalfWordtB[h́AHalfWordEɐ񂵂Ă܂B
 * ׂĂWordtB[h́AWordEɐ񂵂Ă܂B
 * ܂AoCgtB[h̃oCgт́AP/ECEƓLittleEndianłB
 * ȏ̓ɂAS3M̍\̒`shortintgĎRɕ\ł܂B
 * 2004/11/17ǋL
 * dl͕K񂳂Ă͂̂łA͂łȂ悤łB
 * ꕔ̃tB[hǂݍ݂LEHALF}NgKv܂B
 * S3MMODULEHEADER.ordnum̃RgQƂĂB
 */

/* S3M Module header */
typedef struct _S3MMODULEHEADER {
		 char  song_name[28];				/* +0000, 28: Song name, max 28 chars (end with NUL (0)) */
		 char  _1ah;					/* +001c,  1: 1Ah */
	unsigned char  type;					/* +001d,  1: File type: 16=ST3 module */
	unsigned char  x001e[2];				/* +001e,  2: Reserved */
	unsigned short ordnum;					/* +0020,  2: Number of orders in file (should be even!)                                                                             */
								/*              (ModplugTrackerŕҏWS3M̏ꍇAordnum16̔{ɐ؂グ悤łB                                   ) */
								/*              (  ؂グɂĐorders[]̗]́A255(=SongI)Ŗ߂悤łB                                    ) */
								/*              (  ̋ɈˑR[fBO͕svłAÔߋLĂƂɂ܂B                                    ) */
								/*              (2004/11/17ǋL                                                                                                  ) */
								/*              (  dlłOrdnumłȂ΂Ȃ̂łAɊS3Mt@C݂܂B(PARTY92.S3M)              ) */
								/*              (  dȂ̂ŁAOrdnume邱Ƃɂ܂BOrdnum̏ꍇAOrderstB[hTCYɂȂ邽߁A) */
								/*              (  OrderšɂParapointers to instrumentsParapointers to patterns̊etB[hHalfWord񂳂܂B ) */
								/*              (  Parapointers to instrumentsParapointers to patterns̊etB[h̓ǂݍ݂́ALEHALF}NgĂB ) */
	unsigned short insnum;					/* +0022,  2: Number of instruments in file */
	unsigned short patnum;					/* +0024,  2: Number of patterns in file */
	unsigned short flags;					/* +0026,  2: [These are old flags for Ffv1. Not supported in ST3.01                                  */
								/*            | +  1: st2vibrato                                                                      */
								/*            | +  2: st2tempo                                                                        */
								/*            | +  4: amigaslides                                                                     */
								/*            | + 32: enable filter/sfx with sb                                                       */
								/*            ]                                                                                       */
								/*              +  8: 0vol optimizations                                                              */
								/*                      Automatically turn off looping notes whose volume is zero for >2 note rows.   */
								/*              + 16: amiga limits                                                                    */
								/*                      Disallow any notes that go beond the amiga hardware limits (like amiga does). */
								/*                      This means that sliding up stops at B#5 etc.                                  */
								/*                      Also affects some minor amiga compatibility issues.                           */
								/*              +128  special custom data in file                                                     */
	unsigned short cwt_v;					/* +0028,  2: Created with tracker / version: &0xfff=version, >>12=tracker                        */
								/*              ST3.00:0x1300                                                                     */
								/*              ST3.01:0x1301                                                                     */
								/*              (ModplugTracker0x1320łB1991`1992N̋S3Mt@C0x3212̂悤łB) */
								/*              (  Tracker̎ނ𐧌邱Ƃɂ͈Ӗ̂ŁÃtB[h͌܂B) */
	unsigned short ffv;					/* +002a,  2: FIle format version;                                                                    */
								/*              1=old version used long ago (samples signed)                                          */
								/*              2=standard (samples unsigned)                                                         */
								/*              (1991N̏S3Mt@CA1998N̐VS3Mt@CA2ݒ肳Ă܂B) */
								/*              (  tSampledata`S3Mt@ĆA݂ȂƍlĂƎv܂B) */
		 char  scrm[4];					/* +002c,  4: "SCRM" */
	unsigned char  g_v;					/* +0030,  1: global volume                                                                                                 */
								/*              Global volume directly divides the volume numbers used.                                                     */
								/*              So if the module has a note with volume 48 and master volume is 32, the note will be played with volume 24. */
								/*              This affects both Gravis & SoundBlasters.                                                                   */
								/*              (XƉĂ܂(^^;Aςǂ̕ʂGlobal volumełB0..64őS̉ʂ𒲐܂B)        */
	unsigned char  i_s;					/* +0031,  1: initial speed (command A)                                                */
								/*              (MODSpeedAXMTempoɑB1[Row]TickŁA6O̒lłB) */
	unsigned char  i_t;					/* +0032,  1: initial tempo (command T)                                                                   */
								/*              (MODTempoAXMBPMɑB1[Tick]̎ԌWŁA1[Tick]=(1/50)*(Tempo/125)[Sec]łB) */
	unsigned char  m_v;					/* +0033,  1: master volume                                                                                                                                    */
								/*              Master volume only affects the SoundBlaster.                                                                                                   */
								/*              It controls the amount of sample multiplication.                                                                                               */
								/*              The bigger the value the bigger the output volume (and thus quality) will be.                                                                  */
								/*              However if the value is too big, the mixer may have to clip the output to fit the 8 bit output stream.                                         */
								/*              The default value works pretty well.                                                                                                           */
								/*              Note that in stereo, the mastermul is internally multiplied by 11/8 inside the player since there is generally more room in the output stream. */
								/*              (̖`ɏĂ悤ɁASoundBlaster̃~LVOn[hEFAp݂łBg܂B)                                       */
	unsigned char  x0034[10];				/* +0034, 10: Reserved */
	unsigned short special;					/* +003e,  2: pointer to special custom data (not used by ST3.01) */
	unsigned char  channel_settings[32];			/* +0040, 32: Channel settings:                                                                                                      */
								/*              bit   7: channel enabled                                                                                             */
								/*                         (Documentɂ́gbit 6hƏĂ܂ŁAgbit 7hƎv܂B                         ) */
								/*                         (  0=L,1=łB                                                                                  ) */
								/*                         (  ۂɂbit 7-0ŜŌ0..15LSample ChannelƌȂ̂ŁAbit 7𒲂ׂKv͂܂B) */
								/*              bit 0-6: channel type                                                                                                */
								/*                          0.. 7: Left Sample Channel 1-8                                                                           */
								/*                          8..15: Right Sample Channel 1-8                                                                          */
								/*                         16..31: Adlib channels (9 melody + 5 drums)                                                               */
								/*                         (Documentɂ́gbit 0-7hƏĂ܂ŁAgbit 6-0hƎv܂B)                      */
//	unsigned char  orders[/*ordnum*/];			/* +0060,ordnum                  : Orders; length=OrdNum (should be even)                                                               */
//								/*                                   Order list lists the order in which to play the patterns.                                          */
//								/*                                   255=-- is the end of tune mark and 254=++ is just a marker that is skipped.                        */
//								/*                                   (g--hƂg++hƂ́AScream Trackerł͂̂悤ɕ\ĂAƂƂƎv܂B) */
//								/*                                   (  g++hȂĖőɎgȂ낤ƎvASPLATFST.S3MgĂ܂BSkipfKvłB) */
//								/*                                   (2004/11/17ǋL: TCYL蓾܂BOrdnum̃RgQƂĂB                  ) */
//	unsigned short parapointers_to_instruments[/*insnum*/];	/* +0060+ordnum,insnum*2         : Parapointers to instruments; length=InsNum*2                                                       */
//	unsigned short parapointers_to_patterns[/*patnum*/];	/* +0060+ordnum+insnum*2,patnum*2: Parapointers to patterns; length=PatNum*2                                                          */
//								/*                                   Parapointers to file offset Y is (Y-Offset of file header)/16.                                   */
//								/*                                   You could think of parapointers as segments relative to the start of the S3M file.               */
//								/*                                   (2004/11/17ǋL: HalfWord񂳂ĂȂꍇ܂BOrdnum̃RgQƂĂB) */
} S3MMODULEHEADER;						/* =0060+ordnum+insnum*2+patnum*2 */

/* Digiplayer ST3/ samplefileformat */
typedef struct _S3MSAMPLEHEADER {
	unsigned char  type;			/* +0000,  1: Type; 1=Sample, 2=adlib melody, 3+=adlib drum                                                       */
		 				/*              (Type1ȊȌꍇADigiplayer ST3/ samplefileformatł͂ȂAadlib instrument formatłB   ) */
		 				/*              (  AdlibT|[gȂ̂ŁAadlib instrument format܂S3Mt@C͉tsƂ܂B) */
						/*              (  ܂AModplugTrackerŕҏWS3M̏ꍇAWavedataȂSampléAType=0ƂȂ܂B  ) */
						/*              (  SampleheadeŕAVolC2spdȊOAVOl`܂߂đSă[NAĂ悤łB   ) */
						/*              (  VOl`TypeAType=1ȊOSample͖SampleƂăXLbvĂB ) */
		 char  dos_filename[13];	/* +0001, 13: Dos filename (12345678.ABC) (incl. NUL)                                                   */
						/*              (Documentɂchar[12]ŖNUL܂܂Ȃ悤ɏĂ܂A肾Ǝv܂B) */
						/*              (  char[13]ŖNUL܂ނƍlAmemsegtB[hƂ̐܂B) */
						/*              (  s3mod̃R[hAchar[13]ƂĎĂ܂B                                ) */
	unsigned short memseg;			/* +000e,  2: Pointer to sampledata                                                                                   */
						/*              Inside a sample or S3M, MemSeg tells the parapointer to the actual sampledata.                        */
						/*              In files all 24 bits are used.                                                                        */
						/*              In memory the value points to the actual sample segment or Fxxx if sample is in EMS under handle xxx. */
						/*              In memory the first memseg byte is overwritten with 0 to create the dos filename terminator nul.      */
						/*              (DocumentɂMemseg000dn܂3oCgƏĂ܂A肾Ǝv܂B        )           */
						/*              (  ̐Document炻̂܂܈p̂ŁA邾Ȃ̂œǂ܂ȂłB )           */
						/*              (  MemseǵASampledatåJnʒut@C擪Parapointerŕ\HalfWordlłB    )           */
						/*              (  s3mod̃R[hÂ悤ɎĂ܂B                                        )           */
		 int   length;			/* +0010,  4: Length                                                                                                                                     */
		 int   loop_begin;		/* +0014,  4: LoopBegin                                                                                                                                  */
		 int   loop_end;		/* +0018,  4: LoopEnd                                                                                                                                    */
						/*              Length / LoopBegin / LoopEnd are all 32 bit parameters although ST3 only support file sizes up to 64,000 bytes.                          */
						/*              Files bigger than that are clipped to 64,000 bytes when loaded to ST3.                                                                   */
						/*              NOTE that LoopEnd points to one byte AFTER the end of the sample, so LoopEnd=100 means that byte 99.9999 (fixed) is the last one played. */
	unsigned char  vol;			/* +001c,  1: Default volume 0..64 */
	unsigned char  x001d;			/* +001d,  1: Reserved */
	unsigned char  pack;			/* +001e,  1: Pack; 0=unpacked, 1=DP30ADPCM packing (not used by ST3.01) */
	unsigned char  flags;			/* +001f,  1: Flags                                                                                     */
						/*              +1=loop on                                                                              */
						/*              +2=stereo (after Length bytes for LEFT channel, another Length bytes for RIGHT channel) */
						/*              +4=16-bit sample (intel LO-HI byteorder)                                                */
						/*              (+2/+4 not supported by ST3.01)                                                         */
		 int   c2spd;			/* +0020,  4: C2spd; Herz for middle C. ST3 only uses lower 16 bits.                  */
						/*              Finetuning (C2SPD) is actually the frequency in herz for the note C4. */
						/*              Why is it C2SPD?                                                      */
						/*              Well, originally in ST2 the middle note was C2 and the name stuck.    */
						/*              Later in ST3 the middle note was raised to C4 for more octaves...     */
						/*              So actually C2SPD should be called C4SPD...                           */
						/*              (ModplugTracker̓IN^[u\L傫̂ŁAC5ɑ܂B)  */
	unsigned char  x0024[4];		/* +0024,  4: Reserved */
	unsigned short int_gp;			/* +0028,  2: Int:Gp; Internal: Address of sample in gravis memory /32 */
						/*              (only used while module in memory)                     */
	unsigned short int_512;			/* +002a,  2: Int:512; Internal: flags for soundblaster loop expansion */
						/*              (only used while module in memory)                     */
		 int   int_lastused;		/* +002c,  4: Int:las; Internal: last used position (only works with sb) */
						/*              (only used while module in memory)                       */
		 char  sample_name[28];		/* +0030, 28: Sample name, 28 characters max (incl. NUL) */
		 char  scrs[4];			/* +004c,  4: "SCRS" */
} S3MSAMPLEHEADER;				/* =0050 */

/****************************************************************************
 *	P/ECE S3M Driver
 ****************************************************************************/

#define S3MBUFLEN	320			/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */
#define S3MBUFLEN_5	(S3MBUFLEN / 5)		/* e|h~̂߁A1/5[tick]Â~LVO܂ */

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
typedef struct _S3MSAMPLE {
	const unsigned char* sampledata;	/* + 0, 4: S3MSAMPLEHEADER.memseg    ZoAŒBSampleNULL */
	const unsigned char* loop_begin;	/* + 4, 4: S3MSAMPLEHEADER.loop_beginZoAŒBLoop on(sampledata+loop_begin)BLoop off(NULL             ) */
	const unsigned char* loop_end;		/* + 8, 4: S3MSAMPLEHEADER.loop_end  ZoAŒBLoop on(sampledata+loop_end  )BLoop off(sampledata+length) */
	int vol;				/* +12, 4: S3MSAMPLEHEADER.vol       擾AŒ */
	int c2spd;				/* +16, 4: S3MSAMPLEHEADER.c2spd     擾AŒ */
} S3MSAMPLE;					/* =20 */

/* AZuR[h璼ڎQƂ邽߁ACAEgŒł!! */
typedef struct _S3MCHANNEL {
	S3MSAMPLE* pending_sample;		/* + 0, 4: ̔SampleBChannelNULL */
	S3MSAMPLE* playing_sample;		/* + 4, 4: ݂̔SampleBSilentNULL */

	int vol;				/* + 8, 4: S3MSAMPLE.vol擾ASpecial commandŕω */
	int period;				/* +12, 4: ST3 periodɑAAmiga period4{ */
	int progress;				/* +16, 4: Sampledatep̐isJE^ */
	const unsigned char* sample_position;	/* +20, 4: Sampledataʒu */

	int special_command;			/* +24, 4: Special commandێ */
	int command_info;			/* +28, 4: Command infoێ */
	int tone_portamento;			/* +32, 4: Tone portamento̖ڕWPeriod */
} S3MCHANNEL;					/* =36 */

typedef struct _S3MDRIVER {
	int ordnum;				/* S3MMODULEHEADER.ordnum擾AŒ */
	int insnum;				/* S3MMODULEHEADER.insnum擾AŒ */
	int patnum;				/* S3MMODULEHEADER.patnum擾AŒ */

	int g_v;				/* S3MMODULEHEADER.g_v擾ASpecial commandŕω */
	int speed;				/* S3MMODULEHEADER.i_s擾ASpecial commandŕω */
	int tempo;				/* S3MMODULEHEADER.i_t擾ASpecial commandŕω */

	int progress;				/* TempoispJE^ */
	int tick;				/* SpeedispJE^ */
	int order;				/* ݂Order */
	int row;				/* Row */
	const unsigned char* pattern_position;	/* Pattern data */

	int stat;				/* ʏ0Bt~ɗvi[ */
	int position_jump;			/* ʏ-1BPosition jumporderݒ */
	int pattern_break;			/* ʏ-1BPattern breakrowݒ */

	const unsigned char* orders/*[ordnum]*/;	/* Direct */
	S3MSAMPLE* samples/*[insnum]*/;			/* Alloc */
	const unsigned char** patterns/*[patnum]*/;	/* Alloc */

	S3MCHANNEL channels[32];
} S3MDRIVER;

extern const short s3m_note_frequency_table[12];

int s3m_init(S3MDRIVER* driver, const void* data, int initial_row);
void s3m_free(S3MDRIVER* driver);
int s3m_init_pattern(S3MDRIVER* driver);
int s3m_seek_pattern(S3MDRIVER* driver, int row);
int s3m_run(S3MDRIVER* driver);
int s3m_mix(S3MDRIVER* driver, short wbuff[/*S3MBUFLEN_5*/]);
int s3m_stream_callback(short* wbuff, int param);

void s3m_mix1(S3MCHANNEL* channel, int volume, int frequency, int* mixbuf);
void s3m_mix2(short* wbuff, const int* mixbuf);

/* S3MCHANNEL.period͈̔ (ƎfA) */
#define S3M_PERIOD_MIN	(14317056 / (16000 * 32))	/* C2spd=16000[Hz]Ɖ肵āA5[octave]܂ */
#define S3M_PERIOD_MAX	(14317056)			/* 1[Hz]܂ */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* S3Mt@C̍ĐJn܂B
 * [in]
 *	data		S3Mf[^̐擪AhXB
 *	initial_row	tJnRowB
 * [out]
 *	߂l		ĐJnɐ0Ԃ܂B
 *			ĐJnɎs0ȊO̒lԂ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKs3m_stop()ĂŁAxN^𕜌ĂB
 *	* tJnRoww𗘗pƁASampleZbg𗘗p镡̋ȂЂƂS3Mt@Cɂ܂Ƃ߂邱Ƃł܂B
 *	  tJnRow𗘗pꍇ́A擪PatternɃWve[uƂȂPosition jumpׂĂĂB
 *	  ၄
 *		++---------------+---------------+---------------++
 *		|| --- -- -- B01 | --- -- -- A06 | --- -- -- T96 || ... BGM#0: Order= 1`, Speed=6, Tempo=150
 *		|| --- -- -- B0A | --- -- -- A06 | --- -- -- T7D || ... BGM#1: Order=10`, Speed=6, Tempo=125
 *		|| --- -- -- B14 | --- -- -- A05 | --- -- -- T96 || ... BGM#2: Order=20`, Speed=5, Tempo=150
 *		|| --- -- -- --- | --- -- -- --- | --- -- -- --- ||
 *	  ̋@\̓Q[BGMȂǁASampleZbg𗘗p镡ȂSampleLAߖ񂷂邽߂ɗpӂ܂B
 *	  ꂼ̋Ȃ[vꍇPosition jumpA[vȂꍇSet speed = 0AȂ̏I[ɔzuĂB
 *	  ̋@\𗘗pȂ(Wve[ûȂ)ʏS3Mt@C̏ꍇ́AtJnRow = 0w肵ĂB
 */
int s3m_play(const void* data, int initial_row);

/* S3Mt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void s3m_stop();

/* tԂ擾܂B
 * [out]
 *	߂l		tȂ1Ԃ܂B
 *			~Ȃ0Ԃ܂B
 *			tI܂̓G[ȂΕ̒lԂ܂B
 */
int s3m_stat();

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_S3M_H__*/
