
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

		.code
		.align		1
		.global		REG_open_key
		.global		REG_get_value
		.global		REG_get_string
		.global		REG_get_blob
REG_open_key:
		;//%r12 := keyBody
		;//%r13 := keyName
		jp.d		REG_op					;//%r10 := addr
		ld.w		%r14, 0					;//%r14 := type = 0/*L[*/								*delay*
REG_get_value:
		;//%r12 := keyBody
		;//%r13 := valueName
		call.d		REG_op					;//%r11:%r10 := data:addr
		ld.w		%r14, 1					;//%r14 := type = 1/*l*/								*delay*
		sub		%r10, 1					;//if(--addr == -1) { return -1 }
		jrult		2					;//else {
		 ld.w		%r10, %r11				;//  %r10 := data
		ret							;//  return  data }
REG_get_string:
		;//%r12 := keyBody
		;//%r13 := stringName
		jp.d		REG_op					;//%r10 := addr
		ld.w		%r14, 2					;//%r14 := type = 2/**/								*delay*
REG_get_blob:
		;//%r12 := keyBody
		;//%r13 := blobName
		ld.w		%r14, 3					;//%r14 := type = 3/*BLOB*/
		;//-----------------------------------------------------;//
REG_op:
		;//%r12 := addr
		;//%r13 := name
		;//%r14 := type
	    ;//{{2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	    ;//	ld.w		%r10, 0					;//%r10 := 0
	    ;//2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		cmp		%r12, 0					;//if(!addr) { return 0 }
		jreq.d		REG_op_RET				;//
		ld.w		%r10, 0					;//%r10 := 0										*delay*
	    ;//}}2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		ld.ub		%r4, [%r12]+				;//%r4  := mask = *addr++
		rr		%r4, 8					;//%r4[31:24] := mask
REG_op_LOOP:								;//for(;;) {
		add		%r4, %r4				;//  %psr(C) := mask[31], %r4  := mask <<= 1
		jruge		7					;//  if(%psr(C)) {
		 ld.ub		%r5, [%r12]+				;//    %r5  :=      nH
		 ld.ub		%r6, [%r12]+				;//    %r6  :=             nL
		 sla		%r5, 8					;//    %r5  :=      nH<<8
		 or		%r5, %r6				;//    %r5  := n = (nH<<8)|nL
		 jp.d		4					;//    %r5  := n++
		 add		%r5, 1					;//  } else {										*delay*
		  jreq		REG_op_RET				;//    if(!mask) { return 0 }
		  ld.w		%r5, 0					;//    %r5  := n = 0 }
		sub		%r14, 1					;//  %r14 := type--
		jrult		REG_op_BREAK				;//  if(type == -1) { break }
		add		%r12, %r5				;//  %r12 := addr + n * 1
		sla		%r5, 2					;//  %r5  :=        n * 4
		jp.d		REG_op_LOOP				;//}
		add		%r12, %r5				;//  %r12 := addr + n * 5 = addr + n * (2/*name*/+3/*data*/)				*delay*
REG_op_BREAK:
	   ;//{{---
		call.d		REG_bsearch				;//%r10    := addr = REG_bsearch(name, addr, n)
		ld.w		%r14, %r5				;//%r14    :=                                n						*delay*
		cmp		%r10, 0					;//if(!addr) {
		jreq		REG_op_RET				;//  return 0 }
	   ;//}}---
		ld.b		%r11, [%r10]+				;//%r11 :=            (int8_t)dataH
		ld.ub		%r12, [%r10]+				;//%r12 :=                              dataM
		ld.ub		%r13, [%r10]+				;//%r13 :=                                         dataL
		sla		%r11, 8					;//%r11 :=            (int8_t)dataH<<8
		or		%r11, %r12				;//%r11 :=           ((int8_t)dataH<<8)|dataM
		sla		%r11, 8					;//%r11 :=          (((int8_t)dataH<<8)|dataM)<<8
		or		%r11, %r13				;//%r11 := data  = ((((int8_t)dataH<<8)|dataM)<<8)|dataL
		add		%r10, %r11				;//%r10 := addr += data
		sll		%r11, 8					;//%r11 :=                  (data << 8)
REG_op_RET:								;//
		ret.d							;//%r11:%r10 := data:addr			(addr=0)̏ꍇ(data=sl)ł
		srl		%r11, 8					;//%r11 := data = (unsigned)(data << 8) >> 8	rRETjpꍇ̓_~[	*delay*
		;//-----------------------------------------------------;//
REG_bsearch:
		;//%r12 := addr
		;//%r13 := name
		;//%r14 := n
		ld.ub		%r4, %r13				;//%r4  := nameL  = (uint8_t)name
		sra		%r13, 8					;//%r13 := name >>= 8
		ld.ub		%r5, %r13				;//%r5  := nameH  = (uint8_t)name
		sra		%r13, 8					;//%r13 := name >>= 8
		jrne		REG_bsearch_RET0			;//if(!name) {
		jp.d		REG_bsearch_START			;//  goto L_START
		cmp		%r14, 0					;//  %psr(Z) := !n		*delay*
REG_bsearch_LOOP:							;//  do {										
		ld.w		%r6, %r14				;//    %r6  :=                n								
		sra		%r6, 1					;//    %r6  :=                n >> 1							
		add		%r10, %r6				;//    %r10 :=       addr + ((n >> 1) * 1)						
		sla		%r6, 2					;//    %r6  :=               (n >> 1) * 4						
		add		%r10, %r6				;//    %r10 := mid = addr + ((n >> 1) * 5) = addr + ((n >> 1) * (2/*name*/+3/*data*/))	
		ld.ub		%r6, [%r10]+				;//    %r6  :=        mid[0/*nameH*/]				, %r10 := mid + 1	
		sub		%r6, %r5				;//    %r6  := diff = mid[0/*nameH*/] - nameH							ł̓C^[bN܂B
		jrne		4					;//    if(!diff) {									
		 ld.ub		%r6, [%r10]				;//      %r6  :=        mid[1/*nameL*/]				
		 sub		%r6, %r4				;//      %r6  := diff = mid[1/*nameL*/] - nameL							!INTERLOCK!
		 jreq		REG_bsearch_RET				;//      if(!diff) { return &mid[2/*data*/] } }						
		jrge		4					;//    if(diff < 0) {									
		 ld.w		%r12, %r10				;//      %r12 :=        mid + 1					
		 add		%r12, 4					;//      %r12 := addr = mid + 5 = mid + (2/*name*/+3/*data*/)				
		 sub		%r14, 1					;//      %r14 := n-- }									
		sra		%r14, 1					;//    %r14 := n >>= 1									
REG_bsearch_START:							;//    											
		jrne.d		REG_bsearch_LOOP			;//  } while(n)		
		ld.w		%r10, %r12				;//    %r10 := addr										*delay*
REG_bsearch_RET0:							;//}									
		ld.w		%r10, -1				;//return  (-1+1)/*=NULL*/						
REG_bsearch_RET:							;//									
		ret.d							;//return  &mid[2/*data*/]						
		add		%r10, 1					;//%r10 := &mid[2/*data*/]				*delay*


		.code
		.align		1
		.global		REG_open_key_l
		.global		REG_open_key_a
		.global		REG_open_key_v
		.global		REG_get_value_l
		.global		REG_get_value_a
		.global		REG_get_value_v
		.global		REG_get_string_l
		.global		REG_get_string_a
		.global		REG_get_string_v
		.global		REG_get_blob_l
		.global		REG_get_blob_a
		.global		REG_get_blob_v
REG_open_key_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_open_key_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_open_key_v:
		;//%r12 := keyBody
		;//%r13 := names
	    ;//{{Ꮘ
		;//uREG_open_key_l(keyBody,-1)v̌`ŌĂяoꂽꍇ́AG[ƂNULLԂ̂ł͂ȂAkeyBodygԂRłB
		;// - REG_open_get_v()ĂяoƁAREG_open_get_v()ăG[ƔfĂ܂B
		;//   REG_open_get_v()ɓᏈǉAŔfK؂Ǝv̂ŁAɓᏈǉ鎖ɂ܂B
		;// - clipfsm.cFsmObj_GetTransKey()A̓ɈˑĂ܂B
		ld.w		%r9, [%r13]				;//%r9  := names[0]
	ext	REG_open_key+0x0@h	; 		xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key								*anti-interlock*
	ext	REG_open_key+0x0@m
	ld.w	%r14,REG_open_key+0x0@l
		cmp		%r9, -1					;//if(names[0] != -1) {
		jrne		REG_open_get_v				;//  goto REG_open_get_v }
		ret.d							;//return  keyBody
		ld.w		%r10, %r12				;//%r10 := keyBody									*delay*
	    ;//}}Ꮘ
		;//-----------------------------------------------------;//
REG_get_value_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_get_value_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_value_v:
		;//%r12 := keyBody
		;//%r13 := names
	ext	REG_get_value+0x0@h	; 		xld.w		%r14, REG_get_value			;//%r14 := fn = REG_get_value
	ext	REG_get_value+0x0@m
	ld.w	%r14,REG_get_value+0x0@l
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_string_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_get_string_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_string_v:
		;//%r12 := keyBody
		;//%r13 := names
	ext	REG_get_string+0x0@h	; 		xld.w		%r14, REG_get_string			;//%r14 := fn = REG_get_string
	ext	REG_get_string+0x0@m
	ld.w	%r14,REG_get_string+0x0@l
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_blob_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+0x4]				;//%r12 := keyBody
	ld.w	%r13,%sp	; 		xadd		%r13, %sp, 8				;//%r13 := ap = &...
	add	%r13,0x8
REG_get_blob_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_blob_v:
		;//%r12 := keyBody
		;//%r13 := names
	ext	REG_get_blob+0x0@h	; 		xld.w		%r14, REG_get_blob			;//%r14 := fn = REG_get_blob
	ext	REG_get_blob+0x0@m
	ld.w	%r14,REG_get_blob+0x0@l
		;//-----------------------------------------------------;//
REG_open_get_v:
		;//%r12 := keyBody
		;//%r13 := names
		;//%r14 := fn
		pushn		%r1					;//
		ld.w		%r0, %r13				;//%r0  :=         names
		ld.w		%r1, %r14				;//%r1  :=         fn
		ld.w		%r13, [%r0]+				;//%r13 := name = *names++
		cmp		%r13, -1				;//if(name != -1)
		jreq		REG_open_get_v_NAMES_EMPTY		;//
		jp		REG_open_get_v_START			;//  goto L_START
REG_open_get_v_LOOP:							;//  do {
	call	REG_open_key	; 		xcall		REG_open_key				;//    %r10 := keyBody = REG_open_key(keyBody, name)
		ld.w		%r12, %r10				;//    %r12 := keyBody
		ld.w		%r13, [%r0]+				;//    %r13 := name = *names++
REG_open_get_v_START:							;//
		ld.w		%r14, [%r0]				;//    %r14 := *names
		cmp		%r14, -1				;//    											!INTERLOCK!
		jrne		REG_open_get_v_LOOP			;//  } while(*names != -1)
REG_open_get_v_NAMES_EMPTY:						;//}
		ld.w		%r14, %r1				;//%r14 :=  fn
		popn		%r1					;//
		jp		%r14					;//return (*fn)(keyBody, name)


		.code
		.align		1
		.global		REG_open_nth_key
		.global		REG_get_nth_value
		.global		REG_get_nth_string
		.global		REG_get_nth_blob
REG_open_nth_key:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_keyName
		jp.d		REG_nth					;//%r10 := addr
		ld.w		%r15, 0					;//%r15 := type = 0/*L[*/								*delay*
REG_get_nth_value:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_valueName
		call.d		REG_nth					;//%r11:%r10 := data:addr
		ld.w		%r15, 1					;//%r15 := type = 1/*l*/								*delay*
		sub		%r10, 1					;//if(--addr == -1) { return -1 }
		jrult		2					;//else {
		 ld.w		%r10, %r11				;//  %r10 := data
		ret							;//  return  data }
REG_get_nth_string:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_stringName
		jp.d		REG_nth					;//%r10 := addr
		ld.w		%r15, 2					;//%r15 := type = 2/**/								*delay*
REG_get_nth_blob:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_blobName
		ld.w		%r15, 3					;//%r15 := type = 3/*BLOB*/
		;//-----------------------------------------------------;//
REG_nth:
		;//%r12 := addr
		;//%r13 := index
		;//%r14 := p_name
		;//%r15 := type
	    ;//{{2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	    ;//	ld.w		%r10, 0					;//%r10 := 0
	    ;//2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		cmp		%r12, 0					;//if(!addr) { return 0 }
		jreq.d		REG_nth_RET				;//
		ld.w		%r10, 0					;//%r10 := 0										*delay*
	    ;//}}2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		ld.ub		%r4, [%r12]+				;//%r4  := mask = *addr++
		rr		%r4, 8					;//%r4[31:24] := mask
REG_nth_LOOP:								;//for(;;) {
		add		%r4, %r4				;//  %psr(C) := mask[31], %r4  := mask <<= 1
		jruge		7					;//  if(%psr(C)) {
		 ld.ub		%r5, [%r12]+				;//    %r5  :=      nH
		 ld.ub		%r6, [%r12]+				;//    %r6  :=             nL
		 sla		%r5, 8					;//    %r5  :=      nH<<8
		 or		%r5, %r6				;//    %r5  := n = (nH<<8)|nL
		 jp.d		4					;//    %r5  := n++
		 add		%r5, 1					;//  } else {										*delay*
		  jreq		REG_nth_RET				;//    if(!mask) { return 0 }
		  ld.w		%r5, 0					;//    %r5  := n = 0 }
		sub		%r15, 1					;//  %r15 := type--
		jrult		REG_nth_BREAK				;//  if(type == -1) { break }
		add		%r12, %r5				;//  %r12 := addr + n * 1
		sla		%r5, 2					;//  %r5  :=        n * 4
		jp.d		REG_nth_LOOP				;//}
		add		%r12, %r5				;//  %r12 := addr + n * 5 = addr + n * (2/*name*/+3/*data*/)				*delay*
REG_nth_BREAK:
	   ;//{{---
		cmp		%r13, %r5				;//if((unsigned)index >= (unsigned)n) {
		jruge		REG_nth_RET				;//  return 0 }
		ld.w		%r10, %r12				;//%r10 := addr
		add		%r10, %r13				;//%r10 := addr + index * 1
		sla		%r13, 2					;//%r13 :=        index * 4
		add		%r10, %r13				;//%r10 := addr + index * 5 = addr + index * (2/*name*/+3/*data*/)
		ld.ub		%r4, [%r10]+				;//%r4  :=           nameH
		ld.ub		%r5, [%r10]+				;//%r5  :=                     nameL
		cmp		%r14, 0					;//if(p_name) {
		jreq		4					;//
		 sla		%r4, 8					;//  %r4  :=         nameH<<8
		 or		%r4, %r5				;//  %r4  := name = (nameH<<8)|nameL
		 ld.w		[%r14], %r4				;//  *p_name = name }
	   ;//}}---
		ld.b		%r11, [%r10]+				;//%r11 :=            (int8_t)dataH
		ld.ub		%r12, [%r10]+				;//%r12 :=                              dataM
		ld.ub		%r13, [%r10]+				;//%r13 :=                                         dataL
		sla		%r11, 8					;//%r11 :=            (int8_t)dataH<<8
		or		%r11, %r12				;//%r11 :=           ((int8_t)dataH<<8)|dataM
		sla		%r11, 8					;//%r11 :=          (((int8_t)dataH<<8)|dataM)<<8
		or		%r11, %r13				;//%r11 := data  = ((((int8_t)dataH<<8)|dataM)<<8)|dataL
		add		%r10, %r11				;//%r10 := addr += data
		sll		%r11, 8					;//%r11 :=                  (data << 8)
REG_nth_RET:								;//
		ret.d							;//%r11:%r10 := data:addr			(addr=0)̏ꍇ(data=sl)ł
		srl		%r11, 8					;//%r11 := data = (unsigned)(data << 8) >> 8	rRETjpꍇ̓_~[	*delay*


		.code
		.align		1
		.global		REG_open_nth_key_l
		.global		REG_open_nth_key_a
		.global		REG_open_nth_key_v
		.global		REG_get_nth_value_l
		.global		REG_get_nth_value_a
		.global		REG_get_nth_value_v
		.global		REG_get_nth_string_l
		.global		REG_get_nth_string_a
		.global		REG_get_nth_string_v
		.global		REG_get_nth_blob_l
		.global		REG_get_nth_blob_a
		.global		REG_get_nth_blob_v
REG_open_nth_key_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_keyName
		;//[%sp+8] := ...
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+0x4]				;//%r14 := p_keyName
	ld.w	%r15,%sp	; 		xadd		%r15, %sp, 8				;//%r15 := ap = &...
	add	%r15,0x8
REG_open_nth_key_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_keyName
		;//%r15    := ap
REG_open_nth_key_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_keyName
		;//%r15    := names
	ext	REG_open_nth_key+0x0@h	; 		xld.w		%r10, REG_open_nth_key			;//%r10 := fn = REG_open_nth_key
	ext	REG_open_nth_key+0x0@m
	ld.w	%r10,REG_open_nth_key+0x0@l
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_value_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_valueName
		;//[%sp+8] := ...
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+0x4]				;//%r14 := p_valueName
	ld.w	%r15,%sp	; 		xadd		%r15, %sp, 8				;//%r15 := ap = &...
	add	%r15,0x8
REG_get_nth_value_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_valueName
		;//%r15    := ap
REG_get_nth_value_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_valueName
		;//%r15    := names
	ext	REG_get_nth_value+0x0@h	; 		xld.w		%r10, REG_get_nth_value			;//%r10 := fn = REG_get_nth_value
	ext	REG_get_nth_value+0x0@m
	ld.w	%r10,REG_get_nth_value+0x0@l
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_string_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_stringName
		;//[%sp+8] := ...
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+0x4]				;//%r14 := p_stringName
	ld.w	%r15,%sp	; 		xadd		%r15, %sp, 8				;//%r15 := ap = &...
	add	%r15,0x8
REG_get_nth_string_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_stringName
		;//%r15    := ap
REG_get_nth_string_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_stringName
		;//%r15    := names
	ext	REG_get_nth_string+0x0@h	; 		xld.w		%r10, REG_get_nth_string		;//%r10 := fn = REG_get_nth_string
	ext	REG_get_nth_string+0x0@m
	ld.w	%r10,REG_get_nth_string+0x0@l
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_blob_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_blobName
		;//[%sp+8] := ...
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+0x4]				;//%r14 := p_blobName
	ld.w	%r15,%sp	; 		xadd		%r15, %sp, 8				;//%r15 := ap = &...
	add	%r15,0x8
REG_get_nth_blob_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_blobName
		;//%r15    := ap
REG_get_nth_blob_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_blobName
		;//%r15    := names
	ext	REG_get_nth_blob+0x0@h	; 		xld.w		%r10, REG_get_nth_blob			;//%r10 := fn = REG_get_nth_blob
	ext	REG_get_nth_blob+0x0@m
	ld.w	%r10,REG_get_nth_blob+0x0@l
		;//-----------------------------------------------------;//
REG_open_get_nth_v:
		;//%r10    := fn
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_name
		;//%r15    := names
	sub	%sp,0x3		; 		xsub		%sp, %sp, 12
	ld.w	[%sp+0x0],%r13	; 		xld.w		[%sp+0x0], %r13				;//[%sp+0] := index
	ld.w	[%sp+0x1],%r14	; 		xld.w		[%sp+0x4], %r14				;//[%sp+4] := p_name
	ld.w	[%sp+0x2],%r10	; 		xld.w		[%sp+0x8], %r10				;//[%sp+8] := fn
	ext	REG_open_key_v@rm	; 		xcall.d		REG_open_key_v				;//%r10 := keyBody = REG_open_key_v(keyBody, names)
	call.d	REG_open_key_v@rl
		ld.w		%r13, %r15				;//%r13 :=                                   names					*delay*
	ld.w	%r13,[%sp+0x0]	; 		xld.w		%r13, [%sp+0x0]				;//%r13 :=                 index
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+0x4]				;//%r14 :=                        p_name
	add	%sp,0x2		; 		xadd		%sp, %sp, 8				;//[%sp+0] := fn
		ret.d							;//return   (*fn)(keyBody, index, p_name)
		ld.w		%r12, %r10				;//%r12 :=        keyBody								*delay*


		.code
		.align		1
		.global		REG_get_blob_size
REG_get_blob_size:
		;//%r12 := blob
		cmp		%r12, 0					;//if(!blob) { goto RET }
		jreq		REG_get_blob_size_RET			;//
		sub		%r12, 4					;//%r12        := blob -= 4											
		ld.w		%r12, [%r12]				;//%r12[31:24] := sizeL,    %r12[23:16] := sizeM, %r12[15:8] := sizeH, %r12[7:0] := (sl)			WXgBLOBf[^{̂[hACgĂ鎖𗘗pčœK
		swap		%r12, %r12				;//%r12[31:24] := (sl), %r12[23:16] := sizeH, %r12[15:8] := sizeM, %r12[7:0] := sizeL	!INTERLOCK!	nꂽblob|C^͂S̔{ł͂Ȃ̂ŁA(blob-4)̈ʒu烏[h
		sll		%r12, 8					;//%r12[31:24] := sizeH,    %r12[23:16] := sizeM, %r12[15:8] := sizeL, %r12[7:0] := 0				(blob-4)Ɋi[Ăl͕slłA(blob-4)WXgłANZX\ł
		srl		%r12, 8					;//%r12[31:24] := 0,        %r12[23:16] := sizeH, %r12[15:8] := sizeM, %r12[7:0] := sizeL			
		add		%r12, 1					;//%r12        := size++	(oCg-1)˃oCgɕϊB
REG_get_blob_size_RET:							;//
		ret.d							;//return         size,,0
		ld.w		%r10, %r12				;//%r10        := size,,0									*delay*

