/*	
 *	clipreg.c
 *
 *	WXge[u
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Tue Mar 24 02:10:47 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Mar 24 21:45:37 JST 2015 Naoyuki Sawa
 *	- REG_open_key(),y,REG_get_value()ɁA(keyBody=NULL)w肵ĂSɂ܂B
 *	  REG_open_key_v()REG_get_value_v()̏̑啔ʉăR[h팸܂B
 *	* Thu Mar 26 21:28:16 JST 2015 Naoyuki Sawa
 *	- dRegTblC.exȅo̓f[^\ύXɔAW[啝ɕύX܂B
 *	  O܂ł̓L[zjAT[`Ă܂A̓oCiT[`ɂȂ܂B
 *	  ڍׂ́Auclip/tool/dRegTblC/winapp.hv̓̃RgQƂĂB
 *	* Sat Apr 11 13:20:40 JST 2015 Naoyuki Sawa
 *	 - ̃f[^^CvǉA啝ȕύXs܂B
 *	   ύXÕR[hQƂɂ́AÕA[JCuQƂĂB
 *	* Mon Jul 27 21:32:15 JST 2015 Naoyuki Sawa
 *	- REG_open_key_v()̏C܂BCéAȉ̒ʂł:
 *	  'REG_open_key_l(keyBody,-1)'ɑ΂āA܂łNULLԂĂ܂B(keyBody)gԂ̂RłƎv̂ŁÂ悤ɏC܂B
 *	- ɁAclipfsm.c  FsmObj_GetTransKey() ɂāA'REG_open_key_l(keyBody,-1)'(keyBody)gԂ҂R[hĂ܂Ă܂B
 *	  ܂ł́A'REG_open_key_l(keyBody,-1)'NULLԂĂ̂ŁAFsmObj_GetTransKey() 삵Ă܂łB
 *	  A'REG_open_key_l(keyBody,-1)'(keyBody)gԂ悤ɏĈŁAFsmObj_GetTransKey() 삷悤ɂȂ܂B
 *	- L̏CAREG_open_get_v()REG_open_key()ł͂ȂAREG_open_key_v()ōsŔAe͈͂߂邽߂łB
 *	  REG_open_get_v()REG_open_key()́Å֐Ƃ̋ʐ̂߂ɁA(keyName=-1)I[ƌȂᏈs܂B
 *	  Ꮘ́AĂяoKw̐󂢕ōsSƍlāAREG_open_key_v()ōsɂ܂B
 *	* Tue Sep 22 12:15:09 JST 2015 Naoyuki Sawa
 *	- uCfNXANZX^,y,Ce[Vp̊֐vǉ܂B
 *	- CfNXANZX^̊֐gpāACe[Vs܂B
 *	  TBL_RegTbl->RegKey_X->RegKey_YɑlڰĂTBL_RegTbl->RegKey_X->RegKey_Y݂ȂĂSł
 *	  for(index=0;
 *	      (valueData=REG_get_nth_value_l(TBL_RegTbl,index,&valueName,RegKey_X,RegKey_Y,-1))!=-1;
 *	      index++){
 *	        printf("%d:%d=>%d\n",index,valueName,valueData);
 *	  }
 *	* Sun Oct 04 21:01:44 JST 2015 Naoyuki Sawa
 *	- 啝ȕύXs܂B
 *	  ύXÕR[h̓\[X̒ɎcĂȂ̂ŁAKvȂΑO܂ł̃\[XQƂĂB
 *	  ύXÕ\[Xƃc['keep/17_WXge[u`ύXOۑ/'ɕۑĂ܂B
 *	- ύX_͈ȉ̒ʂłB
 *	  @'l'f[^24rbg̒lԂ悤ɂ܂B܂ł16rbg̒lԂ܂łB
 *	  A'BLOB'^Cvǉ܂B܂ł'BLOB'^CvA̒lɕĊi[Ă܂B
 *	  Bz̗vf̏65536ɂȂ܂B܂ł͔z̗vf̏65535łB
 *	- ̊֐dlɂ͕ύXL܂B'BLOB'^Cv̊֐ǉ܂B
 *	  WXge[ũoCitH[}bg͌݊͗L܂B
 *	- ̕ύXɂASẴ^Cṽf[^24rbgɓꂳ܂BV^Cvǉ鎖eՂƎv܂B
 *	  }XÑrbg4rbgcĂ̂ŁA4ނ͗eՂɑ₹܂BڍׂREG_op()maskϐQƂĉB
 *	* Wed Oct 07 21:27:19 JST 2015 Naoyuki Sawa
 *	- REG_get_blob_size()ǉ܂B
 *	* Thu Oct 08 21:52:46 JST 2015 Naoyuki Sawa
 *	- BLOB̃f[^\ύX܂B
 *	  ܂ł́ABLOB̃TCY(f[^{̂̃oCg)i[Ă܂ÁA(f[^{̂̃oCg-1)i[܂B
 *	  ̃tB[hɂ(vf-1)i[Ă̂ŁABLOB̃TCYɍ킹ēꂷՂƎvłB
 *	* Fri Oct 09 22:14:58 JST 2015 Naoyuki Sawa
 *	- REG_op()܂B
 *	  ܂ł͔ėpbsearch()𗘗pĂ܂AREG_op()̗pɓčREG_bsearch()쐬ĂĂяo悤ɂ܂B
 *	  Ȍvł͂܂񂪁AREG_op()Ăяo֐̓삪A3{炢Ȃ݂łB
 *	* Wed Oct 14 21:21:55 JST 2015 Naoyuki Sawa
 *	- x}̂߂REG_bsearch()Cł̎C܂B
 *	  e͕ςĂ܂B
 *	* Thu Oct 29 21:30:16 JST 2015 Naoyuki Sawa
 *	- REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
 *	- LREG_op()̃oỎeŁAclipfsm.cFsmObj_ApplyTrans()삵Ă܂łB
 *	  FsmObj_ApplyTrans()̏ŁA(pKey=NULL)ɑ΂iFnGrd,iFnAct,iStNex擾悤ƂɁA(-1)ԂׂƂANULLAhXt߂̃RL[ɈvƁAl擾łƌȂĂ܂ԈlԂĂ܂łB
 *	  ̏CɂāAFsmObj_ApplyTrans()삷悤ɂȂ܂B
 */
#include "clip.h"
/****************************************************************************
 *	ANZX^̊֐
 ****************************************************************************/
/*==========================================================================*
 *	{IȊ֐
 *==========================================================================*/
#ifndef PIECE
//REG_op()̗pɓčoCiT[`֐łB
//ASYœK̍Hvcliplibc.cbsearch()̎ƓłB
//{{2015/10/14C:x}̂߂REG_bsearch()Cł̎C܂Be͕ςĂ܂B
//static const uint8_t* REG_bsearch(const uint8_t* addr, int name, int n/*>=0*/) {
//	int nameL, nameH;
//	nameL  = (uint8_t)name;
//	name >>= 8;
//	nameH  = (uint8_t)name;
//	name >>= 8;
//	if(!name) {	//O͕16rbgłB͈͊O̖Ow肳ꂽꍇɉ16bitRvȂ悤ɁA16rbg0łȂΐɏOB
//		goto L_START;
//		do {
//			const uint8_t* mid = addr + ((n >> 1) * (2/*name*/+3/*data*/));
//			int diff = mid[0/*nameH*/] - nameH;
//			if(!diff) {
//				diff = mid[1/*nameL*/] - nameL;
//				if(!diff) { return &mid[2/*data*/]; }	//dataւ̃|C^ԂB
//			}
//			if(diff < 0) {
//				addr = mid + (2/*name*/+3/*data*/);
//				n--;
//			}
//			n >>= 1;
//L_START:		;
//		} while(n);
//	}
//	return NULL;	//ȂNULLԂB
//}
//2015/10/14C:x}̂߂REG_bsearch()Cł̎C܂Be͕ςĂ܂B
// * Wed Oct 14 21:21:55 JST 2015 Naoyuki Sawa
// - x}̂߂REG_bsearch()Cł̎C܂B
//   e͕ςĂ܂B
// - C̎dlł́Aϐ錾܂ރubN̓rցÃubNOgotoŔэގ͋֎~Ă܂B
//   QƎ
//   wISO/IEC 9899:TC2 Programming languages - Cx(http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1124.pdf)
//   u6.8.6.1 The goto statement - 4 EXAMPLE 2v(p.138)
//   L̕ύXOREG_bsearch()̎́A̎dlɈᔽĂ܂B
//   ۂɂ́AGCCVC++6.0ł̓G[xoɁA삵܂B
//   Aꕔ̃RpC(Hew)ł͌xo܂B(͐łB)
//   ɂĂ͖薳̂łAC̎dlɈᔽĂ̂͗ǂȂ̂ŁAC鎖ɂ܂B
static const uint8_t* REG_bsearch(const uint8_t* addr, int name, int n/*>=0*/) {
	int nameL, nameH, diff;
	const uint8_t* mid;
	nameL  = (uint8_t)name;
	name >>= 8;
	nameH  = (uint8_t)name;
	name >>= 8;
	if(!name) {	//O͕16rbgłB͈͊O̖Ow肳ꂽꍇɉ16bitRvȂ悤ɁA16rbg0łȂΐɏOB
		goto L_START;
		do {
			mid = addr + ((n >> 1) * (2/*name*/+3/*data*/));
			diff = mid[0/*nameH*/] - nameH;
			if(!diff) {
				diff = mid[1/*nameL*/] - nameL;
				if(!diff) { return &mid[2/*data*/]; }	//dataւ̃|C^ԂB
			}
			if(diff < 0) {
				addr = mid + (2/*name*/+3/*data*/);
				n--;
			}
			n >>= 1;
L_START:		;
		} while(n);
	}
	return NULL;	//ȂNULLԂB
}
//}}2015/10/14C:x}̂߂REG_bsearch()Cł̎C܂Be͕ςĂ܂B
static uint64_t REG_op(const uint8_t* addr, int name, int type) {
	int mask, n, data;
    //{{2015/10/29ǉ:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	//NULLAhXɑ΂ĂяoȂΗvf̂ƓƌȂċAB
	if(!addr) { return 0; }
    //}}2015/10/29ǉ:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	//̃L[{fBĂz^Cṽ}XN擾B
	// - bit31=L[,bit30=l,bit29=,bit28=BLOB,bit27`24=0(gp),bit27`0=0
	mask = *addr++ << 24;								//AZuł'rr 8'ƏoB
	for(;;) {
		//̃L[{fB̃^Cv̔zĂc
		if(mask < 0) {								//
			mask <<= 1;							//
			//z(vf-1)擾B					//@
			n   = *addr++;	//						//@
			n <<= 8;	//16rbg,rbOGfBA		//@
			n  |= *addr++;	//						//@
			//(vf-1)˗vfɕϊB				//@AZuł'add %r(mask),%r(mask); jrult 2; jreq RET'ƏoB	{{2015/10/05ǋL:ۂɂ͑̏Ƃ̌ˍōL̂Ƃ̃R[hɂ͂ȂȂBREG_op_LOOP̉̃R[hQƂB}}
			n++;								//@'(mask<0)'2ӏ'mask<<=1'̓AZuł1߂ɂ܂Ƃ߂B
		//̃L[{fB̃^Cv̔zĂȂ΁c			//@
		} else {								//@
			mask <<= 1;							//
			//̃L[{fBĂz^CvcĂȂ΋AB	//@
			// - AZuł͖߂lbit63`32͕slō\܂B	//@
			if(!mask) { return 0; }						//
			//z̗vf0ƂB
			n = 0;
		}
		//̔z񂪎w肳ꂽ^Cv̔zȂΔB
		if(--type < 0) { break; }
		//̔zXLbvB
		addr += n * (2/*name*/+3/*data*/);
	}
    {{//--- REG_op()REG_nth()Ƃŏ̈Ⴂ͈͂̔͂łB ---
	//̔z񂩂w肳ꂽOɈvvfB
	addr = REG_bsearch(addr, name, n);	//dataւ̃|C^ԂBȂNULLԂB
	//w肳ꂽOɈvvfȂ΋AB
	// - AZuł͖߂lbit63`32͕slō\܂B
	if(!addr) { return 0; }
    }}//--- REG_op()REG_nth()Ƃŏ̈Ⴂ͈͂̔͂łB ---
	data   = (int8_t)*addr++;		//
	data <<= 8;				//
	data  |=         *addr++;		//t24rbg,rbOGfBA		t24rbgŃAhXɉZA24rbgɕϊB
	data <<= 8;				//
	data  |=         *addr++;		//
	addr  += data;				//AhX					REG_get_value()Ăяoꂽꍇ͎gpȂB
	data   = (unsigned)(data << 8) >> 8;	//f[^					24rbg
	//߂l bit63`32 = f[^(24rbg)	REG_get_value()Ăяoꂽꍇ͂gB
	//       bit31` 0 = AhX			REG_get_value()ȊOĂяoꂽꍇ͂gB
	return (((uint64_t)(unsigned)data) << 32) | ((uint64_t)(unsigned)addr);
	//                 ~~~~~~~~~~̃LXgsȂĂʂ͓ɂȂ̂AʂȕgsR[hȂ悤ɖIɕɃLXgB
}
/*--------------------------------------------------------------------------*/
const uint8_t* REG_open_key(const uint8_t* keyBody, int keyName) {
	return (const uint8_t*)(int)REG_op(keyBody, keyName, 0/*L[*/);		//REG_op()̖߂lbit31`0ԂB
}
int REG_get_value(const uint8_t* keyBody, int valueName) {
	uint64_t data_addr = REG_op(keyBody, valueName, 1/*l*/);
	if(!(int)data_addr) { return -1; }						//REG_op()̖߂lbit31`00Ȃ(-1)ԂB	//AZuł'sub %r10,1; jrult RET'ƏoB
	return (int)(data_addr >> 32);							//REG_op()̖߂lbit55`32ԂB			//AZuł'ld.w %r10,%r11'ƏoB
}
const char* REG_get_string(const uint8_t* keyBody, int stringName) {
	return (const char*)(int)REG_op(keyBody, stringName, 2/**/);		//REG_op()̖߂lbit31`0ԂB
}
const void* REG_get_blob(const uint8_t* keyBody, int  blobName) {
	return (const void*)(int)REG_op(keyBody, blobName, 3/*BLOB*/);			//REG_op()̖߂lbit31`0ԂB
}
#else //PIECE
const uint8_t* REG_open_key(const uint8_t* keyBody, int keyName);
int REG_get_value(const uint8_t* keyBody, int valueName);
const char* REG_get_string(const uint8_t* keyBody, int stringName);
const void* REG_get_blob(const uint8_t* keyBody, int  blobName);
asm("
		.code
		.align		1
		.global		REG_open_key
		.global		REG_get_value
		.global		REG_get_string
		.global		REG_get_blob
REG_open_key:
		;//%r12 := keyBody
		;//%r13 := keyName
		jp.d		REG_op					;//%r10 := addr
		ld.w		%r14, 0					;//%r14 := type = 0/*L[*/								*delay*
REG_get_value:
		;//%r12 := keyBody
		;//%r13 := valueName
		call.d		REG_op					;//%r11:%r10 := data:addr
		ld.w		%r14, 1					;//%r14 := type = 1/*l*/								*delay*
		sub		%r10, 1					;//if(--addr == -1) { return -1 }
		jrult		2					;//else {
		 ld.w		%r10, %r11				;//  %r10 := data
		ret							;//  return  data }
REG_get_string:
		;//%r12 := keyBody
		;//%r13 := stringName
		jp.d		REG_op					;//%r10 := addr
		ld.w		%r14, 2					;//%r14 := type = 2/**/								*delay*
REG_get_blob:
		;//%r12 := keyBody
		;//%r13 := blobName
		ld.w		%r14, 3					;//%r14 := type = 3/*BLOB*/
		;//-----------------------------------------------------;//
REG_op:
		;//%r12 := addr
		;//%r13 := name
		;//%r14 := type
	    ;//{{2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	    ;//	ld.w		%r10, 0					;//%r10 := 0
	    ;//2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		cmp		%r12, 0					;//if(!addr) { return 0 }
		jreq.d		REG_op_RET				;//
		ld.w		%r10, 0					;//%r10 := 0										*delay*
	    ;//}}2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		ld.ub		%r4, [%r12]+				;//%r4  := mask = *addr++
		rr		%r4, 8					;//%r4[31:24] := mask
REG_op_LOOP:								;//for(;;) {
		add		%r4, %r4				;//  %psr(C) := mask[31], %r4  := mask <<= 1
		jruge		7					;//  if(%psr(C)) {
		 ld.ub		%r5, [%r12]+				;//    %r5  :=      nH
		 ld.ub		%r6, [%r12]+				;//    %r6  :=             nL
		 sla		%r5, 8					;//    %r5  :=      nH<<8
		 or		%r5, %r6				;//    %r5  := n = (nH<<8)|nL
		 jp.d		4					;//    %r5  := n++
		 add		%r5, 1					;//  } else {										*delay*
		  jreq		REG_op_RET				;//    if(!mask) { return 0 }
		  ld.w		%r5, 0					;//    %r5  := n = 0 }
		sub		%r14, 1					;//  %r14 := type--
		jrult		REG_op_BREAK				;//  if(type == -1) { break }
		add		%r12, %r5				;//  %r12 := addr + n * 1
		sla		%r5, 2					;//  %r5  :=        n * 4
		jp.d		REG_op_LOOP				;//}
		add		%r12, %r5				;//  %r12 := addr + n * 5 = addr + n * (2/*name*/+3/*data*/)				*delay*
REG_op_BREAK:
	   ;//{{---
		call.d		REG_bsearch				;//%r10    := addr = REG_bsearch(name, addr, n)
		ld.w		%r14, %r5				;//%r14    :=                                n						*delay*
		cmp		%r10, 0					;//if(!addr) {
		jreq		REG_op_RET				;//  return 0 }
	   ;//}}---
		ld.b		%r11, [%r10]+				;//%r11 :=            (int8_t)dataH
		ld.ub		%r12, [%r10]+				;//%r12 :=                              dataM
		ld.ub		%r13, [%r10]+				;//%r13 :=                                         dataL
		sla		%r11, 8					;//%r11 :=            (int8_t)dataH<<8
		or		%r11, %r12				;//%r11 :=           ((int8_t)dataH<<8)|dataM
		sla		%r11, 8					;//%r11 :=          (((int8_t)dataH<<8)|dataM)<<8
		or		%r11, %r13				;//%r11 := data  = ((((int8_t)dataH<<8)|dataM)<<8)|dataL
		add		%r10, %r11				;//%r10 := addr += data
		sll		%r11, 8					;//%r11 :=                  (data << 8)
REG_op_RET:								;//
		ret.d							;//%r11:%r10 := data:addr			(addr=0)̏ꍇ(data=sl)ł
		srl		%r11, 8					;//%r11 := data = (unsigned)(data << 8) >> 8	rRETjpꍇ̓_~[	*delay*
		;//-----------------------------------------------------;//
REG_bsearch:
		;//%r12 := addr
		;//%r13 := name
		;//%r14 := n
		ld.ub		%r4, %r13				;//%r4  := nameL  = (uint8_t)name
		sra		%r13, 8					;//%r13 := name >>= 8
		ld.ub		%r5, %r13				;//%r5  := nameH  = (uint8_t)name
		sra		%r13, 8					;//%r13 := name >>= 8
		jrne		REG_bsearch_RET0			;//if(!name) {
		jp.d		REG_bsearch_START			;//  goto L_START
		cmp		%r14, 0					;//  %psr(Z) := !n		*delay*
REG_bsearch_LOOP:							;//  do {										
		ld.w		%r6, %r14				;//    %r6  :=                n								
		sra		%r6, 1					;//    %r6  :=                n >> 1							
		add		%r10, %r6				;//    %r10 :=       addr + ((n >> 1) * 1)						
		sla		%r6, 2					;//    %r6  :=               (n >> 1) * 4						
		add		%r10, %r6				;//    %r10 := mid = addr + ((n >> 1) * 5) = addr + ((n >> 1) * (2/*name*/+3/*data*/))	
		ld.ub		%r6, [%r10]+				;//    %r6  :=        mid[0/*nameH*/]				, %r10 := mid + 1	
		sub		%r6, %r5				;//    %r6  := diff = mid[0/*nameH*/] - nameH							ł̓C^[bN܂B
		jrne		4					;//    if(!diff) {									
		 ld.ub		%r6, [%r10]				;//      %r6  :=        mid[1/*nameL*/]				
		 sub		%r6, %r4				;//      %r6  := diff = mid[1/*nameL*/] - nameL							!INTERLOCK!
		 jreq		REG_bsearch_RET				;//      if(!diff) { return &mid[2/*data*/] } }						
		jrge		4					;//    if(diff < 0) {									
		 ld.w		%r12, %r10				;//      %r12 :=        mid + 1					
		 add		%r12, 4					;//      %r12 := addr = mid + 5 = mid + (2/*name*/+3/*data*/)				
		 sub		%r14, 1					;//      %r14 := n-- }									
		sra		%r14, 1					;//    %r14 := n >>= 1									
REG_bsearch_START:							;//    											
		jrne.d		REG_bsearch_LOOP			;//  } while(n)		
		ld.w		%r10, %r12				;//    %r10 := addr										*delay*
REG_bsearch_RET0:							;//}									
		ld.w		%r10, -1				;//return  (-1+1)/*=NULL*/						
REG_bsearch_RET:							;//									
		ret.d							;//return  &mid[2/*data*/]						
		add		%r10, 1					;//%r10 := &mid[2/*data*/]				*delay*
");
#endif//PIECE
/*==========================================================================*
 *	[eBeB֐
 *==========================================================================*/
#ifndef PIECE
static int REG_open_get_v(const uint8_t* keyBody, const int* names, int (*fn)(const uint8_t*, int)) {
	int name = *names++;
	if(name != -1) {
		goto L_START;
		do {
			keyBody = REG_open_key(keyBody, name);	//(keyBody=NULL)w肳ꂽAREG_open_key()NULLԂ(keyBody=NULL)ɂȂĂApĈSłB
			name = *names++;
L_START:		;
		} while(*names != -1);
	}
	return (*fn)(keyBody, name);	//(keyBody=NULL)(name=-1)̏ꍇłȀsĈSłB
}
/*--------------------------------------------------------------------------*/
const uint8_t* REG_open_key_l(const uint8_t* keyBody, ...) {
	va_list ap;
	va_start(ap, keyBody);
	keyBody = REG_open_key_a(keyBody, ap);
	va_end(ap);
	return keyBody;
}
const uint8_t* REG_open_key_a(const uint8_t* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_open_key_v(keyBody, names);
}
const uint8_t* REG_open_key_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
    //{{Ꮘ
	//uREG_open_key_l(keyBody,-1)v̌`ŌĂяoꂽꍇ́AG[ƂNULLԂ̂ł͂ȂAkeyBodygԂRłB
	// - REG_open_get_v()ĂяoƁAREG_open_get_v()ăG[ƔfĂ܂B
	//   REG_open_get_v()ɓᏈǉAŔfK؂Ǝv̂ŁAɓᏈǉ鎖ɂ܂B
	// - clipfsm.cFsmObj_GetTransKey()A̓ɈˑĂ܂B
	if(names[0] == -1) { return keyBody; }
    //}}Ꮘ
	return (const uint8_t*)REG_open_get_v(keyBody, names, (int (*)(const uint8_t*, int))REG_open_key);
}
/*--------------------------------------------------------------------------*/
int REG_get_value_l(const uint8_t* keyBody, ...) {
	int valueData;
	va_list ap;
	va_start(ap, keyBody);
	valueData = REG_get_value_a(keyBody, ap);
	va_end(ap);
	return valueData;
}
int REG_get_value_a(const uint8_t* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_value_v(keyBody, names);
}
int REG_get_value_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]valueName,]-1*/) {
	return REG_open_get_v(keyBody, names, REG_get_value);
}
/*--------------------------------------------------------------------------*/
const char* REG_get_string_l(const uint8_t* keyBody, ...) {
	const char* stringData;
	va_list ap;
	va_start(ap, keyBody);
	stringData = REG_get_string_a(keyBody, ap);
	va_end(ap);
	return stringData;
}
const char* REG_get_string_a(const uint8_t* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_string_v(keyBody, names);
}
const char* REG_get_string_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]stringName,]-1*/) {
	return (const char*)REG_open_get_v(keyBody, names, (int (*)(const uint8_t*, int))REG_get_string);
}
/*--------------------------------------------------------------------------*/
const void* REG_get_blob_l(const uint8_t* keyBody, ...) {
	const void* blobData;
	va_list ap;
	va_start(ap, keyBody);
	blobData = REG_get_blob_a(keyBody, ap);
	va_end(ap);
	return blobData;
}
const void* REG_get_blob_a(const uint8_t* keyBody, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_blob_v(keyBody, names);
}
const void* REG_get_blob_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]blobName,]-1*/) {
	return (const void*)REG_open_get_v(keyBody, names, (int (*)(const uint8_t*, int))REG_get_blob);
}
#else //PIECE
const uint8_t* REG_open_key_l(const uint8_t* keyBody, ...);
const uint8_t* REG_open_key_a(const uint8_t* keyBody, va_list ap);
const uint8_t* REG_open_key_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
int REG_get_value_l(const uint8_t* keyBody, ...);
int REG_get_value_a(const uint8_t* keyBody, va_list ap);
int REG_get_value_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]valueName,]-1*/);
const char* REG_get_string_l(const uint8_t* keyBody, ...);
const char* REG_get_string_a(const uint8_t* keyBody, va_list ap);
const char* REG_get_string_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]stringName,]-1*/);
const void* REG_get_blob_l(const uint8_t* keyBody, ...);
const void* REG_get_blob_a(const uint8_t* keyBody, va_list ap);
const void* REG_get_blob_v(const uint8_t* keyBody, const int* names/*[[[[keyName,]keyName],c,]blobName,]-1*/);
asm("
		.code
		.align		1
		.global		REG_open_key_l
		.global		REG_open_key_a
		.global		REG_open_key_v
		.global		REG_get_value_l
		.global		REG_get_value_a
		.global		REG_get_value_v
		.global		REG_get_string_l
		.global		REG_get_string_a
		.global		REG_get_string_v
		.global		REG_get_blob_l
		.global		REG_get_blob_a
		.global		REG_get_blob_v
REG_open_key_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_open_key_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_open_key_v:
		;//%r12 := keyBody
		;//%r13 := names
	    ;//{{Ꮘ
		;//uREG_open_key_l(keyBody,-1)v̌`ŌĂяoꂽꍇ́AG[ƂNULLԂ̂ł͂ȂAkeyBodygԂRłB
		;// - REG_open_get_v()ĂяoƁAREG_open_get_v()ăG[ƔfĂ܂B
		;//   REG_open_get_v()ɓᏈǉAŔfK؂Ǝv̂ŁAɓᏈǉ鎖ɂ܂B
		;// - clipfsm.cFsmObj_GetTransKey()A̓ɈˑĂ܂B
		ld.w		%r9, [%r13]				;//%r9  := names[0]
		xld.w		%r14, REG_open_key			;//%r14 := fn = REG_open_key								*anti-interlock*
		cmp		%r9, -1					;//if(names[0] != -1) {
		jrne		REG_open_get_v				;//  goto REG_open_get_v }
		ret.d							;//return  keyBody
		ld.w		%r10, %r12				;//%r10 := keyBody									*delay*
	    ;//}}Ꮘ
		;//-----------------------------------------------------;//
REG_get_value_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_get_value_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_value_v:
		;//%r12 := keyBody
		;//%r13 := names
		xld.w		%r14, REG_get_value			;//%r14 := fn = REG_get_value
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_string_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_get_string_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_string_v:
		;//%r12 := keyBody
		;//%r13 := names
		xld.w		%r14, REG_get_string			;//%r14 := fn = REG_get_string
		jp		REG_open_get_v				;//
		;//-----------------------------------------------------;//
REG_get_blob_l:
		;//[%sp+0] := retp
		;//[%sp+4] := keyBody
		;//[%sp+8] := ...
		xld.w		%r12, [%sp+4]				;//%r12 := keyBody
		xadd		%r13, %sp, 8				;//%r13 := ap = &...
REG_get_blob_a:
		;//%r12 := keyBody
		;//%r13 := ap
REG_get_blob_v:
		;//%r12 := keyBody
		;//%r13 := names
		xld.w		%r14, REG_get_blob			;//%r14 := fn = REG_get_blob
		;//-----------------------------------------------------;//
REG_open_get_v:
		;//%r12 := keyBody
		;//%r13 := names
		;//%r14 := fn
		pushn		%r1					;//
		ld.w		%r0, %r13				;//%r0  :=         names
		ld.w		%r1, %r14				;//%r1  :=         fn
		ld.w		%r13, [%r0]+				;//%r13 := name = *names++
		cmp		%r13, -1				;//if(name != -1)
		jreq		REG_open_get_v_NAMES_EMPTY		;//  
		jp		REG_open_get_v_START			;//  goto L_START
REG_open_get_v_LOOP:							;//  do {
		xcall		REG_open_key				;//    %r10 := keyBody = REG_open_key(keyBody, name)
		ld.w		%r12, %r10				;//    %r12 := keyBody
		ld.w		%r13, [%r0]+				;//    %r13 := name = *names++
REG_open_get_v_START:							;//    
		ld.w		%r14, [%r0]				;//    %r14 := *names
		cmp		%r14, -1				;//    											!INTERLOCK!
		jrne		REG_open_get_v_LOOP			;//  } while(*names != -1)
REG_open_get_v_NAMES_EMPTY:						;//}
		ld.w		%r14, %r1				;//%r14 :=  fn
		popn		%r1					;//
		jp		%r14					;//return (*fn)(keyBody, name)
");
#endif//PIECE
/****************************************************************************
 *	CfNXANZX^,y,Ce[Vp̊֐
 ****************************************************************************/
/*==========================================================================*
 *	{IȊ֐
 *==========================================================================*/
#ifndef PIECE
static uint64_t REG_nth(const uint8_t* addr, int index, int* p_name/*NULL*/, int type) {
	int mask, n, data;
    //{{2015/10/29ǉ:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	//NULLAhXɑ΂ĂяoȂΗvf̂ƓƌȂċAB
	if(!addr) { return 0; }
    //}}2015/10/29ǉ:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	//̃L[{fBĂz^Cṽ}XN擾B
	// - bit31=L[,bit30=l,bit29=,bit28=BLOB,bit27`24=0(gp),bit27`0=0
	mask = *addr++ << 24;								//AZuł'rr 8'ƏoB
	for(;;) {
		//̃L[{fB̃^Cv̔zĂc
		if(mask < 0) {								//
			mask <<= 1;							//
			//z(vf-1)擾B					//@
			n   = *addr++;	//						//@
			n <<= 8;	//16rbg,rbOGfBA		//@
			n  |= *addr++;	//						//@
			//(vf-1)˗vfɕϊB				//@AZuł'add %r(mask),%r(mask); jrult 2; jreq RET'ƏoB	{{2015/10/05ǋL:ۂɂ͑̏Ƃ̌ˍōL̂Ƃ̃R[hɂ͂ȂȂBREG_op_LOOP̉̃R[hQƂB}}
			n++;								//@'(mask<0)'2ӏ'mask<<=1'̓AZuł1߂ɂ܂Ƃ߂B
		//̃L[{fB̃^Cv̔zĂȂ΁c			//@
		} else {								//@
			mask <<= 1;							//
			//̃L[{fBĂz^CvcĂȂ΋AB	//@
			// - AZuł͖߂lbit63`32͕slō\܂B	//@
			if(!mask) { return 0; }						//
			//z̗vf0ƂB
			n = 0;
		}
		//̔z񂪎w肳ꂽ^Cv̔zȂΔB
		if(--type < 0) { break; }
		//̔zXLbvB
		addr += n * (2/*name*/+3/*data*/);
	}
    {{//--- REG_op()REG_nth()Ƃŏ̈Ⴂ͈͂̔͂łB ---
	int name;
	//w肳ꂽCfNXz̗vfȏȂ΋AB
	// - AZuł͖߂lbit63`32͕slō\܂B
	if((unsigned)index >= (unsigned)n) { return 0; }
	//w肳ꂽCfNX̗vf̃AhX߂B
	addr  += index * (2/*keyName*/+3/*keyBodyDist*/);
	//vf̖O擾(,i[)B
	name   = *addr++;	//
	name <<= 8;		//16rbg,rbOGfBA
	name  |= *addr++;	//
	if(p_name) { *p_name = name; }
    }}//--- REG_op()REG_nth()Ƃŏ̈Ⴂ͈͂̔͂łB ---
	data   = (int8_t)*addr++;		//
	data <<= 8;				//
	data  |=         *addr++;		//t24rbg,rbOGfBA		t24rbgŃAhXɉZA24rbgɕϊB
	data <<= 8;				//
	data  |=         *addr++;		//
	addr  += data;				//AhX					REG_get_value()Ăяoꂽꍇ͎gpȂB
	data   = (unsigned)(data << 8) >> 8;	//f[^					24rbg
	//߂l bit63`32 = f[^(24rbg)	REG_get_value()Ăяoꂽꍇ͂gB
	//       bit31` 0 = AhX			REG_get_value()ȊOĂяoꂽꍇ͂gB
	return (((uint64_t)(unsigned)data) << 32) | ((uint64_t)(unsigned)addr);
	//                 ~~~~~~~~~~̃LXgsȂĂʂ͓ɂȂ̂AʂȕgsR[hȂ悤ɖIɕɃLXgB
}
/*--------------------------------------------------------------------------*/
const uint8_t* REG_open_nth_key(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/) {
	return (const uint8_t*)(int)REG_nth(keyBody, index, p_keyName, 0/*L[*/);	//REG_nth()̖߂lbit31`0̂܂ܕԂB
}
int REG_get_nth_value(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/) {
	uint64_t data_addr = REG_nth(keyBody, index, p_valueName, 1/*l*/);
	if(!(int)data_addr) { return -1; }						//REG_nth()̖߂lbit31`00Ȃ(-1)ԂB	//AZuł'sub %r10,1; jrult RET'ƏoB
	return (int)(data_addr >> 32);							//REG_nth()̖߂lbit55`32ԂB			//AZuł'ld.w %r10,%r11'ƏoB
}
const char* REG_get_nth_string(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/) {
	return (const char*)(int)REG_nth(keyBody, index, p_stringName, 2/**/);	//REG_nth()̖߂lbit31`0̂܂ܕԂB
}
const void* REG_get_nth_blob(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/) {
	return (const void*)(int)REG_nth(keyBody, index, p_blobName, 3/*BLOB*/);	//REG_nth()̖߂lbit31`0̂܂ܕԂB
}
#else //PIECE
const uint8_t* REG_open_nth_key(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/);
int REG_get_nth_value(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/);
const char* REG_get_nth_string(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/);
const void* REG_get_nth_blob(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/);
asm("
		.code
		.align		1
		.global		REG_open_nth_key
		.global		REG_get_nth_value
		.global		REG_get_nth_string
		.global		REG_get_nth_blob
REG_open_nth_key:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_keyName
		jp.d		REG_nth					;//%r10 := addr
		ld.w		%r15, 0					;//%r15 := type = 0/*L[*/								*delay*
REG_get_nth_value:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_valueName
		call.d		REG_nth					;//%r11:%r10 := data:addr
		ld.w		%r15, 1					;//%r15 := type = 1/*l*/								*delay*
		sub		%r10, 1					;//if(--addr == -1) { return -1 }
		jrult		2					;//else {
		 ld.w		%r10, %r11				;//  %r10 := data
		ret							;//  return  data }
REG_get_nth_string:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_stringName
		jp.d		REG_nth					;//%r10 := addr
		ld.w		%r15, 2					;//%r15 := type = 2/**/								*delay*
REG_get_nth_blob:
		;//%r12 := keyBody
		;//%r13 := index
		;//%r14 := p_blobName
		ld.w		%r15, 3					;//%r15 := type = 3/*BLOB*/
		;//-----------------------------------------------------;//
REG_nth:
		;//%r12 := addr
		;//%r13 := index
		;//%r14 := p_name
		;//%r15 := type
	    ;//{{2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
	    ;//	ld.w		%r10, 0					;//%r10 := 0
	    ;//2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		cmp		%r12, 0					;//if(!addr) { return 0 }
		jreq.d		REG_nth_RET				;//
		ld.w		%r10, 0					;//%r10 := 0										*delay*
	    ;//}}2015/10/29ύX:REG_op()REG_nth()addrNULLnꂽꍇ̔肪Ă̂C܂B
		ld.ub		%r4, [%r12]+				;//%r4  := mask = *addr++
		rr		%r4, 8					;//%r4[31:24] := mask
REG_nth_LOOP:								;//for(;;) {
		add		%r4, %r4				;//  %psr(C) := mask[31], %r4  := mask <<= 1
		jruge		7					;//  if(%psr(C)) {
		 ld.ub		%r5, [%r12]+				;//    %r5  :=      nH
		 ld.ub		%r6, [%r12]+				;//    %r6  :=             nL
		 sla		%r5, 8					;//    %r5  :=      nH<<8
		 or		%r5, %r6				;//    %r5  := n = (nH<<8)|nL
		 jp.d		4					;//    %r5  := n++
		 add		%r5, 1					;//  } else {										*delay*
		  jreq		REG_nth_RET				;//    if(!mask) { return 0 }
		  ld.w		%r5, 0					;//    %r5  := n = 0 }
		sub		%r15, 1					;//  %r15 := type--
		jrult		REG_nth_BREAK				;//  if(type == -1) { break }
		add		%r12, %r5				;//  %r12 := addr + n * 1
		sla		%r5, 2					;//  %r5  :=        n * 4
		jp.d		REG_nth_LOOP				;//}
		add		%r12, %r5				;//  %r12 := addr + n * 5 = addr + n * (2/*name*/+3/*data*/)				*delay*
REG_nth_BREAK:
	   ;//{{---
		cmp		%r13, %r5				;//if((unsigned)index >= (unsigned)n) {
		jruge		REG_nth_RET				;//  return 0 }
		ld.w		%r10, %r12				;//%r10 := addr
		add		%r10, %r13				;//%r10 := addr + index * 1
		sla		%r13, 2					;//%r13 :=        index * 4
		add		%r10, %r13				;//%r10 := addr + index * 5 = addr + index * (2/*name*/+3/*data*/)
		ld.ub		%r4, [%r10]+				;//%r4  :=           nameH
		ld.ub		%r5, [%r10]+				;//%r5  :=                     nameL
		cmp		%r14, 0					;//if(p_name) {
		jreq		4					;//  
		 sla		%r4, 8					;//  %r4  :=         nameH<<8
		 or		%r4, %r5				;//  %r4  := name = (nameH<<8)|nameL
		 ld.w		[%r14], %r4				;//  *p_name = name }
	   ;//}}---
		ld.b		%r11, [%r10]+				;//%r11 :=            (int8_t)dataH
		ld.ub		%r12, [%r10]+				;//%r12 :=                              dataM
		ld.ub		%r13, [%r10]+				;//%r13 :=                                         dataL
		sla		%r11, 8					;//%r11 :=            (int8_t)dataH<<8
		or		%r11, %r12				;//%r11 :=           ((int8_t)dataH<<8)|dataM
		sla		%r11, 8					;//%r11 :=          (((int8_t)dataH<<8)|dataM)<<8
		or		%r11, %r13				;//%r11 := data  = ((((int8_t)dataH<<8)|dataM)<<8)|dataL
		add		%r10, %r11				;//%r10 := addr += data
		sll		%r11, 8					;//%r11 :=                  (data << 8)
REG_nth_RET:								;//
		ret.d							;//%r11:%r10 := data:addr			(addr=0)̏ꍇ(data=sl)ł
		srl		%r11, 8					;//%r11 := data = (unsigned)(data << 8) >> 8	rRETjpꍇ̓_~[	*delay*
");
#endif//PIECE
/*==========================================================================*
 *	[eBeB֐
 *==========================================================================*/
#ifndef PIECE
const uint8_t* REG_open_nth_key_l(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, ...) {
	va_list ap;
	va_start(ap, p_keyName);
	keyBody = REG_open_nth_key_a(keyBody, index, p_keyName, ap);
	va_end(ap);
	return keyBody;
}
const uint8_t* REG_open_nth_key_a(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_open_nth_key_v(keyBody, index, p_keyName, names);
}
const uint8_t* REG_open_nth_key_v(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
	return REG_open_nth_key(REG_open_key_v(keyBody, names), index, p_keyName);
}
/*--------------------------------------------------------------------------*/
int REG_get_nth_value_l(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, ...) {
	int valueData;
	va_list ap;
	va_start(ap, p_valueName);
	valueData = REG_get_nth_value_a(keyBody, index, p_valueName, ap);
	va_end(ap);
	return valueData;
}
int REG_get_nth_value_a(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_nth_value_v(keyBody, index, p_valueName, names);
}
int REG_get_nth_value_v(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
	return REG_get_nth_value(REG_open_key_v(keyBody, names), index, p_valueName);
}
/*--------------------------------------------------------------------------*/
const char* REG_get_nth_string_l(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, ...) {
	const char* stringData;
	va_list ap;
	va_start(ap, p_stringName);
	stringData = REG_get_nth_string_a(keyBody, index, p_stringName, ap);
	va_end(ap);
	return stringData;
}
const char* REG_get_nth_string_a(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_nth_string_v(keyBody, index, p_stringName, names);
}
const char* REG_get_nth_string_v(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
	return REG_get_nth_string(REG_open_key_v(keyBody, names), index, p_stringName);
}
/*--------------------------------------------------------------------------*/
const void* REG_get_nth_blob_l(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, ...) {
	const void* blobData;
	va_list ap;
	va_start(ap, p_blobName);
	blobData = REG_get_nth_blob_a(keyBody, index, p_blobName, ap);
	va_end(ap);
	return blobData;
}
const void* REG_get_nth_blob_a(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, va_list ap) {
	int names[(7+1)/**/], i = 0;	//pAL[ƒl̊Kw7ȉ(I[(-1)܂߂8ȉ)ƍlď[낤Bsꍇ͑₹B
	for(;;) {
		if((names[i] = va_arg(ap, int)) == -1) { break; }
		if(++i >= ARRAY_SIZE(names)) { DIE(); }	//Œ~ꍇ́Anames[]s,,ďoI[YĂB炭҂낤B
	}
	return REG_get_nth_blob_v(keyBody, index, p_blobName, names);
}
const void* REG_get_nth_blob_v(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/) {
	return REG_get_nth_blob(REG_open_key_v(keyBody, names), index, p_blobName);
}
#else //PIECE
const uint8_t* REG_open_nth_key_l(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, ...);
const uint8_t* REG_open_nth_key_a(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, va_list ap);
const uint8_t* REG_open_nth_key_v(const uint8_t* keyBody, int index, int* p_keyName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
int REG_get_nth_value_l(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, ...);
int REG_get_nth_value_a(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, va_list ap);
int REG_get_nth_value_v(const uint8_t* keyBody, int index, int* p_valueName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
const char* REG_get_nth_string_l(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, ...);
const char* REG_get_nth_string_a(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, va_list ap);
const char* REG_get_nth_string_v(const uint8_t* keyBody, int index, int* p_stringName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
const void* REG_get_nth_blob_l(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, ...);
const void* REG_get_nth_blob_a(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, va_list ap);
const void* REG_get_nth_blob_v(const uint8_t* keyBody, int index, int* p_blobName/*NULL*/, const int* names/*[[[[keyName,]keyName],c,]keyName,]-1*/);
asm("
		.code
		.align		1
		.global		REG_open_nth_key_l
		.global		REG_open_nth_key_a
		.global		REG_open_nth_key_v
		.global		REG_get_nth_value_l
		.global		REG_get_nth_value_a
		.global		REG_get_nth_value_v
		.global		REG_get_nth_string_l
		.global		REG_get_nth_string_a
		.global		REG_get_nth_string_v
		.global		REG_get_nth_blob_l
		.global		REG_get_nth_blob_a
		.global		REG_get_nth_blob_v
REG_open_nth_key_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_keyName
		;//[%sp+8] := ...
		xld.w		%r14, [%sp+4]				;//%r14 := p_keyName
		xadd		%r15, %sp, 8				;//%r15 := ap = &...
REG_open_nth_key_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_keyName
		;//%r15    := ap
REG_open_nth_key_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_keyName
		;//%r15    := names
		xld.w		%r10, REG_open_nth_key			;//%r10 := fn = REG_open_nth_key
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_value_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_valueName
		;//[%sp+8] := ...
		xld.w		%r14, [%sp+4]				;//%r14 := p_valueName
		xadd		%r15, %sp, 8				;//%r15 := ap = &...
REG_get_nth_value_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_valueName
		;//%r15    := ap
REG_get_nth_value_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_valueName
		;//%r15    := names
		xld.w		%r10, REG_get_nth_value			;//%r10 := fn = REG_get_nth_value
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_string_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_stringName
		;//[%sp+8] := ...
		xld.w		%r14, [%sp+4]				;//%r14 := p_stringName
		xadd		%r15, %sp, 8				;//%r15 := ap = &...
REG_get_nth_string_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_stringName
		;//%r15    := ap
REG_get_nth_string_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_stringName
		;//%r15    := names
		xld.w		%r10, REG_get_nth_string		;//%r10 := fn = REG_get_nth_string
		jp		REG_open_get_nth_v
		;//-----------------------------------------------------;//
REG_get_nth_blob_l:
		;//%r12    := keyBody
		;//%r13    := index
		;//[%sp+0] := retp
		;//[%sp+4] := p_blobName
		;//[%sp+8] := ...
		xld.w		%r14, [%sp+4]				;//%r14 := p_blobName
		xadd		%r15, %sp, 8				;//%r15 := ap = &...
REG_get_nth_blob_a:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_blobName
		;//%r15    := ap
REG_get_nth_blob_v:
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_blobName
		;//%r15    := names
		xld.w		%r10, REG_get_nth_blob			;//%r10 := fn = REG_get_nth_blob
		;//-----------------------------------------------------;//
REG_open_get_nth_v:
		;//%r10    := fn
		;//%r12    := keyBody
		;//%r13    := index
		;//%r14    := p_name
		;//%r15    := names
		xsub		%sp, %sp, 12
		xld.w		[%sp+0], %r13				;//[%sp+0] := index
		xld.w		[%sp+4], %r14				;//[%sp+4] := p_name
		xld.w		[%sp+8], %r10				;//[%sp+8] := fn
		xcall.d		REG_open_key_v				;//%r10 := keyBody = REG_open_key_v(keyBody, names)
		ld.w		%r13, %r15				;//%r13 :=                                   names					*delay*
		xld.w		%r13, [%sp+0]				;//%r13 :=                 index
		xld.w		%r14, [%sp+4]				;//%r14 :=                        p_name
		xadd		%sp, %sp, 8				;//[%sp+0] := fn
		ret.d							;//return   (*fn)(keyBody, index, p_name)
		ld.w		%r12, %r10				;//%r12 :=        keyBody								*delay*
");
#endif//PIECE
/****************************************************************************
 *	BLOB̃f[^\ɂ
 ****************************************************************************/
#ifndef PIECE
int REG_get_blob_size(const void* _blob/*NULL*/) {
	const uint8_t* blob = _blob;
	int size;
	if(!blob) { return 0; }	//NULL|C^nꂽꍇ(size=0)Ԃ܂BREG_get_blob()̌ʂNULLǂmFREG_get_blob_size()ɓnĂSłB
	blob  -= 3;
	size   = *blob++;	//
	size <<= 8;		//
	size  |= *blob++;	//24rbgBE
	size <<= 8;		//
	size  |= *blob++;	//
	size++;			//(oCg-1)˃oCgɕϊB
	return size;
}
#else //PIECE
int REG_get_blob_size(const void* _blob/*NULL*/);
asm("
		.code
		.align		1
		.global		REG_get_blob_size
REG_get_blob_size:
		;//%r12 := blob
		cmp		%r12, 0					;//if(!blob) { goto RET }
		jreq		REG_get_blob_size_RET			;//
		sub		%r12, 4					;//%r12        := blob -= 4											
		ld.w		%r12, [%r12]				;//%r12[31:24] := sizeL,    %r12[23:16] := sizeM, %r12[15:8] := sizeH, %r12[7:0] := (sl)			WXgBLOBf[^{̂[hACgĂ鎖𗘗pčœK܂B
		swap		%r12, %r12				;//%r12[31:24] := (sl), %r12[23:16] := sizeH, %r12[15:8] := sizeM, %r12[7:0] := sizeL	!INTERLOCK!	nꂽblob|C^͂S̔{ł͂Ȃ̂ŁA(blob-4)̈ʒu烏[hǂݏoĂSłB
		sll		%r12, 8					;//%r12[31:24] := sizeH,    %r12[23:16] := sizeM, %r12[15:8] := sizeL, %r12[7:0] := 0				(blob-4)Ɋi[Ăl͕slłA(blob-4)WXgłANZX\ł鎖͕ۏ؏o܂B
		srl		%r12, 8					;//%r12[31:24] := 0,        %r12[23:16] := sizeH, %r12[15:8] := sizeM, %r12[7:0] := sizeL			
		add		%r12, 1					;//%r12        := size++	(oCg-1)˃oCgɕϊB
REG_get_blob_size_RET:							;//
		ret.d							;//return         size,,0
		ld.w		%r10, %r12				;//%r10        := size,,0									*delay*
");
#endif//PIECE
