/*	
 *	clippnm.h
 *
 *	Netpbm format
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sat Apr 09 21:06:53 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- 摜APBMeLXg`(P1),,PGMeLXg`(P2),,PPMeLXg`(P3)ŕۑ܂B
 *	  ڃt@Cɕۑ֐(`_save())ƁAXg[ɏo͂֐(`_dump()pӂ܂B
 *	- W[쐬ȖړÍAP/ECẺʂȒPɕۑ邽߂łB
 *	  BMP`TGA`ŕۑAPNM`ŕۑȒPŃR[hʂȂôŁAPNM`I܂B
 *	  z肷ǵAP/ECẼtbVɃt@CƂĕۑ邩ÁAWG[o͂USBoRŏo͂܂B
 *	  ̌AImageMagickgāAPNM`ėpIȌ`(BMP`PNG`)֕ϊĉB
 *	- P/ECẺ摜`ɓKĂ̂PGM`łAۂɂ͂قƂpgm_save(),,pgm_dump()gȂƎv܂B
 *	  APBM`PPM`قƂǓőΉôŁAPBM`PPM`ΉĂɂ܂B
 *	- PNM`ŕۑ鎖ړIłAǂݍގ͖ړIł͂Ȃ̂ŁAPNM`̓ǂݍ݊֐͍쐬Ă܂B
 *	- QƎuWikipedia - Netpbm formatv(http://en.wikipedia.org/wiki/Netpbm_format)
 *	  A Netpbm format is any graphics format used and defined by the Netpbm project.
 *	  The portable pixmap format (PPM), the portable graymap format (PGM) and the portable bitmap format (PBM) are image file formats designed to be easily exchanged between platforms.
 *	  They are also sometimes referred to collectively as the portable anymap format (PNM), not to be confused with the related portable arbitrary map format.
 */
#ifndef __CLIP_PNM_H__
#define __CLIP_PNM_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	Portable bitmap format (PBM)
 *****************************************************************************/
void pbm_save(const char* path/*gqȗ*/, int w, int h, int (*fnPoint)(int x, int y, void* arg), void* arg);
void pbm_dump(FILE* fp, int w, int h, int (*fnPoint)(int x, int y, void* arg), void* arg);
/*****************************************************************************
 *	Portable graymap format (PGM)
 *****************************************************************************/
void pgm_save(const char* path/*gqȗ*/, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg);
void pgm_dump(FILE* fp, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg);
/*****************************************************************************
 *	Portable pixmap format (PPM)
 *****************************************************************************/
void ppm_save(const char* path/*gqȗ*/, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg);
void ppm_dump(FILE* fp, int w, int h, int maxVal, int (*fnPoint)(int x, int y, void* arg), void* arg);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_PNM_H__
