/*	
 *	clipmemc.c
 *
 *	RpNV@\tubNǗ
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Sat Dec 26 13:49:23 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	- W[̖ړÍAȉ̒ʂłB
 *	  1. WCu̓I֐(malloc(),free())gȂAK͂ȑgݍ݊ɁAPȓI֐񋟂鎖B
 *	  2. RpNV@\񋟂鎖BeʂȂł́AtOe[VŘÄ悪mۏoȂȂՂłB
 *	- W[̎Ȑ́Aȉ̒ʂłB
 *	  1. Ɋ蓖ĂubN̏́A65535łB
 *	  2. Ɋ肠ĂubN̍vTCY̏́A(4*65535)=256LoCgłB
 *	  K͂ȑgݍ݊Ŏgɂ́A[Ǝv܂B
 *	- RpNV̒ӓ_ɂĐ܂B
 *	  W[́AMemCpt_Free()ĂяoꂽɁAIɃRpNVs܂B
 *	  鎖ɂāAobt@̈̓rɋ󂫗̈悪AtOe[V܂B
 *	  RpNVs(=MemCpt_Free()Ăяo)AubÑAhXړ\L܂B
 *	  AvP[V́AMemCpt_Free()̌Ăяo܂ŁAubÑAhXێĂ͂܂B
 *	  ۂɂ́AMemCpt_Free()̌Ăяo̗LɊ֌WȂAɁAubN̗̈ɃANZX钼OɁAAMemCpt_Ptr()Ăяoă|C^擾̂]܂łB
 *	- RpNV́ARXg̍łAƂ͂Aɒ[ɒxł͂܂B
 *	  ubNŜ񑖍鎖ƁÄړ邾łB
 *	  AvP[VAMemCpt_Free()̌Ăяo鎖ɐ_oɂȂKv͗L܂B
 */
#include "clip.h"
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
//Ǘ\̂𓮓Iɍ쐬B
//[in]
//	nBlock		ubNz̗vf
//			蓖ĉ\ȃubN̍őlłB
//			ႦnBlock=10w肵ꍇAƂobt@̋󂫗̈悪cĂĂA10ȏ̃ubN蓖Ă鎖͏o܂B
//	nBytes		obt@̃oCg	4̔{Ŏw肵ĉB
//			蓖ĉ\ȃubNTCY̍v̍őoCgłB
//			ႦnBytes=100w肵ꍇAƂ󂫃ubNcĂĂAv100oCgȏ̃ubN蓖Ă鎖͏o܂B
//[out]
//	߂l		Ǘ\
//[note]
//	- ֐ō쐬Ǘ\̂AJ邽߂̊֐͗pӂĂ܂B
//	  free()ŊJĉB
ST_MemCpt* MemCpt_New(int nBlock, int nBytes/*4N*/) {	//Jfree()gĉB
	ST_MemCpt* pMemCpt;
	int nWords;
	if(nBytes & 3) { DIE(); }
	nWords = nBytes >> 2;
	if((unsigned)nBlock > UINT16_MAX) { DIE(); }
	if((unsigned)nWords > UINT16_MAX) { DIE(); }
	pMemCpt = malloc(sizeof(ST_MemCpt)
	               + sizeof(ST_MemCptBk) * nBlock
	               + sizeof(uint32_t)    * nWords);
	if(!pMemCpt) { DIE(); }
	MemCpt_Init(pMemCpt, nBlock, nBytes);
	return pMemCpt;
}
/*--------------------------------------------------------------------------*/
//ÓIɊmۂǗ\̂̃AB
//[in]
//	pMemCpt		ÓIɊmۂǗ\̂̃
//	nBlock		ubNz̗vf
//	nBytes		obt@̃oCg	4̔{Ŏw肵ĉB
//[note]
//	- nBlock,nBytes̎w@́AMemCpt_New()̐QƂĉB
void MemCpt_Init(ST_MemCpt* pMemCpt, int nBlock, int nBytes/*4N*/) {
	int nWords;
	if(nBytes & 3) { DIE(); }
	nWords = nBytes >> 2;
	if((unsigned)nBlock > UINT16_MAX) { DIE(); }
	if((unsigned)nWords > UINT16_MAX) { DIE(); }
	memset(pMemCpt, 0, sizeof(ST_MemCpt)
	                 + sizeof(ST_MemCptBk) * nBlock
	                 + sizeof(uint32_t)    * nWords);
	pMemCpt->nBlock = nBlock;
	pMemCpt->nWords = nWords;
}
/*--------------------------------------------------------------------------*/
//ubN蓖ĂB
//[in]
//	pMemCpt		Ǘ\
//	iAllocBytes	蓖ĂoCg
//			ۂɂ́A[hPʂɐ؂グĊ蓖Ă܂B
//[out]
//	߂l		蓖ĐȂ΁A蓖ĂubNԍ(1`nBlock)ԂB
//			蓖Ďs,,蓖ĂTCY0AubNԍ0ԂB
int MemCpt_Alloc(ST_MemCpt* pMemCpt, int iAllocBytes) {
	int iBlock = 0;
	//蓖ĂTCYoCgPʁ˃[hPʂɕϊB
	int iAllocWords = (iAllocBytes + 3) >> 2;
	//蓖ĂTCY0łȂ΁c
	if(iAllocWords) {
		ST_MemCptBk* const TBL_Block = (ST_MemCptBk*)(pMemCpt + 1);		//&pMemCpt->TBL_Block[0]
	//sv	uint32_t*    const TBL_Words = (uint32_t*)&TBL_Block[pMemCpt->nBlock];	//&pMemCpt->TBL_Words[0]
		//󂫗̈̃TCYA蓖ĂTCYȏȂ΁c
		if((pMemCpt->nWords - pMemCpt->iFree) >= iAllocWords) {
			//󂫃ubNB
			int i;
			for(i = 0; i < pMemCpt->nBlock; i++) {
				//󂫃ubN𔭌c
				if(!TBL_Block[i].iSize) {
					//蓖ĂubN̐擪AhXƃ[hi[B
					TBL_Block[i].iAddr = pMemCpt->iFree;
					TBL_Block[i].iSize = iAllocWords;
					//󂫗̈̐擪AhXi߂B
					pMemCpt->iFree += iAllocWords;
					//蓖ĐȂ΁A蓖ĂubNԍ(1`nBlock)ԂB
					iBlock = i + 1;
					break;	//܂
				}
			}
		}
	}
	//蓖ĐȂ΁A蓖ĂubNԍ(1`nBlock)ԂB
	//蓖Ďs,,蓖ĂTCY0AubNԍ0ԂB
	return iBlock;
}
/*--------------------------------------------------------------------------*/
//ubNJB
//[in]
//	pMemCpt		Ǘ\
//	iBlock		JubNԍ(1`nBlock),,0
//			iBlock=0w肵ꍇA֐͉܂B
//[note]
//	- MemCpt_Free()ĂяoARpNV̉eŁÃubÑAhXړ\L܂B
//	  ]āAMemCpt_Free()̌Ăяo܂ŁÃubÑ|C^ێĂ͂܂B
//	  MemCpt_Free()Ăяoɑ̃ubÑ|C^gpꍇ́AēxAMemCpt_Ptr()Ăяoă|C^擾ĉB
//	  ۂɂ́AMemCpt_Ptr()ĂяoǂɊ֌WɁAubN̗̈ɃANZX钼OɁAMemCpt_Ptr()Ăяoă|C^擾̂]܂łB
void MemCpt_Free(ST_MemCpt* pMemCpt, int iBlock/*0,1`nBlock*/) {
	//ubNԍ0ɑ΂J́AȂB
	if(iBlock) {
		ST_MemCptBk* const TBL_Block = (ST_MemCptBk*)(pMemCpt + 1);		//&pMemCpt->TBL_Block[0]
		uint32_t*    const TBL_Words = (uint32_t*)&TBL_Block[pMemCpt->nBlock];	//&pMemCpt->TBL_Words[0]
		int i, iFreeAddr, iFreeSize;
		if((unsigned)iBlock > (unsigned)pMemCpt->nBlock) { DIE(); }	//ubNԍs
		i = iBlock - 1;	//0`(nBlock-1)
		//JubN̐擪AhXƃ[h擾B
		iFreeAddr = TBL_Block[i].iAddr;
		iFreeSize = TBL_Block[i].iSize;
		if(!iFreeSize) { DIE(); }	//󂫃ubNJ悤ƂB
		//ubNJB
		TBL_Block[i].iAddr = 0;		//
		TBL_Block[i].iSize = 0;									//
		//󂫗̈̐擪AhXAOւ炷B						//
		pMemCpt->iFree -= iFreeSize;								//󂫃ubN(iAddr=0)ƂĂŁA'JubNɗL銄蓖čς݃ubN'𔻒肷鏈oB
		//JubNɗL銄蓖čς݃ubŃA擪AhXOւ炷B	//
		for(i = 0; i < pMemCpt->nBlock; i++) {							//
			if(/*TBL_Block[i].iSize &&*/ (TBL_Block[i].iAddr > iFreeAddr)) {	//
				TBL_Block[i].iAddr -= iFreeSize;
			}
		}
		//JubNɗLA蓖čςݗ̈AOւ炷B
		memmove(&TBL_Words[iFreeAddr],
		        &TBL_Words[iFreeAddr + iFreeSize],
		        sizeof(uint32_t) * (pMemCpt->iFree - iFreeAddr));
	}
}
/*--------------------------------------------------------------------------*/
//ubN̗̈ւ̃|C^擾B
//[in]
//	pMemCpt		Ǘ\
//	iBlock		ubNԍ(1`nBlock),,0
//[out]
//	߂l		iBlock=ubNԍ(1`nBlock)w肵ꍇAubN̗̈ւ̃|C^ԂB	ubN̗̈ւ̃|C^́A[hACgĂ܂B
//			iBlock=0w肵ꍇANULL|C^ԂB
void* MemCpt_Ptr(ST_MemCpt* pMemCpt, int iBlock/*0,1`nBlock*/) {
	uint32_t* pWord = NULL;
	//ubNԍ0ɑ΂ẮANULL|C^ԂB
	if(iBlock) {
		ST_MemCptBk* const TBL_Block = (ST_MemCptBk*)(pMemCpt + 1);		//&pMemCpt->TBL_Block[0]
		uint32_t*    const TBL_Words = (uint32_t*)&TBL_Block[pMemCpt->nBlock];	//&pMemCpt->TBL_Words[0]
		int i;
		if((unsigned)iBlock > (unsigned)pMemCpt->nBlock) { DIE(); }	//ubNԍs
		i = iBlock - 1;	//0`(nBlock-1)
		if(!TBL_Block[i].iSize) { DIE(); }	//󂫃ubÑ|C^擾悤ƂB
		//w肳ꂽubN̗̈ւ̃|C^ԂB
		pWord = &TBL_Words[TBL_Block[i].iAddr];
	}
	return pWord;
}
/*--------------------------------------------------------------------------*/
#ifdef  USE_MEMCPT_DUMP
//RpNV@\tubNǗ̊蓖ďԂeLXg_vB
//[in]
//	fp		o͐Xg[
//	pMemCpt		Ǘ\
void MemCpt_Dump(FILE* fp, ST_MemCpt* pMemCpt) {
	ST_MemCptBk* const TBL_Block = (ST_MemCptBk*)(pMemCpt + 1);		//&pMemCpt->TBL_Block[0]
//sv	uint32_t*    const TBL_Words = (uint32_t*)&TBL_Block[pMemCpt->nBlock];	//&pMemCpt->TBL_Words[0]
	int i, j;
	fprintf(fp, "Block\tAddr\tWords\tData\n");
	for(i = 0; i < pMemCpt->nBlock; i++) {
		int iAddr = TBL_Block[i].iAddr;
		int iSize = TBL_Block[i].iSize;
		if(iSize) {	//蓖čς݃ubN\B
			uint8_t* p = MemCpt_Ptr(pMemCpt, i + 1);
			fprintf(fp, "%d\t%d\t%d\t", i + 1, iAddr, iSize);
			for(j = 0; (unsigned)j < (unsigned)(sizeof(uint32_t) * iSize); j++) {
				if(j) {
					fprintf(fp, " ");
					if(j >= 16) {	//̈̓e͍ő16oCg܂ŕ\Aȏ͏ȗ鎖ɂB
						fprintf(fp, "...");
						break;	//܂
					}
				}
				fprintf(fp, "%02X", *p++);
			}
			fprintf(fp, "\n");
		}
	}
}
#endif//USE_MEMCPT_DUMP
/****************************************************************************
 *	gp
 ****************************************************************************/
#if 0
//ÓIɊmۂǗ\̂gp
MemCpt_Def(mcSmpl1,16,1024);
void sample1() {
	int blk1,blk2,blk3;
	MemCpt_Init(mcSmpl1,16,1024);
	blk1 = MemCpt_Alloc(mcSmpl1,3+1);
	if(blk1) { strcpy(MemCpt_Ptr(mcSmpl1,blk1),""); }
	blk2 = MemCpt_Alloc(mcSmpl1,4+1);
	if(blk2) { strcpy(MemCpt_Ptr(mcSmpl1,blk2),""); }
	MemCpt_Free(mcSmpl1,blk1);
	blk3 = MemCpt_Alloc(mcSmpl1,4+1);
	if(blk3) { strcpy(MemCpt_Ptr(mcSmpl1,blk3),"߽"); }
	MemCpt_Dump(stdout,mcSmpl1);
}
//Iɍ쐬Ǘ\̂gp
ST_MemCpt* mcSmpl2;
void sample2() {
	int blk1,blk2,blk3;
	mcSmpl2 = MemCpt_New(16,1024);
	blk1 = MemCpt_Alloc(mcSmpl2,3+1);
	if(blk1) { strcpy(MemCpt_Ptr(mcSmpl2,blk1),""); }
	blk2 = MemCpt_Alloc(mcSmpl2,4+1);
	if(blk2) { strcpy(MemCpt_Ptr(mcSmpl2,blk2),""); }
	MemCpt_Free(mcSmpl2,blk1);
	blk3 = MemCpt_Alloc(mcSmpl2,4+1);
	if(blk3) { strcpy(MemCpt_Ptr(mcSmpl2,blk3),"߽"); }
	MemCpt_Dump(stdout,mcSmpl2);
	free(mcSmpl2);
}
#endif
