/*	
 *	cliplibc.c
 *
 *	WbCu̕⏕
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Wed Jan 07 21:18:08 JST 2015 Naoyuki Sawa
 *	- VK쐬B
 *	- errnoAclippce.ccliplibc.cֈړ܂B
 *	- uʃx֐/_~[֐ : WbCuv̎Aclippce.ccliplibc.cֈړ܂B
 *	- uEPSONCu̒uv̎Aclippce.ccliplibc.cֈړ܂B
 *	- uWbCu̕⏕v̎Aclippce.ccliplibc.cֈړ܂B̓Iɂ́Aclippce.h2015/01/07̉LRgɑ܂:
 *	   - strdup(),strcasecmp(),strncasecmp()̐錾clippce.hinclude/string.hցCclippce.ccliplibc.cֈړ܂B
 *	     strcasecmp(),strncasecmp()͖{strings.hŐ錾ׂȂ̂łAP/ECEɂstrings.ĥinclude/string.hŐ錾邱Ƃɂ܂B
 *	   - strnlen(),strndup()̐錾clippce.hinclude/string.hցCclippce.ccliplibc.cֈړ܂B
 *	   - ismbblead(),ismbbtrail(),iscsym(),iscsymf(),isblank()̐錾clippce.hinclude/ctype.hցCclippce.ccliplibc.cֈړ܂B
 *	     ismbblead(),ismbbtrail()͖{mbctype.hŐ錾ׂȂ̂łAP/ECEɂmbctype.ĥinclude/ctype.hŐ錾邱Ƃɂ܂B
 *	   - strupr(),strlwr()̐錾clippce.hinclude/string.hցCclippce.ccliplibc.cֈړ܂B
 *	   - splitpath(),makepath()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂B
 *	   - ffs()̐錾clippce.hinclude/string.hցCclippce.ccliplibc.cֈړ܂B
 *	     ffs()͖{strings.hŐ錾ׂȂ̂łAP/ECEɂstrings.ĥinclude/string.hŐ錾邱Ƃɂ܂B
 *	   - fileno(),isatty()̐錾Aclippce.hinclude/stdio.hֈړ܂Bclipio.cɂ܂B
 *	     isatty()͖{io.hunistd.hŐ錾ׂȂ̂łAP/ECEɂio.hunistd.ĥinclude/stdio.hŐ錾邱Ƃɂ܂B
 *	* Wed Jan 07 21:29:51 JST 2015 Naoyuki Sawa
 *	- Visual C++ 6.0Ńrh鎞ɃG[ɂȂӏARpCfBNeBuŏO悤ɂ܂B
 *	  ̕ύX́AP/ECEJŃrhꍇɂ́AeL܂B
 *	* Wed Mar 18 22:26:03 JST 2015 Naoyuki Sawa
 *	- _~[read()̎폜܂B
 *	  _~[read()EPSONCusscanf()̂߂ɒ`ĂŁAԂOsscanf()Ǝ_ŕsvɂȂĂɂ܂ŋCtʂɃR[heʂĂ܂B
 *	  _~[read()폜ɂAR[heʂ12oCgȂȂ܂B
 *	* Tue Mar 24 21:38:35 JST 2015 Naoyuki Sawa
 *	- EPSONCubsearch()u܂B
 *	  EPSONCubsearch()̂܂܂ł薳̂łACŎĂĐR[hɏʂL܂B
 *	  AZu鎖ɂāA68oCg60oCgɂȂA8oCg̃TCYߖɂȂ܂B
 *	  AZuɂ鍂̌ʂ́Ar֐̏Ԃ܂߂Ȃ΁A15%̍łB
 *	* Wed Apr 29 14:30:43 JST 2015 Naoyuki Sawa
 *	- memccpy(),mempcpy(),strncpy(),stpncpy(),strcpy(),stpcpy()ǉ܂B
 *	  錾́Ainclude/string.hɒǉ܂B
 *	- strncpy()strcpy()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *	  stpncpy()stpcpy()Ƌʉł镔A܂Ƃ߂ĎR[hTCYߖł邩łB
 *	* Sun May 31 13:54:55 JST 2015 Naoyuki Sawa
 *	- strcpy()strcat()Visual C++ 6.0ReleaserhƁuerror C2169: gݍ݊֐͒`ł܂BvɂȂ̂ŏO܂B
 *	* Sat Jul 25 17:20:54 JST 2015 Naoyuki Sawa
 *	- log2()ǉ܂B錾́Ainclude/math.h ɗL܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B
 *	  EPSONCuɂAVisual C++ 6.0ɂAlog2()͊܂܂Ă܂B
 *	* Sat Oct 10 21:38:51 JST 2015 Naoyuki Sawa
 *	- cliplibc.c̒setjmp(),longjmp()āAEPSONCu̓̊֐u܂B
 *	* Wed Oct 14 21:50:46 JST 2015 Naoyuki Sawa
 *	- dirname(),basename()ǉ܂B錾́Ainclude/libgen.h ɗL܂B
 *	* Tue Oct 20 21:18:14 JST 2015 Naoyuki Sawa
 *	- a64l(),l64a(),l64a_r()ǉ܂B錾́Ainclude/stdlib.h ɗL܂B
 *	* Sat Oct 24 14:03:11 JST 2015 Naoyuki Sawa
 *	- program_invocation_name,program_invocation_short_name̕ϐ`ǉ܂Bϐ錾cliplibc.cɗL܂B
 *	  ڍׂ́A/clip/include/errno.h ̓̃RgQƂĉB
 *	* Mon Nov 02 21:32:47 JST 2015 Naoyuki Sawa
 *	- Win32vWFNgł́Amain()ĂяoOɁAprogram_invocation_name,program_invocation_short_name悤ɕύX܂B
 *	* Sat Nov 21 21:27:06 JST 2015 Naoyuki Sawa
 *	- strchrnul()ǉ܂B
 *	* Mon Nov 23 21:30:44 JST 2015 Naoyuki Sawa
 *	- strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
 *	  strtok_r()̐錾́Ainclude/string.h ɗL܂B
 *	* Tue Nov 24 21:41:25 JST 2015 Naoyuki Sawa
 *	- sleep(),usleep()ǉ܂B錾unistd.hɗL܂B
 *	* Sat Feb 13 21:29:21 JST 2016 Naoyuki Sawa
 *	- rawmemchr()ǉ܂B錾́Ainclude/string.hɒǉ܂B
 *	  uLinux Programmer's Manual - MEMCHRv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/memchr.3.html)p:
 *	  rawmemchr()֐memchr()ƓlAcswꏊn܂郁[̈̂ǂɂ邱ƂOɂ(܂AvO}͂̂ƂmĂ)AœK@čs(Ȃ킿A͈͂̏gpȂ)B
 *	  rawmemchr()֐̓}b`oCgꍇ̓}b`oCgւ̃|C^[ԂB}b`oCgȂꍇAʂ͕słB
 *	  rawmemchr()֐GNUgłAglibc2.1gp\łB
 *	- L̐ɂ'œK@čs'ƏĂ܂Ał͕ʂmemchr()ĂяoB
 *	  ĂяoA͈͂̏ȗoA֐̂߂ɗpӂ܂B
 *	* Thu Mar 24 21:04:15 JST 2016 Naoyuki Sawa
 *	- signbit(),copysign(),copysignf()ǉ܂B
 *	  C99Œǉꂽp̃}N,y,֐ŁA܂g͖Ǝv܂AoĂ߂ɎĂɂ܂B
 *	- round(),roundf(),nearbyint(),nearbyintf(),rint(),rintf(),lround(),lroundf(),lrint(),lrintf()ǉ܂B
 *	  C99Œǉꂽۂߊ֐ŁAɁAlround()֗Ǝv܂B
 *	  ܂܂ł'(int)((x>=0.0)?(x+0.5):(x-0.5))'̂悤ɏĂA'lround(x)'ōςނ悤ɂȂ܂B
 *	- 錾͑SāAinclude/math.hɗL܂B
 *	  {xo[W̊֐Acopysign(),lround(),lrint(),round(),nearbyint(),rint(),trunc()̎́Acliplibc.cɗL܂B
 *	  Pxo[W̊֐Acopysignf(),lroundf(),lrintf(),roundf(),nearbyintf(),rintf(),truncf()̎́Aframflt2.cɗL܂B
 *	  𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB
 *	* Mon Mar 28 21:40:28 JST 2016 Naoyuki Sawa
 *	- fdim(),fdimf(),fmin(),fminf(),fmax(),fmaxf(),fma(),fmaf()ǉ܂B
 *	  C99Œǉꂽ֐łB
 *	  fdim()́AɎĝǂȂ̂łAoĂ߂ɎĂɂ܂B
 *	  fmin(),fmax()́Amin(),max()}N^𖾎o邵p̂ŁA֗ɎgpoƎv܂B
 *	  fma()́AϘaZZEՂ̂ŁA(gʂ͏ȂƎv܂)g͗LƎv܂B
 *	- 錾͑SāAinclude/math.hɗL܂B
 *	  {xo[W̊֐Afdim(),fmin(),fmax(),fma()̎́Acliplibc.cɗL܂B
 *	  Pxo[W̊֐Afdimf(),fminf(),fmaxf(),fmaf()̎́Aframflt2.cɗL܂B
 *	  𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB
 *	* Mon Mar 28 22:52:58 JST 2016 Naoyuki Sawa
 *	- fdim(),fmin(),fmax(),fma()AZu܂B
 *	  fdim(),fmin(),fmax()̋ʏHvāA肭R[hTCY팸oƎv܂B
 *	  A__fcmpd%r4`%r7j󂵂ȂɈˑĂ܂B
 *	  A__fcmpd̎ύXꍇ́AӂĉB
 */
#include "clip.h"

/*****************************************************************************
 *	O[oϐ
 *****************************************************************************/

#ifdef  PIECE
/* S1C33 Family CRpCpbP[Wł́Aerrno̓AvP[VŒ`Kv܂B
 * [S5U1C33000C_J.pdf p.140] */
int errno;
#endif//PIECE

// * Sat Oct 24 14:03:11 JST 2015 Naoyuki Sawa
// - program_invocation_name,program_invocation_short_name̕ϐ`ǉ܂Bϐ錾cliplibc.cɗL܂B
//   ڍׂ́A/clip/include/errno.h ̓̃RgQƂĉB
char* program_invocation_name       = "";
char* program_invocation_short_name = "";

#ifdef  _MSC_VER
// * Mon Nov 02 21:32:47 JST 2015 Naoyuki Sawa
// - Win32vWFNgł́Amain()ĂяoOɁAprogram_invocation_name,program_invocation_short_name悤ɕύX܂B
//   ܂ł́A/clip/test.win/app.cmain()̐擪ŖIɏĂ܂Ȁ͕svɂȂ̂ō폜܂B
// - main()ĂяoOɕϐdg݂ɂẮAL̎QƂĉB
//   @uMSDNv́wCRT ̏xˁwO[o IuWFNg̏x(http://msdn.microsoft.com/ja-jp/library/bb918180.aspx)
//   AuLȌ(felid labo)v(http://up-cat.net/)́wmainƃXbh̑O㏈(1)x(http://up-cat.net/main%25A4%25C8%25A5%25B9%25A5%25EC%25A5%25C3%25A5%25C9%25A4%25CE%25C1%25B0%25B8%25E5%25BD%25E8%25CD%25FD%25281%2529.html)
//   BuOSDev.orgv(http://wiki.osdev.org/)́wC++xˁwVisual C++x(http://wiki.osdev.org/C%2B%2B)
//   C/Program Files/Microsoft Visual Studio/VC98/CRT/SRC/CRTEXE.C__xi_a[],__xi_z[],__xc_a[],__xc_z[]̕ϐ`
//   D/Program Files/Microsoft Visual Studio/VC98/CRT/SRC/CINITEXE.CmainCRTStartup()̊֐
// - @A̋L̓ZNV".CRT$XC?"ɂĐĂ܂Aɂ".CRT$XC?"C++płACł".CRT$XI?",ĝK؂łB
//   ۂɂ́AĂяöႢłACvOȂ".CRT$XI?"".CRT$XC?"̂ǂgĂʂɂȂ܂B
//   ڍׂ́AB̋L,y,D̎QƂĉB
// - @A̋LǂނƁAZNV".CRT$XI?"'?'̕'A'`'Z'͈̔͂悤ɓǂ߂܂A'B'`'W'͈̔͂ɂĂ̂SƎv܂B
//   'A''Z'͐擪ƏI[̃}[J[łÅԂ̖ÕZNVɒ`ꂽ|C^̊֐ĂяołB
//   ڍׂ́ACD̎QƂĉB
// - A̋Lɂ́A'#pragma data_seg(".CRT$XCU")'̑'#pragma init_seg(user)'łǂƏĂ܂AC++p̃vO}łCvOł͎gpo܂B
//   CvO'#pragma init_seg(user)'gpƁAuwarning C4157: ׸ς͖܂BvɂȂ܂B
// - '#pragma data_seg(".CRT$XI?")''#pragma data_seg(".CRT$XC?")'̃ZOgɒ`|C^ϐ́A萔ɂĂ͂܂B
//   萔ɂƁAC̒`Ƃ͈Ⴄނ̕ϐ̈ʒuɔzuĂ܂悤ŁA֐ĂяoȂȂ܂B
//   ȂAϐO[oɂKv͖Astaticłǂ悤ł()B]āAL̒`łstaticƂ܂B
// - P/ECEɂ͏L̂悤Ȏdĝ݂͖ŁAA/clip/test.pce/app.cmain()̐擪program_invocation_name,program_invocation_short_nameĂ܂B
//   P/ECẼX^[gAbv(/clip/cstart.c)ύXēl̎dg݂𓱓鎖܂AdvxႢ,GɂȂėǂȂƎv̂ŁA̕ύX͍sȂɂ܂B
static void init_program_invocation_name() {	//main()ĂяoOɁAmainCRTStartup()_cinit()_initterm()ĂяoB
	static char path[MAX_PATH];
	GetModuleFileName(NULL, path, sizeof path);
	program_invocation_short_name = basename((program_invocation_name = path));
}
#pragma data_seg(".CRT$XIU")	//'#pragma data_seg(".CRT$XCU")'ł\܂B
static void* /*!!consts!!*/ pinit_program_invocation_name/*ϐ͊֌Ŵŉłǂ*/ = init_program_invocation_name;	//̃|C^".CRT$XI?"ZOgɔzuāAmainCRTStartup()|C^̎w֐Ăяo܂B
#pragma data_seg()		//̃ZOgɖ߂BYȂ!!
#endif//_MSC_VER

/*****************************************************************************
 *	ʃx֐/_~[֐ : WbCu
 *****************************************************************************/

/* ʃx֐F	WCuĂ΂́B
 *			AvP[V璼ڎgƂ͂܂B
 * _~[֐F		WCũwb_Ő錾Ă邪A
 *			ĂȂiCuɑ݂ȂjB
 * ]āÅ֐ clippce.h Ő錾Kv͂܂B
 */

#ifdef  PIECE
/* exit(),abort()Ă΂܂B */
void
_exit()
{
	pceAppReqExit(0); /* Iv𔭍sāA */
	yield();          /* VXeɐԂ */
	/* Ayield()͐Ԃ܂B      */
}
#endif//PIECE

//{{2015/03/18폜:_~[read()̎폜܂B_~[read()EPSONCusscanf()̂߂ɒ`ĂŁAԂOsscanf()Ǝ_ŕsvɂȂĂɂ܂ŋCtʂɃR[heʂĂ܂B_~[read()폜ɂAR[heʂ12oCgȂȂ܂B
//#ifdef  PIECE
///* * EPSONCu̕Wo͗pʃx֐łB
// *   EPSONCusscanf()g߂ɒ`܂B
// * - sscanf()read()gĂ܂񂪁Asscanf()Ăяo_doscan()scanf()ƋpɂȂĂāA
// *   _doscan()scanf()Ă΂ꂽꍇread()gĂ邽߁Aread()̃V{vĂ܂܂B
// *   NG[邽߁A_~[read()֐`邱Ƃɂ܂B
// * - sscanf()gȂread()Ă΂邱Ƃ͂܂B
// */
//int
//read(int fd, char* buf, int nbytes)
//{
//	DIE();
//}
//#endif//PIECE
//}}2015/03/18폜:_~[read()̎폜܂B_~[read()EPSONCusscanf()̂߂ɒ`ĂŁAԂOsscanf()Ǝ_ŕsvɂȂĂɂ܂ŋCtʂɃR[heʂĂ܂B_~[read()폜ɂAR[heʂ12oCgȂȂ܂B

/*****************************************************************************
 *	EPSONCu̒u
 *****************************************************************************/

#ifdef  PIECE
/* * Thu Jun 17 05:14:00 JST 2004 Naoyuki Sawa ǋL
 * - ǗAEPSONCumalloc()AP/ECE API pceHeapAlloc()ɕύX܂B
 *   {W[ɂmalloc()/calloc()/realloc()/free()Ē`AEPSONCu̓֐I[o[Ch܂B
 */
void*
malloc(size_t size)
{
	return pceHeapAlloc(size);
}
void
free(void* ptr)
{
	/* pceHeapFree()free()ƈNULL|C^𖳎AJ悤ƂĎŝŁA܂IɌ܂B
	 * ubN̊JɎsꍇAԂAvP[VvÕoOȂ̂ŁADIE()邱Ƃɂ܂B
	 */
	int retval;

	if(ptr) {
		retval = pceHeapFree(ptr);
		if(retval != 0) DIE();
	}
}
void*
realloc(void* oldptr, size_t newsize)
{
	/* pceHeapRealloc()realloc()́AȂdlقȂ܂B
	 * pceHeapRealloc()̓ubNړ܂B
	 * ̏ꏊ̂܂܁ATCYg܂͏ksƂ܂B(k͕K͂ł)
	 * realloc()̏ꍇȀꏊŃTCYgɎsꍇAʂ̃ubNmۂČ̓eRs[܂A
	 * pceHeapRealloc()͂̓s킸AɎsԂ܂B
	 * * Thu Jun 17 07:27:00 JST 2004 Naoyuki Sawa ǋL
	 *   PieceSystem 1.20 ݂pceHeapRealloc()ɂ̓oO邱Ƃ킩܂B
	 *   ڂ́Aq̃RgQƂĂB
	 * * Mon Mar 30 19:21:12 JST 2009 Naoyuki Sawa
	 * - PieceSystem1.20݂pceHeapRealloc()oOCpb`Kp܂B
	 *   ڂ́Aq̃RgQƂĂB
	 */
	int retval;
	int oldsize;
	void* newptr;
	HEAPMEM* phm;

	/* * realloc(NULL, newsize)́Amalloc(newsize)ƓłB(reallocdl)
	 *   realloc(oldptr, 0)́Afree(oldptr)ƓłB(reallocdl)
	 * * realloc(NULL, 0)̓́AWCCudlł͖`̂悤łB(vmF)
	 *   2004/06/17݂̎́A{ free(NULL); return NULL; } ̓ƂĂ܂B
	 */
	if(!newsize) {
		free(oldptr);
		return NULL;
	}
	if(!oldptr) {
		return malloc(newsize);
	}

	///* ܂ȀŃTCYύXĂ݂܂B
	// * k̏ꍇ́AK͂łB
	// */
	//retval = pceHeapRealloc(oldptr, newsize);
	//if(retval == 0) return oldptr;
	//* Thu Jun 17 07:27:00 JST 2004 Naoyuki Sawa
	//  PieceSystem1.20݂pceHeapRealloc()ɂ̓oO܂B
	//  /usr/PIECE/system/pcekn/heapman.c 195sڂ
	//	oldsize = (unsigned long)phm->chain - (unsigned long)phm;
	//  ͊ԈႢŁA
	//	oldsize = (unsigned long)phm->chain - ((unsigned long)phm + sizeof(HEAPMEM));
	//  ƂȂ΂Ȃ͂łB
	//  pceHeapRealloc()ĂԂƁAq[vj󂳂ꂽAAhXsO肵܂B
	//  d̂ŁAɃubN̍Ċ蓖ĂsƂɂ܂B
	//  TCYk͋ubN̂܂܎gƂi܂A
	//  svɑ傫ȃubN܂łcĂ܂Ƃ邽߂ɁA
	//  ɗvꂽTCỸubNĊ蓖Ă邱Ƃɂ܂B
	//----------------------------------------------------------------------------------------
	// * Mon Mar 30 19:21:12 JST 2009 Naoyuki Sawa
	// - PieceSystem1.20pceHeapRealloc()oOɑ΂Aq̏C@͌łB
	//   q̏C@ł́AXsHeap𑝂₷oOɁAXHeap炷sɂȂĂ܂܂B
	//   C@́A/usr/PIECE/system/pcekn/heapman.c195sڂ͕ύXA202sڂ203sڂ̊ԂɎ̈sǉ邱ƂłB
	//     if ( phm2->owner ) return 2; // s(ɋ󂫂Ȃ)
	//     if(n < sizeof(HEAPMEM)) n = sizeof(HEAPMEM); // ̈sǉ!!
	//     n2 = (unsigned long)phm2->chain - (unsigned long)phm2;
	// - PieceSystem1.20ɂApceHeapRealloc()̃oOČ@́Aȉ̂ƂłB
	//     p = pceHeapAlloc(4);
	//     pceHeapRealloc(p, 8); // ŃAhXsO܂B
	//   oǑ́A204sڂAllocHEAPMEM()ĂяoɂāAnɌ㑱̋󂫃ubN荞ރoCgw肵Ă܂B
	//   AllocHEAPMEM()̑ɂ́AHEAPMEM\̂܂߂蓖ăTCYw肷̂łAL̃oOČR[ĥ悤ɁA
	//   4oCggꍇAHEAPMEM\̂̃TCY(8oCg)̐VKubN쐬悤ƂĂ܂܂B
	//   AllocHEAPMEM()̒ŁAphm14oCgphm2쐬Ă܂Aphm1chaintB[hj󂵂Ă܂܂B
	//   ̖Cɂ́AgoCgHEAPMEM\̂̃TCY(8oCg)̏ꍇ́A8oCgƂ邱ƂłB
	// - ȏ̏C@ɂāApceHeapRealloc()삷悤ɂȂ܂B
	//   ȂAHeap炷(208s)͌X̂ŁAOq̏C@ȂHeap炷ɂ͉e^܂B
	// - ȏ𓥂܂āA{CȕɁApceHeapRealloc()̏Cpb`gݍނƂɂ܂B
	//   ̓Iɂ́ApceAppInit()pceAppExit()ɒǉAbugfix_pceHeapRealloc()ĂяoQƂĂB
	//   pceHeapRealloc()Cpb`ɔA"Thu Jun 17 07:27:00 JST 2004"ɃRgAEgĂR[h𕜌܂B
	//   ܂ł́Arealloc()͏ɃړĂ܂ÁApceHeapRealloc()΃ړȂȂ܂B
	retval = pceHeapRealloc(oldptr, newsize);
	if(retval == 0) return oldptr;

	/* VubNmۂ܂B
	 * VubNmۂłȂꍇ́ÃubNJɁANULLԂ܂B(rellocdl)
	 */
	newptr = malloc(newsize);
	if(!newptr) return NULL;

	/* ̃ubN̓eAVubNɃRs[܂B
	 *
	 *	|              |
	 *	+--------------+ --- phm = oldptr - sizeof(HEAPMEM)
	 *	|    HEAPMEM   |
	 *	+--------------+ --- oldptr
	 *	|              |  |
	 *	| memory block |  |  oldsize = phm->chain - oldptr
	 *	|              |  |
	 *	+--------------+ --- phm->chain
	 *	| next HEAPMEM |
	 *	+--------------+
	 *	|              |
	 */
	phm = (HEAPMEM*)((unsigned char*)oldptr - sizeof(HEAPMEM));
	if(phm->mark != HEAPMEMMK) DIE();
	oldsize = (unsigned char*)phm->chain - (unsigned char*)oldptr;
	memcpy(newptr, oldptr, oldsize < newsize ? oldsize : newsize);

	/* ̃ubNJ܂B */
	free(oldptr);

	return newptr;
}
#endif//PIECE

#ifdef  PIECE
/* S1C33 Family CRpCpbP[Wcalloc()ɂ͖肪܂B
 * calloc(`, 1)̌`ŎgƂɁAKvʂ4{̃mۂ悤Ƃ܂B
 * 炭Â悤ȎɂȂĂ̂Ǝv܂B
 * 	void* calloc(size_t num, size_t size) {
 * 		int n;
 * 		void* p;
 * 		size = size + 3 & ~3;		// vfTCY4oCgPʂɐ؂グ
 * 		n = num * size;			// 蓖ăoCgvZ
 * 		p = malloc(n);			// 蓖ĂsĂ݂
 * 		if(p != NULL) memset(p, 0, n);	// Ȃ[NA
 * 		return p;
 * 	}
 * ł͖ʂ܂B
 * Ocalloc()pӂACucalloc()u邱Ƃɂ܂B
 * QlFP.J.vEK[uWbCu ANSI/ISO/JIS CKivigbpj
 * @@@@@ 432y[W }13.30 calloc.c
 *
 * * Thu Jun 17 05:14:00 JST 2004 Naoyuki Sawa ǋL
 * - ǗAEPSONCumalloc()AP/ECE API pceHeapAlloc()ɕύX܂B
 *   EPSONCucalloc()I[o[Ch邽߂ɁAcalloc()`Ă܂B
 */
void*
calloc(size_t num, size_t size)
{
	size_t n = num * size;
	void* p = malloc(n);
	if(p) memset(p, 0, n);
	return p;
}
#endif//PIECE

//{{2015/11/23폜:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
//#ifdef  PIECE
//}}2015/11/23폜:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
/* S1C33 Family CRpCpbP[Wstrtok()͊SɃoOĂ܂B
 * s1ɗ^̏I['\0'˂đĂ܂܂B
 * ႦΎ̃R[hsƁF
 *	char* s1 = "a/b/c\0d/e/f";
 *	char* p;
 *	p = strtok(s1, "/");
 *	while(p != NULL) {
 *		pceFontPrintf("(%s)", p);
 *		p = strtok(NULL, "/");
 *	}
 * u(a)(b)(c)vł͂ȂAu(a)(b)(c)(d)(e)(f)vƕ\Ă܂܂B
 * s1ucv̌́u\0vŏIĂ̂FłĂ܂B
 * ̗ł́ufvŎ~܂Ă܂A܂܁ufv̌Ɂu\0\0...v
 * kAĂŁAłȂĂȂΉiɏI܂B
 * iS1C33strtok()́Au\0vȏAĂȂƏIȂ悤łBj
 * ͂ɘ_OłB
 * Ostrtok()pӂACustrtok()u邱Ƃɂ܂B
 * QlFP.J.vEK[uWbCu ANSI/ISO/JIS CKivigbpj
 * @@@@@ 467y[W }14.20 strtok.c
 */
//{{2015/11/23ύX:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
//char* strtok(char* s1, const char* s2) { /* find next token in s1[] delimited by s2[] */
//	static char* ssave = ""; /* for safety */
//	char *sbegin, *send;
//	sbegin = s1 ? s1 : ssave;
//	sbegin += strspn(sbegin, s2);
//	if(*sbegin == '\0') { /* end of scan */
//		ssave = ""; /* for safety */
//		return NULL;
//	}
//	send = sbegin + strcspn(sbegin, s2);
//	if(*send != '\0') *send++ = '\0';
//	ssave = send;
//	return sbegin;
//}
//2015/11/23ύX:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
char* strtok(char* s1, const char* s2) { /* find next token in s1[] delimited by s2[] */
	static char* ssave = ""; /* for safety */
	return strtok_r(s1, s2, &ssave);
}
char* strtok_r(char* s1, const char* s2, char** saveptr) { /* find next token in s1[] delimited by s2[] */
	char *sbegin, *send;
	sbegin = s1 ? s1 : *saveptr;
	sbegin += strspn(sbegin, s2);
	if(*sbegin == '\0') { /* end of scan */
		*saveptr = ""; /* for safety */
		return NULL;
	}
	send = sbegin + strcspn(sbegin, s2);
	if(*send != '\0') *send++ = '\0';
	*saveptr = send;
	return sbegin;
}
//}}2015/11/23ύX:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
//{{2015/11/23폜:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B
//#endif//PIECE
//}}2015/11/23폜:strtok_r()ǉ܂B̕ύXɔWin32vWFNgłstrtok()Lɂ܂B

/* * Tue Jul 11 17:50:40 JST 2006 Naoyuki Sawa
 * - P/ECEJtstrstr()ɂ͕sAʂԂ܂B
 *   sČvOAȉɎ܂B
 *
 *	char dst1[] = { 'a', '\0', 'a', 'b', '\0' }; // r敶1
 *	char dst2[] = {       'a', 'a', 'b', '\0' }; // r敶2
 *	char src [] = {            'a', 'b', '\0' }; // r
 *	char* p1 = dstdst(dst1, "ab"); // NULLԂׂAdst1[2]ւ̃|C^ԂĂ܂
 *	char* p2 = dstdst(dst2, "ab"); // dst2[1]ւ̃|C^ԂׂANULLԂĂ܂
 *
 *    ̃p^[͓ނ܂BȉAꂼɂĐ܂B
 *
 *    1. }b`Ă͂Ȃ̂Ƀ}b`Ă܂̗:
 *
 *	dst1[]́AƂČƁAꕶڂ"a"ŏIĂ܂B
 *	]āA
 *		strstr(dst1, src);
 *	́A
 *		strstr("a", "ab");
 *	ƓłAʂNULLɂȂ͂łB
 *	AP/ECEJtstrstr()͌'\0'˂A
 *	Oځ`"ab"Ƀ}b`āAOڂ'a'ւ̃|C^ԂĂ܂܂B
 *
 *    2. }b`Ȃ΂Ȃ̂Ƀ}b`Ȃ̗
 *
 *	dst2[]́AƂČƁA"aab"łA񕶎ځ`"ab"܂ł܂B
 *	]āA
 *		strstr(dst2, src);
 *	́A񕶎ڂ'a'ւ̃|C^Ԃ͂łB
 *	AP/ECEJtstrstr()͌NULLԂĂ܂܂B
 *	P/ECEstrstr()́A܂Adst2[0`1]src[0`1]̔rsA}b`ĂȂƔfA
 *	dst2[]̑ʒudst[1]ɖ߂̂YāAdst[2]rpĂ܂Ă݂łB
 *
 * - P/ECEJtstrstr()̕s邽߁AOstrstr()pӂ܂B
 *   xvʂstrstr()gƂ͖Ǝv̂ŁAPȎƂ܂B
 *   vmF: strstr()̐ȎdĺAs1,s2KkI[Ă邱ƂOƂėǂ̂ł傤?	
 *   As1̂ǂs2݂邱ƂmȏꍇɁAs1kI[ĂȂƂdlȂ΁A	2014/10/12ǋL
 *   ȉ̎ł͐삵܂B(ŏɍsĂstrlen()Aǂ܂ōs\łȂB)	strstr()s1kI[ĂȂĂ삷悤ɏC܂B
 *   strstr()̐ȎdlmFKv܂B							
 */
//{{2014/10/12ύX:strstr()s1kI[ĂȂĂ삷悤ɏC܂B
//char*
//strstr(const char* s1, const char* s2)
//{
//	int n1 = strlen(s1);
//	int n2 = strlen(s2);
//
//	n1 -= n2;
//	while(n1 >= 0) {
//		if(!memcmp(s1, s2, n2)) {
//			return (char*)s1;
//		}
//		s1++;
//		n1--;
//	}
//	return NULL;
//}
//2014/10/12ύX:strstr()s1kI[ĂȂĂ삷悤ɏC܂B
/* * Sun Oct 12 18:49:43 JST 2014 Naoyuki Sawa
 * - strstr()s1kI[ĂȂĂ삷悤ɏC܂Bs2̓kI[ĂȂ΂Ȃ܂B
 * - strcasestr()ǉ܂B錾include/string.hɒǉ܂Bstrcasestr()GNUgłB
 */
#ifndef PIECE
static char* strstr_sub(const char* s1, const char* s2, int (*fn)(const char*, const char*, size_t));
char* strstr(const char* s1, const char* s2) {
	return strstr_sub(s1, s2, strncmp);
}
char* strcasestr(const char* s1, const char* s2) {
	return strstr_sub(s1, s2, strncasecmp);
}
static char* strstr_sub(const char* s1, const char* s2, int (*fn)(const char*, const char*, size_t)) {
	/* ̕߂B(s2="")ł\ȂB */
	int n = strlen(s2);
	/* ̐擪猟JnB
	 * - (s1="")̏ꍇAڂ̃[v͎sB
	 *   (s2="")̏ꍇ́As1̓eɂ炸((s1="")łĂȂĂ)Ɉv邩łB */
	do {
		/* ݈̌ʒuA̕rsAv猻݈ʒuԂB
		 * - (s2="")ꍇAs1̓eɂ炸((s1="")łĂȂĂ)AvB
		 * - (s1="")ꍇA(s2="")łȂ΁AvȂB */
		if(!(*fn)(s1, s2, n)) { return (char*)s1; }
	/* ̏I[łȂ΁Aʒu֐i߂B
	 * - (s1="")ꍇ́AڂŔ邱ƂɂȂB */
	} while(*s1++);
	/* ̏I[ɂrłvȂ΁ANULLԂB */
	return NULL;
}
#else /*PIECE*/
char* strstr(const char* s1, const char* s2);
char* strcasestr(const char* s1, const char* s2);
asm("
		.code
		.align		1
		.global		strstr
		.global		strcasestr
strstr:
		xld.w		%r14, strncmp			;//%r14 := fn = strncmp
		jp		strstr_sub
strcasestr:
		xld.w		%r14, strncasecmp		;//%r14 := fn = strncasecmp
strstr_sub:
		pushn		%r3
		ld.w		%r0, %r12			;//%r0  := s1
		ld.w		%r1, %r13			;//%r1  := s2
		ld.w		%r2, %r14			;//%r2  := fn
		xcall.d		strlen				;//%r10 := n = strlen(s2)
		ld.w		%r12, %r1			;//%r12 :=            s2		*delay*
		ld.w		%r3, %r10			;//%r3  := n
strstr_sub_L10:							;//do {
		ld.w		%r12, %r0			;//%r12 :=                s1
		ld.w		%r13, %r1			;//%r13 :=                   s2
		call.d		%r2				;//%r10 := retval = (*fn)(s1,s2,n)
		ld.w		%r14, %r3			;//%r14 :=                      n	*delay*
		cmp		%r10, 0				;//if(!retval) { return s1 }
		jreq.d		strstr_sub_L20
		ld.w		%r10, %r0			;//%r10 :=              s1		*delay*
		ld.b		%r10, [%r0]+			;//%r10 := c = *s1++
		cmp		%r10, 0				;//} while(c)
		jrne		strstr_sub_L10
strstr_sub_L20:
		popn		%r3
		ret
");
#endif/*PIECE*/
//}}2014/10/12ύX:strstr()s1kI[ĂȂĂ삷悤ɏC܂B

#ifndef _MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'pow' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
/* S1C33 Family C Compiler Package  pow() ɂ͕sAԈlԂƂ܂B
 * Ⴆ pow(1.25, 1.0) ̌ʂ 0.0 ɂȂ邱Ƃ܂B܂͋łĂ܂B
 * pow(1.0`1.5, 0.0ȊO) 肪Ȃ悤łAȃR[fBÖႢɂĔǂȂƂ܂B
 * ݁Aނ̉@Ă܂B
 * Epow()ĂԂ̃bsO֐pow_wrap()pӂApow_wrap()oRpow()ĂяoB
 *   mɉł̂łAȂꂾŉł̂S킩Ȃ̂sȂƂłB
 * Epow()exp()log()ɓWJApow()gȂ悤ɂ܂B
 *   s̌pow()P̖̂łȂ΁A̕@Ŋmɉł͂łB
 *   AZp֐̌Ăяo邽߁AvOxȂĂ܂_܂B
 * ɂAƂƂ̌킩ĂȂ̂ŁAǂ̕@łmɉłƂ͌؂܂B
 */
//double
//pow(double x, double y)
//{
//	return exp(log(x) * y);
//}
//---------------------------------------------------------------------------
//* Sun Apr 22 21:28:18 JST 2007 Naoyuki Sawa
//- ̎ł́Ax̏ꍇɑΉłĂȂ̂ŁAȉ̂悤ɏC܂B
//  ȉ̏菇́AOq̂悤ɕs̂EPSONCupow()Ƃقړ̂łAȂsł悤łB
//  EPSONCupow()̕s́A菇̂̂ł͂ȂAx̂߂ɕGȏĂ镔Ɍ݂łB
//- svexp()log()񃊃NĂ܂̂邽߂ɁApow()ʃW[ɕ邱Ƃ܂A
//  clipprnt.cpow()gĂāAʓIɂقƂǂ̃AvP[VɃNKvȂ̂ŁAKv͖Ɣf܂B
double
pow(double x, double y)
{
	double z;

	if(x > 0.0) {
		/* xȂ΁Â܂܌vZ܂B
		 */
		z = exp(y * log(x));
	} else if(x < 0.0) {
		/* xȂ...
		 * 1. yłȂ΁AG[łB(n捪܂ނ)
		 * 2. x𐳂ɂāAvZ܂B
		 * 3. yȂ΁Aʂ𕉂ɂ܂B
		 */
		if((int)y != y) {
			DIE();
		}
		x = -x;
		z = exp(y * log(x));
		if((int)y & 1) {
			z = -z;
		}
	} else { /* (x == 0.0) */
		/* xȂ...
		 * 1. yȂ΁Aʂ0.0łB
		 * 2. yȂ΁AG[łB([ZɂȂ邽)
		 * 3. yȂ΁Aʂ1.0łB
		 */
		if(y > 0.0) {
			z = 0.0;
		} else if(y < 0.0) {
			DIE();
		} else { /* (y == 0.0) */
			z = 1.0;
		}
	}

	return z;
}
#endif//_MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'pow' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB

/* * Thu Oct 25 14:45:01 JST 2007 Naoyuki Sawa
 * - AquaplusłȁAmemcpy()쐬܂B
 * - P/ECEJmemcpy()́AEPSONłȁAAquaplusłgĂ܂B
 *   AAquaplusłɂāAƍŏȃTCYȁACLiPł쐬܂B
 * - Rs[̃[vHvāAxXbgőɊp܂B
 *   ̌ʂ́Aȉ̂ƂłB(TURBO=-1Ōv)
 *	Rs[ (~100)               | Aquaplus | CLiP    | 
 *	-----------------------------------+------------+-----------+-------
 *	memcpy(0xc00000,0xd00000,0x100000) | 21140[ms]  | 18915[ms] | 10%
 *	memcpy(0xc00002,0xd00002,0x100000) | 33379[ms]  | 28929[ms] | 13%
 *	memcpy(0xc00001,0xd00001,0x100000) | 66757[ms]  | 57856[ms] | 13%
 * - IfAmemcpy_BYTËӏɂ܂Ƃ߂āAR[hTCY팸܂B
 *   R[hTCY팸̌ʂ́Aȉ̂ƂłB
 *	Aquaplus=68[byte]  CLiP=64[byte]
 * * Tue Jan 08 14:58:19 JST 2008 Naoyuki Sawa
 * - memcpy()AxN^̈FRAMɓ]Ďs邽߂ɁAclipidiv.sֈړ܂B
 *   xN^̈Ɏ܂悤ɁAבւs܂AR[he͕ύXĂ܂B
 */
//{{2008/01/08:폜(clipidiv.sֈړ)
//asm("
//	.code
//	.align	1
//	.global	memcpy
//memcpy:
//	;// %r12 := dst
//	;// %r13 := src
//	;// %r14 := cnt
//	cmp	%r14, 3		; if(cnt<=3) memcpy_BYTE
//	jrule.d	memcpy_BYTE
//	ld.w	%r10, %r12	; %r10 := dst (߂l)			*delay*
//	ld.w	%r9, %r12	; %r9  := dst
//	or	%r9, %r13	; %r9  := dst|src
//	and	%r9, 3		; %r9  := (dst|src)&3
//	jreq	memcpy_WORD	; if(!((dst|src)&3)) memcpy_WORD
//	and	%r9, 1		; %r9  := (dst|src)&1
//	jreq	memcpy_HALF	; if(!((dst|src)&1)) memcpy_HALF
//	;-----------------------;
//memcpy_BYTE:
//	sub	%r14, 1		; %r14 := (cnt-1) ------+
//	jrult	memcpy_RET	; if((cnt-1)<0) return  |
//	 ld.b	%r9, [%r13]+	;   byte = *src++       |
//	 ld.b	[%r12]+, %r9	;   *dst++ = byte       |
//	jrugt.d	-2		; while((cnt-1)>0) <----+ tOe
//	sub	%r14, 1		; %r14 := (cnt-1) -= 1 -+		*delay*
//memcpy_RET:
//	ret
//	;-----------------------;
//memcpy_HALF:
//	xsub	%r15, %r14, 3	; %r15 := (cnt-3) ------+
//	 ld.h	%r9, [%r13]+	;   half = *src++       |
//	 ld.h	[%r12]+, %r9	;   *dst++ = half       |
//	jrugt.d	-2		; while((cnt-3)>0) <----+ tOe
//	sub	%r15, 2		; %r15 := (cnt-3) -= 2 -+		*delay*
//	jp.d	memcpy_BYTE
//	and	%r14, 1		; %r14 := cnt &= 1			*delay*
//	;-----------------------;
//memcpy_WORD:
//	xsub	%r15, %r14, 7	; %r15 := (cnt-7) ------+
//	 ld.w	%r9, [%r13]+	;   word = *src++       |
//	 ld.w	[%r12]+, %r9	;   *dst++ = word       |
//	jrugt.d	-2		; while((cnt-7)>0) <----+ tOe
//	sub	%r15, 4		; %r15 := (cnt-7) -= 4 -+		*delay*
//	jp.d	memcpy_BYTE
//	and	%r14, 3		; %r14 := cnt &= 3			*delay*
//");
//}}2008/01/08:폜(clipidiv.sֈړ)

/* * Thu Oct 25 14:45:01 JST 2007 Naoyuki Sawa
 * - AquaplusłȁAmemset()쐬܂B
 * - P/ECEJmemset()́AEPSONłȁAAquaplusłgĂ܂B
 *   AAquaplusłɂāAƍŏȃTCYȁACLiPł쐬܂B
 * - tB̃[vHvāAxXbgőɊp܂B
 *   ̌ʂ́Aȉ̂ƂłB(TURBO=-1Ōv)
 *	tB (~100)        | Aquaplus | CLiP    | 
 *	----------------------------+------------+-----------+-------
 *	memset(0xc00000,0,0x100000) | 13352[ms]  | 11127[ms] | 16%
 *	memset(0xc00002,0,0x100000) | 22252[ms]  | 17802[ms] | 20%
 *	memset(0xc00001,0,0x100000) | 44505[ms]  | 35604[ms] | 20%
 * - memset_WORDmemset_HALF̂߂́AtBlgꕔʉAсA
 *   IfAmemset_BYTËӏɂ܂Ƃ߂āAR[hTCY팸܂B
 *   R[hTCY팸̌ʂ́Aȉ̂ƂłB
 *	Aquaplus=80[byte]  CLiP=68[byte]
 * * Tue Jan 08 14:58:19 JST 2008 Naoyuki Sawa
 * - memset()AxN^̈FRAMɓ]Ďs邽߂ɁAclipidiv.sֈړ܂B
 *   xN^̈Ɏ܂悤ɁAבւs܂AR[he͕ύXĂ܂B
 */
//{{2008/01/08:폜(clipidiv.sֈړ)
//asm("
//	.code
//	.align	1
//	.global	memset
//memset:
//	;// %r12 := dst
//	;// %r13 := v,?,?,?
//	;// %r14 := cnt
//	cmp	%r14, 3		; if(cnt<=3) memset_BYTE
//	jrule.d	memset_BYTE
//	ld.w	%r10, %r12	; %r10 := dst (߂l)			*delay*
//	xand	%r9, %r12, 1	; %r9  := dst&1
//	jrne	memset_BYTE	; if(dst&1) memset_BYTE
//	ld.ub	%r15, %r13	; %r15 := v,0,0,0
//	sll	%r13, 8		; %r13 := 0,v,?,?
//;//	or	%r13, %r15	; %r13 := v,v,?,?-------+
//	xand	%r9, %r12, 2	; %r9  := dst&2         |
//	jrne.d	memset_HALF	; if(dst&2) memset_HALF |
//	or	%r13, %r15	; <---------------------+		*delay*
//	ld.uh	%r13, %r13	; %r13 := v,v,0,0
//	swap	%r15, %r13	; %r15 := 0,0,v,v
//	or	%r13, %r15	; %r13 := v,v,v,v
//	;-----------------------;
//memset_WORD:
//	xsub	%r15, %r14, 7	; %r15 := (cnt-7) ------+
//	 ld.w	[%r12]+, %r13	;   *dst++ = v,v,v,v    |
//	jrugt.d	-1		; while((cnt-7)>0) <----+ tOe
//	sub	%r15, 4		; %r15 := (cnt-7) -= 4 -+		*delay*
//	jp.d	memset_BYTE
//	and	%r14, 3		; %r14 := cnt &= 3			*delay*
//	;-----------------------;
//memset_HALF:
//	xsub	%r15, %r14, 3	; %r15 := (cnt-3) ------+
//	 ld.h	[%r12]+, %r13	;   *dst++ = v,v        |
//	jrugt.d	-1		; while((cnt-3)>0) <----+ tOe
//	sub	%r15, 2		; %r15 := (cnt-3) -= 2 -+		*delay*
//	and	%r14, 1		; %r14 := cnt &= 1
//	;-----------------------;
//memset_BYTE:
//	sub	%r14, 1		; %r14 := (cnt-1) ------+
//	jrult	memset_RET	; if((cnt-1)<0) return  |
//	 ld.b	[%r12]+, %r13	;   *dst++ = v          |
//	jrugt.d	-1		; while((cnt-1)>0) <----+ tOe
//	sub	%r14, 1		; %r14 := (cnt-1) -= 1 -+		*delay*
//memset_RET:
//	ret
//");
//}}2008/01/08:폜(clipidiv.sֈړ)

#ifdef  PIECE
;// * Sun Mar 11 22:22:46 JST 2012 Naoyuki Sawa
;// - EPSONCumemmoveu܂B
;// - EPSONCumemmove͂܂Aȉ̖肪܂B
;//   Ememcpy𗘗płꍇ́Amemcpy𗘗pǂB
;//	memcpy̕A[hPʃRs[ōœKĂAłB
;//	AEPSONCumemmovéAŃoCgPʃRs[sĂ܂AᑬłB
;//   EORs[̏ꍇ́Amemcpy𗘗płB
;//	]āAmemmoveɁAORs[̎܂߂Kv͖B
;//	AEPSONCumemmovéAORs[܂ł܂ĂAeʂ̖ʂłB
;//   EEPSONCumemmovéARs[̃[vI[fA[v̐擪ōsĂ܂B
;//	[vI[fA[v̖ōsAł܂B
;// - ́ALO_PAmemmove܂B
;//
;//-----------------------------------------------------------------------------------------------------------------------------
;//
;//	((dest <= src) || (dest >= src+count)) ꍇAmemcpy𗘗pł
;//
;//		memcpy𗘗pł
;//
;//			dest
;//			
;//				
;//							
;//							src			src+count
;//
;//		memcpy𗘗pł
;//
;//					dest
;//					
;//					
;//							
;//							src			src+count
;//
;//		memcpy𗘗pł
;//
;//							dest			
;//							
;//							
;//							
;//							src			src+count
;//
;//		~memcpy𗘗płȂ
;//
;//									dest
;//									
;//							
;//							
;//							src			src+count
;//
;//		memcpy𗘗pł
;//
;//										dest
;//										
;//							
;//							
;//							src			src+count
;//
;//		memcpy𗘗pł
;//
;//											dest
;//											
;//								
;//							
;//							src			src+count
;//
;//-----------------------------------------------------------------------------------------------------------------------------
;//
;//	(count == 0) ꍇAmemcpy𗘗płB̏ꍇA
;//		((dest <= src) || (dest >= src+count))@ˁ@((dest <= src) || (dest >= src))@ˁ@ɐ
;//	ƂȂ̂ŁAIɔfKv͖B
;//
;//		memcpy𗘗pł
;//
;//			dest
;//			
;//							
;//							
;//							
;//							src(=src+count)
;//
;//		memcpy𗘗pł
;//
;//							dest
;//							
;//							
;//							
;//							
;//							src(=src+count)
;//
;//		memcpy𗘗pł
;//
;//											dest
;//											
;//											
;//							
;//							
;//							src(=src+count)
;//
;//-----------------------------------------------------------------------------------------------------------------------------
;//
;//	((dest <= src) || (dest >= src+count)) ǂf@́AӂsrcāA
;//		((dest-src <= src-src) || (dest-src >= src-src+count))@ˁ@((dest-src <= 0) || (dest-src >= count))
;//	(dest-src) }CiXlɂȂꍇ́Arp (}CiXl > count) 邩A
;//	(dest-src >= count) ɏWłA(dest-src) 0ɂȂꍇ𔻒fΗǂB]āA
;//		((dest-src == 0) || (dest-src >= count))
;//	ŔfłB
;//
;//-----------------------------------------------------------------------------------------------------------------------------
void* memmove(void* dest, const void* src, size_t count);
asm("
		.code
		.align		1
		.global		memmove
memmove:
		sub		%r12, %r13		;// %r12 := dest-src
		jreq		2			;// if((dest-src == 0) ||	//jreqĂ̂ŁAxjrugeŕK򂷂
		cmp		%r12, %r14		;//    (dest-src >= count))
		xjruge.d	memcpy			;//       return memcpy(dest, src, count)
		add		%r12, %r13		;// %r12 := dest			*delay*
		;//
		add		%r12, %r14		;// %r12 := dest += count
		add		%r13, %r14		;// %r13 := src  += count
		;//
		sub		%r13, 1			;// <---------------------------+
memmove_LOOP:						;// do {			|
;//		sub		%r13, 1			;//   %r13 := src--	--------+
		ld.b		%r9, [%r13]		;//   %r9  := c = *src		|
		sub		%r12, 1			;//   %r12 := dest--		|	*anti-interlock*
		ld.b		[%r12], %r9		;//   *dest = c			|
		sub		%r14, 1			;//   %r14 := count--		|
		jrne.d		memmove_LOOP		;// } while(count != 0)		|
		sub		%r13, 1			;// <---------------------------+	*delay*
		ret.d					;// return  dest
		ld.w		%r10, %r12		;// %r10 := dest			*delay*
");
#endif//PIECE

/*****************************************************************************
 *	WbCu̕⏕
 *****************************************************************************/

#ifndef PIECE
#ifndef _MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'strlen' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
size_t strlen(const char* string) {
	return strnlen(string, SIZE_MAX);
}
#endif//_MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'strlen' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
/* strnlen()֐́Astringw̒AoCgŕԂB
 * ɂ́AI['\0'͊܂܂ȂB
 * ͍őŁAn܂łłB
 * strnlen()֐́Astring̍ŏnoCĝ݂Astring+n邱Ƃ͂ȂB
 */
size_t strnlen(const char* string, size_t n) {
	size_t len = 0;
	while((n--) && (*string++)) {
		len++;
	}
	return len;
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		strlen
		.global		strnlen
strlen:
		ld.w		%r13, -1		;// %r13 := n = SIZE_MAX
strnlen:
		ld.w		%r10, -1		;// %r10 := len = -1	Ō̃[vŗ]+1̂ŁA\-1Ă
		sub		%r13, 1			;// %r13 := n--				<---------------+
		jrult		4			;// if(n == -1) { return len + 1 }	--------+	|
		ld.b		%r9, [%r12]+		;// %r9  := c = *string++			|	|
		cmp		%r9, 0			;// if(c ==  0) { return len + 1 }		|	|
		jrne.d		-4			;//					--------|-------+
		add		%r10, 1			;// %r10 := len++			<-------+		*delay*
		ret
");
#endif/*PIECE*/

#ifndef PIECE
#ifndef GC_LEAK_DETECTOR_H	//Boehm GCleak_detector.hCN[hĂꍇ́A`d̂łł͒`ȂB
char* strdup(const char* string) {
	return strndup(string, SIZE_MAX);
}
/* strndup()֐́Astrdup()Ɠlł邪AőnoCg𕡐B
 * stringnꍇ́AnoCg𕡐AI['\0'ǉB
 */
char* strndup(const char* string, size_t n) {
	size_t len = strnlen(string, n);
	char* p =  malloc(len + 1/*I['\0'̕AYꂸ!*/);
	if(p != NULL) {
		p[len] = '\0';
		memcpy(p, string, len);
	}
	return p;
}
#endif//GC_LEAK_DETECTOR_H	//Boehm GCleak_detector.hCN[hĂꍇ́A`d̂łł͒`ȂB
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		strdup
		.global		strndup
strdup:
		ld.w		%r13, -1		;// %r13 := n = SIZE_MAX
strndup:
		pushn		%r1
		;// %r12 := string
		;// %r13 := n
		xcall.d		strnlen			;// %r10 := len = strnlen(string, n)
		ld.w		%r0, %r12		;// %r0  :=               string	*delay*
		ld.w		%r1, %r10		;// %r1  := len
		;// %r0  := string
		;// %r1  := len
		ld.w		%r12, %r1		;// %r12 :=             len
		xcall.d		malloc			;// %r10 := p =  malloc(len + 1)
		add		%r12, 1			;// %r12 :=             len + 1		*delay*
		cmp		%r10, 0			;// if(p != NULL) {
		jreq		strndup_RET
		;// %r0  := string
		;// %r1  := len
		;// %r10 := p
		ld.w		%r12, %r10		;//   %r12 :=            p
		add		%r10, %r1		;//   %r10 := p + len
		ld.b		[%r10], %r8		;//         *(p + len) = '0'		1
		ld.w		%r13, %r0		;//   %r13 :=               string
		xcall.d		memcpy			;//   %r10 := p = memcpy(p, string, len)
		ld.w		%r14, %r1		;//   %r14 :=                       len	*delay*
strndup_RET:	;// %r10 := p				;// }
		popn		%r1
		ret					;// return p
");
//1
// - asmubÑRgɁApu\vgpȂ悤AӂĂB
// - Ƃ΁ALRǵu*(p+len)='0'vu*(p+len)='\0'vƂƁAasmubNIĂ܂܂B
//   ȂȂARpCasmubN𕶎񃊃eƂĈA'\0' GXP[vV[PXƂēWJ邩łB
// - LR[h̏ꍇ́A܂܁Astrndup_RET ̖`G[ƂȂANɔł܂B
//   AɃrh̃G[ƂĔłƂ͌炸AhoǑƂȂ܂B
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int strcasecmp(const char* s1, const char* s2) {
	int c1, c2;
	do {
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}
int strncasecmp(const char* s1, const char* s2, size_t n) {
	int c1, c2;
	do {
		if(n-- == 0) return 0;
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}
#else /*PIECE*/
/* * Fri Apr 20 11:09:47 JST 2012 Naoyuki Sawa
 * - strcasecmp()strncasecmp()AZu܂B
 */
asm("
		.code
		.align		1
		.global		strcasecmp
		.global		strncasecmp
strcasecmp:
		ld.w		%r14, -1		;// %r14 := n = UINT_MAX
strncasecmp:
		pushn		%r3
		ld.w		%r1, %r12		;// %r1  := s1
		ld.w		%r2, %r13		;// %r2  := s2
		ld.w		%r3, %r14		;// %r3  := n
		sub		%r3, 1			;// <-------------------------------------------+
strncasecmp_LOOP:					;//						|
;//		sub		%r3, 1			;// %r3  := n--	--------------------------------+
		jrult		strncasecmp_RET0	;// if(n < 0) return 0				|
		;//					;//						|
		ld.ub		%r12, [%r2]+		;// %r12 := c2 = (unsigned char)*s2++		|
		xcall		tolower			;// %r10 := c2 = tolower(c2)			|
;//		ld.w		%r0, %r10		;// %r0  := c2	------------------------+	|
		;//					;//					|	|
		ld.ub		%r12, [%r1]+		;// %r12 := c1 = (unsigned char)*s1++	|	|
		xcall.d		tolower			;// %r10 := c1 = tolower(c1)		|	|
		ld.w		%r0, %r10		;// <-----------------------------------+	|	*delay*
		;//					;//						|
		cmp		%r10, 0			;// if(c1 ==  0) return (c1 - c2)		|
		jreq.d		strncasecmp_EXIT	;//						|
		sub		%r10, %r0		;// %r10 :=             (c1 - c2)		|	*delay*
		jreq.d		strncasecmp_LOOP	;// if(c1 != c2) return (c1 - c2)		|
		sub		%r3, 1			;// <-------------------------------------------+	*delay*
strncasecmp_EXIT:
		popn		%r3
		ret
strncasecmp_RET0:
		jp.d		strncasecmp_EXIT
		ld.w		%r10, 0			;// %r10 := 0						*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Sat Dec 15 14:14:55 JST 2012 Naoyuki Sawa
 * - strcmp()strncmp()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   EPSONł́Astrcmp()strncmp()ʂɎĂ܂A܂Ƃ߂ĎAȃɂȂ܂B
 * - ۂɂ́A{W[Ɋ܂߂ƁAKv̖ꍇKNĂ܂Apă܂B
 *   AvP[VAstrcmp()strncmp()𗼕gpĂꍇ̂݁AȃɂȂƍlĂB
 */
#ifndef PIECE
#ifndef _MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'strcmp' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
int strcmp(const char* s1, const char* s2) {
	return strncmp(s1, s2, SIZE_MAX);
}
#endif//_MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'strcmp' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
int strncmp(const char* s1, const char* s2, size_t n) {
	int t = 0; /* n0w肳ꂽꍇɖ߂l0Ƃ邽߁A(t=0)ɏĂB */
	for(;;) {
		int c1, c2;
		if((int)--n == -1) {
			break; /* ̈ʒuł͕K(t==0)łB]"return 0"ɑB */
		}
		c1 = *(unsigned char*)s1++;
		c2 = *(unsigned char*)s2++;
		if((t = c1 - c2) != 0) {
			break;
		}
		if(c2 == 0) {
			break; /* ̈ʒuł͕K(t==0)łB]"return 0"ɑB */
		}
	}
	return t;
}
#else /*PIECE*/
int  strcmp(const char* s1, const char* s2);
int strncmp(const char* s1, const char* s2, size_t n);
asm("
		.code
		.align		1
		.global		strcmp
		.global		strncmp
;//---------------------------------------------;//
strcmp:						;//
		ld.w		%r14, -1	;// %r14 := n = SIZE_MAX
;//---------------------------------------------;//
strncmp:					;//
		ld.w		%r10, 0		;// %r10 := t = 0
strncmp_LOOP:					;// for(;;) {
		sub		%r14, 1		;//   if((int)--n == -1)
		jrult		strncmp_RET	;//     break
		ld.ub		%r10, [%r12]+	;//   %r10 := c1 = *(unsigned char*)s1++
		ld.ub		%r11, [%r13]+	;//   %r11 := c2 = *(unsigned char*)s2++
		sub		%r10, %r11	;//   %r10 := t  = c1 - c2
		jrne		strncmp_RET	;//   if(t  != 0) break
		cmp		%r11, 0		;//   if(c2 == 0)
		jrne		strncmp_LOOP	;//     break
strncmp_RET:					;// }
		ret
;//---------------------------------------------;//
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Sat Dec 15 14:14:55 JST 2012 Naoyuki Sawa
 * - strchr()strrchr()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   EPSONłstrchr()strrchr()ŏɖʂ_PA̎̕ȃɂȂ܂B
 * - ۂɂ́A{W[Ɋ܂߂ƁAKv̖ꍇKNĂ܂Apă܂B
 *   AvP[VAstrchr()strrchr()𗼕gpĂꍇ̂݁AȃɂȂƍlĂB
 * * Sat Nov 21 21:27:06 JST 2015 Naoyuki Sawa
 * - strchrnul()ǉ܂B錾include/string.hɒǉ܂B
 *   uLinux Programmer's Manual - STRCHRv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/strchr.3.html)p:
 *   strchrnul()֐strchr()ƓlAcsɌȂꍇɁAԂlƂNULLłȂAs̖̃koCgւ̃|C^[Ԃ_قȂB
 *   strchrnul()֐͈vւ̃|C^[ԂBȂꍇ́As̖̃koCgւ̃|C^[(܂s+strlen(s))ԂB
 *   strchrnul()  GNU głB
 */
#ifndef PIECE
char* strchr(const char* s, int c) {
	int tmp;
	do {
		if((tmp = *(unsigned char*)s) == c) {
			return (char*)s; /* sɍŏɕcꂽʒuւ̃|C^ԂB */
		}
		s++;
	} while(tmp != 0);
	return NULL; /* sɕcȂꍇNULLԂB */
}
char* strrchr(const char* s, int c) {
	char* result = NULL; /* sɍŌɕcꂽʒuւ̃|C^BsɕcȂꍇNULLԂB */
	int tmp;
	do {
		if((tmp = *(unsigned char*)s) == c) {
			result = (char*)s; /* sɍŌɕcꂽʒuւ̃|C^XVB */
		}
		s++;
	} while(tmp != 0);
	return result; /* sɍŌɕcꂽʒuւ̃|C^ԂBsɕcȂꍇNULLԂB */
}
char* strchrnul(const char* s, int c) {
	for(;;) {
		int tmp = *(unsigned char*)s++;
		if((tmp == c) || !tmp) { break; }
	}
	return (char*)(s - 1); //strchrnul()֐͈vւ̃|C^[ԂBȂꍇ́As̖̃koCgւ̃|C^[(܂s+strlen(s))ԂB
}
#else /*PIECE*/
char*  strchr(const char* s, int c);
char* strrchr(const char* s, int c);
char* strchrnul(const char* s, int c);
asm("
		.code
		.align		1
		.global		strchr
		.global		strrchr
		.global		strchrnul
;//---------------------------------------------;//
;// strchr()֐́Asɍŏɕcꂽʒuւ̃|C^ԂB
;// sɕcȂꍇNULLԂB
;// I[nul͕̈ꕔƌȂAcnulw肳ꂽꍇ͏I[nulւ̃|C^ԂBv!!
;//---------------------------------------------;//
strchr:						;// do {
		ld.ub		%r10, [%r12]	;//   %r10 := tmp = *(unsigned char*)s
		cmp		%r10, %r13	;//   if(tmp == c)			!INTERLOCK!
		jreq		strchr_RET	;//     goto strchr_RET
		cmp		%r10, 0		;//   
		jrne.d		strchr		;// } while(tmp != 0)
		add		%r12, 1		;//   %r12 := s++			*delay*
		ret				;// return  0
strchr_RET:					;//
		ret.d				;// return  s
		ld.w		%r10, %r12	;// %r10 := s				*delay*
;//---------------------------------------------;//
;// strrchr()֐́AsɍŌɕcꂽʒuւ̃|C^ԂB
;// sɕcȂꍇNULLԂB
;// I[nul͕̈ꕔƌȂAcnulw肳ꂽꍇ͏I[nulւ̃|C^ԂBv!!
;//---------------------------------------------;//
strrchr:					;//
		ld.w		%r10, 0		;// %r10 := result = 0
strrchr_LOOP:					;// do {
		ld.ub		%r9, [%r12]	;//   %r9  := tmp = *(unsigned char*)s
		cmp		%r9, %r13	;//   					!INTERLOCK!
		jrne.d		3		;//   if(tmp == c)
		cmp		%r9, 0		;//   <-------------------------+	*delay*
		 ld.w		%r10, %r12	;//     %r10 := result = s	|
;//		cmp		%r9, 0		;//   --------------------------+
		jrne.d		strrchr_LOOP	;// } while(tmp != 0)
		add		%r12, 1		;//   %r12 := s++			*delay*
		ret				;// return result
;//---------------------------------------------;//
// uLinux Programmer's Manual - STRCHRv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/strchr.3.html)p:
// strchrnul()֐strchr()ƓlAcsɌȂꍇɁAԂlƂNULLłȂAs̖̃koCgւ̃|C^[Ԃ_قȂB
// strchrnul()֐͈vւ̃|C^[ԂBȂꍇ́As̖̃koCgւ̃|C^[(܂s+strlen(s))ԂB
// strchrnul()  GNU głB
;//---------------------------------------------;//
strchrnul:
		ld.w		%r10, %r12	;//%r10 := s
strchrnul_LOOP:					;//for(;;) {
		ld.ub		%r9, [%r10]+	;//   %r9  := tmp = *(unsigned char*)s++
		cmp		%r9, %r13	;//   if( tmp == c) { break }
		jreq		strchrnul_BREAK	;//   
		cmp		%r9, 0		;//   if(!tmp     ) { break }
		jrne		strchrnul_LOOP	;//}
strchrnul_BREAK:				;//
		ret.d				;//return  s - 1
		sub		%r10, 1		;//%r10 := s - 1			*delay*
;//---------------------------------------------;//
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Tue Dec 18 21:23:57 JST 2012 Naoyuki Sawa
 * - memchr()memcmp()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   EPSONłmemchr()memcmp()ŏɖʂ_PA̎̕4oCgȃɂȂ܂B
 * - {W[Ɋ܂߂ƁAKv̖ꍇKNApă鋰ꂪ܂
 *   Amemchr()doprnt.cW[,memcmp()clippce.cQƂĂ̂ŁAXKKvłB
 *   ]āAʂ͐܂B
 * * Sat Feb 13 21:29:21 JST 2016 Naoyuki Sawa
 * - rawmemchr()ǉ܂B
 *   uLinux Programmer's Manual - MEMCHRv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/memchr.3.html)p:
 *   rawmemchr()֐memchr()ƓlAcswꏊn܂郁[̈̂ǂɂ邱ƂOɂ(܂AvO}͂̂ƂmĂ)AœK@čs(Ȃ킿A͈͂̏gpȂ)B
 *   rawmemchr()֐̓}b`oCgꍇ̓}b`oCgւ̃|C^[ԂB}b`oCgȂꍇAʂ͕słB
 *   rawmemchr()֐GNUgłAglibc2.1gp\łB
 * - L̐ɂ'œK@čs'ƏĂ܂Ał͕ʂmemchr()ĂяoB
 *   ĂяoA͈͂̏ȗoA֐̂߂ɗpӂ܂B
 */
#ifndef PIECE
void* rawmemchr(const void* s, int c) {
	return memchr(s, c, -1);
}
void* memchr(const void* _s, int c, size_t n) {
	unsigned char* s      = (unsigned char*)_s;
	unsigned char* result = (unsigned char*) 1;
	int tmp;
	for(;;) {
		if((int)--n == -1) {
			break; /* ̈ʒuł͕K(result==1)łB */
		}
		if((tmp = *s++) == c) {
			result = s; /* |C^s͕cʒu+1iłB */
			break;
		}
	}
	return result - 1; /* ǂbreakŔꍇ(result-1)߂lƂȂB */
}
#ifndef _MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'memcmp' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
int memcmp(const void* _s1, const void* _s2, size_t n) {
	const unsigned char* s1 = _s1;
	const unsigned char* s2 = _s2;
	int c1, c2, t;
	for(;;) {
		if((int)--n == -1) {
			break;
		}
		c1 = *s1++;
		c2 = *s2++;
		if((t = c1 - c2) != 0) {
			return t;
		}
	}
	return 0;
}
#endif//_MSC_VER	//Visual C++ 6.0ł̓[XrhɁuerror C2169: 'memcmp' : gݍ݊֐͒`ł܂BvɂȂ邽ߏOB
#else /*PIECE*/
void* rawmemchr(const void* s, int c);
void* memchr(const void* _s, int c, size_t n);
int memcmp(const void* _s1, const void* _s2, size_t n);
asm("
		.code
		.align		1
		.global		rawmemchr
		.global		memchr
		.global		memcmp
;//---------------------------------------------;//
rawmemchr:
		ld.w		%r14, -1	;// %r14 := n = -1
memchr:						;//
		ld.w		%r10, 1		;// %r10 := result = 1
memchr_LOOP:					;// for(;;) {
		sub		%r14, 1		;//   if((int)--n == -1)
		jrult		memchr_RET	;//     break
		ld.ub		%r9, [%r12]+	;//   %r9  := tmp = *s++
		cmp		%r9, %r13	;//   if(tmp == c) {
		jrne		memchr_LOOP	;//     %r10 := result = s
		ld.w		%r10, %r12	;//     break }
memchr_RET:					;// }
		ret.d				;// return  result
		sub		%r10, 1		;// %r10 := result--	*delay*
;//---------------------------------------------;//
memcmp:						;// for(;;) {
		sub		%r14, 1		;//   if((int)--n == -1)
		jrult		memcmp_RET0	;//     break
		ld.ub		%r10, [%r12]+	;//   %r10 := c1 = *(unsigned char*)s1++
		ld.ub		%r11, [%r13]+	;//   %r11 := c2 = *(unsigned char*)s2++
		sub		%r10, %r11	;//   %r10 := t  = c1 - c2
		jreq		memcmp		;//   if(t != 0)
		ret				;//     return t
memcmp_RET0:					;// }
		ret.d				;// return  0
		ld.w		%r10, 0		;// %r10 := 0		*delay*
;//---------------------------------------------;//
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Fri Dec 21 00:22:01 JST 2012 Naoyuki Sawa
 * - strspn()strcspn()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   EPSONłmemchr()memcmp()ŏɖʂ_PA̎̕4ߕȃɂȂ܂B
 * - {W[Ɋ܂߂ƁAKv̖ꍇKNApă鋰ꂪ܂
 *   Astrspn()strcspn()́Aclippce.cōĎstrtok()QƂĂ̂ŁAXKKvłB
 *   ]āAʂ͐܂B
 */
#ifndef PIECE
size_t  strspn(const char* s1, const char* s2) {
	int result = -1;
	int c1, c2, c;
	const char* p;
	c2 = 0;					//قȂ̂͂̓s
	for(;;) {
		c1 = *(unsigned char*)s1++;	//قȂ̂͂̓s
		//{{--- strspn_strcspn ---
		result++;
		if(c1 == c2) { return result; }
		p = s2;
		for(;;) {
			c = *(unsigned char*)p++;
			if(c == c1) { break; }
			if(c == c2) { return result; }
		}
		//}}--- strspn_strcspn ---
	}
}
size_t strcspn(const char* s1, const char* s2) {
	int result = -1;
	int c1, c2, c;
	const char* p;
	c1 = 0;					//قȂ̂͂̓s
	for(;;) {
		c2 = *(unsigned char*)s1++;	//قȂ̂͂̓s
		//{{--- strspn_strcspn ---
		result++;
		if(c1 == c2) { return result; }
		p = s2;
		for(;;) {
			c = *(unsigned char*)p++;
			if(c == c1) { break; }
			if(c == c2) { return result; }
		}
		//}}--- strspn_strcspn ---
	}
}
#else /*PIECE*/
size_t  strspn(const char* s1, const char* s2);
size_t strcspn(const char* s1, const char* s2);
asm("
		.code
		.align		1
		.global		strspn
		.global		strcspn
strspn:
		ld.w		%r10, -1		;// %r10 := result = -1
		ld.w		%r5, 0			;// %r5  := c2 = 0
		;//					;// for(;;) {
		ld.ub		%r4, [%r12]+		;//   %r4  := c1 = *(unsigned char*)s1++
		call		strspn_strcspn		;//   %r10 := result++
		jp		-2			;// }
		;//-------------------------------------;//
strcspn:
		ld.w		%r10, -1		;// %r10 := result = -1
		ld.w		%r4, 0			;// %r4  := c1 = 0
		;//					;// for(;;) {
		ld.ub		%r5, [%r12]+		;//   %r5  := c2 = *(unsigned char*)s1++
		call		strspn_strcspn		;//   %r10 := result++
		jp		-2			;// }
		;//-------------------------------------;//
strspn_strcspn:
		cmp		%r4, %r5		;// if(c1 == c2)
		jreq.d		8			;//   return result	--------------------------------+	strspnstrcspn֖߂炸ǍĂяo֖߂
		add		%r10, 1			;// %r10 := result++	*delay*				|
		ld.w		%r6, %r13		;// %r6  := p = s2					|
		;//					;// for(;;) {						|
		ld.ub		%r7, [%r6]+		;//   %r7  := c = *(unsigned char*)p++	<-------+	|
		cmp		%r7, %r4		;//   if(c == c1)				|	|
		jreq		4			;//     return result	----------------+	|	|	strspnstrcspn֖߂
		cmp		%r7, %r5		;//   if(c != c2)			|	|	|
		jrne		-4			;//     continue	----------------|-------+	|
		add		%sp, 1			;//   else		<---------------|---------------+
		ret					;//     return result	<---------------+			strspnstrcspn֖߂炸ǍĂяo֖߂
							;// }
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Wed Mar 27 20:21:54 JST 2013 Naoyuki Sawa
 * - strsep()ǉ܂B錾́Ainclude/string.hɒǉ܂B
 *   strsep()́AEPSONCuɂ͊܂܂Ă炸A܂ACW֐ł͂܂񂪁AUNIXł͈ʓIȊ֐łB
 *   strtok()ƊrׂāÃtB[h邱ƁCGggł邱Ƃ̗_A֗Ȃ̂P/ECEɂǉ邱Ƃɂ܂B
 * - strpbrk()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   strpbrk()́AEPSONCu̎̂܂܂łA[ɃRpNgōłB
 *   Astrsep()ƈꏏɎ邱ƂŁAꕔ̃WX^̑ޔȗĂRpNgōɂł̂ŁAstrpbrk()邱Ƃɂ܂B
 *   ۂɂ́Astrpbrk()gpȂAvP[VɂNĂ܂_ĂƁAKIƂ͌Ȃ̂łǁA
 *   EPSONCułǂAZuł(Ǝv)̂ŁAȂ̂Ŋ܂߂邱Ƃɂ܂(^^;
 */
#ifndef PIECE
/* strsep()֐́A*stringpɂQƂ镶̒ŁAdelim̂ꂩ̕(܂͏I['\0')̂ōŏɏo镶̈ʒuTẢӏ'\0'Œu܂B
 * ؂蕶̎̈̕ʒu(܂͕̖ɒBꍇNULL)A*stringpɊi[܂B
 * *stringp̌̒lA߂lƂȂ܂B
 * uṽtB[hAȂ킿A2̗אڂ؂蕶ɂĐtB[h́A*stringp̒ɕԂꂽ|C^QƂʒu'\0'Ɣr邱ƂŌo\łB
 * *stringpŏNULLłꍇ́Astrsep()NULLԂ܂B
 */
char* strsep(char** stringp, const char* delim) {
	char* begin = *stringp;
	if(begin) {
		char* end = strpbrk(begin, delim);
		if(end) { *end++ = '\0'; }
		*stringp = end;
	}
	return begin;
}
char* strpbrk(const char* s, const char* accept) {
	const char* p;
	for(;;) {
		int c = *s++;
		if(!c) { return NULL; }
		p = accept;
		for(;;) {
			int t = *p++;
			if(!t) { break; }
			if(t == c) { return (char*)(s - 1); }
		}
	}
}
#else /*PIECE*/
char* strsep(char** stringp, const char* delim);
char* strpbrk(const char* s, const char* accept);
asm("
		.code
		.align		1
		;//=====================================;//
		.global		strsep
strsep:
		ld.w		%r14, [%r12]		;// %r14 := begin = *stringp
		cmp		%r14, 0			;// if(begin) {
		jreq		strsep_RET
		ld.w		%r15, %r12		;//   %r15 := stringp
		call.d		strpbrk			;//   %r10 := end = strpbrk(begin, delim)
		ld.w		%r12, %r14		;//   %r12 :=               begin		*delay*
		cmp		%r10, 0			;//   if(end) {
		jreq		2			;//     *end++ = '0'		--------+
		ld.b		[%r10]+, %r8		;//   }					|
		ld.w		[%r15], %r10		;//   *stringp = end		<-------+
strsep_RET:	;//					;// }
		ret.d
		ld.w		%r10, %r14		;// %r10 := begin				*delay*
		;//=====================================;//
		.global		strpbrk
strpbrk:						;// for(;;) {
		ld.b		%r10, [%r12]+		;//   %r10 := c = *s++		<-------+
		cmp		%r10, 0			;//   if(!c)				|
		jreq		strpbrk_RET		;//     return NULL			|
		ld.w		%r11, %r13		;//   %r11 := p = accept		|
		;//					;//   for(;;) {				|
		ld.b		%r9, [%r11]+		;//     %r9  := t = *p++	<-------|-------+
		cmp		%r9, 0			;//     if(!t)				|	|
		jreq		strpbrk			;//       break			--------+	|
		cmp		%r9, %r10		;//     if(t == c) return s - 1			|
		jrne		-4			;//   }				----------------+
		sub		%r12, 1			;// %r12 := s - 1
		ld.w		%r10, %r12		;// %r10 := s - 1
strpbrk_RET:	;//					;// }
		ret
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Thu Oct 09 22:33:48 JST 2014 Naoyuki Sawa
 * - strcat()strncat()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *   EPSONł́Astrcat()strncat()ʂɎĂ܂A܂Ƃ߂ĎAȃɂȂ܂B
 * - ۂɂ́A{W[Ɋ܂߂ƁAKv̖ꍇKNĂ܂Apă܂B
 *   AvP[VAstrcat()strncat()𗼕gpĂꍇ̂݁AȃɂȂƍlĂB
 * - ȃ̌ʂ́Aȉ̒ʂłB
 *   EPSON
 *   strcat  10߄
 *   strncat 16߄26
 *               c12ߐߖ
 *   strcat{strncat 14
 */
#ifndef PIECE
/* uLinux Programmer's Manual - STRCATv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/strcat.3.html)p:
 * strcat()֐́AdesťsrctB
 * ̍ۂɁAdest̍ŌɂI[̃koCg('\0')͏㏑AVɐꂽ̖ɏI[̃koCgt^B
 * ̕srcdest͏dȂĂ͂ȂȂB
 * ܂Adest́AǍʂi[̂ɏ\ȑ傫łȂ΂ȂȂB
 * dest\ȑ傫łȂꍇAvOǂ̂悤ȓ邩ȂB
 * obt@I[o[̓ZLAȃvOUۂɍDŎg@łB
 * strncat()lAȉ̓_قȂB
 * - srĉőnoCggpB
 * - srcnoCgȏ̏ꍇAsrc̓kI[ĂKv͂ȂB
 * strcat()ƓAdestɊi[錋ʂ̕͏ɃkI[B
 * srcnoCgȏ̏ꍇAstrncat()destn+1oCg(srcnoCgƏI[̃koCgł)B
 * āAdest̑傫͍Œłstrlen(dest)+n+1łȂ΂ȂȂB */
#ifndef _MSC_VER	//{{2015/05/31:Visual C++ 6.0ReleaserhƁuerror C2169: 'strcat' : gݍ݊֐͒`ł܂BvɂȂ̂ŏO܂B
char* strcat(char* dest, const char* src) {
	return strncat(dest, src, SIZE_MAX);
}
#endif//_MSC_VER	//}}2015/05/31:Visual C++ 6.0ReleaserhƁuerror C2169: 'strcat' : gݍ݊֐͒`ł܂BvɂȂ̂ŏO܂B
char* strncat(char* dest, const char* src, size_t n) {
	char* p = dest;
	while(*p++) { /** no job **/ }
	p--;
	while(n--) { if(!(*p++ = *src++)) { return (char*)dest; } }
	*p++ = '\0';
	return (char*)dest;
}
#else /*PIECE*/
char* strcat(char* dest, const char* src);
char* strncat(char* dest, const char* src, size_t n);
//fȃo[W(15)ƁA1ߐߖo[W(14)쐬܂BTCYD悵Č҂gp邱Ƃɂ܂B
//strcat()strncat()gp悤ȏ́Ax܂dvłȂƂAłǂƎvłB
#if 0
//قCǂfɎo[WłB
asm("
		.code
		.align		1
		.global		strcat
		.global		strncat
strcat:
		ld.w		%r14, -1		;//%r14 := n = SIZE_MAX
strncat:
		ld.w		%r10, %r12		;//%r12 := p = dest
		ld.b		%r9, [%r12]+		;//while(*p++) { /** no job **/ }
		 cmp		%r9, 0
		jrne		-2
		sub		%r12, 1			;//%r12 := p--
strncat_LOOP:
		sub		%r14, 1			;//while(n--) {
		jrult		strncat_TERM
		ld.b		%r9, [%r13]+
		ld.b		[%r12]+, %r9		;//  if(!(*p++ = *src++)) { return dest }
		cmp		%r9, 0
		jrne		strncat_LOOP
		ret					;//}
strncat_TERM:
		ld.b		[%r12], %r8		;//*p = '0'
		ret					;//return dest
");
#else
//1ߐߖ񂵂o[WBᑬłB
asm("
		.code
		.align		1
		.global		strcat
		.global		strncat
strcat:
		ld.w		%r14, -1		;//%r14 := n = SIZE_MAX
strncat:
		ld.w		%r10, %r12		;//%r12 := p = dest
		ld.b		%r9, [%r12]		;//while(*p) { p++ }
		 cmp		%r8, %r9		;//					%psr(C) := %r9 ? 1 : 0
		jrne.d		-2
strncat_LOOP:						;//for(;;) {
		adc		%r12, %r8		;//  if(!) { p++ }			̃[v+1B̃[v̂+0B̃[v+1B	*delay*
		sub		%r14, 1			;//  if(!n--) { break }
		jrult		strncat_TERM
		ld.b		%r9, [%r13]+		;//  if(!(*p = *src++)) { break }
		ld.b		[%r12], %r9
		cmp		%r8, %r9		;//					%psr(C) := %r9 ? 1 : 0
		jrne		strncat_LOOP		;//}
strncat_TERM:
		ld.b		[%r12], %r8		;//*p = '0'				̃[v~ėꍇ́A2nuli[邱ƂɂȂ邪薳B
		ret					;//return dest
");
#endif
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Fri Oct 31 00:45:36 JST 2014 Naoyuki Sawa
 * - strlcpy()ǉ܂B錾́Ainclude/string.hɒǉ܂B
 * uLinux Programmer's Manual - STRCPYv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/strcpy.3.html)p:
 * ̃VXe(BSDASolarisȂ)ł͈ȉ̊֐񋟂ĂB
 *     size_t strlcpy(char *dest, const char *src, size_t size); 
 * ̊֐strncpy()ƓlAőłsize-1oCgdestɃRs[Aւ̏I[̃koCg̒ǉKsAobt@(̖gp)ւ̃koCg݂̏sȂB
 * ̊֐łstrcpy()strncpy()̎̂CĂ邪Asizeꍇɂ̓f[^ɂ́AˑRƂČĂяoőΏKvB
 * ̊֐̕Ԃlsrc̒łBɂA̐؂l߂sꂽȒPɌo邱ƂłBԂlsizeȏ̏ꍇɂ́A̐؂l߂ĂB
 * f[^XƂȂꍇ́AĂяoŁAĂяoOɈ`FbN邩Å֐̕Ԃl邩̂ꂩȂ΂ȂȂB
 * strlcpy()glibcɂ݂͑APOSIXɂWĂȂALinuxłlibbsdCuoRŗpłB */
#ifndef PIECE
size_t strlcpy(char* dst, const char* src, size_t size) {
	size_t len = strlen(src);			//]̒̕߂B
	if(size--) {					//obt@TCY1炷B1炷Õobt@TCY0łȂ΁c
		if(size > len) { size = len; }		//]镶̒߂B
		memcpy(dst, src, size);			//]B
		dst[size] = '\0';			//kI[B
	}
	return len;					//]̒̕ԂB
}
#else /*PIECE*/
size_t strlcpy(char* dst, const char* src, size_t size);
asm("
		.code
		.align		1
		.global		strlcpy
strlcpy:
		pushn		%r2
		ld.w		%r0, %r12		;//%r0  := dst
		ld.w		%r1, %r13		;//%r1  := src
		ld.w		%r2, %r14		;//%r2  := size
		xcall.d		strlen			;//%r10 := len = strlen(src)
		ld.w		%r12, %r1		;//%r12 :=              src			*delay*
		sub		%r2, 1			;//%r2  := size--
		jrult		strlcpy_RET		;//if(size >= 0) {
		ld.w		%r12, %r0		;//  %r12 :=              dst
		ld.w		%r0, %r10		;//  %r0  := len
		cmp		%r2, %r0		;//  if(size > len) {
		jrule.d		3			;//
		 ld.w		%r13, %r1		;//  %r13 :=                   src		*delay*
		 ld.w		%r2, %r0		;//     size = len  }
		xcall.d		memcpy			;//  %r10 := dst = memcpy(dst, src, size)
		ld.w		%r14, %r2		;//  %r14 :=                        size	*delay*
		add		%r10, %r2		;//  %r10 := &dst[size]
		ld.b		[%r10], %r8		;//           dst[size] = 'O'
		ld.w		%r10, %r0		;//  %r10 := len
strlcpy_RET:						;//}
		popn		%r2
		ret
");
#endif/*PIECE*/

/* * Fri Oct 31 00:45:36 JST 2014 Naoyuki Sawa
 * - strlcat()ǉ܂B錾́Ainclude/string.hɒǉ܂B
 * uLinux Programmer's Manual - STRCATv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/strcat.3.html)p:
 * ̃VXe(BSDASolarisȂ)ł͈ȉ̊֐񋟂ĂB
 *     size_t strlcat(char *dest, const char *src, size_t size); 
 * ̊֐́AkI[ꂽsrc𕶎destɒǉB
 * ̗ɂ́Asizestrlen(dest)傫ꍇɂ͍ősize-strlen(dest)-1oCgsrcRs[Aʂ̖ɏI[̃koCgǉB
 * ̊֐łstrcat()̃obt@I[o[Ƃ肪CĂ邪Asizeꍇɂ̓f[^ɂ́AˑRƂČĂяoőΏKvB
 * ̊֐strlcat()쐬悤Ƃ̒ԂBԂlsizeȏ̏ꍇAf[^XĂB
 * f[^XƂȂꍇ́AĂяoŁAĂяoOɈ`FbN邩Å֐̕Ԃl邩̂ꂩȂ΂ȂȂB
 * strlcat()glibcɂ݂͑APOSIXɂWĂȂALinuxłlibbsdCuoRŗpłB */
#ifndef PIECE
size_t strlcat(char* dst, const char* src, size_t size) {
	size_t dlen = strlen(dst);			//]̒̕߂B
	size_t slen = strlen(src);			//]̒̕߂B
	size_t tlen = dlen + slen;			//̒̍v߂B
	if(size > dlen) {				//]̕񂪃obt@ŃkI[Ăc
		size -= dlen;				//(obt@ɒǉ\ȕ+1)߂B
		if(slen >= size) { slen = size - 1; }	//ǉ镶̒߂B
		dst += dlen;				//ǉʒu߂B
		memcpy(dst, src, slen);			//ǉB
		dst[slen] = '\0';			//kI[B
	}
	return tlen;					//̒̍vԂB
}
#else /*PIECE*/
size_t strlcat(char* dst, const char* src, size_t size);
asm("
		.code
		.align		1
		.global		strlcat
strlcat:
		pushn		%r3
		ld.w		%r0, %r12		;//%r0  := dst
		ld.w		%r1, %r13		;//%r1  := src
		xcall.d		strlen			;//%r10 := dlen = strlen(dst)
		ld.w		%r2, %r14		;//%r2  := size					*delay*
		add		%r0, %r10		;//%r0  := dst += dlen
		ld.w		%r3, %r10		;//%r3  := dlen
		xcall.d		strlen			;//%r10 := slen = strlen(src)
		ld.w		%r12, %r1		;//%r12 :=               src			*delay*
		sub		%r2, %r3		;//%r2  := size -= dlen
		jrule.d		strlcat_RET		;//if(size > 0) {
		add		%r3, %r10		;//%r3  := tlen = dlen + slen			*delay*
		cmp		%r10, %r2		;//  if(slen >= size) {
		jrult.d		4			;//
		 ld.w		%r12, %r0		;//  %r12 :=        dst				*delay*
		 ld.w		%r10, %r2		;//    %r10 := slen = size - 1
		 sub		%r10, 1			;//  }
		ld.w		%r13, %r1		;//  %r13 :=             src
		ld.w		%r14, %r10		;//  %r14 :=                  slen
		xcall.d		memcpy			;//  %r10 := memcpy(dst, src, slen)
		add		%r0, %r10		;//  %r0  := &dst[slen]				*delay*
		ld.b		[%r0], %r8		;//           dst[slen] = 'O'
strlcat_RET:						;//}
		ld.w		%r10, %r3		;//%r10 := tlen
		popn		%r3
		ret
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

int
ismbblead(int c)
{
	c &= 0xff; /* bit31-8͖iVC++_ismbblead()ȂĂ܂j */
	return (0x81 <= c && c <= 0x9f) ||
	       (0xe0 <= c && c <= 0xfc);
}

int
ismbbtrail(int c)
{
	c &= 0xff; /* bit31-8͖iVC++_ismbbtrail()ȂĂ܂j */
	return (0x40 <= c && c <= 0x7e) ||
	       (0x80 <= c && c <= /*0xec*/0xfc);
	/* 2002/12/12: VC++6.0tMSDŃA_ismbbtrail()̐͂łB */
	/* 㔼0x80`0xecł́Auv(0x82f1)̓oCgڂł܂B */
}

/*--------------------------------------------------------------------------*/

#ifndef PIECE
#ifndef _MSC_VER	//Visual C++ 6.0CTYPE.H́Aiscsym,iscsymf}N`ĂA`d̂łł͒`ȂB
int iscsym(int c) {
	return isalnum(c) || (c == '_');
}
int iscsymf(int c) {
	return isalpha(c) || (c == '_');
}
#endif//_MSC_VER	//Visual C++ 6.0CTYPE.H́Aiscsym,iscsymf}N`ĂA`d̂łł͒`ȂB
#else /*PIECE*/
/* * Fri Apr 20 11:09:47 JST 2012 Naoyuki Sawa
 * - iscsym()iscsymf()AZu܂B
 */
asm("
		.code
		.align		1
		.global		iscsym
		.global		iscsymf
iscsym:
		xcmp		%r12, 95	;// if(c != '_')
		xjrne		isalnum		;//   return isalnum(c)
		ret.d				;// else
		ld.w		%r10, 1		;//   return 1	*delay*
iscsymf:
		xcmp		%r12, 95	;// if(c != '_')
		xjrne		isalpha		;//   return isalpha(c)
		ret.d				;// else
		ld.w		%r10, 1		;//   return 1	*delay*
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

#ifndef PIECE
int isblank(int c) {
	return (c == ' ') || (c == '\t');
}
#else /*PIECE*/
asm("
		.code
		.align		1
		.global		isblank
isblank:
		;// xcmpŔrƁA' '̔rɁAextgKvɂȂ܂B
		;// subaddgƁAextgsvŁA1ߕł܂B
		sub		%r12, 32	;// if((c -=  ' '        ) == 0) { %psr[Z] = 1 } else
		jreq		2
		 add		%r12, 23	;// if((c += (' ' - '\t')) == 0) { %psr[Z] = 1 } else { %psr[Z] = 0 }
		ld.w		%r10, %psr	;// %r10[1] := %psr[Z]
		ret.d
		and		%r10, 2		;// return     %r10[1] c 0 or 2	*delay*		߂l(0|1)łȂ(0|2)ƂȂ邱ƂɒӁBisblank()̎dlɂ͔ȂB
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

//{{2014/01/13폜:lfind()lsearch()̎Aclippce.cclipsrch.c֕܂B
///* * Sat Jul 04 21:25:58 JST 2009 Naoyuki Sawa
// * - POSIXW̃jAT[`֐łB
// *   VŴ悤ŁAP/ECEJEPSONCuɂ͊܂܂ĂȂ̂ŁAŎ܂B
// *   PȏłA\[g̔zjAT[`(=bsearch()͎gȂ)ꍇ͌\L̂ŁA֗Ǝv܂B
// * - ֐dĺAWeb̎AMSDNȂǂQƂĂB(Visual C++ 6.0MSDNɂڂĂ܂B)
// *   lfind()̈ŁAnum|C^nȂ̂ʂɌ܂A炭Alsearch()ƈ^v߂Ǝv܂B
// *   ܂AbaseAlfind()constAlsearch()͔constłႢɒӂĂB
// *   lfind()͔zύXAlsearch()͌ȂƂɔzɗvfǉ邱ƂA邽߂Ǝv܂B
// *   (̊ɂ́Alfind()̖߂ľ^͔constɂȂĂ_Aѐ܂񂪁c)
// * - lsearch()gāAȒPɁAd̖Zbg쐬邱Ƃł܂B
// *   ȉɁAgp܂B
// *	<>
// *		static int compare(const void* elem1, const void* elem2) {
// *			char* str1 = *(char**)elem1;
// *			char* str2 = *(char**)elem2;
// *			return strcmp(str1, str2);
// *		}
// *		void sample() {
// *			char* set[10];
// *			int num = 0;
// *			char* key;
// *			int i;
// *			if(num < 10) key = "One";   lsearch(&key, set, &num, sizeof set[0], compare);
// *			if(num < 10) key = "Two";   lsearch(&key, set, &num, sizeof set[0], compare);
// *			if(num < 10) key = "One";   lsearch(&key, set, &num, sizeof set[0], compare);
// *			if(num < 10) key = "Three"; lsearch(&key, set, &num, sizeof set[0], compare);
// *			if(num < 10) key = "Two";   lsearch(&key, set, &num, sizeof set[0], compare);
// *			if(num < 10) key = "Four";  lsearch(&key, set, &num, sizeof set[0], compare);
// *			for(i = 0; i < num; i++) { printf("%d: %s\n", i, set[i]); }
// *		}
// *	<>
// *		0: One
// *		1: Two
// *		2: Three
// *		3: Four
// */
//void*
//lfind(const void* key, const void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2))
//{
//	int i = *num;
//	while(i) {
//		if(!(*compare)(key, base)) {
//			return (void*)base;
//		}
//		base = (char*)base + width;
//		i--;
//	}
//	return NULL;
//}
//void*
//lsearch(const void* key, void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2))
//{
//	void* ptr = lfind(key, base, num, width, compare);
//	if(!ptr) {
//		ptr = memcpy((char*)base + ((*num)++ * width), key, width);
//	}
//	return ptr;
//}
//}}2014/01/13폜:lfind()lsearch()̎Aclippce.cclipsrch.c֕܂B

/* * Sat Jul 04 21:25:58 JST 2009 Naoyuki Sawa
 * - ׋̂ߎŎĂ݂܂Absearch()P/ECEJEPSONCuɂ܂܂ĂAȉ̃R[hƑSłB
 *   ȉ̃R[hclippce.cɊ܂߂ĂƁAAvP[VɏɃNăR[hTCYʂɂȂ̂ŁARgAEg܂B
 *   ȂAVisual C++ 6.0ɂbsearch()̃\[X܂܂ĂAQlɂł܂AEPSONCu(=ȉ̃R[hƓ)̕ȌłB
 */
//	void*
//	bsearch(const void* key, const void* base, size_t num, size_t width, int (*compare)(const void* elem1, const void* elem2))
//	{
//		while(num) {
//			char* mid = (char*)base + ((num >> 1) * width);
//			int retval = (*compare)(key, mid);
//			if(retval >= 0) {
//				if(!retval) {
//					return mid;
//				}
//				base = mid + width;
//				num--;
//			}
//			num >>= 1;
//		}
//		return NULL;
//	}

/*--------------------------------------------------------------------------*/

/* * Mon Jul 06 23:33:17 JST 2009 Naoyuki Sawa
 * - strupr()strlwr()́AW֐ǂ悭킩炸AVC++LȂ̂m܂B
 *   Web̎琄ƁAUnix̃Cuɂ͊܂܂ĂȂ(?)悤łB
 *   P/ECEJEPSONCuɂAstrupr()strlwr()́A܂܂Ă܂B
 *   ֗Ȃ̂ŁA`ĂƂɂ܂B
 * - strupr()strlwr()̃R[h͏̂ŁAʂȃR[hTCỶe͋͂łB
 *   tolower()ĂяoĂ܂Atolower()͊ɖ{W[ŎgpĂ̂ŁAVȃR[h͐܂B
 *   toupper()ĂяoĂ܂Atoupper()͕K{clipprnt.cŎgpĂ̂ŁAVȃR[h͐܂B
 */
//#ifndef PIECE
//char* strupr(char* string) {
//	int c;
//	char* p = string;
//	while((c = *p)) {
//		*p++ = toupper(c);
//	}
//	return string;
//}
//char* strlwr(char* string) {
//	int c;
//	char* p = string;
//	while((c = *p)) {
//		*p++ = tolower(c);
//	}
//	return string;
//}
//#else /*PIECE*/
//char* strupr(char* string);
//char* strlwr(char* string);
//asm("
//		.code
//		.align		1
//		.global		strupr
//		.global		strlwr
//strupr:
//		xld.w		%r13, toupper		;// %r13 := fn = toupper
//		jp		strupr_strlwr
//strlwr:
//		xld.w		%r13, tolower		;// %r13 := fn = tolower
//strupr_strlwr:
//		pushn		%r2
//		ld.w		%r0, %r12		;// %r0  := string
//		ld.w		%r1, %r12		;// %r1  := p
//		ld.w		%r2, %r13		;// %r2  := fn
//strupr_strlwr_LOOP:					;// for(;;) {
//		ld.b		%r12, [%r1]		;//   %r12 := c = *p
//		cmp		%r12, 0			;//   if(!c)
//		jreq		strupr_strlwr_RET	;//     break
//		call		%r2			;//   %r10 := c = fn(c)
//		ld.b		[%r1]+, %r10		;//   *p++ := c
//		jp		strupr_strlwr_LOOP	;// }
//strupr_strlwr_RET:
//		ld.w		%r10, %r0		;// %r10 := string
//		popn		%r2
//		ret
//");
//#endif /*PIECE*/
//---------------------------------------------------------------------------------------------------------------------
// * Sat Dec 25 12:48:38 JST 2010 Naoyuki Sawa
// - strupr()strlwr()ŁASp܂ޕϊƁA邱ƂC܂B
// - ܂ł̔łł́AƂ΁ueLXgvƂAtoupper()ŕϊƁuELXGvɂȂĂ܂Ă܂B
//   uev2oCgڂuevƌȂāuEvɁAugv2oCgڂugvƌȂāuEvɕϊĂ܂Ă߂łB
// - ̏CɂāASp܂ޕAstrupr()strlwr()Őϊł悤ɂȂ܂B
// - ȂAstrupr()strlwr()őSṕAVisual C++ 6.0ABorland C++ 5.5.1̃Cuł܂B
//   WindowsvO~O̍ۂɂ́ACĂB
//   ̈́AMFCCString::MakeUpper()gƂłBVisual C++ 6.0MFCŁAȂƂmF܂B
//---------------------------------------------------------------------------------------------------------------------
#ifndef PIECE
char* strupr(char* string) {
	char* p = string;
	for(;;) {
		/* SpȂ΁Aϊɔ΂B
		 * - 1oCgڂismbblead()trueȂ΁A2oCgڂ𒲂ׂȂĂSpƔfł̂łA
		 *   ꂽ2oCgڂnulꍇɁAobt@I[o[邨ꂪ邽߁A
		 *   SāA2oCgڂismbbtrail()trueł邱ƂmF邱Ƃɂ܂B
		 */
		if(ismbblead(p[0]) && ismbbtrail(p[1])) {
			p += 2;
		/* pȂ΁AϊBI[甲B
		 * - toupper()nulϊȂ̂ŁAI[`FbNtoupper()ɍsĂɍsĂłB
		 *   toupper()ōsAAsmɏ[vg݈Ղ߁AōsƂɂ܂B
		 */
		} else {
			if(!(*p = toupper(*p))) break;
			p += 1;
		}
	}
	return string;
}
char* strlwr(char* string) {
	char* p = string;
	for(;;) {
		/* SpȂ΁Aϊɔ΂B
		 * - 1oCgڂismbblead()trueȂ΁A2oCgڂ𒲂ׂȂĂSpƔfł̂łA
		 *   ꂽ2oCgڂnulꍇɁAobt@I[o[邨ꂪ邽߁A
		 *   SāA2oCgڂismbbtrail()trueł邱ƂmF邱Ƃɂ܂B
		 */
		if(ismbblead(p[0]) && ismbbtrail(p[1])) {
			p += 2;
		/* pȂ΁AϊBI[甲B */
		} else {
			if(!(*p = tolower(*p))) break;
			p += 1;
		}
	}
	return string;
}
#else /*PIECE*/
char* strupr(char* string);
char* strlwr(char* string);
asm("
		.code
		.align		1
		.global		strupr
		.global		strlwr
strupr:
		xld.w		%r13, toupper		;// %r13 := fn = toupper
		jp		strupr_strlwr
strlwr:
		xld.w		%r13, tolower		;// %r13 := fn = tolower
strupr_strlwr:
		pushn		%r2
		ld.w		%r0, %r12		;// %r0  := string
		ld.w		%r1, %r12		;// %r1  := p
		ld.w		%r2, %r13		;// %r2  := fn
		;//-------------------------------------;//
strupr_strlwr_LOOP:					;// for(;;) {
		xld.b		%r12, [%r1+0]		;//   %r12 :=        p[0]
		xcall		ismbblead		;//   if(!ismbblead (p[0])) goto SINGLE
		cmp		%r10, 0
		jreq		strupr_strlwr_SINGLE
		;//
		xld.b		%r12, [%r1+1]		;//   %r12 :=        p[1]
		xcall		ismbbtrail		;//   if(!ismbbtrail(p[1])) goto SINGLE
		cmp		%r10, 0
		jreq		strupr_strlwr_SINGLE
		;//
		jp.d		strupr_strlwr_LOOP	;//   continue
		add		%r1, 2			;//   p += 2	*delay*
strupr_strlwr_SINGLE:
		ld.b		%r12, [%r1]		;//   %r12 :=    *p
		call		%r2			;//   %r10 := fn(*p)
		ld.b		[%r1]+, %r10		;//   *p   := fn(*p)
		;//
		cmp		%r10, 0			;//   if(!*p) break
		jrne		strupr_strlwr_LOOP
		;//-------------------------------------;//
strupr_strlwr_RET:					;// }
		ld.w		%r10, %r0		;// %r10 := string
		popn		%r2
		ret
");
#endif /*PIECE*/

/*--------------------------------------------------------------------------*/

/* * Wed Apr 29 14:30:43 JST 2015 Naoyuki Sawa
 *  - memccpy(),mempcpy(),strncpy(),stpncpy(),strcpy(),stpcpy()ǉ܂B
 *    錾́Ainclude/string.hɒǉ܂B
 *  - strncpy()strcpy()́AP/ECEJEPSONCuɂ܂܂Ă܂AōĎ܂B
 *    stpncpy()stpcpy()Ƌʉł镔A܂Ƃ߂ĎR[hTCYߖł邩łB
 */

//uLinux Programmer's Manual (3) - MEMCCPYv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/memccpy.3.html)p:
//O
//memccpy - [̈Rs[
//
//memccpy()́A[̈src烁[̈destɍőnoCg̃Rs[sB
//noCgRs[OɕcƁAŃRs[𒆎~B
//Rs[ƃRs[̃[̈悪dȂĂꍇAʂ͕słB
//Ԃl
//memccpy()́AdestɌc̎ɂLN^[^̕ϐw|C^[ԂB
//ȂꍇANULLԂB
//
//SVr4,4.3BSD,POSIX.1-2001.
#ifndef PIECE
void* memccpy(void* dest, const void* src, int c, size_t n) {
	      unsigned char* d = dest;
	const unsigned char* s = src;
	do {
		if(!n--) { return NULL; }
	} while((*d++ = *s++) != c);
	return d;
}
#else //PIECE
void* memccpy(void* dest, const void* src, int c, size_t n);
asm("
		.code
		.align		1
		.global		memccpy
memccpy:
		ld.w		%r10, 0			;//%r10 := NULL
memccpy_LOOP:						;//do {
		sub		%r15, 1			;//  %r15 := n--
		jrult		memccpy_RET		;//  if(n < 0) { return NULL }
		ld.ub		%r9, [%r13]+		;//  %r9  := t = *src++
		ld.b		[%r12]+, %r9		;//  *dest++ = t
		cmp		%r9, %r14		;//} while(t != c)
		jrne		memccpy_LOOP		;//
		ld.w		%r10, %r12		;//%r10 := dest
memccpy_RET:						;//
		ret					;//return  dest
");
#endif//PIECE

//uLinux Programmer's Manual (3) - MEMPCPYv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/mempcpy.3.html)p:
//O
//mempcpy - [̈Rs[
//
//mempcpy()֐memcpy()֐ƂقړłB
//̊֐́AsrcŎn܂IuWFNgnoCgAdestŎwIuWFNgɃRs[B
//dest̒lԂ̂ł͂ȂAŌɏ܂ꂽoCǧɑoCgւ̃|C^[ԂB
//̊֐͂̃IuWFNgAIȃ[̏ꏊɃRs[悤ȏ󋵂ŖɗB
//Ԃl
//dest+n.
//
//̊֐GNUɂgłB
#ifndef PIECE
void* mempcpy(void* dest, const void* src, size_t n) {
	return (char*)memcpy(dest, src, n) + n;
}
#else //PIECE
void* mempcpy(void* dest, const void* src, size_t n);
asm("
		.code
		.align		1
		.global		mempcpy
mempcpy:
		pushn		%r0			;//
		xcall.d		memcpy			;//%r10 := dest = memcpy(dest, src, n)
		ld.w		%r0, %r14		;//%r0  := n				*delay*
		add		%r10, %r0		;//%r10 := dest + n
		popn		%r0			;//
		ret					;//return  dest + n
");
#endif//PIECE

//uLinux Programmer's Manual (3) - STPNCPYv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/stpncpy.3.html)p:
//O
//stpncpy - Œ蒷̕Rs[āA̍Ōւ̃|C^[Ԃ
//
//stpncpy()֐srcwĂ镶񂩂I[̃koCg('\0')܂߂čőnoCgdestɃRs[B
//strlen(src)n菬ꍇɂdest̎c̕ɂ̓koCg('\0')߂B
//strlen(src)nȏȂ΁Adestw̓kŏI[ĂȂB
//̕͏dȂĂ͂ȂȂB
//vO}[destɏȂƂnoCg̋󂫂邱Ƃۏ؂Ȃ΂ȂȂB
//Ԃl
//stpncpy()dest̏I[̃koCgw|C^[ԂAdestkoCgŏI[ĂȂꍇɂdest+nԂB
//
//̊֐POSIX.1-2008ɒǉꂽB
//ȑOGNUɂgłB
//̊֐1993NGNU CCũo[W1.07ŏ߂ēoꂵB
#ifndef PIECE
char* strncpy(char* dest, const char* src, size_t n) {
	char*  save_dest = dest;
	stpncpy(dest, src, n);
	return save_dest;
}
char* stpncpy(char* dest, const char* src, size_t n) {
	char* save_dest;
	do {
		if(!n--) { return dest; }
	} while((*dest++ = *src++));
	save_dest = dest - 1;
	goto L_START;
	do {
		*dest++ = '\0';
L_START:	;
	} while(n--);
	return save_dest;
}
#else //PIECE
char* strncpy(char* dest, const char* src, size_t n);
char* stpncpy(char* dest, const char* src, size_t n);
asm("
		.code
		.align		1
		.global		strncpy
		.global		stpncpy
strncpy:
		call		stpncpy			;//%r12 := save_dest = dest
		ret.d					;//return  save_dest		
stpncpy:						;//				
		ld.w		%r10, %r12		;//%r10 := dest				*delay*
stpncpy_LOOP:						;//do {
		sub		%r14, 1			;//  %r14 := n--
		jrult		stpncpy_RET		;//  if(n < 0) { return dest }
		ld.ub		%r9, [%r13]+		;//  %r9  := c = *src++
		ld.b		[%r10]+, %r9		;//  *dest++ = c
		cmp		%r9, 0			;//  
		jrne		stpncpy_LOOP		;//} while(c)
		ld.w		%r9, %r10		;//%r9  := dest
		jp.d		stpncpy_START		;//goto L_START
		sub		%r10, 1			;//%r10 := save_dest = dest - 1		*delay*
stpncpy_FILL:						;//do {
		ld.b		[%r9]+, %r8		;//  *dest++ = '0'
stpncpy_START:						;//L_START:
		sub		%r14, 1			;//  %r14 := n--
		jruge		stpncpy_FILL		;//} while(  n)
stpncpy_RET:						;//
		ret					;//return  save_dest
");
#endif//PIECE

//uLinux Programmer's Manual (3) - STPCPYv(http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/stpcpy.3.html)p:
//O
//stpcpy - Rs[ARs[̏Iւ̃|C^[Ԃ
//
//stpcpy()֐́AsrcŎwꂽ(I[koCg('\0')܂߂)destŎwꂽzɃRs[B
//͏dĂ͂Ȃ炸ARs[̕dest̓Rs[󂯎̂ɏ\傫ȂĂ͂ȂȂB
//Ԃl
//stpcpy()́Adest̎n܂ł͂ȂIw|C^[(Ȃ킿AI[koCg)ԂB
//
//̊֐POSIX.1-2008ɒǉꂽB
//ȑÓÅ֐CPOSIX.1ẄꕔłUNIXVXe̊KIȂ̂łȂB
//̊֐LatticeCAmigaDOSRpCŏ߂ēoꂵA͏ȂƂ1986N_ł͂łB
//̌A1989NGNUfileutilsGNU textutilsɓoꂵA1992N܂łɂGNU CCuɂ݂ĂB
//̊֐BSDnɂ݂B
#ifndef PIECE
#ifndef _MSC_VER	//{{2015/05/31:Visual C++ 6.0ReleaserhƁuerror C2169: 'strcpy' : gݍ݊֐͒`ł܂BvɂȂ̂ŏO܂B
char* strcpy(char* dest, const char* src) {
	char*  save_dest = dest;
	stpcpy(dest, src);
	return save_dest;
}
#endif//_MSC_VER	//}}2015/05/31:Visual C++ 6.0ReleaserhƁuerror C2169: 'strcpy' : gݍ݊֐͒`ł܂BvɂȂ̂ŏO܂B
char* stpcpy(char* dest, const char* src) {
	do { /** no job **/ } while((*dest++ = *src++));
	return dest - 1;
}
#else //PIECE
char* strcpy(char* dest, const char* src);
char* stpcpy(char* dest, const char* src);
asm("
		.code
		.align		1
		.global		strcpy
		.global		stpcpy
strcpy:
		call		stpcpy			;//%r12 := save_dest = dest
		ret.d					;//return  save_dest		
stpcpy:							;//				
		ld.w		%r10, %r12		;//%r10 := dest				*delay*
stpcpy_LOOP:						;//do {
		ld.ub		%r9, [%r13]+		;//  %r9  := c = *src++
		ld.b		[%r10]+, %r9		;//  *dest++ = c
		cmp		%r9, 0			;//} while(c)
		jrne		stpcpy_LOOP		;//
		ret.d					;//return  dest - 1
		sub		%r10, 1			;//%r12 := dest - 1			*delay*
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

/* * Thu Jul 09 00:22:54 JST 2009 Naoyuki Sawa
 * - VC++6.0_splitpath()Aقڂ̂܂܈ڐA܂B
 */
void
splitpath(const char* path, char drive[/*MAX_DRIVE*/], char dir[/*MAX_DIR*/], char fname[/*MAX_FNAME*/], char ext[/*MAX_EXT*/])
{
	const char* sep;
	const char* dot;
	const char* p;
	int len;

	/* pX2ȏŁA2ڂ':'Ȃ΁Aŏ2hCuB */
	if((path[0] != '\0') && (path[1] == ':')) {
		if(drive) {
			memcpy(drive, path, 2);
			drive[2] = '\0';
		}
		path += 2; /* pathhCu̎֐i߂ */
	} else {
		if(drive) {
			drive[0] = '\0';
		}
	}

	/* Ō̋؂蕶̎̈ʒuƁAŌ̃hbg̈ʒu܂B */
	sep = dot = NULL;
	for(p = path; *p; p++) {
		if((*p == '/') || (*p == '\\')) {
			sep = p + 1; /* ؂蕶̎̈ʒu */
		} else if(*p == '.') {
			dot = p;     /* hbg̈ʒu */
		}
	}

	/* ؂蕶L΁AŌ̋؂蕶܂߂ăfBNgi[B */
	if(sep) {
		if(dir) {
			len = sep - path;
			if(len > (MAX_DIR - 1)) {
				len = (MAX_DIR - 1);
			}
			memcpy(dir, path, len);
			dir[len] = '\0';
		}
		path = sep; /* patht@C̐擪֐i߂ */
	} else {
		if(dir) {
			dir[0] = '\0';
		}
	}

	/* t@C̐擪ɁAhbgL΁c */
	if(dot >= path) { /* ̏ !dot Oł܂B */
		/* hbg̑O܂ŁAt@CƂĊi[B */
		if(fname) {
			len = dot - path;
			if(len > (MAX_FNAME - 1)) {
				len = (MAX_FNAME - 1);
			}
			memcpy(fname, path, len);
			fname[len] = '\0';
		}
		/* hbgŌ܂ŁAgqƂĊi[B */
		if(ext) {
			len = p/*[*/ - dot;
			if(len > (MAX_EXT - 1)) {
				len = (MAX_EXT - 1);
			}
			memcpy(ext, dot, len);
			ext[len] = '\0';
		}
	} else {
		/* cׂ̕āAt@CƂĊi[B */
		if(fname) {
			len = p/*[*/ - path;
			if(len > (MAX_FNAME - 1)) {
				len = (MAX_FNAME - 1);
			}
			memcpy(fname, path, len);
			fname[len] = '\0';
		}
		if(ext) {
			ext[0] = '\0';
		}
	}
}

/* * Thu Jul 09 00:22:54 JST 2009 Naoyuki Sawa
 * - VC++6.0_makepath()AύXĈڐA܂B
 *   VC++6.0_makepath()́Apath[MAX_PATH]ւ̊i[`FbNĂ炸AMAX_PATH𒴂Ăi[Ă܂܂B
 *   ȉ̃R[h́Apath[MAX_PATH]ւ̊i[AI['\0'(MAX_PATH-1)ȉɐ؂l߂悤ύX܂B
 */
void
makepath(char path[/*MAX_PATH*/], const char* drive, const char* dir, const char* fname, const char* ext)
{
	char* path_end = &path[MAX_PATH - 1];

	/* hCu1ȏw肳ĂAhCui[B */
	if(drive && *drive) {
		*path++ = *drive;
		//if(path == path_end) goto L_EXIT; /* L蓾Ȃ */
		*path++ = ':'; /* 2ڂ':'Œ */
		//if(path == path_end) goto L_EXIT; /* L蓾Ȃ */
	}

	/* fBNg1ȏw肳ĂAfBNgi[B */
	if(dir && *dir) {
		do {
			*path++ = *dir++;
			if(path == path_end) goto L_EXIT;
		} while(*dir);
		/* ̋؂蕶ȗĂA؂蕶₤B
		 * - fBNgɋ󕶎񂪎w肳ꂽꍇ(dir="")́A؂蕶ȂƂɒӁB
		 *   󕶎(dir="")ɑ΂ċ؂蕶Ă܂ƁAȉ̂悤ȃoOB
		 *     splitpath("xxx.yyy", drive, dir, fname, ext); -> drive = "", dir = "", fname = "xxx", ext = ".yyy"
		 *     makepath(path, drive, dir, fname, ext);       -> path = "\xxx.yyy" (pathɖ'\'oO)
		 */
		if((*(path - 1) != '/') && (*(path - 1) != '\\')) {
			*path++ = '\\';
			if(path == path_end) goto L_EXIT;
		}
	}

	/* t@Ci[B */
	if(fname) {
		while(*fname) {
			*path++ = *fname++;
			if(path == path_end) goto L_EXIT;
		}
	}

	/* gqi[B */
	if(ext) {
		if(*ext != '.') {
			*path++ = '.'; /* 擪̃hbgȗĂAhbg₤ */
			if(path == path_end) goto L_EXIT;
		}
		while(*ext) {
			*path++ = *ext++;
			if(path == path_end) goto L_EXIT;
		}
	}
L_EXIT:
	*path = '\0'; /* I[ */
}

/*--------------------------------------------------------------------------*/

/* [h̒ōŏɃZbgĂŉʃrbg̈ʒuԂ܂B(Find first set)
 * [in]
 *	i	[h
 * [out]
 *	߂l	(i = ???????? ???????? ???????? ???????1 ̎)   1 c ŉʃrbg 1
 *		(i = ???????? ???????? ???????? ??????10 ̎)   2
 *		(i = ???????? ???????? ???????? ?????100 ̎)   3
 *		                  (   )
 *		(i = ?1000000 00000000 00000000 00000000 ̎)  31
 *		(i = 10000000 00000000 00000000 00000000 ̎)  32 c ŏʃrbg32
 *		(i = 00000000 00000000 00000000 00000000 ̎)   0 c [h0Ȃ0
 * [note]
 *	- {֐́Affs(): 4.3BSD, POSIX.1-2001. łB
 *	  Q: Linux Programmer's Manual (3) FFS
 *	        http://linuxjm.sourceforge.jp/html/LDP_man-pages/man3/ffs.3.html
 *	- P/ECẼRpCgcc33́A__builtin_ffsF܂ACCWJ܂B
 *	  gcc33́A__builtin_ffsƁAffs֐ĂяoR[h𐶐悤łB
 *	  ܂AvO__builtin_ffsĝffsĝ́AłB
 */
#ifndef PIECE
//----------------------------------------------------------------------------
//C
//----------------------------------------------------------------------------
int ffs(int i) {
	int n;
	for(n = 1; n <= 32; n++) {
		if((i & 1) != 0) {
			return n;
		}
		i >>= 1;
	}
	return 0;
}
#else /*PIECE*/
//----------------------------------------------------------------------------
//AZuŇ@
//łAR[hTCY傫ȎłB
//----------------------------------------------------------------------------
//asm("
//		.code
//		.align		1
//		.global		ffs
//ffs:
//		swap		%r12, %r12	;//          +-- ]̒lŤ1ŏʃrbgɗL鎞                                             ]̒lŤ1ŉʃrbgɗL鎞 --+   +-- 1
//		mirror		%r12, %r12	;//          |                                                                                                                           |   |
//		scan1		%r10, %r12	;// %r10 :=  0   1   2   3   4   5   6   7   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8
//		sll		%r12, %r10
//		scan1		%r11, %r12	;// %r11 :=  0   0   0   0   0   0   0   0   0   1   2   3   4   5   6   7   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8   8
//		sll		%r12, %r11
//		add		%r10, %r11	;// %r10 :=  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  16  16  16  16  16  16  16  16  16  16  16  16  16  16  16  16
//		scan1		%r11, %r12	;// %r11 :=  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   1   2   3   4   5   6   7   8   8   8   8   8   8   8   8   8
//		sll		%r12, %r11
//		add		%r10, %r11	;// %r10 :=  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  24  24  24  24  24  24  24  24
//		scan1		%r11, %r12	;// %r11 :=  0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   0   1   2   3   4   5   6   7   8
//		jruge.d		3
//		 add		%r10, %r11	;// %r10 :=  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32	*delay*
//		 ld.w		%r10, -1
//		ret.d
//		add		%r10, 1		;// %r10 :=  1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32   0
//");
//----------------------------------------------------------------------------
//AZuŇA
//ᑬŁAȃȎłB
//ffs()͎gppxႭAsx͏dvłȂ̂ŁA̕ǂłB
//----------------------------------------------------------------------------
//asm("
//		.code
//		.align		1
//		.global		ffs
//ffs:
//		cmp		%r12, 0		;// if(i != 0) {
//		jreq.d		7
//		 ld.w		%r10, 0		;// %r10 := n = 0						*delay*
//		 swap		%r12, %r12	;//   %r12 := i = ](i)
//		 mirror		%r12, %r12
//		  add		%r12, %r12	;//   do { %psr(C) := i[31], %r12 := i <<= 1, %r10 := n++
//		 jruge.d	-1		;//   } while(%psr(C) == 0)
//		 add		%r10, 1		;// }								*delay*
//		ret				;// return n
//");
//----------------------------------------------------------------------------
//AZuŇB
//ɒᑬŁAɏȃȎłB
//@HvāAꖽߐߖ񂵂܂B
//----------------------------------------------------------------------------
asm("
		.code
		.align		1
		.global		ffs
ffs:
		cmp		%r12, 0		;// if(i != 0) {
		jreq.d		6
		 ld.w		%r10, 0		;// %r10 := n = 0			*delay*
		  sll		%r12, 1		;//   do { %r12 := i <<= 1, %r10 := n++
		 jrne.d		-1		;//   } while(i != 0)
		 sub		%r10, 1		;//					*delay*
		 add		%r10, 33	;// %r10 := n += 33  (-1`-32)(32`1)
		ret				;// return n
");
#endif/*PIECE*/

/*--------------------------------------------------------------------------*/

#ifdef  PIECE
//{{2014/09/29ǉ:malloc_usable_size()ǉ܂B
size_t malloc_usable_size(void* ptr) {
	//                              |               |
	//  (((HEAPMEM*)ptr)-1)         +===============+
	//                              | mark  | owner |
	//                              +---------------|
	//                              |     chain     |
	//              ptr             +---------------+
	//               A              |///////////////|
	//               |              |///////////////|
	//               |size          |///////////////|
	//               |              |///////////////|
	//               V              |///////////////|
	// ((((HEAPMEM*)ptr)-1)->chain) +===============+
	//                              | mark  | owner |
	//                              +---------------|
	//                              |     chain     |
	//                              +---------------+
	//                              |               |
	return ptr ? ((int)((((HEAPMEM*)ptr)-1)->chain) - (int)ptr) : 0;
}
//}}2014/09/29ǉ:malloc_usable_size()ǉ܂B
#else //PIECE
#ifdef  GC_H
size_t malloc_usable_size(void* ptr) {	//Visual C++ 6.0 with Boehm GC
	//Boehm GCgpƁAmalloc()̓ubN̓r(=Ǘ̌)̃|C^ԂB
	//GC_size()́AubN̓rw肳ĂAubN̑Ŝ̃TCYԂB
	//malloc()Ԃ|C^ȍ~̃TCY𓾂ɂ́Aȉ̂悤ɌvZȂĂ͂ȂȂB(萄)
	return ptr ? (GC_size(ptr) - ((int)ptr - (int)GC_base(ptr))) : 0;
}
#else //GC_H
size_t malloc_usable_size(void* ptr) {	//Visual C++ 6.0 without Boehm GC
	return ptr ? _msize(ptr) : 0;
}
#endif//GC_H
#endif//PIECE

/*--------------------------------------------------------------------------*/

// * Tue Mar 24 21:38:35 JST 2015 Naoyuki Sawa
// - EPSONCubsearch()u܂B
//   EPSONCubsearch()̂܂܂ł薳̂łACŎĂĐR[hɏʂL܂B
//   AZu鎖ɂāA68oCg60oCgɂȂA8oCg̃TCYߖɂȂ܂B
//   AZuɂ鍂̌ʂ́Ar֐̏Ԃ܂߂Ȃ΁A15%̍łB
#ifndef PIECE
void* bsearch(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*)) {
	const unsigned char* base = _base;
	goto L_START;
	do {
		const unsigned char* mid = base + ((nmemb >> 1) * size);
		int retVal = (*compar)(key, mid);
		if(retVal == 0) { return (void*)mid; }
		if(retVal >  0) {
			base = mid + size;
			nmemb--;
		}
		nmemb >>= 1;
L_START:	;
	} while(nmemb);
	return NULL;
}
#else //PIECE
void* bsearch(const void* key, const void* _base, size_t nmemb, size_t size, int (*compar)(const void*, const void*));
asm("
		.code
		.align		1
		.global		bsearch
bsearch:
		pushn		%r3
		xsub		%sp, %sp, 4
		ld.w		[%sp+0], %r12		;//[%sp+0] := key
		ld.w		%r0, %r13		;//%r0     := base
		ld.w		%r1, %r14		;//%r1     := nmemb
		ld.w		%r2, %r15		;//%r2     := size
		jp.d		bsearch_START		;//goto L_START
		cmp		%r1, 0			;//%psr(Z) := !nmemb				*delay*
bsearch_LOOP:						;//do {						
		;//%r0      := base									
		;//%r1      := nmemb									
		;//%r2      := size									
		;//%r10     := nmemb>>1									
		;//[%sp+ 0] := key									
		;//[%sp+ 4] := %r0									
		;//[%sp+ 8] := %r1									
		;//[%sp+12] := %r2									
		;//[%sp+16] := %r3									
		;//[%sp+20] := %pc									
		;//[%sp+24] := compar									
		mlt.w		%r10, %r2		;//  %alr :=             (nmemb>>1)*size	
		ld.w		%r3, %alr		;//  %r3  :=             (nmemb>>1)*size	
		add		%r3, %r0		;//  %r3  := mid = base+((nmemb>>1)*size)	
		xld.w		%r9, [%sp+24]		;//  %r9  := compar				
		xld.w		%r12, [%sp+0]		;//  %r12 := key				
		call.d		%r9			;//  %r10 := retVal = (*compar)(key, mid)	
		ld.w		%r13, %r3		;//  %r13 :=                         mid		*delay*
		cmp		%r10, 0			;//  						
		jreq		bsearch_FOUND		;//  if(retVal == 0) { return mid }		
		jrlt		4			;//  if(retVal >  0) {				
		 ld.w		%r0, %r3		;//    %r0  :=        mid			
		 add		%r0, %r2		;//    %r0  := base = mid + size		
		 sub		%r1, 1			;//    %r1  := nmemb-- }			
		srl		%r1, 1			;//  %r1  := nmemb >>= 1		
bsearch_START:						;//  						
		ld.w		%r10, %r1		;//  %r10 :=              nmemb			
		jrne.d		bsearch_LOOP		;//} while(nmemb)			
		srl		%r10, 1			;//  %r10 :=              nmemb>>1			*delay*
bsearch_RET:						;//
		xadd		%sp, %sp, 4
		popn		%r3
		ret
bsearch_FOUND:
		jp.d		bsearch_RET		;//return  mid
		ld.w		%r10, %r3		;//%r10 := mid						*delay*
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

// * Sat Jul 25 17:20:54 JST 2015 Naoyuki Sawa
// - log2()ǉ܂B錾́Ainclude/math.h ɗL܂Blog2()́AC99Œǉꂽ֐łBuLua 5.3.1vAgpĂ܂B
//   EPSONCuɂAVisual C++ 6.0ɂAlog2()͊܂܂Ă܂B
double log2(double x) {
	return log(x) / 0.69314718055994530941723212145818/*=log(2)*/;
}

/*--------------------------------------------------------------------------*/

// * Sat Oct 10 21:38:51 JST 2015 Naoyuki Sawa
// - /usr/PIECE/include/setjmp.h$(CLIP)/include/setjmp.hɃRs[āAjmp_buf[]̒`C܂Bڍׂ͉LQƂĉB
//   /usr/PIECE/include/setjmp.h$(CLIP)/include/setjmp.hD悳悤ɁAclip.mk̒ŃCN[hpXݒ肵Ă܂B
// - cliplibc.c̒setjmp(),longjmp()āAEPSONCu̓̊֐u܂B
//   EPSONCuł̊֐́AۑKv̖WX^ۑĂāAʂLłB
// - EPSONCuł̊֐́A%alr,%ahr,%psrۑĂ܂AۑKv͗L܂B
//   ֐ĂяȏOŁA%alr,%ahr,%psrۑKv͖Asetjmp()longjmp()lłB
// - EPSONCuł̊֐%psrۑĂ̂́A荞݃x⊄荞݋tO̕Ӑ}Ă̂m܂񂪁A
//   ۂɊ荞݃T[rX[`̒longjmp()Ŕ鎖͂ȂƎv̂ŁAsvƎv܂B
//   ɂӐ}ƂĂA荞݃T[rX[`̒甲鎞%psr(I)%psr(IL)߂ł͕s\ŁA
//   荞݃Rg[(ITC)̐ݒKvŁACPŮ荞݃x⊄荞݋tO𕜌邾ł͕s\łB
//   vɁAsetjmp()longjmp()%psrۑĂʂȂ̂ŁA%psr̕ۑ͕KvƔf܂B
// - EPSONCułsetjmp.hŒ`Ăjmp_buf[]ɂAʂL܂B
//   EPSONCuł̊֐́A9̒lۑĂ̂jmp_buf[9]ő̂ɁAjmp_buf[16]ƂȂĂ܂B
//   ̊֐́AŒ6̒lۑ悤ɂ̂ŁAjmp_buf[6]Ƃ܂B
// - ȏ̕ύXɂāAjmp_buf64oCg24oCgɂȂA40oCg̃ߖɂȂ܂B
//   ɁAjmp_bufX^bNɊmۂ鎞ɁAX^bNߖoʂ傫Ǝv܂B
#ifdef  PIECE
int setjmp(jmp_buf env);
void longjmp(jmp_buf env, int val);
asm("
		.code
		.align	1
		.global		setjmp
		.global		longjmp
setjmp:
		;//%r12 := env
		ld.w		%r4, %sp		;//%r4     := %sp
		ld.w		%r5, [%r4]+		;//%r5     := retp, %r4 := %sp+4
		ld.w		[%r12]+, %r0		;//env[0]  := %r0
		ld.w		[%r12]+, %r1		;//env[1]  := %r1
		ld.w		[%r12]+, %r2		;//env[2]  := %r2
		ld.w		[%r12]+, %r3		;//env[3]  := %r3
		ld.w		[%r12]+, %r4		;//env[4]  := %sp+4
		ld.w		[%r12]+, %r5		;//env[5]  := retp
		ret.d					;//return     0
		ld.w		%r10, 0			;//%r10    := 0				*delay*
longjmp:
		;//%r12 := env
		;//%r13 := val
		ld.w		%r0, [%r12]+		;//%r0     := env[0]
		ld.w		%r1, [%r12]+		;//%r1     := env[1]
		ld.w		%r2, [%r12]+		;//%r2     := env[2]
		ld.w		%r3, [%r12]+		;//%r3     := env[3]
		ld.w		%r4, [%r12]+		;//%r4     := env[4]
		ld.w		%r5, [%r12]+		;//%r5     := env[5]
		ld.w		%sp, %r4		;//%sp+4   := %r4
		ld.w		%r10, 0			;//%r10    := 0
		cmp		%r13, 1			;//%psr(C) :=           !val
		adc		%r10, %r13		;//%r10    := 0 + val + !val
		jp		%r5			;//return     0 + val + !val		'jp.d %rb'͎gps (CPU bug)
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

// * Wed Oct 14 21:50:46 JST 2015 Naoyuki Sawa
// - uLinux Programmer's Manual - BASENAMEv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/basename.3.html)p:
//   dirname()basename()́AkŏI[ꂽpX̕AfBNgEt@CɕB
//   dirname()͍Ō'/'܂ł̕(Ō'/'͊܂܂Ȃ)ԂAbasename()͍Ō'/'ȍ~̕ԂB
//   ɂ͏LȊOɂׂȎdlL̂Ap͏Lŏ\Ȃ̂ŁAW[ł͒PɎ鎖ɂB
// - basename()ɂ͓ނ̈قȂo[WLBPOSIXo[WłAGNUo[WłB
//   GNUo[W͈ύX邱Ƃ͂ȂApath̖'/'̏ꍇ͋̕ԂB
//   W[basename()́AGNUo[Wɏ鎖ɂB]āAbasename()ɒ萔w肷鎖oB
// - ۂ̏Adirname()g͂܂薳Abasename()g̕ƎvB
//   ȂȂAGȃpX͂sꍇ́APdirname(),basename()ł͂ȂAsplitpath()gƎv炾B
//   dirname(),basename()ĝ́APɍς܂P[XłA̓Iɂ́AG[bZ[W̒Ƀx[X\P[XłB
//   Ƃ΁Aȉ̂悤Ɏgp鎖낤B
//   die("error at %s(%d)", basename(__FILE__), __LINE__);
//   ̎APOSIXo[Wbasename()萔̈̕悤ƂĂ܂AsȓɂȂB
//   GNUo[WȂ΁AȂ̂ŁAL̂悤Ɏgp鎖oAsǂB
// - Adirname()͈̂ŁAL̂悤ȗprɎgp鎖͏oȂB
//   Oq̒ʂAۂdirname()g͂܂薳낤Agpꍇ͒ӂB
char* dirname(char* path) {	//pathɒ萔w肷鎖͏o܂B
	char* p = strrchr(path, '/');			//
	if(!p) { p = strrchr(path, '\\'); }		//pXZp[^'/''\'̂ǂłΉo悤ɂB
	return p ? (*p = '\0', path) : (char*)".";
}
char* basename(char* path) {	//ł͈pathɒ萔wo܂B
	char* p = strrchr(path, '/');			//
	if(!p) { p = strrchr(path, '\\'); }		//pXZp[^'/''\'̂ǂłΉo悤ɂB
	return p ? (p + 1) : path;
}

/*--------------------------------------------------------------------------*/

// * Tue Oct 20 21:18:14 JST 2015 Naoyuki Sawa
// - a64l(),l64a(),l64a_r()ǉ܂B錾́Ainclude/stdlib.h ɗL܂B
//   uLinux Programmer's Manual - A64Lv(http://linuxjm.osdn.jp/html/LDP_man-pages/man3/a64l.3.html)p:
//   ̊֐32rbglongƃgGfBAbase-64ASCII(0`6)̊Ԃ̕ϊsB
//   a64l()̈̕7ȏ̏ꍇAŏ6oCggB
//   l64a()ŕԂl͐ÓIobt@[ւ̃|C^[Ȃ̂ŁAȍ~̌Ăяoŏ㏑\Bvalue0̏ꍇ͋󕶎ԂB
//   yzPOSIX.1-2001.
//   uNetBSD 6.1.5 - man page for a64lv(http://www.unix.com/man-page/netbsd/3/a64l/)p:
//   l64a_r() performs a conversion identical to that of l64a() and stores the resulting representation in the memory area pointed to by buffer,
//   consuming at most buflen characters including the terminating NUL character.
//   On successful completion, l64a_r() returns 0; if buffer is of insufficient length, -1 is returned.
// - !!!!
//   a64l(),l64a(),l64a_r()̐l̕Ή́AWIBase64GR[fBO(RFC3548/RFC4648)Ƃ͈قȂ܂B
//   l64a()ŃGR[hAdbase64enc.exeŃfR[h鎖͏o܂B
//   dbase64enc.exeŃGR[hAa64l()ŃfR[h鎖͏o܂B
//   a64l(),l64a(),l64a_r()͂܂łAw1[hPʂ̏Ȃf[^AoCiZ[tłȂʐMHŁAȈՓIɒʐMxꍇɎgpׂłB
//   傫ȃf[^ʐMꍇ́Aclipcode.cbase64_encode()/base64_decode()gpĉB
//   ܂AWIBase64GR[fBOpÃAvP[VƒʐMꍇAa64l(),l64a(),l64a_r()ł͂ȂAbase64_encode()/base64_decode()gpĉB
static const char TBL_l64a[]=
"."				//'.'    0\B
"/"				//'/'    1\B
"0123456789"			//0-9 2-11\B
"ABCDEFGHIJKLMNOPQRSTUVWXYZ"	//A-Z12-37\B
"abcdefghijklmnopqrstuvwxyz";	//a-z38-63\B
static char l64a_buffer[7] __attribute__((unused))/*asmubNQ*/;
#ifndef PIECE
char* l64a(long n) {
	if(l64a_r(n, l64a_buffer, sizeof l64a_buffer)) { DIE(); }	//Œ~鎖͋N蓾Ȃ͂łB~瓖W[̃oOłB
	return l64a_buffer;
}
int l64a_r(long n, char* buffer, int buflen) {
	for(;;) {
		if(--buflen < 0) { return -1; }	//If buffer is of insufficient length, -1 is returned.
		if(!n) { break; }
		*buffer++ = TBL_l64a[n & 63];
		n = (unsigned)n >> 6;
	}
	*buffer = '\0';
	return 0;	//On successful completion, l64a_r() returns 0.
}
long a64l(const char* s) {
	int n = 0, i = 0;
	for(;;) {
		int t = strchr(TBL_l64a, *s++) - TBL_l64a;
		if((unsigned)t > (unsigned)63) { break; }	//(*s=='\0')ꍇA(t=64)ɂȂ胋[v𔲂B
		n |= t << (i * 6);
		if(++i >= 6) { break; }		//a64l()̈̕7ȏ̏ꍇAŏ6oCggB
	}
	return n;
}
#else //PIECE
char* l64a(long n);
int l64a_r(long n, char* buffer, int buflen);
long a64l(const char* s);
asm("
		.code
		.align		1
		.global		l64a
		.global		l64a_r
		.global		a64l
l64a:
		;//%r12 := n
		xld.w		%r13, l64a_buffer		;//%r13 :=   l64a_buffer
		call.d		l64a_r				;//l64a_r(n, l64a_buffer, sizeof l64a_buffer)
		ld.w		%r14, 7				;//%r14 :=                sizeof l64a_buffer	*delay*
		xld.w		%r10, l64a_buffer		;//return l64a_buffer
		ret
		;//---------------------------------------------;//
l64a_r:
		;//%r12 := n
		;//%r13 := buffer
		;//%r14 := buflen
		ld.w		%r10, -1			;//%r10 := -1
l64a_r_LOOP:							;//for(;;) {
		sub		%r14, 1				;//  %r14 := buflen--
		jrlt		l64a_r_RET			;//  if(buflen < 0) { return -1 }
		cmp		%r12, 0				;//  if(!n) { break }
		jreq		l64a_r_BREAK			;//  
		xand		%r9, %r12, 63			;//  %r9  :=              n & 63
		ext		TBL_l64a@ah			;//  
		ext		TBL_l64a@al			;//  
		ld.ub		%r9, [%r9]			;//  %r9  :=     TBL_l64a[n & 63]
		ld.b		[%r13]+, %r9			;//  *buffer++ = TBL_l64a[n & 63]
		jp.d		l64a_r_LOOP			;//}
		srl		%r12, 6				;//  %r12 := n = (unsigned)n >> 6		*delay*
l64a_r_BREAK:
		ld.b		[%r13], %r8			;//*buffer = '0'
		ld.w		%r10, 0				;//return 0
l64a_r_RET:
		ret
		;//---------------------------------------------;//
a64l:
		;//%r12 := s
		pushn		%r3
		ld.w		%r0, %r12			;//%r0  := s
		ld.w		%r1, 0				;//%r1  := n = 0
		ld.w		%r2, 0				;//%r2  := i = 0
		xld.w		%r3, TBL_l64a			;//%r3  := TBL_l64a
a64l_LOOP:							;//for(;;) {
		ld.b		%r13, [%r0]+			;//  %r13 =                       c = *s++
		xcall.d		strchr				;//  %r10 :=     strchr(TBL_l64a, c)
		ld.w		%r12, %r3			;//  %r12 :=            TBL_l64a		*delay*
		sub		%r10, %r3			;//  %r10 := t = strchr(TBL_l64a, c) - TBL_l64a
		xcmp		%r10, 63			;//  if((unsigned)t > (unsigned)63) { break }
		jrugt		a64l_BREAK			;//  
		ld.w		%r9, 6				;//  %r10 :=      t <<= (i * 6)
		sla		%r10, %r2			;//  
		sub		%r9, 1				;//  
		jrne		-2				;//  
		add		%r2, 1				;//  %r2  := i++
		cmp		%r2, 6				;//  if(i >= 6) { break }
		jrlt.d		a64l_LOOP			;//}
		or		%r1, %r10			;//  %r1  := n |= t				*delay*
a64l_BREAK:							;//
		ld.w		%r10, %r1			;//%r10 := n
		popn		%r3
		ret
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

/* * Tue Nov 24 21:41:25 JST 2015 Naoyuki Sawa
 * - sleep(),usleep()ǉ܂B錾unistd.hɗL܂B
 */
#ifdef  PIECE
unsigned sleep(unsigned seconds) {
	return usleep(seconds * 1000000);
}
int usleep(useconds_t usec) {
	unsigned st, ed;
	//!pceTimerGetPrecisionCount()̖߂l̓jAȒlł͂܂B
	//߂ɂpceTimerAdjustPrecisionCount()gKv܂B
	st = pceTimerGetPrecisionCount();
	do {
		ed = pceTimerGetPrecisionCount();
	} while(pceTimerAdjustPrecisionCount(st, ed) < usec);
	return 0;
}
#endif//PIECE
#ifdef  WIN32
unsigned sleep(unsigned seconds) {
	Sleep(seconds * 1000);
	return 0;
}
int usleep(useconds_t usec) {
	Sleep((usec + 999) / 1000);
	return 0;
}
#endif//WIN32

/*--------------------------------------------------------------------------*/

// * Thu Mar 24 21:04:15 JST 2016 Naoyuki Sawa
// - signbit(),copysign(),copysignf()ǉ܂B
//   C99Œǉꂽp̃}N,y,֐ŁA܂g͖Ǝv܂AoĂ߂ɎĂɂ܂B
// - round(),roundf(),nearbyint(),nearbyintf(),rint(),rintf(),lround(),lroundf(),lrint(),lrintf()ǉ܂B
//   C99Œǉꂽۂߊ֐ŁAɁAlround()֗Ǝv܂B
//   ܂܂ł'(int)((x>=0.0)?(x+0.5):(x-0.5))'̂悤ɏĂA'lround(x)'ōςނ悤ɂȂ܂B
// - 錾͑SāAinclude/math.hɗL܂B
//   {xo[W̊֐Acopysign(),lround(),lrint(),round(),nearbyint(),rint(),trunc()̎́Acliplibc.cɗL܂B
//   Pxo[W̊֐Acopysignf(),lroundf(),lrintf(),roundf(),nearbyintf(),rintf(),truncf()̎́Aframflt2.cɗL܂B
//   𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB
#ifndef PIECE
double  copysign(double x, double y) {
	int* px = (int*)&x + 1;					//*px := seeeeeee eeeemmmm mmmmmmmm mmmmmmmm
	int* py = (int*)&y + 1;					//*py := SEEEEEEE EEEEMMMM MMMMMMMM MMMMMMMM
	*px &= 0x7FFFFFFF;					//*px := 0eeeeeee eeeemmmm mmmmmmmm mmmmmmmm
	*py &= 0x80000000;					//*py := S0000000 00000000 00000000 00000000
	*px |= *py;						//*px := Seeeeeee eeeemmmm mmmmmmmm mmmmmmmm
	return x;						//return Seeeeeee eeeemmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm
}
long      lround(double x) { return (long)(x + ((x >= 0.0) ? 0.5 : -0.5)); }
long       lrint(double x) { return lround(x); }		//{fesetround()̐ݒɏ]ׂAȒPɎ邽߂lround()ƓɂBp͂łxᖳƎvAۂ̏֐gCB
double     round(double x) { return lround(x); }
double nearbyint(double x) { return  round(x); }		//{fesetround()̐ݒɏ]ׂAȒPɎ邽߂round()ƓɂBp͂łxᖳƎvAۂ̏֐gCB
double      rint(double x) { return  round(x); }		//{fesetround()̐ݒɏ]ׂAȒPɎ邽߂round()ƓɂBp͂łxᖳƎvAۂ̏֐gCB
double     trunc(double x) { return (long)x; }
#else //PIECE
double  copysign(double x, double y);
long      lround(double x);
long       lrint(double x);
double     round(double x);
double nearbyint(double x);
double      rint(double x);
double     trunc(double x);
asm("
		.code
		.align		1
		.global		copysign
		.global		lround
		.global		lrint
		.global		round
		.global		nearbyint
		.global		rint
		.global		trunc
copysign:
		add		%r15, %r15			;//%r15 := EEEEEEEE EEEMMMMM MMMMMMMM MMMMMMM0, %psr(C) := S
		adc		%r13, %r13			;//%r13 := eeeeeeee eeemmmmm mmmmmmmm mmmmmmmS
		rr		%r13, 1				;//%r13 := Seeeeeee eeeemmmm mmmmmmmm mmmmmmmm
		ld.w		%r11, %r13			;//
		ret.d						;//return  Seeeeeee eeeemmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm mmmmmmmm
		ld.w		%r10, %r12			;//											*delay*
		;//---------------------------------------------;//
lround:
lrint:
		xand		%r15, %r13, 0x80000000		;//%r15:%r14 :=      ((x >= 0.0) ? 0.5 : -0.5)
		xoor		%r15, %r15, 0x3FE00000		;//
		xcall.d		__adddf3			;//%r11:%r10 := x += ((x >= 0.0) ? 0.5 : -0.5)
		ld.w		%r14, 0				;//											*delay*
		ld.w		%r13, %r11			;//
		xjp.d		__fixdfsi			;//return (long)x
		ld.w		%r12, %r10			;//											*delay*
		;//---------------------------------------------;//
round:
nearbyint:
rint:
		call		lround				;//%r10 :=        lround(x)
		xjp.d		__floatsidf			;//return (double)lround(x)
		ld.w		%r12, %r10			;//											*delay*
		;//---------------------------------------------;//
trunc:
		xcall		__fixdfsi			;//%r10 :=        (int)x
		xjp.d		__floatsidf			;//return (double)(int)x
		ld.w		%r12, %r10			;//											*delay*
");
#endif//PIECE

/*--------------------------------------------------------------------------*/

#ifndef PIECE
// * Mon Mar 28 21:40:28 JST 2016 Naoyuki Sawa
// - fdim(),fdimf(),fmin(),fminf(),fmax(),fmaxf(),fma(),fmaf()ǉ܂B								*/
//   C99Œǉꂽ֐łB													*/
//   fdim()́AɎĝǂȂ̂łAoĂ߂ɎĂɂ܂B						*/
//   fmin(),fmax()́Amin(),max()}N^𖾎o邵p̂ŁA֗ɎgpoƎv܂B				*/
//   fma()́AϘaZZEՂ̂ŁA(gʂ͏ȂƎv܂)g͗LƎv܂B					*/
// - 錾͑SāAinclude/math.hɗL܂B												*/
//   {xo[W̊֐Afdim(),fmin(),fmax(),fma()̎́Acliplibc.cɗL܂B							*/
//   Pxo[W̊֐Afdimf(),fminf(),fmaxf(),fmaf()̎́Aframflt2.cɗL܂B						*/
//   𕪂ŔAPxZCu(AvP[VgpĂȂ̂)ʂɃNāATCY鎖h߂łB	*/
double fdim(double x, double y) {
	return fmax(x - y, 0.0);
}
double fmin(double x, double y) {
	return (x <= y) ? x : y;
}
double fmax(double x, double y) {
	return (x <= y) ? y : x;
}
double fma(double x, double y, double z) {
	return (x * y) + z;
}
#else //PIECE
// * Mon Mar 28 22:52:58 JST 2016 Naoyuki Sawa
// - fdim(),fmin(),fmax(),fma()AZu܂B
//   fdim(),fmin(),fmax()̋ʏHvāA肭R[hTCY팸oƎv܂B
//   A__fcmpd%r4`%r7j󂵂ȂɈˑĂ܂B
//   A__fcmpd̎ύXꍇ́AӂĉB
double fdim(double x, double y);
double fmin(double x, double y);
double fmax(double x, double y);
double fma(double x, double y, double z);
asm("
		.code
		.align		1
		.global		fdim
		.global		fmin
		.global		fmax
		.global		fma
fdim:
		xcall		__subdf3		;//%r11:%r10 := x - y
		ld.w		%r12, %r10		;//%r13:%r12 := x - y
		ld.w		%r13, %r11		;//
		ld.w		%r14, 0			;//%r15:%r14 :=        0
		ld.w		%r15, 0
		;//* FALLTHRU *//			;//return  fmax(x - y, 0)
fmax:
		ld.w		%r4, %r14							;//%r5:%r4  :=       y
		ld.w		%r5, %r15							;//
		ld.w		%r6, %r12							;//%r7:%r6  := x
		jp.d		6								;//				
		 ld.w		%r7, %r13							;//				@	*delay*
		;//* FALLTHRU *//								;//				@
fmin:												;//				@
		 ld.w		%r4, %r12		;//%r5:%r4  :=  x			;//				@			;//
		 ld.w		%r5, %r13		;//					;//				@			;//
		 ld.w		%r6, %r14		;//%r7:%r6  :=        y			;//				@			;//
		 ld.w		%r7, %r15		;//					;//				@			;//
		xcall		__fcmpd			;//%psr     := (x <=> y)		;//%psr     := (x <=> y)				;//
		ld.w		%r10, %r4		;//					;//							;//__fcmpd%r4`%r7j󂵂ȂɈˑĂ܂B
		jrle.d		4			;//          if(x <=  y) {		;//          if(x <=  y) {				;//
		 ld.w		%r11, %r5		;//%r11:%r10 := x        } else {	;//%r11:%r10 :=       y  } else {	*delay*		;//
		 ld.w		%r10, %r6		;//%r11:%r10 :=       y  }		;//%r11:%r10 := x        }				;//
		 ld.w		%r11, %r7		;//					;//							;//
		ret					;//					;//							;//
fma:
		;//%r13:%r12       := x
		;//%r15:%r14       := y
		;//[%sp+0]         := retp
		;//[%sp+8]:[%sp+4] := z
		xcall		__muldf3		;//%r11:%r10 := (x * y)
		xld.w		%r14, [%sp+4]		;//%r15:%r14 :=           z
		xld.w		%r15, [%sp+8]		;//
		ld.w		%r12, %r10		;//%r13:%r12 := (x * y)
		xjp.d		__adddf3		;//return       (x * y) + z
		ld.w		%r13, %r11		;//										*delay*
");
#endif//PIECE
