/*
 *	clipflt1.c
 *
 *	Px_ZCu
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Jul 20 13:26:33 JST 2008 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Jul 20 19:20:18 JST 2008 Naoyuki Sawa
 *	- mat3f_rot()ŁAāA{xłsin()Acos()ĂяoĂ܂Ă܂B
 *	  ̂߁Amat3f_rot()gpƁA傫Ȑ\ቺƂȂĂ܂Ă܂B
 *	  APxłsinf()Acosf()Ăяo悤AC܂B
 *	* Sun Aug 17 22:24:29 JST 2008 Naoyuki Sawa
 *	- vecfvec3fAmatfmat3fAvecxvec3xAmatxmat3xɖOύX܂B
 *	  Suŕϊ̂ŁA{ȑÕRgȂǂׂĖOύXĂ܂B
 *	* Mon Aug 18 00:28:27 JST 2008 Naoyuki Sawa
 *	- vec2fAmat2fAсÅ֐Qǉ܂B
 *	* Tue Aug 19 23:47:09 JST 2008 Naoyuki Sawa
 *	- vec2fAmat2f̊֐QAZuAAȃ܂B
 *	- vec2f_xform,mat2f_xforḿAvec3f_xform,mat3f_xformƈāARAMzuƂ͂܂B
 *	  vec3f_xform,mat3f_xforḿA3D̂Ȃł܂Ƃ܂đʂɎgp邱Ƃl܂A
 *	  vec2f_xform,mat2f_xforḿA3DقǑxdvȏʂŎgƂ͏ȂƍlłB
 *	* Mon Sep 08 16:31:59 JST 2008 Naoyuki Sawa
 *	- clipflt.cclipflt1.cclipflt2.cɕ܂B
 *	- GȊ֐gȂvOɂAɑS֐NĎst@C傫Ȃ邱Ƃh߁A
 *	  gppx̍֐clipflt1.cAgppx̒Ⴂ֐clipflt2.cɕ邱Ƃɂ܂B
 *	  ֐̖mȊ͖̂ŁAKXA֐ړsȂ\łB
 *	  ܂A֐AKvɉclipflt3.c,clipflt4.c,...ǉčs\łB
 *	* Thu Apr 02 13:37:51 JST 2009 Naoyuki Sawa
 *	- xtof()ftox()ǉ܂B
 *	- xtof(),ftox()́Afst(),fld()ƓłAȉ̓_قȂ܂B
 *	  - fst(),fld()̓}N`ĂARpC̕ϊ\ŁA萔e[ȕɗpł܂B
 *	    xtof(),ftox()͊֐ŎĂAɎsƂȂA萔e[ȕɗpł܂B
 *	  - xtof(),ftox()́AŒ菬_̃oCAX2^10ł邱Ƃ𗘗pāAIȎƂ܂B
 *	    fst(),fld()́AsɓWJꂽꍇ́Aq͍̓lꂸAIȏƂȂ܂B
 *	- xtof()ftox()́A%r4,%r5,%r6,%r7̒lj󂵂܂B
 *	  xtof()ftox()͓Ǝɒ`֐łAPx_̊{ZTu[`ł͂܂񂪁A
 *	  framflt1.sW[Ŏ{ZTu[`Ɠl̃WX^KOƂāAp\łB
 *	- xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
 *	* Sun Sep 20 17:20:17 JST 2009 Naoyuki Sawa
 *	- solve_simultaneous_equations()ǉ܂B
 *	* Thu Feb 25 21:08:23 JST 2016 Naoyuki Sawa
 *	- clipflt.hɈˑĂ郂W[AlibclipɊ܂߂悤ɂ邽߂ɁAclipflt.hlibclip/extclip.hɊ܂߂Kv܂B
 *	  ܂ł́Aclipflt.hlibclip/extclip.hɊ܂߂ƁAG[oĂ̂ŁAG[oȂ悤Ɉȉ̏Cs܂B
 *	- P/ECEȊOł́Adief()die()ƓɃ}N`܂B
 *	  P/ECEłdie()pceFontPrintf()gĂ邽߂ɁAƂ͕ʂɔėpłdief()pӂ̂łAP/ECEȊOłdie()̂ėpłƂȂĂAŖ薳łB
 *	- clipfix.hɃCN[hĂȂ΁AŒ菬_Ɉˑ@\O悤ɂ܂B
 *	  libclip/extclip.hclipfix.hCN[hɁAclipflt.hCN[hꍇ̂߂łB
 *	  Alibclip/extclip.hclipfix.hCN[h悤ɕύXÃubNLɂȂ\łB
 *	- cliprend.hɃCN[hĂȂ΁A`Ɉˑ@\O悤ɂ܂B
 *	  libclip/extclip.hcliprend.hCN[hɁAclipflt.hCN[hꍇ̂߂łB
 *	  Alibclip/extclip.hcliprend.hCN[h悤ɕύXÃubNLɂȂ\łB
 *	- P/ECEȊOł́APxł̐w֐́A{xł̐w֐Ăяo悤ɂ܂B
 *	  ܂ł́AW[̒Pxł̐w֐ACłڃAZułō쐬Ă̂ŁAP/ECEȊOɊ܂߂܂łB
 *	  clipflt.hɈˑĂ郂W[AlibclipɊ܂߂悤ɂ邽߂̖ړIŁA삷ΗǂȂ̂őx͍lĂ܂B
 *	- VC++6.0ŒPxł̐w֐̒`Փ˂鎖܂B
 *	  ڍׂ́Aclipflt.h́AuANSICuw֐(math.lib)Ɨގ̋@\̒PxŁv̐錾́A2016/02/25̃RgQƂĉB
 *	* Tue Mar 08 21:09:23 JST 2016 Naoyuki Sawa
 *	- solve_simultaneous_equations()}`Xbh܂B
 *	  ڍׂ́Aclipflt1.c ́Au}`Xbhsolve_simultaneous_equations()̌،ʁvQƂĉB
 */
#include "clip.h"

#ifndef PIECE
#define NOASM	// ̃V|`ƁACłgp܂B */
#endif /*PIECE*/

/****************************************************************************
 *	
 ****************************************************************************/

static float matnf_determinant(const float* m/*[n][n]*/, int n);
static float matnf_cofactor(const float* m/*[n][n]*/, int n, int i, int j);

/****************************************************************************
 *	fobO\
 ****************************************************************************/

#ifdef  PIECE	//{{2016/02/25ǉ:P/ECEȊOł́Adief()die()ƓɃ}N`܂BP/ECEłdie()pceFontPrintf()gĂ邽߂ɁAƂ͕ʂɔėpłdief()pӂ̂łAP/ECEȊOłdie()̂ėpłƂȂĂAŖ薳łB}}

/* * Fri Sep 26 21:35:54 JST 2008 Naoyuki Sawa
 * - _̏("%f")ɑΉAfobO\łB
 *   ʏdie()́ApceFontPrintf()gpĂ邽߁A_̏("%f")ɑΉĂ܂łB
 *   _̃fobO\ȒPɂ邽߁A{֐ǉ܂B
 *   _̏("%f")Kvꍇ́Aʏdie()gSłB(̗ŔAqdief()̖_QƂĂB)
 * - {֐́Asnprintf()ĂяoāA_def_vbuff[]̉[80`87CɁAtWJ܂B
 *   ̌Adie()ɐڂāA_def_vbuff[]0`79CɁAWJ`悵܂B
 * - `悪79C𒴂ƁAj󂵂Ă܂AȂ\ɂȂ댯܂B
 *   ܂AWJ̕'%'܂܂ĂƁAdie()̒pceFontPrintf()ɂčēWJAȂ\ɂȂ댯܂B
 * - {֐́A_̃fobO\ƂꂽprȂ̂ŁAȃD悵āA̖ւ̑΍͍̂ȂƂɂ܂B
 *   ߂镶fobO\AWJ̕'%'܂܂Ȃ悤AӂĂB
 */
#ifdef NOASM
void dief(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	vsnprintf(&_def_vbuff[DISP_X * (DISP_Y - 8)], DISP_X * 8, fmt, ap);
	va_end(ap);
	die(&_def_vbuff[DISP_X * (DISP_Y - 8)]);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		dief
dief:
		;// [%sp+0]  := retp (noreturn)
		;// [%sp+4]  := fmt
		;// [%sp+8]  := ...
		popn		%r0
		xld.w		%r0, _def_vbuff + 10240			;// %r0     := &_def_vbuff[DISP_X * (DISP_Y - 8)]
		;// %r0      := &_def_vbuff[DISP_X * (DISP_Y - 8)]
		;// [%sp+0]  := fmt
		;// [%sp+4]  := ...
		ld.w		%r12, %r0				;// %r12    := &_def_vbuff[DISP_X * (DISP_Y - 8)]
		xld.w		%r13, 1024				;// %r13    :=                                     DISP_X * 8
		xcall		snprintf				;//   snprintf(&_def_vbuff[DISP_X * (DISP_Y - 8)], DISP_X * 8, fmt, ...)
		;// %r0      := &_def_vbuff[DISP_X * (DISP_Y - 8)]
		pushn		%r0					;// [%sp+0] := &_def_vbuff[DISP_X * (DISP_Y - 8)]
		xcall		die					;//        die(&_def_vbuff[DISP_X * (DISP_Y - 8)])
		;// [%sp+0]  := retp (noreturn)
		;// [%sp+4]  := &_def_vbuff[DISP_X * (DISP_Y - 8)]
");
#endif /*NOASM*/

#endif//PIECE	//{{2016/02/25ǉ:P/ECEȊOł́Adief()die()ƓɃ}N`܂BP/ECEłdie()pceFontPrintf()gĂ邽߂ɁAƂ͕ʂɔėpłdief()pӂ̂łAP/ECEȊOłdie()̂ėpłƂȂĂAŖ薳łB}}

/****************************************************************************
 *	_
 ****************************************************************************/

/* 0.0fȏA1.0f̗ */
#ifdef NOASM
float rndf(int* seed) {
	int m = rnd32(seed);
	m <<= 8;
	if(!m) {
		return 0.0f;
	} else {
		int e = 127;
		int c;
		do {
			c = m & (1 << 31);
			m <<= 1;
			e--;
		} while(!c);
		m = ((unsigned)m >> 9) | (e << 23);
		return *(float*)&m;
	}
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		rndf
rndf:
		xcall		rnd32			;// %r10 := m = ???????? ???????? ???????? ????????
		sll		%r10, 8			;// %r10 := m = ???????? ???????? ???????? 00000000
		jreq		rndf_RET		;//             |
		;//					;//             +----------------------------------------------+
		xld.w		%r11, 127		;// %r11 := e = bias                                           |
		 add		%r10, %r10		;// %r10 := m = ???????? ???????? ???????0 00000000, %psr(C) <-+
		jruge.d		-1			;//             (ŔĂA%r10[8:0]͊m0ɂȂ܂B)
		sub		%r11, 1			;// %r11 := e--								*delay*
		;//
		or		%r10, %r11		;// %r10 := mmmmmmmm mmmmmmmm mmmmmmm0 eeeeeeee
		rr		%r10, 8			;// %r10 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0
rndf_RET:
		ret.d
		rr		%r10, 1			;// %r10 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm				*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

/* aȏAb̗ */
#ifdef NOASM
float rndf_range(int* seed, float a, float b) {
	return rndf(seed) * (b - a) + a;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		rndf_range
rndf_range:
		pushn		%r1
		ld.w		%r0, %r13		;// %r0  :=                   a
		xcall.d		rndf			;// %r10 := rndf(seed)
		ld.w		%r1, %r14		;// %r1  :=               b			*delay*
		;//
		ld.w		%r12, %r1		;// %r12 :=               b
		ld.w		%r1, %r10		;// %r1  := rndf(seed)
		xcall.d		__subsf3		;// %r10 :=              (b - a)
		ld.w		%r13, %r0		;// %r13 :=                   a			*delay*
		;//
		ld.w		%r12, %r1		;// %r12 := rndf(seed)
		xcall.d		__mulsf3		;// %r10 := rndf(seed) * (b - a)
		ld.w		%r13, %r10		;// %r13 :=              (b - a)		*delay*
		;//
		ld.w		%r13, %r0		;// %r13 :=                        a
		popn		%r1
		xjp.d		__addsf3		;// %r10 := rndf(seed) * (b - a) + a
		ld.w		%r12, %r10		;// %r12 := rndf(seed) * (b - a)		*delay*
");
#endif /*NOASM*/

/****************************************************************************
 *	Œ菬_{l,xNg,s}̕_{l,xNg,s}
 ****************************************************************************/

#ifdef  __CLIP_FIX_H__	//{{2016/02/25ǉ:clipfix.hɃCN[hĂȂ΁AŒ菬_Ɉˑ@\O悤ɂ܂Blibclip/extclip.hclipfix.hCN[hɁAclipflt.hCN[hꍇ̂߂łBAlibclip/extclip.hclipfix.hCN[h悤ɕύXÃubNLɂȂ\łB}}

/* Œ菬lƕl̑ݕϊsȂ܂B
 * [in]
 *	xtof:	x		ϊŒ菬lB
 *	ftox:	f		ϊ镂lB
 * [out]
 *	xtof:	߂l		ϊlB
 *	ftox:	߂l		ϊŒ菬lB
 * [note]
 *	* xtof(),ftox()́Afst(),fld()ƓłAȉ̓_قȂ܂B
 *	  - fst(),fld()̓}N`ĂARpC̕ϊ\ŁA萔e[ȕɗpł܂B
 *	    xtof(),ftox()͊֐ŎĂAɎsƂȂA萔e[ȕɗpł܂B
 *	  - xtof(),ftox()́AŒ菬_̃oCAX2^10ł邱Ƃ𗘗pāAIȎƂ܂B
 *	    fst(),fld()́AsɓWJꂽꍇ́Aq͍̓lꂸAIȏƂȂ܂B
 *	* xtof()ftox()́A%r4,%r5,%r6,%r7̒lj󂵂܂B
 *	  xtof()ftox()͓Ǝɒ`֐łAPx_̊{ZTu[`ł͂܂񂪁A
 *	  framflt1.sW[Ŏ{ZTu[`Ɠl̃WX^KOƂāAp\łB
 */
float xtof(fixed x);	/* %r4,%r5,%r6,%r7̒lj󂵂܂ */
fixed ftox(float f);	/* %r4,%r5,%r6,%r7̒lj󂵂܂ */
asm("
		.code
		.align		1
;//-----------------------------------------------------;
		.global		xtof
xtof:
		xcall		__floatsisf		;// %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm
		swap		%r12, %r10		;// %r12 := emmmmmmm mmmmmmmm mmmmmmmm seeeeeee
		sla		%r10, 1			;// %r10 := eeeeeeem mmmmmmmm mmmmmmmm mmmmmmm0
		jreq		2			;// if(|f|)
		 sub		%r12, 5			;//   exp  -= 10 (A_[t[͗L蓾܂)
		ret.d
		swap		%r10, %r12		;// %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm		*delay*
;//-----------------------------------------------------;
		.global		ftox
ftox:
		swap		%r10, %r12		;// %r10 := emmmmmmm mmmmmmmm mmmmmmmm seeeeeee
		sla		%r12, 1			;// %r12 := eeeeeeem mmmmmmmm mmmmmmmm mmmmmmm0
		jreq		2			;// if(|f|)
		 add		%r10, 5			;//   exp  += 10 (I[o[t[͍l܂)
		xjp.d		__fixsfsi		;// %r10 := (int)f
		swap		%r12, %r10		;// %r12 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm		*delay*
");

#ifdef NOASM
void vec3f_conv(vec3f* vec1, const vec3x* vec2) {
	      float* dst = &vec1->x;
	const fixed* src = &vec2->x;
	int cnt = 3;
	do {
//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
//		*dst++ = fst(*src++);
//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		*dst++ = xtof(*src++);
//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
	} while(--cnt);
}
void mat3f_conv(mat3f* mat1, const mat3x* mat2) {
	      float* dst = &mat1->a00;
	const fixed* src = &mat2->a00;
	int cnt = 12;
	do {
//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
//		*dst++ = fst(*src++);
//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		*dst++ = xtof(*src++);
//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
	} while(--cnt);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec3f_conv
		.global		mat3f_conv
vec3f_conv:
		jp.d		vec3f_mat3f_conv
		ld.w		%r4, 3			;// %r4  := cnt = 3					*delay*
		;//-------------------------------------;
mat3f_conv:
		ld.w		%r4, 12			;// %r4  := cnt = 12
		;//-------------------------------------;
vec3f_mat3f_conv:
		ld.w		%r5, %r12		;// %r5  := (float*)dst
		ld.w		%r6, %r13		;// %r6  := (fixed*)src
;//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
;//		xld.w		%r7, 0x3a800000		;// %r7  := (1.0f / 1024.0f)
;//vec3f_mat3f_conv_loop:
;//		ld.w		%r12, [%r6]+		;// %r12 := x = (fixed)*src++
;//		xcall		__floatsisf		;// %r10 := f = (float)x
;//		;//
;//		ld.w		%r12, %r10		;// %r12 := f
;//		xcall.d		__mulsf3		;// %r10 := f *= (1.0f / 1024.0f)
;//		ld.w		%r13, %r7		;// %r13 :=      (1.0f / 1024.0f)			*delay*
;//		;//
;//		ld.w		[%r5]+, %r10		;// *dst++ = f
;//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
vec3f_mat3f_conv_loop:
		ld.w		%r12, [%r6]+		;// %r12 := x = (fixed)*src++
		xcall		xtof			;// %r10 := f = xtof(x)
		ld.w		[%r5]+, %r10		;// *dst++ = f
;//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		sub		%r4, 1			;// %r4  := cnt--
		jrne		vec3f_mat3f_conv_loop
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void mat3x_conv(mat3x* mat1, const mat3f* mat2) {
	      fixed* dst = &mat1->a00;
	const float* src = &mat2->a00;
	int cnt = 12;
	do {
//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
//		*dst++ = fld(*src++);
//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		*dst++ = ftox(*src++);
//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
	} while(--cnt);
}
void vec3x_conv(vec3x* vec1, const vec3f* vec2) {
	      fixed* dst = &vec1->x;
	const float* src = &vec2->x;
	int cnt = 3;
	do {
//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
//		*dst++ = fld(*src++);
//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		*dst++ = ftox(*src++);
//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
	} while(--cnt);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec3x_conv
		.global		mat3x_conv
vec3x_conv:
		jp.d		vec3x_mat3x_conv
		ld.w		%r4, 3			;// %r4  := cnt = 3					*delay*
		;//-------------------------------------;
mat3x_conv:
		ld.w		%r4, 12			;// %r4  := cnt = 12
		;//-------------------------------------;
vec3x_mat3x_conv:
		ld.w		%r5, %r12		;// %r5  := (fixed*)dst
		ld.w		%r6, %r13		;// %r6  := (float*)src
;//{{2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
;//		xld.w		%r7, 0x44800000		;// %r7  := 1024.0f
;//vec3x_mat3x_conv_loop:
;//		ld.w		%r12, [%r6]+		;// %r12 := f = (float)*src++
;//		xcall.d		__mulsf3		;// %r10 := f *= 1024.0f
;//		ld.w		%r13, %r7		;// %r13 :=      1024.0f				*delay*
;//		;//
;//		xcall.d		__fixsfsi		;// %r10 := x = (fixed)f
;//		ld.w		%r12, %r10		;// %r12 := x						*delay*
;//		;//
;//		ld.w		[%r5]+, %r10		;// *dst++ = x
;//2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
vec3x_mat3x_conv_loop:
		ld.w		%r12, [%r6]+		;// %r12 := f = (float)*src++
		xcall		ftox			;// %r10 := x = ftox(f)
		ld.w		[%r5]+, %r10		;// *dst++ = x
;//}}2009/04/02:xtof()ftox()̒ǉɔAvec3f_conv(),vec3x_conv(),mat3f_conv(),mat3x_conv()Axtof(),ftox()𗘗p悤ɕύX܂B
		sub		%r4, 1			;// %r4  := cnt--
		jrne		vec3x_mat3x_conv_loop
		ret
");
#endif /*NOASM*/

#endif//__CLIP_FIX_H__	//{{2016/02/25ǉ:clipfix.hɃCN[hĂȂ΁AŒ菬_Ɉˑ@\O悤ɂ܂Blibclip/extclip.hclipfix.hCN[hɁAclipflt.hCN[hꍇ̂߂łBAlibclip/extclip.hclipfix.hCN[h悤ɕύXÃubNLɂȂ\łB}}

/****************************************************************************
 *	_xNg(3D)
 ****************************************************************************/

const vec3f vec3f_0 = { 0.0f, 0.0f, 0.0f };
const vec3f vec3f_1 = { 1.0f, 1.0f, 1.0f };
const vec3f vec3f_x = { 1.0f, 0.0f, 0.0f };
const vec3f vec3f_y = { 0.0f, 1.0f, 0.0f };
const vec3f vec3f_z = { 0.0f, 0.0f, 1.0f };

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void vec3f_add(vec3f* vec1, const vec3f* vec2) {
	vec1->x += vec2->x;
	vec1->y += vec2->y;
	vec1->z += vec2->z;
}
void vec3f_sub(vec3f* vec1, const vec3f* vec2) {
	vec1->x -= vec2->x;
	vec1->y -= vec2->y;
	vec1->z -= vec2->z;
}
void vec3f_mul(vec3f* vec1, const vec3f* vec2) {
	vec1->x *= vec2->x;
	vec1->y *= vec2->y;
	vec1->z *= vec2->z;
}
void vec3f_div(vec3f* vec1, const vec3f* vec2) {
	vec1->x /= vec2->x;
	vec1->y /= vec2->y;
	vec1->z /= vec2->z;
}
void vec3f_neg(vec3f* vec) {
	vec->x = -vec->x;
	vec->y = -vec->y;
	vec->z = -vec->z;
}
#else /*NOASM*/
//{{2008/08/19:vec2fvec3f̏𓝍邽ߍ폜܂B
//asm("
//		.code
//		.align		1
//		.global		vec3f_add
//		.global		vec3f_sub
//		.global		vec3f_mul
//		.global		vec3f_div
//		.global		vec3f_neg
//vec3f_neg:
//		xld.w		%r4, __negsf2
//		jp.d		vec3f_op
//		ld.w		%r13, %r12		;// vec2̓_~[̓ǂݍ݂ɂȂ܂B			*delay*
//		;//-------------------------------------;
//vec3f_div:
//		xld.w		%r4, __divsf3
//		jp		vec3f_op
//		;//-------------------------------------;
//vec3f_mul:
//		xld.w		%r4, __mulsf3
//		jp		vec3f_op
//		;//-------------------------------------;
//vec3f_sub:
//		xld.w		%r4, __subsf3
//		jp		vec3f_op
//		;//-------------------------------------;
//vec3f_add:
//		xld.w		%r4, __addsf3
//		;//-------------------------------------;
//vec3f_op:
//		ld.w		%r5, %r12		;// %r5  := vec1
//		ld.w		%r6, %r13		;// %r6  := vec2
//		ld.w		%r7, 3			;// %r7  := cnt
//vec3f_op_loop:
//		ld.w		%r12, [%r5]		;// %r12 := vec1->x
//		ld.w		%r13, [%r6]+		;// %r13 :=           vec2->x
//		call		%r4			;// %r10 := vec1->x + vec2->x
//		ld.w		[%r5]+, %r10
//		sub		%r7, 1			;// %r7  := cnt--
//		jrne		vec3f_op_loop
//		ret
//");
//}}2008/08/19:vec2fvec3f̏𓝍邽ߍ폜܂B
//* Tue Aug 19 23:47:09 JST 2008 Naoyuki Sawa
//- vec2f̃AZuɕāAvec2fvec3f̏𓝍܂B
asm("
		.code
		.align		1
		.global		vec2f_add
		.global		vec2f_sub
		.global		vec2f_mul
		.global		vec2f_div
		.global		vec2f_neg
		.global		vec3f_add
		.global		vec3f_sub
		.global		vec3f_mul
		.global		vec3f_div
		.global		vec3f_neg
;//-----------------------------------------------------;
vec2f_neg:
		ld.w		%r13, %r12		;// vec2̓_~[̓ǂݍ݂ɂȂ܂B
		xld.w		%r4, __negsf2
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 2			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec2f_div:
		xld.w		%r4, __divsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 2			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec2f_mul:
		xld.w		%r4, __mulsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 2			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec2f_sub:
		xld.w		%r4, __subsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 2			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec2f_add:
		xld.w		%r4, __addsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 2			;// %r5  := cnt						*delay*
;//-----------------------------------------------------;
vec3f_neg:
		ld.w		%r13, %r12		;// vec2̓_~[̓ǂݍ݂ɂȂ܂B
		xld.w		%r4, __negsf2
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 3			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec3f_div:
		xld.w		%r4, __divsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 3			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec3f_mul:
		xld.w		%r4, __mulsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 3			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec3f_sub:
		xld.w		%r4, __subsf3
		jp.d		vec2f_vec3f_op
		ld.w		%r5, 3			;// %r5  := cnt						*delay*
		;//-------------------------------------;
vec3f_add:
		xld.w		%r4, __addsf3
		ld.w		%r5, 3			;// %r5  := cnt
;//-----------------------------------------------------;
vec2f_vec3f_op:
		ld.w		%r6, %r12		;// %r6  := vec1
		ld.w		%r7, %r13		;// %r7  := vec2
vec2f_vec3f_op_loop:
		ld.w		%r12, [%r6]		;// %r12 := vec1->x
		ld.w		%r13, [%r7]+		;// %r13 :=           vec2->x
		call		%r4			;// %r10 := vec1->x + vec2->x
		ld.w		[%r6]+, %r10
		sub		%r5, 1			;// %r5  := cnt--
		jrne		vec2f_vec3f_op_loop
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void vec3f_normal(vec3f* vec) {
	float mag = vec3f_mag(vec);
	vec->x /= mag;
	vec->y /= mag;
	vec->z /= mag;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec3f_normal
vec3f_normal:
		xsub		%sp, %sp, 12
		xld.w		[%sp+0], %r12		;// [%sp+0] := vec
		xcall		vec3f_mag		;// %r10    := mag
		xld.w		%r12, [%sp+0]		;// %r12    := vec
		xld.w		[%sp+0], %r10
		xld.w		[%sp+4], %r10
		xld.w		[%sp+8], %r10
		ld.w		%r13, %sp		;// %r13    :=       [mag,mag,mag]
		xcall		vec3f_div		;// %r10    := vec / [mag,mag,mag]
		xadd		%sp, %sp, 12
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
float vec3f_mag(const vec3f* vec) {
	return sqrtf(vec3f_mag2(vec));
}
float vec3f_mag2(const vec3f* vec) {
	return vec3f_dot(vec, vec);
}
float vec3f_dot(const vec3f* vec1, const vec3f* vec2) {
	return (vec1->x * vec2->x) + (vec1->y * vec2->y) + (vec1->z * vec2->z);
}
#else /*NOASM*/
//{{2008/08/19:vec2fvec3f̏𓝍邽ߍ폜܂B
//asm("
//		.code
//		.align		1
//		.global		vec3f_mag
//		.global		vec3f_mag2
//		.global		vec3f_dot
//vec3f_mag:
//		call		vec3f_mag2
//		xjp.d		sqrtf
//		ld.w		%r12, %r10		;//							*delay*
//		;//-------------------------------------;
//vec3f_mag2:
//		ld.w		%r13, %r12
//		;//-------------------------------------;
//vec3f_dot:
//		ld.w		%r4, %r12		;// %r4  := vec1
//		ld.w		%r5, %r13		;// %r5  := vec2
//		ld.w		%r6, 3			;// %r6  := cnt
//		ld.w		%r7, 0			;// %r7  := sum
//vec3f_dot_loop:
//		ld.w		%r12, [%r4]+		;// %r12 := vec1->x
//		ld.w		%r13, [%r5]+		;// %r13 :=           vec2->x
//		xcall		__mulsf3		;// %r10 := vec1->x * vec2->x
//		ld.w		%r12, %r10		;// %r13 := vec1->x * vec2->x
//		xcall.d		__addsf3		;// %r10 := vec1->x * vec2->x + sum
//		ld.w		%r13, %r7		;// %r12 :=                     sum			*delay*
//		sub		%r6, 1			;// %r6  := cnt--
//		jrne.d		vec3f_dot_loop
//		ld.w		%r7, %r10		;// %r7  := sum						*delay*
//		ret.d
//		ld.w		%r10, %r7		;// %r10 := sum						*delay*
//");
//}}2008/08/19:vec2fvec3f̏𓝍邽ߍ폜܂B
//* Tue Aug 19 23:47:09 JST 2008 Naoyuki Sawa
//- vec2f̃AZuɕāAvec2fvec3f̏𓝍܂B
asm("
		.code
		.align		1
		.global		vec2f_mag
		.global		vec2f_mag2
		.global		vec2f_dot
		.global		vec3f_mag
		.global		vec3f_mag2
		.global		vec3f_dot
;//-----------------------------------------------------;
vec2f_mag:
		call		vec2f_mag2
		xjp.d		sqrtf
		ld.w		%r12, %r10		;//							*delay*
		;//-------------------------------------;
vec2f_mag2:
		ld.w		%r13, %r12
		;//-------------------------------------;
vec2f_dot:
		jp.d		vec2f_vec3f_dot
		ld.w		%r4, 2			;// %r4  := cnt						*delay*
;//-----------------------------------------------------;
vec3f_mag:
		call		vec3f_mag2
		xjp.d		sqrtf
		ld.w		%r12, %r10		;//							*delay*
		;//-------------------------------------;
vec3f_mag2:
		ld.w		%r13, %r12
		;//-------------------------------------;
vec3f_dot:
		ld.w		%r4, 3			;// %r4  := cnt
;//-----------------------------------------------------;
vec2f_vec3f_dot:
		ld.w		%r5, %r12		;// %r5  := vec1
		ld.w		%r6, %r13		;// %r6  := vec2
		ld.w		%r7, 0			;// %r7  := sum
vec2f_vec3f_dot_loop:
		ld.w		%r12, [%r5]+		;// %r12 := vec1->x
		ld.w		%r13, [%r6]+		;// %r13 :=           vec2->x
		xcall		__mulsf3		;// %r10 := vec1->x * vec2->x
		ld.w		%r12, %r10		;// %r13 := vec1->x * vec2->x
		xcall.d		__addsf3		;// %r10 := vec1->x * vec2->x + sum
		ld.w		%r13, %r7		;// %r12 :=                     sum			*delay*
		sub		%r4, 1			;// %r4  := cnt--
		jrne.d		vec2f_vec3f_dot_loop
		ld.w		%r7, %r10		;// %r7  := sum						*delay*
		ret.d
		ld.w		%r10, %r7		;// %r10 := sum						*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
vec3f vec3f_cross(const vec3f* vec1, const vec3f* vec2) {
	vec3f tmp;
	tmp.x = (vec1->y * vec2->z) - (vec1->z * vec2->y);
	tmp.y = (vec1->z * vec2->x) - (vec1->x * vec2->z);
	tmp.z = (vec1->x * vec2->y) - (vec1->y * vec2->x);
	return tmp;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec3f_cross
vec3f_cross:
		pushn		%r3
		ld.w		%r0, %r12		;// %r0  := ʂi[\̂̃AhX
		ld.w		%r1, [%r13]+		;// %r1  := vec1->x
		ld.w		%r2, [%r13]+		;// %r2  := vec1->y
		ld.w		%r3, [%r13]		;// %r3  := vec1->z
		ld.w		%r4, [%r14]+		;// %r4  := vec2->x
		ld.w		%r5, [%r14]+		;// %r5  := vec2->y
		ld.w		%r6, [%r14]		;// %r6  := vec2->z
		;//
		ld.w		%r12, %r2		;// %r12 := vec1->y
		xcall.d		__mulsf3		;// %r10 := vec1->y * vec2->z
		ld.w		%r13, %r6		;// %r13 :=           vec2->z				*delay*
		ld.w		%r7, %r10		;// %r7  := vec1->y * vec2->z
		ld.w		%r12, %r3		;// %r12 :=                     vec1->z
		xcall.d		__mulsf3		;// %r10 :=                     vec1->z * vec2->y
		ld.w		%r13, %r5		;// %r13 :=                               vec2->y	*delay*
		ld.w		%r12, %r7		;// %r12 := vec1->y * vec2->z
		xcall.d		__subsf3		;// %r10 := vec1->y * vec2->z - vec1->z * vec2->y
		ld.w		%r13, %r10		;// %r13 :=                     vec1->z * vec2->y	*delay*
		ld.w		[%r0]+, %r10
		;//
		ld.w		%r12, %r3		;// %r12 := vec1->z
		xcall.d		__mulsf3		;// %r10 := vec1->z * vec2->x
		ld.w		%r13, %r4		;// %r13 :=           vec2->x				*delay*
		ld.w		%r7, %r10		;// %r7  := vec1->z * vec2->x
		ld.w		%r12, %r1		;// %r12 :=                     vec1->x
		xcall.d		__mulsf3		;// %r10 :=                     vec1->x * vec2->z
		ld.w		%r13, %r6		;// %r13 :=                               vec2->z	*delay*
		ld.w		%r12, %r7		;// %r12 := vec1->z * vec2->x
		xcall.d		__subsf3		;// %r10 := vec1->z * vec2->x - vec1->x * vec2->z
		ld.w		%r13, %r10		;// %r13 :=                     vec1->x * vec2->z	*delay*
		ld.w		[%r0]+, %r10
		;//
		ld.w		%r12, %r1		;// %r12 := vec1->x
		xcall.d		__mulsf3		;// %r10 := vec1->x * vec2->y
		ld.w		%r13, %r5		;// %r13 :=           vec2->y				*delay*
		ld.w		%r7, %r10		;// %r7  := vec1->x * vec2->y
		ld.w		%r12, %r2		;// %r12 :=                     vec1->y
		xcall.d		__mulsf3		;// %r10 :=                     vec1->y * vec2->x
		ld.w		%r13, %r4		;// %r13 :=                               vec2->x	*delay*
		ld.w		%r12, %r7		;// %r12 := vec1->x * vec2->y
		xcall.d		__subsf3		;// %r10 := vec1->x * vec2->y - vec1->y * vec2->x
		ld.w		%r13, %r10		;// %r13 :=                     vec1->y * vec2->x	*delay*
		ld.w		[%r0]+, %r10
		;//
		ld.w		%r10, %r0		;// %r10 := ʂi[\̂̃AhX + 12
		popn		%r3
		ret.d
		sub		%r10, 12		;// %r10 := ʂi[\̂̃AhX		*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

/* _Ԃ̋߂ */
#ifdef NOASM
float vec3f_dist(const vec3f* vec1, const vec3f* vec2) {
	return sqrtf(vec3f_dist2(vec1, vec2));
}
/* _Ԃ̋̓߂ */
float vec3f_dist2(const vec3f* vec1, const vec3f* vec2) {
	vec3f tmp = *vec1;
	vec3f_sub(&tmp, vec2);
	return vec3f_mag2(&tmp);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec3f_dist
		.global		vec3f_dist2
vec3f_dist:
		call		vec3f_dist2		;// %r10    := vec3f_dist2(vec1, vec2)
		xjp.d		sqrtf
		ld.w		%r12, %r10		;//										*delay*
vec3f_dist2:
		xsub		%sp, %sp, 12
		;//
		ld.w		%r4, [%r12]+		;// %r4     := vec1->x
		ld.w		%r5, [%r12]+		;// %r5     := vec1->y
		ld.w		%r6, [%r12]		;// %r6     := vec1->z
		xld.w		[%sp+0], %r4		;// [%sp+0] := tmp.x = vec1->x
		xld.w		[%sp+4], %r5		;// [%sp+4] := tmp.y = vec1->y
		xld.w		[%sp+8], %r6		;// [%sp+8] := tmp.z = vec1->z
		;//
		ld.w		%r12, %sp		;// %r12    :=           &tmp
		xcall		vec3f_sub		;//            vec3f_sub(&tmp, vec2)
		;//
		ld.w		%r12, %sp		;// %r12    :=            &tmp
		xcall		vec3f_mag2		;// %r10    := vec3f_mag2(&tmp)
		;//
		xadd		%sp, %sp, 12
		ret
");
#endif /*NOASM*/

/****************************************************************************
 *	_s(3D)
 ****************************************************************************/

const mat3f mat3f_0 = {
	0.0f, 0.0f, 0.0f, 0.0f,
	0.0f, 0.0f, 0.0f, 0.0f,
	0.0f, 0.0f, 0.0f, 0.0f,
};
const mat3f mat3f_1 = {
	1.0f, 0.0f, 0.0f, 0.0f,
	0.0f, 1.0f, 0.0f, 0.0f,
	0.0f, 0.0f, 1.0f, 0.0f,
};

/*--------------------------------------------------------------------------*/

void mat3f_xlate(mat3f* mat, float x, float y, float z) {
	mat3f tmp = {
		1.0f, 0.0f, 0.0f, x,
		0.0f, 1.0f, 0.0f, y,
		0.0f, 0.0f, 1.0f, z,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_scale(mat3f* mat, float x, float y, float z) {
	mat3f tmp = {
		   x, 0.0f, 0.0f, 0.0f,
		0.0f,    y, 0.0f, 0.0f,
		0.0f, 0.0f,    z, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_rot(mat3f* mat, const vec3f* axis, float ang) {
	float s = sinf(ang);
	float c = cosf(ang);
	float ic = 1.0f - c;
	vec3f _axis = *axis;
	vec3f_normal(&_axis);
	{
		mat3f tmp = {
			(_axis.x * _axis.x * ic) + (          c), (_axis.x * _axis.y * ic) - (_axis.z * s), (_axis.x * _axis.z * ic) + (_axis.y * s), 0.0f,
			(_axis.y * _axis.x * ic) + (_axis.z * s), (_axis.y * _axis.y * ic) + (          c), (_axis.y * _axis.z * ic) - (_axis.x * s), 0.0f,
			(_axis.z * _axis.x * ic) - (_axis.y * s), (_axis.z * _axis.y * ic) + (_axis.x * s), (_axis.z * _axis.z * ic) + (          c), 0.0f,
		};
		mat3f_xform(mat, &tmp);
	}
}

/*--------------------------------------------------------------------------*/

void mat3f_rotx(mat3f* mat, float ang) {
	float s = sinf(ang);
	float c = cosf(ang);
	mat3f tmp = {
		1.0f, 0.0f, 0.0f, 0.0f,
		0.0f,    c,   -s, 0.0f,
		0.0f,    s,    c, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_roty(mat3f* mat, float ang) {
	float s = sinf(ang);
	float c = cosf(ang);
	mat3f tmp = {
		   c, 0.0f,    s, 0.0f,
		0.0f, 1.0f, 0.0f, 0.0f,
		  -s, 0.0f,    c, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_rotz(mat3f* mat, float ang) {
	float s = sinf(ang);
	float c = cosf(ang);
	mat3f tmp = {
		   c,   -s, 0.0f, 0.0f,
		   s,    c, 0.0f, 0.0f,
		0.0f, 0.0f, 1.0f, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_invno(mat3f* mat) {
	mat3f tmp = {
		mat->a00, mat->a10, mat->a20, -((mat->a00 * mat->a03) + (mat->a10 * mat->a13) + (mat->a20 * mat->a23)),
		mat->a01, mat->a11, mat->a21, -((mat->a01 * mat->a03) + (mat->a11 * mat->a13) + (mat->a21 * mat->a23)),
		mat->a02, mat->a12, mat->a22, -((mat->a02 * mat->a03) + (mat->a12 * mat->a13) + (mat->a22 * mat->a23)),
	};
	*mat = tmp;
}

void mat3f_inv(mat3f* mat) { /* ts߂܂BKsłȂĂ\܂B */
	int i;
	int j;
	float d;
	float m[4 * 4];

	/* ꎞIȁAs쐬܂B */
	memcpy(m, mat, sizeof(mat3f));
	m[(4 * 3) + 0] = 0.0f;
	m[(4 * 3) + 1] = 0.0f;
	m[(4 * 3) + 2] = 0.0f;
	m[(4 * 3) + 3] = 1.0f;

	/* ŇpāAts߂܂B */
	d = matnf_determinant(m, 4);
	for(i = 0; i < 3; i++) {
		for(j = 0; j < 4; j++) {
			((float(*)[4])mat)[i][j] = matnf_cofactor(m, 4, j, i) / d;
		}	//                                    !!~~~~
	}
}

/*--------------------------------------------------------------------------*/

void mat3f_orient(mat3f* mat, const vec3f* forward, const vec3f* up) {
	vec3f _forward;
	vec3f _right;
	vec3f _up;
	_forward = *forward;
	vec3f_normal(&_forward);
	_right = vec3f_cross(up, &_forward);
	vec3f_normal(&_right);
	_up = vec3f_cross(&_forward, &_right);
	{
		mat3f tmp = {
			_right.x, _up.x, _forward.x, 0.0f,
			_right.y, _up.y, _forward.y, 0.0f,
			_right.z, _up.z, _forward.z, 0.0f,
		};
		mat3f_xform(mat, &tmp);
	}
}

/*--------------------------------------------------------------------------*/

void mat3f_lookat(mat3f* mat, const vec3f* eye, const vec3f* center, float ang) {
	vec3f forward;
	mat3f tmp = mat3f_1;
	mat3f_xlate(&tmp, eye->x, eye->y, eye->z);
	forward = *center;
	vec3f_sub(&forward, eye);
	mat3f_orient(&tmp, &forward, &vec3f_y);
	mat3f_rotz(&tmp, ang);
	mat3f_invno(&tmp);
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_frustum(mat3f* mat, float width, float height, float front) {
	mat3f tmp = {
		2.0f * front / width,                  0.0f, 0.0f, 0.0f,
		                0.0f, 2.0f * front / height, 0.0f, 0.0f,
		                0.0f,                  0.0f, 1.0f, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat3f_perspect(mat3f* mat, float fovy, float aspect, float front) {
	float height = front * tanf(fovy / 2.0f) * 2.0f;
	float width = height * aspect;
	mat3f_frustum(mat, width, height, front);
}

/*--------------------------------------------------------------------------*/

void mat3f_viewportz(mat3f* mat, int left, int top, int width, int height) {
	mat3f tmp = {
		width / 2.0f,           0.0f, left + width / 2.0f, 0.0f,
		        0.0f, -height / 2.0f, top + height / 2.0f, 0.0f,
		        0.0f,           0.0f,                1.0f, 0.0f,
	};
	mat3f_xform(mat, &tmp);
}

/****************************************************************************
 *	_xNg(2D)
 ****************************************************************************/

const vec2f vec2f_0 = { 0.0f, 0.0f };
const vec2f vec2f_1 = { 1.0f, 1.0f };
const vec2f vec2f_x = { 1.0f, 0.0f };
const vec2f vec2f_y = { 0.0f, 1.0f };

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void vec2f_xform(const mat2f* mat, vec2f* vec) {
	vec2f tmp = *vec;
	vec->x = (mat->a00 * tmp.x) + (mat->a01 * tmp.y) + mat->a02;
	vec->y = (mat->a10 * tmp.x) + (mat->a11 * tmp.y) + mat->a12;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec2f_xform
vec2f_xform:
		pushn		%r1
		;//
		ld.w		%r0, %r12		;// %r0  := mat
		ld.w		%r1, %r13		;// %r1  := vec
		ld.w		%r4, 2			;// %r4  := cnt
		ld.w		%r5, [%r13]+		;// %r5  := tmp.x
		ld.w		%r6, [%r13]		;// %r6  := tmp.y
vec2f_xform_loop:
		ld.w		%r12, [%r0]+		;// %r12 :=        mat->a00        , %r0  := &mat->a01
		xcall.d		__mulsf3		;// %r10 := sum  = mat->a00 * tmp.x
		ld.w		%r13, %r5		;// %r13 :=                   tmp.x			*delay*
		ld.w		%r7, %r10		;// %r7  := sum
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=        mat->a01        , %r0  := &mat->a02
		xcall.d		__mulsf3		;// %r10 :=        mat->a01 * tmp.y
		ld.w		%r13, %r6		;// %r13 :=                   tmp.y			*delay*
		ld.w		%r12, %r10		;// %r12 :=        mat->a01 * tmp.y
		xcall.d		__addsf3		;// %r10 := sum += mat->a01 * tmp.y
		ld.w		%r13, %r7		;// %r13 := sum						*delay*
		;//
		ld.w		%r12, [%r0]+		;// %r12 :=        mat->a02        , %r0  := &mat->a10
		xcall.d		__addsf3		;// %r10 := sum += mat->a02
		ld.w		%r13, %r10		;// %r13 := sum						*delay*
		;//
		ld.w		[%r1]+, %r10		;// vec->x = sum
		sub		%r4, 1			;// %r4  := cnt--
		jrne		vec2f_xform_loop
		;//
		popn		%r1
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void vec2f_add(vec2f* vec1, const vec2f* vec2) {
	vec1->x += vec2->x;
	vec1->y += vec2->y;
}
void vec2f_sub(vec2f* vec1, const vec2f* vec2) {
	vec1->x -= vec2->x;
	vec1->y -= vec2->y;
}
void vec2f_mul(vec2f* vec1, const vec2f* vec2) {
	vec1->x *= vec2->x;
	vec1->y *= vec2->y;
}
void vec2f_div(vec2f* vec1, const vec2f* vec2) {
	vec1->x /= vec2->x;
	vec1->y /= vec2->y;
}
void vec2f_neg(vec2f* vec) {
	vec->x = -vec->x;
	vec->y = -vec->y;
}
#else /*NOASM*/
// * Tue Aug 19 23:47:09 JST 2008 Naoyuki Sawa
// - vec2f̃AZuɕāAvec2fvec3f̏𓝍܂B
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void vec2f_normal(vec2f* vec) {
	float mag = vec2f_mag(vec);
	vec->x /= mag;
	vec->y /= mag;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec2f_normal
vec2f_normal:
		xsub		%sp, %sp, 8
		xld.w		[%sp+0], %r12		;// [%sp+0] := vec
		xcall		vec2f_mag		;// %r10    := mag
		xld.w		%r12, [%sp+0]		;// %r12    := vec
		xld.w		[%sp+0], %r10
		xld.w		[%sp+4], %r10
		ld.w		%r13, %sp		;// %r13    :=       [mag,mag]
		xcall		vec2f_div		;// %r10    := vec / [mag,mag]
		xadd		%sp, %sp, 8
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
float vec2f_mag(const vec2f* vec) {
	return sqrtf(vec2f_mag2(vec));
}
float vec2f_mag2(const vec2f* vec) {
	return vec2f_dot(vec, vec);
}
float vec2f_dot(const vec2f* vec1, const vec2f* vec2) {
	return (vec1->x * vec2->x) + (vec1->y * vec2->y);
}
#else /*NOASM*/
// * Tue Aug 19 23:47:09 JST 2008 Naoyuki Sawa
// - vec2f̃AZuɕāAvec2fvec3f̏𓝍܂B
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

#ifdef NOASM
float vec2f_cross(const vec2f* vec1, const vec2f* vec2) {
	return (vec1->x * vec2->y) - (vec1->y * vec2->x);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec2f_cross
vec2f_cross:
		ld.w		%r4, [%r12]+		;// %r4  := vec1->x
		ld.w		%r5, [%r12]		;// %r5  := vec1->y
		ld.w		%r6, [%r13]+		;// %r6  := vec2->x
		;//
		ld.w		%r13, [%r13]		;// %r13 :=            vec2->y
		xcall.d		__mulsf3		;// %r10 := (vec1->x * vec2->y)
		ld.w		%r12, %r4		;// %r12 :=  vec1->x					*delay*
		ld.w		%r4, %r10		;// %r4  := (vec1->x * vec2->y)
		;//
		ld.w		%r12, %r5		;// %r12 :=  vec1->y
		xcall.d		__mulsf3		;// %r10 := (vec1->y * vec2->x)
		ld.w		%r13, %r6		;// %r13 :=            vec2->x				*delay*
		;//
		ld.w		%r12, %r4		;// %r12 := (vec1->x * vec2->y)
		xjp.d		__subsf3		;// %r10 := (vec1->x * vec2->y) - (vec1->y * vec2->x)
		ld.w		%r13, %r10		;// %r13 :=                       (vec1->y * vec2->x)	*delay*
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

/* _Ԃ̋߂ */
#ifdef NOASM
float vec2f_dist(const vec2f* vec1, const vec2f* vec2) {
	return sqrtf(vec2f_dist2(vec1, vec2));
}
/* _Ԃ̋̓߂ */
float vec2f_dist2(const vec2f* vec1, const vec2f* vec2) {
	vec2f tmp = *vec1;
	vec2f_sub(&tmp, vec2);
	return vec2f_mag2(&tmp);
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		vec2f_dist
		.global		vec2f_dist2
vec2f_dist:
		call		vec2f_dist2		;// %r10    := vec2f_dist2(vec1, vec2)
		xjp.d		sqrtf
		ld.w		%r12, %r10		;//										*delay*
vec2f_dist2:
		xsub		%sp, %sp, 8
		;//
		ld.w		%r4, [%r12]+		;// %r4     := vec1->x
		ld.w		%r5, [%r12]		;// %r5     := vec1->y
		xld.w		[%sp+0], %r4		;// [%sp+0] := tmp.x = vec1->x
		xld.w		[%sp+4], %r5		;// [%sp+4] := tmp.y = vec1->y
		;//
		ld.w		%r12, %sp		;// %r12    :=           &tmp
		xcall		vec2f_sub		;//            vec2f_sub(&tmp, vec2)
		;//
		ld.w		%r12, %sp		;// %r12    :=            &tmp
		xcall		vec2f_mag2		;// %r10    := vec2f_mag2(&tmp)
		;//
		xadd		%sp, %sp, 8
		ret
");
#endif /*NOASM*/

/****************************************************************************
 *	_s(2D)
 ****************************************************************************/

const mat2f mat2f_0 = {
	0.0f, 0.0f, 0.0f,
	0.0f, 0.0f, 0.0f,
};
const mat2f mat2f_1 = {
	1.0f, 0.0f, 0.0f,
	0.0f, 1.0f, 0.0f,
};

/*--------------------------------------------------------------------------*/

#ifdef NOASM
void mat2f_xform(mat2f* mat1, const mat2f* mat2) {
	mat2f tmp = *mat1;
	mat1->a00 = (tmp.a00 * mat2->a00) + (tmp.a01 * mat2->a10);
	mat1->a01 = (tmp.a00 * mat2->a01) + (tmp.a01 * mat2->a11);
	mat1->a02 = (tmp.a00 * mat2->a02) + (tmp.a01 * mat2->a12) + tmp.a02;
	mat1->a10 = (tmp.a10 * mat2->a00) + (tmp.a11 * mat2->a10);
	mat1->a11 = (tmp.a10 * mat2->a01) + (tmp.a11 * mat2->a11);
	mat1->a12 = (tmp.a10 * mat2->a02) + (tmp.a11 * mat2->a12) + tmp.a12;
}
#else /*NOASM*/
asm("
		.code
		.align		1
		.global		mat2f_xform
mat2f_xform:
		pushn		%r2
		xsub		%sp, %sp, 24		;// %sp  := &tmp
		ld.w		%r0, %r12		;// %r0  := mat1
		ld.w		%r1, %r13		;// %r1  := mat2
		ld.w		%r12, %sp		;// %r12 := &tmp
		xld.w		%r14, 24		;// %r14 :=             sizeof(mat2f)
		xcall.d		memcpy			;//  memcpy(&tmp, mat1, sizeof(mat2f))
		ld.w		%r13, %r0		;// %r13 :=       mat1					*delay*
		;//
		xld.w		%r2, __mulsf3		;// %r2  := __mulsf3
		xld.w		%r4, __addsf3		;// %r4  := __addsf3
		ld.w		%r5, 2			;// %r5  := cnt1
		;//-------------------------------------;
mat2f_xform_lp1:
		ld.w		%r6, 3			;// %r6  := cnt2
		;//-------------------------------------;
mat2f_xform_lp2:
		xld.w		%r12, [%sp+0]		;// %r12 :=        tmp.a00
		ld.w		%r13, [%r1]		;// %r13 :=                  mat2->a00
		call.d		%r2			;// %r10 := sum  = tmp.a00 * mat2->a00 -+
		add		%r1, 12			;// %r1  :=                 &mat2->a10  |		*delay*
		;//					;//                                     |
		xld.w		%r12, [%sp+4]		;// %r12 :=        tmp.a01              |
		ld.w		%r13, [%r1]		;// %r13 :=                  mat2->a10  |
		call.d		%r2			;// %r10 :=        tmp.a01 * mat2->a10 -|-+
		ld.w		%r7, %r10		;// %r7  := sum <-----------------------+ |		*delay*
		;//					;//                                       |
		ld.w		%r12, %r10		;// %r12 :=        tmp.a01 * mat2->a10 <--+
		call.d		%r4			;// %r10 := sum += tmp.a01 * mat2->a10 -----+
		ld.w		%r13, %r7		;// %r13 := sum                             |		*delay*
		;//					;//                                         |
		sub		%r6, 1			;// %r6  := cnt2--                          |
		jreq		4			;// if(cnt2)                                |
		 ld.w		[%r0]+, %r10		;//   mat1->a00 = sum, %r0  := &mat1->a01 <-+
		 jp.d		mat2f_xform_lp2		;//                                         |
		 sub		%r1, 8			;//                    %r1  := &mat2->a01   |		*delay*
		;//-------------------------------------;// else                                    |
		xld.w		%r12, [%sp+8]		;//   %r12 :=        tmp.a02                |
		call.d		%r4			;//   %r10 := sum += tmp.a02 ---------------|-+
		ld.w		%r13, %r10		;//   %r13 := sum <-------------------------+ |		*delay*
		ld.w		[%r0]+, %r10		;//   mat1->a02 = sum, %r0  := &mat1->a10 <---+
		;//
		xadd		%sp, %sp, 12		;//                    %sp  :=   &tmp.a10
		sub		%r5, 1			;//   %r5  := cnt1--
		jrne.d		mat2f_xform_lp1
		sub		%r1, 20			;//                    %r1  := &mat2->a00		*delay*
		;//-------------------------------------;
		;// %sp2+12ĊɌɖ߂Ă܂B
		popn		%r2
		ret
");
#endif /*NOASM*/

/*--------------------------------------------------------------------------*/

void mat2f_xlate(mat2f* mat, float x, float y) {
	mat2f tmp = {
		1.0f, 0.0f, x,
		0.0f, 1.0f, y,
	};
	mat2f_xform(mat, &tmp);
}
void mat2f_scale(mat2f* mat, float x, float y) {
	mat2f tmp = {
		   x, 0.0f, 0.0f,
		0.0f,    y, 0.0f,
	};
	mat2f_xform(mat, &tmp);
}
void mat2f_rot(mat2f* mat, float ang) {
	float s = sinf(ang);
	float c = cosf(ang);
	mat2f tmp = {
		c, -s, 0.0f,
		s,  c, 0.0f,
	};
	mat2f_xform(mat, &tmp);
}

/*--------------------------------------------------------------------------*/

void mat2f_invno(mat2f* mat) {
	mat2f tmp = {
		mat->a00, mat->a10, -((mat->a00 * mat->a02) + (mat->a10 * mat->a12)),
		mat->a01, mat->a11, -((mat->a01 * mat->a02) + (mat->a11 * mat->a12)),
	};
	*mat = tmp;
}

void mat2f_inv(mat2f* mat) { /* ts߂܂BKsłȂĂ\܂B */
	int i;
	int j;
	float d;
	float m[3 * 3];

	/* ꎞIȁAs쐬܂B */
	memcpy(m, mat, sizeof(mat2f));
	m[(3 * 2) + 0] = 0.0f;
	m[(3 * 2) + 1] = 0.0f;
	m[(3 * 2) + 2] = 1.0f;

	/* ŇpāAts߂܂B */
	d = matnf_determinant(m, 3);
	for(i = 0; i < 2; i++) {
		for(j = 0; j < 3; j++) {
			((float(*)[3])mat)[i][j] = matnf_cofactor(m, 3, j, i) / d;
		}	//                                    !!~~~~
	}
}

/****************************************************************************
 *	ts߂邽߂ɗpTu[`
 ****************************************************************************/

//m[ns][n]̍s(determinant)߂܂B
static float matnf_determinant(const float* m/*[n][n]*/, int n) {
	int i;
	float d;
	if(n < 1) { DIE(); }
	//]qWJpāAs(determinant)߂܂B
	d = 0.0f;
	for(i = 0; i < n; i++) {
		d += (m[(n * i) + 0/*j*/] * matnf_cofactor(m, n, i, 0/*j*/));
	}
	return d;
}
//m[ns][n]isjA]q(cofactor)߂܂B
static float matnf_cofactor(const float* m/*[n][n]*/, int n, int i, int j) {
	int k, l;
	float d;
	float* s/*[n-1][n-1]*/;
	float* t/*[n-1][n-1]*/;
	if((n < 1) ||
	   (i < 0) || (i > (n - 1)) ||
	   (j < 0) || (j > (n - 1))) { DIE(); }
	//m[ns][n]isjAs(submatrix)쐬܂B
	if(n == 1) { return 1; } //s0s0ɂȂꍇ
//{{2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
//	s = malloc(sizeof(float) * ((n - 1) * (n - 1)));
//	if(!s) { DIE(); }
//2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
// * Tue Mar 08 21:16:31 JST 2016 Naoyuki Sawa
// - solve_simultaneous_equations()}`Xbh܂B
// - L̕ύX̂߂ɁAWin32Ń}`Xbhgꍇ́Amatnf_cofactor()ŁAmalloc()ł͂Ȃalloca()g悤ɏC܂B
//   matnf_cofactor()ċAŉxĂяoA}`Xbhmalloc()̔rŒ񉻂A}`XbȟʂȂłB
//   ȂƁA}`XbhpĒxȂĂ܂܂B
//   ڍׂ́Aq́u}`Xbhsolve_simultaneous_equations()̌،ʁvQƂĉB
// - Aۂɂ́AWin32Ń}`XbhgꍇłȂAWin32ŃVOXbh̏ꍇAalloca()ĝłA
//   Ƀ}`Xbh̏ꍇalloca()gK{ł鎖邽߂ɁAVOXbh̏ꍇmalloc()̂܂܂ɂ鎖ɂ܂B
// - P/ECEł́A܂ŒʂAmalloc()g܂B
//   P/ECE̓Ǝalloca() (clipalca.cQ)́A݊̂߂Ɏ̂łAmalloc()łB
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	s = malloc(sizeof(float) * ((n - 1) * (n - 1)));
	if(!s) { DIE(); }
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
	s = alloca(sizeof(float) * ((n - 1) * (n - 1)));
#endif//!(defined(_WIN32)&&defined(_MT))
//}}2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
	t = s;
	for(k = 0; k < n; k++) {
		for(l = 0; l < n; l++) {
			if((k != i) && (l != j)) {
				*t++ = *m;
			}
			m++;
		}
	}
	//s(minor determinant)߂܂B
	d = matnf_determinant(s, (n - 1));
	//]q(cofactor)߂܂B
	if((i ^ j) & 1) { d = -d; }
	//s܂B
//{{2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
//	free(s);
//2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
	free(s);
#endif//!(defined(_WIN32)&&defined(_MT))
//}}2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
	return d;
}

/****************************************************************************
 *	A
 ****************************************************************************/

//{{2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
//void solve_simultaneous_equations(const float* A/*[n][n]*/, const float* b/*[n]*/, float* x/*[n]*/, int n) {
//	int i;
//	int j;
//	float d;
//	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
//	d = matnf_determinant(A, n);
//	for(i = 0; i < n; i++) {
//		x[i] = 0.0f;
//		for(j = 0; j < n; j++) {
//			x[i] += (matnf_cofactor(A, n, j, i) / d) * b[j];
//			//                  !!~~~~
//		}
//	}
//}
//2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B
#if     !(defined(_WIN32)&&defined(_MT))
//Win32VOXbh̏ꍇ,P/ECȄꍇ,̑̊̏ꍇɗLȃubN
void solve_simultaneous_equations(const float* A/*[n][n]*/, const float* b/*[n]*/, float* x/*[n]*/, int n) {
	int i, j;
	float d;
	//s(determinant)߂܂B
	d = matnf_determinant(A, n);
	//ŇpāAA̋ts߂ȂAb|āAx߂܂B
	for(i = 0; i < n; i++) {
		x[i] = 0.0f;
		for(j = 0; j < n; j++) {
			x[i] += (matnf_cofactor(A, n, j, i) / d) * b[j];
			//                  !!~~~~
		}
	}
}
#else //!(defined(_WIN32)&&defined(_MT))
//Win32}`Xbh̏ꍇɗLȃubN
struct _ST_solve_simultaneous_equations {
	const float*		A/*[n][n]*/;	//solve_simultaneous_equations()̈ƓłBsolve_simultaneous_equations_start_routine()͎QƐpłBĂ͂܂B
	const float*		b/*[n]*/;	//
	float*			x/*[n]*/;	//
	int			n;		//
	float			d;		//solve_simultaneous_equations()li[܂Bsolve_simultaneous_equations_start_routine()͎QƐpłBĂ͂܂B
	volatile int		i;		//i0nBsolve_simultaneous_equations_start_routine()ǂݏ܂Biǂݏ鎞csbNĉB
	CRITICAL_SECTION 	cs;		//
};
static unsigned __stdcall solve_simultaneous_equations_start_routine(void* _arg) {
	struct _ST_solve_simultaneous_equations* arg = _arg;
	const float* const A = arg->A;
	const float* const b = arg->b;
	float*       const x = arg->x;
	int          const n = arg->n;
	float        const d = arg->d;
	for(;;) {
		int i, j;
	    EnterCriticalSection(&arg->cs);	//{{arg->i̓ǂݏ:
		i = arg->i;
		if(i != n) { arg->i = (i + 1); }
	    LeaveCriticalSection(&arg->cs);	//}}arg->i̓ǂݏ:܂
		if(i == n) { break; }
		x[i] = 0.0f;
		for(j = 0; j < n; j++) {
			x[i] += (matnf_cofactor(A, n, j, i) / d) * b[j];
			//                  !!~~~~
		}
	}
	return 0;
}
void solve_simultaneous_equations(const float* A/*[n][n]*/, const float* b/*[n]*/, float* x/*[n]*/, int n) {
	struct _ST_solve_simultaneous_equations arg;
	HANDLE hThread[16/**/];	//֐쐬Xbh̐͂̔zTCYƂȂB2016/03/08݂16XbhƂB16RAȏCPUʓIɂȂꍇ͂̔zTCY𑝂₹B
	int nThread, iThread;
	SYSTEM_INFO si;
	//\̂B
	arg.A = A;
	arg.b = b;
	arg.x = x;
	arg.n = n;
	arg.d = matnf_determinant(A, n);	//s(determinant)߂܂B
	arg.i = 0;
	//NeBJZNV쐬B
	InitializeCriticalSection(&arg.cs);
	//Xbh߂邽߂ɁACPU̘_RA擾B
	GetSystemInfo(&si);
	nThread = si.dwNumberOfProcessors;
	//CPU̘_RAAhThread[]z̃TCYꍇ́A؂l߂B
	if(nThread > ARRAY_SIZE(hThread)) { nThread = ARRAY_SIZE(hThread); }
	//CPU̘_RAAz̎ꍇ́A؂l߂B
	// - z̎葽Xbh𐶐ĂA͖薳AȂXbhĖʂłB
	if(nThread > n) { nThread = n; }
	//Xbh쐬B
	for(iThread = 0; iThread < nThread; iThread++) {
		hThread[iThread] = (HANDLE)_beginthreadex(NULL,
			0,
			solve_simultaneous_equations_start_routine,
			&arg,
			0,
			NULL);
		if(!hThread[iThread]) { DIE(); }	//oO,,\[Xs
	}
	//Xbh̊҂B
	iThread = WaitForMultipleObjects(nThread, hThread, TRUE, INFINITE);
	if((unsigned)(iThread - WAIT_OBJECT_0) >= (unsigned)nThread) { DIE(); }	//oO
	//XbhJB
	for(iThread = 0; iThread < nThread; iThread++) {
		if(!CloseHandle(hThread[iThread])) { DIE(); }	//oO
	}
	//NeBJZNV폜B
	DeleteCriticalSection(&arg.cs);	//YȂ!!
}
#endif//!(defined(_WIN32)&&defined(_MT))
//}}2016/03/08ύX:solve_simultaneous_equations()}`Xbh܂B

#if 0

}`Xbhsolve_simultaneous_equations()̌،

eXgvO
void test() {
  static const float A[10*10]={1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                               1, 1, 1,-1, 1, 1, 1, 1, 1, 1,
                               1, 1,-1, 1, 2, 3, 4, 4, 4, 4,
                               1,-1, 1, 1, 1, 1, 2, 2, 2, 2,
                               1, 1, 9, 1, 3, 1, 1, 1, 1, 1,
                               1, 1, 8, 1, 1, 1, 4, 4, 4, 4,
                               1, 1, 7, 1, 1, 1, 1, 5, 5, 5,
                               1, 1, 7, 1, 1, 1, 1, 1, 1, 3,
                               1, 1, 7, 1, 1, 1, 1, 1, 1, 1,
                               1, 1, 7, 1, 1, 1, 2, 3, 1, 1};
  static const float b[   10]={0, 4,-4, 2, 2, 2, 3, 5, 6, 7};
               float x[   10];
  int i,t=GetTickCount();
  solve_simultaneous_equations(A,b,x,ARRAY_SIZE(x));
  t=GetTickCount()-t;
  for(i=0;i<ARRAY_SIZE(x);i++){printf("x[%d]=% f\n",i,x[i]);}
  printf("time=%d\n",t);
}

x[0]= 4.500000
x[1]=-1.833333
x[2]= 1.000000
x[3]=-2.000000
x[4]=-3.000000
x[5]= 3.000000
x[6]=-0.916667
x[7]= 0.958333
x[8]=-1.208333
x[9]=-0.500000
ĽʂƂAuxvZTCg - s(n)v(http://keisan.casio.jp/exec/system/1279265553)łvZĊmFB
ȉ́Aǂ̃eXgEǂ̃Xbh\łAĽʂɂȂ鎖mFB

eXg
OS  Windows 10 Home
CPU Core i7-4500U
RAM 8 GB

 1XbhAmalloc()gp	time=13719	malloc()gƃXbhقǒxȂĂB֐malloc()̎gppx̂ŁAmalloc()Œ񉻂ă}`XbȟʂꂸAI[o[wbhĂ̂낤B
E 2XbhAmalloc()gp	time=22578	Ã݂rhłBoehm GCpĂAL̃eXgvOŎgpAP[^́AVC++6.0WLIBCMTmalloc()ł͂ȂABoehm GCGC_MALLOC()łB
E 4XbhAmalloc()gp	time=38766	Boehm GCGC_MALLOC()LIBCMTmalloc()x\͗L邪ALIBCMTmalloc()ł炩̔rsĂ͂łALIBCMTmalloc()gƂẴeXgʂƓXɂȂƎvB
E 1XbhAalloca()gp	time= 2781	
E 2XbhAalloca()gp	time= 1750	alloca()gƃXbhقǑȂĂB_́A'4XbhAalloca()gp'ACPUł̍œKȍ\ł͂BA24̍ȂlāAHyperThreadinǧʂ͏悤B
 4XbhAalloca()gp	time= 1625	
E10XbhAalloca()gp	time= 1437	ɁAs񎮂̎ł10XbhɕĂ݂ƁÂ4XbhȂBCPU̘_RAȏɕĂȂ͂Ȃ̂c TurboBoostł|Ă̂낤?
2016/03/08ύXÕvO\ł́A''̓łB
2016/03/08ύX̃vO\ł́A''̓ɂȂ܂B

eXg
OS  Windows XP Home
CPU Pentium 4 530
RAM 1.5 GB

 1XbhAmalloc()gp	time=65641	
E 2XbhAmalloc()gp	time=66343	Pentium 4ł́A֐̃}`Xbȟʂ͓ꂸAtɒxȂĂ܂܂BFPZ킪(?)̂ŁA֐̂悤FPZ𑽗p鏈ł́AFPZŋĂ܂̂Ǝv܂B
E 1XbhAalloca()gp	time=12984	p̈ŃeXĝŁATM2(ThermalMonitoring2)āAʂxʂɂȂĂ邩m܂BAXbh\Ƃ̑ΓIȔrƂẮÂƂ肾Ǝv܂B
 2XbhAalloca()gp	time=13297	
2016/03/08ύXÕvO\ł́A''̓łB
2016/03/08ύX̃vO\ł́A''̓ɂȂ܂B
#endif

/****************************************************************************
 *	
 ****************************************************************************/
