/*	
 *	clipdmg.h
 *
 *	P/ECE DMG-CPU Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Fri Feb 18 03:32:00 JST 2005 Naoyuki Sawa
 *	- 荞݂ۗ̕ɑΉ܂B
 *	* Fri Feb 18 18:28:00 JST 2005 Naoyuki Sawa
 *	- dmg_reset()GameBoy[IPL@\ǉ܂B
 *	* Tue Feb 22 19:00:00 JST 2005 Naoyuki Sawa
 *	- DMGOP_}NɂāAsTCN̒`ԈႦĂ̂C܂B
 *	  dmg/xx.hAdmg/cb.h̒ł10iŋLqĂ̂ɁAԈႦ16iƉ߂Ă܂Ă܂B
 *	  Ƃ΁A{12TCNׂ߂AԈ0x12=18TCNĂ܂Ă܂B
 *	  ̌̌́ADMGOP_}N`̌^Aclipz80.hZ80OP_}NRs[Ă߂łB
 *	  Z80G~[VW[̎sTCN`́Aۂ16i\L̂ŁA"0x##CYCLE"Ő̂łA
 *	  DMG-CPUG~[VW[̎sTCN`10iɕύXĂ߂ɁAOq̕sv̂łB
 *	  ܂łɁA{DMG-CPUG~[VW[gAvP[V́AuGBSvC[v݂̂łB
 *	  GBSvC[́A100%̃TCNssOHALTŔĂ̂ŁAsTCN̕svI܂łB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_DMG_H__
#define __CLIP_DMG_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* DMG_ASMV{`ǂݍ݂܂B
 * DMG_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipdmga.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define DMG_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef DMG_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef DMG_ASM
#undef DMG_TRACE
#endif /*DMG_ASM*/ 

#ifdef DMG_TRACE
#define DMGTRACE	TRACE
#else /*DMG_TRACE*/
#define DMGTRACE	1 ? ((void)0) : TRACE
#endif /*DMG_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _DMG DMG;

/*
 *	DMGRAO֐̌^`
 */
typedef unsigned char DMGREADPROC (DMG* dmg, unsigned short addr);
typedef          void DMGWRITEPROC(DMG* dmg, unsigned short addr, unsigned char data);

/*
 *	DMGRA
 */
/*typedef*/ struct _DMG {
	/*===== WX^ =====*/
	unsigned short af;		/* + 0, 2 */
	unsigned short bc;		/* + 2, 2 */
	unsigned short de;		/* + 4, 2 */
	unsigned short hl;		/* + 6, 2 */
	unsigned short sp;		/* + 8, 2 */
	unsigned short pc;		/* +10, 2 */
	/*=====  =====*/
	unsigned char ime;		/* +12, 1 */ /* Interrupt Master Enable */
	unsigned char halt;		/* +13, 1 */
	unsigned char _resv1[6];	/* +14, 6 */
	int cycle;			/* +20, 4 */
	/*===== O֐ =====*/
	DMGREADPROC* read;		/* +24, 4 */
	DMGWRITEPROC* write;		/* +28, 4 */
} /*DMG*/;				/* =32    */

/*
 *	CXgNV֐錾
 */
typedef                void DMGOPPROC (DMG* dmg, unsigned char code, int arg);
#define DMGFN_(OP, FN) void dmgop_##FN(DMG* dmg, unsigned char code, int arg);	/* 錾p */
#include "dmg/list.h" /* [dmg.xls]List!C5 */
DMGFN_("CB"   , CB   )
DMGFN_("ERROR", ERROR)
#undef  DMGFN_
#define DMGFN_(FN) void dmgop_##FN(DMG* dmg, unsigned char code, int arg)	/* `p */

/*
 *	IyR[h}bvEj[jbNe[u
 */
typedef struct _DMGOP {
	DMGOPPROC* proc;	/* + 0, 4 */
	unsigned char argc;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 dmg_op_name_table[]̕ւ̃ItZbgł */
} DMGOP;			/* = 8    */
//#define DMGOP_(CODE, PROC, ARGC, CYCLE, NAME)	{ dmgop_##PROC, 0x##ARGC, 0x##CYCLE, 0x##NAME },
//* Tue Feb 22 19:00:00 JST 2005 Naoyuki Sawa
//- DMGOP_}NɂāAsTCN̒`ԈႦĂ̂C܂B
//  dmg/xx.hAdmg/cb.h̒ł10iŋLqĂ̂ɁAԈႦ16iƉ߂Ă܂Ă܂B
//  Ƃ΁A{12TCNׂ߂AԈ0x12=18TCNĂ܂Ă܂B
//  ̌̌́ADMGOP_}N`̌^Aclipz80.hZ80OP_}NRs[Ă߂łB
//  Z80G~[VW[̎sTCN`́Aۂ16i\L̂ŁA"0x##CYCLE"Ő̂łA
//  DMG-CPUG~[VW[̎sTCN`10iɕύXĂ߂ɁAOq̕sv̂łB
//  ܂łɁA{DMG-CPUG~[VW[gAvP[V́AuGBSvC[v݂̂łB
//  GBSvC[́A100%̃TCNssOHALTŔĂ̂ŁAsTCN̕svI܂łB
#define DMGOP_(CODE, PROC, ARGC, CYCLE, NAME)	{ dmgop_##PROC, 0x##ARGC, CYCLE, 0x##NAME },
extern const DMGOP dmg_op_table[256/*XX*/];		/* XX */
extern const DMGOP dmg_op_table_CB[256/*XX*/];		/* CB XX */
extern const char dmg_op_name_table[];			/* j[jbNe[u */

/****************************************************************************
 *	֐
 ****************************************************************************/

/* DMGZbgɐݒ肳ADMGRÃCREAD/WRITE̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char dmg_internal_read (DMG* dmg, unsigned short addr);
         void dmg_internal_write(DMG* dmg, unsigned short addr, unsigned char data);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* DMGZbg܂B
 * [in]
 *	dmg		DMG\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 *	gb_ipl		0ȊO̒lw肷ƁAGameBoy[IPLs܂B
 * [note]
 *	* read,writeNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	DMG\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	DMG\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 */
void dmg_reset(DMG* dmg, DMGREADPROC* read, DMGWRITEPROC* write, int gb_ipl);

/* DMGs܂B
 * [in]
 *	dmg		DMG\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂HALT܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAdmg->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇA  dmg->cycle=-5 ƂȂ܂B
 *	  ܂A cycle=100 ŌĂяoA10 TCNs HALT ꍇ́Admg->cycle=90 ƂȂ܂B
 */
void dmg_run(DMG* dmg, int cycle);

/* * IȊ荞ݗvs֐͂܂B
 *   $FFFF(IE)܂$FF0F(IF)̕ύXɁAdmg_check_pending()ĂяoĂB
 *
 *   <>
 *	// CWrite֐̃Tv
 *	void dmg_write(DMG* dmg, unsigned short addr, unsigned char data) {
 *		switch(addr) {
 *		case 0xff0f: // $FF0F (IF)
 *		case 0xffff: // $FFFF (IE)
 *			mem[addr] = data;
 *			dmg_check_pending(dmg);
 *			return;
 *		}
 *		dmg_internal_write(addr, data);
 *	}
 *	// V-Blank荞ݗṽTv
 *	void dmg_vblank(DMG* dmg) {
 *		mem[0xff0f] |= DMG_V_BLANK;
 *		dmg_check_pending(dmg);
 *	}
 */
void dmg_check_pending(DMG* dmg);

/* $FF0F (IF)A$FFFF (IE) */
#define DMG_V_BLANK			(1<<0)	/* RST $40 */
#define DMG_LCDC_STATUS			(1<<1)	/* RST $48 */
#define DMG_TIMER_OVERFLOW		(1<<2)	/* RST $50 */
#define DMG_SERIAL_TRANSFER_COMPLETION	(1<<3)	/* RST $58 */
#define DMG_HIGH_TO_LOW_OF_P10_P13	(1<<4)	/* RST $60 */

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	dmg		DMG\́B
 */
void dmg_dump(DMG* dmg);

#ifdef PIECE
/* DMGs܂B(X^bNؑցE)
 * [in]
 *	dmg		DMG\́B
 *	cycle		sTCNB
 * [note]
 *	* dmg_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- dmg_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  dmg_run2()̓X^bN0x1000ɈڂAdmg_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAdmg_run2()̎gpɂ͏܂B
 *	  Edmg_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Edmg_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Edmg_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAdmg_run2()̎gpɂ͏[ȒӂKvłB
 *	  dmg_run()gꍇɊrׂāAdmg_run2()gꍇ̌ʂ́A()̍ƂȂ܂B
 */
void dmg_run2(DMG* dmg, int cycle);
#endif /*PIECE*/

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_DMG_H__*/
