;
;	clipdmca.s
;
;	P/ECE DMG-CPU (Sharp LR35902) Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Feb 13 03:10:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Sat Mar 05 04:41:00 JST 2005 Naoyuki Sawa
;	- EI߂̊荞݋A1ߒx点܂B
;	  ܂ł́AEIߎsɊ荞݋Ă܂B
;	  1ߒxĊ荞݋̂AłB
;
;#include "clipdmca.h"
;
;	clipdmca.h
;
;	P/ECE DMG-CPU (Sharp LR35902) Emulator ()
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Feb 13 03:10:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;

; clipdmca.sAframdmca.sɃCN[hĎg܂B

; - g[XfobOsꍇ́ADMGCPU_RUN_TRACEV{`ĂB
;   DMGCPU_RUN_TRACEV{`ƁA쑬xƂĂxȂ̂ŁA
;   ʏ̓RgAEgĂĂB
; - DMGCPU_RUN_TRACEV{QƂăg[XOo͂Ă̂́A
;   dmgcpu_rundmgcpu_EIłB(2005/03/05)
;   dmgcpu_rundmgcpu_EI̎QƂĂB
;;#define DMGCPU_RUN_TRACE

;****************************************************************************
;	DMGCPU\
;****************************************************************************

					; typedef struct _DMGCPU {
;#define CZ		 0		; 	unsigned short cz;		/* + 0,2: -------C zzzzzzzz (C=F(C),z=!F(Z)) */
;#define NH		 2		; 	unsigned char  nh;		/* + 2,1:          --NH---- (N=F(N),H= F(H)) */
;#define _A_		 3		; 	unsigned char   a;		/* + 3,1: A  */
;#define BC		 4		; 	unsigned short bc;		/* + 4,2: BC */
;#define DE		 6		; 	unsigned short de;		/* + 6,2: DE */
;#define HL		 8		; 	unsigned short hl;		/* + 8,2: HL */
;#define SP		10		; 	unsigned short sp;		/* +10,2: SP */
;#define _PC_		12		; 	unsigned short pc;		/* +12,2: PC */
;#define FLAGS		14		; 	unsigned char flags;		/* +14,1: -----SHI (S=STOP,H=HALT,I=IME) */
					; 	//				/* +15,1: (pfBO) */
;#define _CYCLE_		16		; 	int cycle;			/* +16,4: csTCN */
;#define _READ_		20		; 	void* read;			/* +20,4: ǂݏo[` */
;#define _WRITE_		24		; 	void* write;			/* +24,4: ݃[` */
;#define SIZEOF_DMGCPU	28		; } DMGCPU;				/* =28 */

;#define C		 4
;#define B		 5
;#define E		 6
;#define D		 7
;#define L		 8
;#define H		 9

;****************************************************************************
;	tOrbg`
;****************************************************************************

; * tOtB[h̃}XN`AсAӎL܂B
;
; - ꎞIɃWX^ɕێĂNHtB[hɑ΂āANtOZbgɂ́A
;
;	xoor	%t0, %t0, 0x20		; D5Zbg (2߂ɓWJ)
;
;   A
;
;	xoor	%t0, %t0, ~0x1f		; D31:5SăZbg (1߂ōς)
;
;   ̕LłBlɁANtONAɂ́A
;
;	xand	%t0, %t0, ~0x20		; D5NA (2߂ɓWJ)
;
;   A
;
;	xand	%t0, %t0, 0x1f		; D31:5SăNA (1߂ōς)
;
;   ̕LłBȏ𓥂܂āAtOrbg̃}XN`s܂B
;
;	xoor	%t0, %t0, NF		; NtOZbg (1)
;	xand	%t0, %t0, ~NF		; NtONA (1)
;
;   ȂANHtB[h́AF(N,H)1rbgEɂĂ邱ƂɒӂĂB
;   1rbgEɂĂ邱Ƃ̎ȗŔAHtǑvZeՂɂ邽߂łA
;   NtOEɂꂽ߂ɁAsǂA1߂NtÕZbgANA
;   ł悤ɂȂ܂B
;
; - HACtOɊւẮA1rbgZbgANAĂRXg͓łA
;   NtOɑāAArbgZbgANA邱Ƃɂ܂B
;
;	xoor	%t0, %t0, HF		; HtOZbg (1)
;	xand	%t0, %t0, ~HF		; HtONA (1)
;
;	xoor	%t0, %t0, CF		; CtOZbg (2)
;	xand	%t0, %t0, ~CF		; CtONA (2)
;
; - CZtB[hZtÓAF(Z)̋t_ł邱ƂɒӂĂB
;   CZtB[hZtOׂ0Ȃ΁AF(Z)=1Ӗ܂B
;   CZtB[hZtÔ1rbgł1Ȃ΁AF(Z)=0Ӗ܂B
;   ZtONAꍇ́A`ASrbgNAKv܂B
;
;	xand	%t0, %t0, ~ZF		; ZtONA (2)
;
;   ZtOZbgꍇ́A`Aǂꂩ1rbg̃Zbgŏ[łB
;
;	xoor	%t0, %t0, ZF		; ZtOZbg (2)
;	;̕@ł\܂񂪁A̕@RXgłB
;	xoor	%t0, %t0, 1		; ZtOZbg (1)
;
; - ̃tOtB[hɑ΂āANAHAC̃ZbgANAsꍇ́A
;   ʏǂxbsetAxbclrgāA1rbgZbgANAĂB
;   (CtÕNAɊւẮASrbgNAARXgłB)
;
;	xbset	[%CPU+NH], NF_BIT	; NtOZbg
;	xbclr	[%CPU+NH], NF_BIT	; NtONA
;
;	xbset	[%CPU+NH], HF_BIT	; HtOZbg
;	xbclr	[%CPU+NH], HF_BIT	; HtONA
;
;	xbset	[%CPU+CZ+1], 0		; CtOZbg
;	xbclr	[%CPU+CZ+1], 0		; CtONA
;	;̕@ł\܂񂪁A̕@RXgłB
;	xld.b	[%CPU+CZ+1], %r8	; CtONA
;
;   ZtONAꍇ́A`ASrbgNAKv܂B
;
;	xld.b	[%CPU+CZ+0], %r8	; ZtONA
;
;   ZtOZbgꍇ́A`Aǂꂩ1rbg̃Zbgŏ[łB
;
;	xbset	[%CPU+CZ+0], 0		; ZtOZbg
;
; - ȏ܂Ƃ߂ƁAetOZbgANAőP̕@́ÂƂłB
;
;	ꎞIɃWX^ɕێĂtOtB[hɑ΂...
;
;	xoor	%t0, %t0, NF		; NtOZbg (1)
;	xand	%t0, %t0, ~NF		; NtONA (1)
;
;	xoor	%t0, %t0, HF		; HtOZbg (1)
;	xand	%t0, %t0, ~HF		; HtONA (1)
;
;	xoor	%t0, %t0, CF		; CtOZbg (2)
;	xand	%t0, %t0, ~CF		; CtONA (2)
;
;	xoor	%t0, %t0, 1		; ZtOZbg (1)
;	xand	%t0, %t0, ~ZF		; ZtONA (2)
;
;	̃tOtB[hɑ΂...
;
;	xbset	[%CPU+NH], NF_BIT	; NtOZbg
;	xbclr	[%CPU+NH], NF_BIT	; NtONA
;
;	xbset	[%CPU+NH], HF_BIT	; HtOZbg
;	xbclr	[%CPU+NH], HF_BIT	; HtONA
;
;	xbset	[%CPU+CZ+1], 0		; CtOZbg
;	xld.b	[%CPU+CZ+1], %r8	; CtONA
;
;	xbset	[%CPU+CZ+0], 0		; ZtOZbg
;	xld.b	[%CPU+CZ+0], %r8	; ZtONA

;/* DMGCPU.cz */
;#define ZF		0xff
;#define CF		(~0xff)
;#define ZF_BIT		0..7
;#define CF_BIT		8

;/* DMGCPU.nh */
;#define HF		0x1f
;#define NF		(~0x1f)
;#define HF_BIT		4
;#define NF_BIT		5

;/* DMGCPU.flags */
;#define IME		(1<<0)
;#define HALT		(1<<1)
;#define STOP		(1<<2)
;#define IME_BIT		0
;#define HALT_BIT	1
;#define STOP_BIT	2

;****************************************************************************
;	WX^蓖
;****************************************************************************

;#define addr		r0		; READAWRITE[`ւ̃AhXłB
					; ߃[`AREADAWRITE[`QƂ܂B
					; ߃[`ȊOÃWX^ύXĂ͂܂B
;#define data		r1		; READ[`̖߂lAWRITE[`ւ̃f[^łB
					; READ[`A߃[`QƂ܂B
					; ܂́A߃[`AWRITE[`QƂ܂B
					; WRITE[`́ÃWX^ύXĂ͂܂B
;#define s0		r2		; READAWRITE[`ĂяoɁAꎞIȒlۑ邽߂̃WX^łB
					; ߃[`ACӂɎgp\łB
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define s1		r3		; ()
;#define CPU		r4		; dmgcpũAhXێ܂B
					; dmgcpu_enter`dmgcpu_leave̊ԁAsςłB
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define A		r5		; AWX^̒lێ܂B
					; D31:8͏0Ƃ܂B
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define PC		r6		; PCWX^̒lێ܂B
					; D31:16͏0Ƃ܂B
					; dmgcpu_runA߃[`Aѕ⏕[`AK؂ɐݒAQƂ܂B
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define CYCLE		r7		; csTCNێ܂B
					; ߃[`Aѕ⏕[`AK؂ɐݒAQƂ܂B
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;	 		r8
;	 		r9
;#define READ		r10		; READ[`̃AhXێ܂B
					; dmgcpu_enter`dmgcpu_leave̊ԁAsςłB
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define WRITE		r11		; WRITE[`̃AhXێ܂B
					; dmgcpu_enter`dmgcpu_leave̊ԁAsςłB
					; READAWRITE[`́ÃWX^ύXĂ͂܂B
;#define t0		r12		; ėp[NWX^łB
					; SẴ[`ACӂɎgp\łB
;#define t1		r13		; ()
;#define t2		r14		; ()
;#define t3		r15		; ()

;****************************************************************************
;	8-Bit Loads
;****************************************************************************

;#define CYCLE_LD_A_n		8
;#define CYCLE_LD_A_A		4
;#define CYCLE_LD_A_B		4
;#define CYCLE_LD_A_C		4
;#define CYCLE_LD_A_D		4
;#define CYCLE_LD_A_E		4
;#define CYCLE_LD_A_H		4
;#define CYCLE_LD_A_L		4
;#define CYCLE_LD_A_IHLI		8

;#define CYCLE_LD_B_n		8
;#define CYCLE_LD_B_A		4
;#define CYCLE_LD_B_B		4
;#define CYCLE_LD_B_C		4
;#define CYCLE_LD_B_D		4
;#define CYCLE_LD_B_E		4
;#define CYCLE_LD_B_H		4
;#define CYCLE_LD_B_L		4
;#define CYCLE_LD_B_IHLI		8

;#define CYCLE_LD_C_n		8
;#define CYCLE_LD_C_A		4
;#define CYCLE_LD_C_B		4
;#define CYCLE_LD_C_C		4
;#define CYCLE_LD_C_D		4
;#define CYCLE_LD_C_E		4
;#define CYCLE_LD_C_H		4
;#define CYCLE_LD_C_L		4
;#define CYCLE_LD_C_IHLI		8

;#define CYCLE_LD_D_n		8
;#define CYCLE_LD_D_A		4
;#define CYCLE_LD_D_B		4
;#define CYCLE_LD_D_C		4
;#define CYCLE_LD_D_D		4
;#define CYCLE_LD_D_E		4
;#define CYCLE_LD_D_H		4
;#define CYCLE_LD_D_L		4
;#define CYCLE_LD_D_IHLI		8

;#define CYCLE_LD_E_n		8
;#define CYCLE_LD_E_A		4
;#define CYCLE_LD_E_B		4
;#define CYCLE_LD_E_C		4
;#define CYCLE_LD_E_D		4
;#define CYCLE_LD_E_E		4
;#define CYCLE_LD_E_H		4
;#define CYCLE_LD_E_L		4
;#define CYCLE_LD_E_IHLI		8

;#define CYCLE_LD_H_n		8
;#define CYCLE_LD_H_A		4
;#define CYCLE_LD_H_B		4
;#define CYCLE_LD_H_C		4
;#define CYCLE_LD_H_D		4
;#define CYCLE_LD_H_E		4
;#define CYCLE_LD_H_H		4
;#define CYCLE_LD_H_L		4
;#define CYCLE_LD_H_IHLI		8

;#define CYCLE_LD_L_n		8
;#define CYCLE_LD_L_A		4
;#define CYCLE_LD_L_B		4
;#define CYCLE_LD_L_C		4
;#define CYCLE_LD_L_D		4
;#define CYCLE_LD_L_E		4
;#define CYCLE_LD_L_H		4
;#define CYCLE_LD_L_L		4
;#define CYCLE_LD_L_IHLI		8

;#define CYCLE_LD_IHLI_n		12
;#define CYCLE_LD_IHLI_A		8
;#define CYCLE_LD_IHLI_B		8
;#define CYCLE_LD_IHLI_C		8
;#define CYCLE_LD_IHLI_D		8
;#define CYCLE_LD_IHLI_E		8
;#define CYCLE_LD_IHLI_H		8
;#define CYCLE_LD_IHLI_L		8

;#define CYCLE_LD_A_InnI		16
;#define CYCLE_LD_InnI_A		16
;#define CYCLE_LD_A_IBCI		8
;#define CYCLE_LD_IBCI_A		8
;#define CYCLE_LD_A_IDEI		8
;#define CYCLE_LD_IDEI_A		8

;#define CYCLE_LD_A_ICI		8
;#define CYCLE_LD_ICI_A		8
;#define CYCLE_LDH_A_InI		12
;#define CYCLE_LDH_InI_A		12

;#define CYCLE_LDI_A_IHLI	8
;#define CYCLE_LDI_IHLI_A	8
;#define CYCLE_LDD_A_IHLI	8
;#define CYCLE_LDD_IHLI_A	8

;****************************************************************************
;	16-Bit Loads
;****************************************************************************

;#define CYCLE_LD_BC_nn		12
;#define CYCLE_LD_DE_nn		12
;#define CYCLE_LD_HL_nn		12
;#define CYCLE_LD_SP_nn		12

;#define CYCLE_LD_SP_HL		8
;#define CYCLE_LDHL_SP_e		12
;#define CYCLE_LD_InnI_SP	20

;#define CYCLE_PUSH_AF		16
;#define CYCLE_PUSH_BC		16
;#define CYCLE_PUSH_DE		16
;#define CYCLE_PUSH_HL		16

;#define CYCLE_POP_AF		12
;#define CYCLE_POP_BC		12
;#define CYCLE_POP_DE		12
;#define CYCLE_POP_HL		12

;****************************************************************************
;	8-Bit ALU
;****************************************************************************

;#define CYCLE_ADD_A_n		8
;#define CYCLE_ADD_A_A		4
;#define CYCLE_ADD_A_B		4
;#define CYCLE_ADD_A_C		4
;#define CYCLE_ADD_A_D		4
;#define CYCLE_ADD_A_E		4
;#define CYCLE_ADD_A_H		4
;#define CYCLE_ADD_A_L		4
;#define CYCLE_ADD_A_IHLI	8

;#define CYCLE_ADC_A_n		8
;#define CYCLE_ADC_A_A		4
;#define CYCLE_ADC_A_B		4
;#define CYCLE_ADC_A_C		4
;#define CYCLE_ADC_A_D		4
;#define CYCLE_ADC_A_E		4
;#define CYCLE_ADC_A_H		4
;#define CYCLE_ADC_A_L		4
;#define CYCLE_ADC_A_IHLI	8

;#define CYCLE_SUB_n		8
;#define CYCLE_SUB_A		4
;#define CYCLE_SUB_B		4
;#define CYCLE_SUB_C		4
;#define CYCLE_SUB_D		4
;#define CYCLE_SUB_E		4
;#define CYCLE_SUB_H		4
;#define CYCLE_SUB_L		4
;#define CYCLE_SUB_IHLI		8

;#define CYCLE_SBC_A_n		8
;#define CYCLE_SBC_A_A		4
;#define CYCLE_SBC_A_B		4
;#define CYCLE_SBC_A_C		4
;#define CYCLE_SBC_A_D		4
;#define CYCLE_SBC_A_E		4
;#define CYCLE_SBC_A_H		4
;#define CYCLE_SBC_A_L		4
;#define CYCLE_SBC_A_IHLI	8

;#define CYCLE_CP_n		8
;#define CYCLE_CP_A		4
;#define CYCLE_CP_B		4
;#define CYCLE_CP_C		4
;#define CYCLE_CP_D		4
;#define CYCLE_CP_E		4
;#define CYCLE_CP_H		4
;#define CYCLE_CP_L		4
;#define CYCLE_CP_IHLI		8

;#define CYCLE_AND_n		8
;#define CYCLE_AND_A		4
;#define CYCLE_AND_B		4
;#define CYCLE_AND_C		4
;#define CYCLE_AND_D		4
;#define CYCLE_AND_E		4
;#define CYCLE_AND_H		4
;#define CYCLE_AND_L		4
;#define CYCLE_AND_IHLI		8

;#define CYCLE_OR_n		8
;#define CYCLE_OR_A		4
;#define CYCLE_OR_B		4
;#define CYCLE_OR_C		4
;#define CYCLE_OR_D		4
;#define CYCLE_OR_E		4
;#define CYCLE_OR_H		4
;#define CYCLE_OR_L		4
;#define CYCLE_OR_IHLI		8

;#define CYCLE_XOR_n		8
;#define CYCLE_XOR_A		4
;#define CYCLE_XOR_B		4
;#define CYCLE_XOR_C		4
;#define CYCLE_XOR_D		4
;#define CYCLE_XOR_E		4
;#define CYCLE_XOR_H		4
;#define CYCLE_XOR_L		4
;#define CYCLE_XOR_IHLI		8

;#define CYCLE_INC_A		4
;#define CYCLE_INC_B		4
;#define CYCLE_INC_C		4
;#define CYCLE_INC_D		4
;#define CYCLE_INC_E		4
;#define CYCLE_INC_H		4
;#define CYCLE_INC_L		4
;#define CYCLE_INC_IHLI		12

;#define CYCLE_DEC_A		4
;#define CYCLE_DEC_B		4
;#define CYCLE_DEC_C		4
;#define CYCLE_DEC_D		4
;#define CYCLE_DEC_E		4
;#define CYCLE_DEC_H		4
;#define CYCLE_DEC_L		4
;#define CYCLE_DEC_IHLI		12

;****************************************************************************
;	16-Bit Arithmetic
;****************************************************************************

;#define CYCLE_ADD_HL_BC		8
;#define CYCLE_ADD_HL_DE		8
;#define CYCLE_ADD_HL_HL		8
;#define CYCLE_ADD_HL_SP		8
;#define CYCLE_ADD_SP_e		16

;#define CYCLE_INC_BC		8
;#define CYCLE_INC_DE		8
;#define CYCLE_INC_HL		8
;#define CYCLE_INC_SP		8

;#define CYCLE_DEC_BC		8
;#define CYCLE_DEC_DE		8
;#define CYCLE_DEC_HL		8
;#define CYCLE_DEC_SP		8

;****************************************************************************
;	Miscellaneous
;****************************************************************************

;#define CYCLE_SWAP_A		8
;#define CYCLE_SWAP_B		8
;#define CYCLE_SWAP_C		8
;#define CYCLE_SWAP_D		8
;#define CYCLE_SWAP_E		8
;#define CYCLE_SWAP_H		8
;#define CYCLE_SWAP_L		8
;#define CYCLE_SWAP_IHLI		16

;#define CYCLE_DAA		4
;#define CYCLE_CPL		4
;#define CYCLE_SCF		4
;#define CYCLE_CCF		4

;#define CYCLE_NOP		4
;#define CYCLE_HALT		4
;#define CYCLE_STOP		4
;#define CYCLE_DI		4
;#define CYCLE_EI		4

;****************************************************************************
;	Rotates & Shifts
;****************************************************************************

;#define CYCLE_RLA		4
;#define CYCLE_RLCA		4
;#define CYCLE_RRA		4
;#define CYCLE_RRCA		4

;#define CYCLE_RL_A		8
;#define CYCLE_RL_B		8
;#define CYCLE_RL_C		8
;#define CYCLE_RL_D		8
;#define CYCLE_RL_E		8
;#define CYCLE_RL_H		8
;#define CYCLE_RL_L		8
;#define CYCLE_RL_IHLI		16

;#define CYCLE_RLC_A		8
;#define CYCLE_RLC_B		8
;#define CYCLE_RLC_C		8
;#define CYCLE_RLC_D		8
;#define CYCLE_RLC_E		8
;#define CYCLE_RLC_H		8
;#define CYCLE_RLC_L		8
;#define CYCLE_RLC_IHLI		16

;#define CYCLE_RR_A		8
;#define CYCLE_RR_B		8
;#define CYCLE_RR_C		8
;#define CYCLE_RR_D		8
;#define CYCLE_RR_E		8
;#define CYCLE_RR_H		8
;#define CYCLE_RR_L		8
;#define CYCLE_RR_IHLI		16

;#define CYCLE_RRC_A		8
;#define CYCLE_RRC_B		8
;#define CYCLE_RRC_C		8
;#define CYCLE_RRC_D		8
;#define CYCLE_RRC_E		8
;#define CYCLE_RRC_H		8
;#define CYCLE_RRC_L		8
;#define CYCLE_RRC_IHLI		16

;#define CYCLE_SLA_A		8
;#define CYCLE_SLA_B		8
;#define CYCLE_SLA_C		8
;#define CYCLE_SLA_D		8
;#define CYCLE_SLA_E		8
;#define CYCLE_SLA_H		8
;#define CYCLE_SLA_L		8
;#define CYCLE_SLA_IHLI		16

;#define CYCLE_SRA_A		8
;#define CYCLE_SRA_B		8
;#define CYCLE_SRA_C		8
;#define CYCLE_SRA_D		8
;#define CYCLE_SRA_E		8
;#define CYCLE_SRA_H		8
;#define CYCLE_SRA_L		8
;#define CYCLE_SRA_IHLI		16

;#define CYCLE_SRL_A		8
;#define CYCLE_SRL_B		8
;#define CYCLE_SRL_C		8
;#define CYCLE_SRL_D		8
;#define CYCLE_SRL_E		8
;#define CYCLE_SRL_H		8
;#define CYCLE_SRL_L		8
;#define CYCLE_SRL_IHLI		16

;****************************************************************************
;	Bit Opcodes
;****************************************************************************

;#define CYCLE_BIT_0_A		8
;#define CYCLE_BIT_0_B		8
;#define CYCLE_BIT_0_C		8
;#define CYCLE_BIT_0_D		8
;#define CYCLE_BIT_0_E		8
;#define CYCLE_BIT_0_H		8
;#define CYCLE_BIT_0_L		8
;#define CYCLE_BIT_0_IHLI	12

;#define CYCLE_BIT_1_A		8
;#define CYCLE_BIT_1_B		8
;#define CYCLE_BIT_1_C		8
;#define CYCLE_BIT_1_D		8
;#define CYCLE_BIT_1_E		8
;#define CYCLE_BIT_1_H		8
;#define CYCLE_BIT_1_L		8
;#define CYCLE_BIT_1_IHLI	12

;#define CYCLE_BIT_2_A		8
;#define CYCLE_BIT_2_B		8
;#define CYCLE_BIT_2_C		8
;#define CYCLE_BIT_2_D		8
;#define CYCLE_BIT_2_E		8
;#define CYCLE_BIT_2_H		8
;#define CYCLE_BIT_2_L		8
;#define CYCLE_BIT_2_IHLI	12

;#define CYCLE_BIT_3_A		8
;#define CYCLE_BIT_3_B		8
;#define CYCLE_BIT_3_C		8
;#define CYCLE_BIT_3_D		8
;#define CYCLE_BIT_3_E		8
;#define CYCLE_BIT_3_H		8
;#define CYCLE_BIT_3_L		8
;#define CYCLE_BIT_3_IHLI	12

;#define CYCLE_BIT_4_A		8
;#define CYCLE_BIT_4_B		8
;#define CYCLE_BIT_4_C		8
;#define CYCLE_BIT_4_D		8
;#define CYCLE_BIT_4_E		8
;#define CYCLE_BIT_4_H		8
;#define CYCLE_BIT_4_L		8
;#define CYCLE_BIT_4_IHLI	12

;#define CYCLE_BIT_5_A		8
;#define CYCLE_BIT_5_B		8
;#define CYCLE_BIT_5_C		8
;#define CYCLE_BIT_5_D		8
;#define CYCLE_BIT_5_E		8
;#define CYCLE_BIT_5_H		8
;#define CYCLE_BIT_5_L		8
;#define CYCLE_BIT_5_IHLI	12

;#define CYCLE_BIT_6_A		8
;#define CYCLE_BIT_6_B		8
;#define CYCLE_BIT_6_C		8
;#define CYCLE_BIT_6_D		8
;#define CYCLE_BIT_6_E		8
;#define CYCLE_BIT_6_H		8
;#define CYCLE_BIT_6_L		8
;#define CYCLE_BIT_6_IHLI	12

;#define CYCLE_BIT_7_A		8
;#define CYCLE_BIT_7_B		8
;#define CYCLE_BIT_7_C		8
;#define CYCLE_BIT_7_D		8
;#define CYCLE_BIT_7_E		8
;#define CYCLE_BIT_7_H		8
;#define CYCLE_BIT_7_L		8
;#define CYCLE_BIT_7_IHLI	12

;#define CYCLE_SET_0_A		8
;#define CYCLE_SET_0_B		8
;#define CYCLE_SET_0_C		8
;#define CYCLE_SET_0_D		8
;#define CYCLE_SET_0_E		8
;#define CYCLE_SET_0_H		8
;#define CYCLE_SET_0_L		8
;#define CYCLE_SET_0_IHLI	16

;#define CYCLE_SET_1_A		8
;#define CYCLE_SET_1_B		8
;#define CYCLE_SET_1_C		8
;#define CYCLE_SET_1_D		8
;#define CYCLE_SET_1_E		8
;#define CYCLE_SET_1_H		8
;#define CYCLE_SET_1_L		8
;#define CYCLE_SET_1_IHLI	16

;#define CYCLE_SET_2_A		8
;#define CYCLE_SET_2_B		8
;#define CYCLE_SET_2_C		8
;#define CYCLE_SET_2_D		8
;#define CYCLE_SET_2_E		8
;#define CYCLE_SET_2_H		8
;#define CYCLE_SET_2_L		8
;#define CYCLE_SET_2_IHLI	16

;#define CYCLE_SET_3_A		8
;#define CYCLE_SET_3_B		8
;#define CYCLE_SET_3_C		8
;#define CYCLE_SET_3_D		8
;#define CYCLE_SET_3_E		8
;#define CYCLE_SET_3_H		8
;#define CYCLE_SET_3_L		8
;#define CYCLE_SET_3_IHLI	16

;#define CYCLE_SET_4_A		8
;#define CYCLE_SET_4_B		8
;#define CYCLE_SET_4_C		8
;#define CYCLE_SET_4_D		8
;#define CYCLE_SET_4_E		8
;#define CYCLE_SET_4_H		8
;#define CYCLE_SET_4_L		8
;#define CYCLE_SET_4_IHLI	16

;#define CYCLE_SET_5_A		8
;#define CYCLE_SET_5_B		8
;#define CYCLE_SET_5_C		8
;#define CYCLE_SET_5_D		8
;#define CYCLE_SET_5_E		8
;#define CYCLE_SET_5_H		8
;#define CYCLE_SET_5_L		8
;#define CYCLE_SET_5_IHLI	16

;#define CYCLE_SET_6_A		8
;#define CYCLE_SET_6_B		8
;#define CYCLE_SET_6_C		8
;#define CYCLE_SET_6_D		8
;#define CYCLE_SET_6_E		8
;#define CYCLE_SET_6_H		8
;#define CYCLE_SET_6_L		8
;#define CYCLE_SET_6_IHLI	16

;#define CYCLE_SET_7_A		8
;#define CYCLE_SET_7_B		8
;#define CYCLE_SET_7_C		8
;#define CYCLE_SET_7_D		8
;#define CYCLE_SET_7_E		8
;#define CYCLE_SET_7_H		8
;#define CYCLE_SET_7_L		8
;#define CYCLE_SET_7_IHLI	16

;#define CYCLE_RES_0_A		8
;#define CYCLE_RES_0_B		8
;#define CYCLE_RES_0_C		8
;#define CYCLE_RES_0_D		8
;#define CYCLE_RES_0_E		8
;#define CYCLE_RES_0_H		8
;#define CYCLE_RES_0_L		8
;#define CYCLE_RES_0_IHLI	16

;#define CYCLE_RES_1_A		8
;#define CYCLE_RES_1_B		8
;#define CYCLE_RES_1_C		8
;#define CYCLE_RES_1_D		8
;#define CYCLE_RES_1_E		8
;#define CYCLE_RES_1_H		8
;#define CYCLE_RES_1_L		8
;#define CYCLE_RES_1_IHLI	16

;#define CYCLE_RES_2_A		8
;#define CYCLE_RES_2_B		8
;#define CYCLE_RES_2_C		8
;#define CYCLE_RES_2_D		8
;#define CYCLE_RES_2_E		8
;#define CYCLE_RES_2_H		8
;#define CYCLE_RES_2_L		8
;#define CYCLE_RES_2_IHLI	16

;#define CYCLE_RES_3_A		8
;#define CYCLE_RES_3_B		8
;#define CYCLE_RES_3_C		8
;#define CYCLE_RES_3_D		8
;#define CYCLE_RES_3_E		8
;#define CYCLE_RES_3_H		8
;#define CYCLE_RES_3_L		8
;#define CYCLE_RES_3_IHLI	16

;#define CYCLE_RES_4_A		8
;#define CYCLE_RES_4_B		8
;#define CYCLE_RES_4_C		8
;#define CYCLE_RES_4_D		8
;#define CYCLE_RES_4_E		8
;#define CYCLE_RES_4_H		8
;#define CYCLE_RES_4_L		8
;#define CYCLE_RES_4_IHLI	16

;#define CYCLE_RES_5_A		8
;#define CYCLE_RES_5_B		8
;#define CYCLE_RES_5_C		8
;#define CYCLE_RES_5_D		8
;#define CYCLE_RES_5_E		8
;#define CYCLE_RES_5_H		8
;#define CYCLE_RES_5_L		8
;#define CYCLE_RES_5_IHLI	16

;#define CYCLE_RES_6_A		8
;#define CYCLE_RES_6_B		8
;#define CYCLE_RES_6_C		8
;#define CYCLE_RES_6_D		8
;#define CYCLE_RES_6_E		8
;#define CYCLE_RES_6_H		8
;#define CYCLE_RES_6_L		8
;#define CYCLE_RES_6_IHLI	16

;#define CYCLE_RES_7_A		8
;#define CYCLE_RES_7_B		8
;#define CYCLE_RES_7_C		8
;#define CYCLE_RES_7_D		8
;#define CYCLE_RES_7_E		8
;#define CYCLE_RES_7_H		8
;#define CYCLE_RES_7_L		8
;#define CYCLE_RES_7_IHLI	16

;****************************************************************************
;	Jumps
;****************************************************************************

;#define CYCLE_JP_nn		12
;#define CYCLE_JP_Z_nn		12	;* 16 */
;#define CYCLE_JP_NZ_nn		12	;* 16 */
;#define CYCLE_JP_C_nn		12	;* 16 */
;#define CYCLE_JP_NC_nn		12	;* 16 */
;#define CYCLE_JP_IHLI		4

;#define CYCLE_JR_e		8
;#define CYCLE_JR_Z_e		8	;* 12 */
;#define CYCLE_JR_NZ_e		8	;* 12 */
;#define CYCLE_JR_C_e		8	;* 12 */
;#define CYCLE_JR_NC_e		8	;* 12 */

;****************************************************************************
;	Calls
;****************************************************************************

;#define CYCLE_CALL_nn		12
;#define CYCLE_CALL_Z_nn		12	;* 24 */
;#define CYCLE_CALL_NZ_nn	12	;* 24 */
;#define CYCLE_CALL_C_nn		12	;* 24 */
;#define CYCLE_CALL_NC_nn	12	;* 24 */

;****************************************************************************
;	Restarts
;****************************************************************************

;#define CYCLE_RST_00H		16
;#define CYCLE_RST_08H		16
;#define CYCLE_RST_10H		16
;#define CYCLE_RST_18H		16
;#define CYCLE_RST_20H		16
;#define CYCLE_RST_28H		16
;#define CYCLE_RST_30H		16
;#define CYCLE_RST_38H		16

;****************************************************************************
;	Returns
;****************************************************************************

;#define CYCLE_RET		8
;#define CYCLE_RET_Z		8	;* 20 */
;#define CYCLE_RET_NZ		8	;* 20 */
;#define CYCLE_RET_C		8	;* 20 */
;#define CYCLE_RET_NC		8	;* 20 */
;#define CYCLE_RETI		8

;****************************************************************************
;
;****************************************************************************



;----------------------------------------------------------------------------
;
; * Wed Feb 23 21:55:00 JST 2005 Naoyuki Sawa
;
; - "jp.d %rb"́A΁ɎgĂ͂܂!!
;   ȉɁA̗RL܂B
;
; - ȑOAMOS6502G~[VvOƂɁA(framm65a.s)
;   u"jp.d %rb"̒OɃANZX߂DelaySlotsȂv
;   Ə܂A듮̏͂ꂾł͂܂łB
;   "jp.d %rb"𑽗pĂvOATEh炵ȂsƁA
;   Ƃǂ"jp.d %rb"̌DelaySlotɒu߂sȂȂ̂łB
;   ɁA"jp.d %rb"̒OŃTEhDMAɂ郁]ꍇɂA
;   "jp.d %rb"̌DelaySlotsȂ̂ł͂Ȃł傤H
;
; - {W[̍ŏ̎ł́AŌɃCgobN閽(LD (HL),AȂ)ŁA
;   sTCN炷"jp.d %rb"DelaySlotɓčĂ̂łA
;
;	#macro	LD_IHLI_A	$1
;		xld.uh	%addr, [%CPU+HL]	; %addr = HL
;		ld.w	%data, %A		; %data = A
;		jp.d	%WRITE			; WRITE(addr, data)
;		sub	%CYCLE, $1		; *delay*
;	#endm
;
;   ŏ͖Ȃ̂́ATEh炷ƁA"sub %CYCLE, $1"sȂ
;   ۂ悤ɂȂ܂B
;   As邽тɂǂ̈ʒuŔ邩słB
;   ̏Ǐ󂩂AOq̂悤ɐ܂B
;
; - _͎̒ʂłB
;
;	w"jp.d %rb"́A΁ɎgĂ͂܂!!x
;
;   {W[ɂāAقǎ́Â悤ɏ܂B
;   1TCNxȂ܂Aނ܂B
;
;	#macro	LD_IHLI_A	$1
;		xld.uh	%addr, [%CPU+HL]	; %addr = HL
;		ld.w	%data, %A		; %data = A
;		sub	%CYCLE, $1
;		jp	%WRITE			; WRITE(addr, data)
;	#endm
;
;   ȂAKɂAߋ"jp.d %rb"gĂW[͈܂łB
;   ("xjp.d rel"͂gĂ܂A͑vłB)
;
;----------------------------------------------------------------------------

;****************************************************************************
;
;****************************************************************************

	.code
	.align	1

;****************************************************************************
;
;****************************************************************************

dmgcpu_ERR:
	ext	dmgcpu_leave@rm	; 	xcall	dmgcpu_leave			; sReLXg߂܂B
	call	dmgcpu_leave@rl
	ext	dmgcpu_err@rm	; 	xjp	dmgcpu_err			; Cł̃G[[`ցB
	jp	dmgcpu_err@rl

dmgcpu_CHECK_PENDING:
	ext	dmgcpu_leave@rm	; 	xcall dmgcpu_leave			; sReLXg߂܂B
	call	dmgcpu_leave@rl
	ext	dmgcpu_check_pending@rm	; 	xcall dmgcpu_check_pending		; ۗĂ荞݂΁As܂B
	call	dmgcpu_check_pending@rl
	ext	dmgcpu_enter@rm	; 	xjp   dmgcpu_enter			; sReLXgo܂B
	jp	dmgcpu_enter@rl

;****************************************************************************
;	8-Bit Loads
;****************************************************************************

;#macro	LD_A_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	ld.w	%A, %data			; %A    = n
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_A_r		$1, $2
;	xld.ub	%A, [%CPU+$2]			; %A = r
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_r_A		$1, $2
;	xld.b	[%CPU+$2], %A			; r = A
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_A_IrrI	$1, $2
;	xld.uh	%addr, [%CPU+$2]		; %addr = rr
;	call	%READ				; %data = READ(addr)
;	ld.w	%A, %data			; %A    = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_IrrI_A	$1, $2
;	xld.uh	%addr, [%CPU+$2]		; %addr = rr
;	ld.w	%data, %A			; %data = A
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LD_InnI_A	$1
;	call.d	%READ				; %data = LO(nn)
;	ld.w	%addr, %PC			; %addr = PC   *delay*
;	ld.w	%s0, %data			; %s0   = LO(nn)
;	call.d	%READ				; %data = HI(nn)
;	add	%addr, 1			; %addr = PC+1 *delay*
;	xadd	%PC, %PC, 2			; %PC   = PC+2
;	xsll	%data, 8			; %data = HI(nn)<<8
;	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
;	ld.w	%addr, %s0			; %addr = nn
;	ld.w	%data, %A			; %data = A
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LD_A_InnI	$1
;	call.d	%READ				; %data = LO(nn)
;	ld.w	%addr, %PC			; %addr = PC   *delay*
;	ld.w	%s0, %data			; %s0   = LO(nn)
;	call.d	%READ				; %data = HI(nn)
;	add	%addr, 1			; %addr = PC+1 *delay*
;	xadd	%PC, %PC, 2			; %PC   = PC+2
;	xsll	%data, 8			; %data = HI(nn)<<8
;	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
;	call.d	%READ				; %data = READ(addr)
;	ld.w	%addr, %s0			; %addr = nn   *delay*
;	ld.w	%A, %data			; %A    = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_r_n		$1, $2
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xld.b	[%CPU+$2], %data		; r     = n
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_r_s		$1, $2, $3
;	xld.ub	%data, [%CPU+$3]		; %data = s
;	xld.b	[%CPU+$2], %data		; r     = s
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_r_IHLI	$1, $2
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(HL)
;	xld.b	[%CPU+$2], %data		; r     = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_IHLI_n	$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LD_IHLI_A	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	ld.w	%data, %A			; %data = A
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LD_IHLI_r	$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LD_A_ICI	$1
;	xld.ub	%addr, [%CPU+C]			; %addr = C
;	xoor	%addr, %addr, 0xff00		; %addr = C|0xff00
;	call	%READ				; %data = READ(addr)
;	ld.w	%A, %data			; %A    = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_ICI_A	$1
;	xld.ub	%addr, [%CPU+C]			; %addr = C
;	xoor	%addr, %addr, 0xff00		; %addr = C|0xff00
;	ld.w	%data, %A			; %data = A
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LDH_A_InI	$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xoor	%addr, %data, 0xff00		; %addr = n|0xff00
;	call	%READ				; %data = READ(addr)
;	ld.w	%A, %data			; %A    = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LDH_InI_A	$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xoor	%addr, %data, 0xff00		; %addr = n|0xff00
;	ld.w	%data, %A			; %data = A
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(addr, data)
;#endm

;#macro	LDI_A_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	ld.w	%A, %data			; %A    = data
;	xadd	%addr, %addr, 1			; %addr = HL+1
;	xld.h	[%CPU+HL], %addr		; HL    = HL+1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LDI_IHLI_A	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call.d	%WRITE				; WRITE(addr, data)
;	ld.w	%data, %A			; %data = A *delay*
;	xadd	%addr, %addr, 1			; %addr = HL+1
;	xld.h	[%CPU+HL], %addr		; HL    = HL+1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LDD_A_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	ld.w	%A, %data			; %A    = data
;	xsub	%addr, %addr, 1			; %addr = HL-1
;	xld.h	[%CPU+HL], %addr		; HL    = HL-1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LDD_IHLI_A	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call.d	%WRITE				; WRITE(addr, data)
;	ld.w	%data, %A			; %data = A *delay*
;	xsub	%addr, %addr, 1			; %addr = HL-1
;	xld.h	[%CPU+HL], %addr		; HL    = HL-1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;----------------------------------------------------------------------------

dmgcpu_LD_A_n:
	call.d	%r10				; %data = n	; 	LD_A_n		CYCLE_LD_A_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ld.w	%r5, %r1			; %A    = n
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_A_A:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_A_B:
	ext	0x5		; 	xld.ub	%r5, [%r4+0x5]			; %A = r	; 	LD_A_r		CYCLE_LD_A_B, B
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_C:
	ext	0x4		; 	xld.ub	%r5, [%r4+0x4]			; %A = r	; 	LD_A_r		CYCLE_LD_A_C, C
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_D:
	ext	0x7		; 	xld.ub	%r5, [%r4+0x7]			; %A = r	; 	LD_A_r		CYCLE_LD_A_D, D
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_E:
	ext	0x6		; 	xld.ub	%r5, [%r4+0x6]			; %A = r	; 	LD_A_r		CYCLE_LD_A_E, E
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_H:
	ext	0x9		; 	xld.ub	%r5, [%r4+0x9]			; %A = r	; 	LD_A_r		CYCLE_LD_A_H, H
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_L:
	ext	0x8		; 	xld.ub	%r5, [%r4+0x8]			; %A = r	; 	LD_A_r		CYCLE_LD_A_L, L
	ld.ub	%r5,[%r4]
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = rr	; 	LD_A_IrrI	CYCLE_LD_A_IHLI, HL
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_B_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_B_n, B
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_B_A:
	ext	0x5		; 	xld.b	[%r4+0x5], %r5			; r = A	; 	LD_r_A		CYCLE_LD_B_A, B
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_B:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_B_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = s	; 	LD_r_s		CYCLE_LD_B_C, B, C
	ld.ub	%r1,[%r4]
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = s	; 	LD_r_s		CYCLE_LD_B_D, B, D
	ld.ub	%r1,[%r4]
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = s	; 	LD_r_s		CYCLE_LD_B_E, B, E
	ld.ub	%r1,[%r4]
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = s	; 	LD_r_s		CYCLE_LD_B_H, B, H
	ld.ub	%r1,[%r4]
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = s	; 	LD_r_s		CYCLE_LD_B_L, B, L
	ld.ub	%r1,[%r4]
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_B_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_B_IHLI, B
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_C_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_C_n, C
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_C_A:
	ext	0x4		; 	xld.b	[%r4+0x4], %r5			; r = A	; 	LD_r_A		CYCLE_LD_C_A, C
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = s	; 	LD_r_s		CYCLE_LD_C_B, C, B
	ld.ub	%r1,[%r4]
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_C:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_C_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = s	; 	LD_r_s		CYCLE_LD_C_D, C, D
	ld.ub	%r1,[%r4]
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = s	; 	LD_r_s		CYCLE_LD_C_E, C, E
	ld.ub	%r1,[%r4]
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = s	; 	LD_r_s		CYCLE_LD_C_H, C, H
	ld.ub	%r1,[%r4]
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = s	; 	LD_r_s		CYCLE_LD_C_L, C, L
	ld.ub	%r1,[%r4]
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_C_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_C_IHLI, C
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_D_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_D_n, D
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_D_A:
	ext	0x7		; 	xld.b	[%r4+0x7], %r5			; r = A	; 	LD_r_A		CYCLE_LD_D_A, D
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = s	; 	LD_r_s		CYCLE_LD_D_B, D, B
	ld.ub	%r1,[%r4]
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = s	; 	LD_r_s		CYCLE_LD_D_C, D, C
	ld.ub	%r1,[%r4]
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_D:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_D_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = s	; 	LD_r_s		CYCLE_LD_D_E, D, E
	ld.ub	%r1,[%r4]
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = s	; 	LD_r_s		CYCLE_LD_D_H, D, H
	ld.ub	%r1,[%r4]
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = s	; 	LD_r_s		CYCLE_LD_D_L, D, L
	ld.ub	%r1,[%r4]
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_D_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_D_IHLI, D
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_E_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_E_n, E
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_E_A:
	ext	0x6		; 	xld.b	[%r4+0x6], %r5			; r = A	; 	LD_r_A		CYCLE_LD_E_A, E
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = s	; 	LD_r_s		CYCLE_LD_E_B, E, B
	ld.ub	%r1,[%r4]
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = s	; 	LD_r_s		CYCLE_LD_E_C, E, C
	ld.ub	%r1,[%r4]
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = s	; 	LD_r_s		CYCLE_LD_E_D, E, D
	ld.ub	%r1,[%r4]
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_E:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_E_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = s	; 	LD_r_s		CYCLE_LD_E_H, E, H
	ld.ub	%r1,[%r4]
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = s	; 	LD_r_s		CYCLE_LD_E_L, E, L
	ld.ub	%r1,[%r4]
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_E_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_E_IHLI, E
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_H_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_H_n, H
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_H_A:
	ext	0x9		; 	xld.b	[%r4+0x9], %r5			; r = A	; 	LD_r_A		CYCLE_LD_H_A, H
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = s	; 	LD_r_s		CYCLE_LD_H_B, H, B
	ld.ub	%r1,[%r4]
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = s	; 	LD_r_s		CYCLE_LD_H_C, H, C
	ld.ub	%r1,[%r4]
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = s	; 	LD_r_s		CYCLE_LD_H_D, H, D
	ld.ub	%r1,[%r4]
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = s	; 	LD_r_s		CYCLE_LD_H_E, H, E
	ld.ub	%r1,[%r4]
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_H:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_H_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = s	; 	LD_r_s		CYCLE_LD_H_L, H, L
	ld.ub	%r1,[%r4]
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_H_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_H_IHLI, H
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_L_n:
	call.d	%r10				; %data = n	; 	LD_r_n		CYCLE_LD_L_n, L
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = n
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_L_A:
	ext	0x8		; 	xld.b	[%r4+0x8], %r5			; r = A	; 	LD_r_A		CYCLE_LD_L_A, L
	ld.b	[%r4],%r5
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = s	; 	LD_r_s		CYCLE_LD_L_B, L, B
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = s	; 	LD_r_s		CYCLE_LD_L_C, L, C
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = s	; 	LD_r_s		CYCLE_LD_L_D, L, D
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = s	; 	LD_r_s		CYCLE_LD_L_E, L, E
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = s	; 	LD_r_s		CYCLE_LD_L_H, L, H
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = s
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_LD_L_L:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*
dmgcpu_LD_L_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_r_IHLI	CYCLE_LD_L_IHLI, L
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(HL)
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = data
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_LD_IHLI_n:
	call.d	%r10				; %data = n	; 	LD_IHLI_n	CYCLE_LD_IHLI_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 12
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_A:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LD_IHLI_A	CYCLE_LD_IHLI_A
	ld.uh	%r0,[%r4]
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_B, B
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_C, C
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_D, D
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_E, E
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_H, H
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_IHLI_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	LD_IHLI_r	CYCLE_LD_IHLI_L, L
	ld.ub	%r1,[%r4]
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL
	ld.uh	%r0,[%r4]
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)

dmgcpu_LD_A_InnI:
	call.d	%r10				; %data = LO(nn)	; 	LD_A_InnI	CYCLE_LD_A_InnI
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ld.w	%r2, %r1			; %s0   = LO(nn)
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data = HI(nn)<<8
	or	%r2, %r1			; %s0   = HI(nn)<<8|LO(nn)
	call.d	%r10				; %data = READ(addr)
	ld.w	%r0, %r2			; %addr = nn   *delay*
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_LD_InnI_A:
	call.d	%r10				; %data = LO(nn)	; 	LD_InnI_A	CYCLE_LD_InnI_A
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ld.w	%r2, %r1			; %s0   = LO(nn)
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data = HI(nn)<<8
	or	%r2, %r1			; %s0   = HI(nn)<<8|LO(nn)
	ld.w	%r0, %r2			; %addr = nn
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 16
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_A_IBCI:
	ext	0x4		; 	xld.uh	%r0, [%r4+0x4]		; %addr = rr	; 	LD_A_IrrI	CYCLE_LD_A_IBCI, BC
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_IBCI_A:
	ext	0x4		; 	xld.uh	%r0, [%r4+0x4]		; %addr = rr	; 	LD_IrrI_A	CYCLE_LD_IBCI_A, BC
	ld.uh	%r0,[%r4]
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LD_A_IDEI:
	ext	0x6		; 	xld.uh	%r0, [%r4+0x6]		; %addr = rr	; 	LD_A_IrrI	CYCLE_LD_A_IDEI, DE
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_IDEI_A:
	ext	0x6		; 	xld.uh	%r0, [%r4+0x6]		; %addr = rr	; 	LD_IrrI_A	CYCLE_LD_IDEI_A, DE
	ld.uh	%r0,[%r4]
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)

dmgcpu_LD_A_ICI:
	ext	0x4		; 	xld.ub	%r0, [%r4+0x4]			; %addr = C	; 	LD_A_ICI	CYCLE_LD_A_ICI
	ld.ub	%r0,[%r4]
	ext	0x3fc		; 	xoor	%r0, %r0, 0xff00		; %addr = C|0xff00
	or	%r0,0x0
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LD_ICI_A:
	ext	0x4		; 	xld.ub	%r0, [%r4+0x4]			; %addr = C	; 	LD_ICI_A	CYCLE_LD_ICI_A
	ld.ub	%r0,[%r4]
	ext	0x3fc		; 	xoor	%r0, %r0, 0xff00		; %addr = C|0xff00
	or	%r0,0x0
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 8
	jp	%r11				; WRITE(addr, data)
dmgcpu_LDH_A_InI:
	call.d	%r10				; %data = n	; 	LDH_A_InI	CYCLE_LDH_A_InI
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x7		; 	xoor	%r0, %r1, 0xff00		; %addr = n|0xff00
	ext	0x1f00
	or	%r0,%r1
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_LDH_InI_A:
	call.d	%r10				; %data = n	; 	LDH_InI_A	CYCLE_LDH_InI_A
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	0x7		; 	xoor	%r0, %r1, 0xff00		; %addr = n|0xff00
	ext	0x1f00
	or	%r0,%r1
	ld.w	%r1, %r5			; %data = A
	sub	%r7, 12
	jp	%r11				; WRITE(addr, data)

dmgcpu_LDI_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LDI_A_IHLI	CYCLE_LDI_A_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	add	%r0,0x1		; 	xadd	%r0, %r0, 1			; %addr = HL+1
	ext	0x8		; 	xld.h	[%r4+0x8], %r0		; HL    = HL+1
	ld.h	[%r4],%r0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LDI_IHLI_A:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LDI_IHLI_A	CYCLE_LDI_IHLI_A
	ld.uh	%r0,[%r4]
	call.d	%r11				; WRITE(addr, data)
	ld.w	%r1, %r5			; %data = A *delay*
	add	%r0,0x1		; 	xadd	%r0, %r0, 1			; %addr = HL+1
	ext	0x8		; 	xld.h	[%r4+0x8], %r0		; HL    = HL+1
	ld.h	[%r4],%r0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LDD_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LDD_A_IHLI	CYCLE_LDD_A_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ld.w	%r5, %r1			; %A    = data
	sub	%r0,0x1		; 	xsub	%r0, %r0, 1			; %addr = HL-1
	ext	0x8		; 	xld.h	[%r4+0x8], %r0		; HL    = HL-1
	ld.h	[%r4],%r0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LDD_IHLI_A:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	LDD_IHLI_A	CYCLE_LDD_IHLI_A
	ld.uh	%r0,[%r4]
	call.d	%r11				; WRITE(addr, data)
	ld.w	%r1, %r5			; %data = A *delay*
	sub	%r0,0x1		; 	xsub	%r0, %r0, 1			; %addr = HL-1
	ext	0x8		; 	xld.h	[%r4+0x8], %r0		; HL    = HL-1
	ld.h	[%r4],%r0
	ret.d
	sub	%r7, 8			; *delay*

;****************************************************************************
;	16-Bit Loads
;****************************************************************************

;#macro	LD_rr_nn	$1, $2
;	call.d	%READ				; %data = LO(nn)
;	ld.w	%addr, %PC			; %addr = PC   *delay*
;	xld.b	[%CPU+$2+0], %data		; LO(rr) = LO(nn)
;	call.d	%READ				; %data = HI(nn)
;	add	%addr, 1			; %addr = PC+1 *delay*
;	xld.b	[%CPU+$2+1], %data		; HI(rr) = HI(nn)
;	xadd	%PC, %PC, 2			; %PC   = PC+2
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_SP_HL	$1
;	xld.uh	%data, [%CPU+HL]		; %data = HL
;	xld.h	[%CPU+SP], %data		; SP    = HL
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Set or reset according to operation.
;	C - Set or reset according to operation.
;
; [note]
;	dmgcpu_LDHL_SP_edmgcpu_ADD_SP_e邽߂Ɏg܂B
;
;#macro	LD_rr_SP_e	$1, $2
;	call.d	%READ				; %data = e (   0.. 255)
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	ld.b	%data, %data			; %data = e (-128..+127)
;	xld.uh	%t0, [%CPU+SP]			; %t0   = SP
;	xand	%t1, %t0, 0x0fff		; %t1   = 0000spsp spspspsp
;	add	%t0, %data			; %t0   = SP+e
;	xld.h	[%CPU+$2], %t0			; rr    = SP+e
;	xsrl	%t0, 8				; %t0   = -------C --------
;	xoor	%t0, %t0, 1			; %t0   = -------C -------1
;	xld.h	[%CPU+CZ], %t0			; CF    = -------C zzzzzzzz (z!=0 -> Z-Reset)
;	xand	%data, %data, 0x0fff		; %data = 0000eeee eeeeeeee
;	add	%t1, %data			; %t1   = 000H---- --------
;	xsrl	%t1, 8				; %t1   = 000H----
;	xld.b	[%CPU+NH], %t1			; NH    = --NH---- (N=0)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	LD_InnI_SP	$1
;	call.d	%READ				; %data = LO(nn)
;	ld.w	%addr, %PC			; %addr = PC   *delay*
;	ld.w	%s0, %data			; %s0   = LO(nn)
;	call.d	%READ				; %data = HI(nn)
;	add	%addr, 1			; %addr = PC+1 *delay*
;	xadd	%PC, %PC, 2			; %PC   = PC+2
;	xsll	%data, 8			; %data = HI(nn)<<8
;	or	%s0, %data			; %s0   = HI(nn)<<8|LO(nn)
;	xld.ub	%data, [%CPU+SP+0]		; %data = LO(SP)
;	call.d	%WRITE				; WRITE(nn+0, LO(SP))
;	ld.w	%addr, %s0			; %addr = nn+0 *delay*
;	xld.ub	%data, [%CPU+SP+1]		; %data = HI(SP)
;	xadd	%addr, %addr, 1			; %addr = nn+1 *delay*
;	sub	%CYCLE, $1
;	jp	%WRITE				; WRITE(nn+1, HI(SP))
;#endm

;#macro	PUSH_AF		$1
;	xcall	dmgcpu_pack			; %data = pack(CZ,NH)
;	ld.w	%t0, %A				; %t0   = A
;	xsll	%t0, 8				; %t0   = A<<8
;	xcall.d	dmgcpu_push			; PUSH(data)
;	or	%data, %t0			; %data = AF *delay*
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	POP_AF		$1
;	xcall	dmgcpu_pop			; %data = POP()
;	ld.w	%A, %data			; %A    = AF
;	xsrl	%A, 8				; %A    = A
;	xjp.d	dmgcpu_unpack			; CZ,NH = unpack(F)
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	PUSH_rr		$1, $2
;	xld.uh	%data, [%CPU+$2]		; %data = rr
;	xjp.d	dmgcpu_push			; PUSH(data)
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	POP_rr		$1, $2
;	xcall	dmgcpu_pop			; %data = POP()
;	xld.h	[%CPU+$2], %data		; rr    = data
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;----------------------------------------------------------------------------

dmgcpu_LD_BC_nn:
	call.d	%r10				; %data = LO(nn)	; 	LD_rr_nn	CYCLE_LD_BC_nn, BC
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; LO(rr) = LO(nn)
	ld.b	[%r4],%r1
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; HI(rr) = HI(nn)
	ld.b	[%r4],%r1
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_LD_DE_nn:
	call.d	%r10				; %data = LO(nn)	; 	LD_rr_nn	CYCLE_LD_DE_nn, DE
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; LO(rr) = LO(nn)
	ld.b	[%r4],%r1
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; HI(rr) = HI(nn)
	ld.b	[%r4],%r1
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_LD_HL_nn:
	call.d	%r10				; %data = LO(nn)	; 	LD_rr_nn	CYCLE_LD_HL_nn, HL
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; LO(rr) = LO(nn)
	ld.b	[%r4],%r1
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; HI(rr) = HI(nn)
	ld.b	[%r4],%r1
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_LD_SP_nn:
	call.d	%r10				; %data = LO(nn)	; 	LD_rr_nn	CYCLE_LD_SP_nn, SP
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ext	0xa		; 	xld.b	[%r4+0xa], %r1		; LO(rr) = LO(nn)
	ld.b	[%r4],%r1
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	ext	0xb		; 	xld.b	[%r4+0xb], %r1		; HI(rr) = HI(nn)
	ld.b	[%r4],%r1
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	ret.d
	sub	%r7, 12			; *delay*

dmgcpu_LD_SP_HL:
	ext	0x8		; 	xld.uh	%r1, [%r4+0x8]		; %data = HL	; 	LD_SP_HL	CYCLE_LD_SP_HL
	ld.uh	%r1,[%r4]
	ext	0xa		; 	xld.h	[%r4+0xa], %r1		; SP    = HL
	ld.h	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_LDHL_SP_e:
	call.d	%r10				; %data = e (   0.. 255)	; 	LD_rr_SP_e	CYCLE_LDHL_SP_e, HL
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ld.b	%r1, %r1			; %data = e (-128..+127)
	ext	0xa		; 	xld.uh	%r12, [%r4+0xa]			; %t0   = SP
	ld.uh	%r12,[%r4]
	ext	0xfff		; 	xand	%r13, %r12, 0x0fff		; %t1   = 0000spsp spspspsp
	and	%r13,%r12
	add	%r12, %r1			; %t0   = SP+e
	ext	0x8		; 	xld.h	[%r4+0x8], %r12			; rr    = SP+e
	ld.h	[%r4],%r12
	srl	%r12,0x8	; 	xsrl	%r12, 8				; %t0   = -------C --------
	or	%r12,0x1	; 	xoor	%r12, %r12, 1			; %t0   = -------C -------1
	ld.h	[%r4],%r12	; 	xld.h	[%r4+0x0], %r12			; CF    = -------C zzzzzzzz (z!=0 -> Z-Reset)
	ext	0x3f		; 	xand	%r1, %r1, 0x0fff		; %data = 0000eeee eeeeeeee
	and	%r1,0x3f
	add	%r13, %r1			; %t1   = 000H---- --------
	srl	%r13,0x8	; 	xsrl	%r13, 8				; %t1   = 000H----
	ext	0x2		; 	xld.b	[%r4+0x2], %r13			; NH    = --NH---- (N=0)
	ld.b	[%r4],%r13
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_LD_InnI_SP:
	call.d	%r10				; %data = LO(nn)	; 	LD_InnI_SP	CYCLE_LD_InnI_SP
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ld.w	%r2, %r1			; %s0   = LO(nn)
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; %PC   = PC+2
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data = HI(nn)<<8
	or	%r2, %r1			; %s0   = HI(nn)<<8|LO(nn)
	ext	0xa		; 	xld.ub	%r1, [%r4+0xa]		; %data = LO(SP)
	ld.ub	%r1,[%r4]
	call.d	%r11				; WRITE(nn+0, LO(SP))
	ld.w	%r0, %r2			; %addr = nn+0 *delay*
	ext	0xb		; 	xld.ub	%r1, [%r4+0xb]		; %data = HI(SP)
	ld.ub	%r1,[%r4]
	add	%r0,0x1		; 	xadd	%r0, %r0, 1			; %addr = nn+1 *delay*
	sub	%r7, 20
	jp	%r11				; WRITE(nn+1, HI(SP))

dmgcpu_PUSH_AF:
	ext	dmgcpu_pack@rm	; 	xcall	dmgcpu_pack			; %data = pack(CZ,NH)	; 	PUSH_AF		CYCLE_PUSH_AF
	call	dmgcpu_pack@rl
	ld.w	%r12, %r5				; %t0   = A
	sll	%r12,0x8	; 	xsll	%r12, 8				; %t0   = A<<8
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(data)
	call.d	dmgcpu_push@rl
	or	%r1, %r12			; %data = AF *delay*
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_PUSH_BC:
	ext	0x4		; 	xld.uh	%r1, [%r4+0x4]		; %data = rr	; 	PUSH_rr		CYCLE_PUSH_BC, BC
	ld.uh	%r1,[%r4]
	ext	dmgcpu_push@rm	; 	xjp.d	dmgcpu_push			; PUSH(data)
	jp.d	dmgcpu_push@rl
	sub	%r7, 16			; *delay*
dmgcpu_PUSH_DE:
	ext	0x6		; 	xld.uh	%r1, [%r4+0x6]		; %data = rr	; 	PUSH_rr		CYCLE_PUSH_DE, DE
	ld.uh	%r1,[%r4]
	ext	dmgcpu_push@rm	; 	xjp.d	dmgcpu_push			; PUSH(data)
	jp.d	dmgcpu_push@rl
	sub	%r7, 16			; *delay*
dmgcpu_PUSH_HL:
	ext	0x8		; 	xld.uh	%r1, [%r4+0x8]		; %data = rr	; 	PUSH_rr		CYCLE_PUSH_HL, HL
	ld.uh	%r1,[%r4]
	ext	dmgcpu_push@rm	; 	xjp.d	dmgcpu_push			; PUSH(data)
	jp.d	dmgcpu_push@rl
	sub	%r7, 16			; *delay*

dmgcpu_POP_AF:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()	; 	POP_AF		CYCLE_POP_AF
	call	dmgcpu_pop@rl
	ld.w	%r5, %r1			; %A    = AF
	srl	%r5,0x8		; 	xsrl	%r5, 8				; %A    = A
	ext	dmgcpu_unpack@rm	; 	xjp.d	dmgcpu_unpack			; CZ,NH = unpack(F)
	jp.d	dmgcpu_unpack@rl
	sub	%r7, 12			; *delay*
dmgcpu_POP_BC:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()	; 	POP_rr		CYCLE_POP_BC, BC
	call	dmgcpu_pop@rl
	ext	0x4		; 	xld.h	[%r4+0x4], %r1		; rr    = data
	ld.h	[%r4],%r1
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_POP_DE:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()	; 	POP_rr		CYCLE_POP_DE, DE
	call	dmgcpu_pop@rl
	ext	0x6		; 	xld.h	[%r4+0x6], %r1		; rr    = data
	ld.h	[%r4],%r1
	ret.d
	sub	%r7, 12			; *delay*
dmgcpu_POP_HL:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()	; 	POP_rr		CYCLE_POP_HL, HL
	call	dmgcpu_pop@rl
	ext	0x8		; 	xld.h	[%r4+0x8], %r1		; rr    = data
	ld.h	[%r4],%r1
	ret.d
	sub	%r7, 12			; *delay*

;****************************************************************************
;	8-Bit ALU
;****************************************************************************

;#macro	ADD_A_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_add			; %A    = A+n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADD_A_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_add			; %A    = A+A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADD_A_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_add			; %A    = A+r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADD_A_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_add			; %A    = A+[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADC_A_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_adc			; %A    = A+n+C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADC_A_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_adc			; %A    = A+A+C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADC_A_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_adc			; %A    = A+r+C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	ADC_A_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_adc			; %A    = A+[HL]+C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SUB_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_sub			; %A    = A-n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SUB_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_sub			; %A    = A-A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SUB_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_sub			; %A    = A-r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SUB_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_sub			; %A    = A-[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SBC_A_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_sbc			; %A    = A-n-C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SBC_A_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_sbc			; %A    = A-A-C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SBC_A_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_sbc			; %A    = A-r-C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SBC_A_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_sbc			; %A    = A-[HL]-C
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	CP_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_cp			; test    A-n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	CP_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_cp			; test    A-A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	CP_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_cp			; test    A-r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	CP_IHLI		$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_cp			; test    A-[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	AND_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_and			; %A    = A&n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	AND_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_and			; %A    = A&A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	AND_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_and			; %A    = A&r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	AND_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_and			; %A    = A&[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	OR_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_or			; %A    = A|n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	OR_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_or			; %A    = A|A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	OR_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_or			; %A    = A|r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	OR_IHLI		$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_or			; %A    = A|[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	XOR_n		$1
;	call.d	%READ				; %data = n
;	ld.w	%addr, %PC			; %addr = PC *delay*
;	xadd	%PC, %PC, 1			; %PC   = PC+1
;	xjp.d	dmgcpu_xor			; %A    = A^n
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	XOR_A		$1
;	ld.w	%data, %A			; %data = A
;	xjp.d	dmgcpu_xor			; %A    = A^A
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	XOR_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xjp.d	dmgcpu_xor			; %A    = A^r
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	XOR_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = READ(addr)
;	xjp.d	dmgcpu_xor			; %A    = A^[HL]
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	INC_A		$1
;	xcall.d	dmgcpu_inc			; %data = A+1
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = A+1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	INC_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_inc			; %data = r+1
;	xld.b	[%CPU+$2], %data		; r     = r+1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	INC_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_inc			; %data = [HL]+1
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = [HL]+1
;#endm

;#macro	DEC_A		$1
;	xcall.d	dmgcpu_dec			; %data = A-1
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = A-1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	DEC_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_dec			; %data = r-1
;	xld.b	[%CPU+$2], %data		; r     = r-1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	DEC_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_dec			; %data = [HL]-1
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = [HL]-1
;#endm

;----------------------------------------------------------------------------

dmgcpu_ADD_A_n:
	call.d	%r10				; %data = n	; 	ADD_A_n		CYCLE_ADD_A_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+n
	jp.d	dmgcpu_add@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADD_A_A:
	ld.w	%r1, %r5			; %data = A	; 	ADD_A_A		CYCLE_ADD_A_A
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+A
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	ADD_A_r		CYCLE_ADD_A_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+r
	jp.d	dmgcpu_add@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADD_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	ADD_A_IHLI	CYCLE_ADD_A_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_add@rm	; 	xjp.d	dmgcpu_add			; %A    = A+[HL]
	jp.d	dmgcpu_add@rl
	sub	%r7, 8			; *delay*

dmgcpu_ADC_A_n:
	call.d	%r10				; %data = n	; 	ADC_A_n		CYCLE_ADC_A_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+n+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADC_A_A:
	ld.w	%r1, %r5			; %data = A	; 	ADC_A_A		CYCLE_ADC_A_A
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+A+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	ADC_A_r		CYCLE_ADC_A_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+r+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 4			; *delay*
dmgcpu_ADC_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	ADC_A_IHLI	CYCLE_ADC_A_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_adc@rm	; 	xjp.d	dmgcpu_adc			; %A    = A+[HL]+C
	jp.d	dmgcpu_adc@rl
	sub	%r7, 8			; *delay*

dmgcpu_SUB_n:
	call.d	%r10				; %data = n	; 	SUB_n		CYCLE_SUB_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-n
	jp.d	dmgcpu_sub@rl
	sub	%r7, 8			; *delay*
dmgcpu_SUB_A:
	ld.w	%r1, %r5			; %data = A	; 	SUB_A		CYCLE_SUB_A
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-A
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SUB_r		CYCLE_SUB_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SUB_r		CYCLE_SUB_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SUB_r		CYCLE_SUB_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SUB_r		CYCLE_SUB_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SUB_r		CYCLE_SUB_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SUB_r		CYCLE_SUB_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-r
	jp.d	dmgcpu_sub@rl
	sub	%r7, 4			; *delay*
dmgcpu_SUB_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SUB_IHLI	CYCLE_SUB_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_sub@rm	; 	xjp.d	dmgcpu_sub			; %A    = A-[HL]
	jp.d	dmgcpu_sub@rl
	sub	%r7, 8			; *delay*

dmgcpu_SBC_A_n:
	call.d	%r10				; %data = n	; 	SBC_A_n		CYCLE_SBC_A_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-n-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 8			; *delay*
dmgcpu_SBC_A_A:
	ld.w	%r1, %r5			; %data = A	; 	SBC_A_A		CYCLE_SBC_A_A
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-A-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SBC_A_r		CYCLE_SBC_A_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-r-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 4			; *delay*
dmgcpu_SBC_A_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SBC_A_IHLI	CYCLE_SBC_A_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_sbc@rm	; 	xjp.d	dmgcpu_sbc			; %A    = A-[HL]-C
	jp.d	dmgcpu_sbc@rl
	sub	%r7, 8			; *delay*

dmgcpu_CP_n:
	call.d	%r10				; %data = n	; 	CP_n		CYCLE_CP_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-n
	jp.d	dmgcpu_cp@rl
	sub	%r7, 8			; *delay*
dmgcpu_CP_A:
	ld.w	%r1, %r5			; %data = A	; 	CP_A		CYCLE_CP_A
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-A
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	CP_r		CYCLE_CP_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	CP_r		CYCLE_CP_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	CP_r		CYCLE_CP_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	CP_r		CYCLE_CP_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	CP_r		CYCLE_CP_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	CP_r		CYCLE_CP_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-r
	jp.d	dmgcpu_cp@rl
	sub	%r7, 4			; *delay*
dmgcpu_CP_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	CP_IHLI		CYCLE_CP_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_cp@rm	; 	xjp.d	dmgcpu_cp			; test    A-[HL]
	jp.d	dmgcpu_cp@rl
	sub	%r7, 8			; *delay*

dmgcpu_AND_n:
	call.d	%r10				; %data = n	; 	AND_n		CYCLE_AND_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&n
	jp.d	dmgcpu_and@rl
	sub	%r7, 8			; *delay*
dmgcpu_AND_A:
	ld.w	%r1, %r5			; %data = A	; 	AND_A		CYCLE_AND_A
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&A
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	AND_r		CYCLE_AND_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	AND_r		CYCLE_AND_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	AND_r		CYCLE_AND_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	AND_r		CYCLE_AND_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	AND_r		CYCLE_AND_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	AND_r		CYCLE_AND_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&r
	jp.d	dmgcpu_and@rl
	sub	%r7, 4			; *delay*
dmgcpu_AND_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	AND_IHLI	CYCLE_AND_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_and@rm	; 	xjp.d	dmgcpu_and			; %A    = A&[HL]
	jp.d	dmgcpu_and@rl
	sub	%r7, 8			; *delay*

dmgcpu_OR_n:
	call.d	%r10				; %data = n	; 	OR_n		CYCLE_OR_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|n
	jp.d	dmgcpu_or@rl
	sub	%r7, 8			; *delay*
dmgcpu_OR_A:
	ld.w	%r1, %r5			; %data = A	; 	OR_A		CYCLE_OR_A
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|A
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	OR_r		CYCLE_OR_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	OR_r		CYCLE_OR_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	OR_r		CYCLE_OR_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	OR_r		CYCLE_OR_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	OR_r		CYCLE_OR_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	OR_r		CYCLE_OR_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|r
	jp.d	dmgcpu_or@rl
	sub	%r7, 4			; *delay*
dmgcpu_OR_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	OR_IHLI		CYCLE_OR_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_or@rm	; 	xjp.d	dmgcpu_or			; %A    = A|[HL]
	jp.d	dmgcpu_or@rl
	sub	%r7, 8			; *delay*

dmgcpu_XOR_n:
	call.d	%r10				; %data = n	; 	XOR_n		CYCLE_XOR_n
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^n
	jp.d	dmgcpu_xor@rl
	sub	%r7, 8			; *delay*
dmgcpu_XOR_A:
	ld.w	%r1, %r5			; %data = A	; 	XOR_A		CYCLE_XOR_A
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^A
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	XOR_r		CYCLE_XOR_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	XOR_r		CYCLE_XOR_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	XOR_r		CYCLE_XOR_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	XOR_r		CYCLE_XOR_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	XOR_r		CYCLE_XOR_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	XOR_r		CYCLE_XOR_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^r
	jp.d	dmgcpu_xor@rl
	sub	%r7, 4			; *delay*
dmgcpu_XOR_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	XOR_IHLI	CYCLE_XOR_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = READ(addr)
	ext	dmgcpu_xor@rm	; 	xjp.d	dmgcpu_xor			; %A    = A^[HL]
	jp.d	dmgcpu_xor@rl
	sub	%r7, 8			; *delay*

dmgcpu_INC_A:
	ext	dmgcpu_inc@rm	; 	xcall.d	dmgcpu_inc			; %data = A+1	; 	INC_A		CYCLE_INC_A
	call.d	dmgcpu_inc@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = A+1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	INC_r		CYCLE_INC_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	INC_r		CYCLE_INC_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	INC_r		CYCLE_INC_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	INC_r		CYCLE_INC_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	INC_r		CYCLE_INC_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	INC_r		CYCLE_INC_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_inc@rm	; 	xcall	dmgcpu_inc			; %data = r+1
	call	dmgcpu_inc@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = r+1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_INC_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	INC_IHLI	CYCLE_INC_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_inc@rm	; 	xcall.d	dmgcpu_inc			; %data = [HL]+1
	call.d	dmgcpu_inc@rl
	sub	%r7, 12			; *delay*
	jp	%r11				; [HL]  = [HL]+1

dmgcpu_DEC_A:
	ext	dmgcpu_dec@rm	; 	xcall.d	dmgcpu_dec			; %data = A-1	; 	DEC_A		CYCLE_DEC_A
	call.d	dmgcpu_dec@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = A-1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	DEC_r		CYCLE_DEC_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	DEC_r		CYCLE_DEC_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	DEC_r		CYCLE_DEC_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	DEC_r		CYCLE_DEC_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	DEC_r		CYCLE_DEC_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	DEC_r		CYCLE_DEC_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_dec@rm	; 	xcall	dmgcpu_dec			; %data = r-1
	call	dmgcpu_dec@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = r-1
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 4			; *delay*
dmgcpu_DEC_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	DEC_IHLI	CYCLE_DEC_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_dec@rm	; 	xcall.d	dmgcpu_dec			; %data = [HL]-1
	call.d	dmgcpu_dec@rl
	sub	%r7, 12			; *delay*
	jp	%r11				; [HL]  = [HL]-1

;****************************************************************************
;	16-Bit Arithmetic
;****************************************************************************

;#macro	ADD_HL_rr	$1, $2
;	xld.uh	%data, [%CPU+$2]		; %data = rr
;	xjp.d	dmgcpu_addw			; HL    = HL+rr
;	sub	%CYCLE, $1			; *delay*
;#endm

;
; Flags affected:
;	None.
;
;#macro	INC_rr		$1, $2
;	xld.uh	%t0, [%CPU+$2]
;	xadd	%t0, %t0, 1
;	xld.h	[%CPU+$2], %t0
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;
; Flags affected:
;	None.
;
;#macro	DEC_rr		$1, $2
;	xld.uh	%t0, [%CPU+$2]
;	xsub	%t0, %t0, 1
;	xld.h	[%CPU+$2], %t0
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;----------------------------------------------------------------------------

dmgcpu_ADD_HL_BC:
	ext	0x4		; 	xld.uh	%r1, [%r4+0x4]		; %data = rr	; 	ADD_HL_rr	CYCLE_ADD_HL_BC, BC
	ld.uh	%r1,[%r4]
	ext	dmgcpu_addw@rm	; 	xjp.d	dmgcpu_addw			; HL    = HL+rr
	jp.d	dmgcpu_addw@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADD_HL_DE:
	ext	0x6		; 	xld.uh	%r1, [%r4+0x6]		; %data = rr	; 	ADD_HL_rr	CYCLE_ADD_HL_DE, DE
	ld.uh	%r1,[%r4]
	ext	dmgcpu_addw@rm	; 	xjp.d	dmgcpu_addw			; HL    = HL+rr
	jp.d	dmgcpu_addw@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADD_HL_HL:
	ext	0x8		; 	xld.uh	%r1, [%r4+0x8]		; %data = rr	; 	ADD_HL_rr	CYCLE_ADD_HL_HL, HL
	ld.uh	%r1,[%r4]
	ext	dmgcpu_addw@rm	; 	xjp.d	dmgcpu_addw			; HL    = HL+rr
	jp.d	dmgcpu_addw@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADD_HL_SP:
	ext	0xa		; 	xld.uh	%r1, [%r4+0xa]		; %data = rr	; 	ADD_HL_rr	CYCLE_ADD_HL_SP, SP
	ld.uh	%r1,[%r4]
	ext	dmgcpu_addw@rm	; 	xjp.d	dmgcpu_addw			; HL    = HL+rr
	jp.d	dmgcpu_addw@rl
	sub	%r7, 8			; *delay*
dmgcpu_ADD_SP_e:
	call.d	%r10				; %data = e (   0.. 255)	; 	LD_rr_SP_e	CYCLE_ADD_SP_e, SP
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ld.b	%r1, %r1			; %data = e (-128..+127)
	ext	0xa		; 	xld.uh	%r12, [%r4+0xa]			; %t0   = SP
	ld.uh	%r12,[%r4]
	ext	0xfff		; 	xand	%r13, %r12, 0x0fff		; %t1   = 0000spsp spspspsp
	and	%r13,%r12
	add	%r12, %r1			; %t0   = SP+e
	ext	0xa		; 	xld.h	[%r4+0xa], %r12			; rr    = SP+e
	ld.h	[%r4],%r12
	srl	%r12,0x8	; 	xsrl	%r12, 8				; %t0   = -------C --------
	or	%r12,0x1	; 	xoor	%r12, %r12, 1			; %t0   = -------C -------1
	ld.h	[%r4],%r12	; 	xld.h	[%r4+0x0], %r12			; CF    = -------C zzzzzzzz (z!=0 -> Z-Reset)
	ext	0x3f		; 	xand	%r1, %r1, 0x0fff		; %data = 0000eeee eeeeeeee
	and	%r1,0x3f
	add	%r13, %r1			; %t1   = 000H---- --------
	srl	%r13,0x8	; 	xsrl	%r13, 8				; %t1   = 000H----
	ext	0x2		; 	xld.b	[%r4+0x2], %r13			; NH    = --NH---- (N=0)
	ld.b	[%r4],%r13
	ret.d
	sub	%r7, 16			; *delay*

dmgcpu_INC_BC:
	ext	0x4		; 	xld.uh	%r12, [%r4+0x4]	; 	INC_rr		CYCLE_INC_BC, BC
	ld.uh	%r12,[%r4]
	add	%r12,0x1	; 	xadd	%r12, %r12, 1
	ext	0x4		; 	xld.h	[%r4+0x4], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_INC_DE:
	ext	0x6		; 	xld.uh	%r12, [%r4+0x6]	; 	INC_rr		CYCLE_INC_DE, DE
	ld.uh	%r12,[%r4]
	add	%r12,0x1	; 	xadd	%r12, %r12, 1
	ext	0x6		; 	xld.h	[%r4+0x6], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_INC_HL:
	ext	0x8		; 	xld.uh	%r12, [%r4+0x8]	; 	INC_rr		CYCLE_INC_HL, HL
	ld.uh	%r12,[%r4]
	add	%r12,0x1	; 	xadd	%r12, %r12, 1
	ext	0x8		; 	xld.h	[%r4+0x8], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_INC_SP:
	ext	0xa		; 	xld.uh	%r12, [%r4+0xa]	; 	INC_rr		CYCLE_INC_SP, SP
	ld.uh	%r12,[%r4]
	add	%r12,0x1	; 	xadd	%r12, %r12, 1
	ext	0xa		; 	xld.h	[%r4+0xa], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*

dmgcpu_DEC_BC:
	ext	0x4		; 	xld.uh	%r12, [%r4+0x4]	; 	DEC_rr		CYCLE_DEC_BC, BC
	ld.uh	%r12,[%r4]
	sub	%r12,0x1	; 	xsub	%r12, %r12, 1
	ext	0x4		; 	xld.h	[%r4+0x4], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_DEC_DE:
	ext	0x6		; 	xld.uh	%r12, [%r4+0x6]	; 	DEC_rr		CYCLE_DEC_DE, DE
	ld.uh	%r12,[%r4]
	sub	%r12,0x1	; 	xsub	%r12, %r12, 1
	ext	0x6		; 	xld.h	[%r4+0x6], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_DEC_HL:
	ext	0x8		; 	xld.uh	%r12, [%r4+0x8]	; 	DEC_rr		CYCLE_DEC_HL, HL
	ld.uh	%r12,[%r4]
	sub	%r12,0x1	; 	xsub	%r12, %r12, 1
	ext	0x8		; 	xld.h	[%r4+0x8], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_DEC_SP:
	ext	0xa		; 	xld.uh	%r12, [%r4+0xa]	; 	DEC_rr		CYCLE_DEC_SP, SP
	ld.uh	%r12,[%r4]
	sub	%r12,0x1	; 	xsub	%r12, %r12, 1
	ext	0xa		; 	xld.h	[%r4+0xa], %r12
	ld.h	[%r4],%r12
	ret.d
	sub	%r7, 8			; *delay*

;****************************************************************************
;	Miscellaneous
;****************************************************************************

;#macro	SWAP_A		$1
;	xcall.d	dmgcpu_swap			; %data = SWAP(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = SWAP(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SWAP_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_swap			; %data = SWAP(r)
;	xld.b	[%CPU+$2], %data		; r     = SWAP(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SWAP_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_swap			; %data = SWAP([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = SWAP([HL])
;#endm

;----------------------------------------------------------------------------

dmgcpu_SWAP_A:
	ext	dmgcpu_swap@rm	; 	xcall.d	dmgcpu_swap			; %data = SWAP(A)	; 	SWAP_A		CYCLE_SWAP_A
	call.d	dmgcpu_swap@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = SWAP(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SWAP_r		CYCLE_SWAP_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SWAP_r		CYCLE_SWAP_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SWAP_r		CYCLE_SWAP_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SWAP_r		CYCLE_SWAP_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SWAP_r		CYCLE_SWAP_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SWAP_r		CYCLE_SWAP_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_swap@rm	; 	xcall	dmgcpu_swap			; %data = SWAP(r)
	call	dmgcpu_swap@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = SWAP(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SWAP_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SWAP_IHLI	CYCLE_SWAP_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_swap@rm	; 	xcall.d	dmgcpu_swap			; %data = SWAP([HL])
	call.d	dmgcpu_swap@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = SWAP([HL])

;
; Flags affected:
;	Z - Set if register A is zero.
;	N - Not affected.
;	H - Reset.
;	C - Set or reset according to operation.
;
dmgcpu_DAA:
	ext	dmgcpu_leave@rm	; 	xcall	dmgcpu_leave
	call	dmgcpu_leave@rl
	ext	dmgcpu_daa@rm	; 	xcall	dmgcpu_daa
	call	dmgcpu_daa@rl
	ext	dmgcpu_enter@rm	; 	xjp	dmgcpu_enter
	jp	dmgcpu_enter@rl

;
; Flags affected:
;	Z - Not affected.
;	N - Set.
;	H - Set.
;	C - Not affected.
;
dmgcpu_CPL:
	not	%r5, %r5				; %A  = ~A
	ld.ub	%r5, %r5				; (Kv!!)
	ld.w	%r12,0x3f	; 	xld.w	%r12, -1				; %t0 = 11111111
	ext	0x2		; 	xld.b	[%r4+0x2], %r12			; NH  = --NH---- (N=1,H=1)
	ld.b	[%r4],%r12
	ret.d
	sub	%r7, 4		; *delay*

;
; Flags affected:
;	Z - Not affected.
;	N - Reset.
;	H - Reset.
;	C - Set.
;
dmgcpu_SCF:
	ext	0x1		; 	xbset	[%r4+0x1], 0x0			; CF = 1
	bset	[%r4],0x0
	ext	0x2		; 	xld.b	[%r4+0x2], %r8			; NH = --NH---- (N=0,H=0)
	ld.b	[%r4],%r8
	ret.d
	sub	%r7, 4		; *delay*

;
; Flags affected:
;	Z - Not affected.
;	N - Reset.
;	H - Reset.
;	C - Complemented.
;
dmgcpu_CCF:
	ext	0x1		; 	xbnot	[%r4+0x1], 0x0			; CF = !CF
	bnot	[%r4],0x0
	ext	0x2		; 	xld.b	[%r4+0x2], %r8			; NH = --NH---- (N=0,H=0)
	ld.b	[%r4],%r8
	ret.d
	sub	%r7, 4		; *delay*

dmgcpu_NOP:
	ret.d	; ** no job **
	sub	%r7, 4		; *delay*

dmgcpu_HALT:
	ext	0xe		; 	xbset	[%r4+0xe], 0x1		; HALT = 1
	bset	[%r4],0x1
	ret.d
	;sub	%CYCLE, CYCLE_HALT		; *delay*
	;csTCNjAdmgcpu_run𔲂܂B
	ld.w	%r7, 0			; *delay*

dmgcpu_STOP:
	ext	0xe		; 	xbset	[%r4+0xe], 0x2		; STOP = 1
	bset	[%r4],0x2
	ret.d
	;sub	%CYCLE, CYCLE_STOP		; *delay*
	;csTCNjAdmgcpu_run𔲂܂B
	ld.w	%r7, 0			; *delay*

dmgcpu_DI:
	ext	0xe		; 	xbclr	[%r4+0xe], 0x0		; IME = 0
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 4		; *delay*

dmgcpu_EI:
	; EI̖̒߂sŁA荞݂܂B
	; Ɋ荞݂Ă܂ƁA"Bubble_Bobble_(J).zip"삵܂B
	;/*{{dmgcpu_runRs[*/
;#ifdef DMGCPU_RUN_TRACE
;	xcall dmgcpu_leave
;	xcall dmgcpu_trace
;	xcall dmgcpu_enter
;#endif /*DMGCPU_RUN_TRACE*/
	call.d	%r10				; OpCode擾APCi߂܂B
	ld.w	%r0, %r6
	add	%r6,0x1		; 	xadd	%r6, %r6, 1
	sll	%r1,0x2		; 	xsll	%r1, 2			; OpCodeɑΉ閽߃[`Ăяo܂B
	ext	dmgcpu_XXops@ah
	ext	dmgcpu_XXops@al
	ld.w	%r1, [%r1]
	call	%r1
	;/*}}dmgcpu_runRs[*/
	ext	0xe		; 	xbset	[%r4+0xe], 0x0		; IME = 1
	bset	[%r4],0x0
	ext	dmgcpu_CHECK_PENDING@rm	; 	xjp.d	dmgcpu_CHECK_PENDING		; ۗĂ荞݂΁As܂B
	jp.d	dmgcpu_CHECK_PENDING@rl
	sub	%r7, 4		; *delay*

;****************************************************************************
;	Rotates & Shifts
;****************************************************************************

;#macro	RL_A		$1
;	xcall.d	dmgcpu_rl			; %data = RL(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = RL(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RL_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_rl			; %data = RL(r)
;	xld.b	[%CPU+$2], %data		; r     = RL(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RL_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_rl			; %data = RL([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = RL([HL])
;#endm

;#macro	RLC_A		$1
;	xcall.d	dmgcpu_rlc			; %data = RLC(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = RLC(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RLC_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_rlc			; %data = RLC(r)
;	xld.b	[%CPU+$2], %data		; r     = RLC(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RLC_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_rlc			; %data = RLC([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = RLC([HL])
;#endm

;#macro	RR_A		$1
;	xcall.d	dmgcpu_rr			; %data = RR(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = RR(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RR_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_rr			; %data = RR(r)
;	xld.b	[%CPU+$2], %data		; r     = RR(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RR_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_rr			; %data = RR([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = RR([HL])
;#endm

;#macro	RRC_A		$1
;	xcall.d	dmgcpu_rrc			; %data = RRC(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = RRC(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RRC_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_rrc			; %data = RRC(r)
;	xld.b	[%CPU+$2], %data		; r     = RRC(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RRC_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_rrc			; %data = RRC([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = RRC([HL])
;#endm

;#macro	SLA_A		$1
;	xcall.d	dmgcpu_sla			; %data = SLA(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = SLA(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SLA_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_sla			; %data = SLA(r)
;	xld.b	[%CPU+$2], %data		; r     = SLA(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SLA_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_sla			; %data = SLA([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = SLA([HL])
;#endm

;#macro	SRA_A		$1
;	xcall.d	dmgcpu_sra			; %data = SRA(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = SRA(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SRA_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_sra			; %data = SRA(r)
;	xld.b	[%CPU+$2], %data		; r     = SRA(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SRA_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_sra			; %data = SRA([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = SRA([HL])
;#endm

;#macro	SRL_A		$1
;	xcall.d	dmgcpu_srl			; %data = SRL(A)
;	ld.w	%data, %A			; %data = A *delay*
;	ld.w	%A, %data			; %A    = SRL(A)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SRL_r		$1, $2
;	xld.ub	%data, [%CPU+$2]		; %data = r
;	xcall	dmgcpu_srl			; %data = SRL(r)
;	xld.b	[%CPU+$2], %data		; r     = SRL(r)
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SRL_IHLI	$1
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call	%READ				; %data = [HL]
;	xcall.d	dmgcpu_srl			; %data = SRL([HL])
;	sub	%CYCLE, $1			; *delay*
;	jp	%WRITE				; [HL]  = SRL([HL])
;#endm

;----------------------------------------------------------------------------

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 7 data.
;
dmgcpu_RLA:
	ext	dmgcpu_rl@rm	; 	xcall.d	dmgcpu_rl			; %data = RL(A)
	call.d	dmgcpu_rl@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RL(A)
	bset	[%r4],0x0	; 	xbset	[%r4+0x0], 0x0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%r7, 4		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 7 data.
;
dmgcpu_RLCA:
	ext	dmgcpu_rlc@rm	; 	xcall.d	dmgcpu_rlc			; %data = RLC(A)
	call.d	dmgcpu_rlc@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RLC(A)
	bset	[%r4],0x0	; 	xbset	[%r4+0x0], 0x0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%r7, 4		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 0 data.
;
dmgcpu_RRA:
	ext	dmgcpu_rr@rm	; 	xcall.d	dmgcpu_rr			; %data = RR(A)
	call.d	dmgcpu_rr@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RR(A)
	bset	[%r4],0x0	; 	xbset	[%r4+0x0], 0x0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%r7, 4		; *delay*

;
; Flags affected:
;	Z - Reset.
;	N - Reset.
;	H - Reset.
;	C - Contains old bit 0 data.
;
dmgcpu_RRCA:
	ext	dmgcpu_rrc@rm	; 	xcall.d	dmgcpu_rrc			; %data = RRC(A)
	call.d	dmgcpu_rrc@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RRC(A)
	bset	[%r4],0x0	; 	xbset	[%r4+0x0], 0x0			; ZF    = -------1 (z!=0 -> Z-Reset)
	ret.d
	sub	%r7, 4		; *delay*

dmgcpu_RL_A:
	ext	dmgcpu_rl@rm	; 	xcall.d	dmgcpu_rl			; %data = RL(A)	; 	RL_A		CYCLE_RL_A
	call.d	dmgcpu_rl@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RL(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	RL_r		CYCLE_RL_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	RL_r		CYCLE_RL_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	RL_r		CYCLE_RL_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	RL_r		CYCLE_RL_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	RL_r		CYCLE_RL_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	RL_r		CYCLE_RL_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rl@rm	; 	xcall	dmgcpu_rl			; %data = RL(r)
	call	dmgcpu_rl@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = RL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RL_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RL_IHLI		CYCLE_RL_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_rl@rm	; 	xcall.d	dmgcpu_rl			; %data = RL([HL])
	call.d	dmgcpu_rl@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = RL([HL])

dmgcpu_RLC_A:
	ext	dmgcpu_rlc@rm	; 	xcall.d	dmgcpu_rlc			; %data = RLC(A)	; 	RLC_A		CYCLE_RLC_A
	call.d	dmgcpu_rlc@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RLC(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	RLC_r		CYCLE_RLC_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	RLC_r		CYCLE_RLC_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	RLC_r		CYCLE_RLC_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	RLC_r		CYCLE_RLC_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	RLC_r		CYCLE_RLC_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	RLC_r		CYCLE_RLC_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rlc@rm	; 	xcall	dmgcpu_rlc			; %data = RLC(r)
	call	dmgcpu_rlc@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = RLC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RLC_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RLC_IHLI	CYCLE_RLC_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_rlc@rm	; 	xcall.d	dmgcpu_rlc			; %data = RLC([HL])
	call.d	dmgcpu_rlc@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = RLC([HL])

dmgcpu_RR_A:
	ext	dmgcpu_rr@rm	; 	xcall.d	dmgcpu_rr			; %data = RR(A)	; 	RR_A		CYCLE_RR_A
	call.d	dmgcpu_rr@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RR(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	RR_r		CYCLE_RR_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	RR_r		CYCLE_RR_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	RR_r		CYCLE_RR_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	RR_r		CYCLE_RR_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	RR_r		CYCLE_RR_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	RR_r		CYCLE_RR_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rr@rm	; 	xcall	dmgcpu_rr			; %data = RR(r)
	call	dmgcpu_rr@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = RR(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RR_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RR_IHLI		CYCLE_RR_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_rr@rm	; 	xcall.d	dmgcpu_rr			; %data = RR([HL])
	call.d	dmgcpu_rr@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = RR([HL])

dmgcpu_RRC_A:
	ext	dmgcpu_rrc@rm	; 	xcall.d	dmgcpu_rrc			; %data = RRC(A)	; 	RRC_A		CYCLE_RRC_A
	call.d	dmgcpu_rrc@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = RRC(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	RRC_r		CYCLE_RRC_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	RRC_r		CYCLE_RRC_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	RRC_r		CYCLE_RRC_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	RRC_r		CYCLE_RRC_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	RRC_r		CYCLE_RRC_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	RRC_r		CYCLE_RRC_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_rrc@rm	; 	xcall	dmgcpu_rrc			; %data = RRC(r)
	call	dmgcpu_rrc@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = RRC(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RRC_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RRC_IHLI	CYCLE_RRC_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_rrc@rm	; 	xcall.d	dmgcpu_rrc			; %data = RRC([HL])
	call.d	dmgcpu_rrc@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = RRC([HL])

dmgcpu_SLA_A:
	ext	dmgcpu_sla@rm	; 	xcall.d	dmgcpu_sla			; %data = SLA(A)	; 	SLA_A		CYCLE_SLA_A
	call.d	dmgcpu_sla@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = SLA(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SLA_r		CYCLE_SLA_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SLA_r		CYCLE_SLA_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SLA_r		CYCLE_SLA_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SLA_r		CYCLE_SLA_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SLA_r		CYCLE_SLA_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SLA_r		CYCLE_SLA_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sla@rm	; 	xcall	dmgcpu_sla			; %data = SLA(r)
	call	dmgcpu_sla@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = SLA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SLA_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SLA_IHLI	CYCLE_SLA_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_sla@rm	; 	xcall.d	dmgcpu_sla			; %data = SLA([HL])
	call.d	dmgcpu_sla@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = SLA([HL])

dmgcpu_SRA_A:
	ext	dmgcpu_sra@rm	; 	xcall.d	dmgcpu_sra			; %data = SRA(A)	; 	SRA_A		CYCLE_SRA_A
	call.d	dmgcpu_sra@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = SRA(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SRA_r		CYCLE_SRA_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SRA_r		CYCLE_SRA_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SRA_r		CYCLE_SRA_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SRA_r		CYCLE_SRA_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SRA_r		CYCLE_SRA_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SRA_r		CYCLE_SRA_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_sra@rm	; 	xcall	dmgcpu_sra			; %data = SRA(r)
	call	dmgcpu_sra@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = SRA(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRA_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SRA_IHLI	CYCLE_SRA_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_sra@rm	; 	xcall.d	dmgcpu_sra			; %data = SRA([HL])
	call.d	dmgcpu_sra@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = SRA([HL])

dmgcpu_SRL_A:
	ext	dmgcpu_srl@rm	; 	xcall.d	dmgcpu_srl			; %data = SRL(A)	; 	SRL_A		CYCLE_SRL_A
	call.d	dmgcpu_srl@rl
	ld.w	%r1, %r5			; %data = A *delay*
	ld.w	%r5, %r1			; %A    = SRL(A)
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	SRL_r		CYCLE_SRL_B, B
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x5		; 	xld.b	[%r4+0x5], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	SRL_r		CYCLE_SRL_C, C
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x4		; 	xld.b	[%r4+0x4], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	SRL_r		CYCLE_SRL_D, D
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x7		; 	xld.b	[%r4+0x7], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	SRL_r		CYCLE_SRL_E, E
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x6		; 	xld.b	[%r4+0x6], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	SRL_r		CYCLE_SRL_H, H
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x9		; 	xld.b	[%r4+0x9], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	SRL_r		CYCLE_SRL_L, L
	ld.ub	%r1,[%r4]
	ext	dmgcpu_srl@rm	; 	xcall	dmgcpu_srl			; %data = SRL(r)
	call	dmgcpu_srl@rl
	ext	0x8		; 	xld.b	[%r4+0x8], %r1		; r     = SRL(r)
	ld.b	[%r4],%r1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SRL_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SRL_IHLI	CYCLE_SRL_IHLI
	ld.uh	%r0,[%r4]
	call	%r10				; %data = [HL]
	ext	dmgcpu_srl@rm	; 	xcall.d	dmgcpu_srl			; %data = SRL([HL])
	call.d	dmgcpu_srl@rl
	sub	%r7, 16			; *delay*
	jp	%r11				; [HL]  = SRL([HL])

;****************************************************************************
;	Bit Opcodes
;****************************************************************************

;#macro	BIT_b_A		$1, $2
;	ld.w	%data, %A			; %data = A
;	xld.w	%s0, $2				; %s0   = b
;	xjp.d	dmgcpu_bit			; BIT(A,b)
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	BIT_b_r		$1, $2, $3
;	xld.ub	%data, [%CPU+$3]		; %data = r
;	xld.w	%s0, $2				; %s0   = b
;	xjp.d	dmgcpu_bit			; BIT(r,b)
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	BIT_b_IHLI	$1, $2
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call.d	%READ				; %data = [HL]
;	xld.w	%s0, $2				; %s0   = b *delay*
;	xjp.d	dmgcpu_bit			; BIT([HL],b)
;	sub	%CYCLE, $1			; *delay*
;#endm

;
; Flags affected:
;	None.
;
;#macro	SET_b_A		$1, $2
;	xoor	%A, %A, (1<<$2)			; A[b] = 1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SET_b_r		$1, $2, $3
;	xbset	[%CPU+$3], $2			; r[b] = 1
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	SET_b_IHLI	$1, $2
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call.d	%READ				; %data = [HL]
;	sub	%CYCLE, $1			; *delay*
;	xoor	%data, %data, (1<<$2)		; %data = [HL]|(1<<b)
;	jp	%WRITE				; [HL]  = [HL]|(1<<b)
;#endm

;
; Flags affected:
;	None.
;
;#macro	RES_b_A		$1, $2
;	xand	%A, %A, ~(1<<$2)		; A[b] = 0
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RES_b_r		$1, $2, $3
;	xbclr	[%CPU+$3], $2			; r[b] = 0
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;#macro	RES_b_IHLI	$1, $2
;	xld.uh	%addr, [%CPU+HL]		; %addr = HL
;	call.d	%READ				; %data = [HL]
;	sub	%CYCLE, $1			; *delay*
;	xand	%data, %data, ~(1<<$2)		; %data = [HL]&~(1<<b)
;	jp	%WRITE				; [HL]  = [HL]&~(1<<b)
;#endm

;----------------------------------------------------------------------------

dmgcpu_BIT_0_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_0_A, 0
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_B, 0, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_C, 0, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_D, 0, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_E, 0, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_H, 0, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_0_L, 0, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_0_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_0_IHLI, 0
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x0		; 	xld.w	%r2, 0				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_1_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_1_A, 1
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_B, 1, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_C, 1, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_D, 1, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_E, 1, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_H, 1, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_1_L, 1, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_1_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_1_IHLI, 1
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x1		; 	xld.w	%r2, 1				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_2_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_2_A, 2
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_B, 2, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_C, 2, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_D, 2, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_E, 2, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_H, 2, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_2_L, 2, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_2_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_2_IHLI, 2
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x2		; 	xld.w	%r2, 2				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_3_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_3_A, 3
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_B, 3, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_C, 3, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_D, 3, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_E, 3, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_H, 3, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_3_L, 3, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_3_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_3_IHLI, 3
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x3		; 	xld.w	%r2, 3				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_4_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_4_A, 4
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_B, 4, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_C, 4, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_D, 4, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_E, 4, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_H, 4, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_4_L, 4, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_4_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_4_IHLI, 4
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x4		; 	xld.w	%r2, 4				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_5_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_5_A, 5
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_B, 5, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_C, 5, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_D, 5, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_E, 5, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_H, 5, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_5_L, 5, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_5_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_5_IHLI, 5
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x5		; 	xld.w	%r2, 5				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_6_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_6_A, 6
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_B, 6, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_C, 6, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_D, 6, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_E, 6, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_H, 6, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_6_L, 6, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_6_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_6_IHLI, 6
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x6		; 	xld.w	%r2, 6				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_BIT_7_A:
	ld.w	%r1, %r5			; %data = A	; 	BIT_b_A		CYCLE_BIT_7_A, 7
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(A,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_B:
	ext	0x5		; 	xld.ub	%r1, [%r4+0x5]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_B, 7, B
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_C:
	ext	0x4		; 	xld.ub	%r1, [%r4+0x4]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_C, 7, C
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_D:
	ext	0x7		; 	xld.ub	%r1, [%r4+0x7]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_D, 7, D
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_E:
	ext	0x6		; 	xld.ub	%r1, [%r4+0x6]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_E, 7, E
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_H:
	ext	0x9		; 	xld.ub	%r1, [%r4+0x9]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_H, 7, H
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_L:
	ext	0x8		; 	xld.ub	%r1, [%r4+0x8]		; %data = r	; 	BIT_b_r		CYCLE_BIT_7_L, 7, L
	ld.ub	%r1,[%r4]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT(r,b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 8			; *delay*
dmgcpu_BIT_7_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	BIT_b_IHLI	CYCLE_BIT_7_IHLI, 7
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	ld.w	%r2,0x7		; 	xld.w	%r2, 7				; %s0   = b *delay*
	ext	dmgcpu_bit@rm	; 	xjp.d	dmgcpu_bit			; BIT([HL],b)
	jp.d	dmgcpu_bit@rl
	sub	%r7, 12			; *delay*

dmgcpu_SET_0_A:
	or	%r5,0x1		; 	xoor	%r5, %r5, 0x1			; A[b] = 1	; 	SET_b_A		CYCLE_SET_0_A, 0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_B, 0, B
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_C, 0, C
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_D, 0, D
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_E, 0, E
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_H, 0, H
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x0			; r[b] = 1	; 	SET_b_r		CYCLE_SET_0_L, 0, L
	bset	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_0_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_0_IHLI, 0
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	or	%r1,0x1		; 	xoor	%r1, %r1, 0x1		; %data = [HL]|(1<<b)
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_1_A:
	or	%r5,0x2		; 	xoor	%r5, %r5, 0x2			; A[b] = 1	; 	SET_b_A		CYCLE_SET_1_A, 1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_B, 1, B
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_C, 1, C
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_D, 1, D
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_E, 1, E
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_H, 1, H
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x1			; r[b] = 1	; 	SET_b_r		CYCLE_SET_1_L, 1, L
	bset	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_1_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_1_IHLI, 1
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	or	%r1,0x2		; 	xoor	%r1, %r1, 0x2		; %data = [HL]|(1<<b)
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_2_A:
	or	%r5,0x4		; 	xoor	%r5, %r5, 0x4			; A[b] = 1	; 	SET_b_A		CYCLE_SET_2_A, 2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_B, 2, B
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_C, 2, C
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_D, 2, D
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_E, 2, E
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_H, 2, H
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x2			; r[b] = 1	; 	SET_b_r		CYCLE_SET_2_L, 2, L
	bset	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_2_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_2_IHLI, 2
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	or	%r1,0x4		; 	xoor	%r1, %r1, 0x4		; %data = [HL]|(1<<b)
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_3_A:
	or	%r5,0x8		; 	xoor	%r5, %r5, 0x8			; A[b] = 1	; 	SET_b_A		CYCLE_SET_3_A, 3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_B, 3, B
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_C, 3, C
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_D, 3, D
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_E, 3, E
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_H, 3, H
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x3			; r[b] = 1	; 	SET_b_r		CYCLE_SET_3_L, 3, L
	bset	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_3_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_3_IHLI, 3
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	or	%r1,0x8		; 	xoor	%r1, %r1, 0x8		; %data = [HL]|(1<<b)
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_4_A:
	or	%r5,0x10	; 	xoor	%r5, %r5, 0x10			; A[b] = 1	; 	SET_b_A		CYCLE_SET_4_A, 4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_B, 4, B
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_C, 4, C
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_D, 4, D
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_E, 4, E
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_H, 4, H
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x4			; r[b] = 1	; 	SET_b_r		CYCLE_SET_4_L, 4, L
	bset	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_4_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_4_IHLI, 4
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	or	%r1,0x10	; 	xoor	%r1, %r1, 0x10		; %data = [HL]|(1<<b)
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_5_A:
	ext	0x0		; 	xoor	%r5, %r5, 0x20			; A[b] = 1	; 	SET_b_A		CYCLE_SET_5_A, 5
	or	%r5,0x20
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_B, 5, B
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_C, 5, C
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_D, 5, D
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_E, 5, E
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_H, 5, H
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x5			; r[b] = 1	; 	SET_b_r		CYCLE_SET_5_L, 5, L
	bset	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_5_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_5_IHLI, 5
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x0		; 	xoor	%r1, %r1, 0x20		; %data = [HL]|(1<<b)
	or	%r1,0x20
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_6_A:
	ext	0x1		; 	xoor	%r5, %r5, 0x40			; A[b] = 1	; 	SET_b_A		CYCLE_SET_6_A, 6
	or	%r5,0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_B, 6, B
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_C, 6, C
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_D, 6, D
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_E, 6, E
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_H, 6, H
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x6			; r[b] = 1	; 	SET_b_r		CYCLE_SET_6_L, 6, L
	bset	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_6_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_6_IHLI, 6
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x1		; 	xoor	%r1, %r1, 0x40		; %data = [HL]|(1<<b)
	or	%r1,0x0
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_SET_7_A:
	ext	0x2		; 	xoor	%r5, %r5, 0x80			; A[b] = 1	; 	SET_b_A		CYCLE_SET_7_A, 7
	or	%r5,0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_B:
	ext	0x5		; 	xbset	[%r4+0x5], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_B, 7, B
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_C:
	ext	0x4		; 	xbset	[%r4+0x4], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_C, 7, C
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_D:
	ext	0x7		; 	xbset	[%r4+0x7], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_D, 7, D
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_E:
	ext	0x6		; 	xbset	[%r4+0x6], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_E, 7, E
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_H:
	ext	0x9		; 	xbset	[%r4+0x9], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_H, 7, H
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_L:
	ext	0x8		; 	xbset	[%r4+0x8], 0x7			; r[b] = 1	; 	SET_b_r		CYCLE_SET_7_L, 7, L
	bset	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_SET_7_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	SET_b_IHLI	CYCLE_SET_7_IHLI, 7
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x2		; 	xoor	%r1, %r1, 0x80		; %data = [HL]|(1<<b)
	or	%r1,0x0
	jp	%r11				; [HL]  = [HL]|(1<<b)

dmgcpu_RES_0_A:
	and	%r5,0x3e	; 	xand	%r5, %r5, -2		; A[b] = 0	; 	RES_b_A		CYCLE_RES_0_A, 0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_B, 0, B
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_C, 0, C
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_D, 0, D
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_E, 0, E
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_H, 0, H
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x0			; r[b] = 0	; 	RES_b_r		CYCLE_RES_0_L, 0, L
	bclr	[%r4],0x0
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_0_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_0_IHLI, 0
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	and	%r1,0x3e	; 	xand	%r1, %r1, -2		; %data = [HL]&~(1<<b)
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_1_A:
	and	%r5,0x3d	; 	xand	%r5, %r5, -3		; A[b] = 0	; 	RES_b_A		CYCLE_RES_1_A, 1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_B, 1, B
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_C, 1, C
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_D, 1, D
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_E, 1, E
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_H, 1, H
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x1			; r[b] = 0	; 	RES_b_r		CYCLE_RES_1_L, 1, L
	bclr	[%r4],0x1
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_1_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_1_IHLI, 1
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	and	%r1,0x3d	; 	xand	%r1, %r1, -3		; %data = [HL]&~(1<<b)
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_2_A:
	and	%r5,0x3b	; 	xand	%r5, %r5, -5		; A[b] = 0	; 	RES_b_A		CYCLE_RES_2_A, 2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_B, 2, B
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_C, 2, C
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_D, 2, D
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_E, 2, E
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_H, 2, H
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x2			; r[b] = 0	; 	RES_b_r		CYCLE_RES_2_L, 2, L
	bclr	[%r4],0x2
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_2_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_2_IHLI, 2
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	and	%r1,0x3b	; 	xand	%r1, %r1, -5		; %data = [HL]&~(1<<b)
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_3_A:
	and	%r5,0x37	; 	xand	%r5, %r5, -9		; A[b] = 0	; 	RES_b_A		CYCLE_RES_3_A, 3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_B, 3, B
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_C, 3, C
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_D, 3, D
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_E, 3, E
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_H, 3, H
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x3			; r[b] = 0	; 	RES_b_r		CYCLE_RES_3_L, 3, L
	bclr	[%r4],0x3
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_3_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_3_IHLI, 3
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	and	%r1,0x37	; 	xand	%r1, %r1, -9		; %data = [HL]&~(1<<b)
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_4_A:
	and	%r5,0x2f	; 	xand	%r5, %r5, -17		; A[b] = 0	; 	RES_b_A		CYCLE_RES_4_A, 4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_B, 4, B
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_C, 4, C
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_D, 4, D
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_E, 4, E
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_H, 4, H
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x4			; r[b] = 0	; 	RES_b_r		CYCLE_RES_4_L, 4, L
	bclr	[%r4],0x4
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_4_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_4_IHLI, 4
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	and	%r1,0x2f	; 	xand	%r1, %r1, -17		; %data = [HL]&~(1<<b)
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_5_A:
	ext	0x1fff		; 	xand	%r5, %r5, -33		; A[b] = 0	; 	RES_b_A		CYCLE_RES_5_A, 5
	and	%r5,0x1f
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_B, 5, B
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_C, 5, C
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_D, 5, D
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_E, 5, E
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_H, 5, H
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x5			; r[b] = 0	; 	RES_b_r		CYCLE_RES_5_L, 5, L
	bclr	[%r4],0x5
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_5_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_5_IHLI, 5
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x1fff		; 	xand	%r1, %r1, -33		; %data = [HL]&~(1<<b)
	and	%r1,0x1f
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_6_A:
	ext	0x1ffe		; 	xand	%r5, %r5, -65		; A[b] = 0	; 	RES_b_A		CYCLE_RES_6_A, 6
	and	%r5,0x3f
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_B, 6, B
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_C, 6, C
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_D, 6, D
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_E, 6, E
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_H, 6, H
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x6			; r[b] = 0	; 	RES_b_r		CYCLE_RES_6_L, 6, L
	bclr	[%r4],0x6
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_6_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_6_IHLI, 6
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x1ffe		; 	xand	%r1, %r1, -65		; %data = [HL]&~(1<<b)
	and	%r1,0x3f
	jp	%r11				; [HL]  = [HL]&~(1<<b)

dmgcpu_RES_7_A:
	ext	0x1ffd		; 	xand	%r5, %r5, -129		; A[b] = 0	; 	RES_b_A		CYCLE_RES_7_A, 7
	and	%r5,0x3f
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_B:
	ext	0x5		; 	xbclr	[%r4+0x5], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_B, 7, B
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_C:
	ext	0x4		; 	xbclr	[%r4+0x4], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_C, 7, C
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_D:
	ext	0x7		; 	xbclr	[%r4+0x7], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_D, 7, D
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_E:
	ext	0x6		; 	xbclr	[%r4+0x6], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_E, 7, E
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_H:
	ext	0x9		; 	xbclr	[%r4+0x9], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_H, 7, H
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_L:
	ext	0x8		; 	xbclr	[%r4+0x8], 0x7			; r[b] = 0	; 	RES_b_r		CYCLE_RES_7_L, 7, L
	bclr	[%r4],0x7
	ret.d
	sub	%r7, 8			; *delay*
dmgcpu_RES_7_IHLI:
	ext	0x8		; 	xld.uh	%r0, [%r4+0x8]		; %addr = HL	; 	RES_b_IHLI	CYCLE_RES_7_IHLI, 7
	ld.uh	%r0,[%r4]
	call.d	%r10				; %data = [HL]
	sub	%r7, 16			; *delay*
	ext	0x1ffd		; 	xand	%r1, %r1, -129		; %data = [HL]&~(1<<b)
	and	%r1,0x3f
	jp	%r11				; [HL]  = [HL]&~(1<<b)

;****************************************************************************
;	Jumps
;****************************************************************************

dmgcpu_JP_c_nn:
	sub	%r7, 0x4			; CYCLE -= (16-12)
	; FALLTHRU
dmgcpu_JP_nn:
	call.d	%r10				; %data = LO(nn)
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ld.w	%r6, %r1			; %PC   = LO(nn)
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data = HI(nn)<<8
	or	%r6, %r1			; %PC   = HI(nn)<<8|LO(nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_JP_Z_nn:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jreq	dmgcpu_JP_c_nn	; 	xjreq	dmgcpu_JP_c_nn			; if(z == 0) { CYCLE -= (16-12); JP_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_JP_NZ_nn:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jrne	dmgcpu_JP_c_nn	; 	xjrne	dmgcpu_JP_c_nn			; if(z != 0) { CYCLE -= (16-12); JP_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_JP_C_nn:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jrne	dmgcpu_JP_c_nn	; 	xjrne	dmgcpu_JP_c_nn			; if(CF == 1) { CYCLE -= (16-12); JP_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_JP_NC_nn:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jreq	dmgcpu_JP_c_nn	; 	xjreq	dmgcpu_JP_c_nn			; if(CF == 0) { CYCLE -= (16-12); JP_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_JP_IHLI:
	ext	0x8		; 	xld.uh	%r6, [%r4+0x8]			; %PC = HL
	ld.uh	%r6,[%r4]
	ret.d
	sub	%r7, 4		; *delay*

dmgcpu_JR_c_e:
	sub	%r7, 0x4			; CYCLE -= (12-8)
	; FALLTHRU
dmgcpu_JR_e:
	call.d	%r10				; %data = e (   0.. 255)
	ld.w	%r0, %r6			; %addr = PC *delay*
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; %PC   = PC+1
	ld.b	%r1, %r1			; %data = e (-128..+127)
	add	%r6, %r1			; %PC   = PC+1+e
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_JR_Z_e:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jreq	dmgcpu_JR_c_e	; 	xjreq	dmgcpu_JR_c_e			; if(z == 0) { CYCLE -= (12-8); JR_e; }
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; PC += 1 (skip e)
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_JR_NZ_e:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jrne	dmgcpu_JR_c_e	; 	xjrne	dmgcpu_JR_c_e			; if(z != 0) { CYCLE -= (12-8); JR_e; }
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; PC += 1 (skip e)
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_JR_C_e:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jrne	dmgcpu_JR_c_e	; 	xjrne	dmgcpu_JR_c_e			; if(CF == 1) { CYCLE -= (12-8); JR_e; }
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; PC += 1 (skip e)
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_JR_NC_e:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jreq	dmgcpu_JR_c_e	; 	xjreq	dmgcpu_JR_c_e			; if(CF == 0) { CYCLE -= (12-8); JR_e; }
	add	%r6,0x1		; 	xadd	%r6, %r6, 1			; PC += 1 (skip e)
	ret.d
	sub	%r7, 8		; *delay*

;****************************************************************************
;	Calls
;****************************************************************************

dmgcpu_CALL_c_nn:
	sub	%r7, 0xc			; CYCLE -= (24-12)
	; FALLTHRU
dmgcpu_CALL_nn:
	ld.w	%r1, %r6			; %data = PC
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC+2)
	call.d	dmgcpu_push@rl
	add	%r1, 2			; %data = PC+2 *delay*
	call.d	%r10				; %data = LO(nn)
	ld.w	%r0, %r6			; %addr = PC   *delay*
	ld.w	%r6, %r1			; %PC   = LO(nn)
	call.d	%r10				; %data = HI(nn)
	add	%r0, 1			; %addr = PC+1 *delay*
	sll	%r1,0x8		; 	xsll	%r1, 8			; %data = HI(nn)<<8
	or	%r6, %r1			; %PC   = HI(nn)<<8|LO(nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_CALL_Z_nn:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jreq	dmgcpu_CALL_c_nn	; 	xjreq	dmgcpu_CALL_c_nn		; if(z == 0) { CYCLE -= (24-12); CALL_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_CALL_NZ_nn:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jrne	dmgcpu_CALL_c_nn	; 	xjrne	dmgcpu_CALL_c_nn		; if(z != 0) { CYCLE -= (24-12); CALL_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12	; *delay*

dmgcpu_CALL_C_nn:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jrne	dmgcpu_CALL_c_nn	; 	xjrne	dmgcpu_CALL_c_nn		; if(CF == 1) { CYCLE -= (24-12); CALL_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12		; *delay*

dmgcpu_CALL_NC_nn:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jreq	dmgcpu_CALL_c_nn	; 	xjreq	dmgcpu_CALL_c_nn		; if(CF == 0) { CYCLE -= (24-12); CALL_nn; }
	add	%r6,0x2		; 	xadd	%r6, %r6, 2			; PC += 2 (skip nn)
	ret.d
	sub	%r7, 12	; *delay*

;****************************************************************************
;	Restarts
;****************************************************************************

;#macro	RST_n		$1, $2
;	xcall.d	dmgcpu_push			; PUSH(PC)
;	ld.w	%data, %PC			; %data = PC *delay*
;	xld.w	%PC, $2				; %PC   = n
;	ret.d
;	sub	%CYCLE, $1			; *delay*
;#endm

;----------------------------------------------------------------------------

dmgcpu_RST_00H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_00H, 0x00
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ld.w	%r6,0x0		; 	xld.w	%r6, 0x00				; %PC   = n
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_08H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_08H, 0x08
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ld.w	%r6,0x8		; 	xld.w	%r6, 0x08				; %PC   = n
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_10H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_10H, 0x10
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ld.w	%r6,0x10	; 	xld.w	%r6, 0x10				; %PC   = n
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_18H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_18H, 0x18
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ld.w	%r6,0x18	; 	xld.w	%r6, 0x18				; %PC   = n
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_20H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_20H, 0x20
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ext	0x0		; 	xld.w	%r6, 0x20				; %PC   = n
	ld.w	%r6,0x20
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_28H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_28H, 0x28
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ext	0x0		; 	xld.w	%r6, 0x28				; %PC   = n
	ld.w	%r6,0x28
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_30H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_30H, 0x30
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ext	0x0		; 	xld.w	%r6, 0x30				; %PC   = n
	ld.w	%r6,0x30
	ret.d
	sub	%r7, 16			; *delay*
dmgcpu_RST_38H:
	ext	dmgcpu_push@rm	; 	xcall.d	dmgcpu_push			; PUSH(PC)	; 	RST_n		CYCLE_RST_38H, 0x38
	call.d	dmgcpu_push@rl
	ld.w	%r1, %r6			; %data = PC *delay*
	ext	0x0		; 	xld.w	%r6, 0x38				; %PC   = n
	ld.w	%r6,0x38
	ret.d
	sub	%r7, 16			; *delay*

;****************************************************************************
;	Returns
;****************************************************************************

dmgcpu_RET_c:
	sub	%r7, 0xc			; CYCLE -= (20-8)
	; FALLTHRU
dmgcpu_RET:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()
	call	dmgcpu_pop@rl
	ld.w	%r6, %r1			; %PC   = PC
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_RET_Z:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jreq	dmgcpu_RET_c	; 	xjreq	dmgcpu_RET_c			; if(z == 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_RET_NZ:
	ld.ub	%r12,[%r4]	; 	xld.ub	%r12, [%r4+0x0]		; %t0 = zzzzzzzz
	or	%r12, %r12			; test  zzzzzzzz
	jrne	dmgcpu_RET_c	; 	xjrne	dmgcpu_RET_c			; if(z != 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_RET_C:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jrne	dmgcpu_RET_c	; 	xjrne	dmgcpu_RET_c			; if(CF == 1) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_RET_NC:
	ext	0x1		; 	xbtst	[%r4+0x1], 0x0			; test CF
	btst	[%r4],0x0
	jreq	dmgcpu_RET_c	; 	xjreq	dmgcpu_RET_c			; if(CF == 0) { CYCLE -= (20-8); RET; }
	ret.d
	sub	%r7, 8		; *delay*

dmgcpu_RETI:
	ext	dmgcpu_pop@rm	; 	xcall	dmgcpu_pop			; %data = POP()
	call	dmgcpu_pop@rl
	ld.w	%r6, %r1			; %PC   = PC
	ext	0xe		; 	xbset	[%r4+0xe], 0x0		; IME = 1
	bset	[%r4],0x0
	ext	dmgcpu_CHECK_PENDING@rm	; 	xjp.d	dmgcpu_CHECK_PENDING		; ۗĂ荞݂΁As܂B
	jp.d	dmgcpu_CHECK_PENDING@rl
	sub	%r7, 8		; *delay*

;****************************************************************************
;
;****************************************************************************

	.code
	.align	2

	.global dmgcpu_XXops
dmgcpu_XXops:
	.word	dmgcpu_NOP		;00
	.word	dmgcpu_LD_BC_nn		;01
	.word	dmgcpu_LD_IBCI_A	;02
	.word	dmgcpu_INC_BC		;03
	.word	dmgcpu_INC_B		;04
	.word	dmgcpu_DEC_B		;05
	.word	dmgcpu_LD_B_n		;06
	.word	dmgcpu_RLCA		;07
	.word	dmgcpu_LD_InnI_SP	;08
	.word	dmgcpu_ADD_HL_BC	;09
	.word	dmgcpu_LD_A_IBCI	;0A
	.word	dmgcpu_DEC_BC		;0B
	.word	dmgcpu_INC_C		;0C
	.word	dmgcpu_DEC_C		;0D
	.word	dmgcpu_LD_C_n		;0E
	.word	dmgcpu_RRCA		;0F
	.word	dmgcpu_STOP		;10
	.word	dmgcpu_LD_DE_nn		;11
	.word	dmgcpu_LD_IDEI_A	;12
	.word	dmgcpu_INC_DE		;13
	.word	dmgcpu_INC_D		;14
	.word	dmgcpu_DEC_D		;15
	.word	dmgcpu_LD_D_n		;16
	.word	dmgcpu_RLA		;17
	.word	dmgcpu_JR_e		;18
	.word	dmgcpu_ADD_HL_DE	;19
	.word	dmgcpu_LD_A_IDEI	;1A
	.word	dmgcpu_DEC_DE		;1B
	.word	dmgcpu_INC_E		;1C
	.word	dmgcpu_DEC_E		;1D
	.word	dmgcpu_LD_E_n		;1E
	.word	dmgcpu_RRA		;1F
	.word	dmgcpu_JR_NZ_e		;20
	.word	dmgcpu_LD_HL_nn		;21
	.word	dmgcpu_LDI_IHLI_A	;22
	.word	dmgcpu_INC_HL		;23
	.word	dmgcpu_INC_H		;24
	.word	dmgcpu_DEC_H		;25
	.word	dmgcpu_LD_H_n		;26
	.word	dmgcpu_DAA		;27
	.word	dmgcpu_JR_Z_e		;28
	.word	dmgcpu_ADD_HL_HL	;29
	.word	dmgcpu_LDI_A_IHLI	;2A
	.word	dmgcpu_DEC_HL		;2B
	.word	dmgcpu_INC_L		;2C
	.word	dmgcpu_DEC_L		;2D
	.word	dmgcpu_LD_L_n		;2E
	.word	dmgcpu_CPL		;2F
	.word	dmgcpu_JR_NC_e		;30
	.word	dmgcpu_LD_SP_nn		;31
	.word	dmgcpu_LDD_IHLI_A	;32
	.word	dmgcpu_INC_SP		;33
	.word	dmgcpu_INC_IHLI		;34
	.word	dmgcpu_DEC_IHLI		;35
	.word	dmgcpu_LD_IHLI_n	;36
	.word	dmgcpu_SCF		;37
	.word	dmgcpu_JR_C_e		;38
	.word	dmgcpu_ADD_HL_SP	;39
	.word	dmgcpu_LDD_A_IHLI	;3A
	.word	dmgcpu_DEC_SP		;3B
	.word	dmgcpu_INC_A		;3C
	.word	dmgcpu_DEC_A		;3D
	.word	dmgcpu_LD_A_n		;3E
	.word	dmgcpu_CCF		;3F
	.word	dmgcpu_LD_B_B		;40
	.word	dmgcpu_LD_B_C		;41
	.word	dmgcpu_LD_B_D		;42
	.word	dmgcpu_LD_B_E		;43
	.word	dmgcpu_LD_B_H		;44
	.word	dmgcpu_LD_B_L		;45
	.word	dmgcpu_LD_B_IHLI	;46
	.word	dmgcpu_LD_B_A		;47
	.word	dmgcpu_LD_C_B		;48
	.word	dmgcpu_LD_C_C		;49
	.word	dmgcpu_LD_C_D		;4A
	.word	dmgcpu_LD_C_E		;4B
	.word	dmgcpu_LD_C_H		;4C
	.word	dmgcpu_LD_C_L		;4D
	.word	dmgcpu_LD_C_IHLI	;4E
	.word	dmgcpu_LD_C_A		;4F
	.word	dmgcpu_LD_D_B		;50
	.word	dmgcpu_LD_D_C		;51
	.word	dmgcpu_LD_D_D		;52
	.word	dmgcpu_LD_D_E		;53
	.word	dmgcpu_LD_D_H		;54
	.word	dmgcpu_LD_D_L		;55
	.word	dmgcpu_LD_D_IHLI	;56
	.word	dmgcpu_LD_D_A		;57
	.word	dmgcpu_LD_E_B		;58
	.word	dmgcpu_LD_E_C		;59
	.word	dmgcpu_LD_E_D		;5A
	.word	dmgcpu_LD_E_E		;5B
	.word	dmgcpu_LD_E_H		;5C
	.word	dmgcpu_LD_E_L		;5D
	.word	dmgcpu_LD_E_IHLI	;5E
	.word	dmgcpu_LD_E_A		;5F
	.word	dmgcpu_LD_H_B		;60
	.word	dmgcpu_LD_H_C		;61
	.word	dmgcpu_LD_H_D		;62
	.word	dmgcpu_LD_H_E		;63
	.word	dmgcpu_LD_H_H		;64
	.word	dmgcpu_LD_H_L		;65
	.word	dmgcpu_LD_H_IHLI	;66
	.word	dmgcpu_LD_H_A		;67
	.word	dmgcpu_LD_L_B		;68
	.word	dmgcpu_LD_L_C		;69
	.word	dmgcpu_LD_L_D		;6A
	.word	dmgcpu_LD_L_E		;6B
	.word	dmgcpu_LD_L_H		;6C
	.word	dmgcpu_LD_L_L		;6D
	.word	dmgcpu_LD_L_IHLI	;6E
	.word	dmgcpu_LD_L_A		;6F
	.word	dmgcpu_LD_IHLI_B	;70
	.word	dmgcpu_LD_IHLI_C	;71
	.word	dmgcpu_LD_IHLI_D	;72
	.word	dmgcpu_LD_IHLI_E	;73
	.word	dmgcpu_LD_IHLI_H	;74
	.word	dmgcpu_LD_IHLI_L	;75
	.word	dmgcpu_HALT		;76
	.word	dmgcpu_LD_IHLI_A	;77
	.word	dmgcpu_LD_A_B		;78
	.word	dmgcpu_LD_A_C		;79
	.word	dmgcpu_LD_A_D		;7A
	.word	dmgcpu_LD_A_E		;7B
	.word	dmgcpu_LD_A_H		;7C
	.word	dmgcpu_LD_A_L		;7D
	.word	dmgcpu_LD_A_IHLI	;7E
	.word	dmgcpu_LD_A_A		;7F
	.word	dmgcpu_ADD_A_B		;80
	.word	dmgcpu_ADD_A_C		;81
	.word	dmgcpu_ADD_A_D		;82
	.word	dmgcpu_ADD_A_E		;83
	.word	dmgcpu_ADD_A_H		;84
	.word	dmgcpu_ADD_A_L		;85
	.word	dmgcpu_ADD_A_IHLI	;86
	.word	dmgcpu_ADD_A_A		;87
	.word	dmgcpu_ADC_A_B		;88
	.word	dmgcpu_ADC_A_C		;89
	.word	dmgcpu_ADC_A_D		;8A
	.word	dmgcpu_ADC_A_E		;8B
	.word	dmgcpu_ADC_A_H		;8C
	.word	dmgcpu_ADC_A_L		;8D
	.word	dmgcpu_ADC_A_IHLI	;8E
	.word	dmgcpu_ADC_A_A		;8F
	.word	dmgcpu_SUB_B		;90
	.word	dmgcpu_SUB_C		;91
	.word	dmgcpu_SUB_D		;92
	.word	dmgcpu_SUB_E		;93
	.word	dmgcpu_SUB_H		;94
	.word	dmgcpu_SUB_L		;95
	.word	dmgcpu_SUB_IHLI		;96
	.word	dmgcpu_SUB_A		;97
	.word	dmgcpu_SBC_A_B		;98
	.word	dmgcpu_SBC_A_C		;99
	.word	dmgcpu_SBC_A_D		;9A
	.word	dmgcpu_SBC_A_E		;9B
	.word	dmgcpu_SBC_A_H		;9C
	.word	dmgcpu_SBC_A_L		;9D
	.word	dmgcpu_SBC_A_IHLI	;9E
	.word	dmgcpu_SBC_A_A		;9F
	.word	dmgcpu_AND_B		;A0
	.word	dmgcpu_AND_C		;A1
	.word	dmgcpu_AND_D		;A2
	.word	dmgcpu_AND_E		;A3
	.word	dmgcpu_AND_H		;A4
	.word	dmgcpu_AND_L		;A5
	.word	dmgcpu_AND_IHLI		;A6
	.word	dmgcpu_AND_A		;A7
	.word	dmgcpu_XOR_B		;A8
	.word	dmgcpu_XOR_C		;A9
	.word	dmgcpu_XOR_D		;AA
	.word	dmgcpu_XOR_E		;AB
	.word	dmgcpu_XOR_H		;AC
	.word	dmgcpu_XOR_L		;AD
	.word	dmgcpu_XOR_IHLI		;AE
	.word	dmgcpu_XOR_A		;AF
	.word	dmgcpu_OR_B		;B0
	.word	dmgcpu_OR_C		;B1
	.word	dmgcpu_OR_D		;B2
	.word	dmgcpu_OR_E		;B3
	.word	dmgcpu_OR_H		;B4
	.word	dmgcpu_OR_L		;B5
	.word	dmgcpu_OR_IHLI		;B6
	.word	dmgcpu_OR_A		;B7
	.word	dmgcpu_CP_B		;B8
	.word	dmgcpu_CP_C		;B9
	.word	dmgcpu_CP_D		;BA
	.word	dmgcpu_CP_E		;BB
	.word	dmgcpu_CP_H		;BC
	.word	dmgcpu_CP_L		;BD
	.word	dmgcpu_CP_IHLI		;BE
	.word	dmgcpu_CP_A		;BF
	.word	dmgcpu_RET_NZ		;C0
	.word	dmgcpu_POP_BC		;C1
	.word	dmgcpu_JP_NZ_nn		;C2
	.word	dmgcpu_JP_nn		;C3
	.word	dmgcpu_CALL_NZ_nn	;C4
	.word	dmgcpu_PUSH_BC		;C5
	.word	dmgcpu_ADD_A_n		;C6
	.word	dmgcpu_RST_00H		;C7
	.word	dmgcpu_RET_Z		;C8
	.word	dmgcpu_RET		;C9
	.word	dmgcpu_JP_Z_nn		;CA
	.word	dmgcpu_CB		;CB
	.word	dmgcpu_CALL_Z_nn	;CC
	.word	dmgcpu_CALL_nn		;CD
	.word	dmgcpu_ADC_A_n		;CE
	.word	dmgcpu_RST_08H		;CF
	.word	dmgcpu_RET_NC		;D0
	.word	dmgcpu_POP_DE		;D1
	.word	dmgcpu_JP_NC_nn		;D2
	.word	dmgcpu_ERR		;D3
	.word	dmgcpu_CALL_NC_nn	;D4
	.word	dmgcpu_PUSH_DE		;D5
	.word	dmgcpu_SUB_n		;D6
	.word	dmgcpu_RST_10H		;D7
	.word	dmgcpu_RET_C		;D8
	.word	dmgcpu_RETI		;D9
	.word	dmgcpu_JP_C_nn		;DA
	.word	dmgcpu_ERR		;DB
	.word	dmgcpu_CALL_C_nn	;DC
	.word	dmgcpu_ERR		;DD
	.word	dmgcpu_SBC_A_n		;DE
	.word	dmgcpu_RST_18H		;DF
	.word	dmgcpu_LDH_InI_A	;E0
	.word	dmgcpu_POP_HL		;E1
	.word	dmgcpu_LD_ICI_A		;E2
	.word	dmgcpu_ERR		;E3
	.word	dmgcpu_ERR		;E4
	.word	dmgcpu_PUSH_HL		;E5
	.word	dmgcpu_AND_n		;E6
	.word	dmgcpu_RST_20H		;E7
	.word	dmgcpu_ADD_SP_e		;E8
	.word	dmgcpu_JP_IHLI		;E9
	.word	dmgcpu_LD_InnI_A	;EA
	.word	dmgcpu_ERR		;EB
	.word	dmgcpu_ERR		;EC
	.word	dmgcpu_ERR		;ED
	.word	dmgcpu_XOR_n		;EE
	.word	dmgcpu_RST_28H		;EF
	.word	dmgcpu_LDH_A_InI	;F0
	.word	dmgcpu_POP_AF		;F1
	.word	dmgcpu_LD_A_ICI		;F2
	.word	dmgcpu_DI		;F3
	.word	dmgcpu_ERR		;F4
	.word	dmgcpu_PUSH_AF		;F5
	.word	dmgcpu_OR_n		;F6
	.word	dmgcpu_RST_30H		;F7
	.word	dmgcpu_LDHL_SP_e	;F8
	.word	dmgcpu_LD_SP_HL		;F9
	.word	dmgcpu_LD_A_InnI	;FA
	.word	dmgcpu_EI		;FB
	.word	dmgcpu_ERR		;FC
	.word	dmgcpu_ERR		;FD
	.word	dmgcpu_CP_n		;FE
	.word	dmgcpu_RST_38H		;FF

	.global dmgcpu_CBops
dmgcpu_CBops:
	.word	dmgcpu_RLC_B		;00
	.word	dmgcpu_RLC_C		;01
	.word	dmgcpu_RLC_D		;02
	.word	dmgcpu_RLC_E		;03
	.word	dmgcpu_RLC_H		;04
	.word	dmgcpu_RLC_L		;05
	.word	dmgcpu_RLC_IHLI		;06
	.word	dmgcpu_RLC_A		;07
	.word	dmgcpu_RRC_B		;08
	.word	dmgcpu_RRC_C		;09
	.word	dmgcpu_RRC_D		;0A
	.word	dmgcpu_RRC_E		;0B
	.word	dmgcpu_RRC_H		;0C
	.word	dmgcpu_RRC_L		;0D
	.word	dmgcpu_RRC_IHLI		;0E
	.word	dmgcpu_RRC_A		;0F
	.word	dmgcpu_RL_B		;10
	.word	dmgcpu_RL_C		;11
	.word	dmgcpu_RL_D		;12
	.word	dmgcpu_RL_E		;13
	.word	dmgcpu_RL_H		;14
	.word	dmgcpu_RL_L		;15
	.word	dmgcpu_RL_IHLI		;16
	.word	dmgcpu_RL_A		;17
	.word	dmgcpu_RR_B		;18
	.word	dmgcpu_RR_C		;19
	.word	dmgcpu_RR_D		;1A
	.word	dmgcpu_RR_E		;1B
	.word	dmgcpu_RR_H		;1C
	.word	dmgcpu_RR_L		;1D
	.word	dmgcpu_RR_IHLI		;1E
	.word	dmgcpu_RR_A		;1F
	.word	dmgcpu_SLA_B		;20
	.word	dmgcpu_SLA_C		;21
	.word	dmgcpu_SLA_D		;22
	.word	dmgcpu_SLA_E		;23
	.word	dmgcpu_SLA_H		;24
	.word	dmgcpu_SLA_L		;25
	.word	dmgcpu_SLA_IHLI		;26
	.word	dmgcpu_SLA_A		;27
	.word	dmgcpu_SRA_B		;28
	.word	dmgcpu_SRA_C		;29
	.word	dmgcpu_SRA_D		;2A
	.word	dmgcpu_SRA_E		;2B
	.word	dmgcpu_SRA_H		;2C
	.word	dmgcpu_SRA_L		;2D
	.word	dmgcpu_SRA_IHLI		;2E
	.word	dmgcpu_SRA_A		;2F
	.word	dmgcpu_SWAP_B		;30
	.word	dmgcpu_SWAP_C		;31
	.word	dmgcpu_SWAP_D		;32
	.word	dmgcpu_SWAP_E		;33
	.word	dmgcpu_SWAP_H		;34
	.word	dmgcpu_SWAP_L		;35
	.word	dmgcpu_SWAP_IHLI	;36
	.word	dmgcpu_SWAP_A		;37
	.word	dmgcpu_SRL_B		;38
	.word	dmgcpu_SRL_C		;39
	.word	dmgcpu_SRL_D		;3A
	.word	dmgcpu_SRL_E		;3B
	.word	dmgcpu_SRL_H		;3C
	.word	dmgcpu_SRL_L		;3D
	.word	dmgcpu_SRL_IHLI		;3E
	.word	dmgcpu_SRL_A		;3F
	.word	dmgcpu_BIT_0_B		;40
	.word	dmgcpu_BIT_0_C		;41
	.word	dmgcpu_BIT_0_D		;42
	.word	dmgcpu_BIT_0_E		;43
	.word	dmgcpu_BIT_0_H		;44
	.word	dmgcpu_BIT_0_L		;45
	.word	dmgcpu_BIT_0_IHLI	;46
	.word	dmgcpu_BIT_0_A		;47
	.word	dmgcpu_BIT_1_B		;48
	.word	dmgcpu_BIT_1_C		;49
	.word	dmgcpu_BIT_1_D		;4A
	.word	dmgcpu_BIT_1_E		;4B
	.word	dmgcpu_BIT_1_H		;4C
	.word	dmgcpu_BIT_1_L		;4D
	.word	dmgcpu_BIT_1_IHLI	;4E
	.word	dmgcpu_BIT_1_A		;4F
	.word	dmgcpu_BIT_2_B		;50
	.word	dmgcpu_BIT_2_C		;51
	.word	dmgcpu_BIT_2_D		;52
	.word	dmgcpu_BIT_2_E		;53
	.word	dmgcpu_BIT_2_H		;54
	.word	dmgcpu_BIT_2_L		;55
	.word	dmgcpu_BIT_2_IHLI	;56
	.word	dmgcpu_BIT_2_A		;57
	.word	dmgcpu_BIT_3_B		;58
	.word	dmgcpu_BIT_3_C		;59
	.word	dmgcpu_BIT_3_D		;5A
	.word	dmgcpu_BIT_3_E		;5B
	.word	dmgcpu_BIT_3_H		;5C
	.word	dmgcpu_BIT_3_L		;5D
	.word	dmgcpu_BIT_3_IHLI	;5E
	.word	dmgcpu_BIT_3_A		;5F
	.word	dmgcpu_BIT_4_B		;60
	.word	dmgcpu_BIT_4_C		;61
	.word	dmgcpu_BIT_4_D		;62
	.word	dmgcpu_BIT_4_E		;63
	.word	dmgcpu_BIT_4_H		;64
	.word	dmgcpu_BIT_4_L		;65
	.word	dmgcpu_BIT_4_IHLI	;66
	.word	dmgcpu_BIT_4_A		;67
	.word	dmgcpu_BIT_5_B		;68
	.word	dmgcpu_BIT_5_C		;69
	.word	dmgcpu_BIT_5_D		;6A
	.word	dmgcpu_BIT_5_E		;6B
	.word	dmgcpu_BIT_5_H		;6C
	.word	dmgcpu_BIT_5_L		;6D
	.word	dmgcpu_BIT_5_IHLI	;6E
	.word	dmgcpu_BIT_5_A		;6F
	.word	dmgcpu_BIT_6_B		;70
	.word	dmgcpu_BIT_6_C		;71
	.word	dmgcpu_BIT_6_D		;72
	.word	dmgcpu_BIT_6_E		;73
	.word	dmgcpu_BIT_6_H		;74
	.word	dmgcpu_BIT_6_L		;75
	.word	dmgcpu_BIT_6_IHLI	;76
	.word	dmgcpu_BIT_6_A		;77
	.word	dmgcpu_BIT_7_B		;78
	.word	dmgcpu_BIT_7_C		;79
	.word	dmgcpu_BIT_7_D		;7A
	.word	dmgcpu_BIT_7_E		;7B
	.word	dmgcpu_BIT_7_H		;7C
	.word	dmgcpu_BIT_7_L		;7D
	.word	dmgcpu_BIT_7_IHLI	;7E
	.word	dmgcpu_BIT_7_A		;7F
	.word	dmgcpu_RES_0_B		;80
	.word	dmgcpu_RES_0_C		;81
	.word	dmgcpu_RES_0_D		;82
	.word	dmgcpu_RES_0_E		;83
	.word	dmgcpu_RES_0_H		;84
	.word	dmgcpu_RES_0_L		;85
	.word	dmgcpu_RES_0_IHLI	;86
	.word	dmgcpu_RES_0_A		;87
	.word	dmgcpu_RES_1_B		;88
	.word	dmgcpu_RES_1_C		;89
	.word	dmgcpu_RES_1_D		;8A
	.word	dmgcpu_RES_1_E		;8B
	.word	dmgcpu_RES_1_H		;8C
	.word	dmgcpu_RES_1_L		;8D
	.word	dmgcpu_RES_1_IHLI	;8E
	.word	dmgcpu_RES_1_A		;8F
	.word	dmgcpu_RES_2_B		;90
	.word	dmgcpu_RES_2_C		;91
	.word	dmgcpu_RES_2_D		;92
	.word	dmgcpu_RES_2_E		;93
	.word	dmgcpu_RES_2_H		;94
	.word	dmgcpu_RES_2_L		;95
	.word	dmgcpu_RES_2_IHLI	;96
	.word	dmgcpu_RES_2_A		;97
	.word	dmgcpu_RES_3_B		;98
	.word	dmgcpu_RES_3_C		;99
	.word	dmgcpu_RES_3_D		;9A
	.word	dmgcpu_RES_3_E		;9B
	.word	dmgcpu_RES_3_H		;9C
	.word	dmgcpu_RES_3_L		;9D
	.word	dmgcpu_RES_3_IHLI	;9E
	.word	dmgcpu_RES_3_A		;9F
	.word	dmgcpu_RES_4_B		;A0
	.word	dmgcpu_RES_4_C		;A1
	.word	dmgcpu_RES_4_D		;A2
	.word	dmgcpu_RES_4_E		;A3
	.word	dmgcpu_RES_4_H		;A4
	.word	dmgcpu_RES_4_L		;A5
	.word	dmgcpu_RES_4_IHLI	;A6
	.word	dmgcpu_RES_4_A		;A7
	.word	dmgcpu_RES_5_B		;A8
	.word	dmgcpu_RES_5_C		;A9
	.word	dmgcpu_RES_5_D		;AA
	.word	dmgcpu_RES_5_E		;AB
	.word	dmgcpu_RES_5_H		;AC
	.word	dmgcpu_RES_5_L		;AD
	.word	dmgcpu_RES_5_IHLI	;AE
	.word	dmgcpu_RES_5_A		;AF
	.word	dmgcpu_RES_6_B		;B0
	.word	dmgcpu_RES_6_C		;B1
	.word	dmgcpu_RES_6_D		;B2
	.word	dmgcpu_RES_6_E		;B3
	.word	dmgcpu_RES_6_H		;B4
	.word	dmgcpu_RES_6_L		;B5
	.word	dmgcpu_RES_6_IHLI	;B6
	.word	dmgcpu_RES_6_A		;B7
	.word	dmgcpu_RES_7_B		;B8
	.word	dmgcpu_RES_7_C		;B9
	.word	dmgcpu_RES_7_D		;BA
	.word	dmgcpu_RES_7_E		;BB
	.word	dmgcpu_RES_7_H		;BC
	.word	dmgcpu_RES_7_L		;BD
	.word	dmgcpu_RES_7_IHLI	;BE
	.word	dmgcpu_RES_7_A		;BF
	.word	dmgcpu_SET_0_B		;C0
	.word	dmgcpu_SET_0_C		;C1
	.word	dmgcpu_SET_0_D		;C2
	.word	dmgcpu_SET_0_E		;C3
	.word	dmgcpu_SET_0_H		;C4
	.word	dmgcpu_SET_0_L		;C5
	.word	dmgcpu_SET_0_IHLI	;C6
	.word	dmgcpu_SET_0_A		;C7
	.word	dmgcpu_SET_1_B		;C8
	.word	dmgcpu_SET_1_C		;C9
	.word	dmgcpu_SET_1_D		;CA
	.word	dmgcpu_SET_1_E		;CB
	.word	dmgcpu_SET_1_H		;CC
	.word	dmgcpu_SET_1_L		;CD
	.word	dmgcpu_SET_1_IHLI	;CE
	.word	dmgcpu_SET_1_A		;CF
	.word	dmgcpu_SET_2_B		;D0
	.word	dmgcpu_SET_2_C		;D1
	.word	dmgcpu_SET_2_D		;D2
	.word	dmgcpu_SET_2_E		;D3
	.word	dmgcpu_SET_2_H		;D4
	.word	dmgcpu_SET_2_L		;D5
	.word	dmgcpu_SET_2_IHLI	;D6
	.word	dmgcpu_SET_2_A		;D7
	.word	dmgcpu_SET_3_B		;D8
	.word	dmgcpu_SET_3_C		;D9
	.word	dmgcpu_SET_3_D		;DA
	.word	dmgcpu_SET_3_E		;DB
	.word	dmgcpu_SET_3_H		;DC
	.word	dmgcpu_SET_3_L		;DD
	.word	dmgcpu_SET_3_IHLI	;DE
	.word	dmgcpu_SET_3_A		;DF
	.word	dmgcpu_SET_4_B		;E0
	.word	dmgcpu_SET_4_C		;E1
	.word	dmgcpu_SET_4_D		;E2
	.word	dmgcpu_SET_4_E		;E3
	.word	dmgcpu_SET_4_H		;E4
	.word	dmgcpu_SET_4_L		;E5
	.word	dmgcpu_SET_4_IHLI	;E6
	.word	dmgcpu_SET_4_A		;E7
	.word	dmgcpu_SET_5_B		;E8
	.word	dmgcpu_SET_5_C		;E9
	.word	dmgcpu_SET_5_D		;EA
	.word	dmgcpu_SET_5_E		;EB
	.word	dmgcpu_SET_5_H		;EC
	.word	dmgcpu_SET_5_L		;ED
	.word	dmgcpu_SET_5_IHLI	;EE
	.word	dmgcpu_SET_5_A		;EF
	.word	dmgcpu_SET_6_B		;F0
	.word	dmgcpu_SET_6_C		;F1
	.word	dmgcpu_SET_6_D		;F2
	.word	dmgcpu_SET_6_E		;F3
	.word	dmgcpu_SET_6_H		;F4
	.word	dmgcpu_SET_6_L		;F5
	.word	dmgcpu_SET_6_IHLI	;F6
	.word	dmgcpu_SET_6_A		;F7
	.word	dmgcpu_SET_7_B		;F8
	.word	dmgcpu_SET_7_C		;F9
	.word	dmgcpu_SET_7_D		;FA
	.word	dmgcpu_SET_7_E		;FB
	.word	dmgcpu_SET_7_H		;FC
	.word	dmgcpu_SET_7_L		;FD
	.word	dmgcpu_SET_7_IHLI	;FE
	.word	dmgcpu_SET_7_A		;FF

;****************************************************************************
;
;****************************************************************************

