/*	
 *	clipc16.h
 *
 *	P/ECE CP1610 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun May 15 21:34:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_C16_H__
#define __CLIP_C16_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/* --------------
 * CP1610ɂ
 * --------------
 *
 * * "The CP1610 is a compatible member of the Series 1600 Microprocessor products family."
 *   [General Instrument CP1610f[^V[g]
 * - CP1610́AGeneral InstrumentЂ1600}CNvZbTt@~ɑiłB
 *
 * * "The processor is a CP1610 (CP1600 with a low clock rate (read: cheaper!)) running at 894.886 Khz."
 *   [uBlueTechṽTCǵuIntellivision(http://www.tripoint.org/kevtris/intv/)ṽy[W ]
 * - 1600}CNvZbTt@~ɂ́At@~ƓCP1600Ƃi݂悤łB
 *   CP1610CP1600̒ᑬ(!)łAIntellivisionɂĂ894.886KHz̃NbNŋ쓮Ă܂B
 *   894.886KHźANTSCJ[TuLANbN̎l̈łB
 * - AŌ894.886KHzƂ̓}CNTCN̂ƂłANbN͂̓{Ǝv܂B
 *   CP1610f[^V[g̖ߕ\ɂ́Â悤ȋLq܂B
 *   "1 MICROCYCLE = 2 CLOCK CYCLES"
 * - CP1610̎ÃG~[VvÓASă}CNTCNPʂŋLqĂ܂B
 *   {vOɕ킢A}CNTCNPʂŋLq邱Ƃɂ܂B
 */

/****************************************************************************
 *	萔E\
 ****************************************************************************/

typedef struct _CP1610 {
	unsigned short r[8];	/* + 0,16: R0,R1,R2,R3,R4,R5,R6,R7 */
	int sz;			/* +16, 4: S------- -------- SZZZZZZZ ZZZZZZZZ */
	int c;			/* +20, 4: -------- -------C -------- -------- */
	unsigned short ov;	/* +24, 2:                   V------- -------- */
	//
	unsigned char flags;	/* +26, 1: etO (CP1610_*̑g) */
	unsigned char ebc;	/* +27, 1: External Branch Condition (0..15) */
	unsigned short iab;	/* +28, 2: 荞݃xN^ ($0000..$FFFF) */
	//			/* +30, 2: (pfBO) */
	int cycle;		/* +32, 4 */
} CP1610;			/* =36 */
#define SIZEOF_CP1610		    36

/* CP1610.flags */
#define CP1610_IRQ	(1<<0)	/* 荞݂vꂽ1 */
#define CP1610_IFF	(1<<1)	/* 荞݋ԂȂ1 */
#define CP1610_DBD	(1<<2)	/* SDBDߎsȂ1 */
#define CP1610_HLT	(1<<3)	/* HLTȂ1 */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern CP1610 cp1610; /* P/ECȄꍇ͍RAMɔzu -> framc16a.s */

typedef struct _CP1610OP {
	void (*fn)();			/* +0,4: ߂֐ */
	unsigned char cycle;		/* +4,1: TCN */
	unsigned char dst;		/* +5,1: ]惌WX^A(0/-1) */
	unsigned char src;		/* +6,1: ]WX^ACondition Code */
	unsigned char ni;		/* +7,1: bit0=荞݃}XN߂Ȃ1 */
					/*       bit1=SDBDC\Ȗ߂Ȃ1 */
} CP1610OP;				/* =8 */
extern const CP1610OP cp1610op[0x400];	/* ߃e[u */

/* Condition Code -> L(1)/(0)Ή\ */
extern const unsigned short cp1610_cond[16/*Condition Code*/];

/****************************************************************************
 *	AvP[V`
 ****************************************************************************/

#ifndef PIECE
int cp1610_read(int addr);		/* Read */
void cp1610_write(int addr, int data);	/* Write */
#else /*PIECE*/
/* %r10 cp1610_read(%r12); */		/* Read */
/* void cp1610_write(%r12, %r13); */	/* Write */
#endif /*PIECE*/

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* CPUZbg܂B
 * [in]
 *	iab		IAB=ZbgxN^B($0000..$FFFF)
 *			Intellivision̏ꍇA$1000w肵ĂB
 * [note]
 *	* IAB́AInterrupt Address to Bus̗łB
 *	  #MSYNCMɂ郊Zbg󂯕tAZbgvfoCXA
 *	  f[^oXăvOJnAhX擾AƂdlłB
 */
void cp1610_reset(int iab);

/* Xe[^X[hl擾܂B
 * [out]
 *	߂l		Xe[^X[hlB(S|Z|V|C|0|0|0|0)
 */
#define cp1610_get_status cp1610_get_status_C /* AZu֐Ƃ̖OՓˉ */
int cp1610_get_status();

/* Xe[^X[hlݒ肵܂B
 * [in]
 *	status		Xe[^X[hlB(S|Z|V|C|-|-|-|-)
 */
#define cp1610_set_status cp1610_set_status_C /* AZu֐Ƃ̖OՓˉ */
void cp1610_set_status(int status);

/* EBC(External Branch Condition)ݒ肵܂B
 * [in]
 *	ebc		EBCB(0..15)
 * [note]
 *	* BEXT߂̕ƂĎQƂ܂B
 *	* ۂCP1610vZbTɂ́A4bitEBC͒[q킯ł͂܂B
 *	  BEXT̏Ɏw肳ꂽ4bitEBCR[hACP1610EBCA0-3[q*o*܂B
 *	  ÕfR[_(74150)EBCA0-3߂AɈvEBCIMŉ܂B
 *	  CP1610́AEBCIM̉ꍇ̂݁ABEXT̕sAƂdg݂łB
 */
void cp1610_set_ebc(int ebc);

/* CPUs܂B
 * [in]
 *	cycle		sTCNB
 */
void cp1610_run(int cycle);

/* 荞݂v܂B
 * [in]
 *	iab		IAB=荞݃xN^B($0000..$FFFF)
 *			Intellivision̏ꍇA$1004w肵ĂB
 * [note]
 *	* IAB́AInterrupt Address to Bus̗łB
 *	  #INTRMɂ銄荞݂󂯕tA荞݂vfoCXA
 *	  f[^oXĊ荞݃[`AhX擾AƂdlłB
 */
void cp1610_irq(int iab);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_C16_H__*/
