/*
 *	clipact.c
 *
 *	AN^[IuWFNg
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Feb 07 21:14:38 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- Lԋ@BƃvpeBwb_ƃAvP[V`̃f[^܂Ƃ߂̂AAN^[IuWFNgƌĂԎɂ܂B
 *        W[́AAN^[IuWFNgAc[\ŊǗ@\񋟂܂B
 *	- 2016/02/07݂̏AŒ̋@\܂B
 *	  AAN^[IuWFNg@\ǉAWvpeBⓖ蔻vpeBW肷\łB
 *	* Fri Feb 26 21:51:12 JST 2016 Naoyuki Sawa
 *	- ActObj_ApplyTrans_l(),ActObj_ApplyTrans_a(),ActObj_ApplyTrans_v()ǉ܂B
 *	  ActObj_ApplyTransToChildren_l(),ActObj_ApplyTransToChildren_a(),ActObj_ApplyTransToChildren_v()ǉ܂B
 *	  ActObj_ApplyTransToTree_l(),ActObj_ApplyTransToTree_a(),ActObj_ApplyTransToTree_v()ǉ܂B
 *	  ڍׂ́Aclipfsm.h ̓̃RgQƂĉB
 *	* Sat Feb 27 21:21:24 JST 2016 Naoyuki Sawa
 *	- FsmObj_Init()̈ŗLԋ@B̏Ԃ𖾎ȂȂɔAActObj_New()Ԃw肷폜܂B
 *	  ڍׂ́Aclipfsm.h ̓̃RgQƂĉB
 *	- ActObj_GetParent()ǉ܂B
 *	  ̊֐ǉŔAclipact.c ̎̃RgQƂĉB
 *	* Sat Apr 02 23:34:06 JST 2016 Naoyuki Sawa
 *	- ARRAY_SIZE()}N̕ύXɔAVC++6.0intunsigned̔rɑ΂xɏo悤ɂȂ̂ŁAxoȂ悤ɖIȃLXgǉ܂B
 *	  쎩̂͂܂łƕς܂B
 *	  ڍׂclipmisc.h̓̃RgQƂĉB
 */
#include "clip.h"
/****************************************************************************
 *	{IȊ֐
 ****************************************************************************/
static int GetPrpTblWords(const void* pPrpKey, int iPrpTbl) {
	//vpeBe[v(rbg-1)擾B
	int iBitLen = REG_get_value_l(pPrpKey, iPrpTbl, Prp_len, -1);
	if(iBitLen == -1) { DIE(); }
	//(rbg-1)(rbg)ɕ␳B
	iBitLen++;
	//rbg˃[hɐ؂グB
	return (iBitLen + 31) >> 5;
}
/*--------------------------------------------------------------------------*/
//AN^[IuWFNg쐬B
ST_ActObj* ActObj_New(ST_ActObj* pParent/*NULL*/, const void* pFsmKey/*NULL*/, int iFsmMap, const void* pPrpKey/*NULL*/, int iPrpTbl, int nDataBytes) {
	int nPrpTblWords, nDataWords;
	ST_ActObj* pActObj;
	//AvP[VpFsmKeyw肵Ȃꍇ́A_~[ƂāAȂXe[g}bvgď鎖ɂ܂B
	if(!pFsmKey) {
		//-------------------------------------
		//FsmMap.txt
		//Map0 State0
		//     State0
		//            default State0
		//     end
		//end
		//- - - - - - - - - - - - - - - - - - -
		//RegFsmMap.txt
		//FsmMap
		//       Map0
		//            init = State0
		//            State0
		//                   default
		//                           Fsm_State(3N+2) = State0
		//                   end
		//            end
		//       end
		//FsmMap
		//- - - - - - - - - - - - - - - - - - -
		static const uint8_t TBL_FsmMap_dummy[]={
		0x80,
		0x00,0x00,
		HIBYTE(           0x0000),LOBYTE(           0x0000), 0x00,0x00,0x00,	//Map0
		0xC0,
		0x00,0x00,
		HIBYTE(           0x8000),LOBYTE(           0x8000), 0x00,0x00,0x07,	//State0
		0x00,0x00,
		HIBYTE(   Fsm_State_init),LOBYTE(   Fsm_State_init), 0x00,0x00,0x00,	//init = State0
		0x80,
		0x00,0x00,
		HIBYTE(Fsm_Trans_default),LOBYTE(Fsm_Trans_default), 0x00,0x00,0x00,	//default
		0x40,
		0x00,0x00,
		/*Fsm_State*/HIBYTE(0x02),/*Fsm_State*/LOBYTE(0x02), 0x00,0x00,0x00,	//Fsm_State(3N+2) = State0
		};
		//-------------------------------------
		pFsmKey = TBL_FsmMap_dummy;
		iFsmMap = 0;	//Map0
	}
	//AvP[VpPrpKeyw肵Ȃꍇ́A_~[ƂāÃe[ugď鎖ɂ܂B
	if(!pPrpKey) {
		//dPrpTblC.exegăvpeBe[uXNvgRpCƁÃe[u͍쐬oȂ̂ŁAȉ̃f[^͎ō쐬܂B
		//dPrpTblC.exegč쐬鎖͏oȂf[^łAvpeBe[ũWXgf[^\ƂĂ͗LłB
		//-------------------------------------
		//PrpTbl.txt
		//Table0
		//    (empty)
		//end
		//- - - - - - - - - - - - - - - - - - -
		//RegPrpTbl.txt
		//PrpTbl
		//    Table0
		//        len = 1-1	//{(len=0-1)ƂWXg\oȂB1bit(؂グ1word)ʂɊmۂĂ܂͖薳B
		//    end
		//end
		//- - - - - - - - - - - - - - - - - - -
		static const uint8_t TBL_PrpTbl_dummy[]={
		0x80,
		0x00,0x00,
		HIBYTE(           0x0000),LOBYTE(           0x0000), 0x00,0x00,0x00,	//Table0
		0x40,
		0x00,0x00,
		HIBYTE(          Prp_len),LOBYTE(          Prp_len), 0x00,0x00,0x00,	//len = 1-1
		};
		//-------------------------------------
		pPrpKey = TBL_PrpTbl_dummy;
		iPrpTbl = 0;	//Table0
	}
	//vpeBe[ṽ[h߂B
	nPrpTblWords = GetPrpTblWords(pPrpKey, iPrpTbl);
	//f[^̃[h߂B
	nDataWords = (nDataBytes + 3) >> 2;
	//AN^[IuWFNg̃mۂB
	pActObj = calloc(sizeof(ST_ActObj) + sizeof(int) * (nPrpTblWords + nDataWords), 1);
	if(!pActObj) { DIE(); }
	//eIuWFNgw肳Ăc
	if(pParent) {
		//qm[h쐬B
		pActObj->node = g_node_append_data(pParent->node, pActObj);
	//eIuWFNgw肳ĂȂ΁c
	} else {
		//[gm[h쐬B
		pActObj->node = g_node_new(pActObj);
	}
	//vpeBwb_B
	PrpHdr_init(&pActObj->stPrpHdr, pPrpKey, iPrpTbl);
	//Lԋ@BB
	// - ̏ԍŌɍsKvL鎖ɒӂB
	//   Lԋ@Bstart֐̒ŃAN^[IuWFNg𑀍삷\L̂ŁȂOɃAN^[IuWFNg̏ĂȂ΂ȂB
	FsmObj_Init(&pActObj->stFsmObj, pFsmKey, iFsmMap);
	//AN^[IuWFNgԂB
	return pActObj;
}
/*--------------------------------------------------------------------------*/
static void ActObj_Free_func(GNode* node, void* data) {
	ST_ActObj* pActObj = node->data;
	ActObj_Free(pActObj);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃AN^[IuWFNgƁAqAN^[IuWFNgJB
void ActObj_Free(ST_ActObj* pActObj) {
	ActObj_FreeChildren(pActObj);
	g_node_destroy(pActObj->node);
	free(pActObj);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//qAN^[IuWFNgJB
//̃AN^[IuWFNg͊JȂB
void ActObj_FreeChildren(ST_ActObj* pActObj) {
	g_node_children_foreach(pActObj->node, G_TRAVERSE_ALL, ActObj_Free_func, NULL);
}
/*--------------------------------------------------------------------------*/
//AvP[V`̃f[^ւ̃|C^擾B
void* ActObj_GetData(ST_ActObj* pActObj) {
	//vpeBe[ṽ[h߂B
	int nPrpTblWords = GetPrpTblWords(pActObj->stPrpHdr.pPrpKey, pActObj->stPrpHdr.iTbl);
	//pActObj->stPrpHdr̃vpeBe[ǔɃf[^LB
	return (int*)(&pActObj->stPrpHdr + 1) + nPrpTblWords;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//eIuWFNg擾B
//eIuWFNg(=pFsmObj[gm[hȂ)NULLԂB
// - N-ary Trees̎dlł́Aem[hɃANZXɂ node->parent 𒼐ڎQƂ邾ŗǂ̂łA
//   ST_ActObj̏ꍇ (pActObj->node->parent ? pActObj->node->parent->data : NULL) ƒȂĂ܂A
//   AvP[V̒ɉx͔̂ς킵̂ŁA֐ƂĒ`鎖ɂ܂B
// - N-ary Trees̋@\gĎo鎖́AȂׂW[̊֐ƂĂ͎ȂjłA
//   L̗RŁÁAW[̊֐ƂĎĂǂƔf܂B
ST_ActObj* ActObj_GetParent(ST_ActObj* pActObj) {
	GNode* parent = pActObj->node->parent;
	return parent ? parent->data : NULL;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//ST_ActObj.stFsmObjւ̃|C^AST_ActObjւ̃|C^ɕϊB
ST_ActObj* ActObj_FromFsmObj(ST_FsmObj* pFsmObj) {
	return CONTAINING_RECORD(pFsmObj, ST_ActObj, stFsmObj);
}
/*--------------------------------------------------------------------------*/
//ŏ̎qAN^[IuWFNg擾B
//<gp>
//ST_ActObj_Iter Iter;
//ST_ActObj* pChild;
//for(pChild=ActObj_FirstChild(pActObj,&Iter);
//    pChild;
//    pChild=ActObj_NextSibling(&Iter)){
//      `  //ActObj_Free(pChild)sĂSłB
//}
ST_ActObj* ActObj_FirstChild(ST_ActObj* pActObj, ST_ActObj_Iter* pIter) {
	GNode* node = g_node_first_child(pActObj->node);
	pIter->pNext = node ? node->data : NULL;
	return ActObj_NextSibling(pIter);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̎qAN^[IuWFNg擾B
ST_ActObj* ActObj_NextSibling(ST_ActObj_Iter* pIter) {
	ST_ActObj* pActObj = pIter->pNext;
	if(pActObj) {
		GNode* node = g_node_next_sibling(pActObj->node);
		pIter->pNext = node ? node->data : NULL;
	}
	return pActObj;
}
/*--------------------------------------------------------------------------*/
static int ActObj_ApplyTrans_func(GNode* node, void* data) {
	ST_ActObj* pActObj = node->data;
	void** d = data;		//
	int iFsmTrans = (int)d[0];	//ActObj_ApplyTransToChildren(),ActObj_ApplyTransToTree()
	void* pParam  =      d[1];	//
	ActObj_ApplyTrans(pActObj, iFsmTrans, pParam);
	return 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃AN^[IuWFNg̗Lԋ@BɁAJڂKpB
void ActObj_ApplyTrans(ST_ActObj* pActObj, int iFsmTrans, void* pParam) {
	FsmObj_ApplyTrans(&pActObj->stFsmObj, iFsmTrans, pParam);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//qAN^[IuWFNg̗Lԋ@BɁAJڂKpB
//̃AN^[IuWFNg,y,ڂ̎qȊO̎qAN^[IuWFNg̗Lԋ@Bɂ́AJڂKpȂB
void ActObj_ApplyTransToChildren(ST_ActObj* pActObj, int iFsmTrans, void* pParam) {
	void* d[2];			//
	d[0] = (void*)iFsmTrans;	//ActObj_ApplyTrans_func()
	d[1] =        pParam;		//
	g_node_children_foreach(pActObj->node, G_TRAVERSE_ALL, (void(*)(GNode*,void*))ActObj_ApplyTrans_func, d);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//̃AN^[IuWFNg,y,qAN^[IuWFNg̗Lԋ@BɁAJڂKpB
void ActObj_ApplyTransToTree(ST_ActObj* pActObj, int iFsmTrans, void* pParam) {
	void* d[2];			//
	d[0] = (void*)iFsmTrans;	//ActObj_ApplyTrans_func()
	d[1] =        pParam;		//
	g_node_traverse(pActObj->node, G_POST_ORDER, G_TRAVERSE_ALL, -1/*depth*/, ActObj_ApplyTrans_func, d);
	//                             ~~~~~~~~~~~~R[obN֐AR[obN֐ɓnꂽm[h폜\L̂ŁAG_PRE_ORDER͕słBڍׂg_node_traverse()̃RgQƂĉB
	//                                         G_POST_ORDER,,G_LEVEL_ORDER̂ǂłɓ삵܂AG_LEVEL_ORDERG_POST_ORDER̕ǂ̂ŁAG_POST_ORDERgɂ܂B
}
/****************************************************************************
 *	[eBeB֐
 ****************************************************************************/
#ifndef PIECE
void ActObj_ApplyTrans_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...) {
	va_list ap;
	va_start(ap, argc);
	ActObj_ApplyTrans_a(pActObj, iFsmTrans, argc, ap);
	va_end(ap);
}
void ActObj_ApplyTrans_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap) {
	void* argv[16/**/];	//pAp[^16ȉƍlď[낤Bsꍇ͑₹B
	int i;
	if((unsigned)argc > (unsigned)ARRAY_SIZE(argv)) { DIE(); }	//Œ~ꍇ́Aargv[]̗vf𑝂₹B
	for(i = 0; i < argc; i++) { argv[i] = va_arg(ap, void*); }
	ActObj_ApplyTrans_v(pActObj, iFsmTrans, argc, argv);
}
void ActObj_ApplyTrans_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]) {
	ActObj_ApplyTrans(pActObj, iFsmTrans, argv);
}
#else //PIECE
void ActObj_ApplyTrans_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...);
void ActObj_ApplyTrans_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap);
void ActObj_ApplyTrans_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]);
asm("
		.code
		.align		1
		.global		ActObj_ApplyTrans_l
		.global		ActObj_ApplyTrans_a
		.global		ActObj_ApplyTrans_v
ActObj_ApplyTrans_l:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := argc
		;//[%sp+ 8] := ...
		xld.w		%r14, [%sp+4]			;//%r14 := argc
		xadd		%r15, %sp, 8			;//%r15 := ap = &...
ActObj_ApplyTrans_a:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := ap
ActObj_ApplyTrans_v:
		xsub		%sp, %sp, 12
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := argv
		xjp.d		ActObj_ApplyTrans		;//ActObj_ApplyTrans(pActObj, iFsmTrans, argv)
		ld.w		%r14, %r15			;//%r14 :=                               argv			*delay*
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void ActObj_ApplyTransToChildren_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...) {
	va_list ap;
	va_start(ap, argc);
	ActObj_ApplyTransToChildren_a(pActObj, iFsmTrans, argc, ap);
	va_end(ap);
}
void ActObj_ApplyTransToChildren_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap) {
	void* argv[16/**/];	//pAp[^16ȉƍlď[낤Bsꍇ͑₹B
	int i;
	if((unsigned)argc > (unsigned)ARRAY_SIZE(argv)) { DIE(); }	//Œ~ꍇ́Aargv[]̗vf𑝂₹B
	for(i = 0; i < argc; i++) { argv[i] = va_arg(ap, void*); }
	ActObj_ApplyTransToChildren_v(pActObj, iFsmTrans, argc, argv);
}
void ActObj_ApplyTransToChildren_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]) {
	ActObj_ApplyTransToChildren(pActObj, iFsmTrans, argv);
}
#else //PIECE
void ActObj_ApplyTransToChildren_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...);
void ActObj_ApplyTransToChildren_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap);
void ActObj_ApplyTransToChildren_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]);
asm("
		.code
		.align		1
		.global		ActObj_ApplyTransToChildren_l
		.global		ActObj_ApplyTransToChildren_a
		.global		ActObj_ApplyTransToChildren_v
ActObj_ApplyTransToChildren_l:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := argc
		;//[%sp+ 8] := ...
		xld.w		%r14, [%sp+4]			;//%r14 := argc
		xadd		%r15, %sp, 8			;//%r15 := ap = &...
ActObj_ApplyTransToChildren_a:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := ap
ActObj_ApplyTransToChildren_v:
		xsub		%sp, %sp, 12
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := argv
		xjp.d		ActObj_ApplyTransToChildren	;//ActObj_ApplyTransToChildren(pActObj, iFsmTrans, argv)
		ld.w		%r14, %r15			;//%r14 :=                                         argv		*delay*
");
#endif//PIECE
/*--------------------------------------------------------------------------*/
#ifndef PIECE
void ActObj_ApplyTransToTree_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...) {
	va_list ap;
	va_start(ap, argc);
	ActObj_ApplyTransToTree_a(pActObj, iFsmTrans, argc, ap);
	va_end(ap);
}
void ActObj_ApplyTransToTree_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap) {
	void* argv[16/**/];	//pAp[^16ȉƍlď[낤Bsꍇ͑₹B
	int i;
	if((unsigned)argc > (unsigned)ARRAY_SIZE(argv)) { DIE(); }	//Œ~ꍇ́Aargv[]̗vf𑝂₹B
	for(i = 0; i < argc; i++) { argv[i] = va_arg(ap, void*); }
	ActObj_ApplyTransToTree_v(pActObj, iFsmTrans, argc, argv);
}
void ActObj_ApplyTransToTree_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]) {
	ActObj_ApplyTransToTree(pActObj, iFsmTrans, argv);
}
#else //PIECE
void ActObj_ApplyTransToTree_l(ST_ActObj* pActObj, int iFsmTrans, int argc, ...);
void ActObj_ApplyTransToTree_a(ST_ActObj* pActObj, int iFsmTrans, int argc, va_list ap);
void ActObj_ApplyTransToTree_v(ST_ActObj* pActObj, int iFsmTrans, int argc, void* argv[/*argc*/]);
asm("
		.code
		.align		1
		.global		ActObj_ApplyTransToTree_l
		.global		ActObj_ApplyTransToTree_a
		.global		ActObj_ApplyTransToTree_v
ActObj_ApplyTransToTree_l:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//[%sp+ 0] := retp
		;//[%sp+ 4] := argc
		;//[%sp+ 8] := ...
		xld.w		%r14, [%sp+4]			;//%r14 := argc
		xadd		%r15, %sp, 8			;//%r15 := ap = &...
ActObj_ApplyTransToTree_a:
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := ap
ActObj_ApplyTransToTree_v:
		xsub		%sp, %sp, 12
		;//%r12     := pActObj
		;//%r13     := iFsmTrans
		;//%r14     := argc
		;//%r15     := argv
		xjp.d		ActObj_ApplyTransToTree		;//ActObj_ApplyTransToTree(pActObj, iFsmTrans, argv)
		ld.w		%r14, %r15			;//%r14 :=                                     argv		*delay*
");
#endif//PIECE
