%{
/*{{^R[h:y.tab.y(錾,%{`%})======================================*/
#ifdef  PIECE
#include "app.h"
#else //PIECE
#include "winapp.h"
#endif//PIECE
/* p[T[X^bN̏l`܂B
 * sizeof(YYSTYPE)*YYINITDEPTH) X^bNɊmۂ܂B
 * ftHgł200ƒ`ĂAP/ECEɂ͑傫܂B
 * P/ECEɓK؂ȁAȃTCY(16)ɁAĒ`܂B
 * p[T[X^bNsꍇ́AIɊĝŁA肠܂B
 */
#define YYINITDEPTH 16
/* G[񍐊֐`܂B */
void yyerror(const char* fmt, ...) {
  fprintf(stderr, "### error at line %d : ", yylineno);
  { va_list ap; va_start(ap, fmt); vfprintf(stderr, fmt, ap); va_end(ap); }
  fputc('\n', stderr); }
/*}}^R[h:y.tab.y(錾,%{`%})======================================*/
%}

%union {
	int		v_num;			//0`65536=l,65537`131071=TBL_LabRef[]ւ̃CfNX	//{{I\idȎQƂł悤ɁB}}
	char*		v_lab;
	//
	ST_Table*	v_table;
	ST_Blocks*	v_blocks;
	ST_Block*	v_block;
	ST_Header*	v_header;
	ST_Body*	v_body;
	ST_LabelRow*	v_labelRow;
	ST_HeaderRow*	v_headerRow;
	ST_BodyRow*	v_bodyRow;
	ST_Values*	v_values;
}
%token T_ID
%token <v_num> T_NUM
%token <v_lab> T_LAB
%token T_EOL

%left '|'
%left '^'
%left '&'
%left '<' '>'
%left '+' '-'
%left '*' '/'
%nonassoc T_UPL T_UMI
%type <v_num>       expr
%type <v_table>     table
%type <v_blocks>    blocks
%type <v_block>     block
%type <v_header>    header
%type <v_body>      body
%type <v_labelRow>  labelRow
%type <v_headerRow> headerRow
%type <v_bodyRow>   bodyRow
%type <v_values>    colIds
%type <v_values>    weights
%type <v_num>       colId
%type <v_num>       hitVal
%type <v_num>       weight

%%

all
		: /* empty */			/* no action */
	    //{{2015/02/21C:alĺuall eolsvbodyRoẃuhitVal ',' weights eolsvՓ˂Ă̂ŁAO҂ueolsvɕύXďC܂B
	    //	| all eols			/* no action */			//t@C̍ŏɈsȏ̋sLꍇɓǂݔ΂߂ɕKvB
	    //2015/02/21C:alĺuall eolsvbodyRoẃuhitVal ',' weights eolsvՓ˂Ă̂ŁAO҂ueolsvɕύXďC܂B
		| eols				/* no action */			//t@C̍ŏɈsȏ̋sLꍇɓǂݔ΂߂ɕKvB
	    //}}2015/02/21C:alĺuall eolsvbodyRoẃuhitVal ',' weights eolsvՓ˂Ă̂ŁAO҂ueolsvɕύXďC܂B
		| all table			{ add_table($2); yyerrok; }	//SẴV^NXG[񍐂邽߂ɌpB	errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| all error
		;
table
		: labelRow blocks		{ $$ = Table_newBlocks($1, $2); }
		| labelRow body			{ $$ = Table_newBody(  $1, $2); }
		;
blocks
		:        block			{ $$ = Blocks_add(NULL, $1); }
		| blocks block			{ $$ = Blocks_add(  $1, $2); }
		;
block
		: header body			{ $$ = Block_new($1, $2); }
		;
header
		:        headerRow		{ $$ = Header_add(NULL, $1); }
		| header headerRow		{ $$ = Header_add(  $1, $2); }
		;
body
		:      bodyRow			{ $$ = Body_add(NULL, $1); }
		| body bodyRow			{ $$ = Body_add(  $1, $2); }
		;
eols
		:      T_EOL			/* no action */
		| eols T_EOL			/* no action */
		;
labelRow
		: ':' T_LAB eols		{ $$ = LabelRow_new($2); }
		;
headerRow
		: T_ID ',' colIds eols		{ $$ = HeaderRow_new($3); }
		;
bodyRow
		: hitVal ',' weights eols	{ $$ = BodyRow_new($1, $3); }
		;
colIds
		:            colId		{ $$ = Values_add(NULL, $1); }
		| colIds ',' colId		{ $$ = Values_add(  $1, $3); }
		;
weights
		:             weight		{ $$ = Values_add(NULL, $1); }
		| weights ',' weight		{ $$ = Values_add(  $1, $3); }
		;
colId
		: /* empty */			{ $$ = -1/**/; }
		| expr				{ $$ = ColId_new($1); }
		| T_LAB				{ $$ = LabRef_new($1); }	//{{I\idȎQƂł悤ɁB}}
		;
hitVal
		: expr				{ $$ = HitVal_new($1); }
		| T_LAB				{ $$ = LabRef_new($1); }	//{{I\idȎQƂł悤ɁB}}
		;
weight
		: expr				{ $$ = Weight_new($1); }
		| T_LAB				{ $$ = LabRef_new($1); }	//{{I\idȎQƂł悤ɁB}}
		;
expr
		: T_NUM				/* use default action */
		| '(' expr ')'			{ $$ =  $2; }
		| '+' expr %prec T_UPL		{ $$ =  $2; }
		| '-' expr %prec T_UMI		{ $$ = -$2; }
		| expr '+' expr			{ $$ = $1 + $3; }
		| expr '-' expr			{ $$ = $1 - $3; }
		| expr '*' expr			{ $$ = $1 * $3; }
		| expr '/' expr			{ $$ = $1 / $3; }
		| expr '&' expr			{ $$ = $1 & $3; }
		| expr '^' expr			{ $$ = $1 ^ $3; }
		| expr '|' expr			{ $$ = $1 | $3; }
		| expr '<' expr			{ $$ = $1 << $3; }
		| expr '>' expr			{ $$ = $1 >> $3; }
		;

%%
