    /********************************************************/
    /*                                                      */
    /*                                                      */
    /*         Copyright (C), 1993  SEIKO EPSON Corp.       */
    /*         ALL RIGHTS RESERVED                          */
    /*                                                      */
    /*                                                      */
    /*  file name : stdlib.h                                */
    /*                                                      */
    /*  Revision history                                    */
    /*      93/12/17    first release       S.Akaiwa        */
    /*      97/02/20    modified            T.Katahira      */
    /*                  change function declaration         */
    /*                          to the ANSI style           */
    /*      00/06/01    modified            M.Kakinuma      */
    /*      14/11/19    modify for P/ECE    Naoyuki Sawa    */
    /*                - qsort_r()ǉ܂Bclipsort.cɂ܂B */
    /*      15/01/07    modify for P/ECE    Naoyuki Sawa    */
    /*                - splitpath(),makepath()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂B */
    /*                - malloc_usable_size()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂B                            */
    /*                  malloc_usable_size()͖{malloc.hŐ錾ׂȂ̂łAP/ECEɂmalloc.ĥinclude/stdlib.hŐ錾邱Ƃɂ܂B */
    /*      15/01/20    modify for P/ECE    Naoyuki Sawa    */
    /*                - size_t̒`unsigned^ɓꂵ܂B */
    /*                                                      */
    /********************************************************/

#ifndef _STDLIB_H
#define _STDLIB_H

#ifndef _SIZE_T
#define _SIZE_T
//{{2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
//typedef unsigned long   size_t;     /* size of type */
//2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
// * Tue Jan 20 23:26:57 JST 2015 Naoyuki Sawa
// - P/ECEJłsize_tunsignedBunsigned longł͂ȂB
//   1:
//   typedef unsigned size_t;
//   extern void* memcpy(void*,const void*,size_t);  xRpCo
//   2:~
//   typedef unsigned long size_t;
//   extern void* memcpy(void*,const void*,size_t);  warning:conflicting types for built-in function `memcpy'
//   P/ECEJ̕WCN[ht@CԈĂ̂ŗvӂłB
//   stddef.hł̒`͐ǁAstdio.h,stdlib.h,string.h,time.hł̒`͊ԈĂ܂B
//   ܂stddef.hŏɃCN[hƑvȂ̂łB
// - ǂ̃wb_t@CŏɃCN[hĂvȂ悤ɁA`𓝈ꂷ邱Ƃɂ܂B
//   P/ECEvOȂ΁Astddef.hŏɃCN[h悤ɂł̂łA
//   I[v\[X̃CuύXRpCɁAstddef.hȊOŏɂȂĂꍇ邩łB
//   ̓Iɂ́A/clip/liblua/RpCƂɌxoāA̖ɋCt܂B
typedef unsigned size_t;
//}}2015/01/20ύX:size_t̒`unsigned^ɓꂵ܂B
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short  wchar_t;    /* wide character type */
#endif
    
typedef struct {                    /* division type */
  int rem;
  int quot; } div_t;

typedef struct {                    /* long division type */
  long rem;
  long quot; } ldiv_t;

#if !defined(NULL)
#  define NULL          ((void *)0L)/* null pointer */
#endif

#define RAND_MAX        0x7fff      /* random maximum number */

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

/*  global, memory allocation proc.*/
extern unsigned char *ansi_ucStartAlloc;   /* allocate area, start address */
extern unsigned char *ansi_ucEndAlloc;     /* allocate area, end address   */
extern unsigned char *ansi_ucNxtAlcP;      /* next allocate address        */
extern unsigned char *ansi_ucTblPtr;       /* next address for table       */
extern unsigned long ansi_ulRow;           /* table count   */


extern  unsigned int    seed;       /* random seed */

typedef int fn_t( const void *, const void * );


/* prototype definition */

extern  void            abort( void );
extern  void            exit( int ); 
extern  int             atexit( void (*)(void) );
extern  char *          getenv( const char * );
extern  int             system( const char * );

extern  void *          malloc( size_t );
extern  void *          calloc( size_t, size_t );
extern  void *          realloc( void *, size_t );
extern  void            free( void * ); 
extern  int             ansi_InitMalloc(unsigned long, unsigned long);

extern  int             atoi( const char * );
extern  long            atol( const char * );
extern  double          atof( const char * );
extern  long            strtol( const char *, char **, int );
extern  unsigned long   strtoul( const char *, char **, int );
extern  double          strtod( const char *, char ** );

extern  int             abs( int );
extern  long            labs( long );

extern  div_t           div( int, int );
extern  ldiv_t          ldiv( long, long );

extern  int             rand( void );
extern  void            srand( unsigned int );

extern  void *          bsearch( const void *, const void *, 
                        size_t, size_t, fn_t * );

extern  void            qsort( void *, size_t, size_t, fn_t * );
//{{2014/11/19ǉ:qsort_r()ǉ܂Bclipsort.cɂ܂B
void qsort_r(void* base, size_t num, size_t width, int (*compare)(const void*, const void*, void*), void* arg);
//}}2014/11/19ǉ:qsort_r()ǉ܂Bclipsort.cɂ܂B

//{{2015/01/07ǉ:splitpath(),makepath()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂B
/* WindowśApX\vf/֐łB
 * P/ECEłAt@CƊgq̕/͕֗Ȃ̂ŁA`ĂƂɂ܂B
 * - MAX_PATH,MAX_DRIVE,MAX_DIR,MAX_FNAME,MAX_EXT́AWindowsƓlƂ܂B
 *   path[MAX_PATH],drive[MAX_DRIVE],dir[MAX_DIR],fname[MAX_FNAME],ext[MAX_EXT]SăX^bNɊmۂƁA
 *   v1KBKvȂ̂ŁAX^bNI[o[t[ɒӂĂB
 *   P/ECEł́Adrive[MAX_DRIVE]dir[MAX_DIR]͒ʏKvȂ̂ŁA2mۂȂΏߖł܂B */
#define MAX_PATH  260
#define MAX_DRIVE 3
#define MAX_DIR   256
#define MAX_FNAME 256
#define MAX_EXT   256
void splitpath(const char* path, char drive[/*MAX_DRIVE*/], char dir[/*MAX_DIR*/], char fname[/*MAX_FNAME*/], char ext[/*MAX_EXT*/]);
void makepath(char path[/*MAX_PATH*/], const char* drive, const char* dir, const char* fname, const char* ext);
//}}2015/01/07ǉ:splitpath(),makepath()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂B

//{{2015/01/07ǉ:malloc_usable_size()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂Bmalloc_usable_size()͖{malloc.hŐ錾ׂȂ̂łAP/ECEɂmalloc.ĥinclude/stdlib.hŐ錾邱Ƃɂ܂B
//{{2014/09/29ǉ:malloc_usable_size()ǉ܂B
//q[vɊ蓖ĂꂽubÑTCY擾܂B
// - ̊֐́AGNUgłB֗Ȃ̂ŁAP/ECEɂǉ邱Ƃɂ܂B
// - Visual C++ɂA֐Ƃ_msize()L܂AdlقȂĂ܂B
//   malloc_usable_size()NULL|C^nƁA(0)Ԃ܂B
//   _msize()NULL|C^nƁAsI܂B
//   malloc_usable_size()̕SȂ̂ŁAmalloc_usable_size()̎dlɏ]܂B
//uLinux Programmer's Manualvp
//MALLOC_USABLE_SIZE(3)      Linux Programmer's Manual     MALLOC_USABLE_SIZE(3)
//NAME
//       malloc_usable_size - obtain size of block of memory allocated from heap
//SYNOPSIS
//       #include <malloc.h> 
//       size_t malloc_usable_size (void *ptr);
//DESCRIPTION
//       The malloc_usable_size() function returns the number of usable bytes in
//       the block pointed to by ptr, a pointer to a block of  memory  allocated
//       by malloc(3) or a related function.
//RETURN VALUE
//       malloc_usable_size() returns the number of usable bytes in the block of
//       allocated memory pointed to by ptr.  If ptr is NULL, 0 is returned.
//CONFORMING TO
//       This function is a GNU extension.
//NOTES
//       The value returned by malloc_usable_size()  may  be  greater  than  the
//       requested  size of the allocation because of alignment and minimum size
//       constraints.  Although the excess  bytes  can  be  overwritten  by  the
//       application without ill effects, this is not good programming practice:
//       the number of excess bytes in an allocation depends on  the  underlying
//       implementation.
//       The main use of this function is for debugging and introspection.
//SEE ALSO
//       malloc(3)
//COLOPHON
//       This  page  is  part of release 3.53 of the Linux man-pages project.  A
//       description of the project, and information about reporting  bugs,  can
//       be found at http://www.kernel.org/doc/man-pages/.
//GNU                               2012-03-29             MALLOC_USABLE_SIZE(3)
size_t malloc_usable_size(void* ptr);
//}}2014/09/29ǉ:malloc_usable_size()ǉ܂B
//}}2015/01/07ǉ:malloc_usable_size()̐錾clippce.hinclude/stdlib.hցCclippce.ccliplibc.cֈړ܂Bmalloc_usable_size()͖{malloc.hŐ錾ׂȂ̂łAP/ECEɂmalloc.ĥinclude/stdlib.hŐ錾邱Ƃɂ܂B

#endif  _STDLIB_H

