/*	
 *	framz80.c
 *
 *	P/ECE Z80 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipz80i.h"	/*Z80G~[^p}N*/

/****************************************************************************
 *	Z80RÃCREAD/WRITEO֐
 ****************************************************************************/

/* Z80\(64oCg)̒ɃCzuĂ邱Ƃ肵܂B
 * oCiCAEgقȂꍇAoNؑւȂǂ̓ᏈKvȏꍇ́A
 * AvP[V`̊O֐pӂĂB
 */

#ifndef Z80_ASM	/************************************************************/

unsigned char
z80_internal_read(Z80* z80, unsigned short addr)
{
	return ((unsigned char*)(z80 + 1))[addr];
}
void
z80_internal_write(Z80* z80, unsigned short addr, unsigned char data)
{
	((unsigned char*)(z80 + 1))[addr] = data;
}

#else	/********************************************************************/

asm("
	.code
	.align 1
	.global z80_internal_read
z80_internal_read:
	add %r12, %r13
	xld.ub %r10, [%r12+64]
	ret
");
asm("
	.code
	.align 1
	.global z80_internal_write
z80_internal_write:
	add %r12, %r13
	xld.b [%r12+64], %r14
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef Z80_ASM

/* Z80G~[Vs܂B
 * [in]
 *	z80		Z80\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂HALTŏI܂B
 */
void
z80_run(Z80* z80, int cycle)
{
	unsigned char code;
	const Z80OP* op;
	unsigned char arg1;
	unsigned char arg2;

	arg1 = arg2 = 0; /* x} */
	CYCLE = cycle;
	while(!HALT && CYCLE > 0) {
#ifdef Z80_TRACE
		z80_dump(z80);
#endif /*Z80_TRACE*/
		Z80TRACE("%04x: ", PC);
		FETCH(code);
		op = &z80_op_table[code];
		if(op->argc >= 1) {
			FETCH(arg1);
			if(op->argc >= 2) {
				FETCH(arg2);
			}
		}
		EXEC();
		Z80TRACE("\n");
	}
}

/* CB XX ߂̃e[uWvłB
 * [note]
 *	* CB XX ߂̈́A0oCgłB
 */
Z80FN_("CB", CB)
{
	const Z80OP* op;

	FETCH(code);
	op = &z80_op_table_CB[code];
	ASSERT(op->argc == 0);
	EXEC();
}

/* ED XX ߂̃e[uWvłB
 * [note]
 *	* ED XX ߂̈́A0oCg܂2oCgłB
 */
Z80FN_("ED", ED)
{
	const Z80OP* op;

	FETCH(code);
	op = &z80_op_table_ED[code];
	ASSERT(op->argc == 0 || op->argc == 2);
	if(op->argc) {
		FETCH(arg1);
		FETCH(arg2);
	}
	EXEC();
}

/* DD XX ߂̃e[uWvłB
 */
Z80FN_("DD", DD)
{
	const Z80OP* op;

	FETCH(code);
	op = &z80_op_table_DD[code];
	if(op->argc >= 1) {
		FETCH(arg1);
		if(op->argc >= 2) {
			FETCH(arg2);
		}
	}
	EXEC();
}

/* FD XX ߂̃e[uWvłB
 */
Z80FN_("FD", FD)
{
	const Z80OP* op;

	FETCH(code);
	op = &z80_op_table_FD[code];
	if(op->argc >= 1) {
		FETCH(arg1);
		if(op->argc >= 2) {
			FETCH(arg2);
		}
	}
	EXEC();
}

/* DD CB d XX ߂̃e[uWvłB
 * [note]
 *	* DD CB d XX ߂̈1oCgłB
 *	  uAIyR[hv̏ł邱ƂɒӂĂB
 */
Z80FN_("DDCB", DDCB)
{
	const Z80OP* op;

	FETCH(arg1);
	FETCH(code);
	op = &z80_op_table_DDCB[code];
	ASSERT(op->argc == 1);
	EXEC();
}

/* FD CB d XX ߂̃e[uWvłB
 * [note]
 *	* FD CB d XX ߂̈1oCgłB
 *	  uAIyR[hv̏ł邱ƂɒӂĂB
 */
Z80FN_("FDCB", FDCB)
{
	const Z80OP* op;

	FETCH(arg1);
	FETCH(code);
	op = &z80_op_table_FDCB[code];
	ASSERT(op->argc == 1);
	EXEC();
}

#endif /*Z80_ASM*/

/****************************************************************************
 *
 ****************************************************************************/

///* peBtOZô߂̕⏕[`łB
// * [in]
// *	n		ׂlB
// * [out]
// *	߂l		1̃rbgȂ4Ԃ܂B
// *			1̃rbgȂ0Ԃ܂B
// * [note]
// *	* Z80̃peBtO͋peBłB
// *	* peBtÖʒubit2Ȃ̂ŁA4or0Ԃ܂B
// */
//#ifndef Z80_ASM	/************************************************************/
//
//unsigned char
//z80_PARITY(unsigned char n)
//{
//	int p = 4;
//	while(n) {
//		if(n & 1) p ^= 4;
//		n >>= 1;
//	}
//	return p;
//}
//
//#else	/********************************************************************/
//
//asm("
//	.code
//	.align 1
//	.global z80_PARITY
//z80_PARITY:
//	swap %r12, %r12			; ׂl8rbgɈړB
//	xjreq.d z80_PARITY_L20		; 1̃rbgȂ΁A[vɓ܂B
//	ld.w %r10, 4			; peBȂ̂ŁAԂONB*delay*
//z80_PARITY_L10:
//	scan1 %r11, %r12		; 1̃rbgʒuB(K݂)
//	sll %r12, %r11			; rbgŏʂփVtgB
//	sll %r12, 1			; rbg֎̂ĂB
//	xjrne.d z80_PARITY_L10		; ܂1̃rbgcĂA[vB
//	xor %r10, 4			; rbg̃peB]B*delay*
//z80_PARITY_L20:
//	ret
//");
//
//#endif	/********************************************************************/
//
//2003/12/01 peBrbgϊe[u̎QƂɒûŁA폜܂B

/****************************************************************************
 *	General-Purpose Arithmetic and CPU Control Group
 ****************************************************************************/

#ifndef Z80_ASM

/* 8rbgZs܂B
 * [in/out]
 *	A <= A + n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
void
z80_ADD8(Z80* z80, unsigned char n)
{
	int tmp = A + n;
	F = (tmp & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xff) << 6) |			/* Z */
	    (((A & 0xf) + (n & 0xf)) & 0x10) |		/* H */
	    ((~(A ^ n) & (A ^ tmp) & 0x80) >> 5) |	/* V */
							/* N */
	    ((tmp >> 8) & 1);				/* C */
	A = tmp;
}

/* 8rbgZ(L[)s܂B
 * [in/out]
 *	A <= A + n + F(C)
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
void
z80_ADC8(Z80* z80, unsigned char n)
{
	int c = F & 1;
	int tmp = A + n + c;
	F = (tmp & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xff) << 6) |			/* Z */
	    (((A & 0xf) + (n & 0xf) + c) & 0x10) |	/* H */
	    ((~(A ^ n) & (A ^ tmp) & 0x80) >> 5) |	/* V */
							/* N */
	    ((tmp >> 8) & 1);				/* C */
	A = tmp;
}

/* 8rbgZs܂B
 * [in/out]
 *	A <= A - n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	  1	Doc'd
 *	C	0/1	Doc'd
 */
void
z80_SUB8(Z80* z80, unsigned char n)
{
	int tmp = A - n;
	F = (tmp & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xff) << 6) |			/* Z */
	    (((A & 0xf) - (n & 0xf)) & 0x10) |		/* H */
	    (((A ^ n) & (A ^ tmp) & 0x80) >> 5) |	/* V */
	    2 |						/* N */
	    ((tmp >> 8) & 1);				/* C */
	A = tmp;
}

/* 8rbgZ({[)s܂B
 * [in/out]
 *	A <= A - n - F(C)
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	  1	Doc'd
 *	C	0/1	Doc'd
 */
void
z80_SBC8(Z80* z80, unsigned char n)
{
	int c = F & 1;
	int tmp = A - n - c;
	F = (tmp & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xff) << 6) |			/* Z */
	    (((A & 0xf) - (n & 0xf) - c) & 0x10) |	/* H */
	    (((A ^ n) & (A ^ tmp) & 0x80) >> 5) |	/* V */
	    2 |						/* N */
	    ((tmp >> 8) & 1);				/* C */
	A = tmp;
}

/* _ς߂܂B
 * [in/out]
 *	A <= A & n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	  1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0  	Doc'd
 */
void
z80_AND(Z80* z80, unsigned char n)
{
	A &= n;
	F = (A & 0xa8) |	/* S,Y,X */
	    (!A << 6) |		/* Z */
	    0x10 |		/* H */
	    PARITY(A);		/* P */
				/* N */
				/* C */
}

/* _a߂܂B
 * [in/out]
 *	A <= A & n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0  	Doc'd
 */
void
z80_OR(Z80* z80, unsigned char n)
{
	A |= n;
	F = (A & 0xa8) |	/* S,Y,X */
	    (!A << 6) |		/* Z */
				/* H */
	    PARITY(A);		/* P */
				/* N */
				/* C */
}

/* r_a߂܂B
 * [in/out]
 *	A <= A ^ n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0  	Doc'd
 */
void
z80_XOR(Z80* z80, unsigned char n)
{
	A ^= n;
	F = (A & 0xa8) |	/* S,Y,X */
	    (!A << 6) |		/* Z */
				/* H */
	    PARITY(A);		/* P */
				/* N */
				/* C */
}

/* rs܂B
 * [in/out]
 *	̂Ă <= A - n
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	rlbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	rlbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	  1	Doc'd
 *	C	0/1	Doc'd
 * [note]
 *	* tOWX^bit5,3́Aʂł͂ȂrΏےl𔽉f܂B
 *	  ̖߂AgptOrbg̐U镑łBv!!
 */
void
z80_CP(Z80* z80, unsigned char n)
{
	int tmp = A - n;
	F = (tmp & 0x80) |				/* S */
	    (n & 0x28) |				/* Y,X */
	    (!(tmp & 0xff) << 6) |			/* Z */
	    (((A & 0xf) - (n & 0xf)) & 0x10) |		/* H */
	    (((A ^ n) & (A ^ tmp) & 0x80) >> 5) |	/* V */
	    2 |						/* N */
	    ((tmp >> 8) & 1);				/* C */
}

/* 8rbglCNg܂B
 * [in/out]
 *	߂l <= r + 1
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	---	Doc'd
 */
unsigned char
z80_INC8(Z80* z80, unsigned char r)
{
	r++;
	F = (r & 0xa8) |		/* S,Y,X */
	    (!r << 6) |			/* Z */
	    (!(r & 0xf) << 4) |		/* H */
	    ((r == 0x80) << 2) |	/* V */
					/* N */
	    (F & 1);			/* C */
	return r;
}

/* 8rbglfNg܂B
 * [in/out]
 *	߂l <= r + 1
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0/1	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	  1	Doc'd
 *	C	---	Doc'd
 */
unsigned char
z80_DEC8(Z80* z80, unsigned char r)
{
	r--;
	F = (r & 0xa8) |		/* S,Y,X */
	    (!r << 6) |			/* Z */
	    (((r & 0xf) == 0xf) << 4) |	/* H */
	    ((r == 0x7f) << 2) |	/* V */
	    2 |				/* N */
	    (F & 1);			/* C */
	return r;
}

/****************************************************************************
 *	16-Bit Arithmetic Group
 ****************************************************************************/

/* 16rbgZs܂B
 * [in/out]
 *	߂l <= rr + nn
 * [flags]
 *	S	---	Doc'd
 *	Z	---	Doc'd
 *	Y	0/1	UnDoc	ʂ̏ʃoCgbit5Rs[܂B
 *	H	0/1	UnDoc	ʂ̏ʃoCg̃n[tL[łB
 *	X	0/1	UnDoc	ʂ̏ʃoCgbit3Rs[܂B
 *	V	---	Doc'd
 *	N	  0	Doc'd
 *	C	0/1	Doc'd
 */
unsigned short
z80_ADD16(Z80* z80, unsigned short rr, unsigned short nn)
{
	int tmp = rr + nn;
	F = (F & 0xc4) |					/* S,Z,V */
	    ((tmp >> 8) & 0x28) |				/* Y,X */
	    ((((rr & 0xfff) + (nn & 0xfff)) >> 8) & 0x10) |	/* H */
								/* N */
	    ((tmp >> 16) & 1);					/* C */
	return tmp;
}

/* 16rbgZ(L[)s܂B
 * [in/out]
 *	߂l <= rr + nn + F(C)
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂ̏ʃoCgbit5Rs[܂B
 *	H	0/1	UnDoc	ʂ̏ʃoCg̃n[tL[łB
 *	X	0/1	UnDoc	ʂ̏ʃoCgbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	  0	Doc'd
 *	C	0/1	Doc'd
 */
unsigned short
z80_ADC16(Z80* z80, unsigned short rr, unsigned short nn)
{
	int c = F & 1;
	int tmp = rr + nn + c;
	F = ((tmp >> 8) & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xffff) << 6) |				/* Z */
	    ((((rr & 0xfff) + (nn & 0xfff) + c) >> 8) & 0x10) |	/* H */
	    ((~(rr ^ nn) & (rr ^ tmp) & 0x8000) >> 13) |	/* V */
								/* N */
	    ((tmp >> 16) & 1);					/* C */
	return tmp;
}

/* 16rbgZ({[)s܂B
 * [in/out]
 *	߂l <= rr - nn - F(C)
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂ̏ʃoCgbit5Rs[܂B
 *	H	0/1	UnDoc	ʂ̏ʃoCg̃n[tL[łB
 *	X	0/1	UnDoc	ʂ̏ʃoCgbit3Rs[܂B
 *	V	0/1	Doc'd
 *	N	1  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned short
z80_SBC16(Z80* z80, unsigned short rr, unsigned short nn)
{
	int c = F & 1;
	int tmp = rr - nn - c;
	F = ((tmp >> 8) & 0xa8) |				/* S,Y,X */
	    (!(tmp & 0xffff) << 6) |				/* Z */
	    ((((rr & 0xfff) - (nn & 0xfff) - c) >> 8) & 0x10) |	/* H */
	    (((rr ^ nn) & (rr ^ tmp) & 0x8000) >> 13) |		/* V */
	    2 |							/* N */
	    ((tmp >> 16) & 1);					/* C */
	return tmp;
}

#endif /*Z80_ASM*/

/****************************************************************************
 *	Rotate and Shift Group
 ****************************************************************************/

/* [e[g(L[)s܂B
 * [in/out]
 *	߂l <= RL r
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_RL(Z80* z80, unsigned char r)
{
	unsigned char tmp = (r << 1) | (F & 1);
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r >> 7);		/* C */
	return tmp;
}

/* [e[g(T[L)s܂B
 * [in/out]
 *	߂l <= RLC r
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_RLC(Z80* z80, unsigned char r)
{
	unsigned char tmp = (r << 1) | (r >> 7);
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r >> 7);		/* C */
	return tmp;
}

/* E[e[g(L[)s܂B
 * [in/out]
 *	߂l <= RR r
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_RR(Z80* z80, unsigned char r)
{
	unsigned char tmp = (r >> 1) | (F << 7);
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r & 1);		/* C */
	return tmp;
}

/* E[e[g(T[L)s܂B
 * [in/out]
 *	߂l <= RRC r
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_RRC(Z80* z80, unsigned char r)
{
	unsigned char tmp = (r >> 1) | (r << 7);
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r & 1);		/* C */
	return tmp;
}

/* ZpVtgs܂B
 * [in/out]
 *	߂l <= (char)r << 1
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_SLA(Z80* z80, unsigned char r)
{
	unsigned char tmp = r << 1;
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r >> 7);		/* C */
	return tmp;
}

/* EZpVtgs܂B
 * [in/out]
 *	߂l <= (char)r >> 1
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_SRA(Z80* z80, unsigned char r)
{
	unsigned char tmp = (char)r >> 1;
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r & 1);		/* C */
	return tmp;
}

/* E_Vtgs܂B
 * [in/out]
 *	߂l <= (unsigned char)r >> 1
 * [flags]
 *	S	0/1	Doc'd
 *	Z	0/1	Doc'd
 *	Y	0/1	UnDoc	ʂbit5Rs[܂B
 *	H	0  	Doc'd
 *	X	0/1	UnDoc	ʂbit3Rs[܂B
 *	P	0/1	Doc'd
 *	N	0  	Doc'd
 *	C	0/1	Doc'd
 */
unsigned char
z80_SRL(Z80* z80, unsigned char r)
{
	unsigned char tmp = r >> 1;
	F = (tmp & 0xa8) |	/* S,Y,X */
	    (!tmp << 6) |	/* Z */
				/* H */
	    PARITY(tmp) |	/* P */
				/* N */
	    (r & 1);		/* C */
	return tmp;
}

/****************************************************************************
 *	Bit Set, Reset, and Test Group
 ****************************************************************************/

/* rbgeXgs܂B
 * [in/out]
 *	̂Ă <= r & (1 << n)
 * [flags]
 *	S	0/1	UnDoc	ʂbit7Rs[܂B
 *	Z	0/1	Doc'd
 *	Y	???	UnDoc	GĂ悭킩܂c(^^;
 *	H	  1	Doc'd
 *	X	???	UnDoc	GĂ悭킩܂c(^^;
 *	P	0/1	UnDoc	ZtOƓlB
 *	N	0  	Doc'd
 *	C	---	Doc'd
 */
void
z80_BIT(Z80* z80, unsigned char n, unsigned char r)
{
	unsigned char tmp = r & (1 << n);
	F = (tmp & 0x80) |		/* S */
	    (tmp ? 0x10 : 0x54) |	/* Z,H,P */
					/* N */
	    (F & 1);			/* C */
}

