/*	
 *	clipx11c.c
 *
 *	X11̐F
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2013 Naoyuki Sawa
 *
 *	* Fri Nov 22 00:11:19 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/****************************************************************************
 *	
 ****************************************************************************/

static const unsigned char TBL_X11Color[] = {								//! $XConsortium: rgb.txt,v 10.41 94/02/20 18:39:36 rws Exp $
255,250,250,'s','n','o','w',0,										//255 250 250 snow
248,248,255,'g','h','o','s','t',' ','w','h','i','t','e',0,						//248 248 255 ghost white
248,248,255,'G','h','o','s','t','W','h','i','t','e',0,							//248 248 255 GhostWhite
245,245,245,'w','h','i','t','e',' ','s','m','o','k','e',0,						//245 245 245 white smoke
245,245,245,'W','h','i','t','e','S','m','o','k','e',0,							//245 245 245 WhiteSmoke
220,220,220,'g','a','i','n','s','b','o','r','o',0,							//220 220 220 gainsboro
255,250,240,'f','l','o','r','a','l',' ','w','h','i','t','e',0,						//255 250 240 floral white
255,250,240,'F','l','o','r','a','l','W','h','i','t','e',0,						//255 250 240 FloralWhite
253,245,230,'o','l','d',' ','l','a','c','e',0,								//253 245 230 old lace
253,245,230,'O','l','d','L','a','c','e',0,								//253 245 230 OldLace
250,240,230,'l','i','n','e','n',0,									//250 240 230 linen
250,235,215,'a','n','t','i','q','u','e',' ','w','h','i','t','e',0,					//250 235 215 antique white
250,235,215,'A','n','t','i','q','u','e','W','h','i','t','e',0,						//250 235 215 AntiqueWhite
255,239,213,'p','a','p','a','y','a',' ','w','h','i','p',0,						//255 239 213 papaya whip
255,239,213,'P','a','p','a','y','a','W','h','i','p',0,							//255 239 213 PapayaWhip
255,235,205,'b','l','a','n','c','h','e','d',' ','a','l','m','o','n','d',0,				//255 235 205 blanched almond
255,235,205,'B','l','a','n','c','h','e','d','A','l','m','o','n','d',0,					//255 235 205 BlanchedAlmond
255,228,196,'b','i','s','q','u','e',0,									//255 228 196 bisque
255,218,185,'p','e','a','c','h',' ','p','u','f','f',0,							//255 218 185 peach puff
255,218,185,'P','e','a','c','h','P','u','f','f',0,							//255 218 185 PeachPuff
255,222,173,'n','a','v','a','j','o',' ','w','h','i','t','e',0,						//255 222 173 navajo white
255,222,173,'N','a','v','a','j','o','W','h','i','t','e',0,						//255 222 173 NavajoWhite
255,228,181,'m','o','c','c','a','s','i','n',0,								//255 228 181 moccasin
255,248,220,'c','o','r','n','s','i','l','k',0,								//255 248 220 cornsilk
255,255,240,'i','v','o','r','y',0,									//255 255 240 ivory
255,250,205,'l','e','m','o','n',' ','c','h','i','f','f','o','n',0,					//255 250 205 lemon chiffon
255,250,205,'L','e','m','o','n','C','h','i','f','f','o','n',0,						//255 250 205 LemonChiffon
255,245,238,'s','e','a','s','h','e','l','l',0,								//255 245 238 seashell
240,255,240,'h','o','n','e','y','d','e','w',0,								//240 255 240 honeydew
245,255,250,'m','i','n','t',' ','c','r','e','a','m',0,							//245 255 250 mint cream
245,255,250,'M','i','n','t','C','r','e','a','m',0,							//245 255 250 MintCream
240,255,255,'a','z','u','r','e',0,									//240 255 255 azure
240,248,255,'a','l','i','c','e',' ','b','l','u','e',0,							//240 248 255 alice blue
240,248,255,'A','l','i','c','e','B','l','u','e',0,							//240 248 255 AliceBlue
230,230,250,'l','a','v','e','n','d','e','r',0,								//230 230 250 lavender
255,240,245,'l','a','v','e','n','d','e','r',' ','b','l','u','s','h',0,					//255 240 245 lavender blush
255,240,245,'L','a','v','e','n','d','e','r','B','l','u','s','h',0,					//255 240 245 LavenderBlush
255,228,225,'m','i','s','t','y',' ','r','o','s','e',0,							//255 228 225 misty rose
255,228,225,'M','i','s','t','y','R','o','s','e',0,							//255 228 225 MistyRose
255,255,255,'w','h','i','t','e',0,									//255 255 255 white
  0,  0,  0,'b','l','a','c','k',0,									//  0   0   0 black
 47, 79, 79,'d','a','r','k',' ','s','l','a','t','e',' ','g','r','a','y',0,				// 47  79  79 dark slate gray
 47, 79, 79,'D','a','r','k','S','l','a','t','e','G','r','a','y',0,					// 47  79  79 DarkSlateGray
 47, 79, 79,'d','a','r','k',' ','s','l','a','t','e',' ','g','r','e','y',0,				// 47  79  79 dark slate grey
 47, 79, 79,'D','a','r','k','S','l','a','t','e','G','r','e','y',0,					// 47  79  79 DarkSlateGrey
105,105,105,'d','i','m',' ','g','r','a','y',0,								//105 105 105 dim gray
105,105,105,'D','i','m','G','r','a','y',0,								//105 105 105 DimGray
105,105,105,'d','i','m',' ','g','r','e','y',0,								//105 105 105 dim grey
105,105,105,'D','i','m','G','r','e','y',0,								//105 105 105 DimGrey
112,128,144,'s','l','a','t','e',' ','g','r','a','y',0,							//112 128 144 slate gray
112,128,144,'S','l','a','t','e','G','r','a','y',0,							//112 128 144 SlateGray
112,128,144,'s','l','a','t','e',' ','g','r','e','y',0,							//112 128 144 slate grey
112,128,144,'S','l','a','t','e','G','r','e','y',0,							//112 128 144 SlateGrey
119,136,153,'l','i','g','h','t',' ','s','l','a','t','e',' ','g','r','a','y',0,				//119 136 153 light slate gray
119,136,153,'L','i','g','h','t','S','l','a','t','e','G','r','a','y',0,					//119 136 153 LightSlateGray
119,136,153,'l','i','g','h','t',' ','s','l','a','t','e',' ','g','r','e','y',0,				//119 136 153 light slate grey
119,136,153,'L','i','g','h','t','S','l','a','t','e','G','r','e','y',0,					//119 136 153 LightSlateGrey
190,190,190,'g','r','a','y',0,										//190 190 190 gray
190,190,190,'g','r','e','y',0,										//190 190 190 grey
211,211,211,'l','i','g','h','t',' ','g','r','e','y',0,							//211 211 211 light grey
211,211,211,'L','i','g','h','t','G','r','e','y',0,							//211 211 211 LightGrey
211,211,211,'l','i','g','h','t',' ','g','r','a','y',0,							//211 211 211 light gray
211,211,211,'L','i','g','h','t','G','r','a','y',0,							//211 211 211 LightGray
 25, 25,112,'m','i','d','n','i','g','h','t',' ','b','l','u','e',0,					// 25  25 112 midnight blue
 25, 25,112,'M','i','d','n','i','g','h','t','B','l','u','e',0,						// 25  25 112 MidnightBlue
  0,  0,128,'n','a','v','y',0,										//  0   0 128 navy
  0,  0,128,'n','a','v','y',' ','b','l','u','e',0,							//  0   0 128 navy blue
  0,  0,128,'N','a','v','y','B','l','u','e',0,								//  0   0 128 NavyBlue
100,149,237,'c','o','r','n','f','l','o','w','e','r',' ','b','l','u','e',0,				//100 149 237 cornflower blue
100,149,237,'C','o','r','n','f','l','o','w','e','r','B','l','u','e',0,					//100 149 237 CornflowerBlue
 72, 61,139,'d','a','r','k',' ','s','l','a','t','e',' ','b','l','u','e',0,				// 72  61 139 dark slate blue
 72, 61,139,'D','a','r','k','S','l','a','t','e','B','l','u','e',0,					// 72  61 139 DarkSlateBlue
106, 90,205,'s','l','a','t','e',' ','b','l','u','e',0,							//106  90 205 slate blue
106, 90,205,'S','l','a','t','e','B','l','u','e',0,							//106  90 205 SlateBlue
123,104,238,'m','e','d','i','u','m',' ','s','l','a','t','e',' ','b','l','u','e',0,			//123 104 238 medium slate blue
123,104,238,'M','e','d','i','u','m','S','l','a','t','e','B','l','u','e',0,				//123 104 238 MediumSlateBlue
132,112,255,'l','i','g','h','t',' ','s','l','a','t','e',' ','b','l','u','e',0,				//132 112 255 light slate blue
132,112,255,'L','i','g','h','t','S','l','a','t','e','B','l','u','e',0,					//132 112 255 LightSlateBlue
  0,  0,205,'m','e','d','i','u','m',' ','b','l','u','e',0,						//  0   0 205 medium blue
  0,  0,205,'M','e','d','i','u','m','B','l','u','e',0,							//  0   0 205 MediumBlue
 65,105,225,'r','o','y','a','l',' ','b','l','u','e',0,							// 65 105 225 royal blue
 65,105,225,'R','o','y','a','l','B','l','u','e',0,							// 65 105 225 RoyalBlue
  0,  0,255,'b','l','u','e',0,										//  0   0 255 blue
 30,144,255,'d','o','d','g','e','r',' ','b','l','u','e',0,						// 30 144 255 dodger blue
 30,144,255,'D','o','d','g','e','r','B','l','u','e',0,							// 30 144 255 DodgerBlue
  0,191,255,'d','e','e','p',' ','s','k','y',' ','b','l','u','e',0,					//  0 191 255 deep sky blue
  0,191,255,'D','e','e','p','S','k','y','B','l','u','e',0,						//  0 191 255 DeepSkyBlue
135,206,235,'s','k','y',' ','b','l','u','e',0,								//135 206 235 sky blue
135,206,235,'S','k','y','B','l','u','e',0,								//135 206 235 SkyBlue
135,206,250,'l','i','g','h','t',' ','s','k','y',' ','b','l','u','e',0,					//135 206 250 light sky blue
135,206,250,'L','i','g','h','t','S','k','y','B','l','u','e',0,						//135 206 250 LightSkyBlue
 70,130,180,'s','t','e','e','l',' ','b','l','u','e',0,							// 70 130 180 steel blue
 70,130,180,'S','t','e','e','l','B','l','u','e',0,							// 70 130 180 SteelBlue
176,196,222,'l','i','g','h','t',' ','s','t','e','e','l',' ','b','l','u','e',0,				//176 196 222 light steel blue
176,196,222,'L','i','g','h','t','S','t','e','e','l','B','l','u','e',0,					//176 196 222 LightSteelBlue
173,216,230,'l','i','g','h','t',' ','b','l','u','e',0,							//173 216 230 light blue
173,216,230,'L','i','g','h','t','B','l','u','e',0,							//173 216 230 LightBlue
176,224,230,'p','o','w','d','e','r',' ','b','l','u','e',0,						//176 224 230 powder blue
176,224,230,'P','o','w','d','e','r','B','l','u','e',0,							//176 224 230 PowderBlue
175,238,238,'p','a','l','e',' ','t','u','r','q','u','o','i','s','e',0,					//175 238 238 pale turquoise
175,238,238,'P','a','l','e','T','u','r','q','u','o','i','s','e',0,					//175 238 238 PaleTurquoise
  0,206,209,'d','a','r','k',' ','t','u','r','q','u','o','i','s','e',0,					//  0 206 209 dark turquoise
  0,206,209,'D','a','r','k','T','u','r','q','u','o','i','s','e',0,					//  0 206 209 DarkTurquoise
 72,209,204,'m','e','d','i','u','m',' ','t','u','r','q','u','o','i','s','e',0,				// 72 209 204 medium turquoise
 72,209,204,'M','e','d','i','u','m','T','u','r','q','u','o','i','s','e',0,				// 72 209 204 MediumTurquoise
 64,224,208,'t','u','r','q','u','o','i','s','e',0,							// 64 224 208 turquoise
  0,255,255,'c','y','a','n',0,										//  0 255 255 cyan
224,255,255,'l','i','g','h','t',' ','c','y','a','n',0,							//224 255 255 light cyan
224,255,255,'L','i','g','h','t','C','y','a','n',0,							//224 255 255 LightCyan
 95,158,160,'c','a','d','e','t',' ','b','l','u','e',0,							// 95 158 160 cadet blue
 95,158,160,'C','a','d','e','t','B','l','u','e',0,							// 95 158 160 CadetBlue
102,205,170,'m','e','d','i','u','m',' ','a','q','u','a','m','a','r','i','n','e',0,			//102 205 170 medium aquamarine
102,205,170,'M','e','d','i','u','m','A','q','u','a','m','a','r','i','n','e',0,				//102 205 170 MediumAquamarine
127,255,212,'a','q','u','a','m','a','r','i','n','e',0,							//127 255 212 aquamarine
  0,100,  0,'d','a','r','k',' ','g','r','e','e','n',0,							//  0 100   0 dark green
  0,100,  0,'D','a','r','k','G','r','e','e','n',0,							//  0 100   0 DarkGreen
 85,107, 47,'d','a','r','k',' ','o','l','i','v','e',' ','g','r','e','e','n',0,				// 85 107  47 dark olive green
 85,107, 47,'D','a','r','k','O','l','i','v','e','G','r','e','e','n',0,					// 85 107  47 DarkOliveGreen
143,188,143,'d','a','r','k',' ','s','e','a',' ','g','r','e','e','n',0,					//143 188 143 dark sea green
143,188,143,'D','a','r','k','S','e','a','G','r','e','e','n',0,						//143 188 143 DarkSeaGreen
 46,139, 87,'s','e','a',' ','g','r','e','e','n',0,							// 46 139  87 sea green
 46,139, 87,'S','e','a','G','r','e','e','n',0,								// 46 139  87 SeaGreen
 60,179,113,'m','e','d','i','u','m',' ','s','e','a',' ','g','r','e','e','n',0,				// 60 179 113 medium sea green
 60,179,113,'M','e','d','i','u','m','S','e','a','G','r','e','e','n',0,					// 60 179 113 MediumSeaGreen
 32,178,170,'l','i','g','h','t',' ','s','e','a',' ','g','r','e','e','n',0,				// 32 178 170 light sea green
 32,178,170,'L','i','g','h','t','S','e','a','G','r','e','e','n',0,					// 32 178 170 LightSeaGreen
152,251,152,'p','a','l','e',' ','g','r','e','e','n',0,							//152 251 152 pale green
152,251,152,'P','a','l','e','G','r','e','e','n',0,							//152 251 152 PaleGreen
  0,255,127,'s','p','r','i','n','g',' ','g','r','e','e','n',0,						//  0 255 127 spring green
  0,255,127,'S','p','r','i','n','g','G','r','e','e','n',0,						//  0 255 127 SpringGreen
124,252,  0,'l','a','w','n',' ','g','r','e','e','n',0,							//124 252   0 lawn green
124,252,  0,'L','a','w','n','G','r','e','e','n',0,							//124 252   0 LawnGreen
  0,255,  0,'g','r','e','e','n',0,									//  0 255   0 green
127,255,  0,'c','h','a','r','t','r','e','u','s','e',0,							//127 255   0 chartreuse
  0,250,154,'m','e','d','i','u','m',' ','s','p','r','i','n','g',' ','g','r','e','e','n',0,		//  0 250 154 medium spring green
  0,250,154,'M','e','d','i','u','m','S','p','r','i','n','g','G','r','e','e','n',0,			//  0 250 154 MediumSpringGreen
173,255, 47,'g','r','e','e','n',' ','y','e','l','l','o','w',0,						//173 255  47 green yellow
173,255, 47,'G','r','e','e','n','Y','e','l','l','o','w',0,						//173 255  47 GreenYellow
 50,205, 50,'l','i','m','e',' ','g','r','e','e','n',0,							// 50 205  50 lime green
 50,205, 50,'L','i','m','e','G','r','e','e','n',0,							// 50 205  50 LimeGreen
154,205, 50,'y','e','l','l','o','w',' ','g','r','e','e','n',0,						//154 205  50 yellow green
154,205, 50,'Y','e','l','l','o','w','G','r','e','e','n',0,						//154 205  50 YellowGreen
 34,139, 34,'f','o','r','e','s','t',' ','g','r','e','e','n',0,						// 34 139  34 forest green
 34,139, 34,'F','o','r','e','s','t','G','r','e','e','n',0,						// 34 139  34 ForestGreen
107,142, 35,'o','l','i','v','e',' ','d','r','a','b',0,							//107 142  35 olive drab
107,142, 35,'O','l','i','v','e','D','r','a','b',0,							//107 142  35 OliveDrab
189,183,107,'d','a','r','k',' ','k','h','a','k','i',0,							//189 183 107 dark khaki
189,183,107,'D','a','r','k','K','h','a','k','i',0,							//189 183 107 DarkKhaki
240,230,140,'k','h','a','k','i',0,									//240 230 140 khaki
238,232,170,'p','a','l','e',' ','g','o','l','d','e','n','r','o','d',0,					//238 232 170 pale goldenrod
238,232,170,'P','a','l','e','G','o','l','d','e','n','r','o','d',0,					//238 232 170 PaleGoldenrod
250,250,210,'l','i','g','h','t',' ','g','o','l','d','e','n','r','o','d',' ','y','e','l','l','o','w',0,	//250 250 210 light goldenrod yellow
250,250,210,'L','i','g','h','t','G','o','l','d','e','n','r','o','d','Y','e','l','l','o','w',0,		//250 250 210 LightGoldenrodYellow
255,255,224,'l','i','g','h','t',' ','y','e','l','l','o','w',0,						//255 255 224 light yellow
255,255,224,'L','i','g','h','t','Y','e','l','l','o','w',0,						//255 255 224 LightYellow
255,255,  0,'y','e','l','l','o','w',0,									//255 255   0 yellow
255,215,  0,'g','o','l','d',0,										//255 215   0 gold
238,221,130,'l','i','g','h','t',' ','g','o','l','d','e','n','r','o','d',0,				//238 221 130 light goldenrod
238,221,130,'L','i','g','h','t','G','o','l','d','e','n','r','o','d',0,					//238 221 130 LightGoldenrod
218,165, 32,'g','o','l','d','e','n','r','o','d',0,							//218 165  32 goldenrod
184,134, 11,'d','a','r','k',' ','g','o','l','d','e','n','r','o','d',0,					//184 134  11 dark goldenrod
184,134, 11,'D','a','r','k','G','o','l','d','e','n','r','o','d',0,					//184 134  11 DarkGoldenrod
188,143,143,'r','o','s','y',' ','b','r','o','w','n',0,							//188 143 143 rosy brown
188,143,143,'R','o','s','y','B','r','o','w','n',0,							//188 143 143 RosyBrown
205, 92, 92,'i','n','d','i','a','n',' ','r','e','d',0,							//205  92  92 indian red
205, 92, 92,'I','n','d','i','a','n','R','e','d',0,							//205  92  92 IndianRed
139, 69, 19,'s','a','d','d','l','e',' ','b','r','o','w','n',0,						//139  69  19 saddle brown
139, 69, 19,'S','a','d','d','l','e','B','r','o','w','n',0,						//139  69  19 SaddleBrown
160, 82, 45,'s','i','e','n','n','a',0,									//160  82  45 sienna
205,133, 63,'p','e','r','u',0,										//205 133  63 peru
222,184,135,'b','u','r','l','y','w','o','o','d',0,							//222 184 135 burlywood
245,245,220,'b','e','i','g','e',0,									//245 245 220 beige
245,222,179,'w','h','e','a','t',0,									//245 222 179 wheat
244,164, 96,'s','a','n','d','y',' ','b','r','o','w','n',0,						//244 164  96 sandy brown
244,164, 96,'S','a','n','d','y','B','r','o','w','n',0,							//244 164  96 SandyBrown
210,180,140,'t','a','n',0,										//210 180 140 tan
210,105, 30,'c','h','o','c','o','l','a','t','e',0,							//210 105  30 chocolate
178, 34, 34,'f','i','r','e','b','r','i','c','k',0,							//178  34  34 firebrick
165, 42, 42,'b','r','o','w','n',0,									//165  42  42 brown
233,150,122,'d','a','r','k',' ','s','a','l','m','o','n',0,						//233 150 122 dark salmon
233,150,122,'D','a','r','k','S','a','l','m','o','n',0,							//233 150 122 DarkSalmon
250,128,114,'s','a','l','m','o','n',0,									//250 128 114 salmon
255,160,122,'l','i','g','h','t',' ','s','a','l','m','o','n',0,						//255 160 122 light salmon
255,160,122,'L','i','g','h','t','S','a','l','m','o','n',0,						//255 160 122 LightSalmon
255,165,  0,'o','r','a','n','g','e',0,									//255 165   0 orange
255,140,  0,'d','a','r','k',' ','o','r','a','n','g','e',0,						//255 140   0 dark orange
255,140,  0,'D','a','r','k','O','r','a','n','g','e',0,							//255 140   0 DarkOrange
255,127, 80,'c','o','r','a','l',0,									//255 127  80 coral
240,128,128,'l','i','g','h','t',' ','c','o','r','a','l',0,						//240 128 128 light coral
240,128,128,'L','i','g','h','t','C','o','r','a','l',0,							//240 128 128 LightCoral
255, 99, 71,'t','o','m','a','t','o',0,									//255  99  71 tomato
255, 69,  0,'o','r','a','n','g','e',' ','r','e','d',0,							//255  69   0 orange red
255, 69,  0,'O','r','a','n','g','e','R','e','d',0,							//255  69   0 OrangeRed
255,  0,  0,'r','e','d',0,										//255   0   0 red
255,105,180,'h','o','t',' ','p','i','n','k',0,								//255 105 180 hot pink
255,105,180,'H','o','t','P','i','n','k',0,								//255 105 180 HotPink
255, 20,147,'d','e','e','p',' ','p','i','n','k',0,							//255  20 147 deep pink
255, 20,147,'D','e','e','p','P','i','n','k',0,								//255  20 147 DeepPink
255,192,203,'p','i','n','k',0,										//255 192 203 pink
255,182,193,'l','i','g','h','t',' ','p','i','n','k',0,							//255 182 193 light pink
255,182,193,'L','i','g','h','t','P','i','n','k',0,							//255 182 193 LightPink
219,112,147,'p','a','l','e',' ','v','i','o','l','e','t',' ','r','e','d',0,				//219 112 147 pale violet red
219,112,147,'P','a','l','e','V','i','o','l','e','t','R','e','d',0,					//219 112 147 PaleVioletRed
176, 48, 96,'m','a','r','o','o','n',0,									//176  48  96 maroon
199, 21,133,'m','e','d','i','u','m',' ','v','i','o','l','e','t',' ','r','e','d',0,			//199  21 133 medium violet red
199, 21,133,'M','e','d','i','u','m','V','i','o','l','e','t','R','e','d',0,				//199  21 133 MediumVioletRed
208, 32,144,'v','i','o','l','e','t',' ','r','e','d',0,							//208  32 144 violet red
208, 32,144,'V','i','o','l','e','t','R','e','d',0,							//208  32 144 VioletRed
255,  0,255,'m','a','g','e','n','t','a',0,								//255   0 255 magenta
238,130,238,'v','i','o','l','e','t',0,									//238 130 238 violet
221,160,221,'p','l','u','m',0,										//221 160 221 plum
218,112,214,'o','r','c','h','i','d',0,									//218 112 214 orchid
186, 85,211,'m','e','d','i','u','m',' ','o','r','c','h','i','d',0,					//186  85 211 medium orchid
186, 85,211,'M','e','d','i','u','m','O','r','c','h','i','d',0,						//186  85 211 MediumOrchid
153, 50,204,'d','a','r','k',' ','o','r','c','h','i','d',0,						//153  50 204 dark orchid
153, 50,204,'D','a','r','k','O','r','c','h','i','d',0,							//153  50 204 DarkOrchid
148,  0,211,'d','a','r','k',' ','v','i','o','l','e','t',0,						//148   0 211 dark violet
148,  0,211,'D','a','r','k','V','i','o','l','e','t',0,							//148   0 211 DarkViolet
138, 43,226,'b','l','u','e',' ','v','i','o','l','e','t',0,						//138  43 226 blue violet
138, 43,226,'B','l','u','e','V','i','o','l','e','t',0,							//138  43 226 BlueViolet
160, 32,240,'p','u','r','p','l','e',0,									//160  32 240 purple
147,112,219,'m','e','d','i','u','m',' ','p','u','r','p','l','e',0,					//147 112 219 medium purple
147,112,219,'M','e','d','i','u','m','P','u','r','p','l','e',0,						//147 112 219 MediumPurple
216,191,216,'t','h','i','s','t','l','e',0,								//216 191 216 thistle
255,250,250,'s','n','o','w','1',0,									//255 250 250 snow1
238,233,233,'s','n','o','w','2',0,									//238 233 233 snow2
205,201,201,'s','n','o','w','3',0,									//205 201 201 snow3
139,137,137,'s','n','o','w','4',0,									//139 137 137 snow4
255,245,238,'s','e','a','s','h','e','l','l','1',0,							//255 245 238 seashell1
238,229,222,'s','e','a','s','h','e','l','l','2',0,							//238 229 222 seashell2
205,197,191,'s','e','a','s','h','e','l','l','3',0,							//205 197 191 seashell3
139,134,130,'s','e','a','s','h','e','l','l','4',0,							//139 134 130 seashell4
255,239,219,'A','n','t','i','q','u','e','W','h','i','t','e','1',0,					//255 239 219 AntiqueWhite1
238,223,204,'A','n','t','i','q','u','e','W','h','i','t','e','2',0,					//238 223 204 AntiqueWhite2
205,192,176,'A','n','t','i','q','u','e','W','h','i','t','e','3',0,					//205 192 176 AntiqueWhite3
139,131,120,'A','n','t','i','q','u','e','W','h','i','t','e','4',0,					//139 131 120 AntiqueWhite4
255,228,196,'b','i','s','q','u','e','1',0,								//255 228 196 bisque1
238,213,183,'b','i','s','q','u','e','2',0,								//238 213 183 bisque2
205,183,158,'b','i','s','q','u','e','3',0,								//205 183 158 bisque3
139,125,107,'b','i','s','q','u','e','4',0,								//139 125 107 bisque4
255,218,185,'P','e','a','c','h','P','u','f','f','1',0,							//255 218 185 PeachPuff1
238,203,173,'P','e','a','c','h','P','u','f','f','2',0,							//238 203 173 PeachPuff2
205,175,149,'P','e','a','c','h','P','u','f','f','3',0,							//205 175 149 PeachPuff3
139,119,101,'P','e','a','c','h','P','u','f','f','4',0,							//139 119 101 PeachPuff4
255,222,173,'N','a','v','a','j','o','W','h','i','t','e','1',0,						//255 222 173 NavajoWhite1
238,207,161,'N','a','v','a','j','o','W','h','i','t','e','2',0,						//238 207 161 NavajoWhite2
205,179,139,'N','a','v','a','j','o','W','h','i','t','e','3',0,						//205 179 139 NavajoWhite3
139,121, 94,'N','a','v','a','j','o','W','h','i','t','e','4',0,						//139 121  94 NavajoWhite4
255,250,205,'L','e','m','o','n','C','h','i','f','f','o','n','1',0,					//255 250 205 LemonChiffon1
238,233,191,'L','e','m','o','n','C','h','i','f','f','o','n','2',0,					//238 233 191 LemonChiffon2
205,201,165,'L','e','m','o','n','C','h','i','f','f','o','n','3',0,					//205 201 165 LemonChiffon3
139,137,112,'L','e','m','o','n','C','h','i','f','f','o','n','4',0,					//139 137 112 LemonChiffon4
255,248,220,'c','o','r','n','s','i','l','k','1',0,							//255 248 220 cornsilk1
238,232,205,'c','o','r','n','s','i','l','k','2',0,							//238 232 205 cornsilk2
205,200,177,'c','o','r','n','s','i','l','k','3',0,							//205 200 177 cornsilk3
139,136,120,'c','o','r','n','s','i','l','k','4',0,							//139 136 120 cornsilk4
255,255,240,'i','v','o','r','y','1',0,									//255 255 240 ivory1
238,238,224,'i','v','o','r','y','2',0,									//238 238 224 ivory2
205,205,193,'i','v','o','r','y','3',0,									//205 205 193 ivory3
139,139,131,'i','v','o','r','y','4',0,									//139 139 131 ivory4
240,255,240,'h','o','n','e','y','d','e','w','1',0,							//240 255 240 honeydew1
224,238,224,'h','o','n','e','y','d','e','w','2',0,							//224 238 224 honeydew2
193,205,193,'h','o','n','e','y','d','e','w','3',0,							//193 205 193 honeydew3
131,139,131,'h','o','n','e','y','d','e','w','4',0,							//131 139 131 honeydew4
255,240,245,'L','a','v','e','n','d','e','r','B','l','u','s','h','1',0,					//255 240 245 LavenderBlush1
238,224,229,'L','a','v','e','n','d','e','r','B','l','u','s','h','2',0,					//238 224 229 LavenderBlush2
205,193,197,'L','a','v','e','n','d','e','r','B','l','u','s','h','3',0,					//205 193 197 LavenderBlush3
139,131,134,'L','a','v','e','n','d','e','r','B','l','u','s','h','4',0,					//139 131 134 LavenderBlush4
255,228,225,'M','i','s','t','y','R','o','s','e','1',0,							//255 228 225 MistyRose1
238,213,210,'M','i','s','t','y','R','o','s','e','2',0,							//238 213 210 MistyRose2
205,183,181,'M','i','s','t','y','R','o','s','e','3',0,							//205 183 181 MistyRose3
139,125,123,'M','i','s','t','y','R','o','s','e','4',0,							//139 125 123 MistyRose4
240,255,255,'a','z','u','r','e','1',0,									//240 255 255 azure1
224,238,238,'a','z','u','r','e','2',0,									//224 238 238 azure2
193,205,205,'a','z','u','r','e','3',0,									//193 205 205 azure3
131,139,139,'a','z','u','r','e','4',0,									//131 139 139 azure4
131,111,255,'S','l','a','t','e','B','l','u','e','1',0,							//131 111 255 SlateBlue1
122,103,238,'S','l','a','t','e','B','l','u','e','2',0,							//122 103 238 SlateBlue2
105, 89,205,'S','l','a','t','e','B','l','u','e','3',0,							//105  89 205 SlateBlue3
 71, 60,139,'S','l','a','t','e','B','l','u','e','4',0,							// 71  60 139 SlateBlue4
 72,118,255,'R','o','y','a','l','B','l','u','e','1',0,							// 72 118 255 RoyalBlue1
 67,110,238,'R','o','y','a','l','B','l','u','e','2',0,							// 67 110 238 RoyalBlue2
 58, 95,205,'R','o','y','a','l','B','l','u','e','3',0,							// 58  95 205 RoyalBlue3
 39, 64,139,'R','o','y','a','l','B','l','u','e','4',0,							// 39  64 139 RoyalBlue4
  0,  0,255,'b','l','u','e','1',0,									//  0   0 255 blue1
  0,  0,238,'b','l','u','e','2',0,									//  0   0 238 blue2
  0,  0,205,'b','l','u','e','3',0,									//  0   0 205 blue3
  0,  0,139,'b','l','u','e','4',0,									//  0   0 139 blue4
 30,144,255,'D','o','d','g','e','r','B','l','u','e','1',0,						// 30 144 255 DodgerBlue1
 28,134,238,'D','o','d','g','e','r','B','l','u','e','2',0,						// 28 134 238 DodgerBlue2
 24,116,205,'D','o','d','g','e','r','B','l','u','e','3',0,						// 24 116 205 DodgerBlue3
 16, 78,139,'D','o','d','g','e','r','B','l','u','e','4',0,						// 16  78 139 DodgerBlue4
 99,184,255,'S','t','e','e','l','B','l','u','e','1',0,							// 99 184 255 SteelBlue1
 92,172,238,'S','t','e','e','l','B','l','u','e','2',0,							// 92 172 238 SteelBlue2
 79,148,205,'S','t','e','e','l','B','l','u','e','3',0,							// 79 148 205 SteelBlue3
 54,100,139,'S','t','e','e','l','B','l','u','e','4',0,							// 54 100 139 SteelBlue4
  0,191,255,'D','e','e','p','S','k','y','B','l','u','e','1',0,						//  0 191 255 DeepSkyBlue1
  0,178,238,'D','e','e','p','S','k','y','B','l','u','e','2',0,						//  0 178 238 DeepSkyBlue2
  0,154,205,'D','e','e','p','S','k','y','B','l','u','e','3',0,						//  0 154 205 DeepSkyBlue3
  0,104,139,'D','e','e','p','S','k','y','B','l','u','e','4',0,						//  0 104 139 DeepSkyBlue4
135,206,255,'S','k','y','B','l','u','e','1',0,								//135 206 255 SkyBlue1
126,192,238,'S','k','y','B','l','u','e','2',0,								//126 192 238 SkyBlue2
108,166,205,'S','k','y','B','l','u','e','3',0,								//108 166 205 SkyBlue3
 74,112,139,'S','k','y','B','l','u','e','4',0,								// 74 112 139 SkyBlue4
176,226,255,'L','i','g','h','t','S','k','y','B','l','u','e','1',0,					//176 226 255 LightSkyBlue1
164,211,238,'L','i','g','h','t','S','k','y','B','l','u','e','2',0,					//164 211 238 LightSkyBlue2
141,182,205,'L','i','g','h','t','S','k','y','B','l','u','e','3',0,					//141 182 205 LightSkyBlue3
 96,123,139,'L','i','g','h','t','S','k','y','B','l','u','e','4',0,					// 96 123 139 LightSkyBlue4
198,226,255,'S','l','a','t','e','G','r','a','y','1',0,							//198 226 255 SlateGray1
185,211,238,'S','l','a','t','e','G','r','a','y','2',0,							//185 211 238 SlateGray2
159,182,205,'S','l','a','t','e','G','r','a','y','3',0,							//159 182 205 SlateGray3
108,123,139,'S','l','a','t','e','G','r','a','y','4',0,							//108 123 139 SlateGray4
202,225,255,'L','i','g','h','t','S','t','e','e','l','B','l','u','e','1',0,				//202 225 255 LightSteelBlue1
188,210,238,'L','i','g','h','t','S','t','e','e','l','B','l','u','e','2',0,				//188 210 238 LightSteelBlue2
162,181,205,'L','i','g','h','t','S','t','e','e','l','B','l','u','e','3',0,				//162 181 205 LightSteelBlue3
110,123,139,'L','i','g','h','t','S','t','e','e','l','B','l','u','e','4',0,				//110 123 139 LightSteelBlue4
191,239,255,'L','i','g','h','t','B','l','u','e','1',0,							//191 239 255 LightBlue1
178,223,238,'L','i','g','h','t','B','l','u','e','2',0,							//178 223 238 LightBlue2
154,192,205,'L','i','g','h','t','B','l','u','e','3',0,							//154 192 205 LightBlue3
104,131,139,'L','i','g','h','t','B','l','u','e','4',0,							//104 131 139 LightBlue4
224,255,255,'L','i','g','h','t','C','y','a','n','1',0,							//224 255 255 LightCyan1
209,238,238,'L','i','g','h','t','C','y','a','n','2',0,							//209 238 238 LightCyan2
180,205,205,'L','i','g','h','t','C','y','a','n','3',0,							//180 205 205 LightCyan3
122,139,139,'L','i','g','h','t','C','y','a','n','4',0,							//122 139 139 LightCyan4
187,255,255,'P','a','l','e','T','u','r','q','u','o','i','s','e','1',0,					//187 255 255 PaleTurquoise1
174,238,238,'P','a','l','e','T','u','r','q','u','o','i','s','e','2',0,					//174 238 238 PaleTurquoise2
150,205,205,'P','a','l','e','T','u','r','q','u','o','i','s','e','3',0,					//150 205 205 PaleTurquoise3
102,139,139,'P','a','l','e','T','u','r','q','u','o','i','s','e','4',0,					//102 139 139 PaleTurquoise4
152,245,255,'C','a','d','e','t','B','l','u','e','1',0,							//152 245 255 CadetBlue1
142,229,238,'C','a','d','e','t','B','l','u','e','2',0,							//142 229 238 CadetBlue2
122,197,205,'C','a','d','e','t','B','l','u','e','3',0,							//122 197 205 CadetBlue3
 83,134,139,'C','a','d','e','t','B','l','u','e','4',0,							// 83 134 139 CadetBlue4
  0,245,255,'t','u','r','q','u','o','i','s','e','1',0,							//  0 245 255 turquoise1
  0,229,238,'t','u','r','q','u','o','i','s','e','2',0,							//  0 229 238 turquoise2
  0,197,205,'t','u','r','q','u','o','i','s','e','3',0,							//  0 197 205 turquoise3
  0,134,139,'t','u','r','q','u','o','i','s','e','4',0,							//  0 134 139 turquoise4
  0,255,255,'c','y','a','n','1',0,									//  0 255 255 cyan1
  0,238,238,'c','y','a','n','2',0,									//  0 238 238 cyan2
  0,205,205,'c','y','a','n','3',0,									//  0 205 205 cyan3
  0,139,139,'c','y','a','n','4',0,									//  0 139 139 cyan4
151,255,255,'D','a','r','k','S','l','a','t','e','G','r','a','y','1',0,					//151 255 255 DarkSlateGray1
141,238,238,'D','a','r','k','S','l','a','t','e','G','r','a','y','2',0,					//141 238 238 DarkSlateGray2
121,205,205,'D','a','r','k','S','l','a','t','e','G','r','a','y','3',0,					//121 205 205 DarkSlateGray3
 82,139,139,'D','a','r','k','S','l','a','t','e','G','r','a','y','4',0,					// 82 139 139 DarkSlateGray4
127,255,212,'a','q','u','a','m','a','r','i','n','e','1',0,						//127 255 212 aquamarine1
118,238,198,'a','q','u','a','m','a','r','i','n','e','2',0,						//118 238 198 aquamarine2
102,205,170,'a','q','u','a','m','a','r','i','n','e','3',0,						//102 205 170 aquamarine3
 69,139,116,'a','q','u','a','m','a','r','i','n','e','4',0,						// 69 139 116 aquamarine4
193,255,193,'D','a','r','k','S','e','a','G','r','e','e','n','1',0,					//193 255 193 DarkSeaGreen1
180,238,180,'D','a','r','k','S','e','a','G','r','e','e','n','2',0,					//180 238 180 DarkSeaGreen2
155,205,155,'D','a','r','k','S','e','a','G','r','e','e','n','3',0,					//155 205 155 DarkSeaGreen3
105,139,105,'D','a','r','k','S','e','a','G','r','e','e','n','4',0,					//105 139 105 DarkSeaGreen4
 84,255,159,'S','e','a','G','r','e','e','n','1',0,							// 84 255 159 SeaGreen1
 78,238,148,'S','e','a','G','r','e','e','n','2',0,							// 78 238 148 SeaGreen2
 67,205,128,'S','e','a','G','r','e','e','n','3',0,							// 67 205 128 SeaGreen3
 46,139, 87,'S','e','a','G','r','e','e','n','4',0,							// 46 139  87 SeaGreen4
154,255,154,'P','a','l','e','G','r','e','e','n','1',0,							//154 255 154 PaleGreen1
144,238,144,'P','a','l','e','G','r','e','e','n','2',0,							//144 238 144 PaleGreen2
124,205,124,'P','a','l','e','G','r','e','e','n','3',0,							//124 205 124 PaleGreen3
 84,139, 84,'P','a','l','e','G','r','e','e','n','4',0,							// 84 139  84 PaleGreen4
  0,255,127,'S','p','r','i','n','g','G','r','e','e','n','1',0,						//  0 255 127 SpringGreen1
  0,238,118,'S','p','r','i','n','g','G','r','e','e','n','2',0,						//  0 238 118 SpringGreen2
  0,205,102,'S','p','r','i','n','g','G','r','e','e','n','3',0,						//  0 205 102 SpringGreen3
  0,139, 69,'S','p','r','i','n','g','G','r','e','e','n','4',0,						//  0 139  69 SpringGreen4
  0,255,  0,'g','r','e','e','n','1',0,									//  0 255   0 green1
  0,238,  0,'g','r','e','e','n','2',0,									//  0 238   0 green2
  0,205,  0,'g','r','e','e','n','3',0,									//  0 205   0 green3
  0,139,  0,'g','r','e','e','n','4',0,									//  0 139   0 green4
127,255,  0,'c','h','a','r','t','r','e','u','s','e','1',0,						//127 255   0 chartreuse1
118,238,  0,'c','h','a','r','t','r','e','u','s','e','2',0,						//118 238   0 chartreuse2
102,205,  0,'c','h','a','r','t','r','e','u','s','e','3',0,						//102 205   0 chartreuse3
 69,139,  0,'c','h','a','r','t','r','e','u','s','e','4',0,						// 69 139   0 chartreuse4
192,255, 62,'O','l','i','v','e','D','r','a','b','1',0,							//192 255  62 OliveDrab1
179,238, 58,'O','l','i','v','e','D','r','a','b','2',0,							//179 238  58 OliveDrab2
154,205, 50,'O','l','i','v','e','D','r','a','b','3',0,							//154 205  50 OliveDrab3
105,139, 34,'O','l','i','v','e','D','r','a','b','4',0,							//105 139  34 OliveDrab4
202,255,112,'D','a','r','k','O','l','i','v','e','G','r','e','e','n','1',0,				//202 255 112 DarkOliveGreen1
188,238,104,'D','a','r','k','O','l','i','v','e','G','r','e','e','n','2',0,				//188 238 104 DarkOliveGreen2
162,205, 90,'D','a','r','k','O','l','i','v','e','G','r','e','e','n','3',0,				//162 205  90 DarkOliveGreen3
110,139, 61,'D','a','r','k','O','l','i','v','e','G','r','e','e','n','4',0,				//110 139  61 DarkOliveGreen4
255,246,143,'k','h','a','k','i','1',0,									//255 246 143 khaki1
238,230,133,'k','h','a','k','i','2',0,									//238 230 133 khaki2
205,198,115,'k','h','a','k','i','3',0,									//205 198 115 khaki3
139,134, 78,'k','h','a','k','i','4',0,									//139 134  78 khaki4
255,236,139,'L','i','g','h','t','G','o','l','d','e','n','r','o','d','1',0,				//255 236 139 LightGoldenrod1
238,220,130,'L','i','g','h','t','G','o','l','d','e','n','r','o','d','2',0,				//238 220 130 LightGoldenrod2
205,190,112,'L','i','g','h','t','G','o','l','d','e','n','r','o','d','3',0,				//205 190 112 LightGoldenrod3
139,129, 76,'L','i','g','h','t','G','o','l','d','e','n','r','o','d','4',0,				//139 129  76 LightGoldenrod4
255,255,224,'L','i','g','h','t','Y','e','l','l','o','w','1',0,						//255 255 224 LightYellow1
238,238,209,'L','i','g','h','t','Y','e','l','l','o','w','2',0,						//238 238 209 LightYellow2
205,205,180,'L','i','g','h','t','Y','e','l','l','o','w','3',0,						//205 205 180 LightYellow3
139,139,122,'L','i','g','h','t','Y','e','l','l','o','w','4',0,						//139 139 122 LightYellow4
255,255,  0,'y','e','l','l','o','w','1',0,								//255 255   0 yellow1
238,238,  0,'y','e','l','l','o','w','2',0,								//238 238   0 yellow2
205,205,  0,'y','e','l','l','o','w','3',0,								//205 205   0 yellow3
139,139,  0,'y','e','l','l','o','w','4',0,								//139 139   0 yellow4
255,215,  0,'g','o','l','d','1',0,									//255 215   0 gold1
238,201,  0,'g','o','l','d','2',0,									//238 201   0 gold2
205,173,  0,'g','o','l','d','3',0,									//205 173   0 gold3
139,117,  0,'g','o','l','d','4',0,									//139 117   0 gold4
255,193, 37,'g','o','l','d','e','n','r','o','d','1',0,							//255 193  37 goldenrod1
238,180, 34,'g','o','l','d','e','n','r','o','d','2',0,							//238 180  34 goldenrod2
205,155, 29,'g','o','l','d','e','n','r','o','d','3',0,							//205 155  29 goldenrod3
139,105, 20,'g','o','l','d','e','n','r','o','d','4',0,							//139 105  20 goldenrod4
255,185, 15,'D','a','r','k','G','o','l','d','e','n','r','o','d','1',0,					//255 185  15 DarkGoldenrod1
238,173, 14,'D','a','r','k','G','o','l','d','e','n','r','o','d','2',0,					//238 173  14 DarkGoldenrod2
205,149, 12,'D','a','r','k','G','o','l','d','e','n','r','o','d','3',0,					//205 149  12 DarkGoldenrod3
139,101,  8,'D','a','r','k','G','o','l','d','e','n','r','o','d','4',0,					//139 101   8 DarkGoldenrod4
255,193,193,'R','o','s','y','B','r','o','w','n','1',0,							//255 193 193 RosyBrown1
238,180,180,'R','o','s','y','B','r','o','w','n','2',0,							//238 180 180 RosyBrown2
205,155,155,'R','o','s','y','B','r','o','w','n','3',0,							//205 155 155 RosyBrown3
139,105,105,'R','o','s','y','B','r','o','w','n','4',0,							//139 105 105 RosyBrown4
255,106,106,'I','n','d','i','a','n','R','e','d','1',0,							//255 106 106 IndianRed1
238, 99, 99,'I','n','d','i','a','n','R','e','d','2',0,							//238  99  99 IndianRed2
205, 85, 85,'I','n','d','i','a','n','R','e','d','3',0,							//205  85  85 IndianRed3
139, 58, 58,'I','n','d','i','a','n','R','e','d','4',0,							//139  58  58 IndianRed4
255,130, 71,'s','i','e','n','n','a','1',0,								//255 130  71 sienna1
238,121, 66,'s','i','e','n','n','a','2',0,								//238 121  66 sienna2
205,104, 57,'s','i','e','n','n','a','3',0,								//205 104  57 sienna3
139, 71, 38,'s','i','e','n','n','a','4',0,								//139  71  38 sienna4
255,211,155,'b','u','r','l','y','w','o','o','d','1',0,							//255 211 155 burlywood1
238,197,145,'b','u','r','l','y','w','o','o','d','2',0,							//238 197 145 burlywood2
205,170,125,'b','u','r','l','y','w','o','o','d','3',0,							//205 170 125 burlywood3
139,115, 85,'b','u','r','l','y','w','o','o','d','4',0,							//139 115  85 burlywood4
255,231,186,'w','h','e','a','t','1',0,									//255 231 186 wheat1
238,216,174,'w','h','e','a','t','2',0,									//238 216 174 wheat2
205,186,150,'w','h','e','a','t','3',0,									//205 186 150 wheat3
139,126,102,'w','h','e','a','t','4',0,									//139 126 102 wheat4
255,165, 79,'t','a','n','1',0,										//255 165  79 tan1
238,154, 73,'t','a','n','2',0,										//238 154  73 tan2
205,133, 63,'t','a','n','3',0,										//205 133  63 tan3
139, 90, 43,'t','a','n','4',0,										//139  90  43 tan4
255,127, 36,'c','h','o','c','o','l','a','t','e','1',0,							//255 127  36 chocolate1
238,118, 33,'c','h','o','c','o','l','a','t','e','2',0,							//238 118  33 chocolate2
205,102, 29,'c','h','o','c','o','l','a','t','e','3',0,							//205 102  29 chocolate3
139, 69, 19,'c','h','o','c','o','l','a','t','e','4',0,							//139  69  19 chocolate4
255, 48, 48,'f','i','r','e','b','r','i','c','k','1',0,							//255  48  48 firebrick1
238, 44, 44,'f','i','r','e','b','r','i','c','k','2',0,							//238  44  44 firebrick2
205, 38, 38,'f','i','r','e','b','r','i','c','k','3',0,							//205  38  38 firebrick3
139, 26, 26,'f','i','r','e','b','r','i','c','k','4',0,							//139  26  26 firebrick4
255, 64, 64,'b','r','o','w','n','1',0,									//255  64  64 brown1
238, 59, 59,'b','r','o','w','n','2',0,									//238  59  59 brown2
205, 51, 51,'b','r','o','w','n','3',0,									//205  51  51 brown3
139, 35, 35,'b','r','o','w','n','4',0,									//139  35  35 brown4
255,140,105,'s','a','l','m','o','n','1',0,								//255 140 105 salmon1
238,130, 98,'s','a','l','m','o','n','2',0,								//238 130  98 salmon2
205,112, 84,'s','a','l','m','o','n','3',0,								//205 112  84 salmon3
139, 76, 57,'s','a','l','m','o','n','4',0,								//139  76  57 salmon4
255,160,122,'L','i','g','h','t','S','a','l','m','o','n','1',0,						//255 160 122 LightSalmon1
238,149,114,'L','i','g','h','t','S','a','l','m','o','n','2',0,						//238 149 114 LightSalmon2
205,129, 98,'L','i','g','h','t','S','a','l','m','o','n','3',0,						//205 129  98 LightSalmon3
139, 87, 66,'L','i','g','h','t','S','a','l','m','o','n','4',0,						//139  87  66 LightSalmon4
255,165,  0,'o','r','a','n','g','e','1',0,								//255 165   0 orange1
238,154,  0,'o','r','a','n','g','e','2',0,								//238 154   0 orange2
205,133,  0,'o','r','a','n','g','e','3',0,								//205 133   0 orange3
139, 90,  0,'o','r','a','n','g','e','4',0,								//139  90   0 orange4
255,127,  0,'D','a','r','k','O','r','a','n','g','e','1',0,						//255 127   0 DarkOrange1
238,118,  0,'D','a','r','k','O','r','a','n','g','e','2',0,						//238 118   0 DarkOrange2
205,102,  0,'D','a','r','k','O','r','a','n','g','e','3',0,						//205 102   0 DarkOrange3
139, 69,  0,'D','a','r','k','O','r','a','n','g','e','4',0,						//139  69   0 DarkOrange4
255,114, 86,'c','o','r','a','l','1',0,									//255 114  86 coral1
238,106, 80,'c','o','r','a','l','2',0,									//238 106  80 coral2
205, 91, 69,'c','o','r','a','l','3',0,									//205  91  69 coral3
139, 62, 47,'c','o','r','a','l','4',0,									//139  62  47 coral4
255, 99, 71,'t','o','m','a','t','o','1',0,								//255  99  71 tomato1
238, 92, 66,'t','o','m','a','t','o','2',0,								//238  92  66 tomato2
205, 79, 57,'t','o','m','a','t','o','3',0,								//205  79  57 tomato3
139, 54, 38,'t','o','m','a','t','o','4',0,								//139  54  38 tomato4
255, 69,  0,'O','r','a','n','g','e','R','e','d','1',0,							//255  69   0 OrangeRed1
238, 64,  0,'O','r','a','n','g','e','R','e','d','2',0,							//238  64   0 OrangeRed2
205, 55,  0,'O','r','a','n','g','e','R','e','d','3',0,							//205  55   0 OrangeRed3
139, 37,  0,'O','r','a','n','g','e','R','e','d','4',0,							//139  37   0 OrangeRed4
255,  0,  0,'r','e','d','1',0,										//255   0   0 red1
238,  0,  0,'r','e','d','2',0,										//238   0   0 red2
205,  0,  0,'r','e','d','3',0,										//205   0   0 red3
139,  0,  0,'r','e','d','4',0,										//139   0   0 red4
255, 20,147,'D','e','e','p','P','i','n','k','1',0,							//255  20 147 DeepPink1
238, 18,137,'D','e','e','p','P','i','n','k','2',0,							//238  18 137 DeepPink2
205, 16,118,'D','e','e','p','P','i','n','k','3',0,							//205  16 118 DeepPink3
139, 10, 80,'D','e','e','p','P','i','n','k','4',0,							//139  10  80 DeepPink4
255,110,180,'H','o','t','P','i','n','k','1',0,								//255 110 180 HotPink1
238,106,167,'H','o','t','P','i','n','k','2',0,								//238 106 167 HotPink2
205, 96,144,'H','o','t','P','i','n','k','3',0,								//205  96 144 HotPink3
139, 58, 98,'H','o','t','P','i','n','k','4',0,								//139  58  98 HotPink4
255,181,197,'p','i','n','k','1',0,									//255 181 197 pink1
238,169,184,'p','i','n','k','2',0,									//238 169 184 pink2
205,145,158,'p','i','n','k','3',0,									//205 145 158 pink3
139, 99,108,'p','i','n','k','4',0,									//139  99 108 pink4
255,174,185,'L','i','g','h','t','P','i','n','k','1',0,							//255 174 185 LightPink1
238,162,173,'L','i','g','h','t','P','i','n','k','2',0,							//238 162 173 LightPink2
205,140,149,'L','i','g','h','t','P','i','n','k','3',0,							//205 140 149 LightPink3
139, 95,101,'L','i','g','h','t','P','i','n','k','4',0,							//139  95 101 LightPink4
255,130,171,'P','a','l','e','V','i','o','l','e','t','R','e','d','1',0,					//255 130 171 PaleVioletRed1
238,121,159,'P','a','l','e','V','i','o','l','e','t','R','e','d','2',0,					//238 121 159 PaleVioletRed2
205,104,137,'P','a','l','e','V','i','o','l','e','t','R','e','d','3',0,					//205 104 137 PaleVioletRed3
139, 71, 93,'P','a','l','e','V','i','o','l','e','t','R','e','d','4',0,					//139  71  93 PaleVioletRed4
255, 52,179,'m','a','r','o','o','n','1',0,								//255  52 179 maroon1
238, 48,167,'m','a','r','o','o','n','2',0,								//238  48 167 maroon2
205, 41,144,'m','a','r','o','o','n','3',0,								//205  41 144 maroon3
139, 28, 98,'m','a','r','o','o','n','4',0,								//139  28  98 maroon4
255, 62,150,'V','i','o','l','e','t','R','e','d','1',0,							//255  62 150 VioletRed1
238, 58,140,'V','i','o','l','e','t','R','e','d','2',0,							//238  58 140 VioletRed2
205, 50,120,'V','i','o','l','e','t','R','e','d','3',0,							//205  50 120 VioletRed3
139, 34, 82,'V','i','o','l','e','t','R','e','d','4',0,							//139  34  82 VioletRed4
255,  0,255,'m','a','g','e','n','t','a','1',0,								//255   0 255 magenta1
238,  0,238,'m','a','g','e','n','t','a','2',0,								//238   0 238 magenta2
205,  0,205,'m','a','g','e','n','t','a','3',0,								//205   0 205 magenta3
139,  0,139,'m','a','g','e','n','t','a','4',0,								//139   0 139 magenta4
255,131,250,'o','r','c','h','i','d','1',0,								//255 131 250 orchid1
238,122,233,'o','r','c','h','i','d','2',0,								//238 122 233 orchid2
205,105,201,'o','r','c','h','i','d','3',0,								//205 105 201 orchid3
139, 71,137,'o','r','c','h','i','d','4',0,								//139  71 137 orchid4
255,187,255,'p','l','u','m','1',0,									//255 187 255 plum1
238,174,238,'p','l','u','m','2',0,									//238 174 238 plum2
205,150,205,'p','l','u','m','3',0,									//205 150 205 plum3
139,102,139,'p','l','u','m','4',0,									//139 102 139 plum4
224,102,255,'M','e','d','i','u','m','O','r','c','h','i','d','1',0,					//224 102 255 MediumOrchid1
209, 95,238,'M','e','d','i','u','m','O','r','c','h','i','d','2',0,					//209  95 238 MediumOrchid2
180, 82,205,'M','e','d','i','u','m','O','r','c','h','i','d','3',0,					//180  82 205 MediumOrchid3
122, 55,139,'M','e','d','i','u','m','O','r','c','h','i','d','4',0,					//122  55 139 MediumOrchid4
191, 62,255,'D','a','r','k','O','r','c','h','i','d','1',0,						//191  62 255 DarkOrchid1
178, 58,238,'D','a','r','k','O','r','c','h','i','d','2',0,						//178  58 238 DarkOrchid2
154, 50,205,'D','a','r','k','O','r','c','h','i','d','3',0,						//154  50 205 DarkOrchid3
104, 34,139,'D','a','r','k','O','r','c','h','i','d','4',0,						//104  34 139 DarkOrchid4
155, 48,255,'p','u','r','p','l','e','1',0,								//155  48 255 purple1
145, 44,238,'p','u','r','p','l','e','2',0,								//145  44 238 purple2
125, 38,205,'p','u','r','p','l','e','3',0,								//125  38 205 purple3
 85, 26,139,'p','u','r','p','l','e','4',0,								// 85  26 139 purple4
171,130,255,'M','e','d','i','u','m','P','u','r','p','l','e','1',0,					//171 130 255 MediumPurple1
159,121,238,'M','e','d','i','u','m','P','u','r','p','l','e','2',0,					//159 121 238 MediumPurple2
137,104,205,'M','e','d','i','u','m','P','u','r','p','l','e','3',0,					//137 104 205 MediumPurple3
 93, 71,139,'M','e','d','i','u','m','P','u','r','p','l','e','4',0,					// 93  71 139 MediumPurple4
255,225,255,'t','h','i','s','t','l','e','1',0,								//255 225 255 thistle1
238,210,238,'t','h','i','s','t','l','e','2',0,								//238 210 238 thistle2
205,181,205,'t','h','i','s','t','l','e','3',0,								//205 181 205 thistle3
139,123,139,'t','h','i','s','t','l','e','4',0,								//139 123 139 thistle4
  0,  0,  0,'g','r','a','y','0',0,									//  0   0   0 gray0
  0,  0,  0,'g','r','e','y','0',0,									//  0   0   0 grey0
  3,  3,  3,'g','r','a','y','1',0,									//  3   3   3 gray1
  3,  3,  3,'g','r','e','y','1',0,									//  3   3   3 grey1
  5,  5,  5,'g','r','a','y','2',0,									//  5   5   5 gray2
  5,  5,  5,'g','r','e','y','2',0,									//  5   5   5 grey2
  8,  8,  8,'g','r','a','y','3',0,									//  8   8   8 gray3
  8,  8,  8,'g','r','e','y','3',0,									//  8   8   8 grey3
 10, 10, 10,'g','r','a','y','4',0,									// 10  10  10 gray4
 10, 10, 10,'g','r','e','y','4',0,									// 10  10  10 grey4
 13, 13, 13,'g','r','a','y','5',0,									// 13  13  13 gray5
 13, 13, 13,'g','r','e','y','5',0,									// 13  13  13 grey5
 15, 15, 15,'g','r','a','y','6',0,									// 15  15  15 gray6
 15, 15, 15,'g','r','e','y','6',0,									// 15  15  15 grey6
 18, 18, 18,'g','r','a','y','7',0,									// 18  18  18 gray7
 18, 18, 18,'g','r','e','y','7',0,									// 18  18  18 grey7
 20, 20, 20,'g','r','a','y','8',0,									// 20  20  20 gray8
 20, 20, 20,'g','r','e','y','8',0,									// 20  20  20 grey8
 23, 23, 23,'g','r','a','y','9',0,									// 23  23  23 gray9
 23, 23, 23,'g','r','e','y','9',0,									// 23  23  23 grey9
 26, 26, 26,'g','r','a','y','1','0',0,									// 26  26  26 gray10
 26, 26, 26,'g','r','e','y','1','0',0,									// 26  26  26 grey10
 28, 28, 28,'g','r','a','y','1','1',0,									// 28  28  28 gray11
 28, 28, 28,'g','r','e','y','1','1',0,									// 28  28  28 grey11
 31, 31, 31,'g','r','a','y','1','2',0,									// 31  31  31 gray12
 31, 31, 31,'g','r','e','y','1','2',0,									// 31  31  31 grey12
 33, 33, 33,'g','r','a','y','1','3',0,									// 33  33  33 gray13
 33, 33, 33,'g','r','e','y','1','3',0,									// 33  33  33 grey13
 36, 36, 36,'g','r','a','y','1','4',0,									// 36  36  36 gray14
 36, 36, 36,'g','r','e','y','1','4',0,									// 36  36  36 grey14
 38, 38, 38,'g','r','a','y','1','5',0,									// 38  38  38 gray15
 38, 38, 38,'g','r','e','y','1','5',0,									// 38  38  38 grey15
 41, 41, 41,'g','r','a','y','1','6',0,									// 41  41  41 gray16
 41, 41, 41,'g','r','e','y','1','6',0,									// 41  41  41 grey16
 43, 43, 43,'g','r','a','y','1','7',0,									// 43  43  43 gray17
 43, 43, 43,'g','r','e','y','1','7',0,									// 43  43  43 grey17
 46, 46, 46,'g','r','a','y','1','8',0,									// 46  46  46 gray18
 46, 46, 46,'g','r','e','y','1','8',0,									// 46  46  46 grey18
 48, 48, 48,'g','r','a','y','1','9',0,									// 48  48  48 gray19
 48, 48, 48,'g','r','e','y','1','9',0,									// 48  48  48 grey19
 51, 51, 51,'g','r','a','y','2','0',0,									// 51  51  51 gray20
 51, 51, 51,'g','r','e','y','2','0',0,									// 51  51  51 grey20
 54, 54, 54,'g','r','a','y','2','1',0,									// 54  54  54 gray21
 54, 54, 54,'g','r','e','y','2','1',0,									// 54  54  54 grey21
 56, 56, 56,'g','r','a','y','2','2',0,									// 56  56  56 gray22
 56, 56, 56,'g','r','e','y','2','2',0,									// 56  56  56 grey22
 59, 59, 59,'g','r','a','y','2','3',0,									// 59  59  59 gray23
 59, 59, 59,'g','r','e','y','2','3',0,									// 59  59  59 grey23
 61, 61, 61,'g','r','a','y','2','4',0,									// 61  61  61 gray24
 61, 61, 61,'g','r','e','y','2','4',0,									// 61  61  61 grey24
 64, 64, 64,'g','r','a','y','2','5',0,									// 64  64  64 gray25
 64, 64, 64,'g','r','e','y','2','5',0,									// 64  64  64 grey25
 66, 66, 66,'g','r','a','y','2','6',0,									// 66  66  66 gray26
 66, 66, 66,'g','r','e','y','2','6',0,									// 66  66  66 grey26
 69, 69, 69,'g','r','a','y','2','7',0,									// 69  69  69 gray27
 69, 69, 69,'g','r','e','y','2','7',0,									// 69  69  69 grey27
 71, 71, 71,'g','r','a','y','2','8',0,									// 71  71  71 gray28
 71, 71, 71,'g','r','e','y','2','8',0,									// 71  71  71 grey28
 74, 74, 74,'g','r','a','y','2','9',0,									// 74  74  74 gray29
 74, 74, 74,'g','r','e','y','2','9',0,									// 74  74  74 grey29
 77, 77, 77,'g','r','a','y','3','0',0,									// 77  77  77 gray30
 77, 77, 77,'g','r','e','y','3','0',0,									// 77  77  77 grey30
 79, 79, 79,'g','r','a','y','3','1',0,									// 79  79  79 gray31
 79, 79, 79,'g','r','e','y','3','1',0,									// 79  79  79 grey31
 82, 82, 82,'g','r','a','y','3','2',0,									// 82  82  82 gray32
 82, 82, 82,'g','r','e','y','3','2',0,									// 82  82  82 grey32
 84, 84, 84,'g','r','a','y','3','3',0,									// 84  84  84 gray33
 84, 84, 84,'g','r','e','y','3','3',0,									// 84  84  84 grey33
 87, 87, 87,'g','r','a','y','3','4',0,									// 87  87  87 gray34
 87, 87, 87,'g','r','e','y','3','4',0,									// 87  87  87 grey34
 89, 89, 89,'g','r','a','y','3','5',0,									// 89  89  89 gray35
 89, 89, 89,'g','r','e','y','3','5',0,									// 89  89  89 grey35
 92, 92, 92,'g','r','a','y','3','6',0,									// 92  92  92 gray36
 92, 92, 92,'g','r','e','y','3','6',0,									// 92  92  92 grey36
 94, 94, 94,'g','r','a','y','3','7',0,									// 94  94  94 gray37
 94, 94, 94,'g','r','e','y','3','7',0,									// 94  94  94 grey37
 97, 97, 97,'g','r','a','y','3','8',0,									// 97  97  97 gray38
 97, 97, 97,'g','r','e','y','3','8',0,									// 97  97  97 grey38
 99, 99, 99,'g','r','a','y','3','9',0,									// 99  99  99 gray39
 99, 99, 99,'g','r','e','y','3','9',0,									// 99  99  99 grey39
102,102,102,'g','r','a','y','4','0',0,									//102 102 102 gray40
102,102,102,'g','r','e','y','4','0',0,									//102 102 102 grey40
105,105,105,'g','r','a','y','4','1',0,									//105 105 105 gray41
105,105,105,'g','r','e','y','4','1',0,									//105 105 105 grey41
107,107,107,'g','r','a','y','4','2',0,									//107 107 107 gray42
107,107,107,'g','r','e','y','4','2',0,									//107 107 107 grey42
110,110,110,'g','r','a','y','4','3',0,									//110 110 110 gray43
110,110,110,'g','r','e','y','4','3',0,									//110 110 110 grey43
112,112,112,'g','r','a','y','4','4',0,									//112 112 112 gray44
112,112,112,'g','r','e','y','4','4',0,									//112 112 112 grey44
115,115,115,'g','r','a','y','4','5',0,									//115 115 115 gray45
115,115,115,'g','r','e','y','4','5',0,									//115 115 115 grey45
117,117,117,'g','r','a','y','4','6',0,									//117 117 117 gray46
117,117,117,'g','r','e','y','4','6',0,									//117 117 117 grey46
120,120,120,'g','r','a','y','4','7',0,									//120 120 120 gray47
120,120,120,'g','r','e','y','4','7',0,									//120 120 120 grey47
122,122,122,'g','r','a','y','4','8',0,									//122 122 122 gray48
122,122,122,'g','r','e','y','4','8',0,									//122 122 122 grey48
125,125,125,'g','r','a','y','4','9',0,									//125 125 125 gray49
125,125,125,'g','r','e','y','4','9',0,									//125 125 125 grey49
127,127,127,'g','r','a','y','5','0',0,									//127 127 127 gray50
127,127,127,'g','r','e','y','5','0',0,									//127 127 127 grey50
130,130,130,'g','r','a','y','5','1',0,									//130 130 130 gray51
130,130,130,'g','r','e','y','5','1',0,									//130 130 130 grey51
133,133,133,'g','r','a','y','5','2',0,									//133 133 133 gray52
133,133,133,'g','r','e','y','5','2',0,									//133 133 133 grey52
135,135,135,'g','r','a','y','5','3',0,									//135 135 135 gray53
135,135,135,'g','r','e','y','5','3',0,									//135 135 135 grey53
138,138,138,'g','r','a','y','5','4',0,									//138 138 138 gray54
138,138,138,'g','r','e','y','5','4',0,									//138 138 138 grey54
140,140,140,'g','r','a','y','5','5',0,									//140 140 140 gray55
140,140,140,'g','r','e','y','5','5',0,									//140 140 140 grey55
143,143,143,'g','r','a','y','5','6',0,									//143 143 143 gray56
143,143,143,'g','r','e','y','5','6',0,									//143 143 143 grey56
145,145,145,'g','r','a','y','5','7',0,									//145 145 145 gray57
145,145,145,'g','r','e','y','5','7',0,									//145 145 145 grey57
148,148,148,'g','r','a','y','5','8',0,									//148 148 148 gray58
148,148,148,'g','r','e','y','5','8',0,									//148 148 148 grey58
150,150,150,'g','r','a','y','5','9',0,									//150 150 150 gray59
150,150,150,'g','r','e','y','5','9',0,									//150 150 150 grey59
153,153,153,'g','r','a','y','6','0',0,									//153 153 153 gray60
153,153,153,'g','r','e','y','6','0',0,									//153 153 153 grey60
156,156,156,'g','r','a','y','6','1',0,									//156 156 156 gray61
156,156,156,'g','r','e','y','6','1',0,									//156 156 156 grey61
158,158,158,'g','r','a','y','6','2',0,									//158 158 158 gray62
158,158,158,'g','r','e','y','6','2',0,									//158 158 158 grey62
161,161,161,'g','r','a','y','6','3',0,									//161 161 161 gray63
161,161,161,'g','r','e','y','6','3',0,									//161 161 161 grey63
163,163,163,'g','r','a','y','6','4',0,									//163 163 163 gray64
163,163,163,'g','r','e','y','6','4',0,									//163 163 163 grey64
166,166,166,'g','r','a','y','6','5',0,									//166 166 166 gray65
166,166,166,'g','r','e','y','6','5',0,									//166 166 166 grey65
168,168,168,'g','r','a','y','6','6',0,									//168 168 168 gray66
168,168,168,'g','r','e','y','6','6',0,									//168 168 168 grey66
171,171,171,'g','r','a','y','6','7',0,									//171 171 171 gray67
171,171,171,'g','r','e','y','6','7',0,									//171 171 171 grey67
173,173,173,'g','r','a','y','6','8',0,									//173 173 173 gray68
173,173,173,'g','r','e','y','6','8',0,									//173 173 173 grey68
176,176,176,'g','r','a','y','6','9',0,									//176 176 176 gray69
176,176,176,'g','r','e','y','6','9',0,									//176 176 176 grey69
179,179,179,'g','r','a','y','7','0',0,									//179 179 179 gray70
179,179,179,'g','r','e','y','7','0',0,									//179 179 179 grey70
181,181,181,'g','r','a','y','7','1',0,									//181 181 181 gray71
181,181,181,'g','r','e','y','7','1',0,									//181 181 181 grey71
184,184,184,'g','r','a','y','7','2',0,									//184 184 184 gray72
184,184,184,'g','r','e','y','7','2',0,									//184 184 184 grey72
186,186,186,'g','r','a','y','7','3',0,									//186 186 186 gray73
186,186,186,'g','r','e','y','7','3',0,									//186 186 186 grey73
189,189,189,'g','r','a','y','7','4',0,									//189 189 189 gray74
189,189,189,'g','r','e','y','7','4',0,									//189 189 189 grey74
191,191,191,'g','r','a','y','7','5',0,									//191 191 191 gray75
191,191,191,'g','r','e','y','7','5',0,									//191 191 191 grey75
194,194,194,'g','r','a','y','7','6',0,									//194 194 194 gray76
194,194,194,'g','r','e','y','7','6',0,									//194 194 194 grey76
196,196,196,'g','r','a','y','7','7',0,									//196 196 196 gray77
196,196,196,'g','r','e','y','7','7',0,									//196 196 196 grey77
199,199,199,'g','r','a','y','7','8',0,									//199 199 199 gray78
199,199,199,'g','r','e','y','7','8',0,									//199 199 199 grey78
201,201,201,'g','r','a','y','7','9',0,									//201 201 201 gray79
201,201,201,'g','r','e','y','7','9',0,									//201 201 201 grey79
204,204,204,'g','r','a','y','8','0',0,									//204 204 204 gray80
204,204,204,'g','r','e','y','8','0',0,									//204 204 204 grey80
207,207,207,'g','r','a','y','8','1',0,									//207 207 207 gray81
207,207,207,'g','r','e','y','8','1',0,									//207 207 207 grey81
209,209,209,'g','r','a','y','8','2',0,									//209 209 209 gray82
209,209,209,'g','r','e','y','8','2',0,									//209 209 209 grey82
212,212,212,'g','r','a','y','8','3',0,									//212 212 212 gray83
212,212,212,'g','r','e','y','8','3',0,									//212 212 212 grey83
214,214,214,'g','r','a','y','8','4',0,									//214 214 214 gray84
214,214,214,'g','r','e','y','8','4',0,									//214 214 214 grey84
217,217,217,'g','r','a','y','8','5',0,									//217 217 217 gray85
217,217,217,'g','r','e','y','8','5',0,									//217 217 217 grey85
219,219,219,'g','r','a','y','8','6',0,									//219 219 219 gray86
219,219,219,'g','r','e','y','8','6',0,									//219 219 219 grey86
222,222,222,'g','r','a','y','8','7',0,									//222 222 222 gray87
222,222,222,'g','r','e','y','8','7',0,									//222 222 222 grey87
224,224,224,'g','r','a','y','8','8',0,									//224 224 224 gray88
224,224,224,'g','r','e','y','8','8',0,									//224 224 224 grey88
227,227,227,'g','r','a','y','8','9',0,									//227 227 227 gray89
227,227,227,'g','r','e','y','8','9',0,									//227 227 227 grey89
229,229,229,'g','r','a','y','9','0',0,									//229 229 229 gray90
229,229,229,'g','r','e','y','9','0',0,									//229 229 229 grey90
232,232,232,'g','r','a','y','9','1',0,									//232 232 232 gray91
232,232,232,'g','r','e','y','9','1',0,									//232 232 232 grey91
235,235,235,'g','r','a','y','9','2',0,									//235 235 235 gray92
235,235,235,'g','r','e','y','9','2',0,									//235 235 235 grey92
237,237,237,'g','r','a','y','9','3',0,									//237 237 237 gray93
237,237,237,'g','r','e','y','9','3',0,									//237 237 237 grey93
240,240,240,'g','r','a','y','9','4',0,									//240 240 240 gray94
240,240,240,'g','r','e','y','9','4',0,									//240 240 240 grey94
242,242,242,'g','r','a','y','9','5',0,									//242 242 242 gray95
242,242,242,'g','r','e','y','9','5',0,									//242 242 242 grey95
245,245,245,'g','r','a','y','9','6',0,									//245 245 245 gray96
245,245,245,'g','r','e','y','9','6',0,									//245 245 245 grey96
247,247,247,'g','r','a','y','9','7',0,									//247 247 247 gray97
247,247,247,'g','r','e','y','9','7',0,									//247 247 247 grey97
250,250,250,'g','r','a','y','9','8',0,									//250 250 250 gray98
250,250,250,'g','r','e','y','9','8',0,									//250 250 250 grey98
252,252,252,'g','r','a','y','9','9',0,									//252 252 252 gray99
252,252,252,'g','r','e','y','9','9',0,									//252 252 252 grey99
255,255,255,'g','r','a','y','1','0','0',0,								//255 255 255 gray100
255,255,255,'g','r','e','y','1','0','0',0,								//255 255 255 grey100
169,169,169,'d','a','r','k',' ','g','r','e','y',0,							//169 169 169 dark grey
169,169,169,'D','a','r','k','G','r','e','y',0,								//169 169 169 DarkGrey
169,169,169,'d','a','r','k',' ','g','r','a','y',0,							//169 169 169 dark gray
169,169,169,'D','a','r','k','G','r','a','y',0,								//169 169 169 DarkGray
  0,  0,139,'d','a','r','k',' ','b','l','u','e',0,							//  0   0 139 dark blue
  0,  0,139,'D','a','r','k','B','l','u','e',0,								//  0   0 139 DarkBlue
  0,139,139,'d','a','r','k',' ','c','y','a','n',0,							//  0 139 139 dark cyan
  0,139,139,'D','a','r','k','C','y','a','n',0,								//  0 139 139 DarkCyan
139,  0,139,'d','a','r','k',' ','m','a','g','e','n','t','a',0,						//139   0 139 dark magenta
139,  0,139,'D','a','r','k','M','a','g','e','n','t','a',0,						//139   0 139 DarkMagenta
139,  0,  0,'d','a','r','k',' ','r','e','d',0,								//139   0   0 dark red
139,  0,  0,'D','a','r','k','R','e','d',0,								//139   0   0 DarkRed
144,238,144,'l','i','g','h','t',' ','g','r','e','e','n',0,						//144 238 144 light green
144,238,144,'L','i','g','h','t','G','r','e','e','n',0,							//144 238 144 LightGreen
};

/****************************************************************************
 *	
 ****************************************************************************/

const unsigned char* GetX11Color(const char* Name) {
	const unsigned char* p = TBL_X11Color;
	do {
		p += 3/*RGB*/;
		if(!strcasecmp(p, Name)) { return p - 3/*RGB*/; }
		p = strchr(p, '\0') + 1/*'\0'*/;
	} while(p != (TBL_X11Color + sizeof TBL_X11Color));
	return NULL;
}

/****************************************************************************
 *	
 ****************************************************************************/

const char* GetNearestX11Color(int R, int G, int B) {
	int dNear = INT_MAX;
	const unsigned char* pNear = NULL/*x}*/;
	const unsigned char* p = TBL_X11Color;
	do {
		int dR = *p++ - R;
		int dG = *p++ - G;
		int dB = *p++ - B;
		int d = (dR * dR) + (dG * dG) + (dB * dB);
		if(d < dNear) { dNear = d; pNear = p; }
		p = strchr(p, '\0') + 1/*'\0'*/;
	} while(p != (TBL_X11Color + sizeof TBL_X11Color));
	return pNear;
}

