/*	
 *	clipusb.c
 *
 *	USBhCo܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sat Oct 30 05:43:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Jul 06 05:26:00 JST 2005 Naoyuki Sawa
 *	- Gh|CgCfNX̒`ǉɔAڐlLqĂA
 *	  Gh|CgCfNX̃V{g悤ɏC܂B
 *	* Fri Jul 08 18:04:00 JST 2005 Naoyuki Sawa
 *	- D12_CLOCKRUNNINGɗLƂ悤ɕύX܂B
 *	- D12_CLOCKRUNNING̏ꍇɁAPCŁufoCX̒~vsƁA
 *	  PC̃foCX}l[WɁusȃfoCXvƂĎcĂ܂܂B
 *	  P/ECEł荞݂ɔȂǁA\łȂُ퓮ƂȂ܂B
 *	- ufoCX̒~vłȂAUSBP[uOꍇ́A肠܂B
 *	  P/ECEhCóufoCX̒~vACR\Ȃ̂ŁA
 *	  P/ECEJ[lD12_CLOCKRUNNING𖳌ƂĂ̂́A肠܂B
 *	  m̂ƂAD12_CLOCKRUNNING̕Adr쎞ɏȓd͂ƂȂ܂B
 *	* Sun Jul 31 00:57:00 JST 2005 Naoyuki Sawa
 *	- D12_WriteEndpoint()Aobt@Ŗꍇ͏܂Ȃ悤ύX܂B
 *	- ʓIȃfoCXNGXg̏܂B(CLEAR_FEATUREASET_ADDRESS)
 *	* Wed Aug 03 22:08:00 JST 2005 Naoyuki Sawa
 *	- USBؒf`ڑEFCg200[ms]500[ms]ɕύX܂B
 *	  Windows XP̏ꍇAWindows 2000USBؒf`ڑEFCg𒷂߂ɎȂƁA
 *	  P/ECE USBfoCX̕ωFȂꍇ݂łB
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- usb_init(),usb_free()->usb_start(),usb_stop()ɖOύX܂B
 *	* Fri Dec 07 16:25:46 JST 2007 Naoyuki Sawa
 *	- D12_AcknowledgeSetup()C܂B
 *	  ǐ̂߂̏CłACÕR[hł肠܂B
 *	* Sat Dec 08 00:00:11 JST 2007 Naoyuki Sawa
 *	- MI[o[\Ƃ邽߂̎dlύXs܂B
 *	  ܂ł́Aep1_txdone(),ep2_rxdone()R[obNOɎMobt@ǂݏoANAĂ܂A
 *	  ́Aep1_txdone(),ep2_rxdone()ŎMobt@ǂݏoAłꍇ̂݃NAdlƂȂ܂B
 *	- ̎dlύXzA܂łƓƂ@́Aclipuio.c,clipeth.cQƂĂB
 *	  ̎dlύXɑΉAMI[o[Ƃ@́Aclipacm.cQƂĂB
 *	* Tue Dec 11 14:59:31 JST 2007 Naoyuki Sawa
 *	- D12_WriteBuffer()̖߂lύX܂B
 *	  0oCgM(肦܂!!)ƑMobt@tʂ邽߂ɁA
 *	  Mobt@t̖߂l͂0ł͂Ȃ-1ԂƂɂ܂B
 *	* Thu Sep 04 22:00:29 JST 2014 Naoyuki Sawa
 *	- ʓIȃfoCXNGXg̏ɁAget_statusǉ܂B
 *	* Sat Sep 06 23:41:20 JST 2014 Naoyuki Sawa
 *	- device_request_endpoint()̃oOC܂B
 *	  Gh|Cgԍ̑ΉԈĂ܂B
 *	  ̃oOget_status()clear_feature()삵Ă܂łB
 *	  ͐삷悤ɂȂ܂B
 *	* Tue Dec 30 15:44:40 JST 2014 Naoyuki Sawa
 *	- usb_start()ɂāAD12_NOLAZYCLOCKɗLƂ悤ɕύX܂B
 *	  ܂ŁAD12_NOLAZYCLOCKw肷ƃTXyhɍNbNo͂AD12_NOLAZYCLOCKw肵Ȃ΃TXyhɒᑬNbNo͂dlƎvĂ̂łA
 *	  ́AD12_NOLAZYCLOCKw肷ƃTXyhɃNbNo͂~AD12_NOLAZYCLOCKw肵Ȃ΃TXyhɒᑬNbNo͂dlłB
 *	  P/ECẺHPDIUSBD12̃NbNo͂gpĂȂ̂ŁANbNo͂~Ă薳AD12_NOLAZYCLOCKw\ŁAD12_NOLAZYCLOCKw肷ȓd͂ɂȂ܂B
 *	- QƎ:uFAQ - PDIUSBD12 1 October 1998v(faq_pdiusbd12.pdf)
 *	  3.5 What is the CLKOUT frequency during suspend?
 *	  The behaviour of the output clock is configured based on the Configuration Byte written using the Set Mode Command (0xF3).
 *	  
 *	  Configuration Byte            CLKOUT                                                                          
 *	                                                                                  
 *	  No Lazy Clock Clock Running                                                                                 
 *	  
 *	  0             0             CLKOUT switches to Lazy Clock on suspend.                                       
 *	                              The output frequency is 18KHz to 48 KHz.                                        
 *	                              The PLL clock switched off to reduce current consumption.                       
 *	  
 *	  1             0             The CLKOUT stops on suspend.                                                    
 *	  
 *	  0             1             CLKOUT switches to Lazy Clock on suspend.                                       
 *	                              The output frequency is 18KHz to 48 KHz.                                        
 *	                              The PLL clock remains on.                                                       
 *	  
 *	  1             1             The suspend state does not affect the CLKOUT frequency with this configuration. 
 *	  
 *	- Ȃ݂ɁAP/ECEJ[l1.20̕ύX́A̓_ɂĊԈĂ܂B(QƎ http://aquaplus.jp/piece/dl/up118to120.txt  2003.02.14)
 *	  ۂɂ́AD12_NOLAZYCLOCKw肵Ă(NbN~߂Ă)Aw肵ȂĂ(ᑬNbNo͂Ă)Ad͂̍͏悤łB
 *	  uD12_CLOCKRUNNINGv͎̕w̗LŃTXyh̏d͂̍傫̂łAuD12_NOLAZYCLOCKv͂̕قǕςȂ݂łB
 *	  猻'D12_NOLAZYCLOCKw肵Ȃ'܂܂ł傫Ȗ͂Ȃ̂łAxJ[lXV@LCė~łB
 *	* Sun Jan 04 14:56:51 JST 2015 Naoyuki Sawa
 *	- usb_isr()̒`ISR_DEF()}Ng悤ɕύX܂BR[hTCY8oCgȂ܂Be͕ς܂B
 */
#include "clip.h"

/****************************************************************************
 *	PDIUSBD12 |[gANZX
 ****************************************************************************/

/*  dv!! 
 *
 * * f[^|[g񖽗ߘAœǂݍނƁAlǂݏo܂B
 *   Ƃ΁Â悤ȃR[hƁAȂȂ܂B
 *
 *	xld.w %r9, 0x400000
 *	xld.w %r10, [%r9]  ̊Ԋu!!
 *	xld.w %r10, [%r9] 
 *
 *   D12_ReadEndpoint()ł́A_~[ƃTCY̓ǂݍ݂Ȃǂ댯łB
 *
 * * mȌ͕słB
 *   CPU`USBCւCE7MɊ܂܂ĂfBCHł͂ȂƎv܂B
 *   (KvȃfBCȂ̂ł傤ǁÂԂɉeoĂ?)
 *
 * * 삳ɂ́AAǂݍ݂̊ԂnopKvłB
 *
 *	xld.w %r9, 0x400000
 *	xld.w %r10, [%r9] 
 *	nop !!               ̊ԊuȂΑv
 *	xld.w %r10, [%r9] 
 *	nop !!
 *
 * * ۂɂ͊֐ĂяõI[o[wbĥŁAʏ킱̖͕\ʉ܂B
 *   D12OutCmd()CCWJȂAƂȂR[h͐Ȃ͂łB
 *   ʏ̖ߎs菇́Â悤ɂȂ܂B
 *
 *	; 1ڂD12InDatĂяo
 *	xcall D12InDat
 *	xld.w %r9, 0x400000
 *	xld.w %r10, [%r9] 
 *	ret                       
 *	; 2ڂD12InDatĂяo  [ȊԊu
 *	xcall D12InDat            
 *	xld.w %r9, 0x400000       
 *	xld.w %r10, [%r9] 
 *	ret
 *
 * * ȂAAZuōꍇɖYȂ悤ɁA
 *   (݂͖ʂł)InopłƂɂ܂B
 *
 *	; 1ڂD12InDatĂяo
 *	xcall D12InDat
 *	xld.w %r9, 0x400000
 *	xld.w %r10, [%r9] 
 *      nop !!              
 *	ret                       
 *	; 2ڂD12InDatĂяo  [Ԋu
 *	xcall D12InDat            
 *	xld.w %r9, 0x400000       
 *	xld.w %r10, [%r9] 
 *      nop !!
 *	ret
 *
 * * R}h/f[^|[gւ̓Aߏ݂͌؂Ă܂񂪁A
 *   Ԃ񓯂soƎv̂ŁAnopނƂɂ܂B
 */

#define D12_COMMAND	(*(volatile unsigned char *)0x400004)	/* R}hWX^ */
#define D12_DATA	(*(volatile unsigned char *)0x400000)	/* f[^WX^ */

static void
D12OutCmd(int cmd)
{
	D12_COMMAND = cmd;
	asm("nop"); /* Kv */
}

static void
D12OutDat(int dat)
{
	D12_DATA = dat;
	asm("nop"); /* Kv */
}

static int
D12InDat()
{
	int dat;
	dat = D12_DATA;
	asm("nop"); /* Kv */
	return dat;
}

/****************************************************************************
 *	PDIUSBD12 R}hs
 ****************************************************************************/

/* Initialization commands */
#define SET_ADDRESS_ENABLE		0xd0
#define SET_ENDPOINT_ENABLE		0xd8
#define SET_MODE			0xf3
#define SET_DMA				0xfb
/* Data flow commands */
#define READ_INTERRUPT_REGISTER		0xf4
#define SELECT_ENDPOINT			0x00	/* 0x00`0x05 */
#define READ_LAST_TRANSACTION_STATUS	0x40	/* 0x40`0x45 */
#define READ_ENDPOINT_STATUS		0x80	/* 0x80`0x85 */
#define READ_BUFFER			0xf0
#define WRITE_BUFFER			0xf0
#define SET_ENDPOINT_STATUS		0x40	/* 0x40`0x45 */
#define ACKNOWLEDGE_SETUP		0xf1
#define CLEAR_BUFFER			0xf2
#define VALIDATE_BUFFER			0xfa
#define SEND_RESUME			0xf6
#define READ_CURRENT_FRAME_NUMBER	0xf5
/* Undocumented commands */
#define READ_CHIP_ID			0xfd

void
D12_SetAddressEnable(int addr, int enable)
{
	D12OutCmd(SET_ADDRESS_ENABLE);
	if(enable) addr |= 0x80;
	D12OutDat(addr);
}

void
D12_SetEndpointEnable(int enable)
{
	D12OutCmd(SET_ENDPOINT_ENABLE);
	D12OutDat(enable ? 0x01 : 0x00);
}

void
D12_SetMode(int config, int clkdiv)
{
	D12OutCmd(SET_MODE);
	D12OutDat(config);
	D12OutDat(clkdiv);
}

void
D12_SetDMA(int mode)
{
	D12OutCmd(SET_DMA);
	D12OutDat(mode);
}

int
D12_ReadInterruptRegister()
{
	int lo;
	int hi;
	D12OutCmd(READ_INTERRUPT_REGISTER);
	lo = D12InDat();
	hi = D12InDat();
	return lo | hi << 8;
}

int
D12_SelectEndpoint(int endp)
{
	D12OutCmd(SELECT_ENDPOINT | endp);
	return D12InDat();
}

int
D12_ReadLastTransactionStatus(int endp)
{
	D12OutCmd(READ_LAST_TRANSACTION_STATUS | endp);
	return D12InDat();
}

int
D12_ReadEndpointStatus(int endp)
{
	D12OutCmd(READ_ENDPOINT_STATUS | endp);
	return D12InDat();
}

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//int
//D12_ReadEndpoint(int endp, void* buf, int maxlen)
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
int
D12_ReadBuffer(int endp, void* buf, int maxlen)
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
{
	unsigned char* dst = (unsigned char*)buf;
	//
	int dummy;
	int len;
	int i;

	/* ǂݍރGh|CgI܂B
	 * MĂȂ΁A܂ǂݍ߂܂B
	 * * M(FULL )̔́gD12_FULLEMPTY=1hłB
	 *   M(EMPTY)̔́gD12_FULLEMPTY=0hƂ0<=>1tłBv!!
	 * * 0oCgM(肦܂!!)ƎMʂ邽߂ɁA
	 *   M̖߂l͂0ł͂ȂA-1ԂƂɂ܂Bv!!
	 */
	if(!(D12_SelectEndpoint(endp) & D12_FULLEMPTY)) return -1/*M*/;

	/* Mf[^ǂݍ݂܂B */
	D12OutCmd(READ_BUFFER);
	dummy = D12InDat(); /* _~[ */
	len   = D12InDat(); /* MoCg */
	if(len > maxlen) len = maxlen; /* ǂݍ݃oCg؂l */
	for(i = 0; i < len; i++) dst[i] = D12InDat();

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	/* Mobt@ɂ܂B */
//	D12OutCmd(CLEAR_BUFFER);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

	return len;
}

/* * 2005/07/31ǋL
 * - Gh|Cg̃pPbgTCY𒴂lenw肵Ȃŉ!!
 *   pPbgTCY𒴂lenw肳ꂽꍇ̓́A`łB
 * - usb_inf.mode΁AeGh|Cg̃pPbgTCŶŁA
 *   ̊֐ɂlen؂l߂邱Ƃ\łA͂܂łB
 *   D12_*֐Qɂ͕Gȏ܂߂ȂŁAPɕۂłB
 */
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//int
//D12_WriteEndpoint(int endp, const void* ptr, int len)
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
int
D12_WriteBuffer(int endp, const void* ptr, int len)
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
{
	const unsigned char* src = (const unsigned char*)ptr;
	int i;

//#if 0
////	/* ރGh|CgI܂B
////	 * MĂȂ΁A܂߂܂B
////	 * * M(EMPTY)̔́gD12_FULLEMPTY=0hłB
////	 *   M(FULL )̔́gD12_FULLEMPTY=1hƂ0<=>1tłBv!!
////	 */
////	if(D12_SelectEndpoint(endp) & D12_FULLEMPTY) return 0;
//#else
//	/* C^vg]Ŗ]f[^j邱Ƃ悤Ȃ̂ŁA
//	 * EMPTY͂߂܂B
//	 * A]f[^cĂƂɎ̃f[^ނƁA
//	 * {ɑÕf[^]LẐǂ͖mFłB
//	 */
//	D12_SelectEndpoint(endp);
//#endif
////////2005/07/31 ςłȂƂ͏܂Ȃ悤ɕύX܂B
	/* ރGh|CgI܂B
	 * MĂȂ΁A܂߂܂B
	 * * M(EMPTY)̔́gD12_FULLEMPTY=0hłB
	 *   M(FULL )̔́gD12_FULLEMPTY=1hƂ0<=>1tłBv!!
	 * [l]
	 * * INobt@́AMȊOɂASETUPpPbg̎MStallɂăNA܂B
	 *   OUTobt@́ACLEAR_BUFFERȊOɂASETUPpPbg̎MStallɂăNA܂B
	 */
//{{2007/12/11:D12_WriteBuffer()̖߂lύX܂B
//	if(D12_SelectEndpoint(endp) & D12_FULLEMPTY) return 0;
//2007/12/11:D12_WriteBuffer()̖߂lύX܂B
//	0oCgM(肦܂!!)ƑMobt@tʂ邽߂ɁA
//	Mobt@t̖߂l͂0ł͂Ȃ-1ԂƂɂ܂B
	if(D12_SelectEndpoint(endp) & D12_FULLEMPTY) return -1;
//}}2007/12/11:D12_WriteBuffer()̖߂lύX܂B

	D12OutCmd(WRITE_BUFFER);
	D12OutDat(  0); /* _~[ */
	D12OutDat(len); /* MoCg */
	for(i = 0; i < len; i++) D12OutDat(src[i]);

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	/* MJn܂B */
//	D12OutCmd(VALIDATE_BUFFER);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

	return len;
}

void
D12_SetEndpointStatus(int endp, int stall)
{
	D12OutCmd(SET_ENDPOINT_STATUS | endp);
	D12OutDat(stall ? 0x01 : 0x00);
}

void
D12_AcknowledgeSetup(int endp)
{
	/*{{2007/12/07:C*/
	//D12OutCmd(endp);
	//* Fri Dec 07 16:25:46 JST 2007 Naoyuki Sawa
	//- SelectEndpoints1 byteǂݏo͔CӂȂ̂ŁACÕR[hł̂łA
	//  vỎǐ̂߂ɁAID12_SelectEndpoint()g悤C܂B
	D12_SelectEndpoint(endp);
	/*}}2007/12/07:C*/
	D12OutCmd(ACKNOWLEDGE_SETUP);
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	/* Acknowledge SetuṕAEP0OUT(endp=0)܂EP0IN(endp=1)ɑ΂Ă̂ݔs܂B
//	 * EP0OUT(endp=0)ւ̔s̏ꍇAD12_ReadEndpoint()ĂłƎv܂A
//	 * D12_ReadEndpoint()̒ōŌɍsClear Buffer͖łB
//	 * EP0łSETUPM`Acknowledge SetupԂClear/Validate BufferłB
//	 * Acknowledge SetupɂClear Buffers܂B(x͗Lł)
//	 */
//	if(endp == EP0OUT) D12OutCmd(CLEAR_BUFFER);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
}

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
void
D12_ClearBuffer(int endp)
{
	D12_SelectEndpoint(endp);
	D12OutCmd(CLEAR_BUFFER);
}
void
D12_ValidateBuffer(int endp)
{
	D12_SelectEndpoint(endp);
	D12OutCmd(VALIDATE_BUFFER);
}
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

void
D12_SendResume()
{
	D12OutCmd(SEND_RESUME);
}

int
D12_ReadCurrentFrameNumber()
{
	int lo;
	int hi;
	D12OutCmd(READ_CURRENT_FRAME_NUMBER);
	lo = D12InDat();
	hi = D12InDat();
	return lo | hi << 8;
}

int
D12_ReadChipID()
{
	int lo;
	int hi;
	D12OutCmd(READ_CHIP_ID);
	lo = D12InDat();
	hi = D12InDat();
	return lo | hi << 8;
}

/****************************************************************************
 *	USBhCo
 ****************************************************************************/

static PCEKSENT old_usb_isr;		/* ̊荞݃nh(NULL:tbNĂȂ) */
static USBINF usb_inf;			/* USBtbN */

#define TRAP_USBC		TRAP_P1	/* USBC荞݃xN^ԍ */
//#define RECONNECT_WAIT	200	/* USBؒf`ڑEFCg[ms] */
//2005/08/03 WinXPWin2K߂̃EFCgłȂƔFȂꍇ݂łB
#define RECONNECT_WAIT		500	/* USBؒf`ڑEFCg[ms] */

/* CONTROL_XFER.state */
#define STATE_IDLE		 0	/* Rg[f[^MȂ */
#define STATE_RXING		 1	/* Rg[f[^M */
#define STATE_TXING		 2	/* Rg[f[^M */

/* CONTROL_XFER.data_buffer */
#define DATA_BUFFER_SIZE	16	/* MRg[f[^TCY(ő)E */

typedef struct _CONTROL_XFER {
	int state;					/* M */
	DEVICE_REQUEST device_request;			/* foCXNGXgMobt@ */
	int data_length;				/* MRg[f[^TCY(S) */
	int data_count;					/* Mς݃Rg[f[^TCY(is) */
	unsigned char data_buffer[DATA_BUFFER_SIZE];	/* MRg[f[^obt@ */
	const unsigned char* data_ptr;			/* MRg[f[^|C^(擪) */
} CONTROL_XFER;
static CONTROL_XFER control_xfer;

//static void usb_isr();	//{{2015/01/04폜:usb_isr()̒`ISR_DEF()}Ng悤ɕύX܂BR[hTCY8oCgȂ܂Be͕ς܂B}}
static void fn_usb_isr();
static void bus_reset();
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//static void ep0_rxdone(int st, const unsigned char* dat, int len);
//static void ep0_txdone(int st);
//static void ep1_rxdone(int st, const unsigned char* dat, int len);
//static void ep1_txdone(int st);
//static void ep2_rxdone(int st, const unsigned char* dat, int len);
//static void ep2_txdone(int st);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
static void ep0_rxdone(int st);
static void ep0_txdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
static void device_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
/*{{2005/07/31 ʓIȃfoCXNGXg̏܂B*/
static int device_request_endpoint(const DEVICE_REQUEST* req);
static void get_status(const DEVICE_REQUEST* req, const unsigned char* dat, int len);	/*{{2014/09/04ǉ:ʓIȃfoCXNGXg̏ɁAget_statusǉ܂B}}*/
static void clear_feature(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
static void set_address(const DEVICE_REQUEST* req, const unsigned char* dat, int len);
/*}}2005/07/31 ʓIȃfoCXNGXg̏܂B*/

#if 0 //{{2015/01/04ύX:usb_isr()̒`ISR_DEF()}Ng悤ɕύX܂BR[hTCY8oCgȂ܂Be͕ς܂B
/* !!
 * INT_END2retiŒږ߂̂ŁA(orÖق)[JϐĂ͂܂B
 * 炱̊֐ł͂Ȃׂs킸ɁAۂ̏fn_usb_isr()ɔC܂B
 */
static void
usb_isr()
{
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//{{2004/10/28 RgAEg ̃ubN̋Lq͌ł
	//
	///* * 荞ݗvtO֘ȀԑJڂ͎̂悤ɂȂ܂F
	// *
	// *								USBC̊荞	USBC		ITC̊荞
	// *								vtO	INT_N[q	vtO
	// *	0. 荞ݔ						P		P		P
	// *	1. ITC̊荞ݗvtONA			P		P		O
	// *	2. 荞݋						P		P		O
	// *	   CPŮ荞݋xUSBC荞݃x
	// *	   ȂĂ̂ŁAUSBC荞݂̓ubNB
	// *	   ʂ̊荞(TEhȂ)͎󂯕tB
	// *	3. USBC̊荞ݗvtONA			O		O		O
	// *	4. retiɂACPŮ荞݃x			O		O		O
	// *	   USBC荞݂󂯕t悤ɂȂB
	// *
	// *   ̎菇ƁAꌩÂ悤ȐSzĂ܂܂B
	// *
	// *	2.̎_ INT_N=1 Ȃ̂ōĂ ITC̊荞ݗvtO=1 ɂȂA(USBC荞݂̓xgK)
	// *	4.̎_܂ŃyfBOꂽAreti̒ɂ܂荞݂̂ł͂ȂH
	// *	ITC̊荞ݗvtONAOɁAUSBC̊荞ݗvtONAȂ΂Ȃ̂ł͂ȂH
	// *
	// *   A̐Sz͕svłB
	// *   ITC̊荞ݗvtOZbĝ́AwۂɊ荞݂_xłB
	// *   (s1c33209_221_222j.pdf II-5 ITC(荞݃Rg[) B-II-5-2 u}XN\Ȋ荞݂̔v Q)
	// *   DMAgKȂǂƂ͈قȂA荞݃ubNԂŊ荞ݗvtOZbgEyfBO邱Ƃ͂܂B
	// *   2.̎_ŁAUSBC荞݂CPŮ荞݃xɂăubNĂ̂ŁA荞ݗvtO̓Zbg܂B
	// */
	//INT_BEGIN2;
	//bINT_FK01_FP03_FP1 = 0;	/* (1.) */
	////̊荞ݏƂ̔rƂȂꍇ́Ad荞݂ȂSłB
	////ENABLE;		/* (2.) */
	//fn_usb_isr();		/* (3.) */
	//INT_END2;		/* (4.) */
	//
	//}}2004/10/28 RgAEg ̃ubN̋Lq͌ł
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// 2004/10/28 19:40 ǋL ̋Lq͊ԈႢł!!
	//
	//gITC̊荞ݗvtOZbĝ́AwۂɊ荞݂_xhł͂܂łB
	// USBCINT_N=1ɂȂuԂɁACPUŊ荞݂}XNĂ邩ۂ(ۂɊ荞݂邩ۂ)Ɋ֌WȂA
	// 荞ݗvtO(bINT_FK01_FP03_FP1)Zbg܂B
	// ̃R[hłUSBC̊荞ݗvNAOITC̊荞ݗvNAĂ܂AUSBCINT_N=1̂܂܂Ȃ̂ŁA
	// ITC̊荞ݗvNAɂ܂ITC̊荞ݗvtOZbgĂ܂܂B
	// ̌AUSBC̊荞ݗvNAINT_N=0ɂȂ킯łAITUւ̊荞ݗv͔sĂ܂Ă邽߁A
	// ǖʂȊ荞݂Ă܂܂B̗lqAɎ܂B
	// 
	//	[Ȃ菇]					USBC̊荞	USBC		ITC̊荞
	//								vtO	INT_N[q	vtO
	//	0. 荞ݔ						P		P		P
	//	1. ITC̊荞ݗvtONA			P		P		OɂP
	//	2. (荞݋)					P		P		P
	//	3. USBC̊荞ݗvtONA			O		O		P
	//	4. retiɂACPŮ荞݃x			O		O		P
	//	5. ʂȊ荞݂!!				O		O		P
	//
	// ۂɂ̂悤ɓ삵Ă܂ĂƂAvOŊmF܂B
	// ʂȊ荞݂ĂAxڂ̊荞݂Ă΂fn_usb_isr()sȂȂ̂ŁA
	// Q͂Ȃ̂łǁA킸ɖʂȎԂĂ邱ƂɂȂ܂B
	// Ȃ݂P/ECEJ[l(1.20)Ɠ菇Ȃ̂ŁAl̖ʂȊ荞݂Ă̂Ǝv܂B
	//
	// ʂȊ荞݂h߂ɂ́Â悤Ȏ菇ƂȂ΂܂B
	//
	//	[菇]						USBC̊荞	USBC		ITC̊荞
	//								vtO	INT_N[q	vtO
	//	0. 荞ݔ						P		P		P
	//	1. (荞݋)					P		P		P
	//	2. USBC̊荞ݗvtONA			O		O		P
	//	3. ITC̊荞ݗvtONA			O		O		O
	//	4. retiɂACPŮ荞݃x			O		O		O
	//
	// (2.)`(3.)̊ԂɎUSBC荞ݗvꍇSłB荞ݗvĂ܂Ƃ͂܂B
	// (2.)`(3.)̊ԂɎUSBC荞ݗvꍇ̗܂B(\łB܂mF͂Ă܂B)
	//
	//	[菇]						USBC̊荞	USBC		ITC̊荞
	//								vtO	INT_N[q	vtO
	//	0. 荞ݔ						P		P		P
	//	1. (荞݋)					P		P		P
	//	2. USBC̊荞ݗvtONA			O		O		P
	//	X. VUSBC荞ݗv				P		P		P
	//	3. ITC̊荞ݗvtONA			P		P		OɂP
	//	4. retiɂACPŮ荞݃x			P		P		P
	//	5. VUSBC荞݂邽߂̊荞ݔ(Kv)	P		P		P
	//
	// ȏ𓥂܂āAȉ悤ɃR[hC܂B
	//
	INT_BEGIN2;
	//̊荞ݏƂ̔rƂȂꍇ́Ad荞݂ȂSłB
	//ENABLE;		/* (1.) */
	fn_usb_isr();		/* (2.) */
	bINT_FK01_FP03_FP1 = 0;	/* (3.) */
	INT_END2;		/* (4.) */
}
#else //2015/01/04ύX:usb_isr()̒`ISR_DEF()}Ng悤ɕύX܂BR[hTCY8oCgȂ܂Be͕ς܂B
ISR_DEF(usb_isr) {
	//ENABLE;		/* (1.) */
	fn_usb_isr();		/* (2.) */
	bINT_FK01_FP03_FP1 = 0;	/* (3.) */
}				/* (4.) */
#endif//}}2015/01/04ύX:usb_isr()̒`ISR_DEF()}Ng悤ɕύX܂BR[hTCY8oCgȂ܂Be͕ς܂B

static void
fn_usb_isr()
{
	int ir;
	int st;
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	int len;
//	unsigned char dat[EP0TO2_MAX_PACKET_SIZE];
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

	/* 荞ݗv擾ENA܂B(M荞ݗṽNA͌ʂɍs܂) */
	ir = D12_ReadInterruptRegister();

	/* oXZbgȂ΁A̗v͖܂B
	 * * oXZbgCxǵAUSBP[uڑuԂɓAŔ悤łB
	 *   USBP[u𔲂ɂ͔܂B()
	 */
	if(ir & D12_INT_BUSRESET) {
		bus_reset();

	/* oXZbgȊO̗v܂B */
	} else {
		if(ir & D12_INT_SUSPENDCHANGE) { /* ܂ */ }
		if(ir & D12_INT_EOT) { /* DMAM͌Ă܂ */ }
		/* EP0 (Rg[Gh|CgAVOobt@) */
		if(ir & D12_INT_ENDP0OUT) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP0OUT);	/* 荞ݗvNA */
//			len = D12_ReadEndpoint(EP0OUT, dat, sizeof dat);
//			if(len != -1) { /* 肦Ȃ... */
//				ep0_rxdone(st, dat, len);
//			}
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			st = D12_ReadLastTransactionStatus(EP0OUT);	/* 荞ݗvNA */
			ep0_rxdone(st);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
		if(ir & D12_INT_ENDP0IN) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP0IN);	/* 荞ݗvNA */
//			ep0_txdone(st);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			D12_ReadLastTransactionStatus(EP0IN);		/* 荞ݗvNA */
			ep0_txdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
		/* EP1 (WFlbNGh|CgAVOobt@) */
		if(ir & D12_INT_ENDP1OUT) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP1OUT);	/* 荞ݗvNA */
//			len = D12_ReadEndpoint(EP1OUT, dat, sizeof dat);
//			if(len != -1) { /* 肦Ȃ... */
//				ep1_rxdone(st, dat, len);
//			}
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			D12_ReadLastTransactionStatus(EP1OUT);		/* 荞ݗvNA */
			if(usb_inf.ep1_rxdone) usb_inf.ep1_rxdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
		if(ir & D12_INT_ENDP1IN) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP1IN);	/* 荞ݗvNA */
//			ep1_txdone(st);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			D12_ReadLastTransactionStatus(EP1IN);		/* 荞ݗvNA */
			if(usb_inf.ep1_txdone) usb_inf.ep1_txdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
		/* EP2 (CGh|CgAVOobt@܂̓_uobt@) */
		if(ir & D12_INT_ENDP2OUT) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP2OUT);	/* 荞ݗvNA */
//			for(;;) { /* _uobt@ݒ莞̂߂ɁAς݃pPbgSď邱(K{!!) */
//				len = D12_ReadEndpoint(EP2OUT, dat, sizeof dat);
//				if(len == -1) break;
//				ep2_rxdone(st, dat, len);
//			}
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			D12_ReadLastTransactionStatus(EP2OUT);		/* 荞ݗvNA */
			if(usb_inf.ep2_rxdone) usb_inf.ep2_rxdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
		if(ir & D12_INT_ENDP2IN) {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//			st = D12_ReadLastTransactionStatus(EP2IN);	/* 荞ݗvNA */
//			ep2_txdone(st);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
			D12_ReadLastTransactionStatus(EP2IN);		/* 荞ݗvNA */
			if(usb_inf.ep2_txdone) usb_inf.ep2_txdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		}
	}
}

static void
bus_reset()
{
	if(usb_inf.bus_reset != NULL) usb_inf.bus_reset();
}

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//static void
//ep0_rxdone(int st, const unsigned char* dat, int len)
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
static void
ep0_rxdone(int st)
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
{
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	int len;
	unsigned char dat[EP0_PACKET_SIZE];
	len = D12_ReadBuffer(EP0OUT, dat, sizeof dat);
	if(len == -1) return;
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

	/* SETUPpPbgM... */
	if(st & D12_SETUPPACKET) {
		/* ܂AChԂɂĂ܂B
		 * Rg[f[^MłASETUPpPbgMƑM̓LZ܂B
		 */
		control_xfer.state = STATE_IDLE;

		/* foCXNGXgۑ܂B */
		if(len != sizeof(DEVICE_REQUEST)) { /* foCXNGXgTCYs */
			usb_ep0_stall();
			return;
		}
		memcpy(&control_xfer.device_request, dat, sizeof(DEVICE_REQUEST));

		/* SETUPpPbgMɂEP0~Ă̂ŁAA܂B */
		D12_AcknowledgeSetup(EP0OUT);	/* ȍ~AuD12_ClearBuffer(EP0OUT);v\ƂȂ܂B */
		D12_AcknowledgeSetup(EP0IN);	/* ȍ~AuD12_ValidateBuffer(EP0IN);v\ƂȂ܂B */

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		D12_ClearBuffer(EP0OUT);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

		/* Rg[f[^̑MTCY܂B */
		control_xfer.data_length = control_xfer.device_request.wLength;
		control_xfer.data_count  = 0;

		/* Rg[f[^̑Mɂ... */
		if(control_xfer.device_request.bmRequestType & 0x80) { /* Data transfer direction */
			/* Device-to-host (GET) */
			device_request(&control_xfer.device_request, NULL, 0);
		} else {
			/* Host-to-device (SET) */
			if(control_xfer.data_length == 0) {
				/* Rg[f[^͂Ȃ̂ŁAɃfoCXNGXg܂B */
				device_request(&control_xfer.device_request, NULL, 0);
			} else {
				/* Rg[f[^MƂŁAfoCXNGXg܂B */
				if(control_xfer.data_length > DATA_BUFFER_SIZE) {
					usb_ep0_stall();
					return;
				}
				control_xfer.state = STATE_RXING;
			}
		}

	/* Rg[f[^MȂ... */
	} else if(control_xfer.state == STATE_RXING) {
		/* Rg[f[^i[܂B */
		if(control_xfer.data_count + len > control_xfer.data_length) { /* Rg[f[^ */
			usb_ep0_stall();
			return;
		}
		memcpy(&control_xfer.data_buffer[control_xfer.data_count], dat, len);
		control_xfer.data_count += len;

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		D12_ClearBuffer(EP0OUT);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

		/* Rg[f[^̎MAfoCXNGXg܂B
		 * zXgfoCX̃Rg[f[^́AKfoCXNGXgŎw肳ꂽTCY҂ŏI܂B
		 * oN]̂悤ɁAyC[hTCỸpPbg̃pPbgɂďI[ꂽ͂܂B
		 * [usb_20.pdf p.30]
		 * The Data stage of a control transfer from the host to an endpoint is complete when all of the data has been
		 * transferred. If the endpoint receives a larger-than-expected data payload from the host, it halts the pipe.
		 */
		if(control_xfer.data_count == control_xfer.data_length) {
			control_xfer.state = STATE_IDLE;
			device_request(&control_xfer.device_request, control_xfer.data_buffer, control_xfer.data_length);
		}

	} else {
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		D12_ClearBuffer(EP0OUT);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

		/* ԂGETNGXg̃Xe[^XXe[WŁAzXg̋pPbgMʒmłB
		 * ł͉܂B
		 */
	}
}

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//static void
//ep0_txdone(int st)
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
static void
ep0_txdone()
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
{
	int len;

	/* Rg[f[^MȂ... */
	if(control_xfer.state == STATE_TXING) {
		/* Rg[f[^yC[hTCYɕđM܂B
		 * * foCXzXg̃Rg[f[^́AfoCXNGXgŎw肳ꂽTCY҂肩A
		 *   ܂̓oN]ƓlɁAyC[hTCỸpPbg̃pPbgɂďI[܂B
		 * * ݂̎ł́ufoCXNGXgŎw肳ꂽTCY҂vƂlĂȂ̂ŁA
		 *   w肳ꂽTCYyC[hTCY̐{ꍇɁA]vȋpPbg𑗂Ă܂܂B
		 *   zXgŗ]vȋpPbg𖳎Ă邱Ƃ҂āAƂ肠̂܂܂ɂĂ܂BǋL:2004/11/02CÃRgQ
		 * [usb_20.pdf p.30]
		 * The Data stage of a control transfer from an endpoint to the host is complete when the endpoint does one of
		 * the following:
		 *  Has transferred exactly the amount of data specified during the Setup stage
		 *  Transfers a packet with a payload size less than wMaxPacketSize or transfers a zero-length packet
		 * When a Data stage is complete, the Host Controller advances to the Status stage instead of continuing on
		 * with another data transaction. If the Host Controller does not advance to the Status stage when the Data
		 * stage is complete, the endpoint halts the pipe as was outlined in Section 5.3.2. If a larger-than-expected data
		 * payload is received from the endpoint, the IRP for the control transfer will be aborted/retired.
		 */
		len = control_xfer.data_length - control_xfer.data_count;
		if(len > EP0_PACKET_SIZE) len = EP0_PACKET_SIZE;
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//		D12_WriteEndpoint(EP0IN, control_xfer.data_ptr + control_xfer.data_count, len);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		D12_WriteBuffer(EP0IN, control_xfer.data_ptr + control_xfer.data_count, len);
		D12_ValidateBuffer(EP0IN);
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
		control_xfer.data_count += len;
		//if(len < EP0_PACKET_SIZE) control_xfer.state = STATE_IDLE;
		//
		//2004/11/02 Naoyuki Sawa ǋL#1
		//* q́gw肳ꂽTCYyC[hTCY̐{ꍇɁA]vȋpPbg𑗂Ă܂hC܂B
		//  w肳ꂽTCYyC[hTCY̐{ꍇ́A҂yC[hTCỸpPbg𑗂ďI܂B
		//
		///* "len<EP0_PACKET_SIZE"̏ꍇ"data_count==data_length"ɂȂ̂ŁA"len<EP0_PACKET_SIZE"͕̏svłB */
		//if(control_xfer.data_count == control_xfer.data_length) control_xfer.state = STATE_IDLE;
		//
		//2004/11/02 Naoyuki Sawa ǋL#2
		//* ƁAv̂łAۂɏ̂悤ɕύXĂ݂ƁAWindows 2000Mass storagefoCXFȂȂ܂...
		//  ǂRg[]ɂāAyC[hTCY܂͋pPbgɂI[͕K{݂łB
		//  P/ECEJ[lƁA͂yC[hTCY܂͋pPbgɂI[sĂ悤łB(mainloop.c ep0_txdone() Q)
		//  Ȃ킯ŁAɖ߂܂B
		//
		if(len < EP0_PACKET_SIZE) control_xfer.state = STATE_IDLE;

	} else {
		/* ԂSETNGXg̃Xe[^XXe[WŁAzXgւ̋pPbgMʒmłB
		 * ł͉܂B
		 */
	}
}

//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//static void
//ep1_rxdone(int st, const unsigned char* dat, int len)
//{
//	if(usb_inf.ep1_rxdone != NULL) usb_inf.ep1_rxdone(dat, len);
//}
//static void
//ep1_txdone(int st)
//{
//	if(usb_inf.ep1_txdone != NULL) usb_inf.ep1_txdone();
//}
//static void
//ep2_rxdone(int st, const unsigned char* dat, int len)
//{
//	if(usb_inf.ep2_rxdone != NULL) usb_inf.ep2_rxdone(dat, len);
//}
//static void
//ep2_txdone(int st)
//{
//	if(usb_inf.ep2_txdone != NULL) usb_inf.ep2_txdone();
//}
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX

static void
device_request(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	DEVICE_REQUEST_CALLBACK drc = NULL;

	switch(req->bmRequestType & 0x60) { /* Type */
	case 0x00: /* Standard request */
		switch(req->bRequest) {
		case GET_STATUS:        drc = usb_inf.get_status;        break;
		case CLEAR_FEATURE:     drc = usb_inf.clear_feature;     break;
		case SET_FEATURE:       drc = usb_inf.set_feature;       break;
		case SET_ADDRESS:       drc = usb_inf.set_address;       break;
		case GET_DESCRIPTOR:    drc = usb_inf.get_descriptor;    break;
		case SET_DESCRIPTOR:    drc = usb_inf.set_descriptor;    break;
		case GET_CONFIGURATION: drc = usb_inf.get_configuration; break;
		case SET_CONFIGURATION: drc = usb_inf.set_configuration; break;
		case GET_INTERFACE:     drc = usb_inf.get_interface;     break;
		case SET_INTERFACE:     drc = usb_inf.set_interface;     break;
		case SYNCH_FRAME:       drc = usb_inf.synch_frame;       break;
		}
		break;
	case 0x20: /* Class request */
		drc = usb_inf.class_request;
		break;
	case 0x40: /* Vendor request */
		drc = usb_inf.vendor_request;
		break;
	}
	if(drc) {
		drc(req, dat, len);
	} else {
		usb_ep0_stall(); /* Ή̃NGXgȂ΁AXg[܂ */
	}
}

void
usb_start(const USBINF* ui)
{
	int T0;

	/*{{Ôߍ\̒`Ɍ肪ȂƂmF*/
	if(sizeof(DEVICE_REQUEST          ) !=  8) DIE();
	if(sizeof(DEVICE_DESCRIPTOR       ) != 18) DIE();
	if(sizeof(CONFIGURATION_DESCRIPTOR) !=  9) DIE();
	if(sizeof(STRING_DESCRIPTOR       ) !=  2) DIE();
	if(sizeof(INTERFACE_DESCRIPTOR    ) !=  9) DIE();
	if(sizeof(ENDPOINT_DESCRIPTOR     ) !=  7) DIE();
	/*}}Ôߍ\̒`Ɍ肪ȂƂmF*/

	/* ܂mɃtbN܂B */
	usb_stop();

	/* J[lUSB䌠B */
	pceUSBDisconnect();

	/* zXgؒfoł悤ɁAEFCgB */
	T0 = pceTimerGetCount();
	while(pceTimerGetCount() - T0 < RECONNECT_WAIT) { }

	/* USBtbNi[܂B */
	usb_inf = *ui;

	/*{{2005/07/31 ʓIȃfoCXNGXg̏܂B*/
	if(!usb_inf.get_status   ) usb_inf.get_status    = get_status   ;	/*{{2014/09/04ǉ:ʓIȃfoCXNGXg̏ɁAget_statusǉ܂B}}*/
	if(!usb_inf.clear_feature) usb_inf.clear_feature = clear_feature;
	if(!usb_inf.set_address  ) usb_inf.set_address   = set_address  ;
	/*}}2005/07/31 ʓIȃfoCXNGXg̏܂B*/

	/* USBC荞݂tbNB */
	old_usb_isr = pceVectorSetTrap(TRAP_USBC, usb_isr);

	/* USBڑB */
	ENTER_CS;
	//D12_SetMode(usb_inf.mode | D12_SOFTCONNECT, D12_SETTOONE);
	//2005/07/08 D12_CLOCKRUNNINGɗLƂ悤ɕύX܂B
	//D12_SetMode(usb_inf.mode | D12_SOFTCONNECT | D12_CLOCKRUNNING, D12_SETTOONE);
	//2014/12/30 D12_NOLAZYCLOCKɗLƂ悤ɕύX܂B
	D12_SetMode(usb_inf.mode | D12_SOFTCONNECT | D12_CLOCKRUNNING | D12_NOLAZYCLOCK, D12_SETTOONE);
	LEAVE_CS;
}

void
usb_stop()
{
	int T0;

	/* tbNĂȂΉ܂B */
	if(old_usb_isr == NULL) return;

	/* USBؒfB */
	ENTER_CS;
	D12_SetMode(0, D12_SETTOONE);
	LEAVE_CS;

	/* zXgؒfoł悤ɁAEFCgB */
	T0 = pceTimerGetCount();
	while(pceTimerGetCount() - T0 < RECONNECT_WAIT) { }

	/* USBC荞݂ɖ߂B */
	pceVectorSetTrap(TRAP_USBC, old_usb_isr);
	old_usb_isr = NULL; /* tbNƂ}[N */

	/* J[lUSB䌠𕜋AB */
	pceUSBReconnect();
}

void
usb_ep0_tx(const void* ptr, int len)
{
	/* dv
	 * * GETNGXgւ̉ŁAwLength傫ȃTCỸf[^𑗂ԂƂƁA
	 *   zXgƂ̏ԑJڂ̓@ȂȂAusȃfoCXvɂȂĂ܂܂I
	 * * ႦGET_DESCRIPTOR(CONFIGURATION)̏ꍇA܂wLength=9ŗv݂łB(Win2KŊmF)
	 *   ӂARtBM[VfBXNv^9oCgł͎܂Ȃ̂ŁA
	 *   RtBM[VfBXNv^Ŝ̐擪9oCgԂ悤ɂ܂B
	 *   ƁAzXgƑ傫wLengthw肵āAēxGET_DESCRIPTORv悤łB
	 * * wLength=9Ȃ̂9oCgȏ̃f[^𑗂ԂƂƁAOq̂Ƃn}܂B
	 *   vӂłII
	 * * wLength邩ƂāAXg[Ă܂Ă͂܂I
	 *   wLength́̕AԂKv܂B
	 *   Xg[Ă܂ƁA͂usȃfoCXvɂȂĂ܂܂B
	 * * wLengthQƂăf[^TCY؂l߂Ƃ́A{d12usr.c̃foCXNGXgnhōsׂłB
	 *   AɕKvȍƂȂ̂ŁAł܂Ƃ߂Đ؂l߂Ă܂Ƃɂ܂B
	 *   d12usr.c̃foCXNGXgnh́AMf[^؂l߂ꂽƂ֒m܂B
	 * [usb_20.pdf p.253]
	 * The wLength field specifies the number of bytes to return. If the descriptor is longer than the wLength field,
	 * only the initial bytes of the descriptor are returned. If the descriptor is shorter than the wLength field, the
	 * device indicates the end of the control transfer by sending a short packet when further data is requested. A
	 * short packet is defined as a packet shorter than the maximum payload size or a zero length data packet (refer
	 * to Chapter 5).
	 */
	if(control_xfer.device_request.bmRequestType & 0x80) { /* Data transfer direction = Device-to-host (GET) */
		if(len > control_xfer.device_request.wLength) len = control_xfer.device_request.wLength;
	}

	/* * GETNGXgɑ΂Rg[f[^Xe[W(M)ŁAf[^𑗐M邽߂ɗpꍇ́A
	 *    data_count=0 ɂȂĂ̂ŁAdata_count<-0 ̓_~[ƂȂ܂B
	 * * SETNGXgɑ΂Xe[^XXe[W(M)ŁApPbgԐM邽߂ɗpꍇ́A
	 *   Rg[f[^M̂߂ data_count gꂽȂ̂ŁAdata_count<-0 K{łB
	 * * Ƃ킯ŁAȒP̂߂ɁAł data_count<-0 sƂɂ܂B
	 */
	control_xfer.data_length = len;
	control_xfer.data_count = 0;
	control_xfer.data_ptr = ptr;

	/* ̃f[^]B(㑱̃f[^]Ƃ邱ƓȂ̂ŁA]nh𗘗p) */
	control_xfer.state = STATE_TXING; /* KvI */
//{{2007/12/08:MI[o[\Ƃ邽߂̎dlύX
//	ep0_txdone(D12_INT_ENDP0IN);
//2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	ep0_txdone();
//}}2007/12/08:MI[o[\Ƃ邽߂̎dlύX
	/* œ]Aep0_txdone() state=STATE_IDLE ɖ߂Ă܂B */
}

void
usb_ep0_stall()
{
	D12_SetEndpointStatus(EP0OUT, 1); /* EP0OUT(zXgfoCX)~ */
	D12_SetEndpointStatus(EP0IN , 1); /* EP0IN (foCXzXg)~ */
}

/*{{2005/07/31 ʓIȃfoCXNGXg̏܂B*/
static int
device_request_endpoint(const DEVICE_REQUEST* req)
{
	int endp;
	switch(req->wIndex) {
//{{2014/09/06ύX:device_request_endpoint()̃oOC܂BGh|Cgԍ̑ΉԈĂ܂B̃oOget_status()clear_feature()삵Ă܂łB͐삷悤ɂȂ܂B
//	case 0x00: endp = EP0OUT; break;
//	case 0x01: endp = EP0IN ; break;
//	case 0x02: endp = EP1OUT; break;
//	case 0x80: endp = EP1IN ; break;
//	case 0x81: endp = EP2OUT; break;
//	case 0x82: endp = EP2IN ; break;
//2014/09/06ύX:device_request_endpoint()̃oOC܂BGh|Cgԍ̑ΉԈĂ܂B̃oOget_status()clear_feature()삵Ă܂łB͐삷悤ɂȂ܂B
	case 0x00: endp = EP0OUT; break;
	case 0x80: endp = EP0IN ; break;
	case 0x01: endp = EP1OUT; break;
	case 0x81: endp = EP1IN ; break;
	case 0x02: endp = EP2OUT; break;
	case 0x82: endp = EP2IN ; break;
//}}2014/09/06ύX:device_request_endpoint()̃oOC܂BGh|Cgԍ̑ΉԈĂ܂B̃oOget_status()clear_feature()삵Ă܂łB͐삷悤ɂȂ܂B
	default:   endp = -1    ; break;
	}
	return endp;
}
/*{{2014/09/04ǉ:ʓIȃfoCXNGXg̏ɁAget_statusǉ܂B*/
static void
get_status(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	static const unsigned short status[2] = {0,1};	/* For device, D0=SelfPowered,D1=RemoteWakeup. For endpoint, D0=Halt. */
	PCEPWRSTAT ps;
	int endp;
	switch(req->bmRequestType & 0x1f) { /* recipient */
	case 0x00: /* device */
		pcePowerGetStatus(&ps); /* \usr\PIECE\sysdev\pcekn\powerman.c̎ƁA荞ݒɌďoĂSłB */
		usb_ep0_tx(&status[ps.status & 1], 2);	/* {SelfPowered=0,RemoteWakeup=0},,{SelfPowered=1,RemoteWakeup=0} */
		return;
	case 0x01: /* interface */
		goto L_ERR;
	case 0x02: /* endpoint */
		endp = device_request_endpoint(req);
		if(endp < 0) { goto L_ERR; }
		usb_ep0_tx(&status[D12_ReadEndpointStatus(endp) >> 7], 2);	/* {Halt=0},,{Halt=1} */
		return;
	}
L_ERR:
	usb_ep0_stall();
}
/*}}2014/09/04ǉ:ʓIȃfoCXNGXg̏ɁAget_statusǉ܂B*/
static void
clear_feature(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	int endp;
	switch(req->bmRequestType & 0x1f) { /* recipient */
	case 0x00: /* device */
		switch(req->wValue) {
		case 1: /* device remote wakeup */
			goto L_ERR;
		case 2: /* test mode */
			goto L_ERR;
		}
		goto L_ERR;
	case 0x01: /* interface */
		goto L_ERR;
	case 0x02: /* endpoint */
		switch(req->wValue) {
		case 0: /* endpoint halt */
			endp = device_request_endpoint(req);
			if(endp < 0) {
				goto L_ERR;
			}
			D12_SetEndpointStatus(endp, 0);	/* Stall */
			usb_ep0_tx(NULL, 0);		/* Ack */
			return;
		}
		goto L_ERR;
	}
L_ERR:
	usb_ep0_stall();
}
static void
set_address(const DEVICE_REQUEST* req, const unsigned char* dat, int len)
{
	D12_SetAddressEnable(req->wValue, 1);	/* Addressݒ */
	usb_ep0_tx(NULL, 0);			/* Ack */
}
/*}}2005/07/31 ʓIȃfoCXNGXg̏܂B*/
