/*	
 *	clipdfrg.c
 *
 *	s̃t@CftO@\܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Wed Aug 20 06:00:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Oct 28 20:03:00 JST 2003 Naoyuki Sawa
 *	- file_defrag()ɃTCY󂯎ǉB
 *	* Sun Feb  6 06:09:00 JST 2005 Naoyuki Sawa
 *	- ܂ł́Adefrag_sub()֐ԂƂAʂ"t@C𐮗񂵂Ă܂"\c܂܂łB
 *	  defrag_sub()AʍXVOɕʂ̗vŃG[IƁADefragɎŝ悤Ȍ܂B
 *	  ŁAdefrag_sub()֐ԂOɁAʂNAĂƂɂ܂B
 *	* Sun Jan 14 17:37:13 JST 2007 Naoyuki Sawa
 *	- AvP[VpceLCDDispStart()ĂԑOfile_defrag()ĂсAۂɃftOꍇɁA
 *	  ʕ\Off̂܂܂ŁAis󋵕\ȂƂsC܂B
 *	  ̓Iɂ́Adefrag_sub()Sy̐is󋵕\ZbgAbvɁApceLCDDispStart()ǉłB
 *	* Wed Dec 31 17:37:43 JST 2014 Naoyuki Sawa
 *	- cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B
 *	  ̕ύXɔA2007/01/14ɒǉpceLCDDispStart()͕svɂȂA폜܂B
 */
#include "clip.h"

/* Ɨp[NGA
 * * tbVtbVւ́Aڏ߂܂B
 *   sct1obt@, sct2sct1, obt@sct2 Ƃ菇œւ邱Ƃ͂ł܂B
 *                   ~~~~~~~~~~ꂪs
 *   ]āAZN^ւpobt@KvłB
 */
typedef struct _DEFRAG {
	const SYSTEMINFO* sip;		/* VXe */
	pffsMASTERBLOCK msb;		/* ǗubNǂݍݗp */
	unsigned char buf1[BLOCKSIZE];	/* ZN^ւpobt@ */
	unsigned char buf2[BLOCKSIZE];	/* () */
	//
	int mode;			/* 0:tbV݂Ȃ/1: */
	int fatcnt;			/* t@CVXẽZN^ */
	int wr_cnt;			/* tbVɏ񂾉(mode=0JEgAbv܂) */
} DEFRAG;

/* ZN^ԍLł邩A܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 * [note]
 *	* ZN^ԍLȂAɋA܂B
 *	  ZN^ԍsȂAG[bZ[W\Ē~܂B
 *	* FAT_FREE/END/INVALID/SYSTEMAsȃZN^ԍƌȂ܂B
 */
#define verify_sct(d, sct)					\
	do {							\
		if((sct) < 0 || (d)->fatcnt - 1 < (sct)) DIE();	\
	} while(0)

/* ZN^ԍɑΉ郁AhXvZ܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 * [out]
 *	߂l		AhXB
 */
static unsigned char*
sct_address(DEFRAG* d, int sct)
{
	verify_sct(d, sct);
	return d->sip->pffs_top + BLOCKSIZE * sct;
}

/* ZN^`FC̎̃ZN^擾܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 * [out]
 *	߂l		̃ZN^ԍB
 */
static int
next_sct(DEFRAG* d, int sct)
{
	/* w肳ꂽZN^ԍALȃZN^ԍł邱ƁB */
	verify_sct(d, sct);

	/* ̃ZN^ԍ擾B */
	sct = d->msb.fat[sct].chain;

	/* ʂȃZN^ԍA܂͗LȃZN^ԍł邱ƁB */
	switch(sct) {
	case FAT_FREE:
	case FAT_END:
	case FAT_INVALID:
	case FAT_SYSTEM:
		break;
	default:
		verify_sct(d, sct);
		break;
	}

	return sct;
}

/* ZN^ǂݍ݂܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 *	memp		ǂݍݐobt@B
 */
static void
read_sct(DEFRAG* d, int sct, unsigned char* memp)
{
	unsigned char* romp;

	romp = sct_address(d, sct); /* verify_sct()܂ */
	memcpy(memp, romp, BLOCKSIZE);
}

/* ZN^݂܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 *	memp		݌obt@B
 */
static void
write_sct(DEFRAG* d, int sct, const unsigned char* memp)
{
	unsigned char* romp;

	romp = sct_address(d, sct); /* verify_sct()܂ */
	if(memcmp(romp, memp, BLOCKSIZE) == 0) return; /* ɓeȂ珑sviőɂȂǁj */
	if(d->mode) {
		if(pceFlashErase(romp) != 0) DIE(); /* YȂŁI */
		if(pceFlashWrite(romp, memp, BLOCKSIZE) != 0) DIE();
	}
	d->wr_cnt++; /* mode=0݉񐔂̓JEgAbvi݂Kvǂf邽߁j */
}

/* wt@C̃fBNgGg܂B
 * [in]
 *	d		Ɨp[NGAB
 *	fname		t@C
 * [out]
 *	߂l		fBNgGgB
 */
static DIRECTORY*
find_dir(DEFRAG* d, const char* fname)
{
	int i;
	DIRECTORY* dir;

	dir = &d->msb.dir[0];
	for(i = 0; i < MAXDIR; i++) {
		if(dir->name[0] != '\xff') {
			if(strcmp(dir->name, fname) == 0) return dir;
		}
		dir++;
	}
	DIE();
	/* NO RETURN */
}

/* wZN^܂ރt@C̃fBNgGg܂B
 * [in]
 *	d		Ɨp[NGAB
 *	sct		ZN^ԍB
 * [out]
 *	߂l		fBNgGgB
 */
static DIRECTORY*
find_sctdir(DEFRAG* d, int sct)
{
	int i, sct2;
	DIRECTORY* dir;

	verify_sct(d, sct);
	dir = &d->msb.dir[0];
	for(i = 0; i < MAXDIR; i++) {
		if(dir->name[0] != '\xff') {
			sct2 = dir->chain;
			while(sct2 != FAT_END) {
				if(sct2 == sct) return dir;
				sct2 = next_sct(d, sct2);
			}
		}
		dir++;
	}
	DIE();
	/* NO RETURN */
}

/* wZN^ZN^`FCŉԖڂɈʒu邩𒲂ׂ܂B
 * [in]
 *	d		Ɨp[NGAB
 *	dir		fBNgGgB
 *	sct		ZN^ԍB
 * [out]
 *	߂l		ԁB
 */
static int
find_sct(DEFRAG* d, DIRECTORY* dir, int sct)
{
	int sct2, ord;

	verify_sct(d, sct);
	sct2 = dir->chain;
	ord = 0;
	while(sct2 != FAT_END) {
		if(sct2 == sct) return ord;
		sct2 = next_sct(d, sct2);
		ord++;
	}
	DIE();
	/* NO RETURN */
}

/* ZN^`FCŎw肳ꂽԂ̃ZN^擾܂B
 * [in]
 *	d		Ɨp[NGAB
 *	dir		fBNgGgB
 *	ord		ԁB
 * [out]
 *	߂l		ZN^ԍB
 */
static int
get_sct(DEFRAG* d, DIRECTORY* dir, int ord)
{
	int sct;

	sct = dir->chain;
	while(ord != 0) {
		sct = next_sct(d, sct);
		ord--;
	}
	return sct;
}

/* t@C̃ZN^擾܂B
 * [in]
 *	d		Ɨp[NGAB
 *	dir		fBNgGgB
 * [out]
 *	߂l		ZN^B
 */
static int
get_sctcnt(DEFRAG* d, DIRECTORY* dir)
{
	int sct, sctcnt;

	sct = dir->chain;
	sctcnt = 0;
	while(sct != FAT_END) {
		sct = next_sct(d, sct);
		sctcnt++;
	}
	return sctcnt;
}

/* ZN^`FCAw肳ꂽZN^폜܂B
 * [in]
 *	d		Ɨp[NGAB
 *	dir		fBNgGgB
 *	sct		ZN^ԍB
 */
static void
remove_sct(DEFRAG* d, DIRECTORY* dir, int sct)
{
	int ord, sct2, sct3;

	ord = find_sct(d, dir, sct); /* verify_sct()܂ */
	sct2 = next_sct(d, sct);
	if(ord == 0) {
		dir->chain = sct2;
	} else {
		sct3 = get_sct(d, dir, ord - 1);
		d->msb.fat[sct3].chain = sct2;
	}
	d->msb.fat[sct].chain = FAT_FREE;
}

/* ZN^`FC̎w肳ꂽʒuɁAZN^ǉ܂B
 * [in]
 *	d		Ɨp[NGAB
 *	dir		fBNgGgB
 *	ord		ԁB
 *	sct		ZN^ԍB
 */
static void
insert_sct(DEFRAG* d, DIRECTORY* dir, int ord, int sct)
{
	int sct2, sct3;

	verify_sct(d, sct);
	if(d->msb.fat[sct].chain != FAT_FREE) DIE();
	sct2 = get_sct(d, dir, ord);
	if(ord == 0) {
		dir->chain = sct;
	} else {
		sct3 = get_sct(d, dir, ord - 1);
		d->msb.fat[sct3].chain = sct;
	}
	d->msb.fat[sct].chain = sct2;
}

/* ftȌs܂B
 * [in]
 *	mode		0w肷ƃtbVւ݂͍̏s킸AeXĝ݂ƂȂ܂B
 *			1w肷ƃtbVւ݂̏s܂B
 * [out]
 *	߂l		Ɨp[NGAB
 */
static DEFRAG*
defrag_init(int mode)
{
	DEFRAG* d;

	/* Ɨp[NGAmۂ܂B */
	d = (DEFRAG*)calloc(1, sizeof(DEFRAG));
	if(d == NULL) DIE();

	/* [hi[܂B */
	d->mode = mode;

	/* VXe擾܂B */
	d->sip = pceSystemGetInfo();

	/* t@CVXẽZN^߂܂B */
	d->fatcnt = (d->sip->pffs_end - d->sip->pffs_top) / BLOCKSIZE;
	if(d->fatcnt <      0) DIE();
	if(d->fatcnt > MAXFAT) DIE();

	/* ǗubNǂݍ݂܂B */
	if(sizeof(pffsMASTERBLOCK) != BLOCKSIZE) DIE(); /* BIOS1.18(2MB)܂BIOS1.20(512KB/2MB)ȍ~AȂĂ܂ */
	read_sct(d, 0, (unsigned char*)&d->msb);

	/* ǗubN܂B */
	if((int)d->msb.mark.ptr != (int)d->sip->pffs_top + 4) DIE(); /* /usr/PIECE/tools/isd/isdsub.c ismPFFSInit() Q */
	if(strcmp(d->msb.mark.signature, "PFFS Master Block") != 0) DIE();

	return d;
}

/* ftȌIs܂B
 * [in]
 *	d		Ɨp[NGAB
 */
static void
defrag_exit(DEFRAG* d)
{
	/* ǗubN߂܂B */
	if(sizeof(pffsMASTERBLOCK) != BLOCKSIZE) DIE(); /* BIOS1.18(2MB)܂BIOS1.20(512KB/2MB)ȍ~AȂĂ܂ */
	write_sct(d, 0, (unsigned char*)&d->msb);

	/* Ɨp[NGAJ܂B */
	free(d);
}

/* t@C𐮗񂵂܂B(file_defrag()痘p)
 * [in]
 *	fname		t@CB
 *	mode		0w肷ƃtbVւ݂͍̏s킸AeXĝ݂ƂȂ܂B
 *			1w肷ƃtbVւ݂̏s܂B
 * [out]
 *	߂l		Ƀt@C񂳂ĂA0Ԃ܂B
 *			t@C񂳂ĂȂ΁A1Ԃ܂B
 * [note]
 *	* ܂mode=0(eXg)defrag_sub()ĂяoAt@CVXeĂȂƂmFĂB
 *	  Ȃmode=1(s)ŌĂяoƁAftOƂ̓rŃAT[gꍇɊ댯łB
 *	* mode=0(eXg)defrag_sub()ĂяoA߂l0ȊO(񂳂ĂȂ)ꍇ̂݁A
 *	  mode=1(s)w肵Ăxdefrag_sub()ĂяoĂB
 */
static int
defrag_sub(const char* fname, int mode)
{
	DEFRAG* d;
	DIRECTORY *dir1, *dir2;
	int sctorg, sctcnt, sct1, sct2, ord1, ord2, wr_cnt;
	unsigned char* vbuff_save;
	PCEPWRSTAT ps;

	/*{{is󋵕\*/
	vbuff_save = NULL; /* x} */
	if(mode) {
		vbuff_save = pceLCDSetBuffer(_def_vbuff);
	//sv	pceLCDDispStart(); /*{{2007/01/14ǉ}}*/	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
		pceFontSetType(0x80);
		pceFontSetTxColor(3);
		pceFontSetBkColor(-1);
		pcePowerGetStatus(&ps);
	}
	/*}}is󋵕\*/

	/* B */
	d = defrag_init(mode);

	/* 񂷂t@C̃fBNgGg܂B */
	dir1 = find_dir(d, fname);

	/* ̐擪ZN^ԍ肵܂B */
	sctorg = dir1->chain;
	sctcnt = get_sctcnt(d, dir1);
	if(sctorg + sctcnt > d->fatcnt) sctorg = d->fatcnt - sctcnt;

	/* 񂷂t@C̊eZN^ɂāc */
	sct1 = dir1->chain;
	ord1 = 0;
	while(sct1 != FAT_END) {
		/*{{is󋵕\*/
		if(mode) {
			memset(_def_vbuff, 0, DISP_X * DISP_Y);
			pceFontSetPos(0, 10);
			// pceFontPrintf()̌ĂяoőSƂƁA
			// 񂪒ănOAbv܂Bv!!
			//             OPQRSTUVWXOPQ
			pceFontPrintf("t@C𐮗񂵂Ă܂B\n");
			pceFontPrintf("\n");
			pceFontPrintf("~%s𔲂Ȃ!\n", ps.status ? "dr" : "USBP[u");
			pceFontPrintf("~P/ECEZbgȂ!\n");
			pceFontPrintf("\n");
			pceFontPrintf("    is(%3d/%3d)\n", ord1 + 1, sctcnt);
			pceLCDTrans();
		}
		/*}}is󋵕\*/

		sct2 = sctorg + ord1; /* ʒũZN^ԍ */
		if(sct1 != sct2) { /* H */
			if(d->msb.fat[sct2].chain == FAT_FREE) {
				/*--- ʒũZN^gpĂȂꍇ ---*/
				/* ZN^u܂B */
				read_sct(d, sct1, d->buf1);	 /* ZN^ǂݍ */
				remove_sct(d, dir1, sct1);	 /* ZN^폜 */
				write_sct(d, sct2, d->buf1);	 /* ZN^߂ */
				insert_sct(d, dir1, ord1, sct2); /* ZN^ǉ */
			} else {
				/*--- ʒũZN^̃t@CɎgpĂꍇ ---*/
				/* ʒũZN^܂ރt@CT܂Big̃`FCɊ܂܂Ă\܂j */
				dir2 = find_sctdir(d, sct2);
				ord2 = find_sct(d, dir2, sct2);
				/* g̃`FCɊ܂܂ĂꍇA͌ł͂łBiO͐ς݂̂͂j */
				if(dir1 == dir2) {
					if(ord1 >= ord2) DIE();
				}
				/* * ̃ZN^ւ܂B
				 * - Ƃg̃`FCɊ܂܂ĂꍇAsct1̕sct2Oɑ݂͂łB
				 *   폜^ǉɏԂȂ悤A폜̏Ԃsct2sct1Aǉ̏Ԃsct1sct2 Ƃ܂B
				 * - ʁX̃t@CɊ܂܂Ăꍇ͍폜Eǉ̏Ԃ͊֌WȂ̂ŁȀꍇ菇Ƃ܂B
				 */
				read_sct(d, sct1, d->buf1);	 /* ̃ZN^ǂݍ */
				read_sct(d, sct2, d->buf2);
				remove_sct(d, dir2, sct2);	 /* sct2Asct1̏ɍ폜 */
				remove_sct(d, dir1, sct1);
				write_sct(d, sct1, d->buf2);	 /* ̃ZN^ւď߂ */
				write_sct(d, sct2, d->buf1);
				insert_sct(d, dir1, ord1, sct2); /* sct1Asct2̏ɒǉ */
				insert_sct(d, dir2, ord2, sct1);
			}
		}
		sct1 = next_sct(d, sct2/*v!sct1Ȃ!*/);
		ord1++;
	}
	if(ord1 != sctcnt) DIE();

	/*{{is󋵕\*/
	if(mode) {
		/* * Sun Feb  6 06:09:00 JST 2005 Naoyuki Sawa
		 * - ܂ł́Adefrag_sub()֐ԂƂAʂ"t@C𐮗񂵂Ă܂"\c܂܂łB
		 *   defrag_sub()AʍXVOɕʂ̗vŃG[IƁADefragɎŝ悤Ȍ܂B
		 *   ŁAdefrag_sub()֐ԂOɁAʂNAĂƂɂ܂B
		 */
		memset(_def_vbuff, 0, DISP_X * DISP_Y);
		pceLCDTrans();
	}
	/*}}is󋵕\*/

	/* tbVւ̏݉񐔂oĂ܂B */
	wr_cnt = d->wr_cnt;

	/* IB */
	defrag_exit(d);

	/*{{is󋵕\*/
	if(mode) {
		pceLCDSetBuffer(vbuff_save);
	}
	/*}}is󋵕\*/

	return wr_cnt;
}

/* t@C𐮗񂵂܂B
 * [in]
 *	fname		t@CB
 *	size		t@CTCYi[ϐւ̃|C^B
 *			t@CTCYKvȂ΁ANULLw肵ĂB
 * [out]
 *	߂l		񂵂t@C̐擪AhXB
 *	*size		t@C݂AAZN^ɔzuĂAt@CTCYi[܂B
 *			AsizeNULL|C^w肳Ăꍇ́Ai[܂B
 */
const void*
file_defrag(const char* fname, int* size)
{
	int turbo_save;

	turbo_save = turbo(0);		/* pceFlashErase/Write()48MHzł͓삵Ȃ̂ŁAmɒʏ탂[hɂĂ */

	if(defrag_sub(fname, 0) != 0) {	/* eXgA񂳂ĂȂꍇ̂݁EEE */
		defrag_sub(fname, 1);	/* ݂ŎsB                               */
	}

	turbo(turbo_save);		/* ̃Xs[hɖ߂ */

	return file_address(fname, size);
}

