/*	
 *	clipcp8.c
 *
 *	P/ECE CHIP-8 Interpreter
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Mar 18 21:17:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipcp8i.h"	/*CHIP-8C^v^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/*
 *	CXgNV֐/̃e[u
 */
#undef CHIP8FN_
#define CHIP8FN_(CODE, DESC)	chip8op_##CODE,
const CHIP8OP chip8_op_table[/*CHIP8OP_????*/] = {
#include "chip8/list.h"
};
#undef CHIP8FN_
#define CHIP8FN_(CODE, DESC)	#CODE " - " DESC,
const char* const chip8_op_name_table[/*CHIP8OP_????*/] = {
#include "chip8/list.h"
};
#undef CHIP8FN_

/*
 *	4x5sNZtHgp^[
 */
static const unsigned char chip8_font4x5[16/*0-F*/][5/*Line*/] = {
	{0xf0,0x90,0x90,0x90,0xf0}, /*0*/
	{0x20,0x60,0x20,0x20,0x70}, /*1*/
	{0xf0,0x10,0xf0,0x80,0xf0}, /*2*/
	{0xf0,0x10,0xf0,0x10,0xf0}, /*3*/
	{0x90,0x90,0xf0,0x10,0x10}, /*4*/
	{0xf0,0x80,0xf0,0x10,0xf0}, /*5*/
	{0xf0,0x80,0xf0,0x90,0xf0}, /*6*/
	{0xf0,0x10,0x20,0x40,0x40}, /*7*/
	{0xf0,0x90,0xf0,0x90,0xf0}, /*8*/
	{0xf0,0x90,0xf0,0x10,0xf0}, /*9*/
	{0xf0,0x90,0xf0,0x90,0x90}, /*A*/
	{0xe0,0x90,0xe0,0x90,0xe0}, /*B*/
	{0xf0,0x80,0x80,0x80,0xf0}, /*C*/
	{0xe0,0x90,0x90,0x90,0xe0}, /*D*/
	{0xf0,0x80,0xf0,0x80,0xf0}, /*E*/
	{0xf0,0x80,0xf0,0x80,0x80}, /*F*/
};

/*
 *	8x10sNZtHgp^[
 */
static const unsigned char chip8_font8x10[16/*0-F*/][10/*Line*/] = {
	{0xf0,0xf0,0x90,0x90,0x90,0x90,0x90,0x90,0xf0,0xf0}, /*0*/
	{0x20,0x20,0x60,0x60,0x20,0x20,0x20,0x20,0x70,0x70}, /*1*/
	{0xf0,0xf0,0x10,0x10,0xf0,0xf0,0x80,0x80,0xf0,0xf0}, /*2*/
	{0xf0,0xf0,0x10,0x10,0xf0,0xf0,0x10,0x10,0xf0,0xf0}, /*3*/
	{0x90,0x90,0x90,0x90,0xf0,0xf0,0x10,0x10,0x10,0x10}, /*4*/
	{0xf0,0xf0,0x80,0x80,0xf0,0xf0,0x10,0x10,0xf0,0xf0}, /*5*/
	{0xf0,0xf0,0x80,0x80,0xf0,0xf0,0x90,0x90,0xf0,0xf0}, /*6*/
	{0xf0,0xf0,0x10,0x10,0x20,0x20,0x40,0x40,0x40,0x40}, /*7*/
	{0xf0,0xf0,0x90,0x90,0xf0,0xf0,0x90,0x90,0xf0,0xf0}, /*8*/
	{0xf0,0xf0,0x90,0x90,0xf0,0xf0,0x10,0x10,0xf0,0xf0}, /*9*/
	{0xf0,0xf0,0x90,0x90,0xf0,0xf0,0x90,0x90,0x90,0x90}, /*A*/
	{0xe0,0xe0,0x90,0x90,0xe0,0xe0,0x90,0x90,0xe0,0xe0}, /*B*/
	{0xf0,0xf0,0x80,0x80,0x80,0x80,0x80,0x80,0xf0,0xf0}, /*C*/
	{0xe0,0xe0,0x90,0x90,0x90,0x90,0x90,0x90,0xe0,0xe0}, /*D*/
	{0xf0,0xf0,0x80,0x80,0xf0,0xf0,0x80,0x80,0xf0,0xf0}, /*E*/
	{0xf0,0xf0,0x80,0x80,0xf0,0xf0,0x80,0x80,0x80,0x80}, /*F*/
};

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

void
chip8_reset(CHIP8* chip8)
{
	ASSERT(sizeof(CHIP8) == CHIP8_SIZE);

	/* ܂NAB */
	memset(chip8, 0, sizeof(CHIP8));

	/* tHgp^[]܂B */
	memcpy(&MEM(CHIP8_FONT4x5_ADDRESS ), chip8_font4x5 , sizeof chip8_font4x5 );
	memcpy(&MEM(CHIP8_FONT8x10_ADDRESS), chip8_font8x10, sizeof chip8_font8x10);

	/* vOJE^܂B */
	P = CHIP8_RESET_VECTOR;
}

void
chip8_tick(CHIP8* chip8, int count)
{
	DT = DT > count ? DT - count : 0;
	ST = ST > count ? ST - count : 0;
}

void
chip8_dump(CHIP8* chip8)
{
#define INDENT	40
	TRACE("%*s", INDENT, "");
	TRACE("V0 V1 V2 V3 V4 V5 V6 V7 V8 V9 VA VB VC VD VE VF I   DT ST P   S  MODE\n");
	TRACE("%*s", INDENT, "");
	//     V0   V1   V2   V3   V4   V5   V6   V7   V8   V9   VA   VB   VC   VD   VE   VF   I    DT   ST   P    S    MODE
	TRACE("%02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %03x %02x %02x %03x %02x %s\n",
		V0, V1, V2, V3, V4, V5, V6, V7, V8, V9, VA, VB, VC, VD, VE, VF,
		I & CHIP8_MEM_MASK, DT, ST, P & CHIP8_MEM_MASK, S, STAT & CHIP8_SCHIP ? "SCHIP" : "CHIP-8 ");
#undef INDENT
}

int
chip8_load(CHIP8* chip8, const char* fname)
{
	int result = -1;
	FILE* fp = NULL;
	//
	int retval, size;

	/* t@CJ܂B */
	fp = fopen(fname, "rb");
	if(!fp) return -1; /* t@CJȂ */

	/* t@CTCY擾܂B */
	retval = fseek(fp, 0, SEEK_END);
	if(retval != 0) goto L_EXIT; /* V[NG[ */
	size = ftell(fp);
	rewind(fp); /* NOTE: rewind()֐͖߂lł */

	/* t@CTCY܂B */
	if(size < 2) goto L_EXIT; /* t@CTCYs */
	if(size > CHIP8_PROGRAM_SIZE) goto L_EXIT; /* t@CTCY */

	/* t@C[h܂B */
	retval = fread(&MEM(CHIP8_PROGRAM_ADDRESS), 1, size, fp);
	if(retval != size) goto L_EXIT; /* [hG[ */

	/* łB */
	result = 0;

L_EXIT:
	/* t@CJĂA܂B */
	if(fp) {
		fclose(fp);
		fp = NULL;
	}

	return result;
}

int
chip8_test(const char* fname, int cycle)
{
	int result = -1;
	CHIP8* chip8 = NULL;
	//
	int retval;

	/* cycle=0w肳ꂽAlƂ1000߃eXg邱Ƃɂ܂B() */
	if(!cycle) cycle = 1000;

	/* eXgpCHIP8RAmۂ܂B */
	chip8 = (CHIP8*)calloc(1, sizeof(CHIP8));
	if(!chip8) DIE(); /* s̓G[I */

	/* CHIP8RAZbg܂B */
	chip8_reset(chip8);

	/* t@C[h܂B */
	retval = chip8_load(chip8, fname);
	if(retval != 0) goto L_EXIT; /* [hG[ */

	/* vOsĂ݂܂B */
	chip8_run(chip8, cycle);

	/* s߂ȂŎsACHIP-8vOƌȂ܂B */
	if(!(STAT & CHIP8_ILL)) result = 0;

L_EXIT:
	/* CHIP8RAmۂĂAJ܂B */
	if(chip8) {
		free(chip8);
		chip8 = NULL;
	}

	/* eXgʂԂ܂B */
	return result;
}

/****************************************************************************
 *
 ****************************************************************************/

#ifdef PIECE

asm("
	.code
	.global chip8_run2
chip8_run2:
	pushn %r0
	ld.w %r0, %sp		; X^bNޔ
	xld.w %r10, 0x1000	; 0x0e00`0x1000ɃX^bNؑ
	ld.w %sp, %r10
	xcall chip8_run
	ld.w %sp, %r0		; X^bN
	popn %r0
	ret
");

#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

