/*	
 *	clipvgm.c
 *
 *	P/ECE VGM Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Jan 12 18:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	VGMhCo֐
 ****************************************************************************/

int
vgm_init(VGMDRIVER* vgm, const char* fname)
{
	int retval;
	VGMHEADER* header = &vgm->header;
	SN76489* sn76489 = &vgm->sn76489;

	/* ܂NAB */
	memset(vgm, 0, sizeof(VGMDRIVER));

	/* VGM/VGZt@CJ܂B
	 * 񈳏kVGM`̏ꍇgzio֐Q߂Ă̂ŁAʕsvłB
	 */
	vgm->file = gzopen(fname, "rb");
	if(!vgm->file) goto L_ERR;

	/* VGMt@Cwb_ǂݍ݂܂B */
	retval = gzread(vgm->file, header, sizeof(VGMHEADER));
	if(retval != sizeof(VGMHEADER)) goto L_ERR;

	/* VOl`B */
	if(memcmp(header->signature, "Vgm ", 4) != 0) goto L_ERR;

	/* SN76489ZbgB */
	if(!header->psg_clock) goto L_ERR; /* PSGTEhȂ? */
	sn76489_reset(sn76489, header->psg_clock);

	/* isJE^ZbgB */
	vgm->progress = -VGMSAMPLERATE;

	return 0; /*  */
L_ERR:
	vgm_free(vgm);
	return -1; /* s */
}

void
vgm_free(VGMDRIVER* vgm)
{
	/* mgzipXg[܂B */
	if(vgm->file) {
		gzclose(vgm->file);
		vgm->file = NULL;
	}
}

int
vgm_stream_callback(short* wbuff, int param)
{
	return vgm_mix((VGMDRIVER*)param, wbuff);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

static VGMDRIVER g_vgm; /* STATICł! */

int
vgm_play(const char* fname)
{
	/* ܂mɒ~܂B */
	vgm_stop();

	/* VGMhCo܂B */
	if(vgm_init(&g_vgm, fname) != 0) return -1;

	/* Xg[ĐJn܂B */
	stream_play(VGMBUFLEN, vgm_stream_callback, (int)&g_vgm, 0);

	return 0;
}

void
vgm_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* VGMhCoN[Abv܂B(Kv!!) */
	vgm_free(&g_vgm);
}

