/*	
 *	cliptime.c
 *
 *	S1C33 Family CRpCpbP[W̎֐u܂B
 *	S1C33 Family CRpCpbP[W̎֐͂قƂǃ_~[łB
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue May 11 21:10:00 JST 2004 Naoyuki Sawa
 *	- 1st[XB
 *	* Wed Feb 22 00:00:00 JST 2006 Naoyuki Sawa
 *	- include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

/*{{2006/02/22 include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B*/
//clock_t clock() { DIE(); }                     // ĂяovZXgCPUԂԂ܂BP/ECEł͈ӖȂ̂ŖłB
//time_t time(time_t* timer);                    // GMT1970/1/1 00:00:00̌oߕbԂ܂B
//time_t mktime(struct tm* timeptr);             // tm\̂GMT1970/1/1 00:00:00̌oߕbɕϊ܂BGMT<=>JSTϊ͍s܂B
//struct tm* gmtime(const time_t* timer);        // GMT1970/1/1 00:00:00̌oߕbtm\̂ɕϊ܂BGMT<=>JSTϊ͍s܂B
//struct tm* localtime(const time_t* timer);     // GMT1970/1/1 00:00:00̌oߕbJSTɕϊAtm\̂ɕϊ܂B
//char* asctime(const struct tm* timeptr);       // tm\̂𕶎ɕϊAsR[ht܂BGMT<=>JSTϊ͍s܂B
//char* ctime(const time_t* timer);              // GMT1970/1/1 00:00:00̌oߕbJSTɕϊAɕɕϊ܂B
//double difftime(time_t timer1, time_t timer0); // ̎Ԃ̍bPʂŕԂ܂B
/*}}2006/02/22 include/time.hɂANSI`̊֐錾ŝŁÃW[łANSI`֐錾͕svƂȂ܂B*/

/*****************************************************************************
 *	
 *****************************************************************************/

#define TZ_BIAS (9 * 60 * 60)	/* OjbWW(GMT)ƖΕW(JST)̎ԍ[] JST=GMT+TZ_BIAS */

static const short mtbl[2/*0:ʏ/1:邤N*/][12] = {{
	/*1/1` 1/1*/0,
	/*1/1` 2/1*/31,
	/*1/1` 3/1*/31+28,
	/*1/1` 4/1*/31+28+31,
	/*1/1` 5/1*/31+28+31+30,
	/*1/1` 6/1*/31+28+31+30+31,
	/*1/1` 7/1*/31+28+31+30+31+30,
	/*1/1` 8/1*/31+28+31+30+31+30+31,
	/*1/1` 9/1*/31+28+31+30+31+30+31+31,
	/*1/1`10/1*/31+28+31+30+31+30+31+31+30,
	/*1/1`11/1*/31+28+31+30+31+30+31+31+30+31,
	/*1/1`12/1*/31+28+31+30+31+30+31+31+30+31+30,
},{
	/*1/1` 1/1*/0,
	/*1/1` 2/1*/31,
	/*1/1` 3/1*/31+29,
	/*1/1` 4/1*/31+29+31,
	/*1/1` 5/1*/31+29+31+30,
	/*1/1` 6/1*/31+29+31+30+31,
	/*1/1` 7/1*/31+29+31+30+31+30,
	/*1/1` 8/1*/31+29+31+30+31+30+31,
	/*1/1` 9/1*/31+29+31+30+31+30+31+31,
	/*1/1`10/1*/31+29+31+30+31+30+31+31+30,
	/*1/1`11/1*/31+29+31+30+31+30+31+31+30+31,
	/*1/1`12/1*/31+29+31+30+31+30+31+31+30+31+30,
}};

static const char* const wday_table[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
static const char* const mon_table[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

static void
tm_test(const struct tm* timeptr)
{
	if(timeptr->tm_year < 1970 - 1900 || timeptr->tm_year > 2038 - 1900) DIE(); /* 1970`2038NAi[l70`138 */
	if(timeptr->tm_mon  <    1 -    1 || timeptr->tm_mon  >   12 -    1) DIE(); /*    1`  12Ai[l 0` 11 */
	if(timeptr->tm_mday <    1        || timeptr->tm_mday >   31       ) DIE(); /*    1`  31Ai[l 1` 31 */
	if(timeptr->tm_hour <    0        || timeptr->tm_hour >   23       ) DIE(); /*    0`  23Ai[l 0` 23 */
	if(timeptr->tm_min  <    0        || timeptr->tm_min  >   59       ) DIE(); /*    0`  59Ai[l 0` 59 */
	if(timeptr->tm_sec  <    0        || timeptr->tm_sec  >   59       ) DIE(); /*    0`  59bAi[l 0` 59 */
}

/*****************************************************************************
 *	
 *****************************************************************************/

time_t
time(time_t* timer)
{
	PCETIME ptime;
	struct tm tm;
	time_t t;

	/* VXe(JST)擾܂B */
	pceTimeGet(&ptime);

	/* 1970/1/1 00:00:00̌oߕb擾܂B */
	memset(&tm, 0, sizeof tm);
	tm.tm_year = ptime.yy - 1900;
	tm.tm_mon  = ptime.mm -    1;
	tm.tm_mday = ptime.dd;
	tm.tm_hour = ptime.hh;
	tm.tm_min  = ptime.mi;
	tm.tm_sec  = ptime.ss;
	t = mktime(&tm);
	if(t < 0) return t; /* G[ */

	/* JSTGMTɕϊ܂B */
	t -= TZ_BIAS;

	/* KvɉČʂi[܂B */
	if(timer) *timer = t;

	return t;
}

time_t
mktime(struct tm* timeptr)
{
	int days;
	time_t t;

	/* ܂B */
	tm_test(timeptr);

	/* 1970/1/1year/mon/mday܂ł̓B */
	days  = (timeptr->tm_year - 70) * 365;			/* 1970/1/1year/1/1܂ł̓ (b) */
	days += (timeptr->tm_year - 1) / 4;			/* 1900/1/1year/1/1܂ł̂邤N (b) 1901`2099N̊Oł͊ԈʂɂȂ܂ */
	days -= 17;						/* 1900/1/11970/1/1܂ł̂邤N {1904,08,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68} */
	days += mtbl[!(timeptr->tm_year % 4)][timeptr->tm_mon];	/* year/1/1year/mon/1܂ł̓ 1901`2099N̊Oł͊ԈʂɂȂ܂ */
	days += timeptr->tm_mday - 1;				/* year/mon/1year/mon/mday܂ł̓ */

	/* 1970/1/1year/mon/mday hour:min:sec܂ł̕bB */
	t  = (((days * 24) + timeptr->tm_hour) * 60 + timeptr->tm_min) * 60 + timeptr->tm_sec;

	return t;
}

struct tm*
gmtime(const time_t* timer)
{
	static struct tm tm;
	//
	time_t t;
	int leap;
	int days;

	/* ܂NAB */
	memset(&tm, 0, sizeof tm);

	/* AAb߂܂B */
	t = *timer;		/* t = 1970/1/1̌oߕb */
	tm.tm_sec  = t % 60;	/* bm */
	t /= 60;		/* t = 1970/1/1̌oߕ */
	tm.tm_min  = t % 60;	/* m */
	t /= 60;		/* t = 1970/1/1̌oߎ */
	tm.tm_hour = t % 24;	/* m */
	t /= 24;		/* t = 1970/1/1̌oߓ */

	/* NAAAjAŇoߓ߂܂B */
	tm.tm_wday = (t + 4/*1970/1/1͖ؗj*/) % 7;
	for(tm.tm_year = 1970 - 1900; tm.tm_year < 2038 - 1900; tm.tm_year++) {
		leap = !(tm.tm_year % 4); /* 邤N 1901`2099N̊Oł͊ԈʂɂȂ܂ */
		days = 365 + leap;
		if(t < days) break;
		t -= days;
	}
	tm.tm_yday = t; /* year/1/1̌oߓ */
	for(tm.tm_mon = 1 - 1; tm.tm_mon < 12 - 1; tm.tm_mon++) {
		if(t < mtbl[leap][tm.tm_mon + 1]) break;
	}
	t -= mtbl[leap][tm.tm_mon];
	tm.tm_mday = t + 1;

	return &tm;
}

struct tm*
localtime(const time_t* timer)
{
	time_t t = *timer + TZ_BIAS; /* GMTJSTɕϊ܂ */
	return gmtime(&t);
}

char*
asctime(const struct tm* timeptr)
{
	/*  000000000011111111112222QQ  */
	/*  012345678901234567890123ST  */
	/* "Wed Jan 02 02:03:55 1980\n\0" */
	static char buf[26];

	/* ܂B */
	tm_test(timeptr);

	/* 𕶎ɕϊ܂B */
	sprintf(buf, "%3s %3s %2d %02d:%02d:%02d %04d\n",
		wday_table[timeptr->tm_wday],
		mon_table[timeptr->tm_mon],
		timeptr->tm_mday,
		timeptr->tm_hour,
		timeptr->tm_min,
		timeptr->tm_sec,
		timeptr->tm_year + 1900);

	return buf;
}

char*
ctime(const time_t* timer)
{
	return asctime(localtime(timer));
}

double
difftime(time_t timer1, time_t timer0)
{
	return timer1 - timer0;
}

