/*	
 *	cliptask.h
 *
 *	^XNXPW[ (ReLXgXCb`)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2006 Naoyuki Sawa
 *
 *	* Fri Jun 09 22:27:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	  cliptask.h́AkeeptH_ɕۑ܂B
 *	* Wed Jun 14 00:44:00 JST 2006 Naoyuki Sawa
 *	- task_kill()ǉ܂B
 */
#ifndef __CLIP_TASK_H__
#define __CLIP_TASK_H__

/****************************************************************************
 *	^XN
 ****************************************************************************/

/* ^XN\  */
typedef struct _TASK {
	/*{{CAEgŒ*/
	int* sp;			/* %spۑ */
	/*}}CAEgŒ*/
	int suspend;			/* TXyh (1ȏ = ~, 0 = , 0 = ݒs) */
	int priority;			/* sDx (INT_MAX = ō ` 0 = ʏ ` INT_MIN = Œ) */
	int exit_code;			/* IR[h */
	LIST_ENTRY blocked_task_list;	/* ^XNXg                                                           */
					/* * Xg͋󂩁A܂́AB̏I҂^XNo^Ă܂B           */
					/*   ȏ̏I҂^XNo^Ă邱Ƃ́AL蓾܂B           */
					/*   - ̃^XN͏IĂ炸AI҂^XN͖  󃊃Xg           */
					/*   - ̃^XN͏IĂ炸AI҂^XN͗L  I҂^XNo^ */
					/*   - ̃^XN͏Iς݂łAI҂^XN͖  󃊃Xg           */
					/*   - ̃^XN͏Iς݂łAI҂^XN͗L  I҂^XNo^ */
	LIST_ENTRY task_list_entry;	/* e^XNXgւ̓o^p                                                          */
					/* * ̃^XNwI^XNxłꍇAK^XNXgɓo^Ă܂B  */
					/*   Ȃ킿Atask_list_entry.Flink!=NULLłAq́wI^XNxƋʂł܂B */
					/*   o^̃^XNXǵAȉ̒ʂłB                                          */
					/*   - s\łꍇAws\^XNXgx(ready_task_list)                   */
					/*   - ^XNI҂łꍇA^XŃw^XNXgx(TASK.blocked_task_list)  */
					/*   - Cxg҂łꍇACxǵw^XNXgx(EVENT.blocked_task_list) */
					/* * ̃^XNwI^XNx(Iς݁AAI҂^XNo^)łꍇA    */
					/*   Itask_list_entry.Flink=NULLƂāAwI^XNxł邱Ƃ܂B    */
} TASK;

/* ^XNXPW[܂B
 * [note]
 *	* ^XN@\𗘗pAvP[VAŏɈxĂяoĂB
 *	  ̊֐ĂяoɃ^XN@\𗘗p悤ƂƁAُ퓮ƂȂ܂B
 *
 *		int main() {
 *			...
 *			task_init(); // ^XN@\𗘗pȂ΁AKv!!
 *			...
 *		}
 *
 *	* task_init()Ƒ΂ɂȂA^XN@\̃N[Abv֐͂܂B
 *	  task_init()ĂяoAvP[VAIOɌĂяoKv̂֐͂܂B
 *	  ܂A̃^XNc܂܂ŁAAvP[VIĂ\܂B
 *
 *	* ̊֐ĂяoReLXgAVXeACh^XNƂēo^܂B
 *	  VXeACh^XN̎sDx́AINT_MIN(AChDx)ɌŒŁAύXł܂B
 *
 *	* VXeACh^XŃAIĂ͂܂B(task_exit()Ăяos)
 *	  ăVXeACh^XNIĂ܂ꍇ̓́A`łB
 *
 *		int main() {
 *			...
 *			task_init();
 *			...
 *			task_exit(0); // !!
 *		}
 */
void task_init();

/* s^XN擾܂B
 * [out]
 *	߂l		s^XNB
 * [note]
 *	* task_init()ĂяóAɉ炩̃^XNsłB
 *	  task_get_current()NULLԂƂ́A΂ɂ܂B
 */
TASK* task_get_current();

/* ^XN쐬܂B
 * [in]
 *	priority	sDxB
 *	task_proc	AvP[V`̃^XN֐B
 *	param		^XN֐ɈnAAvP[V`̃p[^B
 *	stack_size	X^bNTCYB(oCg)
 *			0w肷ƁÃX^bNTCY̗p܂B
 * [out]
 *	߂l		쐬^XNB
 * [note]
 *	* ^XN̎sDx́A^XN쐬Ɏw肵AȌAύX邱Ƃ͂ł܂B
 *	  ^XN̎sDxύX֐pӂ邱Ƃ͊ȒPłAۂ̃AvP[VɂāA
 *	  ^XN쐬ɎsDx̕ύXKvƂȂʂ͂܂ƍlāAėpӂ܂łB
 *
 *	* ^XN쐬́ATXyh񐔂̏l0łB(=TXyhĂȂ)
 *	  Ȃ킿Atask_create()Ăяo^XNA쐬ꂽ^XN̎sDxꍇA
 *	  task_create()Ԃ̂́A쐬ꂽ^XN邩A܂́AIƂȂ܂B
 *
 *		int main() {
 *			...
 *			task_init();                                 // sDx=INT_MIN
 *			...
 *			task1 = task_create(1, task1_proc, NULL, 0); // sDx=1
 *			// ̎_ŁAtask1͕Ă邩AɏIĂB
 *			...
 *		}
 *
 *		int task1_proc(void* param) {                        // sDx=1
 *			...
 *			task2 = task_create(0, task2_proc, NULL, 0); // sDx=0
 *			// ̎_ŁAtask2̏́A܂sĂȂB
 *			...
 *		}
 *
 *	* ԂŃTXyhĂ^XN쐬@́ApӂĂ܂B
 *	  KvȂ΁A^XN֐̐擪ɎgTXyh鏈zu邱ƂŎł܂B
 *
 *		int task_proc(void* param) {
 *			task_suspend(task_get_current());
 *			...
 *		}
 */
TASK* task_create(int priority, int (*task_proc)(void* param), void* param, int stack_size);

/* ^XNI܂B
 * [in]
 *	exit_code	IR[hB
 * [note]
 *	* ̊֐́AԂ܂B
 *
 *	* AvP[V`̃^XN֐́Aȉ̓ނ̕@Ń^XNIł܂B
 *
 *		1. IR[hw肵āAtask_exit()ĂяoB
 *
 *			int task_proc(void* param) {
 *				...
 *				task_exit(result);
 *			}
 *
 *		2. IR[h𔺂āA^XN֐returnB
 *
 *			int task_proc(void* param) {
 *				...
 *				return result;
 *			}
 */
void task_exit(int exit_code) __attribute__((noreturn));

/* ^XN̏I҂āA\[X܂B
 * [in]
 *	task		҂^XNB
 * [out]
 *	߂l		IR[hB
 * [note]
 *	* g̏I҂Ƃ͂ł܂B
 *	  g̏I҂ƂƂƁAAT[g܂B
 *
 *		reulst = task_wait(task_get_current()); // !!
 *
 *	* task_wait()ĂяoƂŁAI^XÑ\[X܂B
 *	  task_wait()ĂяoȂƁAI^XÑ\[XꂸɁAcĂ܂܂B
 *	  JԂ쐬^XNɑ΂ẮAtask_wait()ĂяoāA\[XĂB
 *
 *		for(;;) {
 *			...
 *			task = task_create(0, task_proc, NULL, 0);
 *			...
 *			result = task_wait(task); // Kv!!
 *			...
 *		}
 *
 *	* ̃^XN̏IÃ^XN҂Ƃ͂ł܂B
 *	  ̃^XN̏IÃ^XN҂ƂƂƁAAT[g܂B
 *
 *		TASK* task4;
 *
 *		int task1_proc(void* param) {
 *			...
 *			task4 = task_create(0, task4_proc, NULL, 0);
 *			...
 * 		}
 *
 *		int task2_proc(void* param) {
 *			...
 *			result = task_wait(task4); // ǂ炩!!
 *			...
 * 		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			result = task_wait(task4); // ǂ炩!!
 *			...
 * 		}
 */
int task_wait(TASK* task);

/* ^XN̏I҂ɁA\[X܂B
 * [in]
 *	task		I^XNB
 * [note]
 *	* gI邱Ƃ͂ł܂B
 *	  gI悤ƂƁAAT[g܂B
 *
 *		task_kill(task_get_current()); // !!
 *
 *	* ɏIĂ^XNɑ΂āAtask_kill()ĂяoƂł܂B
 *	  I^XNAɏIĂ邩ۂɂāAtask_kill()̌ʂɈႢ͂܂B
 *
 *	* ^XN1^XN2̏I҂ĂƂɁA^XN3^XN2I邱Ƃ͂ł܂B
 *	  ̂悤ȎdlƂŔA^XN1Ăяotask_wait()̖߂l`łȂ߂łB
 *
 *		int task1_proc(void* param) {
 *			...
 *			result = task_wait(task2);
 *			...
 *		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			task_kill(task2); // !!
 *			...
 *		}
 *
 *	  ̖ɂ́Ae^XN݌vɁAtask_wait()ɂă\[Xׂ^XNA
 *	  ܂́Atask_kill()ɂă\[Xׂ^XNAmɂĂKv܂B
 *
 *	* ^XN1^XN2̏I҂ă\[X邽߂ɁAtask_wait()ĂяoĕĂƂA
 *	  ^XN3^XN1IƁA^XN1̓^XN2̕^XNXgo^܂B
 *	  AvP[VÃP[XӎāAʂ̎iɂă^XN2̃\[XȂA
 *	  ^XN2̃\[X[NĂ܂܂B
 *
 *		int task1_proc(void* param) {
 *			...
 *			result = task_wait(task2); // ̌ĂяoԂO...
 *			...
 *		}
 *
 *		int task3_proc(void* param) {
 *			...
 *			task_kill(task1);          // ̌ĂяosƁAtask2\[X[N!!
 *			...
 *		}
 *
 *	  ̖́A^XÑ\[XɌ炸Atask1\[Xs^XNłꍇɁA
 *	  ̏sOɋIƁA\[X[NĂ܂łƌ܂B
 *	  Cuœɑ΍݂͐Ă܂̂ŁAAvP[VɂĒӂĂB
 */
void task_kill(TASK* task);

/* ^XÑTXyh񐔂𑝂₵܂B
 * [in]
 *	task		TXyh񐔂𑝂₷^XNB
 * [note]
 *	* TXyhINT_MAXāATXyh񐔂𑝂₷Ƃ͂ł܂B
 */
void task_suspend(TASK* task);

/* ^XÑTXyh񐔂炵܂B
 * [in]
 *	task		TXyh񐔂炷^XNB
 * [note]
 *	* TXyh0āATXyh񐔂炷Ƃ͂ł܂B
 */
void task_resume(TASK* task);

/****************************************************************************
 *	Cxg
 ****************************************************************************/

/* Cxg\  */
typedef struct _EVENT {
	int signal;			/* Cxg (0 = VOi, 1 = VOi) */
	int manual_reset;		/* Zbg敪 (0 = Zbg, 1 = 蓮Zbg) */
	LIST_ENTRY blocked_task_list;	/* ^XNXg */
} EVENT;

/* Cxg쐬܂B
 * [in]
 *	manual_reset	Zbg敪B
 *			0w肷ƁAZbgCxg쐬܂B
 *			1w肷ƁA蓮ZbgCxg쐬܂B
 * [out]
 *	߂l		쐬CxgB
 * [note]
 *	* Cxg̏Ԃ́AwVOiԁxłB
 *
 *	* event_create()̈ŁACxg̏Ԃw肷@́Ač̂܂łB
 *	  ԂŁwVOiԁx̃CxgKvƂȂP[X́A܂ƍlłB
 *	  KvȂ΁Aevent_create()̒ɁAevent_set()ĂяoĂB
 *
 *		event = event_create(0܂1); // VOi
 *		event_set(event);               //   VOi
 */
EVENT* event_create(int manual_reset);

/* Cxg폜܂B
 * [in]
 *	event		폜CxgB
 * [note]
 *	* Cxg҂́w^XNxcĂꍇACxg폜邱Ƃ͂ł܂B
 *	  Cxg폜悤ƂƁAAT[g܂B
 *
 *		int task1_proc(void* param) {
 *			...
 *			event = event_create(0܂1);
 *			task2 = task_create(0, task2_proc, NULL, 0);
 *			event_delete(event); // !!
 *			...
 *		}
 *
 *		int task2_proc(void* param) {
 *			...
 *			event_wait(event);
 *			...
 *		}
 */
void event_delete(EVENT* event);

/* Cxg҂܂B
 * [in]
 *	event		҂CxgB
 */
void event_wait(EVENT* event);

/* Cxg𔭍s܂B(Zbg)
 * [in]
 *	event		sCxgB
 * [note]
 *	* CxgԂwVOiԁxɂ܂B
 *	  Nw^XNx̐ƃCxgԂ̑Jڂ́AZbg敪Ɓw^XNx̗LɈˑ܂B
 *	  TˁAWindows̃Cxg֐ƓłBWindows̃Cxg֐dlQƂĂB
 */
void event_set(EVENT* event);

/* Cxg𔭍s܂B(pX)
 * [in]
 *	event		sCxgB
 * [note]
 *	* CxgԂwVOiԁxɂAɁwVOiԁxɖ߂܂B
 *	  Jw^XNx̐́AZbg敪Ɉˑ܂B
 *	  TˁAWindows̃Cxg֐ƓłBWindows̃Cxg֐dlQƂĂB
 */
void event_pulse(EVENT* event);

/* CxgVOiԂɂ܂B
 * [in]
 *	event		VOiԂɂCxgB
 */
void event_reset(EVENT* event);

#endif /*__CLIP_TASK_H__*/
