/*	
 *	clipmenu.c
 *
 *	ėpj[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Sat Jul 01 20:20:32 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Jul 02 15:36:40 JST 2006 Naoyuki Sawa
 *	- XN[ʒu(MENU.top)̐ݒA`撼O(menu_disp())ɍs悤ύXB
 *	* Sun Jul 02 21:27:56 JST 2006 Naoyuki Sawa
 *	- menu_disp()ɁAXN[̍s߂␳ǉ܂B
 *	  Ƃ΁Aj[ڐ5ŁAj[̈ɊSɕ\łs3̏ꍇA
 *	  ŏiڃCfNX34ɂȂƁAɖʂȋs\Ă܂܂B
 *	  XN[̍s߂␳ɂAŏiڃCfNX0`2ɐ܂B
 */
#include "clip.h"

/*****************************************************************************
 *	ėpj[
 *****************************************************************************/

const MENUPALETTE menu_palette_std = {	/*  4KWj[pbg */
	item   :  2,	/* j[ڕ */
	back   :  0,	/* j[ڔwi */
	title  :  0,	/* ^Cg */
	border :  3,	/* ^CgwiAсAg */
};
const MENUPALETTE menu_palette_ldir = {	/* 16KWj[pbg */
	item   : 10,	/* j[ڕ */
	back   :  0,	/* j[ڔwi */
	title  :  0,	/* ^Cg */
	border : 15,	/* ^CgwiAсAg */
};

/* MENU.font  tHg̍[sNZ] */
static const unsigned char font_h_tbl[3] = {
	10,	/* 5~10hbg{tHg */
	16,	/* 8~10hbgptHg */
	 6,	/* 4~ 6hbgptHg */
};

/* tHgTCYAj[̈ɊSɕ\łsZo܂B
 */
static int
calc_disp_rows(MENU* menu)
{
	int font_h;
	int disp_rows;

	font_h = font_h_tbl[menu->font];
	disp_rows = (menu->h - 1/*g*/
			     - (menu->title ? (font_h/*^Cg*/ + 1/*1C*/) : 0)
			     - 1/*g*/) / font_h;
	if(disp_rows < 1) {
		disp_rows = 1;
	}

	return disp_rows;
}

MENU*
menu_create()
{
	static const LIST_INFO str_list_info = {
		str_copy,	/*  */
		str_delete,	/* 폜 */
	};
	//
	MENU* menu;

	/* j[\̂̃mۂ܂B */
	menu = calloc(1, sizeof(MENU));
	if(!menu) {
		DIE();
	}

	/* j[\̂̏lݒ肵܂B */
	menu->sel = -1;				/* I𖳂 */
	//menu->top = 0;
	//
	//menu->x = 0;				/* ʑS̕\ */
	//menu->y = 0;
	menu->w = DISP_X;
	menu->h = DISP_Y;
	//menu->font = 0;			/* 10hbg{tHg */
	menu->palette = menu_palette_std;	/* 4KWj[pbg */
	//
	//menu->title = NULL;			/* ^Cg */
	menu->items = list_create(&str_list_info);

	return menu;
}

void
menu_delete(MENU* menu)
{
	/* ^Cgݒ肳ĂAJ܂B */
	free(menu->title);

	/* j[ڂ̃Xg폜܂B */
	list_delete(menu->items);

	/* j[\̂̃J܂B */
	free(menu);
}

void
menu_set_sel(MENU* menu, int sel)
{
	/* I𖳂A܂́ALȃCfNXł邱ƂmF܂B */
	if(sel < -1 ||
	   sel > menu_num_items(menu) - 1) {
		DIE();
	}
	menu->sel = sel;
}

int
menu_get_sel(MENU* menu)
{
	return menu->sel;
}

void
menu_set_pos(MENU* menu, int x, int y, int w, int h)
{
	menu->x = x;
	menu->y = y;
	menu->w = w;
	menu->h = h;
}

void
menu_set_font(MENU* menu, int font)
{
	/* stONA(K{!!)Ċi[܂B */
	font &= ~0x80;
	if(font < 0 || font > 2) {
		DIE();
	}
	menu->font = font;
}

void
menu_set_palette(MENU* menu, const MENUPALETTE* palette)
{
	/* pbg𕡐Ċi[܂B */
	menu->palette = *palette;
}

void
menu_set_title(MENU* menu, const char* title)
{
	/* ^Cgݒ肳ĂAJ܂B */
	free(menu->title);

	/* ^Cgw肳ĂA𕡐Ċi[܂B
	 * Ȃ΁ANULL(^Cg)Ƃ܂B
	 */
	if(title) {
		title = strdup(title);
		if(!title) {
			DIE();
		}
	}
	menu->title = (char*)title; /* x}̂߃LXg */
}

void
menu_add_item(MENU* menu, const char* item)
{
	/* ɁAj[ڂǉ܂B */
	menu_insert_item(menu, menu_num_items(menu), item);
}

void
menu_insert_item(MENU* menu, int i_item, const char* item)
{
	/* w肳ꂽʒuɁAj[ڂǉ܂B */
	list_insert(menu->items, i_item, (char*)item); /* x}̂߃LXg */

	/* ߂̃j[ڒǉȂ΁AIɂ̍ڂI܂B */
	if(menu_num_items(menu) == 1) {
		if(menu->sel != -1) {
			DIE(); /* L蓾Ȃ */
		}
		menu->sel = 0;
	}
}

void
menu_set_item(MENU* menu, int i_item, const char* item)
{
	/* w肳ꂽʒúAj[ڂύX܂B */
	list_set(menu->items, i_item, (char*)item); /* x}̂߃LXg */
}

void
menu_remove_item(MENU* menu, int i_item)
{
	/* w肳ꂽʒúAj[ڂ폜܂B */
	list_remove(menu->items, i_item);

	///* * IڂO̍ڂ폜AIڃCfNX炵܂B
	// *   ʓIɁA폜OƓڂIێ邱ƂɂȂ܂B
	// * * 폜OI𖳂ꍇ́A폜ɂĂI𖳂ێ܂B
	// *   ȉifɂāȀ(menu->sel!=-1)𖾎Kv͗L܂B
	// *   ȂȂAK(0<=i_item<=N-1)łA(-1<i_item)͐ȂłB
	// */
	//if(menu->sel > i_item) {
	//	menu->sel--;
	///* * ̍ڂIԂŁA̍ڂ폜ꍇAIڃCfNX炵܂B
	// *   Ō̈̍ڂIԂŁA폜ꍇAI𖳂ƂȂ܂B
	// *   ȏ̃P[X́Aȉ̈ifŏł܂B
	// * * Oq́AuIڂO̍ڂ폜AIڃCfNX炷ṽP[XƁA
	// *   {P[Xɔ邱Ƃ͗L܂B
	// *   ]āAȉif́AOifelseubNƂ܂B(elseubNɂȂĂʂ͓)
	// */
	//} else if(menu->sel == menu_num_items(menu)/*1Ă܂*/) {
	//	menu->sel--;
	//}
	//̓if̐ubN͓Ȃ̂ŁAȉ̂悤ɂ܂Ƃ߂܂B
	if(menu->sel > i_item ||
	   menu->sel == menu_num_items(menu)/*1Ă܂*/) {
		menu->sel--;
	}
}

void
menu_clear_items(MENU* menu)
{
	/* j[ڂׂĔj܂B */
	list_clear(menu->items);

	/* I𖳂ɖ߂܂B */
	menu->sel = -1;
}

int
menu_get_item(MENU* menu, int i_item, char* buf, int buflen)
{
	/* j[ڕ̕擾A𐔂܂B */
	char* str = list_get(menu->items, i_item); /* !! */
	int len = strlen(str);

	/* obt@L΁Aj[ڕi[܂B */
	if(buf && buflen) {
		strncpy(buf, str, buflen);
		if(len >= buflen) {
			buf[buflen - 1] = '\0';
		}
	}

	/* j[ڕ̕AԂ܂B */
	free(str); /* J!! */
	return len;
}

int
menu_num_items(MENU* menu)
{
	return list_size(menu->items);
}

int
menu_action(MENU* menu, int joy)
{
	int result = 0; /* p */
	//
	int n_items;
	int disp_rows;

	/* j[ڐ擾܂B */
	n_items = menu_num_items(menu);

	/* j[ڂ΁AIύXs܂B */
	if(!n_items) {
		if(menu->sel != -1) {
			DIE(); /* L蓾Ȃ */
		}

	/* j[ڂL... */
	} else {
		/* ILȂ΁Aʏ̑IύXs܂B */
		if(menu->sel >= 0) {
			disp_rows = calc_disp_rows(menu);
			if(joy & TRG_UP) menu->sel--;
			if(joy & TRG_DN) menu->sel++;
			if(joy & TRG_LF) menu->sel -= disp_rows;
			if(joy & TRG_RI) menu->sel += disp_rows;
			if(menu->sel < 0          ) menu->sel = 0;
			if(menu->sel > n_items - 1) menu->sel = n_items - 1;

		/* j[ڗLAAI𖳂ŁAI𑀍삪sꂽꍇ́A
		 * - I𖳂擪ڑI
		 * ܂́A
		 * - I𖳂ڑI
		 * ̏ԕωƂȂ܂BI𑀍삪΁AI𖳂̂܂܂łB
		 */
		} else {
			if(joy & (TRG_DN | TRG_RI)) menu->sel = 0;
			if(joy & (TRG_UP | TRG_LF)) menu->sel = n_items - 1;
		}
	}

	/* I𔻒肵܂B */
	if((joy & TRG_A) && (menu->sel != -1)) {
		result = 1; /*  */

	/* LZ𔻒肵܂B */
	} else if(joy & TRG_B) {
		menu->sel = -1;
		result = 1; /*  */
	}

	return result;
}

void
menu_disp(MENU* menu, RENDER* render)
{
	int x;
	int y;
	int w;
	int h;
	int font_h;
	int disp_rows;
	int n_items;
	int i_item;
	char* str;

	/* NbsÖޔ܂B */
	const int save_left   = render->left  ;
	const int save_top    = render->top   ;
	const int save_right  = render->right ;
	const int save_bottom = render->bottom;

	/* gƔwi`܂B
	 * ̕`ɂẮÃ݂NbsÖ悪KpAK؂ɃNbsO܂B
	 */
	x = menu->x;
	y = menu->y;
	w = menu->w;
	h = menu->h;
	if(w <= 0 || h <= 0) {
		goto L_EXIT;
	}
	render_rectangle(render, x, y, w, h, menu->palette.border); /* g */
	x += 1;
	y += 1;
	w -= 2;
	h -= 2;
	if(w <= 0 || h <= 0) {
		goto L_EXIT;
	}
	render_rectangle_fill(render, x, y, w, h, menu->palette.back); /* wi */

	/* ݂̃NbsÖƁAgj[̈̌̈߁AVȃNbsÖƂ܂B
	 * ^Cg⃁j[ڂ̕`悪Aj[g⃁j[̊Oɂ͂ݏoȂ悤ɂ邽߂̐ݒłB
	 */
	if(x     > render->left  ) render->left   = x;
	if(y     > render->top   ) render->top    = y;
	if(x + w < render->right ) render->right  = x + w;
	if(y + h < render->bottom) render->bottom = y + h;
	if(render->left >= render->right || render->top >= render->bottom) {
		goto L_EXIT;
	}

	/* tHgTCY擾܂B */
	font_h = font_h_tbl[menu->font];

	/* ^CgL΁A^Cg`܂B */
	str = menu->title;
	if(str) {
		render_rectangle_fill(render, x, y, w, font_h, menu->palette.border);
		render_string(render, x + 1, y, str, menu->font, menu->palette.title);
		y += font_h;
	}

	/* j[ڐ擾܂B */
	n_items = menu_num_items(menu);

	/* XN[ʒu𒲐܂B */
	if(menu->sel >= 0) { /* IL */
		disp_rows = calc_disp_rows(menu);
		if(menu->sel < menu->top                  ) menu->top = menu->sel;
		if(menu->sel > menu->top + (disp_rows - 1)) menu->top = menu->sel - (disp_rows - 1);
		/* XN[̍s߂␳B */
		if(menu->top > (n_items - disp_rows)) menu->top = (n_items - disp_rows); /* ɂȂ\܂ */
		if(menu->top < (                  0)) menu->top = (                  0); /* Ƀ[ɕ␳܂B */
	} else {             /* I𖳂 */
		menu->top = 0;
	}

	/* j[ڂ`܂B */
	i_item = menu->top;
	for(;;) {
		if(i_item > n_items - 1 ||
		   y >= render->bottom - 1/*g*/) {
			break;
		}
		str = list_get(menu->items, i_item); /* !! */
		if(i_item == menu->sel) {
			render_rectangle_fill(render, x, y, w, font_h + 1, menu->palette.item);
			render_string(render, x + 1, y + 1, str, menu->font, menu->palette.back);
		} else {
			//render_rectangle_fill(render, x, y, w, font_h + 1, menu->palette.back);
			render_string(render, x + 1, y + 1, str, menu->font, menu->palette.item);
		}
		free(str); /* J!! */
		y += font_h;
		i_item++;
	}

L_EXIT:
	/* NbsÖ𕜌܂B */
	render->left   = save_left  ;
	render->top    = save_top   ;
	render->right  = save_right ;
	render->bottom = save_bottom;
}
