/*	
 *	clipcbx.c
 *
 *	P/ECE VAMIDI Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue May 18 21:36:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	[J֐錾
 ****************************************************************************/

static int cbx_read(const unsigned char** ptr, int len);
static int cbx_init(const void* data);
static void cbx_tick();

/****************************************************************************
 *	[Jϐ錾
 ****************************************************************************/

static CBXDRIVER _driver; /* CBXhCo */

/****************************************************************************
 *	cbx_read
 ****************************************************************************/

static int
cbx_read(const unsigned char** ptr, int len)
{
	int value;
	int n;

	value = 0;
	if(len == 0) {
		/* ϒ */
		do {
			n = *(*ptr)++;
			value = (value << 7) | (n & 0x7f);
		} while(n & 0x80);
	} else {
		/* Œ蒷 */
		do {
			n = *(*ptr)++;
			value = (value << 8) | n;
		} while(--len);
	}

	return value;
}

/****************************************************************************
 *	cbx_init
 ****************************************************************************/

static int
cbx_init(const void* data)
{
	CBXDRIVER* driver = &_driver;
	const unsigned char* ptr = data;
	//
	int value;
	int i_track;
	CBXTRACK* track;

	/* ܂[NAB */
	memset(driver, 0, sizeof(CBXDRIVER));

	/*----- wb_`N -----*/

	/* `N^Cv܂B */
	if(memcmp(ptr, "MThd", 4) != 0) return -1;
	ptr += 4;

	/* f[^܂B */
	value = cbx_read(&ptr, 4);
	if(value != 6) return -1;

	/* tH[}bg܂B */
	value = cbx_read(&ptr, 2);
	if(value < 0 || 1 < value) return -1; /* tH[}bg2͖Ή */

	/* gbNi[܂B */
	driver->track_count = cbx_read(&ptr, 2);
	if(driver->track_count < 1) return -1;
	if(driver->track_count > CBXTRACKS) driver->track_count = CBXTRACKS; /* T|[gőgbNȍ~͖ */

	/* ԒPʂi[܂B */
	driver->time_unit = cbx_read(&ptr, 2);
	if(driver->time_unit & 0x8000) return -1; /* ΎԎw͖Ή */

	/*----- gbN`N -----*/

	for(i_track = 0; i_track < driver->track_count; i_track++) {
		track = &driver->track[i_track];

		/* `N^Cv܂B */
		if(memcmp(ptr, "MTrk", 4) != 0) return -1;
		ptr += 4;

		/* f[^擾܂B */
		value = cbx_read(&ptr, 4);

		/* tʒuݒ肵܂B */
		track->pos = ptr;
		ptr += value; /* ptr͎̃gbN`Nw */

		/* f^^Cݒ肵܂B */
		track->delta = cbx_read(&track->pos, 0);
	}

	/*----- lݒ -----*/

	driver->tempo = 60 * 1000 * 1000 / 120; /*  */

	return 0;
}

/****************************************************************************
 *	cbx_tick
 ****************************************************************************/

static void
cbx_tick()
{
	CBXDRIVER* driver = &_driver;
	//
	long long delta_step;     /* ԌvZ̓}CNbPʂȂ̂ŁAintł͑Ȃ */
	long long usec_per_delta; /* ԌvZ̓}CNbPʂȂ̂ŁAintł͑Ȃ */
	int i_track;
	int i_channel;
	int event;
	int data1;
	int data2;
	CBXTRACK* track;

	/* o߃f^^C߂܂B */
	driver->timer += 1000 * 1000 / CBX_TIMER_RATE;
	usec_per_delta = driver->tempo / driver->time_unit; /* Z덷͂قƂǋCɂȂȂ̂Ŗ */
	delta_step = driver->timer / usec_per_delta;
	driver->timer -= delta_step * usec_per_delta;

	for(i_track = 0; i_track < driver->track_count; i_track++) {
		track = &driver->track[i_track];
		if(!track->pos) continue; /* tgbN͔΂ */

		/* CxgB */
		track->delta -= delta_step;
		while(track->delta <= 0) {
			/* Cxgǂݍ݂܂B */
			event = cbx_read(&track->pos, 1);
			if(event & 0x80) {
				track->running_status = event;
			} else {
				event = track->running_status;
				track->pos--;
			}

			/* `l擾܂B */
			i_channel = event & 0xf;

			/* Cxg̎ނɂāc */
			switch(event >> 4) {
			case 0x8: /* m[gIt */
			case 0x9: /* m[gI */
			case 0xa: /* |tHjbNL[vbV[ */
			case 0xb: /* Rg[`FW */
			case 0xe: /* sb`xh`FW */
				data1 = cbx_read(&track->pos, 1);
				data2 = cbx_read(&track->pos, 1);
				com_send(&event, 1);
				com_send(&data1, 1);
				com_send(&data2, 1);
				break;
			case 0xc: /* vO`FW */
			case 0xd: /* `lvbV[ */
				data1 = cbx_read(&track->pos, 1);
				com_send(&event, 1);
				com_send(&data1, 1);
				break;
			case 0xf:
				switch(i_channel) {
				case 0x0: /* VXeGNXN[VubZ[W(I[) */
					com_send(&event, 1);
					data1 = cbx_read(&track->pos, 0); /* F0̎̃oCgI[F7܂ł̒B(I[F7܂) */
					if(!data1) DIE(); /* ȂƂ[J[IDKv */
					do {
						data2 = cbx_read(&track->pos, 1);
						com_send(&data2, 1);
					} while(--data1);
					if(data2 != 0xf7) DIE(); /* I[ */
					break;
				case 0x7: /* VXeGNXN[VubZ[W(I[Ȃ) ̎dl͊ԈėĂ邩? */
					com_send(&event, 1);
					data1 = cbx_read(&track->pos, 0); /* F7̎̃oCgI[܂ł̒ */
					if(!data1) DIE(); /* ȂƂ[J[IDKv */
					do {
						data2 = cbx_read(&track->pos, 1);
						com_send(&data2, 1);
					} while(--data1);
					break;
				case 0xf: /* ^Cxg */
					data1 = cbx_read(&track->pos, 1);
					data2 = cbx_read(&track->pos, 1);
					switch(data1) {
					case 0x2f: /* GhIugbN */
						if(data2 != 0) DIE();
						track->pos = NULL; /* t}[N */
						goto NEXT_TRACK;
						break;
					case 0x51: /* Zbge| */
						if(data2 != 3) DIE();
						driver->tempo = cbx_read(&track->pos, 3);
						break;
					/*{{Ή*/
					case 0x00: /* V[PXԍ */
					case 0x01: /* eLXg */
					case 0x02: /* 쌠\ */
					case 0x03: /* V[PX/gbN */
					case 0x04: /* y햼 */
					case 0x05: /* ̎ */
					case 0x06: /* }[J */
					case 0x07: /* L[|Cg */
					case 0x20: /* MIDI`lvtBbNX */
					//case 0x2f: /* GhIugbN */
					//case 0x51: /* Zbge| */
					case 0x54: /* SMPTEItZbg */
					case 0x58: /* q */
					case 0x59: /*  */
					case 0x7f: /* V[PTŗL̃^Cxg */
					default: /* (s) */
						track->pos += data2;
						break;
					}
					/*}}Ή*/
					break;
				default:
					DIE();
				}
				break;
			default:
				DIE();
			}

			/* ̃f^^Cݒ肵܂B */
			track->delta += cbx_read(&track->pos, 0);
		}
NEXT_TRACK:
	}
}

/****************************************************************************
 *	cbx_play
 ****************************************************************************/

int
cbx_play(const void* data)
{
	/* ܂mɒ~܂B */
	cbx_stop();

	/* CBXhCo܂B */
	if(cbx_init(data) != 0) return -1;

	/* VAʐM|[gJ܂B */
	com_open(CBX_BAUDRATE, CBX_PARITY, CBX_BYTESIZE, CBX_STOPBITS, 0, 0, NULL, NULL);

	/* tp^C}R[obNJn܂B */
	pceTimerSetCallback(CBX_TIMER_CH, PCE_TT_PERIODIC, 1000 / CBX_TIMER_RATE, cbx_tick);

	return 0;
}

/****************************************************************************
 *	cbx_stop
 ****************************************************************************/

void
cbx_stop()
{
	CBXDRIVER* driver = &_driver;

	/* mɃ^C}R[obN~܂B(ɒ~ĂĂSł) */
	pceTimerSetCallback(CBX_TIMER_CH, PCE_TT_NONE, 0, NULL);

	/* mɃVAʐM|[g܂B(ɕĂĂSł) */
	com_close();

	/* hCo\̂[NA܂B(driver->track_count=0:~}[N) */
	memset(driver, 0, sizeof(CBXDRIVER));
}

