/*	
 *	tixml.h
 *
 *	XML DOM parser
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sat Nov 25 20:20:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	- TinyXml version 1.2.4 QlɂāA쐬܂B
 *	  ȉɁAIWi TinyXml version 1.2.4  Copyright p܂B
 *	  ------------------------------------------------------------------------
 *	  Copyright (c) 2000 Lee Thomason (www.grinninglizard.com)
 *	  
 *	  This software is provided 'as-is', without any express or implied 
 *	  warranty. In no event will the authors be held liable for any 
 *	  damages arising from the use of this software.
 *	  
 *	  Permission is granted to anyone to use this software for any 
 *	  purpose, including commercial applications, and to alter it and 
 *	  redistribute it freely, subject to the following restrictions:
 *	  
 *	  1. The origin of this software must not be misrepresented; you must 
 *	  not claim that you wrote the original software. If you use this 
 *	  software in a product, an acknowledgment in the product documentation 
 *	  would be appreciated but is not required.
 *	  
 *	  2. Altered source versions must be plainly marked as such, and 
 *	  must not be misrepresented as being the original software.
 *	  
 *	  3. This notice may not be removed or altered from any source 
 *	  distribution.
 *	  ------------------------------------------------------------------------
 *	- {Iɂ́ATinyXml ̐݌v̂܂܂ŁAC++CɈڐAłB
 *	  AG[폜ċIɕύX铙A啝Ɋȗ܂B
 *	- TinyXml version 1.2.4 ͂Ȃ苌o[WȂ̂ŁA肪L܂B
 *	  VATinyXml version 2.5.2 ̃\[XQlACt͏C܂B
 *	* Sun Nov 26 18:00:19 JST 2006 Naoyuki Sawa
 *	- NXATiXmlStringStdStringɖOύX܂B
 *	  std::stringɁAŒKvȋ@\NXȂ̂ŁA̖O̕K؂łB
 *	- StdStrinǵAXMLɓĂȂ̂ŁAʂ̗prɗp邱Ƃł܂B
 *	  AۂɁAʂ̗prɗp邱ƂȂAʂ̃W[ֈڂm܂B
 *	* Mon Nov 27 00:38:25 JST 2006 Naoyuki Sawa
 *	- NXւ̃LXgs֐(TiXml???_super())Atixml.htixml.cֈڂ܂B
 *	  {W[łȂA{W[𗘗pR[hgƂƍlłB
 *	* Tue Dec 05 00:37:14 JST 2006 Naoyuki Sawa
 *	- StdStringNX\bh̃蓖ĉ񐔂炵A܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Thu Apr 21 21:50:44 JST 2016 Naoyuki Sawa
 *	- TiXmlNode_ToDocument(),TiXmlNode_ToElement(),TiXmlNode_ToComment(),TiXmlNode_ToUnknown(),TiXmlNode_ToText(),TiXmlNode_ToDeclaration()̈ɁANULL|C^wo悤ɂ܂B
 *	  ύXÓAȉ̂悤ɏKv:
 *	  TiXmlNode* node2 = TiXmlNode_FirstChild(node1, NULL);
 *	  if(node2) {
 *	    TiXmlText* text = TiXmlNode_ToText(node2);
 *	    if(text) {
 *	      ```eLXgm[hɑ΂鏈```
 *	    }
 *	  }
 *	  ύX́Aȉ̂悤ɊȌɏo悤ɂȂ܂:
 *	  TiXmlText* text = TiXmlNode_ToText(TiXmlNode_FirstChild(node1, NULL));
 *	  if(text) {
 *	      ```eLXgm[hɑ΂鏈```
 *	  }
 *	  ̕ύXɂÃAvP[V̏ւ̉ê͖ŁÃAvP[VCKv͗L܂B
 *	* Sun May 08 23:30:59 JST 2016 Naoyuki Sawa
 *	- XML̒'\x80'`'\xFF'̕LƐoĂȂC܂B
 *	  ̏Ĉ߂StdString_append_char()ǉ܂B
 *	- ܂Ŗ肪LŔAX̊֐̒ŕR[hintϐuStdString_append(This->value, (char*)&c);v̂悤ɂĈꕶǉ悤ƂĂ܂B
 *	  c[31:8]0ł鎖҂̂łAۂɂc'\x80'`'\xFF'c[31:8]1ɂȂāA2ȏ̕sȕƂĒǉĂ܂Ă܂B
 *	    肪NĂXML̗: <comp name="R| 1">
 *	                                         ~~~~~~~~ ̕1Âǉ悤ƂāAۂɂ͂ꂼ1ł͂ȂA2ȏ̕sȕǉĂ܂ĂB
 *	  ̏CɂāAStdString_append_char()Ăяo悤ɂāAIc[31:8]0ɃNA悤ɂȂ̂ŁAL̖͐ȂȂ܂B
 */
#ifndef __TIXML_H__
#define __TIXML_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _StdString StdString;

typedef struct _TiXmlBase TiXmlBase;
/**/typedef struct _TiXmlNode TiXmlNode;
/*@@*/typedef struct _TiXmlElement TiXmlElement;
/*@@*/typedef struct _TiXmlComment TiXmlComment;
/*@@*/typedef struct _TiXmlText TiXmlText;
/*@@*/typedef struct _TiXmlDeclaration TiXmlDeclaration;
/*@@*/typedef struct _TiXmlUnknown TiXmlUnknown;
/*@@*/typedef struct _TiXmlDocument TiXmlDocument;
/**/typedef struct _TiXmlAttribute TiXmlAttribute;
typedef struct _TiXmlAttributeSet TiXmlAttributeSet;

typedef struct _TiXmlBase_vtbl TiXmlBase_vtbl;
/**/typedef struct _TiXmlNode_vtbl TiXmlNode_vtbl;
/*@@*/typedef struct _TiXmlElement_vtbl TiXmlElement_vtbl;
/*@@*/typedef struct _TiXmlComment_vtbl TiXmlComment_vtbl;
/*@@*/typedef struct _TiXmlText_vtbl TiXmlText_vtbl;
/*@@*/typedef struct _TiXmlDeclaration_vtbl TiXmlDeclaration_vtbl;
/*@@*/typedef struct _TiXmlUnknown_vtbl TiXmlUnknown_vtbl;
/*@@*/typedef struct _TiXmlDocument_vtbl TiXmlDocument_vtbl;
/**/typedef struct _TiXmlAttribute_vtbl TiXmlAttribute_vtbl;
typedef struct _TiXmlAttributeSet_vtbl TiXmlAttributeSet_vtbl;

/* NXւ̃LXgs֐łB
 * - R[hɒڃLXgLqƁALXgɂoOÂ炢߁A
 *   NXւ̃LXgsꍇ́AKAȉ̊֐čsƂɂ܂B
 *   Ă΁ARpC^̕svoČx𔭂̂ŁAoO̔eՂłB
 */
static inline TiXmlBase* TiXmlNode_super       (TiXmlNode* This       ) { return (TiXmlBase*)This; }
static inline TiXmlNode* TiXmlElement_super    (TiXmlElement* This    ) { return (TiXmlNode*)This; }
static inline TiXmlNode* TiXmlComment_super    (TiXmlComment* This    ) { return (TiXmlNode*)This; }
static inline TiXmlNode* TiXmlText_super       (TiXmlText* This       ) { return (TiXmlNode*)This; }
static inline TiXmlNode* TiXmlDeclaration_super(TiXmlDeclaration* This) { return (TiXmlNode*)This; }
static inline TiXmlNode* TiXmlUnknown_super    (TiXmlUnknown* This    ) { return (TiXmlNode*)This; }
static inline TiXmlNode* TiXmlDocument_super   (TiXmlDocument* This   ) { return (TiXmlNode*)This; }
static inline TiXmlBase* TiXmlAttribute_super  (TiXmlAttribute* This  ) { return (TiXmlBase*)This; }

/****************************************************************************
 *	StdString
 ****************************************************************************/

/* ێ܂B
 */
struct _StdString {
	char* buf;	/* obt@ */
			/* I[o[wbhጸ̂߂ɁANULL͋󕶎("")Ӗ܂B */
			/* buf𒼐ڎQƂɁAStdString_c_str()oRŃANZXĂB */
};

StdString* StdString_new(const char* p/*=NULL*/);
void StdString_delete(StdString* This);
void _StdString_construct(StdString* This, const char* p/*=NULL*/);
void _StdString_destruct(StdString* This);
/*public:*/
const char* StdString_c_str(StdString* This);
void StdString_assign(StdString* This, const char* p/*=NULL*/);
void StdString_append(StdString* This, const char* p/*=NULL*/);
void StdString_append_char(StdString* This, int c/*'\0's*/);	//{{2016/05/08ǉ:XML̒'\x80'`'\xFF'̕LƐoĂȂC܂B̏Ĉ߂StdString_append_char()ǉ܂B}}

/****************************************************************************
 *	TiXmlBase
 ****************************************************************************/

/* XML DOM̒ۊNXłB
 */
struct _TiXmlBase {
	const TiXmlBase_vtbl* vptr;
	/*TiXmlBase*/
};

struct _TiXmlBase_vtbl {
	void (*destruct)(TiXmlBase* This);
	void (*Print)(TiXmlBase* This, FILE* fp, int depth); /*=0*/
	/*TiXmlBase_vtbl*/
};

//TiXmlBase* TiXmlBase_new(); hNX̂ݐ
void TiXmlBase_delete(TiXmlBase* This);
void _TiXmlBase_construct(TiXmlBase* This);
/*virtual*/ void _TiXmlBase_destruct(TiXmlBase* This);

/****************************************************************************
 *	TiXmlNode
 ****************************************************************************/

/* XMLm[h̒ۊNXłB
 */
struct _TiXmlNode /*:TiXmlBase*/ {
	const TiXmlNode_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* hNXɗprقȂ܂ */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
};

struct _TiXmlNode_vtbl /*:TiXmlBase_vtbl*/ {
	void (*destruct)(TiXmlNode* This);
	void (*Print)(TiXmlNode* This, FILE* fp, int depth); /*=0*/
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlNode* This); /*=0*/
	const char* (*Parse)(TiXmlNode* This, const char* p); /*=0*/
	/*TiXmlNode_vtbl*/
};

//TiXmlNode* TiXmlNode_new(); hNX̂ݐ
void TiXmlNode_delete(TiXmlNode* This);
void _TiXmlNode_construct(TiXmlNode* This);
/*virtual*/ void _TiXmlNode_destruct(TiXmlNode* This);
/*public:*/
const char* TiXmlNode_Value(TiXmlNode* This);
void TiXmlNode_SetValue(TiXmlNode* This, const char* value);
void TiXmlNode_Clear(TiXmlNode* This);
TiXmlNode* TiXmlNode_FirstChild(TiXmlNode* This, const char* value/*=NULL*/);
TiXmlNode* TiXmlNode_LastChild(TiXmlNode* This, const char* value/*=NULL*/);
TiXmlNode* TiXmlNode_IterateChildren(TiXmlNode* This, const char* value/*=NULL*/, TiXmlNode* previous);
void TiXmlNode_InsertEndChild(TiXmlNode* This, TiXmlNode* addThis);
void TiXmlNode_InsertBeforeChild(TiXmlNode* This, TiXmlNode* beforeThis, TiXmlNode* addThis);
void TiXmlNode_InsertAfterChild(TiXmlNode* This, TiXmlNode* afterThis, TiXmlNode* addThis);
void TiXmlNode_ReplaceChild(TiXmlNode* This, TiXmlNode* replaceThis, TiXmlNode* withThis);
void TiXmlNode_RemoveChild(TiXmlNode* This, TiXmlNode* removeThis);
TiXmlNode* TiXmlNode_NextSibling(TiXmlNode* This, const char* value/*=NULL*/);
TiXmlNode* TiXmlNode_PreviousSibling(TiXmlNode* This, const char* value/*=NULL*/);
TiXmlElement* TiXmlNode_NextSiblingElement(TiXmlNode* This, const char* value/*=NULL*/);
TiXmlElement* TiXmlNode_FirstChildElement(TiXmlNode* This, const char* value/*=NULL*/);
//{{2016/04/21ύX:TiXmlNode_ToDocument(),TiXmlNode_ToElement(),TiXmlNode_ToComment(),TiXmlNode_ToUnknown(),TiXmlNode_ToText(),TiXmlNode_ToDeclaration()̈ɁANULL|C^wo悤ɂ܂B
//TiXmlDocument   * TiXmlNode_ToDocument   (TiXmlNode* This);
//TiXmlElement    * TiXmlNode_ToElement    (TiXmlNode* This);
//TiXmlComment    * TiXmlNode_ToComment    (TiXmlNode* This);
//TiXmlUnknown    * TiXmlNode_ToUnknown    (TiXmlNode* This);
//TiXmlText       * TiXmlNode_ToText       (TiXmlNode* This);
//TiXmlDeclaration* TiXmlNode_ToDeclaration(TiXmlNode* This);
//2016/04/21ύX:TiXmlNode_ToDocument(),TiXmlNode_ToElement(),TiXmlNode_ToComment(),TiXmlNode_ToUnknown(),TiXmlNode_ToText(),TiXmlNode_ToDeclaration()̈ɁANULL|C^wo悤ɂ܂B
TiXmlDocument   * TiXmlNode_ToDocument   (TiXmlNode* This/*NULL*/);
TiXmlElement    * TiXmlNode_ToElement    (TiXmlNode* This/*NULL*/);
TiXmlComment    * TiXmlNode_ToComment    (TiXmlNode* This/*NULL*/);
TiXmlUnknown    * TiXmlNode_ToUnknown    (TiXmlNode* This/*NULL*/);
TiXmlText       * TiXmlNode_ToText       (TiXmlNode* This/*NULL*/);
TiXmlDeclaration* TiXmlNode_ToDeclaration(TiXmlNode* This/*NULL*/);
//}}2016/04/21ύX:TiXmlNode_ToDocument(),TiXmlNode_ToElement(),TiXmlNode_ToComment(),TiXmlNode_ToUnknown(),TiXmlNode_ToText(),TiXmlNode_ToDeclaration()̈ɁANULL|C^wo悤ɂ܂B

/****************************************************************************
 *	TiXmlElement
 ****************************************************************************/

/* vfm[h\܂B
 */
struct _TiXmlElement /*:TiXmlNode*/ {
	const TiXmlElement_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* vf */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	TiXmlAttributeSet* attributeSet;	/* Zbg */
	/*TiXmlElement*/
};

struct _TiXmlElement_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlElement* This);
	void (*Print)(TiXmlElement* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlElement* This);
	const char* (*Parse)(TiXmlElement* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlElement_vtbl*/
};

TiXmlElement* TiXmlElement_new(const char* value/*=NULL*/);
void TiXmlElement_delete(TiXmlElement* This);
void _TiXmlElement_construct(TiXmlElement* This, const char* value/*=NULL*/);
/*virtual*/ void _TiXmlElement_destruct(TiXmlElement* This);
/*public:*/
const char* TiXmlElement_Attribute(TiXmlElement* This, const char* name);
void TiXmlElement_SetAttribute(TiXmlElement* This, const char* name, const char* value);
void TiXmlElement_RemoveAttribute(TiXmlElement* This, const char* name);
TiXmlAttribute* TiXmlElement_FirstAttribute(TiXmlElement* This);
TiXmlAttribute* TiXmlElement_LastAttribute(TiXmlElement* This);
/*virtual*/ TiXmlNode* _TiXmlElement_Clone(TiXmlElement* This);
/*virtual*/ void _TiXmlElement_Print(TiXmlElement* This, FILE* fp, int depth);
/*protected:*/
/*virtual*/ const char* _TiXmlElement_Parse(TiXmlElement* This, const char* p);
const char* TiXmlElement_ReadValue(TiXmlElement* This, const char* p);

/****************************************************************************
 *	TiXmlComment
 ****************************************************************************/

/* Rgm[h\܂B
 */
struct _TiXmlComment /*:TiXmlNode*/ {
	const TiXmlComment_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* Rg̓e */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	/*TiXmlComment*/
};

struct _TiXmlComment_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlComment* This);
	void (*Print)(TiXmlComment* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlComment* This);
	const char* (*Parse)(TiXmlComment* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlComment_vtbl*/
};

TiXmlComment* TiXmlComment_new();
void TiXmlComment_delete(TiXmlComment* This);
void _TiXmlComment_construct(TiXmlComment* This);
/*virtual*/ void _TiXmlComment_destruct(TiXmlComment* This);
/*public:*/
/*virtual*/ TiXmlNode* _TiXmlComment_Clone(TiXmlComment* This);
/*virtual*/ void _TiXmlComment_Print(TiXmlComment* This, FILE* fp, int depth);
/*protected:*/
/*virtual*/ const char* _TiXmlComment_Parse(TiXmlComment* This, const char* p);

/****************************************************************************
 *	TiXmlText
 ****************************************************************************/

/* eLXgm[h\܂B
 */
struct _TiXmlText /*:TiXmlNode*/ {
	const TiXmlText_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* eLXg̓e */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	/*TiXmlText*/
};

struct _TiXmlText_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlText* This);
	void (*Print)(TiXmlText* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlText* This);
	const char* (*Parse)(TiXmlText* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlText_vtbl*/
};

TiXmlText* TiXmlText_new();
void TiXmlText_delete(TiXmlText* This);
void _TiXmlText_construct(TiXmlText* This);
/*virtual*/ void _TiXmlText_destruct(TiXmlText* This);
/*public:*/
/*virtual*/ TiXmlNode* _TiXmlText_Clone(TiXmlText* This);
/*virtual*/ void _TiXmlText_Print(TiXmlText* This, FILE* fp, int depth);
/*protected:*/
/*virtual*/ const char* _TiXmlText_Parse(TiXmlText* This, const char* p);

/****************************************************************************
 *	TiXmlDeclaration
 ****************************************************************************/

/* 錾m[h\܂B
 */
struct _TiXmlDeclaration /*:TiXmlNode*/ {
	const TiXmlDeclaration_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* (g܂) */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	StdString* version;		/* o[W(K{) */
	StdString* encoding;		/* GR[fBO(C) */
	StdString* standalone;	/* X^hA[(C) */
	/*TiXmlDeclaration*/
};

struct _TiXmlDeclaration_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlDeclaration* This);
	void (*Print)(TiXmlDeclaration* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlDeclaration* This);
	const char* (*Parse)(TiXmlDeclaration* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlDeclaration_vtbl*/
};

TiXmlDeclaration* TiXmlDeclaration_new(const char* version/*=NULL*/, const char* encoding/*=NULL*/, const char* standalone/*=NULL*/);
void TiXmlDeclaration_delete(TiXmlDeclaration* This);
void _TiXmlDeclaration_construct(TiXmlDeclaration* This, const char* version/*=NULL*/, const char* encoding/*=NULL*/, const char* standalone/*=NULL*/);
/*virtual*/ void _TiXmlDeclaration_destruct(TiXmlDeclaration* This);
/*public:*/
const char* TiXmlDeclaration_Version(TiXmlDeclaration* This);
const char* TiXmlDeclaration_Encoding(TiXmlDeclaration* This);
const char* TiXmlDeclaration_Standalone(TiXmlDeclaration* This);
/*virtual*/ TiXmlNode* _TiXmlDeclaration_Clone(TiXmlDeclaration* This);
/*virtual*/ void _TiXmlDeclaration_Print(TiXmlDeclaration* This, FILE* fp, int depth);
/*protected:*/
/*virtual*/ const char* _TiXmlDeclaration_Parse(TiXmlDeclaration* This, const char* p);

/****************************************************************************
 *	TiXmlUnknown
 ****************************************************************************/

/* sXMLm[h\܂B
 * - Ƃ΁u<!DOCTYPE`>vȂǂÃNX̃IuWFNgƂĈ܂B
 */
struct _TiXmlUnknown /*:TiXmlNode*/ {
	const TiXmlUnknown_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* Cӂ̓e */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	/*TiXmlUnknown*/
};

struct _TiXmlUnknown_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlUnknown* This);
	void (*Print)(TiXmlUnknown* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlUnknown* This);
	const char* (*Parse)(TiXmlUnknown* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlUnknown_vtbl*/
};

TiXmlUnknown* TiXmlUnknown_new();
void TiXmlUnknown_delete(TiXmlUnknown* This);
void _TiXmlUnknown_construct(TiXmlUnknown* This);
/*virtual*/ void _TiXmlUnknown_destruct(TiXmlUnknown* This);
/*public:*/
/*virtual*/ TiXmlNode* _TiXmlUnknown_Clone(TiXmlUnknown* This);
/*virtual*/ void _TiXmlUnknown_Print(TiXmlUnknown* This, FILE* fp, int depth);
/*protected:*/
/*virtual*/ const char* _TiXmlUnknown_Parse(TiXmlUnknown* This, const char* p);

/****************************************************************************
 *	TiXmlDocument
 ****************************************************************************/

/* XMLhLg\܂B
 */
struct _TiXmlDocument /*:TiXmlNode*/ {
	const TiXmlDocument_vtbl* vptr;
	/*TiXmlBase*/
	StdString* value;		/* t@C */
	TiXmlNode* firstChild;		/* 擪̎qm[hBȂNULL */
	TiXmlNode* lastChild;		/* ̎qm[hBȂNULL */
	TiXmlNode* prev;		/* ǑZm[hB擪ȂNULL */
	TiXmlNode* next;		/* ̌Zm[hBȂNULL */
	/*TiXmlNode*/
	/*TiXmlDocument*/
};

struct _TiXmlDocument_vtbl /*:TiXmlNode_vtbl*/ {
	void (*destruct)(TiXmlDocument* This);
	void (*Print)(TiXmlDocument* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	TiXmlNode* (*Clone)(TiXmlDocument* This);
	const char* (*Parse)(TiXmlDocument* This, const char* p);
	/*TiXmlNode_vtbl*/
	/*TiXmlDocument_vtbl*/
};

TiXmlDocument* TiXmlDocument_new(const char* documentName/*=NULL*/);
void TiXmlDocument_delete(TiXmlDocument* This);
void _TiXmlDocument_construct(TiXmlDocument* This, const char* documentName/*=NULL*/);
/*virtual*/ void _TiXmlDocument_destruct(TiXmlDocument* This);
/*public:*/
void TiXmlDocument_LoadFile(TiXmlDocument* This, const char* filename/*=NULL*/);
void TiXmlDocument_SaveFile(TiXmlDocument* This, const char* filename/*=NULL*/);
/*virtual*/ void _TiXmlDocument_Print(TiXmlDocument* This, FILE* fp, int depth);
/*virtual*/ TiXmlNode* _TiXmlDocument_Clone(TiXmlDocument* This);
/*virtual*/ const char* _TiXmlDocument_Parse(TiXmlDocument* This, const char* p);

/****************************************************************************
 *	TiXmlAttribute
 ****************************************************************************/

/* \܂B
 */
struct _TiXmlAttribute /*:TiXmlBase*/ {
	const TiXmlAttribute_vtbl* vptr;
	/*TiXmlBase*/
	StdString* name;		/*  */
	StdString* value;		/* l */
	TiXmlAttribute* prev;		/* ȎB擪ȂTiXmlAttributeSet.sentinelɃN */
	TiXmlAttribute* next;		/* ̑BȂTiXmlAttributeSet.sentinelɃN */
	/*TiXmlAttribute*/
};

struct _TiXmlAttribute_vtbl /*:TiXmlBase_vtbl*/ {
	void (*destruct)(TiXmlAttribute* This);
	void (*Print)(TiXmlAttribute* This, FILE* fp, int depth);
	/*TiXmlBase_vtbl*/
	/*TiXmlAttribute_vtbl*/
};

TiXmlAttribute* TiXmlAttribute_new(const char* name/*=NULL*/, const char* value/*=NULL*/);
void TiXmlAttribute_delete(TiXmlAttribute* This);
void _TiXmlAttribute_construct(TiXmlAttribute* This, const char* name/*=NULL*/, const char* value/*=NULL*/);
/*virtual*/ void _TiXmlAttribute_destruct(TiXmlAttribute* This);
/*public:*/
const char* TiXmlAttribute_Name(TiXmlAttribute* This);
const char* TiXmlAttribute_Value(TiXmlAttribute* This);
void TiXmlAttribute_SetName(TiXmlAttribute* This, const char* name);
void TiXmlAttribute_SetValue(TiXmlAttribute* This, const char* value);
TiXmlAttribute* TiXmlAttribute_Next(TiXmlAttribute* This);
TiXmlAttribute* TiXmlAttribute_Previous(TiXmlAttribute* This);
/*virtual*/ void _TiXmlAttribute_Print(TiXmlAttribute* This, FILE* fp, int depth);
const char* TiXmlAttribute_Parse(TiXmlAttribute* This, const char* p);

/****************************************************************************
 *	TiXmlAttributeSet
 ****************************************************************************/

/* ̃Zbgێ܂B
 */
struct _TiXmlAttributeSet {
	TiXmlAttribute* sentinel;	/* ̃Xgwb_̖BȂsentinelgɃN */
	/*TiXmlAttributeSet*/
};

TiXmlAttributeSet* TiXmlAttributeSet_new();
void TiXmlAttributeSet_delete(TiXmlAttributeSet* This);
void _TiXmlAttributeSet_construct(TiXmlAttributeSet* This);
void _TiXmlAttributeSet_destruct(TiXmlAttributeSet* This);
/*public:*/
void TiXmlAttributeSet_Add(TiXmlAttributeSet* This, TiXmlAttribute* addThis);
void TiXmlAttributeSet_Remove(TiXmlAttributeSet* This, TiXmlAttribute* removeThis);
TiXmlAttribute* TiXmlAttributeSet_First(TiXmlAttributeSet* This);
TiXmlAttribute* TiXmlAttributeSet_Last(TiXmlAttributeSet* This);
TiXmlAttribute* TiXmlAttributeSet_Find(TiXmlAttributeSet* This, const char* name);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__TIXML_H__*/
