
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.data
	.align	2
__drand48_data:
	.half	13070
	.half	43981
	.half	4660
	.space	14
; APP

		.code
		.align		1
__drand48_iterate:
		;//%r12 := xsubi
		;//%r13 := buffer
		add		%r13, 6				;//%r13      :=       buffer->a
		ld.uh		%r14, [%r13]+			;//%r14      := al  = buffer->a[0]
		ld.uh		%r9, [%r13]+			;//%r9       :=       buffer->a[1]
	sla	%r9,0x8		; 		xsla		%r9, 16				;//%r9       :=       buffer->a[1] << 16
	sla	%r9,0x8
		or		%r14, %r9			;//%r14      := al |= buffer->a[1] << 16
		ld.uh		%r15, [%r13]+			;//%r15      := ah  = buffer->a[2]
		ld.uh		%r6, [%r13]			;//%r6       := c   = buffer->c[0]
		ld.w		%r9, %r14			;//%r9       := al
		or		%r9, %r15			;//%r9       := al | ah
		or		%r9, %r6			;//%r9       := al | ah | c
		jrne.d		__drand48_iterate_L10		;//if(        !(al | ah | c)) {
		ld.w		%r7, %r12			;//%r7       := xsubi									*delay*
	ext	0x1bdd		; 		xld.w		%r14, 0xDEECE66D		;//  %r15:%r14 := ah:al = UINT64_C(0x5DEECE66D)
	ext	0x1399
	ld.w	%r14,0x2d
		ld.w		%r15, 0x5			;//
		ld.w		%r6,  0xB			;//  %r6       := c     = 0xB
__drand48_iterate_L10:						;//}
		ld.uh		%r10, [%r12]+			;//%r10      := xl  = xsubi[0]
		ld.uh		%r9, [%r12]+			;//%r9       :=       xsubi[1]
	sla	%r9,0x8		; 		xsla		%r9, 16				;//%r9       :=       xsubi[1] << 16
	sla	%r9,0x8
		or		%r10, %r9			;//%r10      := xl |= xsubi[1] << 16
		ld.uh		%r13, [%r12]			;//%r13      := xh  = xsubi[2]
	ext	__muldi3@rm	; 		xcall.d		__muldi3			;//%r11:%r10 := xh:xl *= ah:al	__muldi3%r4~%r7j󂵂Ȃframdi.sQƂ
	call.d	__muldi3@rl
		ld.w		%r12, %r10			;//%r12      :=    xl									*delay*
		add		%r10, %r6			;//%r11:%r10 := xh:xl += 0:c
		adc		%r11, %r8			;//
		ld.h		[%r7]+, %r10			;//xsubi[0]  := xl
	sra	%r10,0x8	; 		xsra		%r10, 16			;//%r10      := xl >> 16
	sra	%r10,0x8
		ld.h		[%r7]+, %r10			;//xsubi[1]  := xl >> 16
		ld.h		[%r7], %r11			;//xsubi[2]  := xh
		ret						;//


		.align		1
		.global		drand48
		.global		drand48_r
		.global		erand48
		.global		erand48_r
drand48:
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r12, __drand48_data		;//%r12      := &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r12,__drand48_data+0x0@l
		ld.w		%r13, %sp			;//%r13      :=                  &result
		call		drand48_r			;//drand48_r(   &__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r11:%r10 := result
	ld.w	%r11,[%sp+0x1]	; 		xld.w		%r11, [%sp+0x4]			;//
	add	%sp,0x2		; 		xadd		%sp, %sp, 8			;//
		ret						;//return       result
drand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14      :=                              result
		jp.d		erand48_r			;//%r10      := erand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13      :=                      buffer						*delay*
erand48:
		;//%r12 := xsubi
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13      :=     &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
		ld.w		%r14, %sp			;//%r14      :=                      &result
		call		erand48_r			;//erand48_r(xsubi, &__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r11:%r10 := result
	ld.w	%r11,[%sp+0x1]	; 		xld.w		%r11, [%sp+0x4]			;//
		ret						;//return       result
erand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		pushn		%r0
		ld.w		%r0, %r14			;//%r0       := result
	call.d	__drand48_iterate	; 		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
		ld.w		%r4, %r12			;//%r4       := xsubi									*delay*
		ld.uh		%r12, [%r4]+			;//%r12      := xl  = xsubi[0]
		ld.uh		%r9, [%r4]+			;//%r9       :=       xsubi[1]
		ld.uh		%r13, [%r4]			;//%r13      := xh  = xsubi[2]								*anti-interlock*
	sla	%r9,0x8		; 		xsla		%r9, 16				;//%r9       :=       xsubi[1] << 16
	sla	%r9,0x8
		or		%r12, %r9			;//%r12      := xl |= xsubi[1] << 16
		rl		%r13, 4				;//%r13      := xh  = 00000000 0000hhhh hhhhhhhh hhhh0000	
		rl		%r12, 4				;//%r12      := xl  = llllllll llllllll llllllll llllLLLL	
		xor		%r13, %r12			;//%r13      := xh  = llllllll llllXXXX XXXXXXXX XXXXLLLL	%r13:%r124ޯčĂøƯł
		and		%r12, -16			;//%r12      := xl  = llllllll llllllll llllllll llll0000	
		xor		%r13, %r12			;//%r13      := xh  = 00000000 0000hhhh hhhhhhhh hhhhLLLL	
		ld.w		%r14, 0				;//%r15:%r14 :=         1.0
	ext	0x7fe		; 		xld.w		%r15, 0x3FF00000		;//
	ext	0x0
	ld.w	%r15,0x0
	ext	__subdf3@rm	; 		xcall.d		__subdf3			;//%r11:%r10 := xh:xl - 1.0
	call.d	__subdf3@rl
		or		%r13, %r15			;//%r13      := 0eeeeeee eeeehhhh hhhhhhhh hhhhLLLL					*delay*
		ld.w		[%r0]+, %r10			;//*result   := xh:xl - 1.0
		ld.w		[%r0], %r11			;//
		popn		%r0				;//
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*


		.code
		.align		1
		.global		lrand48
		.global		lrand48_r
		.global		nrand48
		.global		nrand48_r
lrand48:
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r12, __drand48_data		;//%r12 :=   &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r12,__drand48_data+0x0@l
		ld.w		%r13, %sp			;//%r13 :=                    &result
		call		lrand48_r			;//lrand48_r(&__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r10 := result
	add	%sp,0x1		; 		xadd		%sp, %sp, 4			;//
		ret						;//return  result
lrand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14 :=                             result
		jp.d		nrand48_r			;//return nrand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13 :=                     buffer							*delay*
		;//---------------------------------------------;//
nrand48:
		;//%r12 := xsubi
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13 :=          &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
		ld.w		%r14, %sp			;//%r14 :=                           &result
		call		nrand48_r			;//nrand48_r(xsubi, &__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r10 := result
	add	%sp,0x1		; 		xadd		%sp, %sp, 4			;//
		ret						;//return  result
nrand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		ld.w		%r4, %r12			;//%r4  := xsubi
		ld.w		%r5, %r14			;//%r5  := result
	call.d	__drand48_iterate	; 		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
		add		%r4, 2				;//%r4  :=                     &xsubi[1]						*delay*
		ld.uh		%r9, [%r4]+			;//%r9  :=                      xsubi[1]
		ld.uh		%r4, [%r4]			;//%r4  :=    xsubi[2]
		sra		%r9, 1				;//%r9  :=                       xsubi[1] >> 1						*anti-interlock*
	sla	%r4,0x8		; 		xsla		%r4, 15				;//%r4  :=    xsubi[2] << 15
	sla	%r4,0x7
		or		%r4, %r9			;//%r4  :=   (xsubi[2] << 15) | (xsubi[1] >> 1)
		ld.w		[%r5], %r4			;//*result = (xsubi[2] << 15) | (xsubi[1] >> 1)
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*


		.code
		.align		1
		.global		mrand48
		.global		mrand48_r
		.global		jrand48
		.global		jrand48_r
mrand48:
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r12, __drand48_data		;//%r12 :=   &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r12,__drand48_data+0x0@l
		ld.w		%r13, %sp			;//%r13 :=                    &result
		call		mrand48_r			;//mrand48_r(&__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r10 := result
	add	%sp,0x1		; 		xadd		%sp, %sp, 4			;//
		ret						;//return  result
mrand48_r:
		;//%r12 := buffer
		;//%r13 := result
		ld.w		%r14, %r13			;//%r14 :=                             result
		jp.d		jrand48_r			;//return jrand48_r(buffer->x, buffer, result)
		ld.w		%r13, %r12			;//%r13 :=                     buffer							*delay*
		;//---------------------------------------------;//
jrand48:
		;//%r12 := xsubi
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4			;//
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13 :=          &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
		ld.w		%r14, %sp			;//%r14 :=                           &result
		call		jrand48_r			;//jrand48_r(xsubi, &__drand48_data, &result)
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp+0x0]			;//%r10 := result
	add	%sp,0x1		; 		xadd		%sp, %sp, 4			;//
		ret						;//return  result
jrand48_r:
		;//%r12 := xsubi
		;//%r13 := buffer
		;//%r14 := result
		ld.w		%r4, %r12			;//%r4  := xsubi
		ld.w		%r5, %r14			;//%r5  := result
	ext	__drand48_iterate@rm	; 		xcall.d		__drand48_iterate		;//__drand48_iterate(xsubi, buffer)	__drand48_iterate%r4~%r5j󂵂Ȃ
	call.d	__drand48_iterate@rl
		add		%r4, 2				;//%r4  :=                     &xsubi[1]						*delay*
		ld.uh		%r9, [%r4]+			;//%r9  :=                      xsubi[1]
		ld.uh		%r4, [%r4]			;//%r4  :=    xsubi[2]
	sla	%r4,0x8		; 		xsla		%r4, 16				;//%r4  :=    xsubi[2] << 16								!INTERLOCK!
	sla	%r4,0x8
		or		%r4, %r9			;//%r4  :=   (xsubi[2] << 16) | xsubi[1]
		ld.w		[%r5], %r4			;//*result = (xsubi[2] << 16) | xsubi[1]
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*


		.code
		.align		1
		.global		srand48
		.global		srand48_r
		.global		seed48
		.global		seed48_r
		.global		lcong48
		.global		lcong48_r
srand48:
		;//%r12 := seedval
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13 := &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
srand48_r:
		;//%r12 := seedval
		;//%r13 := buffer
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8			;//
	ext	0xcc		; 		xld.w		%r9, 0x330E			;//%r9        := 0x330E
	ld.w	%r9,0xe
	ld.h	[%sp+0x0],%r9	; 		xld.h		[%sp+0x0], %r9			;//seed16v[0] := 0x330E
	ld.h	[%sp+0x1],%r12	; 		xld.h		[%sp+0x2], %r12			;//seed16v[1] := seedval
	sra	%r12,0x8	; 		xsra		%r12, 16			;//%r12       := seedval >>= 16
	sra	%r12,0x8
	ld.h	[%sp+0x2],%r12	; 		xld.h		[%sp+0x4], %r12			;//seed16v[2] := seedval
		ld.w		%r12, %sp			;//%r12       :=          seed16v
		call		seed48_r			;//%r10       := seed48_r(seed16v, buffer)
	add	%sp,0x2		; 		xadd		%sp, %sp, 8			;//
		ret						;//return        seed48_r(seed16v, buffer)
		;//---------------------------------------------;//
seed48:
		;//%r12 := seed16v
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13 :=           &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
		call		seed48_r			;//seed48_r(seed16v, &__drand48_data)
	ext	__drand48_data+0xe@h	; 		xld.w		%r10, __drand48_data+0xe		;//%r10 := __drand48_data.old_x
	ext	__drand48_data+0xe@m
	ld.w	%r10,__drand48_data+0xe@l
		ret						;//return  __drand48_data.old_x
seed48_r:
		;//%r12 := seed16v
		;//%r13 := buffer
		pushn		%r1				;//
		ld.w		%r0, %r12			;//%r0  := seed16v
		ld.w		%r1, %r13			;//%r1  :=                buffer->x
	ext	0xe		; 		xadd		%r12, %r1, 14			;//%r12 := buffer->old_x
	add	%r12,%r1
	ext	memcpy@rm	; 		xcall.d		memcpy				;//memcpy( buffer->old_x, buffer->x, sizeof buffer->x)
	call.d	memcpy@rl
		ld.w		%r14, 6				;//%r14 :=                           sizeof buffer->x					*delay*
		ld.w		%r12, %r1			;//%r12 := buffer->x
		ld.w		%r13, %r0			;//%r13 :=            seed16v
	ext	memcpy@rm	; 		xcall.d		memcpy				;//memcpy( buffer->x, seed16v, sizeof buffer->x)
	call.d	memcpy@rl
		ld.w		%r14, 6				;//%r14 :=                     sizeof buffer->x						*delay*
	ext	0x6		; 		xadd		%r12, %r1, 6			;//%r12 := buffer->a
	add	%r12,%r1
		ld.w		%r13, 0				;//%r13 :=            0
	ext	memset@rm	; 		xcall.d		memset				;//memset( buffer->a, 0, sizeof buffer->a + sizeof buffer->c)
	call.d	memset@rl
		ld.w		%r14, 8				;//%r14 :=               sizeof buffer->a + sizeof buffer->c				*delay*
		popn		%r1				;//
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*
		;//---------------------------------------------;//
lcong48:
		;//%r12 := param
	ext	__drand48_data+0x0@h	; 		xld.w		%r13, __drand48_data		;//%r13 := &__drand48_data
	ext	__drand48_data+0x0@m
	ld.w	%r13,__drand48_data+0x0@l
lcong48_r:
		;//%r12 := param
		;//%r13 := buffer
		xor		%r12, %r13			;//%r12 := param ^ buffer
		xor		%r13, %r12			;//%r13 := param
		xor		%r12, %r13			;//%r12 := buffer
	ext	memcpy@rm	; 		xcall.d		memcpy				;//memcpy(buffer->x, param, sizeof buffer->x + sizeof buffer->a + sizeof buffer->c)
	call.d	memcpy@rl
		ld.w		%r14, 14			;//%r14 :=                  sizeof buffer->x + sizeof buffer->a + sizeof buffer->c	*delay*
		ret.d						;//return  0
		ld.w		%r10, 0				;//%r10 := 0										*delay*

