/*
 *	gstring.h
 *
 *	Strings - text buffers which grow automatically as text is added
 *
 *	* Tue May 24 23:59:14 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibStrings(http://developer.gnome.org/glib/stable/glib-Strings.html)Qlɂ܂B
 *	  ֐dl̓IWiłƓłA͓ƎŁAxeʍ팸D悵܂B
 *	- IWiłgstring.cW[PƂŎĂ܂Ałgarray.cW[𗘗pĎ܂B
 *	  GString̋@\GArray̋@\ɋ߂̂ŁAGArraygpĎƁAVKR[h쐬̎ԂȂ邩łB
 *	* Wed May 25 10:22:02 JST 2016 Naoyuki Sawa
 *	- GString.allocated_lentB[hɂāAӏǋL܂B
 */
#ifndef __G_STRING_H__
#define __G_STRING_H__
#ifdef	__cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	\
 *****************************************************************************/
typedef struct _GString {
	char*		str;			//Points to the character data. It may move as text is added. The str field is null-terminated and so can be used as an ordinary C string.	 GRealArray.data
	int		len;			//Contains the length of the string, not including the terminating nul byte.									 GRealArray.len
/*!!*/	int		allocated_len;		//The number of bytes that can be stored in the string before it needs to be reallocated. May be larger than len.				 GRealArray.alloc_bytes
} GString;
// * Wed May 25 10:22:02 JST 2016 Naoyuki Sawa
// - GString.allocated_lentB[hɂāAӏǋL܂B
// - allocated_len͎vCx[gtB[hłAAvP[VڎQƂĂ͂܂B
//   'str[len]`str[allocated_len-1]͈̔͂ɁAAvP[VځAǉ̕i[ėǂ'ƂӖ *ł͂Ȃ* ɒӂĉB
//   2016/05/25݁AGString̎GArray'zero_terminated=1'̐ݒŎgpĂAL͈̔͂ɃAvP[VځAǉ̕i[ƁAGArray0Ƒz肵Ăӏj󂵂Ă܂\L܂B
// - 'AvP[VځAǉ̕i[ėǂ̈m'ɂ́Ag_string_set_size()ĂяoKvLÃTCYallocated_lenł͂Ȃlenɔf܂B
//   ƂāAMFCCString::GetBuffer()/CString::ReleaseBuffer()Ɠl̏sꍇɂāAallocated_lenɈˑԈ@ƁAallocated_lenɈˑȂ@܂B
//   allocated_lenɈˑԈ@
//   GString* s = g_string_sized_new(100);	//len=0,allocated_len>=100																						
//   strcpy(s->str, "foo");			//s->str[1],s->str[2]0ȊOɂȂ鎖GArrayz肵Ă炸AȌ̏ŃkI[KvɂȂɂ̈ʒuɉ߂0i[Ƃ͌ȂBR삷\L邪A삵Ȃ\LB	BAallocated_len𖾎Iɐݒ肷@g_string_sized_new()lĂAallocated_lenɈˑ̂͌ł鎖͗eՂɑzt낤B(쐬ς݂̕ɑ΂ăTCYw肵GetBuffer()oȂƂɂȂĂ܂)
//   s = g_string_assign(s, s->str);		//len=3,allocated_len>=100																						
//   allocated_lenɈˑȂ@
//   GString* s = g_string_sized_new(NULL);	//len=0,allocated_len=?
//   g_string_set_size(s, 100);		//len=100,allocated_len>=100	CString::GetBuffer(100)ɑB	
//   strcpy(s->str, "foo");			//									B
//   s = g_string_assign(s, s->str);		//len=3,allocated_len>=100	CString::ReleaseBuffer(-1)ɑB	
// - L̗RɂAallocated_lenAvP[VڎQƂĂ͂܂B
//   ɂ炸Aallocated_lenAAvP[V猩GString\̓ɒ`́AIWiłƂRłB
//   ł́AGArraygGStringĂ܂AIWiłGStringPƂŎĂ̂ŁAŎgpallocated_lenGStringɒ`Ă̂Ǝv܂B
//   GArraŷ悤ɁAJ\̂ƔJ̍\̂ɕ@L܂AGStringł̓vCx[gtB[hallocated_lenȂ̂ŁAĂȂ̂Ǝv܂B
//   ł́AGString\̓allocated_len`ɁAvCx[gtB[hƂĂǂ̂łAꉞAIWiłɕČJĂɂ܂B
//   GArraỹvCx[gtB[h(GRealArray.alloc_bytes)JĂ`ƂȂ܂B
//   ۂɃAvP[VQƂ鎖́A܂AƎv܂B
//   ǂ납Agstring.cW[̏QƂĂ܂B
//   ̎ۂ̏́AقƂǑSGArraẙ֐ĂяołAGString.allocated_len(=GRealArray.alloc_bytes)GArraẙ֐łQƂȂłB
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
GString* g_string_new(const char* init);
GString* g_string_new_len(const char* init, int len);
GString* g_string_sized_new(int dfl_size);
GString* g_string_assign(GString* string, const char* rval);
void g_string_vprintf(GString* string, const char* format, va_list args);
void g_string_append_vprintf(GString* string, const char* format, va_list args);
void g_string_printf(GString* string, const char* format, ...);
void g_string_append_printf(GString* string, const char* format, ...);
GString* g_string_append(GString* string, const char* val);
GString* g_string_append_c(GString* string, char c);
//GString* g_string_append_unichar(GString* string, wchar_t wc);		//Ή
GString* g_string_append_len(GString* string, const char* val, int len);
//GString* g_string_append_uri_escaped(GString* string, const char* unescaped, const char* reserved_chars_allowed, int allow_utf8);	//Ή
GString* g_string_prepend(GString* string, const char* val);
GString* g_string_prepend_c(GString* string, char c);
//GString* g_string_prepend_unichar(GString* string, wchar_t wc);		//Ή
GString* g_string_prepend_len(GString* string, const char* val, int len);
GString* g_string_insert(GString* string, int pos, const char* val);
GString* g_string_insert_c(GString* string, int pos, char c);
//GString* g_string_insert_unichar(GString* string, int pos, wchar_t wc);	//Ή
GString* g_string_insert_len(GString* string, int pos, const char* val, int len);
GString* g_string_overwrite(GString* string, int pos, const char* val);
GString* g_string_overwrite_len(GString* string, int pos, const char* val, int len);
GString* g_string_erase(GString* string, int pos, int len);
GString* g_string_truncate(GString* string, int len);
GString* g_string_set_size(GString* string, int len);
char* g_string_free(GString* string, int free_segment);
//GBytes* g_string_free_to_bytes(GString* string);				//Ή
int g_string_hash(const GString* str);
int g_string_equal(const GString* v, const GString* v2);
//GString* g_string_ascii_down(GString* string);				//Ή
//GString* g_string_ascii_up(GString* string);					//Ή
#ifdef	__cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__G_STRING_H__
