/*
 *	gslist.h
 *
 *	Singly-Linked Lists - linked lists that can be iterated in one direction
 *
 *	* Wed Jul 27 21:35:30 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibSingly-Linked Lists(https://developer.gnome.org/glib/stable/glib-Singly-Linked-Lists.html)Qlɂ܂B
 *	  ֐dl̓IWiłƓłA͑ύXāAxeʍ팸D悵܂B
 *	- ۂ̃AvP[Vł́AϋɓIGSListg͏ȂƎv܂B
 *	  GArrayGTreeght_hash_tablegAxIɂgՂIɂDĂ邩łB
 *	  GSListDĂ_́ÃXgNULLŕ\鎖oāAsvł鎖炢Ǝv܂B
 */
#ifndef __G_SLIST_H__
#define __G_SLIST_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	GSList
 *****************************************************************************/
/*****************************************************************************
 *	\
 *****************************************************************************/
typedef struct _GSList {
	void*			data;		//Holds the element's data, which can be a pointer to any kind of data, or any integer value using the Type Conversion Macros.
	struct _GSList*		next;		//Contains the link to the next element in the list.
} GSList;
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
GSList* g_slist_alloc();
GSList* g_slist_append(GSList* list/*NULL*/, void* data);
GSList* g_slist_prepend(GSList* list/*NULL*/, void* data);
GSList* g_slist_insert(GSList* list/*NULL*/, void* data, int position);
GSList* g_slist_insert_before(GSList* slist/*NULL*/, GSList* sibling/*NULL*/, void* data);
GSList* g_slist_insert_sorted(GSList* list/*NULL*/, void* data, int (*compare_func)(const void* a, const void* b));
GSList* g_slist_insert_sorted_with_data(GSList* list/*NULL*/, void* data, int (*compare_func)(const void* a, const void* b, void* user_data), void* user_data);
GSList* g_slist_remove(GSList* list/*NULL*/, const void* data);	//
GSList* g_slist_remove_all(GSList* list/*NULL*/, const void* data);	//Ӂ֐ɑΏ̐Bg_slist_remove()g_slist_remove_all()̓m[h폜邪Ag_slist_remove_link()̓m[h폜Ag_slist_delete_link()m[h폜B
GSList* g_slist_remove_link(GSList* list/*NULL*/, GSList* link_);	//
GSList* g_slist_delete_link(GSList* list/*NULL*/, GSList* link_);	//			//'link'ł͂Ȃ'link_'ƂŔAIWił̎ɕłBAIWił̎ł́Aʂ̃W[ƖOՓ˂Ă̂Ǝv܂Bł'link'łvȂ̂łAIWił̎ɕ'link_'̂܂܂ɂ鎖ɂ܂B
void g_slist_free(GSList* list/*NULL*/);
void g_slist_free_full(GSList* list/*NULL*/, void (*free_func_/*NULL*/)(void* data));	//'free_func'ł͂Ȃ'free_func_'ƂŔAzlib/zlib.htypedefƏՓ˂āAgcc33.exeł̓RpCG[ɂȂłBf[^^̉typedefƏՓ˂ĂvȂ̂łA֐^̉typedefƏՓ˂ƃG[ɂȂ悤łB(v)
void g_slist_free_1(GSList* list/*NULL*/);
/*---------------------------------------------------------------------------*/
//A macro which does the same as g_slist_free_1().
#define g_slist_free1(list) g_slist_free_1(list)
/*---------------------------------------------------------------------------*/
int g_slist_length(GSList* list/*NULL*/);
GSList* g_slist_copy(GSList* list/*NULL*/);
GSList* g_slist_copy_deep(GSList* list/*NULL*/, void* (*copy_func/*NULL*/)(const void* data, void* user_data), void* user_data);
GSList* g_slist_reverse(GSList* list/*NULL*/);
GSList* g_slist_sort(GSList* list/*NULL*/, int (*compare_func)(const void* a, const void* b));
GSList* g_slist_sort_with_data(GSList* list/*NULL*/, int (*compare_func)(const void* a, const void* b, void* user_data), void* user_data);
GSList* g_slist_concat(GSList* list1/*NULL*/, GSList* list2/*NULL*/);
void g_slist_foreach(GSList* list/*NULL*/, void (*func)(void* data, void* user_data), void* user_data);
GSList* g_slist_last(GSList* list/*NULL*/);
/*---------------------------------------------------------------------------*/
//A convenience macro to get the next element in a GSList.
//Parameters
//		slist		An element in a GSList.
//Returns
//		The next element, or NULL if there are no more elements.
#define g_slist_next(slist) ((slist)?(slist)->next:NULL)
/*---------------------------------------------------------------------------*/
GSList* g_slist_nth(GSList* list/*NULL*/, int n);
void* g_slist_nth_data(GSList* list/*NULL*/, int n);
GSList* g_slist_find(GSList* list/*NULL*/, const void* data);
GSList* g_slist_find_custom(GSList* list/*NULL*/, const void* data, int (*compare_func)(const void* a, const void* b));
int g_slist_position(GSList* list/*NULL*/, GSList* llink/*NULL*/);
int g_slist_index(GSList* list/*NULL*/, const void* data);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__G_STRING_H__
